package engine

import (
	"context"
	"github.com/ethereum/go-ethereum/common"
	"github.com/ethereum/go-ethereum/core/types"
	"github.com/exchain/go-exchain/exchain"
	"github.com/exchain/go-exchain/exchain/chaindb"
	nebulav1 "github.com/exchain/go-exchain/exchain/protocol/gen/go/nebula/v1"
	"github.com/exchain/go-exchain/op-node/p2p"
	"github.com/exchain/go-exchain/op-node/rollup/driver"
	"github.com/exchain/go-exchain/op-node/rollup/sync"
	"github.com/exchain/go-exchain/op-service/eth"
	"math/big"
)

type ExChainAPI struct {
	chain chaindb.ChainDB
}

func (e *ExChainAPI) BlockRefByNumber(ctx context.Context, num uint64) (eth.BlockRef, error) {
	//TODO implement me
	panic("implement me")
}

func (e *ExChainAPI) FetchReceipts(ctx context.Context, blockHash common.Hash) (eth.BlockInfo, types.Receipts, error) {
	//TODO implement me
	panic("implement me")
}

func (e *ExChainAPI) OutputV0AtBlock(ctx context.Context, blockHash common.Hash) (*eth.OutputV0, error) {
	//TODO implement me
	panic("implement me")
}

func (e *ExChainAPI) ChainID(ctx context.Context) (*big.Int, error) {
	//TODO implement me
	panic("implement me")
}

func (e *ExChainAPI) NewPayload(params exchain.PayloadParams) (exchain.ExecutionResult, error) {
	//TODO implement me
	panic("implement me")
}

func (e *ExChainAPI) ProcessPayload(block *nebulav1.Block) error {
	//TODO implement me
	panic("implement me")
}

func (e *ExChainAPI) PayloadByNumber(ctx context.Context, u uint64) (*eth.ExecutionPayloadEnvelope, error) {
	//TODO implement me
	panic("implement me")
}

func (e *ExChainAPI) L2BlockRefByLabel(ctx context.Context, label eth.BlockLabel) (eth.L2BlockRef, error) {
	//TODO implement me
	panic("implement me")
}

func (e *ExChainAPI) L2BlockRefByHash(ctx context.Context, l2Hash common.Hash) (eth.L2BlockRef, error) {
	//TODO implement me
	panic("implement me")
}

func (e *ExChainAPI) L2BlockRefByNumber(ctx context.Context, num uint64) (eth.L2BlockRef, error) {
	//TODO implement me
	panic("implement me")
}

func (e *ExChainAPI) SystemConfigByL2Hash(ctx context.Context, hash common.Hash) (eth.SystemConfig, error) {
	//TODO implement me
	panic("implement me")
}

func (e *ExChainAPI) Close() {
}

var (
	_ p2p.L2Chain    = (*ExChainAPI)(nil)
	_ sync.L2Chain   = (*ExChainAPI)(nil)
	_ driver.L2Chain = (*ExChainAPI)(nil)
)

func NewEngineAPI(database chaindb.ChainDB) *ExChainAPI {
	return &ExChainAPI{
		chain: database,
	}
}
