package opcm

import (
	"math/big"
	"testing"

	"github.com/ethereum/go-ethereum/common"
	"github.com/stretchr/testify/require"
)

func TestEncodeStartingAnchorRoots(t *testing.T) {
	encoded, err := EncodeStartingAnchorRoot(DefaultStartingAnchorRoot)
	require.NoError(t, err)
	require.EqualValues(t, PermissionedGameStartingAnchorRoot, encoded)

	encoded, err = EncodeStartingAnchorRoot(StartingAnchorRoot{
		Root:          common.Hash{0xde, 0xad, 0xbe, 0xef},
		L2BlockNumber: big.NewInt(9),
	})
	require.NoError(t, err)
	require.EqualValues(t,
		[]byte{
			0xde, 0xad, 0xbe, 0xef, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
			0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
			0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
			0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x09,
		},
		encoded,
	)
}
