import {
  useNetwork,
  useChainId,
  useContractRead,
  UseContractReadConfig,
  useContractWrite,
  Address,
  UseContractWriteConfig,
  usePrepareContractWrite,
  UsePrepareContractWriteConfig,
  useContractEvent,
  UseContractEventConfig,
} from 'wagmi'
import {
  ReadContractResult,
  WriteContractMode,
  PrepareWriteContractResult,
} from 'wagmi/actions'

/* eslint-disable */

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// AddressManager
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdE1FCfB0851916CA5101820A69b13a4E276bd81F)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xa6f73589243a6A7a9023b1Fa0651b1d89c177111)
 */
export const addressManagerABI = [
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: '_name', internalType: 'string', type: 'string', indexed: true },
      {
        name: '_newAddress',
        internalType: 'address',
        type: 'address',
        indexed: false,
      },
      {
        name: '_oldAddress',
        internalType: 'address',
        type: 'address',
        indexed: false,
      },
    ],
    name: 'AddressSet',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'previousOwner',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'newOwner',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
    ],
    name: 'OwnershipTransferred',
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '_name', internalType: 'string', type: 'string' }],
    name: 'getAddress',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'owner',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'renounceOwnership',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_name', internalType: 'string', type: 'string' },
      { name: '_address', internalType: 'address', type: 'address' },
    ],
    name: 'setAddress',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: 'newOwner', internalType: 'address', type: 'address' }],
    name: 'transferOwnership',
    outputs: [],
  },
] as const

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdE1FCfB0851916CA5101820A69b13a4E276bd81F)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xa6f73589243a6A7a9023b1Fa0651b1d89c177111)
 */
export const addressManagerAddress = {
  1: '0xdE1FCfB0851916CA5101820A69b13a4E276bd81F',
  5: '0xa6f73589243a6A7a9023b1Fa0651b1d89c177111',
} as const

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdE1FCfB0851916CA5101820A69b13a4E276bd81F)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xa6f73589243a6A7a9023b1Fa0651b1d89c177111)
 */
export const addressManagerConfig = {
  address: addressManagerAddress,
  abi: addressManagerABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// AssetReceiver
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 */
export const assetReceiverABI = [
  {
    stateMutability: 'nonpayable',
    type: 'constructor',
    inputs: [{ name: '_owner', internalType: 'address', type: 'address' }],
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'user', internalType: 'address', type: 'address', indexed: true },
      {
        name: 'newOwner',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
    ],
    name: 'OwnerUpdated',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
    ],
    name: 'ReceivedETH',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'withdrawer',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'recipient',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'asset',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
    ],
    name: 'WithdrewERC20',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'withdrawer',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'recipient',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'asset',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      { name: 'id', internalType: 'uint256', type: 'uint256', indexed: false },
    ],
    name: 'WithdrewERC721',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'withdrawer',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'recipient',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
    ],
    name: 'WithdrewETH',
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_target', internalType: 'address', type: 'address' },
      { name: '_data', internalType: 'bytes', type: 'bytes' },
      { name: '_gas', internalType: 'uint256', type: 'uint256' },
      { name: '_value', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'CALL',
    outputs: [
      { name: '', internalType: 'bool', type: 'bool' },
      { name: '', internalType: 'bytes', type: 'bytes' },
    ],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_target', internalType: 'address', type: 'address' },
      { name: '_data', internalType: 'bytes', type: 'bytes' },
      { name: '_gas', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'DELEGATECALL',
    outputs: [
      { name: '', internalType: 'bool', type: 'bool' },
      { name: '', internalType: 'bytes', type: 'bytes' },
    ],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'owner',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: 'newOwner', internalType: 'address', type: 'address' }],
    name: 'setOwner',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_asset', internalType: 'contract ERC20', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'withdrawERC20',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_asset', internalType: 'contract ERC20', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
    ],
    name: 'withdrawERC20',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_asset', internalType: 'contract ERC721', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_id', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'withdrawERC721',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_to', internalType: 'address payable', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'withdrawETH',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: '_to', internalType: 'address payable', type: 'address' }],
    name: 'withdrawETH',
    outputs: [],
  },
  { stateMutability: 'payable', type: 'receive' },
] as const

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 */
export const assetReceiverAddress = {
  1: '0x15DdA60616Ffca20371ED1659dBB78E888f65556',
  10: '0x15DdA60616Ffca20371ED1659dBB78E888f65556',
} as const

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 */
export const assetReceiverConfig = {
  address: assetReceiverAddress,
  abi: assetReceiverABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// AttestationStation
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0xEE36eaaD94d1Cc1d0eccaDb55C38bFfB6Be06C77)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0xEE36eaaD94d1Cc1d0eccaDb55C38bFfB6Be06C77)
 */
export const attestationStationABI = [
  { stateMutability: 'nonpayable', type: 'constructor', inputs: [] },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'creator',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'about',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      { name: 'key', internalType: 'bytes32', type: 'bytes32', indexed: true },
      { name: 'val', internalType: 'bytes', type: 'bytes', indexed: false },
    ],
    name: 'AttestationCreated',
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      {
        name: '_attestations',
        internalType: 'struct AttestationStation.AttestationData[]',
        type: 'tuple[]',
        components: [
          { name: 'about', internalType: 'address', type: 'address' },
          { name: 'key', internalType: 'bytes32', type: 'bytes32' },
          { name: 'val', internalType: 'bytes', type: 'bytes' },
        ],
      },
    ],
    name: 'attest',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_about', internalType: 'address', type: 'address' },
      { name: '_key', internalType: 'bytes32', type: 'bytes32' },
      { name: '_val', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'attest',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [
      { name: '', internalType: 'address', type: 'address' },
      { name: '', internalType: 'address', type: 'address' },
      { name: '', internalType: 'bytes32', type: 'bytes32' },
    ],
    name: 'attestations',
    outputs: [{ name: '', internalType: 'bytes', type: 'bytes' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'version',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
] as const

/**
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0xEE36eaaD94d1Cc1d0eccaDb55C38bFfB6Be06C77)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0xEE36eaaD94d1Cc1d0eccaDb55C38bFfB6Be06C77)
 */
export const attestationStationAddress = {
  10: '0xEE36eaaD94d1Cc1d0eccaDb55C38bFfB6Be06C77',
  420: '0xEE36eaaD94d1Cc1d0eccaDb55C38bFfB6Be06C77',
} as const

/**
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0xEE36eaaD94d1Cc1d0eccaDb55C38bFfB6Be06C77)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0xEE36eaaD94d1Cc1d0eccaDb55C38bFfB6Be06C77)
 */
export const attestationStationConfig = {
  address: attestationStationAddress,
  abi: attestationStationABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// BaseFeeVault
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000019)
 */
export const baseFeeVaultABI = [
  {
    stateMutability: 'nonpayable',
    type: 'constructor',
    inputs: [{ name: '_recipient', internalType: 'address', type: 'address' }],
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'value',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      { name: 'to', internalType: 'address', type: 'address', indexed: false },
      {
        name: 'from',
        internalType: 'address',
        type: 'address',
        indexed: false,
      },
    ],
    name: 'Withdrawal',
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'MIN_WITHDRAWAL_AMOUNT',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'RECIPIENT',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'totalProcessed',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'version',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'withdraw',
    outputs: [],
  },
  { stateMutability: 'payable', type: 'receive' },
] as const

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000019)
 */
export const baseFeeVaultAddress = {
  420: '0x4200000000000000000000000000000000000019',
} as const

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000019)
 */
export const baseFeeVaultConfig = {
  address: baseFeeVaultAddress,
  abi: baseFeeVaultABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// CheckBalanceHigh
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x7eC64a8a591bFf829ff6C8be76074D540ACb813F)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x7eC64a8a591bFf829ff6C8be76074D540ACb813F)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5d7103853f12109A7d27F118e54BbC654ad847E9)
 */
export const checkBalanceHighABI = [
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'params',
        internalType: 'struct CheckBalanceHigh.Params',
        type: 'tuple',
        components: [
          { name: 'target', internalType: 'address', type: 'address' },
          { name: 'threshold', internalType: 'uint256', type: 'uint256' },
        ],
        indexed: false,
      },
    ],
    name: '_EventToExposeStructInABI__Params',
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '_params', internalType: 'bytes', type: 'bytes' }],
    name: 'check',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
] as const

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x7eC64a8a591bFf829ff6C8be76074D540ACb813F)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x7eC64a8a591bFf829ff6C8be76074D540ACb813F)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5d7103853f12109A7d27F118e54BbC654ad847E9)
 */
export const checkBalanceHighAddress = {
  1: '0x7eC64a8a591bFf829ff6C8be76074D540ACb813F',
  5: '0x7eC64a8a591bFf829ff6C8be76074D540ACb813F',
  420: '0x5d7103853f12109A7d27F118e54BbC654ad847E9',
} as const

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x7eC64a8a591bFf829ff6C8be76074D540ACb813F)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x7eC64a8a591bFf829ff6C8be76074D540ACb813F)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5d7103853f12109A7d27F118e54BbC654ad847E9)
 */
export const checkBalanceHighConfig = {
  address: checkBalanceHighAddress,
  abi: checkBalanceHighABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// CheckBalanceLow
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x381a4eFC2A2C914eA1889722bB4B44Fa6BD5b640)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x381a4eFC2A2C914eA1889722bB4B44Fa6BD5b640)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x7Ce13D154FAEE5C8B3E6b19d4Add16f21d884474)
 */
export const checkBalanceLowABI = [
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'params',
        internalType: 'struct CheckBalanceLow.Params',
        type: 'tuple',
        components: [
          { name: 'target', internalType: 'address', type: 'address' },
          { name: 'threshold', internalType: 'uint256', type: 'uint256' },
        ],
        indexed: false,
      },
    ],
    name: '_EventToExposeStructInABI__Params',
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '_params', internalType: 'bytes', type: 'bytes' }],
    name: 'check',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
] as const

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x381a4eFC2A2C914eA1889722bB4B44Fa6BD5b640)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x381a4eFC2A2C914eA1889722bB4B44Fa6BD5b640)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x7Ce13D154FAEE5C8B3E6b19d4Add16f21d884474)
 */
export const checkBalanceLowAddress = {
  1: '0x381a4eFC2A2C914eA1889722bB4B44Fa6BD5b640',
  5: '0x381a4eFC2A2C914eA1889722bB4B44Fa6BD5b640',
  420: '0x7Ce13D154FAEE5C8B3E6b19d4Add16f21d884474',
} as const

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x381a4eFC2A2C914eA1889722bB4B44Fa6BD5b640)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x381a4eFC2A2C914eA1889722bB4B44Fa6BD5b640)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x7Ce13D154FAEE5C8B3E6b19d4Add16f21d884474)
 */
export const checkBalanceLowConfig = {
  address: checkBalanceLowAddress,
  abi: checkBalanceLowABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// CheckGelatoLow
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4f7CFc43f6D262a085F3b946cAC69E7a8E39BBAa)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4f7CFc43f6D262a085F3b946cAC69E7a8E39BBAa)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0xF9c8a4Cb4021f57F9f6d69799cA9BefF64524862)
 */
export const checkGelatoLowABI = [
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'params',
        internalType: 'struct CheckGelatoLow.Params',
        type: 'tuple',
        components: [
          { name: 'treasury', internalType: 'address', type: 'address' },
          { name: 'threshold', internalType: 'uint256', type: 'uint256' },
          { name: 'recipient', internalType: 'address', type: 'address' },
        ],
        indexed: false,
      },
    ],
    name: '_EventToExposeStructInABI__Params',
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '_params', internalType: 'bytes', type: 'bytes' }],
    name: 'check',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
] as const

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4f7CFc43f6D262a085F3b946cAC69E7a8E39BBAa)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4f7CFc43f6D262a085F3b946cAC69E7a8E39BBAa)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0xF9c8a4Cb4021f57F9f6d69799cA9BefF64524862)
 */
export const checkGelatoLowAddress = {
  1: '0x4f7CFc43f6D262a085F3b946cAC69E7a8E39BBAa',
  5: '0x4f7CFc43f6D262a085F3b946cAC69E7a8E39BBAa',
  420: '0xF9c8a4Cb4021f57F9f6d69799cA9BefF64524862',
} as const

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4f7CFc43f6D262a085F3b946cAC69E7a8E39BBAa)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4f7CFc43f6D262a085F3b946cAC69E7a8E39BBAa)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0xF9c8a4Cb4021f57F9f6d69799cA9BefF64524862)
 */
export const checkGelatoLowConfig = {
  address: checkGelatoLowAddress,
  abi: checkGelatoLowABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// CheckTrue
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x5c741a38cb11424711231777D71689C458eE835D)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5c741a38cb11424711231777D71689C458eE835D)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x47443D0C184e022F19BD1578F5bca6B8a9F58E32)
 */
export const checkTrueABI = [
  {
    stateMutability: 'pure',
    type: 'function',
    inputs: [{ name: '', internalType: 'bytes', type: 'bytes' }],
    name: 'check',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
] as const

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x5c741a38cb11424711231777D71689C458eE835D)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5c741a38cb11424711231777D71689C458eE835D)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x47443D0C184e022F19BD1578F5bca6B8a9F58E32)
 */
export const checkTrueAddress = {
  1: '0x5c741a38cb11424711231777D71689C458eE835D',
  5: '0x5c741a38cb11424711231777D71689C458eE835D',
  420: '0x47443D0C184e022F19BD1578F5bca6B8a9F58E32',
} as const

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x5c741a38cb11424711231777D71689C458eE835D)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5c741a38cb11424711231777D71689C458eE835D)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x47443D0C184e022F19BD1578F5bca6B8a9F58E32)
 */
export const checkTrueConfig = {
  address: checkTrueAddress,
  abi: checkTrueABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Drippie
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export const drippieABI = [
  {
    stateMutability: 'nonpayable',
    type: 'constructor',
    inputs: [{ name: '_owner', internalType: 'address', type: 'address' }],
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'nameref',
        internalType: 'string',
        type: 'string',
        indexed: true,
      },
      { name: 'name', internalType: 'string', type: 'string', indexed: false },
      {
        name: 'config',
        internalType: 'struct Drippie.DripConfig',
        type: 'tuple',
        components: [
          { name: 'reentrant', internalType: 'bool', type: 'bool' },
          { name: 'interval', internalType: 'uint256', type: 'uint256' },
          {
            name: 'dripcheck',
            internalType: 'contract IDripCheck',
            type: 'address',
          },
          { name: 'checkparams', internalType: 'bytes', type: 'bytes' },
          {
            name: 'actions',
            internalType: 'struct Drippie.DripAction[]',
            type: 'tuple[]',
            components: [
              {
                name: 'target',
                internalType: 'address payable',
                type: 'address',
              },
              { name: 'data', internalType: 'bytes', type: 'bytes' },
              { name: 'value', internalType: 'uint256', type: 'uint256' },
            ],
          },
        ],
        indexed: false,
      },
    ],
    name: 'DripCreated',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'nameref',
        internalType: 'string',
        type: 'string',
        indexed: true,
      },
      { name: 'name', internalType: 'string', type: 'string', indexed: false },
      {
        name: 'executor',
        internalType: 'address',
        type: 'address',
        indexed: false,
      },
      {
        name: 'timestamp',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
    ],
    name: 'DripExecuted',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'nameref',
        internalType: 'string',
        type: 'string',
        indexed: true,
      },
      { name: 'name', internalType: 'string', type: 'string', indexed: false },
      {
        name: 'status',
        internalType: 'enum Drippie.DripStatus',
        type: 'uint8',
        indexed: false,
      },
    ],
    name: 'DripStatusUpdated',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'user', internalType: 'address', type: 'address', indexed: true },
      {
        name: 'newOwner',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
    ],
    name: 'OwnerUpdated',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
    ],
    name: 'ReceivedETH',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'withdrawer',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'recipient',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'asset',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
    ],
    name: 'WithdrewERC20',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'withdrawer',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'recipient',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'asset',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      { name: 'id', internalType: 'uint256', type: 'uint256', indexed: false },
    ],
    name: 'WithdrewERC721',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'withdrawer',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'recipient',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
    ],
    name: 'WithdrewETH',
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_target', internalType: 'address', type: 'address' },
      { name: '_data', internalType: 'bytes', type: 'bytes' },
      { name: '_value', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'CALL',
    outputs: [
      { name: '', internalType: 'bool', type: 'bool' },
      { name: '', internalType: 'bytes', type: 'bytes' },
    ],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_target', internalType: 'address', type: 'address' },
      { name: '_data', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'DELEGATECALL',
    outputs: [
      { name: '', internalType: 'bool', type: 'bool' },
      { name: '', internalType: 'bytes', type: 'bytes' },
    ],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_name', internalType: 'string', type: 'string' },
      {
        name: '_config',
        internalType: 'struct Drippie.DripConfig',
        type: 'tuple',
        components: [
          { name: 'reentrant', internalType: 'bool', type: 'bool' },
          { name: 'interval', internalType: 'uint256', type: 'uint256' },
          {
            name: 'dripcheck',
            internalType: 'contract IDripCheck',
            type: 'address',
          },
          { name: 'checkparams', internalType: 'bytes', type: 'bytes' },
          {
            name: 'actions',
            internalType: 'struct Drippie.DripAction[]',
            type: 'tuple[]',
            components: [
              {
                name: 'target',
                internalType: 'address payable',
                type: 'address',
              },
              { name: 'data', internalType: 'bytes', type: 'bytes' },
              { name: 'value', internalType: 'uint256', type: 'uint256' },
            ],
          },
        ],
      },
    ],
    name: 'create',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: '_name', internalType: 'string', type: 'string' }],
    name: 'drip',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '', internalType: 'string', type: 'string' }],
    name: 'drips',
    outputs: [
      {
        name: 'status',
        internalType: 'enum Drippie.DripStatus',
        type: 'uint8',
      },
      {
        name: 'config',
        internalType: 'struct Drippie.DripConfig',
        type: 'tuple',
        components: [
          { name: 'reentrant', internalType: 'bool', type: 'bool' },
          { name: 'interval', internalType: 'uint256', type: 'uint256' },
          {
            name: 'dripcheck',
            internalType: 'contract IDripCheck',
            type: 'address',
          },
          { name: 'checkparams', internalType: 'bytes', type: 'bytes' },
          {
            name: 'actions',
            internalType: 'struct Drippie.DripAction[]',
            type: 'tuple[]',
            components: [
              {
                name: 'target',
                internalType: 'address payable',
                type: 'address',
              },
              { name: 'data', internalType: 'bytes', type: 'bytes' },
              { name: 'value', internalType: 'uint256', type: 'uint256' },
            ],
          },
        ],
      },
      { name: 'last', internalType: 'uint256', type: 'uint256' },
      { name: 'count', internalType: 'uint256', type: 'uint256' },
    ],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '_name', internalType: 'string', type: 'string' }],
    name: 'executable',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'owner',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: 'newOwner', internalType: 'address', type: 'address' }],
    name: 'setOwner',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_name', internalType: 'string', type: 'string' },
      {
        name: '_status',
        internalType: 'enum Drippie.DripStatus',
        type: 'uint8',
      },
    ],
    name: 'status',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_asset', internalType: 'contract ERC20', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'withdrawERC20',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_asset', internalType: 'contract ERC20', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
    ],
    name: 'withdrawERC20',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_asset', internalType: 'contract ERC721', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_id', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'withdrawERC721',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_to', internalType: 'address payable', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'withdrawETH',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: '_to', internalType: 'address payable', type: 'address' }],
    name: 'withdrawETH',
    outputs: [],
  },
  { stateMutability: 'payable', type: 'receive' },
] as const

/**
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export const drippieAddress = {
  1: '0x44b3A2a040057eBafC601A78647e805fd58B1f50',
} as const

/**
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export const drippieConfig = {
  address: drippieAddress,
  abi: drippieABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Drippie_goerli
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export const drippieGoerliABI = [
  {
    stateMutability: 'nonpayable',
    type: 'constructor',
    inputs: [{ name: '_owner', internalType: 'address', type: 'address' }],
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'nameref',
        internalType: 'string',
        type: 'string',
        indexed: true,
      },
      { name: 'name', internalType: 'string', type: 'string', indexed: false },
      {
        name: 'config',
        internalType: 'struct Drippie.DripConfig',
        type: 'tuple',
        components: [
          { name: 'reentrant', internalType: 'bool', type: 'bool' },
          { name: 'interval', internalType: 'uint256', type: 'uint256' },
          {
            name: 'dripcheck',
            internalType: 'contract IDripCheck',
            type: 'address',
          },
          { name: 'checkparams', internalType: 'bytes', type: 'bytes' },
          {
            name: 'actions',
            internalType: 'struct Drippie.DripAction[]',
            type: 'tuple[]',
            components: [
              {
                name: 'target',
                internalType: 'address payable',
                type: 'address',
              },
              { name: 'data', internalType: 'bytes', type: 'bytes' },
              { name: 'value', internalType: 'uint256', type: 'uint256' },
            ],
          },
        ],
        indexed: false,
      },
    ],
    name: 'DripCreated',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'nameref',
        internalType: 'string',
        type: 'string',
        indexed: true,
      },
      { name: 'name', internalType: 'string', type: 'string', indexed: false },
      {
        name: 'executor',
        internalType: 'address',
        type: 'address',
        indexed: false,
      },
      {
        name: 'timestamp',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
    ],
    name: 'DripExecuted',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'nameref',
        internalType: 'string',
        type: 'string',
        indexed: true,
      },
      { name: 'name', internalType: 'string', type: 'string', indexed: false },
      {
        name: 'status',
        internalType: 'enum Drippie.DripStatus',
        type: 'uint8',
        indexed: false,
      },
    ],
    name: 'DripStatusUpdated',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'user', internalType: 'address', type: 'address', indexed: true },
      {
        name: 'newOwner',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
    ],
    name: 'OwnerUpdated',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
    ],
    name: 'ReceivedETH',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'withdrawer',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'recipient',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'asset',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
    ],
    name: 'WithdrewERC20',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'withdrawer',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'recipient',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'asset',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      { name: 'id', internalType: 'uint256', type: 'uint256', indexed: false },
    ],
    name: 'WithdrewERC721',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'withdrawer',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'recipient',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
    ],
    name: 'WithdrewETH',
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_target', internalType: 'address', type: 'address' },
      { name: '_data', internalType: 'bytes', type: 'bytes' },
      { name: '_value', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'CALL',
    outputs: [
      { name: '', internalType: 'bool', type: 'bool' },
      { name: '', internalType: 'bytes', type: 'bytes' },
    ],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_target', internalType: 'address', type: 'address' },
      { name: '_data', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'DELEGATECALL',
    outputs: [
      { name: '', internalType: 'bool', type: 'bool' },
      { name: '', internalType: 'bytes', type: 'bytes' },
    ],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_name', internalType: 'string', type: 'string' },
      {
        name: '_config',
        internalType: 'struct Drippie.DripConfig',
        type: 'tuple',
        components: [
          { name: 'reentrant', internalType: 'bool', type: 'bool' },
          { name: 'interval', internalType: 'uint256', type: 'uint256' },
          {
            name: 'dripcheck',
            internalType: 'contract IDripCheck',
            type: 'address',
          },
          { name: 'checkparams', internalType: 'bytes', type: 'bytes' },
          {
            name: 'actions',
            internalType: 'struct Drippie.DripAction[]',
            type: 'tuple[]',
            components: [
              {
                name: 'target',
                internalType: 'address payable',
                type: 'address',
              },
              { name: 'data', internalType: 'bytes', type: 'bytes' },
              { name: 'value', internalType: 'uint256', type: 'uint256' },
            ],
          },
        ],
      },
    ],
    name: 'create',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: '_name', internalType: 'string', type: 'string' }],
    name: 'drip',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '', internalType: 'string', type: 'string' }],
    name: 'drips',
    outputs: [
      {
        name: 'status',
        internalType: 'enum Drippie.DripStatus',
        type: 'uint8',
      },
      {
        name: 'config',
        internalType: 'struct Drippie.DripConfig',
        type: 'tuple',
        components: [
          { name: 'reentrant', internalType: 'bool', type: 'bool' },
          { name: 'interval', internalType: 'uint256', type: 'uint256' },
          {
            name: 'dripcheck',
            internalType: 'contract IDripCheck',
            type: 'address',
          },
          { name: 'checkparams', internalType: 'bytes', type: 'bytes' },
          {
            name: 'actions',
            internalType: 'struct Drippie.DripAction[]',
            type: 'tuple[]',
            components: [
              {
                name: 'target',
                internalType: 'address payable',
                type: 'address',
              },
              { name: 'data', internalType: 'bytes', type: 'bytes' },
              { name: 'value', internalType: 'uint256', type: 'uint256' },
            ],
          },
        ],
      },
      { name: 'last', internalType: 'uint256', type: 'uint256' },
      { name: 'count', internalType: 'uint256', type: 'uint256' },
    ],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '_name', internalType: 'string', type: 'string' }],
    name: 'executable',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'owner',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: 'newOwner', internalType: 'address', type: 'address' }],
    name: 'setOwner',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_name', internalType: 'string', type: 'string' },
      {
        name: '_status',
        internalType: 'enum Drippie.DripStatus',
        type: 'uint8',
      },
    ],
    name: 'status',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_asset', internalType: 'contract ERC20', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'withdrawERC20',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_asset', internalType: 'contract ERC20', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
    ],
    name: 'withdrawERC20',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_asset', internalType: 'contract ERC721', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_id', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'withdrawERC721',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_to', internalType: 'address payable', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'withdrawETH',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: '_to', internalType: 'address payable', type: 'address' }],
    name: 'withdrawETH',
    outputs: [],
  },
  { stateMutability: 'payable', type: 'receive' },
] as const

/**
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export const drippieGoerliAddress = {
  5: '0x44b3A2a040057eBafC601A78647e805fd58B1f50',
} as const

/**
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export const drippieGoerliConfig = {
  address: drippieGoerliAddress,
  abi: drippieGoerliABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Drippie_optimism-goerli
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export const drippieOptimismGoerliABI = [
  {
    stateMutability: 'nonpayable',
    type: 'constructor',
    inputs: [{ name: '_owner', internalType: 'address', type: 'address' }],
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'nameref',
        internalType: 'string',
        type: 'string',
        indexed: true,
      },
      { name: 'name', internalType: 'string', type: 'string', indexed: false },
      {
        name: 'config',
        internalType: 'struct Drippie.DripConfig',
        type: 'tuple',
        components: [
          { name: 'interval', internalType: 'uint256', type: 'uint256' },
          {
            name: 'dripcheck',
            internalType: 'contract IDripCheck',
            type: 'address',
          },
          { name: 'checkparams', internalType: 'bytes', type: 'bytes' },
          {
            name: 'actions',
            internalType: 'struct Drippie.DripAction[]',
            type: 'tuple[]',
            components: [
              {
                name: 'target',
                internalType: 'address payable',
                type: 'address',
              },
              { name: 'data', internalType: 'bytes', type: 'bytes' },
              { name: 'value', internalType: 'uint256', type: 'uint256' },
            ],
          },
        ],
        indexed: false,
      },
    ],
    name: 'DripCreated',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'nameref',
        internalType: 'string',
        type: 'string',
        indexed: true,
      },
      { name: 'name', internalType: 'string', type: 'string', indexed: false },
      {
        name: 'executor',
        internalType: 'address',
        type: 'address',
        indexed: false,
      },
      {
        name: 'timestamp',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
    ],
    name: 'DripExecuted',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'nameref',
        internalType: 'string',
        type: 'string',
        indexed: true,
      },
      { name: 'name', internalType: 'string', type: 'string', indexed: false },
      {
        name: 'status',
        internalType: 'enum Drippie.DripStatus',
        type: 'uint8',
        indexed: false,
      },
    ],
    name: 'DripStatusUpdated',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'user', internalType: 'address', type: 'address', indexed: true },
      {
        name: 'newOwner',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
    ],
    name: 'OwnerUpdated',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
    ],
    name: 'ReceivedETH',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'withdrawer',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'recipient',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'asset',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
    ],
    name: 'WithdrewERC20',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'withdrawer',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'recipient',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'asset',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      { name: 'id', internalType: 'uint256', type: 'uint256', indexed: false },
    ],
    name: 'WithdrewERC721',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'withdrawer',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'recipient',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
    ],
    name: 'WithdrewETH',
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_target', internalType: 'address', type: 'address' },
      { name: '_data', internalType: 'bytes', type: 'bytes' },
      { name: '_gas', internalType: 'uint256', type: 'uint256' },
      { name: '_value', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'CALL',
    outputs: [
      { name: '', internalType: 'bool', type: 'bool' },
      { name: '', internalType: 'bytes', type: 'bytes' },
    ],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_target', internalType: 'address', type: 'address' },
      { name: '_data', internalType: 'bytes', type: 'bytes' },
      { name: '_gas', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'DELEGATECALL',
    outputs: [
      { name: '', internalType: 'bool', type: 'bool' },
      { name: '', internalType: 'bytes', type: 'bytes' },
    ],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_name', internalType: 'string', type: 'string' },
      {
        name: '_config',
        internalType: 'struct Drippie.DripConfig',
        type: 'tuple',
        components: [
          { name: 'interval', internalType: 'uint256', type: 'uint256' },
          {
            name: 'dripcheck',
            internalType: 'contract IDripCheck',
            type: 'address',
          },
          { name: 'checkparams', internalType: 'bytes', type: 'bytes' },
          {
            name: 'actions',
            internalType: 'struct Drippie.DripAction[]',
            type: 'tuple[]',
            components: [
              {
                name: 'target',
                internalType: 'address payable',
                type: 'address',
              },
              { name: 'data', internalType: 'bytes', type: 'bytes' },
              { name: 'value', internalType: 'uint256', type: 'uint256' },
            ],
          },
        ],
      },
    ],
    name: 'create',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: '_name', internalType: 'string', type: 'string' }],
    name: 'drip',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '', internalType: 'string', type: 'string' }],
    name: 'drips',
    outputs: [
      {
        name: 'status',
        internalType: 'enum Drippie.DripStatus',
        type: 'uint8',
      },
      {
        name: 'config',
        internalType: 'struct Drippie.DripConfig',
        type: 'tuple',
        components: [
          { name: 'interval', internalType: 'uint256', type: 'uint256' },
          {
            name: 'dripcheck',
            internalType: 'contract IDripCheck',
            type: 'address',
          },
          { name: 'checkparams', internalType: 'bytes', type: 'bytes' },
          {
            name: 'actions',
            internalType: 'struct Drippie.DripAction[]',
            type: 'tuple[]',
            components: [
              {
                name: 'target',
                internalType: 'address payable',
                type: 'address',
              },
              { name: 'data', internalType: 'bytes', type: 'bytes' },
              { name: 'value', internalType: 'uint256', type: 'uint256' },
            ],
          },
        ],
      },
      { name: 'last', internalType: 'uint256', type: 'uint256' },
      { name: 'count', internalType: 'uint256', type: 'uint256' },
    ],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '_name', internalType: 'string', type: 'string' }],
    name: 'executable',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'owner',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: 'newOwner', internalType: 'address', type: 'address' }],
    name: 'setOwner',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_name', internalType: 'string', type: 'string' },
      {
        name: '_status',
        internalType: 'enum Drippie.DripStatus',
        type: 'uint8',
      },
    ],
    name: 'status',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_asset', internalType: 'contract ERC20', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'withdrawERC20',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_asset', internalType: 'contract ERC20', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
    ],
    name: 'withdrawERC20',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_asset', internalType: 'contract ERC721', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_id', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'withdrawERC721',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_to', internalType: 'address payable', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'withdrawETH',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: '_to', internalType: 'address payable', type: 'address' }],
    name: 'withdrawETH',
    outputs: [],
  },
  { stateMutability: 'payable', type: 'receive' },
] as const

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export const drippieOptimismGoerliAddress = {
  420: '0x8D8d533C16D23847EB04EEB0925be8900Dd3af86',
} as const

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export const drippieOptimismGoerliConfig = {
  address: drippieOptimismGoerliAddress,
  abi: drippieOptimismGoerliABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// EAS
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4E0275Ea5a89e7a3c1B58411379D1a0eDdc5b088)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5A633F1cc84B03F7588486CF2F386c102061E6e1)
 */
export const easABI = [
  { stateMutability: 'nonpayable', type: 'constructor', inputs: [] },
  { type: 'error', inputs: [], name: 'AccessDenied' },
  { type: 'error', inputs: [], name: 'AlreadyRevoked' },
  { type: 'error', inputs: [], name: 'AlreadyRevokedOffchain' },
  { type: 'error', inputs: [], name: 'AlreadyTimestamped' },
  { type: 'error', inputs: [], name: 'InsufficientValue' },
  { type: 'error', inputs: [], name: 'InvalidAttestation' },
  { type: 'error', inputs: [], name: 'InvalidAttestations' },
  { type: 'error', inputs: [], name: 'InvalidExpirationTime' },
  { type: 'error', inputs: [], name: 'InvalidLength' },
  { type: 'error', inputs: [], name: 'InvalidOffset' },
  { type: 'error', inputs: [], name: 'InvalidRegistry' },
  { type: 'error', inputs: [], name: 'InvalidRevocation' },
  { type: 'error', inputs: [], name: 'InvalidRevocations' },
  { type: 'error', inputs: [], name: 'InvalidSchema' },
  { type: 'error', inputs: [], name: 'InvalidSignature' },
  { type: 'error', inputs: [], name: 'InvalidVerifier' },
  { type: 'error', inputs: [], name: 'Irrevocable' },
  { type: 'error', inputs: [], name: 'NotFound' },
  { type: 'error', inputs: [], name: 'NotPayable' },
  { type: 'error', inputs: [], name: 'WrongSchema' },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'recipient',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'attester',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      { name: 'uid', internalType: 'bytes32', type: 'bytes32', indexed: false },
      {
        name: 'schema',
        internalType: 'bytes32',
        type: 'bytes32',
        indexed: true,
      },
    ],
    name: 'Attested',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'recipient',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'attester',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      { name: 'uid', internalType: 'bytes32', type: 'bytes32', indexed: false },
      {
        name: 'schema',
        internalType: 'bytes32',
        type: 'bytes32',
        indexed: true,
      },
    ],
    name: 'Revoked',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'revoker',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      { name: 'data', internalType: 'bytes32', type: 'bytes32', indexed: true },
      {
        name: 'timestamp',
        internalType: 'uint64',
        type: 'uint64',
        indexed: true,
      },
    ],
    name: 'RevokedOffchain',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'data', internalType: 'bytes32', type: 'bytes32', indexed: true },
      {
        name: 'timestamp',
        internalType: 'uint64',
        type: 'uint64',
        indexed: true,
      },
    ],
    name: 'Timestamped',
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      {
        name: 'request',
        internalType: 'struct AttestationRequest',
        type: 'tuple',
        components: [
          { name: 'schema', internalType: 'bytes32', type: 'bytes32' },
          {
            name: 'data',
            internalType: 'struct AttestationRequestData',
            type: 'tuple',
            components: [
              { name: 'recipient', internalType: 'address', type: 'address' },
              {
                name: 'expirationTime',
                internalType: 'uint64',
                type: 'uint64',
              },
              { name: 'revocable', internalType: 'bool', type: 'bool' },
              { name: 'refUID', internalType: 'bytes32', type: 'bytes32' },
              { name: 'data', internalType: 'bytes', type: 'bytes' },
              { name: 'value', internalType: 'uint256', type: 'uint256' },
            ],
          },
        ],
      },
    ],
    name: 'attest',
    outputs: [{ name: '', internalType: 'bytes32', type: 'bytes32' }],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      {
        name: 'delegatedRequest',
        internalType: 'struct DelegatedAttestationRequest',
        type: 'tuple',
        components: [
          { name: 'schema', internalType: 'bytes32', type: 'bytes32' },
          {
            name: 'data',
            internalType: 'struct AttestationRequestData',
            type: 'tuple',
            components: [
              { name: 'recipient', internalType: 'address', type: 'address' },
              {
                name: 'expirationTime',
                internalType: 'uint64',
                type: 'uint64',
              },
              { name: 'revocable', internalType: 'bool', type: 'bool' },
              { name: 'refUID', internalType: 'bytes32', type: 'bytes32' },
              { name: 'data', internalType: 'bytes', type: 'bytes' },
              { name: 'value', internalType: 'uint256', type: 'uint256' },
            ],
          },
          {
            name: 'signature',
            internalType: 'struct EIP712Signature',
            type: 'tuple',
            components: [
              { name: 'v', internalType: 'uint8', type: 'uint8' },
              { name: 'r', internalType: 'bytes32', type: 'bytes32' },
              { name: 's', internalType: 'bytes32', type: 'bytes32' },
            ],
          },
          { name: 'attester', internalType: 'address', type: 'address' },
        ],
      },
    ],
    name: 'attestByDelegation',
    outputs: [{ name: '', internalType: 'bytes32', type: 'bytes32' }],
  },
  {
    stateMutability: 'pure',
    type: 'function',
    inputs: [],
    name: 'getAttestTypeHash',
    outputs: [{ name: '', internalType: 'bytes32', type: 'bytes32' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: 'uid', internalType: 'bytes32', type: 'bytes32' }],
    name: 'getAttestation',
    outputs: [
      {
        name: '',
        internalType: 'struct Attestation',
        type: 'tuple',
        components: [
          { name: 'uid', internalType: 'bytes32', type: 'bytes32' },
          { name: 'schema', internalType: 'bytes32', type: 'bytes32' },
          { name: 'time', internalType: 'uint64', type: 'uint64' },
          { name: 'expirationTime', internalType: 'uint64', type: 'uint64' },
          { name: 'revocationTime', internalType: 'uint64', type: 'uint64' },
          { name: 'refUID', internalType: 'bytes32', type: 'bytes32' },
          { name: 'recipient', internalType: 'address', type: 'address' },
          { name: 'attester', internalType: 'address', type: 'address' },
          { name: 'revocable', internalType: 'bool', type: 'bool' },
          { name: 'data', internalType: 'bytes', type: 'bytes' },
        ],
      },
    ],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'getDomainSeparator',
    outputs: [{ name: '', internalType: 'bytes32', type: 'bytes32' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'getName',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: 'account', internalType: 'address', type: 'address' }],
    name: 'getNonce',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [
      { name: 'revoker', internalType: 'address', type: 'address' },
      { name: 'data', internalType: 'bytes32', type: 'bytes32' },
    ],
    name: 'getRevokeOffchain',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'pure',
    type: 'function',
    inputs: [],
    name: 'getRevokeTypeHash',
    outputs: [{ name: '', internalType: 'bytes32', type: 'bytes32' }],
  },
  {
    stateMutability: 'pure',
    type: 'function',
    inputs: [],
    name: 'getSchemaRegistry',
    outputs: [
      { name: '', internalType: 'contract ISchemaRegistry', type: 'address' },
    ],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: 'data', internalType: 'bytes32', type: 'bytes32' }],
    name: 'getTimestamp',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: 'uid', internalType: 'bytes32', type: 'bytes32' }],
    name: 'isAttestationValid',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      {
        name: 'multiRequests',
        internalType: 'struct MultiAttestationRequest[]',
        type: 'tuple[]',
        components: [
          { name: 'schema', internalType: 'bytes32', type: 'bytes32' },
          {
            name: 'data',
            internalType: 'struct AttestationRequestData[]',
            type: 'tuple[]',
            components: [
              { name: 'recipient', internalType: 'address', type: 'address' },
              {
                name: 'expirationTime',
                internalType: 'uint64',
                type: 'uint64',
              },
              { name: 'revocable', internalType: 'bool', type: 'bool' },
              { name: 'refUID', internalType: 'bytes32', type: 'bytes32' },
              { name: 'data', internalType: 'bytes', type: 'bytes' },
              { name: 'value', internalType: 'uint256', type: 'uint256' },
            ],
          },
        ],
      },
    ],
    name: 'multiAttest',
    outputs: [{ name: '', internalType: 'bytes32[]', type: 'bytes32[]' }],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      {
        name: 'multiDelegatedRequests',
        internalType: 'struct MultiDelegatedAttestationRequest[]',
        type: 'tuple[]',
        components: [
          { name: 'schema', internalType: 'bytes32', type: 'bytes32' },
          {
            name: 'data',
            internalType: 'struct AttestationRequestData[]',
            type: 'tuple[]',
            components: [
              { name: 'recipient', internalType: 'address', type: 'address' },
              {
                name: 'expirationTime',
                internalType: 'uint64',
                type: 'uint64',
              },
              { name: 'revocable', internalType: 'bool', type: 'bool' },
              { name: 'refUID', internalType: 'bytes32', type: 'bytes32' },
              { name: 'data', internalType: 'bytes', type: 'bytes' },
              { name: 'value', internalType: 'uint256', type: 'uint256' },
            ],
          },
          {
            name: 'signatures',
            internalType: 'struct EIP712Signature[]',
            type: 'tuple[]',
            components: [
              { name: 'v', internalType: 'uint8', type: 'uint8' },
              { name: 'r', internalType: 'bytes32', type: 'bytes32' },
              { name: 's', internalType: 'bytes32', type: 'bytes32' },
            ],
          },
          { name: 'attester', internalType: 'address', type: 'address' },
        ],
      },
    ],
    name: 'multiAttestByDelegation',
    outputs: [{ name: '', internalType: 'bytes32[]', type: 'bytes32[]' }],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      {
        name: 'multiRequests',
        internalType: 'struct MultiRevocationRequest[]',
        type: 'tuple[]',
        components: [
          { name: 'schema', internalType: 'bytes32', type: 'bytes32' },
          {
            name: 'data',
            internalType: 'struct RevocationRequestData[]',
            type: 'tuple[]',
            components: [
              { name: 'uid', internalType: 'bytes32', type: 'bytes32' },
              { name: 'value', internalType: 'uint256', type: 'uint256' },
            ],
          },
        ],
      },
    ],
    name: 'multiRevoke',
    outputs: [],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      {
        name: 'multiDelegatedRequests',
        internalType: 'struct MultiDelegatedRevocationRequest[]',
        type: 'tuple[]',
        components: [
          { name: 'schema', internalType: 'bytes32', type: 'bytes32' },
          {
            name: 'data',
            internalType: 'struct RevocationRequestData[]',
            type: 'tuple[]',
            components: [
              { name: 'uid', internalType: 'bytes32', type: 'bytes32' },
              { name: 'value', internalType: 'uint256', type: 'uint256' },
            ],
          },
          {
            name: 'signatures',
            internalType: 'struct EIP712Signature[]',
            type: 'tuple[]',
            components: [
              { name: 'v', internalType: 'uint8', type: 'uint8' },
              { name: 'r', internalType: 'bytes32', type: 'bytes32' },
              { name: 's', internalType: 'bytes32', type: 'bytes32' },
            ],
          },
          { name: 'revoker', internalType: 'address', type: 'address' },
        ],
      },
    ],
    name: 'multiRevokeByDelegation',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: 'data', internalType: 'bytes32[]', type: 'bytes32[]' }],
    name: 'multiRevokeOffchain',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: 'data', internalType: 'bytes32[]', type: 'bytes32[]' }],
    name: 'multiTimestamp',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      {
        name: 'request',
        internalType: 'struct RevocationRequest',
        type: 'tuple',
        components: [
          { name: 'schema', internalType: 'bytes32', type: 'bytes32' },
          {
            name: 'data',
            internalType: 'struct RevocationRequestData',
            type: 'tuple',
            components: [
              { name: 'uid', internalType: 'bytes32', type: 'bytes32' },
              { name: 'value', internalType: 'uint256', type: 'uint256' },
            ],
          },
        ],
      },
    ],
    name: 'revoke',
    outputs: [],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      {
        name: 'delegatedRequest',
        internalType: 'struct DelegatedRevocationRequest',
        type: 'tuple',
        components: [
          { name: 'schema', internalType: 'bytes32', type: 'bytes32' },
          {
            name: 'data',
            internalType: 'struct RevocationRequestData',
            type: 'tuple',
            components: [
              { name: 'uid', internalType: 'bytes32', type: 'bytes32' },
              { name: 'value', internalType: 'uint256', type: 'uint256' },
            ],
          },
          {
            name: 'signature',
            internalType: 'struct EIP712Signature',
            type: 'tuple',
            components: [
              { name: 'v', internalType: 'uint8', type: 'uint8' },
              { name: 'r', internalType: 'bytes32', type: 'bytes32' },
              { name: 's', internalType: 'bytes32', type: 'bytes32' },
            ],
          },
          { name: 'revoker', internalType: 'address', type: 'address' },
        ],
      },
    ],
    name: 'revokeByDelegation',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: 'data', internalType: 'bytes32', type: 'bytes32' }],
    name: 'revokeOffchain',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: 'data', internalType: 'bytes32', type: 'bytes32' }],
    name: 'timestamp',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'version',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
] as const

/**
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4E0275Ea5a89e7a3c1B58411379D1a0eDdc5b088)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5A633F1cc84B03F7588486CF2F386c102061E6e1)
 */
export const easAddress = {
  10: '0x4E0275Ea5a89e7a3c1B58411379D1a0eDdc5b088',
  420: '0x5A633F1cc84B03F7588486CF2F386c102061E6e1',
} as const

/**
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4E0275Ea5a89e7a3c1B58411379D1a0eDdc5b088)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5A633F1cc84B03F7588486CF2F386c102061E6e1)
 */
export const easConfig = { address: easAddress, abi: easABI } as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// GasPriceOracle
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x420000000000000000000000000000000000000F)
 */
export const gasPriceOracleABI = [
  { stateMutability: 'nonpayable', type: 'constructor', inputs: [] },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'baseFee',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'pure',
    type: 'function',
    inputs: [],
    name: 'decimals',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'gasPrice',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '_data', internalType: 'bytes', type: 'bytes' }],
    name: 'getL1Fee',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '_data', internalType: 'bytes', type: 'bytes' }],
    name: 'getL1GasUsed',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'l1BaseFee',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'overhead',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'scalar',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'version',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
] as const

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x420000000000000000000000000000000000000F)
 */
export const gasPriceOracleAddress = {
  420: '0x420000000000000000000000000000000000000F',
} as const

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x420000000000000000000000000000000000000F)
 */
export const gasPriceOracleConfig = {
  address: gasPriceOracleAddress,
  abi: gasPriceOracleABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// L1Block
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000015)
 */
export const l1BlockABI = [
  { stateMutability: 'nonpayable', type: 'constructor', inputs: [] },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'DEPOSITOR_ACCOUNT',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'basefee',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'batcherHash',
    outputs: [{ name: '', internalType: 'bytes32', type: 'bytes32' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'hash',
    outputs: [{ name: '', internalType: 'bytes32', type: 'bytes32' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'l1FeeOverhead',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'l1FeeScalar',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'number',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'sequenceNumber',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_number', internalType: 'uint64', type: 'uint64' },
      { name: '_timestamp', internalType: 'uint64', type: 'uint64' },
      { name: '_basefee', internalType: 'uint256', type: 'uint256' },
      { name: '_hash', internalType: 'bytes32', type: 'bytes32' },
      { name: '_sequenceNumber', internalType: 'uint64', type: 'uint64' },
      { name: '_batcherHash', internalType: 'bytes32', type: 'bytes32' },
      { name: '_l1FeeOverhead', internalType: 'uint256', type: 'uint256' },
      { name: '_l1FeeScalar', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'setL1BlockValues',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'timestamp',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'version',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
] as const

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000015)
 */
export const l1BlockAddress = {
  420: '0x4200000000000000000000000000000000000015',
} as const

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000015)
 */
export const l1BlockConfig = {
  address: l1BlockAddress,
  abi: l1BlockABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// L1CrossDomainMessenger
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 */
export const l1CrossDomainMessengerABI = [
  {
    stateMutability: 'nonpayable',
    type: 'constructor',
    inputs: [
      {
        name: '_portal',
        internalType: 'contract OptimismPortal',
        type: 'address',
      },
    ],
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'msgHash',
        internalType: 'bytes32',
        type: 'bytes32',
        indexed: true,
      },
    ],
    name: 'FailedRelayedMessage',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'version', internalType: 'uint8', type: 'uint8', indexed: false },
    ],
    name: 'Initialized',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'msgHash',
        internalType: 'bytes32',
        type: 'bytes32',
        indexed: true,
      },
    ],
    name: 'RelayedMessage',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'target',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'sender',
        internalType: 'address',
        type: 'address',
        indexed: false,
      },
      { name: 'message', internalType: 'bytes', type: 'bytes', indexed: false },
      {
        name: 'messageNonce',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      {
        name: 'gasLimit',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
    ],
    name: 'SentMessage',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'sender',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'value',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
    ],
    name: 'SentMessageExtension1',
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'MESSAGE_VERSION',
    outputs: [{ name: '', internalType: 'uint16', type: 'uint16' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'MIN_GAS_CALLDATA_OVERHEAD',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'MIN_GAS_DYNAMIC_OVERHEAD_DENOMINATOR',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'MIN_GAS_DYNAMIC_OVERHEAD_NUMERATOR',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'OTHER_MESSENGER',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'PORTAL',
    outputs: [
      { name: '', internalType: 'contract OptimismPortal', type: 'address' },
    ],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'RELAY_CALL_OVERHEAD',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'RELAY_CONSTANT_OVERHEAD',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'RELAY_GAS_CHECK_BUFFER',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'RELAY_RESERVED_GAS',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'pure',
    type: 'function',
    inputs: [
      { name: '_message', internalType: 'bytes', type: 'bytes' },
      { name: '_minGasLimit', internalType: 'uint32', type: 'uint32' },
    ],
    name: 'baseGas',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '', internalType: 'bytes32', type: 'bytes32' }],
    name: 'failedMessages',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'initialize',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'messageNonce',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_nonce', internalType: 'uint256', type: 'uint256' },
      { name: '_sender', internalType: 'address', type: 'address' },
      { name: '_target', internalType: 'address', type: 'address' },
      { name: '_value', internalType: 'uint256', type: 'uint256' },
      { name: '_minGasLimit', internalType: 'uint256', type: 'uint256' },
      { name: '_message', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'relayMessage',
    outputs: [],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_target', internalType: 'address', type: 'address' },
      { name: '_message', internalType: 'bytes', type: 'bytes' },
      { name: '_minGasLimit', internalType: 'uint32', type: 'uint32' },
    ],
    name: 'sendMessage',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '', internalType: 'bytes32', type: 'bytes32' }],
    name: 'successfulMessages',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'version',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'xDomainMessageSender',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
] as const

/**
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 */
export const l1CrossDomainMessengerAddress = {
  1: '0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1',
} as const

/**
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 */
export const l1CrossDomainMessengerConfig = {
  address: l1CrossDomainMessengerAddress,
  abi: l1CrossDomainMessengerABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// L1CrossDomainMessenger_goerli
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export const l1CrossDomainMessengerGoerliABI = [
  { stateMutability: 'nonpayable', type: 'constructor', inputs: [] },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'msgHash',
        internalType: 'bytes32',
        type: 'bytes32',
        indexed: true,
      },
    ],
    name: 'FailedRelayedMessage',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'version', internalType: 'uint8', type: 'uint8', indexed: false },
    ],
    name: 'Initialized',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'msgHash',
        internalType: 'bytes32',
        type: 'bytes32',
        indexed: true,
      },
    ],
    name: 'RelayedMessage',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'target',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'sender',
        internalType: 'address',
        type: 'address',
        indexed: false,
      },
      { name: 'message', internalType: 'bytes', type: 'bytes', indexed: false },
      {
        name: 'messageNonce',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      {
        name: 'gasLimit',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
    ],
    name: 'SentMessage',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'sender',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'value',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
    ],
    name: 'SentMessageExtension1',
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'MESSAGE_VERSION',
    outputs: [{ name: '', internalType: 'uint16', type: 'uint16' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'MIN_GAS_CALLDATA_OVERHEAD',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'MIN_GAS_DYNAMIC_OVERHEAD_DENOMINATOR',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'MIN_GAS_DYNAMIC_OVERHEAD_NUMERATOR',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'OTHER_MESSENGER',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'RELAY_CALL_OVERHEAD',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'RELAY_CONSTANT_OVERHEAD',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'RELAY_GAS_CHECK_BUFFER',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'RELAY_RESERVED_GAS',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'pure',
    type: 'function',
    inputs: [
      { name: '_message', internalType: 'bytes', type: 'bytes' },
      { name: '_minGasLimit', internalType: 'uint32', type: 'uint32' },
    ],
    name: 'baseGas',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '', internalType: 'bytes32', type: 'bytes32' }],
    name: 'failedMessages',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      {
        name: '_portal',
        internalType: 'contract OptimismPortal',
        type: 'address',
      },
    ],
    name: 'initialize',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'messageNonce',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'portal',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_nonce', internalType: 'uint256', type: 'uint256' },
      { name: '_sender', internalType: 'address', type: 'address' },
      { name: '_target', internalType: 'address', type: 'address' },
      { name: '_value', internalType: 'uint256', type: 'uint256' },
      { name: '_minGasLimit', internalType: 'uint256', type: 'uint256' },
      { name: '_message', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'relayMessage',
    outputs: [],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_target', internalType: 'address', type: 'address' },
      { name: '_message', internalType: 'bytes', type: 'bytes' },
      { name: '_minGasLimit', internalType: 'uint32', type: 'uint32' },
    ],
    name: 'sendMessage',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '', internalType: 'bytes32', type: 'bytes32' }],
    name: 'successfulMessages',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'version',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'xDomainMessageSender',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
] as const

/**
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export const l1CrossDomainMessengerGoerliAddress = {
  5: '0x5086d1eEF304eb5284A0f6720f79403b4e9bE294',
} as const

/**
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export const l1CrossDomainMessengerGoerliConfig = {
  address: l1CrossDomainMessengerGoerliAddress,
  abi: l1CrossDomainMessengerGoerliABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// L1ERC721Bridge
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x5a7749f83b81B301cAb5f48EB8516B986DAef23D)
 */
export const l1Erc721BridgeABI = [
  {
    stateMutability: 'nonpayable',
    type: 'constructor',
    inputs: [
      { name: '_messenger', internalType: 'address', type: 'address' },
      { name: '_otherBridge', internalType: 'address', type: 'address' },
    ],
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'localToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'remoteToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      { name: 'to', internalType: 'address', type: 'address', indexed: false },
      {
        name: 'tokenId',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      {
        name: 'extraData',
        internalType: 'bytes',
        type: 'bytes',
        indexed: false,
      },
    ],
    name: 'ERC721BridgeFinalized',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'localToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'remoteToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      { name: 'to', internalType: 'address', type: 'address', indexed: false },
      {
        name: 'tokenId',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      {
        name: 'extraData',
        internalType: 'bytes',
        type: 'bytes',
        indexed: false,
      },
    ],
    name: 'ERC721BridgeInitiated',
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_localToken', internalType: 'address', type: 'address' },
      { name: '_remoteToken', internalType: 'address', type: 'address' },
      { name: '_tokenId', internalType: 'uint256', type: 'uint256' },
      { name: '_minGasLimit', internalType: 'uint32', type: 'uint32' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'bridgeERC721',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_localToken', internalType: 'address', type: 'address' },
      { name: '_remoteToken', internalType: 'address', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_tokenId', internalType: 'uint256', type: 'uint256' },
      { name: '_minGasLimit', internalType: 'uint32', type: 'uint32' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'bridgeERC721To',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [
      { name: '', internalType: 'address', type: 'address' },
      { name: '', internalType: 'address', type: 'address' },
      { name: '', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'deposits',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_localToken', internalType: 'address', type: 'address' },
      { name: '_remoteToken', internalType: 'address', type: 'address' },
      { name: '_from', internalType: 'address', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_tokenId', internalType: 'uint256', type: 'uint256' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'finalizeBridgeERC721',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'messenger',
    outputs: [
      {
        name: '',
        internalType: 'contract CrossDomainMessenger',
        type: 'address',
      },
    ],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'otherBridge',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'version',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
] as const

/**
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x5a7749f83b81B301cAb5f48EB8516B986DAef23D)
 */
export const l1Erc721BridgeAddress = {
  1: '0x5a7749f83b81B301cAb5f48EB8516B986DAef23D',
} as const

/**
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x5a7749f83b81B301cAb5f48EB8516B986DAef23D)
 */
export const l1Erc721BridgeConfig = {
  address: l1Erc721BridgeAddress,
  abi: l1Erc721BridgeABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// L1ERC721Bridge_goerli
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x8DD330DdE8D9898d43b4dc840Da27A07dF91b3c9)
 */
export const l1Erc721BridgeGoerliABI = [
  { stateMutability: 'nonpayable', type: 'constructor', inputs: [] },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'localToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'remoteToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      { name: 'to', internalType: 'address', type: 'address', indexed: false },
      {
        name: 'tokenId',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      {
        name: 'extraData',
        internalType: 'bytes',
        type: 'bytes',
        indexed: false,
      },
    ],
    name: 'ERC721BridgeFinalized',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'localToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'remoteToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      { name: 'to', internalType: 'address', type: 'address', indexed: false },
      {
        name: 'tokenId',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      {
        name: 'extraData',
        internalType: 'bytes',
        type: 'bytes',
        indexed: false,
      },
    ],
    name: 'ERC721BridgeInitiated',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'version', internalType: 'uint8', type: 'uint8', indexed: false },
    ],
    name: 'Initialized',
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_localToken', internalType: 'address', type: 'address' },
      { name: '_remoteToken', internalType: 'address', type: 'address' },
      { name: '_tokenId', internalType: 'uint256', type: 'uint256' },
      { name: '_minGasLimit', internalType: 'uint32', type: 'uint32' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'bridgeERC721',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_localToken', internalType: 'address', type: 'address' },
      { name: '_remoteToken', internalType: 'address', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_tokenId', internalType: 'uint256', type: 'uint256' },
      { name: '_minGasLimit', internalType: 'uint32', type: 'uint32' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'bridgeERC721To',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [
      { name: '', internalType: 'address', type: 'address' },
      { name: '', internalType: 'address', type: 'address' },
      { name: '', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'deposits',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_localToken', internalType: 'address', type: 'address' },
      { name: '_remoteToken', internalType: 'address', type: 'address' },
      { name: '_from', internalType: 'address', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_tokenId', internalType: 'uint256', type: 'uint256' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'finalizeBridgeERC721',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      {
        name: '_messenger',
        internalType: 'contract CrossDomainMessenger',
        type: 'address',
      },
    ],
    name: 'initialize',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'messenger',
    outputs: [
      {
        name: '',
        internalType: 'contract CrossDomainMessenger',
        type: 'address',
      },
    ],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'otherBridge',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'version',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
] as const

/**
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x8DD330DdE8D9898d43b4dc840Da27A07dF91b3c9)
 */
export const l1Erc721BridgeGoerliAddress = {
  5: '0x8DD330DdE8D9898d43b4dc840Da27A07dF91b3c9',
} as const

/**
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x8DD330DdE8D9898d43b4dc840Da27A07dF91b3c9)
 */
export const l1Erc721BridgeGoerliConfig = {
  address: l1Erc721BridgeGoerliAddress,
  abi: l1Erc721BridgeGoerliABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// L1FeeVault
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x420000000000000000000000000000000000001a)
 */
export const l1FeeVaultABI = [
  {
    stateMutability: 'nonpayable',
    type: 'constructor',
    inputs: [{ name: '_recipient', internalType: 'address', type: 'address' }],
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'value',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      { name: 'to', internalType: 'address', type: 'address', indexed: false },
      {
        name: 'from',
        internalType: 'address',
        type: 'address',
        indexed: false,
      },
    ],
    name: 'Withdrawal',
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'MIN_WITHDRAWAL_AMOUNT',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'RECIPIENT',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'totalProcessed',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'version',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'withdraw',
    outputs: [],
  },
  { stateMutability: 'payable', type: 'receive' },
] as const

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x420000000000000000000000000000000000001a)
 */
export const l1FeeVaultAddress = {
  420: '0x420000000000000000000000000000000000001A',
} as const

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x420000000000000000000000000000000000001a)
 */
export const l1FeeVaultConfig = {
  address: l1FeeVaultAddress,
  abi: l1FeeVaultABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// L1StandardBridge
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 */
export const l1StandardBridgeABI = [
  {
    stateMutability: 'nonpayable',
    type: 'constructor',
    inputs: [
      { name: '_messenger', internalType: 'address payable', type: 'address' },
    ],
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'localToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'remoteToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      { name: 'to', internalType: 'address', type: 'address', indexed: false },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      {
        name: 'extraData',
        internalType: 'bytes',
        type: 'bytes',
        indexed: false,
      },
    ],
    name: 'ERC20BridgeFinalized',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'localToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'remoteToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      { name: 'to', internalType: 'address', type: 'address', indexed: false },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      {
        name: 'extraData',
        internalType: 'bytes',
        type: 'bytes',
        indexed: false,
      },
    ],
    name: 'ERC20BridgeInitiated',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'l1Token',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'l2Token',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      { name: 'to', internalType: 'address', type: 'address', indexed: false },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      {
        name: 'extraData',
        internalType: 'bytes',
        type: 'bytes',
        indexed: false,
      },
    ],
    name: 'ERC20DepositInitiated',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'l1Token',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'l2Token',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      { name: 'to', internalType: 'address', type: 'address', indexed: false },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      {
        name: 'extraData',
        internalType: 'bytes',
        type: 'bytes',
        indexed: false,
      },
    ],
    name: 'ERC20WithdrawalFinalized',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      { name: 'to', internalType: 'address', type: 'address', indexed: true },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      {
        name: 'extraData',
        internalType: 'bytes',
        type: 'bytes',
        indexed: false,
      },
    ],
    name: 'ETHBridgeFinalized',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      { name: 'to', internalType: 'address', type: 'address', indexed: true },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      {
        name: 'extraData',
        internalType: 'bytes',
        type: 'bytes',
        indexed: false,
      },
    ],
    name: 'ETHBridgeInitiated',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      { name: 'to', internalType: 'address', type: 'address', indexed: true },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      {
        name: 'extraData',
        internalType: 'bytes',
        type: 'bytes',
        indexed: false,
      },
    ],
    name: 'ETHDepositInitiated',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      { name: 'to', internalType: 'address', type: 'address', indexed: true },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      {
        name: 'extraData',
        internalType: 'bytes',
        type: 'bytes',
        indexed: false,
      },
    ],
    name: 'ETHWithdrawalFinalized',
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'OTHER_BRIDGE',
    outputs: [
      { name: '', internalType: 'contract StandardBridge', type: 'address' },
    ],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_localToken', internalType: 'address', type: 'address' },
      { name: '_remoteToken', internalType: 'address', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
      { name: '_minGasLimit', internalType: 'uint32', type: 'uint32' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'bridgeERC20',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_localToken', internalType: 'address', type: 'address' },
      { name: '_remoteToken', internalType: 'address', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
      { name: '_minGasLimit', internalType: 'uint32', type: 'uint32' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'bridgeERC20To',
    outputs: [],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_minGasLimit', internalType: 'uint32', type: 'uint32' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'bridgeETH',
    outputs: [],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_minGasLimit', internalType: 'uint32', type: 'uint32' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'bridgeETHTo',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_l1Token', internalType: 'address', type: 'address' },
      { name: '_l2Token', internalType: 'address', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
      { name: '_minGasLimit', internalType: 'uint32', type: 'uint32' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'depositERC20',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_l1Token', internalType: 'address', type: 'address' },
      { name: '_l2Token', internalType: 'address', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
      { name: '_minGasLimit', internalType: 'uint32', type: 'uint32' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'depositERC20To',
    outputs: [],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_minGasLimit', internalType: 'uint32', type: 'uint32' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'depositETH',
    outputs: [],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_minGasLimit', internalType: 'uint32', type: 'uint32' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'depositETHTo',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [
      { name: '', internalType: 'address', type: 'address' },
      { name: '', internalType: 'address', type: 'address' },
    ],
    name: 'deposits',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_localToken', internalType: 'address', type: 'address' },
      { name: '_remoteToken', internalType: 'address', type: 'address' },
      { name: '_from', internalType: 'address', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'finalizeBridgeERC20',
    outputs: [],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_from', internalType: 'address', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'finalizeBridgeETH',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_l1Token', internalType: 'address', type: 'address' },
      { name: '_l2Token', internalType: 'address', type: 'address' },
      { name: '_from', internalType: 'address', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'finalizeERC20Withdrawal',
    outputs: [],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_from', internalType: 'address', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'finalizeETHWithdrawal',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'l2TokenBridge',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'messenger',
    outputs: [
      {
        name: '',
        internalType: 'contract CrossDomainMessenger',
        type: 'address',
      },
    ],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'version',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
  { stateMutability: 'payable', type: 'receive' },
] as const

/**
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 */
export const l1StandardBridgeAddress = {
  1: '0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1',
} as const

/**
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 */
export const l1StandardBridgeConfig = {
  address: l1StandardBridgeAddress,
  abi: l1StandardBridgeABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// L1StandardBridge_goerli
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export const l1StandardBridgeGoerliABI = [
  { stateMutability: 'nonpayable', type: 'constructor', inputs: [] },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'localToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'remoteToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      { name: 'to', internalType: 'address', type: 'address', indexed: false },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      {
        name: 'extraData',
        internalType: 'bytes',
        type: 'bytes',
        indexed: false,
      },
    ],
    name: 'ERC20BridgeFinalized',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'localToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'remoteToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      { name: 'to', internalType: 'address', type: 'address', indexed: false },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      {
        name: 'extraData',
        internalType: 'bytes',
        type: 'bytes',
        indexed: false,
      },
    ],
    name: 'ERC20BridgeInitiated',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'l1Token',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'l2Token',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      { name: 'to', internalType: 'address', type: 'address', indexed: false },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      {
        name: 'extraData',
        internalType: 'bytes',
        type: 'bytes',
        indexed: false,
      },
    ],
    name: 'ERC20DepositInitiated',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'l1Token',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'l2Token',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      { name: 'to', internalType: 'address', type: 'address', indexed: false },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      {
        name: 'extraData',
        internalType: 'bytes',
        type: 'bytes',
        indexed: false,
      },
    ],
    name: 'ERC20WithdrawalFinalized',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      { name: 'to', internalType: 'address', type: 'address', indexed: true },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      {
        name: 'extraData',
        internalType: 'bytes',
        type: 'bytes',
        indexed: false,
      },
    ],
    name: 'ETHBridgeFinalized',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      { name: 'to', internalType: 'address', type: 'address', indexed: true },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      {
        name: 'extraData',
        internalType: 'bytes',
        type: 'bytes',
        indexed: false,
      },
    ],
    name: 'ETHBridgeInitiated',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      { name: 'to', internalType: 'address', type: 'address', indexed: true },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      {
        name: 'extraData',
        internalType: 'bytes',
        type: 'bytes',
        indexed: false,
      },
    ],
    name: 'ETHDepositInitiated',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      { name: 'to', internalType: 'address', type: 'address', indexed: true },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      {
        name: 'extraData',
        internalType: 'bytes',
        type: 'bytes',
        indexed: false,
      },
    ],
    name: 'ETHWithdrawalFinalized',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'version', internalType: 'uint8', type: 'uint8', indexed: false },
    ],
    name: 'Initialized',
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_localToken', internalType: 'address', type: 'address' },
      { name: '_remoteToken', internalType: 'address', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
      { name: '_minGasLimit', internalType: 'uint32', type: 'uint32' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'bridgeERC20',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_localToken', internalType: 'address', type: 'address' },
      { name: '_remoteToken', internalType: 'address', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
      { name: '_minGasLimit', internalType: 'uint32', type: 'uint32' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'bridgeERC20To',
    outputs: [],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_minGasLimit', internalType: 'uint32', type: 'uint32' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'bridgeETH',
    outputs: [],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_minGasLimit', internalType: 'uint32', type: 'uint32' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'bridgeETHTo',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_l1Token', internalType: 'address', type: 'address' },
      { name: '_l2Token', internalType: 'address', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
      { name: '_minGasLimit', internalType: 'uint32', type: 'uint32' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'depositERC20',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_l1Token', internalType: 'address', type: 'address' },
      { name: '_l2Token', internalType: 'address', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
      { name: '_minGasLimit', internalType: 'uint32', type: 'uint32' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'depositERC20To',
    outputs: [],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_minGasLimit', internalType: 'uint32', type: 'uint32' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'depositETH',
    outputs: [],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_minGasLimit', internalType: 'uint32', type: 'uint32' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'depositETHTo',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [
      { name: '', internalType: 'address', type: 'address' },
      { name: '', internalType: 'address', type: 'address' },
    ],
    name: 'deposits',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_localToken', internalType: 'address', type: 'address' },
      { name: '_remoteToken', internalType: 'address', type: 'address' },
      { name: '_from', internalType: 'address', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'finalizeBridgeERC20',
    outputs: [],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_from', internalType: 'address', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'finalizeBridgeETH',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_l1Token', internalType: 'address', type: 'address' },
      { name: '_l2Token', internalType: 'address', type: 'address' },
      { name: '_from', internalType: 'address', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'finalizeERC20Withdrawal',
    outputs: [],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_from', internalType: 'address', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'finalizeETHWithdrawal',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      {
        name: '_messenger',
        internalType: 'contract CrossDomainMessenger',
        type: 'address',
      },
    ],
    name: 'initialize',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'l2TokenBridge',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'messenger',
    outputs: [
      {
        name: '',
        internalType: 'contract CrossDomainMessenger',
        type: 'address',
      },
    ],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'otherBridge',
    outputs: [
      { name: '', internalType: 'contract StandardBridge', type: 'address' },
    ],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'version',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
  { stateMutability: 'payable', type: 'receive' },
] as const

/**
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export const l1StandardBridgeGoerliAddress = {
  5: '0x636Af16bf2f682dD3109e60102b8E1A089FedAa8',
} as const

/**
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export const l1StandardBridgeGoerliConfig = {
  address: l1StandardBridgeGoerliAddress,
  abi: l1StandardBridgeGoerliABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// L2CrossDomainMessenger
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export const l2CrossDomainMessengerABI = [
  {
    stateMutability: 'nonpayable',
    type: 'constructor',
    inputs: [
      {
        name: '_l1CrossDomainMessenger',
        internalType: 'address',
        type: 'address',
      },
    ],
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'msgHash',
        internalType: 'bytes32',
        type: 'bytes32',
        indexed: true,
      },
    ],
    name: 'FailedRelayedMessage',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'version', internalType: 'uint8', type: 'uint8', indexed: false },
    ],
    name: 'Initialized',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'msgHash',
        internalType: 'bytes32',
        type: 'bytes32',
        indexed: true,
      },
    ],
    name: 'RelayedMessage',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'target',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'sender',
        internalType: 'address',
        type: 'address',
        indexed: false,
      },
      { name: 'message', internalType: 'bytes', type: 'bytes', indexed: false },
      {
        name: 'messageNonce',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      {
        name: 'gasLimit',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
    ],
    name: 'SentMessage',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'sender',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'value',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
    ],
    name: 'SentMessageExtension1',
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'MESSAGE_VERSION',
    outputs: [{ name: '', internalType: 'uint16', type: 'uint16' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'MIN_GAS_CALLDATA_OVERHEAD',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'MIN_GAS_DYNAMIC_OVERHEAD_DENOMINATOR',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'MIN_GAS_DYNAMIC_OVERHEAD_NUMERATOR',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'OTHER_MESSENGER',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'RELAY_CALL_OVERHEAD',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'RELAY_CONSTANT_OVERHEAD',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'RELAY_GAS_CHECK_BUFFER',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'RELAY_RESERVED_GAS',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'pure',
    type: 'function',
    inputs: [
      { name: '_message', internalType: 'bytes', type: 'bytes' },
      { name: '_minGasLimit', internalType: 'uint32', type: 'uint32' },
    ],
    name: 'baseGas',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '', internalType: 'bytes32', type: 'bytes32' }],
    name: 'failedMessages',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'initialize',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'l1CrossDomainMessenger',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'messageNonce',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_nonce', internalType: 'uint256', type: 'uint256' },
      { name: '_sender', internalType: 'address', type: 'address' },
      { name: '_target', internalType: 'address', type: 'address' },
      { name: '_value', internalType: 'uint256', type: 'uint256' },
      { name: '_minGasLimit', internalType: 'uint256', type: 'uint256' },
      { name: '_message', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'relayMessage',
    outputs: [],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_target', internalType: 'address', type: 'address' },
      { name: '_message', internalType: 'bytes', type: 'bytes' },
      { name: '_minGasLimit', internalType: 'uint32', type: 'uint32' },
    ],
    name: 'sendMessage',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '', internalType: 'bytes32', type: 'bytes32' }],
    name: 'successfulMessages',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'version',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'xDomainMessageSender',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
] as const

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export const l2CrossDomainMessengerAddress = {
  420: '0x4200000000000000000000000000000000000007',
} as const

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export const l2CrossDomainMessengerConfig = {
  address: l2CrossDomainMessengerAddress,
  abi: l2CrossDomainMessengerABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// L2ERC721Bridge
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000014)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000014)
 */
export const l2Erc721BridgeABI = [
  {
    stateMutability: 'nonpayable',
    type: 'constructor',
    inputs: [
      { name: '_messenger', internalType: 'address', type: 'address' },
      { name: '_otherBridge', internalType: 'address', type: 'address' },
    ],
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'localToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'remoteToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      { name: 'to', internalType: 'address', type: 'address', indexed: false },
      {
        name: 'tokenId',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      {
        name: 'extraData',
        internalType: 'bytes',
        type: 'bytes',
        indexed: false,
      },
    ],
    name: 'ERC721BridgeFinalized',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'localToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'remoteToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      { name: 'to', internalType: 'address', type: 'address', indexed: false },
      {
        name: 'tokenId',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      {
        name: 'extraData',
        internalType: 'bytes',
        type: 'bytes',
        indexed: false,
      },
    ],
    name: 'ERC721BridgeInitiated',
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_localToken', internalType: 'address', type: 'address' },
      { name: '_remoteToken', internalType: 'address', type: 'address' },
      { name: '_tokenId', internalType: 'uint256', type: 'uint256' },
      { name: '_minGasLimit', internalType: 'uint32', type: 'uint32' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'bridgeERC721',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_localToken', internalType: 'address', type: 'address' },
      { name: '_remoteToken', internalType: 'address', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_tokenId', internalType: 'uint256', type: 'uint256' },
      { name: '_minGasLimit', internalType: 'uint32', type: 'uint32' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'bridgeERC721To',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_localToken', internalType: 'address', type: 'address' },
      { name: '_remoteToken', internalType: 'address', type: 'address' },
      { name: '_from', internalType: 'address', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_tokenId', internalType: 'uint256', type: 'uint256' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'finalizeBridgeERC721',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'messenger',
    outputs: [
      {
        name: '',
        internalType: 'contract CrossDomainMessenger',
        type: 'address',
      },
    ],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'otherBridge',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'version',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
] as const

/**
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000014)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000014)
 */
export const l2Erc721BridgeAddress = {
  10: '0x4200000000000000000000000000000000000014',
  420: '0x4200000000000000000000000000000000000014',
} as const

/**
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000014)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000014)
 */
export const l2Erc721BridgeConfig = {
  address: l2Erc721BridgeAddress,
  abi: l2Erc721BridgeABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// L2OutputOracle
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 */
export const l2OutputOracleABI = [
  {
    stateMutability: 'nonpayable',
    type: 'constructor',
    inputs: [
      { name: '_submissionInterval', internalType: 'uint256', type: 'uint256' },
      { name: '_l2BlockTime', internalType: 'uint256', type: 'uint256' },
      {
        name: '_startingBlockNumber',
        internalType: 'uint256',
        type: 'uint256',
      },
      { name: '_startingTimestamp', internalType: 'uint256', type: 'uint256' },
      { name: '_proposer', internalType: 'address', type: 'address' },
      { name: '_challenger', internalType: 'address', type: 'address' },
      {
        name: '_finalizationPeriodSeconds',
        internalType: 'uint256',
        type: 'uint256',
      },
    ],
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'version', internalType: 'uint8', type: 'uint8', indexed: false },
    ],
    name: 'Initialized',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'outputRoot',
        internalType: 'bytes32',
        type: 'bytes32',
        indexed: true,
      },
      {
        name: 'l2OutputIndex',
        internalType: 'uint256',
        type: 'uint256',
        indexed: true,
      },
      {
        name: 'l2BlockNumber',
        internalType: 'uint256',
        type: 'uint256',
        indexed: true,
      },
      {
        name: 'l1Timestamp',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
    ],
    name: 'OutputProposed',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'prevNextOutputIndex',
        internalType: 'uint256',
        type: 'uint256',
        indexed: true,
      },
      {
        name: 'newNextOutputIndex',
        internalType: 'uint256',
        type: 'uint256',
        indexed: true,
      },
    ],
    name: 'OutputsDeleted',
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'CHALLENGER',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'FINALIZATION_PERIOD_SECONDS',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'L2_BLOCK_TIME',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'PROPOSER',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'SUBMISSION_INTERVAL',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [
      { name: '_l2BlockNumber', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'computeL2Timestamp',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_l2OutputIndex', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'deleteL2Outputs',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [
      { name: '_l2OutputIndex', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'getL2Output',
    outputs: [
      {
        name: '',
        internalType: 'struct Types.OutputProposal',
        type: 'tuple',
        components: [
          { name: 'outputRoot', internalType: 'bytes32', type: 'bytes32' },
          { name: 'timestamp', internalType: 'uint128', type: 'uint128' },
          { name: 'l2BlockNumber', internalType: 'uint128', type: 'uint128' },
        ],
      },
    ],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [
      { name: '_l2BlockNumber', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'getL2OutputAfter',
    outputs: [
      {
        name: '',
        internalType: 'struct Types.OutputProposal',
        type: 'tuple',
        components: [
          { name: 'outputRoot', internalType: 'bytes32', type: 'bytes32' },
          { name: 'timestamp', internalType: 'uint128', type: 'uint128' },
          { name: 'l2BlockNumber', internalType: 'uint128', type: 'uint128' },
        ],
      },
    ],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [
      { name: '_l2BlockNumber', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'getL2OutputIndexAfter',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      {
        name: '_startingBlockNumber',
        internalType: 'uint256',
        type: 'uint256',
      },
      { name: '_startingTimestamp', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'initialize',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'latestBlockNumber',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'latestOutputIndex',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'nextBlockNumber',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'nextOutputIndex',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_outputRoot', internalType: 'bytes32', type: 'bytes32' },
      { name: '_l2BlockNumber', internalType: 'uint256', type: 'uint256' },
      { name: '_l1BlockHash', internalType: 'bytes32', type: 'bytes32' },
      { name: '_l1BlockNumber', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'proposeL2Output',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'startingBlockNumber',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'startingTimestamp',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'version',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
] as const

/**
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 */
export const l2OutputOracleAddress = {
  1: '0xdfe97868233d1aa22e815a266982f2cf17685a27',
} as const

/**
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 */
export const l2OutputOracleConfig = {
  address: l2OutputOracleAddress,
  abi: l2OutputOracleABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// L2OutputOracle_goerli
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export const l2OutputOracleGoerliABI = [
  {
    stateMutability: 'nonpayable',
    type: 'constructor',
    inputs: [
      { name: '_submissionInterval', internalType: 'uint256', type: 'uint256' },
      { name: '_l2BlockTime', internalType: 'uint256', type: 'uint256' },
      {
        name: '_finalizationPeriodSeconds',
        internalType: 'uint256',
        type: 'uint256',
      },
    ],
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'version', internalType: 'uint8', type: 'uint8', indexed: false },
    ],
    name: 'Initialized',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'outputRoot',
        internalType: 'bytes32',
        type: 'bytes32',
        indexed: true,
      },
      {
        name: 'l2OutputIndex',
        internalType: 'uint256',
        type: 'uint256',
        indexed: true,
      },
      {
        name: 'l2BlockNumber',
        internalType: 'uint256',
        type: 'uint256',
        indexed: true,
      },
      {
        name: 'l1Timestamp',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
    ],
    name: 'OutputProposed',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'prevNextOutputIndex',
        internalType: 'uint256',
        type: 'uint256',
        indexed: true,
      },
      {
        name: 'newNextOutputIndex',
        internalType: 'uint256',
        type: 'uint256',
        indexed: true,
      },
    ],
    name: 'OutputsDeleted',
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'challenger',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [
      { name: '_l2BlockNumber', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'computeL2Timestamp',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_l2OutputIndex', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'deleteL2Outputs',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'finalizationPeriodSeconds',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [
      { name: '_l2OutputIndex', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'getL2Output',
    outputs: [
      {
        name: '',
        internalType: 'struct Types.OutputProposal',
        type: 'tuple',
        components: [
          { name: 'outputRoot', internalType: 'bytes32', type: 'bytes32' },
          { name: 'timestamp', internalType: 'uint128', type: 'uint128' },
          { name: 'l2BlockNumber', internalType: 'uint128', type: 'uint128' },
        ],
      },
    ],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [
      { name: '_l2BlockNumber', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'getL2OutputAfter',
    outputs: [
      {
        name: '',
        internalType: 'struct Types.OutputProposal',
        type: 'tuple',
        components: [
          { name: 'outputRoot', internalType: 'bytes32', type: 'bytes32' },
          { name: 'timestamp', internalType: 'uint128', type: 'uint128' },
          { name: 'l2BlockNumber', internalType: 'uint128', type: 'uint128' },
        ],
      },
    ],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [
      { name: '_l2BlockNumber', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'getL2OutputIndexAfter',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      {
        name: '_startingBlockNumber',
        internalType: 'uint256',
        type: 'uint256',
      },
      { name: '_startingTimestamp', internalType: 'uint256', type: 'uint256' },
      { name: '_proposer', internalType: 'address', type: 'address' },
      { name: '_challenger', internalType: 'address', type: 'address' },
    ],
    name: 'initialize',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'l2BlockTime',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'latestBlockNumber',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'latestOutputIndex',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'nextBlockNumber',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'nextOutputIndex',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_outputRoot', internalType: 'bytes32', type: 'bytes32' },
      { name: '_l2BlockNumber', internalType: 'uint256', type: 'uint256' },
      { name: '_l1BlockHash', internalType: 'bytes32', type: 'bytes32' },
      { name: '_l1BlockNumber', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'proposeL2Output',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'proposer',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'startingBlockNumber',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'startingTimestamp',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'submissionInterval',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'version',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
] as const

/**
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export const l2OutputOracleGoerliAddress = {
  5: '0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0',
} as const

/**
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export const l2OutputOracleGoerliConfig = {
  address: l2OutputOracleGoerliAddress,
  abi: l2OutputOracleGoerliABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// L2StandardBridge
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export const l2StandardBridgeABI = [
  {
    stateMutability: 'nonpayable',
    type: 'constructor',
    inputs: [
      {
        name: '_otherBridge',
        internalType: 'address payable',
        type: 'address',
      },
    ],
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'l1Token',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'l2Token',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      { name: 'to', internalType: 'address', type: 'address', indexed: false },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      {
        name: 'extraData',
        internalType: 'bytes',
        type: 'bytes',
        indexed: false,
      },
    ],
    name: 'DepositFinalized',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'localToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'remoteToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      { name: 'to', internalType: 'address', type: 'address', indexed: false },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      {
        name: 'extraData',
        internalType: 'bytes',
        type: 'bytes',
        indexed: false,
      },
    ],
    name: 'ERC20BridgeFinalized',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'localToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'remoteToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      { name: 'to', internalType: 'address', type: 'address', indexed: false },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      {
        name: 'extraData',
        internalType: 'bytes',
        type: 'bytes',
        indexed: false,
      },
    ],
    name: 'ERC20BridgeInitiated',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      { name: 'to', internalType: 'address', type: 'address', indexed: true },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      {
        name: 'extraData',
        internalType: 'bytes',
        type: 'bytes',
        indexed: false,
      },
    ],
    name: 'ETHBridgeFinalized',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      { name: 'to', internalType: 'address', type: 'address', indexed: true },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      {
        name: 'extraData',
        internalType: 'bytes',
        type: 'bytes',
        indexed: false,
      },
    ],
    name: 'ETHBridgeInitiated',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'l1Token',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'l2Token',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      { name: 'to', internalType: 'address', type: 'address', indexed: false },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      {
        name: 'extraData',
        internalType: 'bytes',
        type: 'bytes',
        indexed: false,
      },
    ],
    name: 'WithdrawalInitiated',
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'OTHER_BRIDGE',
    outputs: [
      { name: '', internalType: 'contract StandardBridge', type: 'address' },
    ],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_localToken', internalType: 'address', type: 'address' },
      { name: '_remoteToken', internalType: 'address', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
      { name: '_minGasLimit', internalType: 'uint32', type: 'uint32' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'bridgeERC20',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_localToken', internalType: 'address', type: 'address' },
      { name: '_remoteToken', internalType: 'address', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
      { name: '_minGasLimit', internalType: 'uint32', type: 'uint32' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'bridgeERC20To',
    outputs: [],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_minGasLimit', internalType: 'uint32', type: 'uint32' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'bridgeETH',
    outputs: [],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_minGasLimit', internalType: 'uint32', type: 'uint32' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'bridgeETHTo',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [
      { name: '', internalType: 'address', type: 'address' },
      { name: '', internalType: 'address', type: 'address' },
    ],
    name: 'deposits',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_localToken', internalType: 'address', type: 'address' },
      { name: '_remoteToken', internalType: 'address', type: 'address' },
      { name: '_from', internalType: 'address', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'finalizeBridgeERC20',
    outputs: [],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_from', internalType: 'address', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'finalizeBridgeETH',
    outputs: [],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_l1Token', internalType: 'address', type: 'address' },
      { name: '_l2Token', internalType: 'address', type: 'address' },
      { name: '_from', internalType: 'address', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'finalizeDeposit',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'l1TokenBridge',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'messenger',
    outputs: [
      {
        name: '',
        internalType: 'contract CrossDomainMessenger',
        type: 'address',
      },
    ],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'version',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_l2Token', internalType: 'address', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
      { name: '_minGasLimit', internalType: 'uint32', type: 'uint32' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'withdraw',
    outputs: [],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_l2Token', internalType: 'address', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
      { name: '_minGasLimit', internalType: 'uint32', type: 'uint32' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'withdrawTo',
    outputs: [],
  },
  { stateMutability: 'payable', type: 'receive' },
] as const

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export const l2StandardBridgeAddress = {
  420: '0x4200000000000000000000000000000000000010',
} as const

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export const l2StandardBridgeConfig = {
  address: l2StandardBridgeAddress,
  abi: l2StandardBridgeABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// L2ToL1MessagePasser
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000016)
 */
export const l2ToL1MessagePasserABI = [
  { stateMutability: 'nonpayable', type: 'constructor', inputs: [] },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'nonce',
        internalType: 'uint256',
        type: 'uint256',
        indexed: true,
      },
      {
        name: 'sender',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'target',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'value',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      {
        name: 'gasLimit',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      { name: 'data', internalType: 'bytes', type: 'bytes', indexed: false },
      {
        name: 'withdrawalHash',
        internalType: 'bytes32',
        type: 'bytes32',
        indexed: false,
      },
    ],
    name: 'MessagePassed',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: true,
      },
    ],
    name: 'WithdrawerBalanceBurnt',
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'MESSAGE_VERSION',
    outputs: [{ name: '', internalType: 'uint16', type: 'uint16' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'burn',
    outputs: [],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_target', internalType: 'address', type: 'address' },
      { name: '_gasLimit', internalType: 'uint256', type: 'uint256' },
      { name: '_data', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'initiateWithdrawal',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'messageNonce',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '', internalType: 'bytes32', type: 'bytes32' }],
    name: 'sentMessages',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'version',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
  { stateMutability: 'payable', type: 'receive' },
] as const

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000016)
 */
export const l2ToL1MessagePasserAddress = {
  420: '0x4200000000000000000000000000000000000016',
} as const

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000016)
 */
export const l2ToL1MessagePasserConfig = {
  address: l2ToL1MessagePasserAddress,
  abi: l2ToL1MessagePasserABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// MintManager
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x5C4e7Ba1E219E47948e6e3F55019A647bA501005)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x038a8825A3C3B0c08d52Cc76E5E361953Cf6Dc76)
 */
export const mintManagerABI = [
  {
    stateMutability: 'nonpayable',
    type: 'constructor',
    inputs: [
      { name: '_upgrader', internalType: 'address', type: 'address' },
      { name: '_governanceToken', internalType: 'address', type: 'address' },
    ],
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'previousOwner',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'newOwner',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
    ],
    name: 'OwnershipTransferred',
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'DENOMINATOR',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'MINT_CAP',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'MINT_PERIOD',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'governanceToken',
    outputs: [
      { name: '', internalType: 'contract GovernanceToken', type: 'address' },
    ],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_account', internalType: 'address', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'mint',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'mintPermittedAfter',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'owner',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'renounceOwnership',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: 'newOwner', internalType: 'address', type: 'address' }],
    name: 'transferOwnership',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_newMintManager', internalType: 'address', type: 'address' },
    ],
    name: 'upgrade',
    outputs: [],
  },
] as const

/**
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x5C4e7Ba1E219E47948e6e3F55019A647bA501005)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x038a8825A3C3B0c08d52Cc76E5E361953Cf6Dc76)
 */
export const mintManagerAddress = {
  10: '0x5C4e7Ba1E219E47948e6e3F55019A647bA501005',
  420: '0x038a8825A3C3B0c08d52Cc76E5E361953Cf6Dc76',
} as const

/**
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x5C4e7Ba1E219E47948e6e3F55019A647bA501005)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x038a8825A3C3B0c08d52Cc76E5E361953Cf6Dc76)
 */
export const mintManagerConfig = {
  address: mintManagerAddress,
  abi: mintManagerABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// OptimismMintableERC20Factory
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export const optimismMintableErc20FactoryABI = [
  {
    stateMutability: 'nonpayable',
    type: 'constructor',
    inputs: [{ name: '_bridge', internalType: 'address', type: 'address' }],
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'localToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'remoteToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'deployer',
        internalType: 'address',
        type: 'address',
        indexed: false,
      },
    ],
    name: 'OptimismMintableERC20Created',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'remoteToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'localToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
    ],
    name: 'StandardL2TokenCreated',
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'BRIDGE',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_remoteToken', internalType: 'address', type: 'address' },
      { name: '_name', internalType: 'string', type: 'string' },
      { name: '_symbol', internalType: 'string', type: 'string' },
    ],
    name: 'createOptimismMintableERC20',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_remoteToken', internalType: 'address', type: 'address' },
      { name: '_name', internalType: 'string', type: 'string' },
      { name: '_symbol', internalType: 'string', type: 'string' },
    ],
    name: 'createStandardL2Token',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'version',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
] as const

/**
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export const optimismMintableErc20FactoryAddress = {
  1: '0x4200000000000000000000000000000000000012',
} as const

/**
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export const optimismMintableErc20FactoryConfig = {
  address: optimismMintableErc20FactoryAddress,
  abi: optimismMintableErc20FactoryABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// OptimismMintableERC20Factory_goerli
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export const optimismMintableErc20FactoryGoerliABI = [
  { stateMutability: 'nonpayable', type: 'constructor', inputs: [] },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'version', internalType: 'uint8', type: 'uint8', indexed: false },
    ],
    name: 'Initialized',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'localToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'remoteToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'deployer',
        internalType: 'address',
        type: 'address',
        indexed: false,
      },
    ],
    name: 'OptimismMintableERC20Created',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'remoteToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'localToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
    ],
    name: 'StandardL2TokenCreated',
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'bridge',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_remoteToken', internalType: 'address', type: 'address' },
      { name: '_name', internalType: 'string', type: 'string' },
      { name: '_symbol', internalType: 'string', type: 'string' },
    ],
    name: 'createOptimismMintableERC20',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_remoteToken', internalType: 'address', type: 'address' },
      { name: '_name', internalType: 'string', type: 'string' },
      { name: '_symbol', internalType: 'string', type: 'string' },
      { name: '_decimals', internalType: 'uint8', type: 'uint8' },
    ],
    name: 'createOptimismMintableERC20WithDecimals',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_remoteToken', internalType: 'address', type: 'address' },
      { name: '_name', internalType: 'string', type: 'string' },
      { name: '_symbol', internalType: 'string', type: 'string' },
    ],
    name: 'createStandardL2Token',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: '_bridge', internalType: 'address', type: 'address' }],
    name: 'initialize',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'version',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
] as const

/**
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export const optimismMintableErc20FactoryGoerliAddress = {
  5: '0x4200000000000000000000000000000000000012',
} as const

/**
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export const optimismMintableErc20FactoryGoerliConfig = {
  address: optimismMintableErc20FactoryGoerliAddress,
  abi: optimismMintableErc20FactoryGoerliABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// OptimismMintableERC20Factory_optimism-goerli
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export const optimismMintableErc20FactoryOptimismGoerliABI = [
  {
    stateMutability: 'nonpayable',
    type: 'constructor',
    inputs: [{ name: '_bridge', internalType: 'address', type: 'address' }],
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'localToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'remoteToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'deployer',
        internalType: 'address',
        type: 'address',
        indexed: false,
      },
    ],
    name: 'OptimismMintableERC20Created',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'remoteToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'localToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
    ],
    name: 'StandardL2TokenCreated',
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'BRIDGE',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_remoteToken', internalType: 'address', type: 'address' },
      { name: '_name', internalType: 'string', type: 'string' },
      { name: '_symbol', internalType: 'string', type: 'string' },
    ],
    name: 'createOptimismMintableERC20',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_remoteToken', internalType: 'address', type: 'address' },
      { name: '_name', internalType: 'string', type: 'string' },
      { name: '_symbol', internalType: 'string', type: 'string' },
    ],
    name: 'createStandardL2Token',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'version',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
] as const

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export const optimismMintableErc20FactoryOptimismGoerliAddress = {
  420: '0x4200000000000000000000000000000000000012',
} as const

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export const optimismMintableErc20FactoryOptimismGoerliConfig = {
  address: optimismMintableErc20FactoryOptimismGoerliAddress,
  abi: optimismMintableErc20FactoryOptimismGoerliABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// OptimismMintableERC721Factory
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000017)
 */
export const optimismMintableErc721FactoryABI = [
  {
    stateMutability: 'nonpayable',
    type: 'constructor',
    inputs: [
      { name: '_bridge', internalType: 'address', type: 'address' },
      { name: '_remoteChainId', internalType: 'uint256', type: 'uint256' },
    ],
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'localToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'remoteToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'deployer',
        internalType: 'address',
        type: 'address',
        indexed: false,
      },
    ],
    name: 'OptimismMintableERC721Created',
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'bridge',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_remoteToken', internalType: 'address', type: 'address' },
      { name: '_name', internalType: 'string', type: 'string' },
      { name: '_symbol', internalType: 'string', type: 'string' },
    ],
    name: 'createOptimismMintableERC721',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '', internalType: 'address', type: 'address' }],
    name: 'isOptimismMintableERC721',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'remoteChainId',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'version',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
] as const

/**
 * [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000017)
 */
export const optimismMintableErc721FactoryAddress = {
  10: '0x4200000000000000000000000000000000000017',
} as const

/**
 * [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000017)
 */
export const optimismMintableErc721FactoryConfig = {
  address: optimismMintableErc721FactoryAddress,
  abi: optimismMintableErc721FactoryABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// OptimismMintableERC721Factory_optimism-goerli
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000017)
 */
export const optimismMintableErc721FactoryOptimismGoerliABI = [
  {
    stateMutability: 'nonpayable',
    type: 'constructor',
    inputs: [
      { name: '_bridge', internalType: 'address', type: 'address' },
      { name: '_remoteChainId', internalType: 'uint256', type: 'uint256' },
    ],
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'localToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'remoteToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'deployer',
        internalType: 'address',
        type: 'address',
        indexed: false,
      },
    ],
    name: 'OptimismMintableERC721Created',
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'BRIDGE',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'REMOTE_CHAIN_ID',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_remoteToken', internalType: 'address', type: 'address' },
      { name: '_name', internalType: 'string', type: 'string' },
      { name: '_symbol', internalType: 'string', type: 'string' },
    ],
    name: 'createOptimismMintableERC721',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '', internalType: 'address', type: 'address' }],
    name: 'isOptimismMintableERC721',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'version',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
] as const

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000017)
 */
export const optimismMintableErc721FactoryOptimismGoerliAddress = {
  420: '0x4200000000000000000000000000000000000017',
} as const

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000017)
 */
export const optimismMintableErc721FactoryOptimismGoerliConfig = {
  address: optimismMintableErc721FactoryOptimismGoerliAddress,
  abi: optimismMintableErc721FactoryOptimismGoerliABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// OptimismPortal
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 */
export const optimismPortalABI = [
  {
    stateMutability: 'nonpayable',
    type: 'constructor',
    inputs: [
      {
        name: '_l2Oracle',
        internalType: 'contract L2OutputOracle',
        type: 'address',
      },
      { name: '_guardian', internalType: 'address', type: 'address' },
      { name: '_paused', internalType: 'bool', type: 'bool' },
      {
        name: '_config',
        internalType: 'contract SystemConfig',
        type: 'address',
      },
    ],
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'version', internalType: 'uint8', type: 'uint8', indexed: false },
    ],
    name: 'Initialized',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'account',
        internalType: 'address',
        type: 'address',
        indexed: false,
      },
    ],
    name: 'Paused',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      { name: 'to', internalType: 'address', type: 'address', indexed: true },
      {
        name: 'version',
        internalType: 'uint256',
        type: 'uint256',
        indexed: true,
      },
      {
        name: 'opaqueData',
        internalType: 'bytes',
        type: 'bytes',
        indexed: false,
      },
    ],
    name: 'TransactionDeposited',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'account',
        internalType: 'address',
        type: 'address',
        indexed: false,
      },
    ],
    name: 'Unpaused',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'withdrawalHash',
        internalType: 'bytes32',
        type: 'bytes32',
        indexed: true,
      },
      { name: 'success', internalType: 'bool', type: 'bool', indexed: false },
    ],
    name: 'WithdrawalFinalized',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'withdrawalHash',
        internalType: 'bytes32',
        type: 'bytes32',
        indexed: true,
      },
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      { name: 'to', internalType: 'address', type: 'address', indexed: true },
    ],
    name: 'WithdrawalProven',
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'GUARDIAN',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'L2_ORACLE',
    outputs: [
      { name: '', internalType: 'contract L2OutputOracle', type: 'address' },
    ],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'SYSTEM_CONFIG',
    outputs: [
      { name: '', internalType: 'contract SystemConfig', type: 'address' },
    ],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_value', internalType: 'uint256', type: 'uint256' },
      { name: '_gasLimit', internalType: 'uint64', type: 'uint64' },
      { name: '_isCreation', internalType: 'bool', type: 'bool' },
      { name: '_data', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'depositTransaction',
    outputs: [],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [],
    name: 'donateETH',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      {
        name: '_tx',
        internalType: 'struct Types.WithdrawalTransaction',
        type: 'tuple',
        components: [
          { name: 'nonce', internalType: 'uint256', type: 'uint256' },
          { name: 'sender', internalType: 'address', type: 'address' },
          { name: 'target', internalType: 'address', type: 'address' },
          { name: 'value', internalType: 'uint256', type: 'uint256' },
          { name: 'gasLimit', internalType: 'uint256', type: 'uint256' },
          { name: 'data', internalType: 'bytes', type: 'bytes' },
        ],
      },
    ],
    name: 'finalizeWithdrawalTransaction',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '', internalType: 'bytes32', type: 'bytes32' }],
    name: 'finalizedWithdrawals',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: '_paused', internalType: 'bool', type: 'bool' }],
    name: 'initialize',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [
      { name: '_l2OutputIndex', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'isOutputFinalized',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'l2Sender',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'pure',
    type: 'function',
    inputs: [{ name: '_byteCount', internalType: 'uint64', type: 'uint64' }],
    name: 'minimumGasLimit',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'params',
    outputs: [
      { name: 'prevBaseFee', internalType: 'uint128', type: 'uint128' },
      { name: 'prevBoughtGas', internalType: 'uint64', type: 'uint64' },
      { name: 'prevBlockNum', internalType: 'uint64', type: 'uint64' },
    ],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'pause',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'paused',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      {
        name: '_tx',
        internalType: 'struct Types.WithdrawalTransaction',
        type: 'tuple',
        components: [
          { name: 'nonce', internalType: 'uint256', type: 'uint256' },
          { name: 'sender', internalType: 'address', type: 'address' },
          { name: 'target', internalType: 'address', type: 'address' },
          { name: 'value', internalType: 'uint256', type: 'uint256' },
          { name: 'gasLimit', internalType: 'uint256', type: 'uint256' },
          { name: 'data', internalType: 'bytes', type: 'bytes' },
        ],
      },
      { name: '_l2OutputIndex', internalType: 'uint256', type: 'uint256' },
      {
        name: '_outputRootProof',
        internalType: 'struct Types.OutputRootProof',
        type: 'tuple',
        components: [
          { name: 'version', internalType: 'bytes32', type: 'bytes32' },
          { name: 'stateRoot', internalType: 'bytes32', type: 'bytes32' },
          {
            name: 'messagePasserStorageRoot',
            internalType: 'bytes32',
            type: 'bytes32',
          },
          { name: 'latestBlockhash', internalType: 'bytes32', type: 'bytes32' },
        ],
      },
      { name: '_withdrawalProof', internalType: 'bytes[]', type: 'bytes[]' },
    ],
    name: 'proveWithdrawalTransaction',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '', internalType: 'bytes32', type: 'bytes32' }],
    name: 'provenWithdrawals',
    outputs: [
      { name: 'outputRoot', internalType: 'bytes32', type: 'bytes32' },
      { name: 'timestamp', internalType: 'uint128', type: 'uint128' },
      { name: 'l2OutputIndex', internalType: 'uint128', type: 'uint128' },
    ],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'unpause',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'version',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
  { stateMutability: 'payable', type: 'receive' },
] as const

/**
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 */
export const optimismPortalAddress = {
  1: '0xbEb5Fc579115071764c7423A4f12eDde41f106Ed',
} as const

/**
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 */
export const optimismPortalConfig = {
  address: optimismPortalAddress,
  abi: optimismPortalABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// OptimismPortal_goerli
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5b47E1A08Ea6d985D6649300584e6722Ec4B1383)
 */
export const optimismPortalGoerliABI = [
  { stateMutability: 'nonpayable', type: 'constructor', inputs: [] },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'version', internalType: 'uint8', type: 'uint8', indexed: false },
    ],
    name: 'Initialized',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'account',
        internalType: 'address',
        type: 'address',
        indexed: false,
      },
    ],
    name: 'Paused',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      { name: 'to', internalType: 'address', type: 'address', indexed: true },
      {
        name: 'version',
        internalType: 'uint256',
        type: 'uint256',
        indexed: true,
      },
      {
        name: 'opaqueData',
        internalType: 'bytes',
        type: 'bytes',
        indexed: false,
      },
    ],
    name: 'TransactionDeposited',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'account',
        internalType: 'address',
        type: 'address',
        indexed: false,
      },
    ],
    name: 'Unpaused',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'withdrawalHash',
        internalType: 'bytes32',
        type: 'bytes32',
        indexed: true,
      },
      { name: 'success', internalType: 'bool', type: 'bool', indexed: false },
    ],
    name: 'WithdrawalFinalized',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'withdrawalHash',
        internalType: 'bytes32',
        type: 'bytes32',
        indexed: true,
      },
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      { name: 'to', internalType: 'address', type: 'address', indexed: true },
    ],
    name: 'WithdrawalProven',
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_value', internalType: 'uint256', type: 'uint256' },
      { name: '_gasLimit', internalType: 'uint64', type: 'uint64' },
      { name: '_isCreation', internalType: 'bool', type: 'bool' },
      { name: '_data', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'depositTransaction',
    outputs: [],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [],
    name: 'donateETH',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      {
        name: '_tx',
        internalType: 'struct Types.WithdrawalTransaction',
        type: 'tuple',
        components: [
          { name: 'nonce', internalType: 'uint256', type: 'uint256' },
          { name: 'sender', internalType: 'address', type: 'address' },
          { name: 'target', internalType: 'address', type: 'address' },
          { name: 'value', internalType: 'uint256', type: 'uint256' },
          { name: 'gasLimit', internalType: 'uint256', type: 'uint256' },
          { name: 'data', internalType: 'bytes', type: 'bytes' },
        ],
      },
    ],
    name: 'finalizeWithdrawalTransaction',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '', internalType: 'bytes32', type: 'bytes32' }],
    name: 'finalizedWithdrawals',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'guardian',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      {
        name: '_l2Oracle',
        internalType: 'contract L2OutputOracle',
        type: 'address',
      },
      { name: '_guardian', internalType: 'address', type: 'address' },
      {
        name: '_systemConfig',
        internalType: 'contract SystemConfig',
        type: 'address',
      },
      { name: '_paused', internalType: 'bool', type: 'bool' },
    ],
    name: 'initialize',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [
      { name: '_l2OutputIndex', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'isOutputFinalized',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'l2Oracle',
    outputs: [
      { name: '', internalType: 'contract L2OutputOracle', type: 'address' },
    ],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'l2Sender',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'pure',
    type: 'function',
    inputs: [{ name: '_byteCount', internalType: 'uint64', type: 'uint64' }],
    name: 'minimumGasLimit',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'params',
    outputs: [
      { name: 'prevBaseFee', internalType: 'uint128', type: 'uint128' },
      { name: 'prevBoughtGas', internalType: 'uint64', type: 'uint64' },
      { name: 'prevBlockNum', internalType: 'uint64', type: 'uint64' },
    ],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'pause',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'paused',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      {
        name: '_tx',
        internalType: 'struct Types.WithdrawalTransaction',
        type: 'tuple',
        components: [
          { name: 'nonce', internalType: 'uint256', type: 'uint256' },
          { name: 'sender', internalType: 'address', type: 'address' },
          { name: 'target', internalType: 'address', type: 'address' },
          { name: 'value', internalType: 'uint256', type: 'uint256' },
          { name: 'gasLimit', internalType: 'uint256', type: 'uint256' },
          { name: 'data', internalType: 'bytes', type: 'bytes' },
        ],
      },
      { name: '_l2OutputIndex', internalType: 'uint256', type: 'uint256' },
      {
        name: '_outputRootProof',
        internalType: 'struct Types.OutputRootProof',
        type: 'tuple',
        components: [
          { name: 'version', internalType: 'bytes32', type: 'bytes32' },
          { name: 'stateRoot', internalType: 'bytes32', type: 'bytes32' },
          {
            name: 'messagePasserStorageRoot',
            internalType: 'bytes32',
            type: 'bytes32',
          },
          { name: 'latestBlockhash', internalType: 'bytes32', type: 'bytes32' },
        ],
      },
      { name: '_withdrawalProof', internalType: 'bytes[]', type: 'bytes[]' },
    ],
    name: 'proveWithdrawalTransaction',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '', internalType: 'bytes32', type: 'bytes32' }],
    name: 'provenWithdrawals',
    outputs: [
      { name: 'outputRoot', internalType: 'bytes32', type: 'bytes32' },
      { name: 'timestamp', internalType: 'uint128', type: 'uint128' },
      { name: 'l2OutputIndex', internalType: 'uint128', type: 'uint128' },
    ],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'systemConfig',
    outputs: [
      { name: '', internalType: 'contract SystemConfig', type: 'address' },
    ],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'unpause',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'version',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
  { stateMutability: 'payable', type: 'receive' },
] as const

/**
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5b47E1A08Ea6d985D6649300584e6722Ec4B1383)
 */
export const optimismPortalGoerliAddress = {
  5: '0x5b47E1A08Ea6d985D6649300584e6722Ec4B1383',
} as const

/**
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5b47E1A08Ea6d985D6649300584e6722Ec4B1383)
 */
export const optimismPortalGoerliConfig = {
  address: optimismPortalGoerliAddress,
  abi: optimismPortalGoerliABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Optimist
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 */
export const optimistABI = [
  {
    stateMutability: 'nonpayable',
    type: 'constructor',
    inputs: [
      { name: '_name', internalType: 'string', type: 'string' },
      { name: '_symbol', internalType: 'string', type: 'string' },
      { name: '_baseURIAttestor', internalType: 'address', type: 'address' },
      {
        name: '_attestationStation',
        internalType: 'contract AttestationStation',
        type: 'address',
      },
      {
        name: '_optimistAllowlist',
        internalType: 'contract OptimistAllowlist',
        type: 'address',
      },
    ],
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'owner',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'approved',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'tokenId',
        internalType: 'uint256',
        type: 'uint256',
        indexed: true,
      },
    ],
    name: 'Approval',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'owner',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'operator',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      { name: 'approved', internalType: 'bool', type: 'bool', indexed: false },
    ],
    name: 'ApprovalForAll',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'version', internalType: 'uint8', type: 'uint8', indexed: false },
    ],
    name: 'Initialized',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      { name: 'to', internalType: 'address', type: 'address', indexed: true },
      {
        name: 'tokenId',
        internalType: 'uint256',
        type: 'uint256',
        indexed: true,
      },
    ],
    name: 'Transfer',
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'ATTESTATION_STATION',
    outputs: [
      {
        name: '',
        internalType: 'contract AttestationStation',
        type: 'address',
      },
    ],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'BASE_URI_ATTESTATION_KEY',
    outputs: [{ name: '', internalType: 'bytes32', type: 'bytes32' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'BASE_URI_ATTESTOR',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'OPTIMIST_ALLOWLIST',
    outputs: [
      { name: '', internalType: 'contract OptimistAllowlist', type: 'address' },
    ],
  },
  {
    stateMutability: 'pure',
    type: 'function',
    inputs: [
      { name: '', internalType: 'address', type: 'address' },
      { name: '', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'approve',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: 'owner', internalType: 'address', type: 'address' }],
    name: 'balanceOf',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'baseURI',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: 'tokenId', internalType: 'uint256', type: 'uint256' }],
    name: 'burn',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: 'tokenId', internalType: 'uint256', type: 'uint256' }],
    name: 'getApproved',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_name', internalType: 'string', type: 'string' },
      { name: '_symbol', internalType: 'string', type: 'string' },
    ],
    name: 'initialize',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [
      { name: 'owner', internalType: 'address', type: 'address' },
      { name: 'operator', internalType: 'address', type: 'address' },
    ],
    name: 'isApprovedForAll',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '_recipient', internalType: 'address', type: 'address' }],
    name: 'isOnAllowList',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: '_recipient', internalType: 'address', type: 'address' }],
    name: 'mint',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'name',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: 'tokenId', internalType: 'uint256', type: 'uint256' }],
    name: 'ownerOf',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: 'from', internalType: 'address', type: 'address' },
      { name: 'to', internalType: 'address', type: 'address' },
      { name: 'tokenId', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'safeTransferFrom',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: 'from', internalType: 'address', type: 'address' },
      { name: 'to', internalType: 'address', type: 'address' },
      { name: 'tokenId', internalType: 'uint256', type: 'uint256' },
      { name: 'data', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'safeTransferFrom',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '', internalType: 'address', type: 'address' },
      { name: '', internalType: 'bool', type: 'bool' },
    ],
    name: 'setApprovalForAll',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: 'interfaceId', internalType: 'bytes4', type: 'bytes4' }],
    name: 'supportsInterface',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'symbol',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
  {
    stateMutability: 'pure',
    type: 'function',
    inputs: [{ name: '_owner', internalType: 'address', type: 'address' }],
    name: 'tokenIdOfAddress',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '_tokenId', internalType: 'uint256', type: 'uint256' }],
    name: 'tokenURI',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: 'from', internalType: 'address', type: 'address' },
      { name: 'to', internalType: 'address', type: 'address' },
      { name: 'tokenId', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'transferFrom',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'version',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
] as const

/**
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 */
export const optimistAddress = {
  10: '0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5',
  420: '0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5',
} as const

/**
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 */
export const optimistConfig = {
  address: optimistAddress,
  abi: optimistABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// OptimistAllowlist
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x482b1945D58f2E9Db0CEbe13c7fcFc6876b41180)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x482b1945D58f2E9Db0CEbe13c7fcFc6876b41180)
 */
export const optimistAllowlistABI = [
  {
    stateMutability: 'nonpayable',
    type: 'constructor',
    inputs: [
      {
        name: '_attestationStation',
        internalType: 'contract AttestationStation',
        type: 'address',
      },
      { name: '_allowlistAttestor', internalType: 'address', type: 'address' },
      {
        name: '_coinbaseQuestAttestor',
        internalType: 'address',
        type: 'address',
      },
      { name: '_optimistInviter', internalType: 'address', type: 'address' },
    ],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'ALLOWLIST_ATTESTOR',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'ATTESTATION_STATION',
    outputs: [
      {
        name: '',
        internalType: 'contract AttestationStation',
        type: 'address',
      },
    ],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'COINBASE_QUEST_ATTESTOR',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'COINBASE_QUEST_ELIGIBLE_ATTESTATION_KEY',
    outputs: [{ name: '', internalType: 'bytes32', type: 'bytes32' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'OPTIMIST_CAN_MINT_ATTESTATION_KEY',
    outputs: [{ name: '', internalType: 'bytes32', type: 'bytes32' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'OPTIMIST_INVITER',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '_claimer', internalType: 'address', type: 'address' }],
    name: 'isAllowedToMint',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'version',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
] as const

/**
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x482b1945D58f2E9Db0CEbe13c7fcFc6876b41180)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x482b1945D58f2E9Db0CEbe13c7fcFc6876b41180)
 */
export const optimistAllowlistAddress = {
  10: '0x482b1945D58f2E9Db0CEbe13c7fcFc6876b41180',
  420: '0x482b1945D58f2E9Db0CEbe13c7fcFc6876b41180',
} as const

/**
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x482b1945D58f2E9Db0CEbe13c7fcFc6876b41180)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x482b1945D58f2E9Db0CEbe13c7fcFc6876b41180)
 */
export const optimistAllowlistConfig = {
  address: optimistAllowlistAddress,
  abi: optimistAllowlistABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// OptimistInviter
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 */
export const optimistInviterABI = [
  {
    stateMutability: 'nonpayable',
    type: 'constructor',
    inputs: [
      { name: '_inviteGranter', internalType: 'address', type: 'address' },
      {
        name: '_attestationStation',
        internalType: 'contract AttestationStation',
        type: 'address',
      },
    ],
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'version', internalType: 'uint8', type: 'uint8', indexed: false },
    ],
    name: 'Initialized',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'issuer',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'claimer',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
    ],
    name: 'InviteClaimed',
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'ATTESTATION_STATION',
    outputs: [
      {
        name: '',
        internalType: 'contract AttestationStation',
        type: 'address',
      },
    ],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'CAN_INVITE_ATTESTATION_KEY',
    outputs: [{ name: '', internalType: 'bytes32', type: 'bytes32' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'CLAIMABLE_INVITE_TYPEHASH',
    outputs: [{ name: '', internalType: 'bytes32', type: 'bytes32' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'EIP712_VERSION',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'INVITE_GRANTER',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'MIN_COMMITMENT_PERIOD',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_claimer', internalType: 'address', type: 'address' },
      {
        name: '_claimableInvite',
        internalType: 'struct OptimistInviter.ClaimableInvite',
        type: 'tuple',
        components: [
          { name: 'issuer', internalType: 'address', type: 'address' },
          { name: 'nonce', internalType: 'bytes32', type: 'bytes32' },
        ],
      },
      { name: '_signature', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'claimInvite',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: '_commitment', internalType: 'bytes32', type: 'bytes32' }],
    name: 'commitInvite',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '', internalType: 'bytes32', type: 'bytes32' }],
    name: 'commitmentTimestamps',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: '_name', internalType: 'string', type: 'string' }],
    name: 'initialize',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '', internalType: 'address', type: 'address' }],
    name: 'inviteCounts',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_accounts', internalType: 'address[]', type: 'address[]' },
      { name: '_inviteCount', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'setInviteCounts',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [
      { name: '', internalType: 'address', type: 'address' },
      { name: '', internalType: 'bytes32', type: 'bytes32' },
    ],
    name: 'usedNonces',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'version',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
] as const

/**
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 */
export const optimistInviterAddress = {
  10: '0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929',
  420: '0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929',
} as const

/**
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 */
export const optimistInviterConfig = {
  address: optimistInviterAddress,
  abi: optimistInviterABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// PortalSender
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x0A893d9576b9cFD9EF78595963dc973238E78210)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xe7FACd39531ee3C313330E93B4d7a8B8A3c84Aa4)
 */
export const portalSenderABI = [
  {
    stateMutability: 'nonpayable',
    type: 'constructor',
    inputs: [
      {
        name: '_portal',
        internalType: 'contract OptimismPortal',
        type: 'address',
      },
    ],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'PORTAL',
    outputs: [
      { name: '', internalType: 'contract OptimismPortal', type: 'address' },
    ],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'donate',
    outputs: [],
  },
] as const

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x0A893d9576b9cFD9EF78595963dc973238E78210)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xe7FACd39531ee3C313330E93B4d7a8B8A3c84Aa4)
 */
export const portalSenderAddress = {
  1: '0x0A893d9576b9cFD9EF78595963dc973238E78210',
  5: '0xe7FACd39531ee3C313330E93B4d7a8B8A3c84Aa4',
} as const

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x0A893d9576b9cFD9EF78595963dc973238E78210)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xe7FACd39531ee3C313330E93B4d7a8B8A3c84Aa4)
 */
export const portalSenderConfig = {
  address: portalSenderAddress,
  abi: portalSenderABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// ProtocolVersions
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x0C24F5098774aA366827D667494e9F889f7cFc08)
 */
export const protocolVersionsABI = [
  { stateMutability: 'nonpayable', type: 'constructor', inputs: [] },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'version',
        internalType: 'uint256',
        type: 'uint256',
        indexed: true,
      },
      {
        name: 'updateType',
        internalType: 'enum ProtocolVersions.UpdateType',
        type: 'uint8',
        indexed: true,
      },
      { name: 'data', internalType: 'bytes', type: 'bytes', indexed: false },
    ],
    name: 'ConfigUpdate',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'version', internalType: 'uint8', type: 'uint8', indexed: false },
    ],
    name: 'Initialized',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'previousOwner',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'newOwner',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
    ],
    name: 'OwnershipTransferred',
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'RECOMMENDED_SLOT',
    outputs: [{ name: '', internalType: 'bytes32', type: 'bytes32' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'REQUIRED_SLOT',
    outputs: [{ name: '', internalType: 'bytes32', type: 'bytes32' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_owner', internalType: 'address', type: 'address' },
      { name: '_required', internalType: 'ProtocolVersion', type: 'uint256' },
      {
        name: '_recommended',
        internalType: 'ProtocolVersion',
        type: 'uint256',
      },
    ],
    name: 'initialize',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'owner',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'recommended',
    outputs: [
      { name: 'out_', internalType: 'ProtocolVersion', type: 'uint256' },
    ],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'renounceOwnership',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'required',
    outputs: [
      { name: 'out_', internalType: 'ProtocolVersion', type: 'uint256' },
    ],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      {
        name: '_recommended',
        internalType: 'ProtocolVersion',
        type: 'uint256',
      },
    ],
    name: 'setRecommended',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_required', internalType: 'ProtocolVersion', type: 'uint256' },
    ],
    name: 'setRequired',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: 'newOwner', internalType: 'address', type: 'address' }],
    name: 'transferOwnership',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'version',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
] as const

/**
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x0C24F5098774aA366827D667494e9F889f7cFc08)
 */
export const protocolVersionsAddress = {
  5: '0x0C24F5098774aA366827D667494e9F889f7cFc08',
} as const

/**
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x0C24F5098774aA366827D667494e9F889f7cFc08)
 */
export const protocolVersionsConfig = {
  address: protocolVersionsAddress,
  abi: protocolVersionsABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// ProxyAdmin
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000018)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000018)
 */
export const proxyAdminABI = [
  {
    stateMutability: 'nonpayable',
    type: 'constructor',
    inputs: [{ name: '_owner', internalType: 'address', type: 'address' }],
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'previousOwner',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'newOwner',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
    ],
    name: 'OwnershipTransferred',
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'addressManager',
    outputs: [
      { name: '', internalType: 'contract AddressManager', type: 'address' },
    ],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_proxy', internalType: 'address payable', type: 'address' },
      { name: '_newAdmin', internalType: 'address', type: 'address' },
    ],
    name: 'changeProxyAdmin',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [
      { name: '_proxy', internalType: 'address payable', type: 'address' },
    ],
    name: 'getProxyAdmin',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '_proxy', internalType: 'address', type: 'address' }],
    name: 'getProxyImplementation',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '', internalType: 'address', type: 'address' }],
    name: 'implementationName',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'isUpgrading',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'owner',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '', internalType: 'address', type: 'address' }],
    name: 'proxyType',
    outputs: [
      { name: '', internalType: 'enum ProxyAdmin.ProxyType', type: 'uint8' },
    ],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'renounceOwnership',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_name', internalType: 'string', type: 'string' },
      { name: '_address', internalType: 'address', type: 'address' },
    ],
    name: 'setAddress',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      {
        name: '_address',
        internalType: 'contract AddressManager',
        type: 'address',
      },
    ],
    name: 'setAddressManager',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_address', internalType: 'address', type: 'address' },
      { name: '_name', internalType: 'string', type: 'string' },
    ],
    name: 'setImplementationName',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_address', internalType: 'address', type: 'address' },
      {
        name: '_type',
        internalType: 'enum ProxyAdmin.ProxyType',
        type: 'uint8',
      },
    ],
    name: 'setProxyType',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: '_upgrading', internalType: 'bool', type: 'bool' }],
    name: 'setUpgrading',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: 'newOwner', internalType: 'address', type: 'address' }],
    name: 'transferOwnership',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_proxy', internalType: 'address payable', type: 'address' },
      { name: '_implementation', internalType: 'address', type: 'address' },
    ],
    name: 'upgrade',
    outputs: [],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_proxy', internalType: 'address payable', type: 'address' },
      { name: '_implementation', internalType: 'address', type: 'address' },
      { name: '_data', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'upgradeAndCall',
    outputs: [],
  },
] as const

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000018)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000018)
 */
export const proxyAdminAddress = {
  1: '0x4200000000000000000000000000000000000018',
  5: '0x4200000000000000000000000000000000000018',
} as const

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000018)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000018)
 */
export const proxyAdminConfig = {
  address: proxyAdminAddress,
  abi: proxyAdminABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// SchemaRegistry
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x6232208d66bAc2305b46b4Cb6BCB3857B298DF13)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x2545fa928d5d278cA75Fd47306e4a89096ff6403)
 */
export const schemaRegistryABI = [
  { stateMutability: 'nonpayable', type: 'constructor', inputs: [] },
  { type: 'error', inputs: [], name: 'AlreadyExists' },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'uid', internalType: 'bytes32', type: 'bytes32', indexed: true },
      {
        name: 'registerer',
        internalType: 'address',
        type: 'address',
        indexed: false,
      },
    ],
    name: 'Registered',
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: 'uid', internalType: 'bytes32', type: 'bytes32' }],
    name: 'getSchema',
    outputs: [
      {
        name: '',
        internalType: 'struct SchemaRecord',
        type: 'tuple',
        components: [
          { name: 'uid', internalType: 'bytes32', type: 'bytes32' },
          {
            name: 'resolver',
            internalType: 'contract ISchemaResolver',
            type: 'address',
          },
          { name: 'revocable', internalType: 'bool', type: 'bool' },
          { name: 'schema', internalType: 'string', type: 'string' },
        ],
      },
    ],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: 'schema', internalType: 'string', type: 'string' },
      {
        name: 'resolver',
        internalType: 'contract ISchemaResolver',
        type: 'address',
      },
      { name: 'revocable', internalType: 'bool', type: 'bool' },
    ],
    name: 'register',
    outputs: [{ name: '', internalType: 'bytes32', type: 'bytes32' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'version',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
] as const

/**
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x6232208d66bAc2305b46b4Cb6BCB3857B298DF13)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x2545fa928d5d278cA75Fd47306e4a89096ff6403)
 */
export const schemaRegistryAddress = {
  10: '0x6232208d66bAc2305b46b4Cb6BCB3857B298DF13',
  420: '0x2545fa928d5d278cA75Fd47306e4a89096ff6403',
} as const

/**
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x6232208d66bAc2305b46b4Cb6BCB3857B298DF13)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x2545fa928d5d278cA75Fd47306e4a89096ff6403)
 */
export const schemaRegistryConfig = {
  address: schemaRegistryAddress,
  abi: schemaRegistryABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// SequencerFeeVault
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000011)
 */
export const sequencerFeeVaultABI = [
  {
    stateMutability: 'nonpayable',
    type: 'constructor',
    inputs: [{ name: '_recipient', internalType: 'address', type: 'address' }],
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'value',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      { name: 'to', internalType: 'address', type: 'address', indexed: false },
      {
        name: 'from',
        internalType: 'address',
        type: 'address',
        indexed: false,
      },
    ],
    name: 'Withdrawal',
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'MIN_WITHDRAWAL_AMOUNT',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'RECIPIENT',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'l1FeeWallet',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'totalProcessed',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'version',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'withdraw',
    outputs: [],
  },
  { stateMutability: 'payable', type: 'receive' },
] as const

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000011)
 */
export const sequencerFeeVaultAddress = {
  420: '0x4200000000000000000000000000000000000011',
} as const

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000011)
 */
export const sequencerFeeVaultConfig = {
  address: sequencerFeeVaultAddress,
  abi: sequencerFeeVaultABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// SystemConfig
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x229047fed2591dbec1eF1118d64F7aF3dB9EB290)
 */
export const systemConfigABI = [
  {
    stateMutability: 'nonpayable',
    type: 'constructor',
    inputs: [
      { name: '_owner', internalType: 'address', type: 'address' },
      { name: '_overhead', internalType: 'uint256', type: 'uint256' },
      { name: '_scalar', internalType: 'uint256', type: 'uint256' },
      { name: '_batcherHash', internalType: 'bytes32', type: 'bytes32' },
      { name: '_gasLimit', internalType: 'uint64', type: 'uint64' },
      { name: '_unsafeBlockSigner', internalType: 'address', type: 'address' },
      {
        name: '_config',
        internalType: 'struct ResourceMetering.ResourceConfig',
        type: 'tuple',
        components: [
          { name: 'maxResourceLimit', internalType: 'uint32', type: 'uint32' },
          {
            name: 'elasticityMultiplier',
            internalType: 'uint8',
            type: 'uint8',
          },
          {
            name: 'baseFeeMaxChangeDenominator',
            internalType: 'uint8',
            type: 'uint8',
          },
          { name: 'minimumBaseFee', internalType: 'uint32', type: 'uint32' },
          { name: 'systemTxMaxGas', internalType: 'uint32', type: 'uint32' },
          { name: 'maximumBaseFee', internalType: 'uint128', type: 'uint128' },
        ],
      },
    ],
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'version',
        internalType: 'uint256',
        type: 'uint256',
        indexed: true,
      },
      {
        name: 'updateType',
        internalType: 'enum SystemConfig.UpdateType',
        type: 'uint8',
        indexed: true,
      },
      { name: 'data', internalType: 'bytes', type: 'bytes', indexed: false },
    ],
    name: 'ConfigUpdate',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'version', internalType: 'uint8', type: 'uint8', indexed: false },
    ],
    name: 'Initialized',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'previousOwner',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'newOwner',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
    ],
    name: 'OwnershipTransferred',
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'UNSAFE_BLOCK_SIGNER_SLOT',
    outputs: [{ name: '', internalType: 'bytes32', type: 'bytes32' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'batcherHash',
    outputs: [{ name: '', internalType: 'bytes32', type: 'bytes32' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'gasLimit',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_owner', internalType: 'address', type: 'address' },
      { name: '_overhead', internalType: 'uint256', type: 'uint256' },
      { name: '_scalar', internalType: 'uint256', type: 'uint256' },
      { name: '_batcherHash', internalType: 'bytes32', type: 'bytes32' },
      { name: '_gasLimit', internalType: 'uint64', type: 'uint64' },
      { name: '_unsafeBlockSigner', internalType: 'address', type: 'address' },
      {
        name: '_config',
        internalType: 'struct ResourceMetering.ResourceConfig',
        type: 'tuple',
        components: [
          { name: 'maxResourceLimit', internalType: 'uint32', type: 'uint32' },
          {
            name: 'elasticityMultiplier',
            internalType: 'uint8',
            type: 'uint8',
          },
          {
            name: 'baseFeeMaxChangeDenominator',
            internalType: 'uint8',
            type: 'uint8',
          },
          { name: 'minimumBaseFee', internalType: 'uint32', type: 'uint32' },
          { name: 'systemTxMaxGas', internalType: 'uint32', type: 'uint32' },
          { name: 'maximumBaseFee', internalType: 'uint128', type: 'uint128' },
        ],
      },
    ],
    name: 'initialize',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'minimumGasLimit',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'overhead',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'owner',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'renounceOwnership',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'resourceConfig',
    outputs: [
      {
        name: '',
        internalType: 'struct ResourceMetering.ResourceConfig',
        type: 'tuple',
        components: [
          { name: 'maxResourceLimit', internalType: 'uint32', type: 'uint32' },
          {
            name: 'elasticityMultiplier',
            internalType: 'uint8',
            type: 'uint8',
          },
          {
            name: 'baseFeeMaxChangeDenominator',
            internalType: 'uint8',
            type: 'uint8',
          },
          { name: 'minimumBaseFee', internalType: 'uint32', type: 'uint32' },
          { name: 'systemTxMaxGas', internalType: 'uint32', type: 'uint32' },
          { name: 'maximumBaseFee', internalType: 'uint128', type: 'uint128' },
        ],
      },
    ],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'scalar',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_batcherHash', internalType: 'bytes32', type: 'bytes32' },
    ],
    name: 'setBatcherHash',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_overhead', internalType: 'uint256', type: 'uint256' },
      { name: '_scalar', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'setGasConfig',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: '_gasLimit', internalType: 'uint64', type: 'uint64' }],
    name: 'setGasLimit',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      {
        name: '_config',
        internalType: 'struct ResourceMetering.ResourceConfig',
        type: 'tuple',
        components: [
          { name: 'maxResourceLimit', internalType: 'uint32', type: 'uint32' },
          {
            name: 'elasticityMultiplier',
            internalType: 'uint8',
            type: 'uint8',
          },
          {
            name: 'baseFeeMaxChangeDenominator',
            internalType: 'uint8',
            type: 'uint8',
          },
          { name: 'minimumBaseFee', internalType: 'uint32', type: 'uint32' },
          { name: 'systemTxMaxGas', internalType: 'uint32', type: 'uint32' },
          { name: 'maximumBaseFee', internalType: 'uint128', type: 'uint128' },
        ],
      },
    ],
    name: 'setResourceConfig',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_unsafeBlockSigner', internalType: 'address', type: 'address' },
    ],
    name: 'setUnsafeBlockSigner',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: 'newOwner', internalType: 'address', type: 'address' }],
    name: 'transferOwnership',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'unsafeBlockSigner',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'version',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
] as const

/**
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x229047fed2591dbec1eF1118d64F7aF3dB9EB290)
 */
export const systemConfigAddress = {
  1: '0x229047fed2591dbec1eF1118d64F7aF3dB9EB290',
} as const

/**
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x229047fed2591dbec1eF1118d64F7aF3dB9EB290)
 */
export const systemConfigConfig = {
  address: systemConfigAddress,
  abi: systemConfigABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// SystemConfig_goerli
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xAe851f927Ee40dE99aaBb7461C00f9622ab91d60)
 */
export const systemConfigGoerliABI = [
  { stateMutability: 'nonpayable', type: 'constructor', inputs: [] },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'version',
        internalType: 'uint256',
        type: 'uint256',
        indexed: true,
      },
      {
        name: 'updateType',
        internalType: 'enum SystemConfig.UpdateType',
        type: 'uint8',
        indexed: true,
      },
      { name: 'data', internalType: 'bytes', type: 'bytes', indexed: false },
    ],
    name: 'ConfigUpdate',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'version', internalType: 'uint8', type: 'uint8', indexed: false },
    ],
    name: 'Initialized',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'previousOwner',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'newOwner',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
    ],
    name: 'OwnershipTransferred',
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'BATCH_INBOX_SLOT',
    outputs: [{ name: '', internalType: 'bytes32', type: 'bytes32' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'L1_CROSS_DOMAIN_MESSENGER_SLOT',
    outputs: [{ name: '', internalType: 'bytes32', type: 'bytes32' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'L1_ERC_721_BRIDGE_SLOT',
    outputs: [{ name: '', internalType: 'bytes32', type: 'bytes32' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'L1_STANDARD_BRIDGE_SLOT',
    outputs: [{ name: '', internalType: 'bytes32', type: 'bytes32' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'L2_OUTPUT_ORACLE_SLOT',
    outputs: [{ name: '', internalType: 'bytes32', type: 'bytes32' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'OPTIMISM_MINTABLE_ERC20_FACTORY_SLOT',
    outputs: [{ name: '', internalType: 'bytes32', type: 'bytes32' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'OPTIMISM_PORTAL_SLOT',
    outputs: [{ name: '', internalType: 'bytes32', type: 'bytes32' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'UNSAFE_BLOCK_SIGNER_SLOT',
    outputs: [{ name: '', internalType: 'bytes32', type: 'bytes32' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'batchInbox',
    outputs: [{ name: 'addr_', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'batcherHash',
    outputs: [{ name: '', internalType: 'bytes32', type: 'bytes32' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'gasLimit',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_owner', internalType: 'address', type: 'address' },
      { name: '_overhead', internalType: 'uint256', type: 'uint256' },
      { name: '_scalar', internalType: 'uint256', type: 'uint256' },
      { name: '_batcherHash', internalType: 'bytes32', type: 'bytes32' },
      { name: '_gasLimit', internalType: 'uint64', type: 'uint64' },
      { name: '_unsafeBlockSigner', internalType: 'address', type: 'address' },
      {
        name: '_config',
        internalType: 'struct ResourceMetering.ResourceConfig',
        type: 'tuple',
        components: [
          { name: 'maxResourceLimit', internalType: 'uint32', type: 'uint32' },
          {
            name: 'elasticityMultiplier',
            internalType: 'uint8',
            type: 'uint8',
          },
          {
            name: 'baseFeeMaxChangeDenominator',
            internalType: 'uint8',
            type: 'uint8',
          },
          { name: 'minimumBaseFee', internalType: 'uint32', type: 'uint32' },
          { name: 'systemTxMaxGas', internalType: 'uint32', type: 'uint32' },
          { name: 'maximumBaseFee', internalType: 'uint128', type: 'uint128' },
        ],
      },
      { name: '_startBlock', internalType: 'uint256', type: 'uint256' },
      { name: '_batchInbox', internalType: 'address', type: 'address' },
      {
        name: '_addresses',
        internalType: 'struct SystemConfig.Addresses',
        type: 'tuple',
        components: [
          {
            name: 'l1CrossDomainMessenger',
            internalType: 'address',
            type: 'address',
          },
          { name: 'l1ERC721Bridge', internalType: 'address', type: 'address' },
          {
            name: 'l1StandardBridge',
            internalType: 'address',
            type: 'address',
          },
          { name: 'l2OutputOracle', internalType: 'address', type: 'address' },
          { name: 'optimismPortal', internalType: 'address', type: 'address' },
          {
            name: 'optimismMintableERC20Factory',
            internalType: 'address',
            type: 'address',
          },
        ],
      },
    ],
    name: 'initialize',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'l1CrossDomainMessenger',
    outputs: [{ name: 'addr_', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'l1ERC721Bridge',
    outputs: [{ name: 'addr_', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'l1StandardBridge',
    outputs: [{ name: 'addr_', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'l2OutputOracle',
    outputs: [{ name: 'addr_', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'minimumGasLimit',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'optimismMintableERC20Factory',
    outputs: [{ name: 'addr_', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'optimismPortal',
    outputs: [{ name: 'addr_', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'overhead',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'owner',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'renounceOwnership',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'resourceConfig',
    outputs: [
      {
        name: '',
        internalType: 'struct ResourceMetering.ResourceConfig',
        type: 'tuple',
        components: [
          { name: 'maxResourceLimit', internalType: 'uint32', type: 'uint32' },
          {
            name: 'elasticityMultiplier',
            internalType: 'uint8',
            type: 'uint8',
          },
          {
            name: 'baseFeeMaxChangeDenominator',
            internalType: 'uint8',
            type: 'uint8',
          },
          { name: 'minimumBaseFee', internalType: 'uint32', type: 'uint32' },
          { name: 'systemTxMaxGas', internalType: 'uint32', type: 'uint32' },
          { name: 'maximumBaseFee', internalType: 'uint128', type: 'uint128' },
        ],
      },
    ],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'scalar',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_batcherHash', internalType: 'bytes32', type: 'bytes32' },
    ],
    name: 'setBatcherHash',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_overhead', internalType: 'uint256', type: 'uint256' },
      { name: '_scalar', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'setGasConfig',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: '_gasLimit', internalType: 'uint64', type: 'uint64' }],
    name: 'setGasLimit',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      {
        name: '_config',
        internalType: 'struct ResourceMetering.ResourceConfig',
        type: 'tuple',
        components: [
          { name: 'maxResourceLimit', internalType: 'uint32', type: 'uint32' },
          {
            name: 'elasticityMultiplier',
            internalType: 'uint8',
            type: 'uint8',
          },
          {
            name: 'baseFeeMaxChangeDenominator',
            internalType: 'uint8',
            type: 'uint8',
          },
          { name: 'minimumBaseFee', internalType: 'uint32', type: 'uint32' },
          { name: 'systemTxMaxGas', internalType: 'uint32', type: 'uint32' },
          { name: 'maximumBaseFee', internalType: 'uint128', type: 'uint128' },
        ],
      },
    ],
    name: 'setResourceConfig',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_unsafeBlockSigner', internalType: 'address', type: 'address' },
    ],
    name: 'setUnsafeBlockSigner',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'startBlock',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: 'newOwner', internalType: 'address', type: 'address' }],
    name: 'transferOwnership',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'unsafeBlockSigner',
    outputs: [{ name: 'addr_', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'version',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
] as const

/**
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xAe851f927Ee40dE99aaBb7461C00f9622ab91d60)
 */
export const systemConfigGoerliAddress = {
  5: '0xAe851f927Ee40dE99aaBb7461C00f9622ab91d60',
} as const

/**
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xAe851f927Ee40dE99aaBb7461C00f9622ab91d60)
 */
export const systemConfigGoerliConfig = {
  address: systemConfigGoerliAddress,
  abi: systemConfigGoerliABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// SystemDictator
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xB4453CEb33d2e67FA244A24acf2E50CEF31F53cB)
 */
export const systemDictatorABI = [
  { stateMutability: 'nonpayable', type: 'constructor', inputs: [] },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'version', internalType: 'uint8', type: 'uint8', indexed: false },
    ],
    name: 'Initialized',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'previousOwner',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'newOwner',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
    ],
    name: 'OwnershipTransferred',
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'EXIT_1_NO_RETURN_STEP',
    outputs: [{ name: '', internalType: 'uint8', type: 'uint8' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'PROXY_TRANSFER_STEP',
    outputs: [{ name: '', internalType: 'uint8', type: 'uint8' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'config',
    outputs: [
      {
        name: 'globalConfig',
        internalType: 'struct SystemDictator.GlobalConfig',
        type: 'tuple',
        components: [
          {
            name: 'addressManager',
            internalType: 'contract AddressManager',
            type: 'address',
          },
          {
            name: 'proxyAdmin',
            internalType: 'contract ProxyAdmin',
            type: 'address',
          },
          { name: 'controller', internalType: 'address', type: 'address' },
          { name: 'finalOwner', internalType: 'address', type: 'address' },
        ],
      },
      {
        name: 'proxyAddressConfig',
        internalType: 'struct SystemDictator.ProxyAddressConfig',
        type: 'tuple',
        components: [
          {
            name: 'l2OutputOracleProxy',
            internalType: 'address',
            type: 'address',
          },
          {
            name: 'optimismPortalProxy',
            internalType: 'address',
            type: 'address',
          },
          {
            name: 'l1CrossDomainMessengerProxy',
            internalType: 'address',
            type: 'address',
          },
          {
            name: 'l1StandardBridgeProxy',
            internalType: 'address',
            type: 'address',
          },
          {
            name: 'optimismMintableERC20FactoryProxy',
            internalType: 'address',
            type: 'address',
          },
          {
            name: 'l1ERC721BridgeProxy',
            internalType: 'address',
            type: 'address',
          },
          {
            name: 'systemConfigProxy',
            internalType: 'address',
            type: 'address',
          },
        ],
      },
      {
        name: 'implementationAddressConfig',
        internalType: 'struct SystemDictator.ImplementationAddressConfig',
        type: 'tuple',
        components: [
          {
            name: 'l2OutputOracleImpl',
            internalType: 'contract L2OutputOracle',
            type: 'address',
          },
          {
            name: 'optimismPortalImpl',
            internalType: 'contract OptimismPortal',
            type: 'address',
          },
          {
            name: 'l1CrossDomainMessengerImpl',
            internalType: 'contract L1CrossDomainMessenger',
            type: 'address',
          },
          {
            name: 'l1StandardBridgeImpl',
            internalType: 'contract L1StandardBridge',
            type: 'address',
          },
          {
            name: 'optimismMintableERC20FactoryImpl',
            internalType: 'contract OptimismMintableERC20Factory',
            type: 'address',
          },
          {
            name: 'l1ERC721BridgeImpl',
            internalType: 'contract L1ERC721Bridge',
            type: 'address',
          },
          {
            name: 'portalSenderImpl',
            internalType: 'contract PortalSender',
            type: 'address',
          },
          {
            name: 'systemConfigImpl',
            internalType: 'contract SystemConfig',
            type: 'address',
          },
        ],
      },
      {
        name: 'systemConfigConfig',
        internalType: 'struct SystemDictator.SystemConfigConfig',
        type: 'tuple',
        components: [
          { name: 'owner', internalType: 'address', type: 'address' },
          { name: 'overhead', internalType: 'uint256', type: 'uint256' },
          { name: 'scalar', internalType: 'uint256', type: 'uint256' },
          { name: 'batcherHash', internalType: 'bytes32', type: 'bytes32' },
          { name: 'gasLimit', internalType: 'uint64', type: 'uint64' },
          {
            name: 'unsafeBlockSigner',
            internalType: 'address',
            type: 'address',
          },
          {
            name: 'resourceConfig',
            internalType: 'struct ResourceMetering.ResourceConfig',
            type: 'tuple',
            components: [
              {
                name: 'maxResourceLimit',
                internalType: 'uint32',
                type: 'uint32',
              },
              {
                name: 'elasticityMultiplier',
                internalType: 'uint8',
                type: 'uint8',
              },
              {
                name: 'baseFeeMaxChangeDenominator',
                internalType: 'uint8',
                type: 'uint8',
              },
              {
                name: 'minimumBaseFee',
                internalType: 'uint32',
                type: 'uint32',
              },
              {
                name: 'systemTxMaxGas',
                internalType: 'uint32',
                type: 'uint32',
              },
              {
                name: 'maximumBaseFee',
                internalType: 'uint128',
                type: 'uint128',
              },
            ],
          },
        ],
      },
    ],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'currentStep',
    outputs: [{ name: '', internalType: 'uint8', type: 'uint8' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'dynamicConfigSet',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'exit1',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'exited',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'finalize',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'finalized',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      {
        name: '_config',
        internalType: 'struct SystemDictator.DeployConfig',
        type: 'tuple',
        components: [
          {
            name: 'globalConfig',
            internalType: 'struct SystemDictator.GlobalConfig',
            type: 'tuple',
            components: [
              {
                name: 'addressManager',
                internalType: 'contract AddressManager',
                type: 'address',
              },
              {
                name: 'proxyAdmin',
                internalType: 'contract ProxyAdmin',
                type: 'address',
              },
              { name: 'controller', internalType: 'address', type: 'address' },
              { name: 'finalOwner', internalType: 'address', type: 'address' },
            ],
          },
          {
            name: 'proxyAddressConfig',
            internalType: 'struct SystemDictator.ProxyAddressConfig',
            type: 'tuple',
            components: [
              {
                name: 'l2OutputOracleProxy',
                internalType: 'address',
                type: 'address',
              },
              {
                name: 'optimismPortalProxy',
                internalType: 'address',
                type: 'address',
              },
              {
                name: 'l1CrossDomainMessengerProxy',
                internalType: 'address',
                type: 'address',
              },
              {
                name: 'l1StandardBridgeProxy',
                internalType: 'address',
                type: 'address',
              },
              {
                name: 'optimismMintableERC20FactoryProxy',
                internalType: 'address',
                type: 'address',
              },
              {
                name: 'l1ERC721BridgeProxy',
                internalType: 'address',
                type: 'address',
              },
              {
                name: 'systemConfigProxy',
                internalType: 'address',
                type: 'address',
              },
            ],
          },
          {
            name: 'implementationAddressConfig',
            internalType: 'struct SystemDictator.ImplementationAddressConfig',
            type: 'tuple',
            components: [
              {
                name: 'l2OutputOracleImpl',
                internalType: 'contract L2OutputOracle',
                type: 'address',
              },
              {
                name: 'optimismPortalImpl',
                internalType: 'contract OptimismPortal',
                type: 'address',
              },
              {
                name: 'l1CrossDomainMessengerImpl',
                internalType: 'contract L1CrossDomainMessenger',
                type: 'address',
              },
              {
                name: 'l1StandardBridgeImpl',
                internalType: 'contract L1StandardBridge',
                type: 'address',
              },
              {
                name: 'optimismMintableERC20FactoryImpl',
                internalType: 'contract OptimismMintableERC20Factory',
                type: 'address',
              },
              {
                name: 'l1ERC721BridgeImpl',
                internalType: 'contract L1ERC721Bridge',
                type: 'address',
              },
              {
                name: 'portalSenderImpl',
                internalType: 'contract PortalSender',
                type: 'address',
              },
              {
                name: 'systemConfigImpl',
                internalType: 'contract SystemConfig',
                type: 'address',
              },
            ],
          },
          {
            name: 'systemConfigConfig',
            internalType: 'struct SystemDictator.SystemConfigConfig',
            type: 'tuple',
            components: [
              { name: 'owner', internalType: 'address', type: 'address' },
              { name: 'overhead', internalType: 'uint256', type: 'uint256' },
              { name: 'scalar', internalType: 'uint256', type: 'uint256' },
              { name: 'batcherHash', internalType: 'bytes32', type: 'bytes32' },
              { name: 'gasLimit', internalType: 'uint64', type: 'uint64' },
              {
                name: 'unsafeBlockSigner',
                internalType: 'address',
                type: 'address',
              },
              {
                name: 'resourceConfig',
                internalType: 'struct ResourceMetering.ResourceConfig',
                type: 'tuple',
                components: [
                  {
                    name: 'maxResourceLimit',
                    internalType: 'uint32',
                    type: 'uint32',
                  },
                  {
                    name: 'elasticityMultiplier',
                    internalType: 'uint8',
                    type: 'uint8',
                  },
                  {
                    name: 'baseFeeMaxChangeDenominator',
                    internalType: 'uint8',
                    type: 'uint8',
                  },
                  {
                    name: 'minimumBaseFee',
                    internalType: 'uint32',
                    type: 'uint32',
                  },
                  {
                    name: 'systemTxMaxGas',
                    internalType: 'uint32',
                    type: 'uint32',
                  },
                  {
                    name: 'maximumBaseFee',
                    internalType: 'uint128',
                    type: 'uint128',
                  },
                ],
              },
            ],
          },
        ],
      },
    ],
    name: 'initialize',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'l2OutputOracleDynamicConfig',
    outputs: [
      {
        name: 'l2OutputOracleStartingBlockNumber',
        internalType: 'uint256',
        type: 'uint256',
      },
      {
        name: 'l2OutputOracleStartingTimestamp',
        internalType: 'uint256',
        type: 'uint256',
      },
    ],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'oldL1CrossDomainMessenger',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'optimismPortalDynamicConfig',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'owner',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'phase1',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'phase2',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'renounceOwnership',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'step1',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'step2',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'step3',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'step4',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'step5',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: 'newOwner', internalType: 'address', type: 'address' }],
    name: 'transferOwnership',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      {
        name: '_l2OutputOracleDynamicConfig',
        internalType: 'struct SystemDictator.L2OutputOracleDynamicConfig',
        type: 'tuple',
        components: [
          {
            name: 'l2OutputOracleStartingBlockNumber',
            internalType: 'uint256',
            type: 'uint256',
          },
          {
            name: 'l2OutputOracleStartingTimestamp',
            internalType: 'uint256',
            type: 'uint256',
          },
        ],
      },
      {
        name: '_optimismPortalDynamicConfig',
        internalType: 'bool',
        type: 'bool',
      },
    ],
    name: 'updateDynamicConfig',
    outputs: [],
  },
] as const

/**
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xB4453CEb33d2e67FA244A24acf2E50CEF31F53cB)
 */
export const systemDictatorAddress = {
  1: '0xB4453CEb33d2e67FA244A24acf2E50CEF31F53cB',
} as const

/**
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xB4453CEb33d2e67FA244A24acf2E50CEF31F53cB)
 */
export const systemDictatorConfig = {
  address: systemDictatorAddress,
  abi: systemDictatorABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// SystemDictator_goerli
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x1f0613A44c9a8ECE7B3A2e0CdBdF0F5B47A50971)
 */
export const systemDictatorGoerliABI = [
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'version', internalType: 'uint8', type: 'uint8', indexed: false },
    ],
    name: 'Initialized',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'previousOwner',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'newOwner',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
    ],
    name: 'OwnershipTransferred',
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'EXIT_1_NO_RETURN_STEP',
    outputs: [{ name: '', internalType: 'uint8', type: 'uint8' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'PROXY_TRANSFER_STEP',
    outputs: [{ name: '', internalType: 'uint8', type: 'uint8' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'config',
    outputs: [
      {
        name: 'globalConfig',
        internalType: 'struct SystemDictator.GlobalConfig',
        type: 'tuple',
        components: [
          {
            name: 'addressManager',
            internalType: 'contract AddressManager',
            type: 'address',
          },
          {
            name: 'proxyAdmin',
            internalType: 'contract ProxyAdmin',
            type: 'address',
          },
          { name: 'controller', internalType: 'address', type: 'address' },
          { name: 'finalOwner', internalType: 'address', type: 'address' },
        ],
      },
      {
        name: 'proxyAddressConfig',
        internalType: 'struct SystemDictator.ProxyAddressConfig',
        type: 'tuple',
        components: [
          {
            name: 'l2OutputOracleProxy',
            internalType: 'address',
            type: 'address',
          },
          {
            name: 'optimismPortalProxy',
            internalType: 'address',
            type: 'address',
          },
          {
            name: 'l1CrossDomainMessengerProxy',
            internalType: 'address',
            type: 'address',
          },
          {
            name: 'l1StandardBridgeProxy',
            internalType: 'address',
            type: 'address',
          },
          {
            name: 'optimismMintableERC20FactoryProxy',
            internalType: 'address',
            type: 'address',
          },
          {
            name: 'l1ERC721BridgeProxy',
            internalType: 'address',
            type: 'address',
          },
          {
            name: 'systemConfigProxy',
            internalType: 'address',
            type: 'address',
          },
        ],
      },
      {
        name: 'implementationAddressConfig',
        internalType: 'struct SystemDictator.ImplementationAddressConfig',
        type: 'tuple',
        components: [
          {
            name: 'l2OutputOracleImpl',
            internalType: 'contract L2OutputOracle',
            type: 'address',
          },
          {
            name: 'optimismPortalImpl',
            internalType: 'contract OptimismPortal',
            type: 'address',
          },
          {
            name: 'l1CrossDomainMessengerImpl',
            internalType: 'contract L1CrossDomainMessenger',
            type: 'address',
          },
          {
            name: 'l1StandardBridgeImpl',
            internalType: 'contract L1StandardBridge',
            type: 'address',
          },
          {
            name: 'optimismMintableERC20FactoryImpl',
            internalType: 'contract OptimismMintableERC20Factory',
            type: 'address',
          },
          {
            name: 'l1ERC721BridgeImpl',
            internalType: 'contract L1ERC721Bridge',
            type: 'address',
          },
          {
            name: 'portalSenderImpl',
            internalType: 'contract PortalSender',
            type: 'address',
          },
          {
            name: 'systemConfigImpl',
            internalType: 'contract SystemConfig',
            type: 'address',
          },
        ],
      },
      {
        name: 'systemConfigConfig',
        internalType: 'struct SystemDictator.SystemConfigConfig',
        type: 'tuple',
        components: [
          { name: 'owner', internalType: 'address', type: 'address' },
          { name: 'overhead', internalType: 'uint256', type: 'uint256' },
          { name: 'scalar', internalType: 'uint256', type: 'uint256' },
          { name: 'batcherHash', internalType: 'bytes32', type: 'bytes32' },
          { name: 'gasLimit', internalType: 'uint64', type: 'uint64' },
          {
            name: 'unsafeBlockSigner',
            internalType: 'address',
            type: 'address',
          },
        ],
      },
    ],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'currentStep',
    outputs: [{ name: '', internalType: 'uint8', type: 'uint8' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'dynamicConfigSet',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'exit1',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'finalize',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'finalized',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      {
        name: '_config',
        internalType: 'struct SystemDictator.DeployConfig',
        type: 'tuple',
        components: [
          {
            name: 'globalConfig',
            internalType: 'struct SystemDictator.GlobalConfig',
            type: 'tuple',
            components: [
              {
                name: 'addressManager',
                internalType: 'contract AddressManager',
                type: 'address',
              },
              {
                name: 'proxyAdmin',
                internalType: 'contract ProxyAdmin',
                type: 'address',
              },
              { name: 'controller', internalType: 'address', type: 'address' },
              { name: 'finalOwner', internalType: 'address', type: 'address' },
            ],
          },
          {
            name: 'proxyAddressConfig',
            internalType: 'struct SystemDictator.ProxyAddressConfig',
            type: 'tuple',
            components: [
              {
                name: 'l2OutputOracleProxy',
                internalType: 'address',
                type: 'address',
              },
              {
                name: 'optimismPortalProxy',
                internalType: 'address',
                type: 'address',
              },
              {
                name: 'l1CrossDomainMessengerProxy',
                internalType: 'address',
                type: 'address',
              },
              {
                name: 'l1StandardBridgeProxy',
                internalType: 'address',
                type: 'address',
              },
              {
                name: 'optimismMintableERC20FactoryProxy',
                internalType: 'address',
                type: 'address',
              },
              {
                name: 'l1ERC721BridgeProxy',
                internalType: 'address',
                type: 'address',
              },
              {
                name: 'systemConfigProxy',
                internalType: 'address',
                type: 'address',
              },
            ],
          },
          {
            name: 'implementationAddressConfig',
            internalType: 'struct SystemDictator.ImplementationAddressConfig',
            type: 'tuple',
            components: [
              {
                name: 'l2OutputOracleImpl',
                internalType: 'contract L2OutputOracle',
                type: 'address',
              },
              {
                name: 'optimismPortalImpl',
                internalType: 'contract OptimismPortal',
                type: 'address',
              },
              {
                name: 'l1CrossDomainMessengerImpl',
                internalType: 'contract L1CrossDomainMessenger',
                type: 'address',
              },
              {
                name: 'l1StandardBridgeImpl',
                internalType: 'contract L1StandardBridge',
                type: 'address',
              },
              {
                name: 'optimismMintableERC20FactoryImpl',
                internalType: 'contract OptimismMintableERC20Factory',
                type: 'address',
              },
              {
                name: 'l1ERC721BridgeImpl',
                internalType: 'contract L1ERC721Bridge',
                type: 'address',
              },
              {
                name: 'portalSenderImpl',
                internalType: 'contract PortalSender',
                type: 'address',
              },
              {
                name: 'systemConfigImpl',
                internalType: 'contract SystemConfig',
                type: 'address',
              },
            ],
          },
          {
            name: 'systemConfigConfig',
            internalType: 'struct SystemDictator.SystemConfigConfig',
            type: 'tuple',
            components: [
              { name: 'owner', internalType: 'address', type: 'address' },
              { name: 'overhead', internalType: 'uint256', type: 'uint256' },
              { name: 'scalar', internalType: 'uint256', type: 'uint256' },
              { name: 'batcherHash', internalType: 'bytes32', type: 'bytes32' },
              { name: 'gasLimit', internalType: 'uint64', type: 'uint64' },
              {
                name: 'unsafeBlockSigner',
                internalType: 'address',
                type: 'address',
              },
            ],
          },
        ],
      },
    ],
    name: 'initialize',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'l2OutputOracleDynamicConfig',
    outputs: [
      {
        name: 'l2OutputOracleStartingBlockNumber',
        internalType: 'uint256',
        type: 'uint256',
      },
      {
        name: 'l2OutputOracleStartingTimestamp',
        internalType: 'uint256',
        type: 'uint256',
      },
    ],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'oldL1CrossDomainMessenger',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'owner',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'renounceOwnership',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'step1',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'step2',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'step3',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'step4',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'step5',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'step6',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: 'newOwner', internalType: 'address', type: 'address' }],
    name: 'transferOwnership',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      {
        name: '_l2OutputOracleDynamicConfig',
        internalType: 'struct SystemDictator.L2OutputOracleDynamicConfig',
        type: 'tuple',
        components: [
          {
            name: 'l2OutputOracleStartingBlockNumber',
            internalType: 'uint256',
            type: 'uint256',
          },
          {
            name: 'l2OutputOracleStartingTimestamp',
            internalType: 'uint256',
            type: 'uint256',
          },
        ],
      },
    ],
    name: 'updateL2OutputOracleDynamicConfig',
    outputs: [],
  },
] as const

/**
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x1f0613A44c9a8ECE7B3A2e0CdBdF0F5B47A50971)
 */
export const systemDictatorGoerliAddress = {
  5: '0x1f0613A44c9a8ECE7B3A2e0CdBdF0F5B47A50971',
} as const

/**
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x1f0613A44c9a8ECE7B3A2e0CdBdF0F5B47A50971)
 */
export const systemDictatorGoerliConfig = {
  address: systemDictatorGoerliAddress,
  abi: systemDictatorGoerliABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// TeleportrWithdrawer
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x78A25524D90E3D0596558fb43789bD800a5c3007)
 */
export const teleportrWithdrawerABI = [
  {
    stateMutability: 'nonpayable',
    type: 'constructor',
    inputs: [{ name: '_owner', internalType: 'address', type: 'address' }],
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'user', internalType: 'address', type: 'address', indexed: true },
      {
        name: 'newOwner',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
    ],
    name: 'OwnerUpdated',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
    ],
    name: 'ReceivedETH',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'withdrawer',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'recipient',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'asset',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
    ],
    name: 'WithdrewERC20',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'withdrawer',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'recipient',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'asset',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      { name: 'id', internalType: 'uint256', type: 'uint256', indexed: false },
    ],
    name: 'WithdrewERC721',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'withdrawer',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'recipient',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
    ],
    name: 'WithdrewETH',
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_target', internalType: 'address', type: 'address' },
      { name: '_data', internalType: 'bytes', type: 'bytes' },
      { name: '_gas', internalType: 'uint256', type: 'uint256' },
      { name: '_value', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'CALL',
    outputs: [
      { name: '', internalType: 'bool', type: 'bool' },
      { name: '', internalType: 'bytes', type: 'bytes' },
    ],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_target', internalType: 'address', type: 'address' },
      { name: '_data', internalType: 'bytes', type: 'bytes' },
      { name: '_gas', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'DELEGATECALL',
    outputs: [
      { name: '', internalType: 'bool', type: 'bool' },
      { name: '', internalType: 'bytes', type: 'bytes' },
    ],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'data',
    outputs: [{ name: '', internalType: 'bytes', type: 'bytes' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'owner',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'recipient',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: '_data', internalType: 'bytes', type: 'bytes' }],
    name: 'setData',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: 'newOwner', internalType: 'address', type: 'address' }],
    name: 'setOwner',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: '_recipient', internalType: 'address', type: 'address' }],
    name: 'setRecipient',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: '_teleportr', internalType: 'address', type: 'address' }],
    name: 'setTeleportr',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'teleportr',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_asset', internalType: 'contract ERC20', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'withdrawERC20',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_asset', internalType: 'contract ERC20', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
    ],
    name: 'withdrawERC20',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_asset', internalType: 'contract ERC721', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_id', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'withdrawERC721',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_to', internalType: 'address payable', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'withdrawETH',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: '_to', internalType: 'address payable', type: 'address' }],
    name: 'withdrawETH',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'withdrawFromTeleportr',
    outputs: [],
  },
  { stateMutability: 'payable', type: 'receive' },
] as const

/**
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x78A25524D90E3D0596558fb43789bD800a5c3007)
 */
export const teleportrWithdrawerAddress = {
  1: '0x78A25524D90E3D0596558fb43789bD800a5c3007',
} as const

/**
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x78A25524D90E3D0596558fb43789bD800a5c3007)
 */
export const teleportrWithdrawerConfig = {
  address: teleportrWithdrawerAddress,
  abi: teleportrWithdrawerABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// eslintIgnore
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// React
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link addressManagerABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdE1FCfB0851916CA5101820A69b13a4E276bd81F)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xa6f73589243a6A7a9023b1Fa0651b1d89c177111)
 */
export function useAddressManagerRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<typeof addressManagerABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof addressManagerABI, TFunctionName, TSelectData>,
    'abi' | 'address'
  > & { chainId?: keyof typeof addressManagerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractRead({
    abi: addressManagerABI,
    address:
      addressManagerAddress[chainId as keyof typeof addressManagerAddress],
    ...config,
  } as UseContractReadConfig<typeof addressManagerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link addressManagerABI}__ and `functionName` set to `"getAddress"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdE1FCfB0851916CA5101820A69b13a4E276bd81F)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xa6f73589243a6A7a9023b1Fa0651b1d89c177111)
 */
export function useAddressManagerGetAddress<
  TFunctionName extends 'getAddress',
  TSelectData = ReadContractResult<typeof addressManagerABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof addressManagerABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof addressManagerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractRead({
    abi: addressManagerABI,
    address:
      addressManagerAddress[chainId as keyof typeof addressManagerAddress],
    functionName: 'getAddress',
    ...config,
  } as UseContractReadConfig<typeof addressManagerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link addressManagerABI}__ and `functionName` set to `"owner"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdE1FCfB0851916CA5101820A69b13a4E276bd81F)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xa6f73589243a6A7a9023b1Fa0651b1d89c177111)
 */
export function useAddressManagerOwner<
  TFunctionName extends 'owner',
  TSelectData = ReadContractResult<typeof addressManagerABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof addressManagerABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof addressManagerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractRead({
    abi: addressManagerABI,
    address:
      addressManagerAddress[chainId as keyof typeof addressManagerAddress],
    functionName: 'owner',
    ...config,
  } as UseContractReadConfig<typeof addressManagerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link addressManagerABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdE1FCfB0851916CA5101820A69b13a4E276bd81F)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xa6f73589243a6A7a9023b1Fa0651b1d89c177111)
 */
export function useAddressManagerWrite<
  TFunctionName extends string,
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof addressManagerAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof addressManagerABI,
          string
        >['request']['abi'],
        TFunctionName,
        TMode
      > & { address?: Address; chainId?: TChainId }
    : UseContractWriteConfig<typeof addressManagerABI, TFunctionName, TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
      } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractWrite<typeof addressManagerABI, TFunctionName, TMode>({
    abi: addressManagerABI,
    address:
      addressManagerAddress[chainId as keyof typeof addressManagerAddress],
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link addressManagerABI}__ and `functionName` set to `"renounceOwnership"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdE1FCfB0851916CA5101820A69b13a4E276bd81F)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xa6f73589243a6A7a9023b1Fa0651b1d89c177111)
 */
export function useAddressManagerRenounceOwnership<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof addressManagerAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof addressManagerABI,
          'renounceOwnership'
        >['request']['abi'],
        'renounceOwnership',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'renounceOwnership'
      }
    : UseContractWriteConfig<
        typeof addressManagerABI,
        'renounceOwnership',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'renounceOwnership'
      } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractWrite<typeof addressManagerABI, 'renounceOwnership', TMode>(
    {
      abi: addressManagerABI,
      address:
        addressManagerAddress[chainId as keyof typeof addressManagerAddress],
      functionName: 'renounceOwnership',
      ...config,
    } as any
  )
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link addressManagerABI}__ and `functionName` set to `"setAddress"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdE1FCfB0851916CA5101820A69b13a4E276bd81F)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xa6f73589243a6A7a9023b1Fa0651b1d89c177111)
 */
export function useAddressManagerSetAddress<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof addressManagerAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof addressManagerABI,
          'setAddress'
        >['request']['abi'],
        'setAddress',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'setAddress' }
    : UseContractWriteConfig<typeof addressManagerABI, 'setAddress', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'setAddress'
      } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractWrite<typeof addressManagerABI, 'setAddress', TMode>({
    abi: addressManagerABI,
    address:
      addressManagerAddress[chainId as keyof typeof addressManagerAddress],
    functionName: 'setAddress',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link addressManagerABI}__ and `functionName` set to `"transferOwnership"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdE1FCfB0851916CA5101820A69b13a4E276bd81F)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xa6f73589243a6A7a9023b1Fa0651b1d89c177111)
 */
export function useAddressManagerTransferOwnership<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof addressManagerAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof addressManagerABI,
          'transferOwnership'
        >['request']['abi'],
        'transferOwnership',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'transferOwnership'
      }
    : UseContractWriteConfig<
        typeof addressManagerABI,
        'transferOwnership',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'transferOwnership'
      } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractWrite<typeof addressManagerABI, 'transferOwnership', TMode>(
    {
      abi: addressManagerABI,
      address:
        addressManagerAddress[chainId as keyof typeof addressManagerAddress],
      functionName: 'transferOwnership',
      ...config,
    } as any
  )
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link addressManagerABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdE1FCfB0851916CA5101820A69b13a4E276bd81F)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xa6f73589243a6A7a9023b1Fa0651b1d89c177111)
 */
export function usePrepareAddressManagerWrite<TFunctionName extends string>(
  config: Omit<
    UsePrepareContractWriteConfig<typeof addressManagerABI, TFunctionName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof addressManagerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return usePrepareContractWrite({
    abi: addressManagerABI,
    address:
      addressManagerAddress[chainId as keyof typeof addressManagerAddress],
    ...config,
  } as UsePrepareContractWriteConfig<typeof addressManagerABI, TFunctionName>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link addressManagerABI}__ and `functionName` set to `"renounceOwnership"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdE1FCfB0851916CA5101820A69b13a4E276bd81F)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xa6f73589243a6A7a9023b1Fa0651b1d89c177111)
 */
export function usePrepareAddressManagerRenounceOwnership(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof addressManagerABI,
      'renounceOwnership'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof addressManagerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return usePrepareContractWrite({
    abi: addressManagerABI,
    address:
      addressManagerAddress[chainId as keyof typeof addressManagerAddress],
    functionName: 'renounceOwnership',
    ...config,
  } as UsePrepareContractWriteConfig<typeof addressManagerABI, 'renounceOwnership'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link addressManagerABI}__ and `functionName` set to `"setAddress"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdE1FCfB0851916CA5101820A69b13a4E276bd81F)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xa6f73589243a6A7a9023b1Fa0651b1d89c177111)
 */
export function usePrepareAddressManagerSetAddress(
  config: Omit<
    UsePrepareContractWriteConfig<typeof addressManagerABI, 'setAddress'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof addressManagerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return usePrepareContractWrite({
    abi: addressManagerABI,
    address:
      addressManagerAddress[chainId as keyof typeof addressManagerAddress],
    functionName: 'setAddress',
    ...config,
  } as UsePrepareContractWriteConfig<typeof addressManagerABI, 'setAddress'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link addressManagerABI}__ and `functionName` set to `"transferOwnership"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdE1FCfB0851916CA5101820A69b13a4E276bd81F)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xa6f73589243a6A7a9023b1Fa0651b1d89c177111)
 */
export function usePrepareAddressManagerTransferOwnership(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof addressManagerABI,
      'transferOwnership'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof addressManagerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return usePrepareContractWrite({
    abi: addressManagerABI,
    address:
      addressManagerAddress[chainId as keyof typeof addressManagerAddress],
    functionName: 'transferOwnership',
    ...config,
  } as UsePrepareContractWriteConfig<typeof addressManagerABI, 'transferOwnership'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link addressManagerABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdE1FCfB0851916CA5101820A69b13a4E276bd81F)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xa6f73589243a6A7a9023b1Fa0651b1d89c177111)
 */
export function useAddressManagerEvent<TEventName extends string>(
  config: Omit<
    UseContractEventConfig<typeof addressManagerABI, TEventName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof addressManagerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractEvent({
    abi: addressManagerABI,
    address:
      addressManagerAddress[chainId as keyof typeof addressManagerAddress],
    ...config,
  } as UseContractEventConfig<typeof addressManagerABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link addressManagerABI}__ and `eventName` set to `"AddressSet"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdE1FCfB0851916CA5101820A69b13a4E276bd81F)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xa6f73589243a6A7a9023b1Fa0651b1d89c177111)
 */
export function useAddressManagerAddressSetEvent(
  config: Omit<
    UseContractEventConfig<typeof addressManagerABI, 'AddressSet'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof addressManagerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractEvent({
    abi: addressManagerABI,
    address:
      addressManagerAddress[chainId as keyof typeof addressManagerAddress],
    eventName: 'AddressSet',
    ...config,
  } as UseContractEventConfig<typeof addressManagerABI, 'AddressSet'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link addressManagerABI}__ and `eventName` set to `"OwnershipTransferred"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdE1FCfB0851916CA5101820A69b13a4E276bd81F)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xa6f73589243a6A7a9023b1Fa0651b1d89c177111)
 */
export function useAddressManagerOwnershipTransferredEvent(
  config: Omit<
    UseContractEventConfig<typeof addressManagerABI, 'OwnershipTransferred'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof addressManagerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractEvent({
    abi: addressManagerABI,
    address:
      addressManagerAddress[chainId as keyof typeof addressManagerAddress],
    eventName: 'OwnershipTransferred',
    ...config,
  } as UseContractEventConfig<typeof addressManagerABI, 'OwnershipTransferred'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link assetReceiverABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 */
export function useAssetReceiverRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<typeof assetReceiverABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof assetReceiverABI, TFunctionName, TSelectData>,
    'abi' | 'address'
  > & { chainId?: keyof typeof assetReceiverAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractRead({
    abi: assetReceiverABI,
    address: assetReceiverAddress[chainId as keyof typeof assetReceiverAddress],
    ...config,
  } as UseContractReadConfig<typeof assetReceiverABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link assetReceiverABI}__ and `functionName` set to `"owner"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 */
export function useAssetReceiverOwner<
  TFunctionName extends 'owner',
  TSelectData = ReadContractResult<typeof assetReceiverABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof assetReceiverABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof assetReceiverAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractRead({
    abi: assetReceiverABI,
    address: assetReceiverAddress[chainId as keyof typeof assetReceiverAddress],
    functionName: 'owner',
    ...config,
  } as UseContractReadConfig<typeof assetReceiverABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link assetReceiverABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 */
export function useAssetReceiverWrite<
  TFunctionName extends string,
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof assetReceiverAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof assetReceiverABI,
          string
        >['request']['abi'],
        TFunctionName,
        TMode
      > & { address?: Address; chainId?: TChainId }
    : UseContractWriteConfig<typeof assetReceiverABI, TFunctionName, TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
      } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractWrite<typeof assetReceiverABI, TFunctionName, TMode>({
    abi: assetReceiverABI,
    address: assetReceiverAddress[chainId as keyof typeof assetReceiverAddress],
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link assetReceiverABI}__ and `functionName` set to `"CALL"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 */
export function useAssetReceiverCall<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof assetReceiverAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof assetReceiverABI,
          'CALL'
        >['request']['abi'],
        'CALL',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'CALL' }
    : UseContractWriteConfig<typeof assetReceiverABI, 'CALL', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'CALL'
      } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractWrite<typeof assetReceiverABI, 'CALL', TMode>({
    abi: assetReceiverABI,
    address: assetReceiverAddress[chainId as keyof typeof assetReceiverAddress],
    functionName: 'CALL',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link assetReceiverABI}__ and `functionName` set to `"DELEGATECALL"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 */
export function useAssetReceiverDelegatecall<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof assetReceiverAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof assetReceiverABI,
          'DELEGATECALL'
        >['request']['abi'],
        'DELEGATECALL',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'DELEGATECALL'
      }
    : UseContractWriteConfig<typeof assetReceiverABI, 'DELEGATECALL', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'DELEGATECALL'
      } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractWrite<typeof assetReceiverABI, 'DELEGATECALL', TMode>({
    abi: assetReceiverABI,
    address: assetReceiverAddress[chainId as keyof typeof assetReceiverAddress],
    functionName: 'DELEGATECALL',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link assetReceiverABI}__ and `functionName` set to `"setOwner"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 */
export function useAssetReceiverSetOwner<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof assetReceiverAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof assetReceiverABI,
          'setOwner'
        >['request']['abi'],
        'setOwner',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'setOwner' }
    : UseContractWriteConfig<typeof assetReceiverABI, 'setOwner', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'setOwner'
      } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractWrite<typeof assetReceiverABI, 'setOwner', TMode>({
    abi: assetReceiverABI,
    address: assetReceiverAddress[chainId as keyof typeof assetReceiverAddress],
    functionName: 'setOwner',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link assetReceiverABI}__ and `functionName` set to `"withdrawERC20"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 */
export function useAssetReceiverWithdrawErc20<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof assetReceiverAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof assetReceiverABI,
          'withdrawERC20'
        >['request']['abi'],
        'withdrawERC20',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'withdrawERC20'
      }
    : UseContractWriteConfig<
        typeof assetReceiverABI,
        'withdrawERC20',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'withdrawERC20'
      } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractWrite<typeof assetReceiverABI, 'withdrawERC20', TMode>({
    abi: assetReceiverABI,
    address: assetReceiverAddress[chainId as keyof typeof assetReceiverAddress],
    functionName: 'withdrawERC20',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link assetReceiverABI}__ and `functionName` set to `"withdrawERC721"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 */
export function useAssetReceiverWithdrawErc721<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof assetReceiverAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof assetReceiverABI,
          'withdrawERC721'
        >['request']['abi'],
        'withdrawERC721',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'withdrawERC721'
      }
    : UseContractWriteConfig<
        typeof assetReceiverABI,
        'withdrawERC721',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'withdrawERC721'
      } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractWrite<typeof assetReceiverABI, 'withdrawERC721', TMode>({
    abi: assetReceiverABI,
    address: assetReceiverAddress[chainId as keyof typeof assetReceiverAddress],
    functionName: 'withdrawERC721',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link assetReceiverABI}__ and `functionName` set to `"withdrawETH"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 */
export function useAssetReceiverWithdrawEth<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof assetReceiverAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof assetReceiverABI,
          'withdrawETH'
        >['request']['abi'],
        'withdrawETH',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'withdrawETH'
      }
    : UseContractWriteConfig<typeof assetReceiverABI, 'withdrawETH', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'withdrawETH'
      } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractWrite<typeof assetReceiverABI, 'withdrawETH', TMode>({
    abi: assetReceiverABI,
    address: assetReceiverAddress[chainId as keyof typeof assetReceiverAddress],
    functionName: 'withdrawETH',
    ...config,
  } as any)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link assetReceiverABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 */
export function usePrepareAssetReceiverWrite<TFunctionName extends string>(
  config: Omit<
    UsePrepareContractWriteConfig<typeof assetReceiverABI, TFunctionName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof assetReceiverAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return usePrepareContractWrite({
    abi: assetReceiverABI,
    address: assetReceiverAddress[chainId as keyof typeof assetReceiverAddress],
    ...config,
  } as UsePrepareContractWriteConfig<typeof assetReceiverABI, TFunctionName>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link assetReceiverABI}__ and `functionName` set to `"CALL"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 */
export function usePrepareAssetReceiverCall(
  config: Omit<
    UsePrepareContractWriteConfig<typeof assetReceiverABI, 'CALL'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof assetReceiverAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return usePrepareContractWrite({
    abi: assetReceiverABI,
    address: assetReceiverAddress[chainId as keyof typeof assetReceiverAddress],
    functionName: 'CALL',
    ...config,
  } as UsePrepareContractWriteConfig<typeof assetReceiverABI, 'CALL'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link assetReceiverABI}__ and `functionName` set to `"DELEGATECALL"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 */
export function usePrepareAssetReceiverDelegatecall(
  config: Omit<
    UsePrepareContractWriteConfig<typeof assetReceiverABI, 'DELEGATECALL'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof assetReceiverAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return usePrepareContractWrite({
    abi: assetReceiverABI,
    address: assetReceiverAddress[chainId as keyof typeof assetReceiverAddress],
    functionName: 'DELEGATECALL',
    ...config,
  } as UsePrepareContractWriteConfig<typeof assetReceiverABI, 'DELEGATECALL'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link assetReceiverABI}__ and `functionName` set to `"setOwner"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 */
export function usePrepareAssetReceiverSetOwner(
  config: Omit<
    UsePrepareContractWriteConfig<typeof assetReceiverABI, 'setOwner'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof assetReceiverAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return usePrepareContractWrite({
    abi: assetReceiverABI,
    address: assetReceiverAddress[chainId as keyof typeof assetReceiverAddress],
    functionName: 'setOwner',
    ...config,
  } as UsePrepareContractWriteConfig<typeof assetReceiverABI, 'setOwner'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link assetReceiverABI}__ and `functionName` set to `"withdrawERC20"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 */
export function usePrepareAssetReceiverWithdrawErc20(
  config: Omit<
    UsePrepareContractWriteConfig<typeof assetReceiverABI, 'withdrawERC20'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof assetReceiverAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return usePrepareContractWrite({
    abi: assetReceiverABI,
    address: assetReceiverAddress[chainId as keyof typeof assetReceiverAddress],
    functionName: 'withdrawERC20',
    ...config,
  } as UsePrepareContractWriteConfig<typeof assetReceiverABI, 'withdrawERC20'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link assetReceiverABI}__ and `functionName` set to `"withdrawERC721"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 */
export function usePrepareAssetReceiverWithdrawErc721(
  config: Omit<
    UsePrepareContractWriteConfig<typeof assetReceiverABI, 'withdrawERC721'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof assetReceiverAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return usePrepareContractWrite({
    abi: assetReceiverABI,
    address: assetReceiverAddress[chainId as keyof typeof assetReceiverAddress],
    functionName: 'withdrawERC721',
    ...config,
  } as UsePrepareContractWriteConfig<typeof assetReceiverABI, 'withdrawERC721'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link assetReceiverABI}__ and `functionName` set to `"withdrawETH"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 */
export function usePrepareAssetReceiverWithdrawEth(
  config: Omit<
    UsePrepareContractWriteConfig<typeof assetReceiverABI, 'withdrawETH'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof assetReceiverAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return usePrepareContractWrite({
    abi: assetReceiverABI,
    address: assetReceiverAddress[chainId as keyof typeof assetReceiverAddress],
    functionName: 'withdrawETH',
    ...config,
  } as UsePrepareContractWriteConfig<typeof assetReceiverABI, 'withdrawETH'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link assetReceiverABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 */
export function useAssetReceiverEvent<TEventName extends string>(
  config: Omit<
    UseContractEventConfig<typeof assetReceiverABI, TEventName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof assetReceiverAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractEvent({
    abi: assetReceiverABI,
    address: assetReceiverAddress[chainId as keyof typeof assetReceiverAddress],
    ...config,
  } as UseContractEventConfig<typeof assetReceiverABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link assetReceiverABI}__ and `eventName` set to `"OwnerUpdated"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 */
export function useAssetReceiverOwnerUpdatedEvent(
  config: Omit<
    UseContractEventConfig<typeof assetReceiverABI, 'OwnerUpdated'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof assetReceiverAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractEvent({
    abi: assetReceiverABI,
    address: assetReceiverAddress[chainId as keyof typeof assetReceiverAddress],
    eventName: 'OwnerUpdated',
    ...config,
  } as UseContractEventConfig<typeof assetReceiverABI, 'OwnerUpdated'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link assetReceiverABI}__ and `eventName` set to `"ReceivedETH"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 */
export function useAssetReceiverReceivedEthEvent(
  config: Omit<
    UseContractEventConfig<typeof assetReceiverABI, 'ReceivedETH'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof assetReceiverAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractEvent({
    abi: assetReceiverABI,
    address: assetReceiverAddress[chainId as keyof typeof assetReceiverAddress],
    eventName: 'ReceivedETH',
    ...config,
  } as UseContractEventConfig<typeof assetReceiverABI, 'ReceivedETH'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link assetReceiverABI}__ and `eventName` set to `"WithdrewERC20"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 */
export function useAssetReceiverWithdrewErc20Event(
  config: Omit<
    UseContractEventConfig<typeof assetReceiverABI, 'WithdrewERC20'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof assetReceiverAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractEvent({
    abi: assetReceiverABI,
    address: assetReceiverAddress[chainId as keyof typeof assetReceiverAddress],
    eventName: 'WithdrewERC20',
    ...config,
  } as UseContractEventConfig<typeof assetReceiverABI, 'WithdrewERC20'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link assetReceiverABI}__ and `eventName` set to `"WithdrewERC721"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 */
export function useAssetReceiverWithdrewErc721Event(
  config: Omit<
    UseContractEventConfig<typeof assetReceiverABI, 'WithdrewERC721'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof assetReceiverAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractEvent({
    abi: assetReceiverABI,
    address: assetReceiverAddress[chainId as keyof typeof assetReceiverAddress],
    eventName: 'WithdrewERC721',
    ...config,
  } as UseContractEventConfig<typeof assetReceiverABI, 'WithdrewERC721'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link assetReceiverABI}__ and `eventName` set to `"WithdrewETH"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 */
export function useAssetReceiverWithdrewEthEvent(
  config: Omit<
    UseContractEventConfig<typeof assetReceiverABI, 'WithdrewETH'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof assetReceiverAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractEvent({
    abi: assetReceiverABI,
    address: assetReceiverAddress[chainId as keyof typeof assetReceiverAddress],
    eventName: 'WithdrewETH',
    ...config,
  } as UseContractEventConfig<typeof assetReceiverABI, 'WithdrewETH'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link attestationStationABI}__.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0xEE36eaaD94d1Cc1d0eccaDb55C38bFfB6Be06C77)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0xEE36eaaD94d1Cc1d0eccaDb55C38bFfB6Be06C77)
 */
export function useAttestationStationRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<typeof attestationStationABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof attestationStationABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address'
  > & { chainId?: keyof typeof attestationStationAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractRead({
    abi: attestationStationABI,
    address:
      attestationStationAddress[
        chainId as keyof typeof attestationStationAddress
      ],
    ...config,
  } as UseContractReadConfig<typeof attestationStationABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link attestationStationABI}__ and `functionName` set to `"attestations"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0xEE36eaaD94d1Cc1d0eccaDb55C38bFfB6Be06C77)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0xEE36eaaD94d1Cc1d0eccaDb55C38bFfB6Be06C77)
 */
export function useAttestationStationAttestations<
  TFunctionName extends 'attestations',
  TSelectData = ReadContractResult<typeof attestationStationABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof attestationStationABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof attestationStationAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractRead({
    abi: attestationStationABI,
    address:
      attestationStationAddress[
        chainId as keyof typeof attestationStationAddress
      ],
    functionName: 'attestations',
    ...config,
  } as UseContractReadConfig<typeof attestationStationABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link attestationStationABI}__ and `functionName` set to `"version"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0xEE36eaaD94d1Cc1d0eccaDb55C38bFfB6Be06C77)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0xEE36eaaD94d1Cc1d0eccaDb55C38bFfB6Be06C77)
 */
export function useAttestationStationVersion<
  TFunctionName extends 'version',
  TSelectData = ReadContractResult<typeof attestationStationABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof attestationStationABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof attestationStationAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractRead({
    abi: attestationStationABI,
    address:
      attestationStationAddress[
        chainId as keyof typeof attestationStationAddress
      ],
    functionName: 'version',
    ...config,
  } as UseContractReadConfig<typeof attestationStationABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link attestationStationABI}__.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0xEE36eaaD94d1Cc1d0eccaDb55C38bFfB6Be06C77)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0xEE36eaaD94d1Cc1d0eccaDb55C38bFfB6Be06C77)
 */
export function useAttestationStationWrite<
  TFunctionName extends string,
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof attestationStationAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof attestationStationABI,
          string
        >['request']['abi'],
        TFunctionName,
        TMode
      > & { address?: Address; chainId?: TChainId }
    : UseContractWriteConfig<
        typeof attestationStationABI,
        TFunctionName,
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
      } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractWrite<typeof attestationStationABI, TFunctionName, TMode>({
    abi: attestationStationABI,
    address:
      attestationStationAddress[
        chainId as keyof typeof attestationStationAddress
      ],
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link attestationStationABI}__ and `functionName` set to `"attest"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0xEE36eaaD94d1Cc1d0eccaDb55C38bFfB6Be06C77)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0xEE36eaaD94d1Cc1d0eccaDb55C38bFfB6Be06C77)
 */
export function useAttestationStationAttest<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof attestationStationAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof attestationStationABI,
          'attest'
        >['request']['abi'],
        'attest',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'attest' }
    : UseContractWriteConfig<typeof attestationStationABI, 'attest', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'attest'
      } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractWrite<typeof attestationStationABI, 'attest', TMode>({
    abi: attestationStationABI,
    address:
      attestationStationAddress[
        chainId as keyof typeof attestationStationAddress
      ],
    functionName: 'attest',
    ...config,
  } as any)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link attestationStationABI}__.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0xEE36eaaD94d1Cc1d0eccaDb55C38bFfB6Be06C77)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0xEE36eaaD94d1Cc1d0eccaDb55C38bFfB6Be06C77)
 */
export function usePrepareAttestationStationWrite<TFunctionName extends string>(
  config: Omit<
    UsePrepareContractWriteConfig<typeof attestationStationABI, TFunctionName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof attestationStationAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return usePrepareContractWrite({
    abi: attestationStationABI,
    address:
      attestationStationAddress[
        chainId as keyof typeof attestationStationAddress
      ],
    ...config,
  } as UsePrepareContractWriteConfig<typeof attestationStationABI, TFunctionName>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link attestationStationABI}__ and `functionName` set to `"attest"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0xEE36eaaD94d1Cc1d0eccaDb55C38bFfB6Be06C77)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0xEE36eaaD94d1Cc1d0eccaDb55C38bFfB6Be06C77)
 */
export function usePrepareAttestationStationAttest(
  config: Omit<
    UsePrepareContractWriteConfig<typeof attestationStationABI, 'attest'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof attestationStationAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return usePrepareContractWrite({
    abi: attestationStationABI,
    address:
      attestationStationAddress[
        chainId as keyof typeof attestationStationAddress
      ],
    functionName: 'attest',
    ...config,
  } as UsePrepareContractWriteConfig<typeof attestationStationABI, 'attest'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link attestationStationABI}__.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0xEE36eaaD94d1Cc1d0eccaDb55C38bFfB6Be06C77)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0xEE36eaaD94d1Cc1d0eccaDb55C38bFfB6Be06C77)
 */
export function useAttestationStationEvent<TEventName extends string>(
  config: Omit<
    UseContractEventConfig<typeof attestationStationABI, TEventName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof attestationStationAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractEvent({
    abi: attestationStationABI,
    address:
      attestationStationAddress[
        chainId as keyof typeof attestationStationAddress
      ],
    ...config,
  } as UseContractEventConfig<typeof attestationStationABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link attestationStationABI}__ and `eventName` set to `"AttestationCreated"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0xEE36eaaD94d1Cc1d0eccaDb55C38bFfB6Be06C77)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0xEE36eaaD94d1Cc1d0eccaDb55C38bFfB6Be06C77)
 */
export function useAttestationStationAttestationCreatedEvent(
  config: Omit<
    UseContractEventConfig<typeof attestationStationABI, 'AttestationCreated'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof attestationStationAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractEvent({
    abi: attestationStationABI,
    address:
      attestationStationAddress[
        chainId as keyof typeof attestationStationAddress
      ],
    eventName: 'AttestationCreated',
    ...config,
  } as UseContractEventConfig<typeof attestationStationABI, 'AttestationCreated'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link baseFeeVaultABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000019)
 */
export function useBaseFeeVaultRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<typeof baseFeeVaultABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof baseFeeVaultABI, TFunctionName, TSelectData>,
    'abi' | 'address'
  > & { chainId?: keyof typeof baseFeeVaultAddress } = {} as any
) {
  return useContractRead({
    abi: baseFeeVaultABI,
    address: baseFeeVaultAddress[420],
    ...config,
  } as UseContractReadConfig<typeof baseFeeVaultABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link baseFeeVaultABI}__ and `functionName` set to `"MIN_WITHDRAWAL_AMOUNT"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000019)
 */
export function useBaseFeeVaultMinWithdrawalAmount<
  TFunctionName extends 'MIN_WITHDRAWAL_AMOUNT',
  TSelectData = ReadContractResult<typeof baseFeeVaultABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof baseFeeVaultABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof baseFeeVaultAddress } = {} as any
) {
  return useContractRead({
    abi: baseFeeVaultABI,
    address: baseFeeVaultAddress[420],
    functionName: 'MIN_WITHDRAWAL_AMOUNT',
    ...config,
  } as UseContractReadConfig<typeof baseFeeVaultABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link baseFeeVaultABI}__ and `functionName` set to `"RECIPIENT"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000019)
 */
export function useBaseFeeVaultRecipient<
  TFunctionName extends 'RECIPIENT',
  TSelectData = ReadContractResult<typeof baseFeeVaultABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof baseFeeVaultABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof baseFeeVaultAddress } = {} as any
) {
  return useContractRead({
    abi: baseFeeVaultABI,
    address: baseFeeVaultAddress[420],
    functionName: 'RECIPIENT',
    ...config,
  } as UseContractReadConfig<typeof baseFeeVaultABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link baseFeeVaultABI}__ and `functionName` set to `"totalProcessed"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000019)
 */
export function useBaseFeeVaultTotalProcessed<
  TFunctionName extends 'totalProcessed',
  TSelectData = ReadContractResult<typeof baseFeeVaultABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof baseFeeVaultABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof baseFeeVaultAddress } = {} as any
) {
  return useContractRead({
    abi: baseFeeVaultABI,
    address: baseFeeVaultAddress[420],
    functionName: 'totalProcessed',
    ...config,
  } as UseContractReadConfig<typeof baseFeeVaultABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link baseFeeVaultABI}__ and `functionName` set to `"version"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000019)
 */
export function useBaseFeeVaultVersion<
  TFunctionName extends 'version',
  TSelectData = ReadContractResult<typeof baseFeeVaultABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof baseFeeVaultABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof baseFeeVaultAddress } = {} as any
) {
  return useContractRead({
    abi: baseFeeVaultABI,
    address: baseFeeVaultAddress[420],
    functionName: 'version',
    ...config,
  } as UseContractReadConfig<typeof baseFeeVaultABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link baseFeeVaultABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000019)
 */
export function useBaseFeeVaultWrite<
  TFunctionName extends string,
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof baseFeeVaultAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof baseFeeVaultABI,
          string
        >['request']['abi'],
        TFunctionName,
        TMode
      > & { address?: Address; chainId?: TChainId }
    : UseContractWriteConfig<typeof baseFeeVaultABI, TFunctionName, TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
      } = {} as any
) {
  return useContractWrite<typeof baseFeeVaultABI, TFunctionName, TMode>({
    abi: baseFeeVaultABI,
    address: baseFeeVaultAddress[420],
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link baseFeeVaultABI}__ and `functionName` set to `"withdraw"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000019)
 */
export function useBaseFeeVaultWithdraw<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof baseFeeVaultAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof baseFeeVaultABI,
          'withdraw'
        >['request']['abi'],
        'withdraw',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'withdraw' }
    : UseContractWriteConfig<typeof baseFeeVaultABI, 'withdraw', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'withdraw'
      } = {} as any
) {
  return useContractWrite<typeof baseFeeVaultABI, 'withdraw', TMode>({
    abi: baseFeeVaultABI,
    address: baseFeeVaultAddress[420],
    functionName: 'withdraw',
    ...config,
  } as any)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link baseFeeVaultABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000019)
 */
export function usePrepareBaseFeeVaultWrite<TFunctionName extends string>(
  config: Omit<
    UsePrepareContractWriteConfig<typeof baseFeeVaultABI, TFunctionName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof baseFeeVaultAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: baseFeeVaultABI,
    address: baseFeeVaultAddress[420],
    ...config,
  } as UsePrepareContractWriteConfig<typeof baseFeeVaultABI, TFunctionName>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link baseFeeVaultABI}__ and `functionName` set to `"withdraw"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000019)
 */
export function usePrepareBaseFeeVaultWithdraw(
  config: Omit<
    UsePrepareContractWriteConfig<typeof baseFeeVaultABI, 'withdraw'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof baseFeeVaultAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: baseFeeVaultABI,
    address: baseFeeVaultAddress[420],
    functionName: 'withdraw',
    ...config,
  } as UsePrepareContractWriteConfig<typeof baseFeeVaultABI, 'withdraw'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link baseFeeVaultABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000019)
 */
export function useBaseFeeVaultEvent<TEventName extends string>(
  config: Omit<
    UseContractEventConfig<typeof baseFeeVaultABI, TEventName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof baseFeeVaultAddress } = {} as any
) {
  return useContractEvent({
    abi: baseFeeVaultABI,
    address: baseFeeVaultAddress[420],
    ...config,
  } as UseContractEventConfig<typeof baseFeeVaultABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link baseFeeVaultABI}__ and `eventName` set to `"Withdrawal"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000019)
 */
export function useBaseFeeVaultWithdrawalEvent(
  config: Omit<
    UseContractEventConfig<typeof baseFeeVaultABI, 'Withdrawal'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof baseFeeVaultAddress } = {} as any
) {
  return useContractEvent({
    abi: baseFeeVaultABI,
    address: baseFeeVaultAddress[420],
    eventName: 'Withdrawal',
    ...config,
  } as UseContractEventConfig<typeof baseFeeVaultABI, 'Withdrawal'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link checkBalanceHighABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x7eC64a8a591bFf829ff6C8be76074D540ACb813F)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x7eC64a8a591bFf829ff6C8be76074D540ACb813F)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5d7103853f12109A7d27F118e54BbC654ad847E9)
 */
export function useCheckBalanceHighRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<typeof checkBalanceHighABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof checkBalanceHighABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address'
  > & { chainId?: keyof typeof checkBalanceHighAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractRead({
    abi: checkBalanceHighABI,
    address:
      checkBalanceHighAddress[chainId as keyof typeof checkBalanceHighAddress],
    ...config,
  } as UseContractReadConfig<typeof checkBalanceHighABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link checkBalanceHighABI}__ and `functionName` set to `"check"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x7eC64a8a591bFf829ff6C8be76074D540ACb813F)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x7eC64a8a591bFf829ff6C8be76074D540ACb813F)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5d7103853f12109A7d27F118e54BbC654ad847E9)
 */
export function useCheckBalanceHighCheck<
  TFunctionName extends 'check',
  TSelectData = ReadContractResult<typeof checkBalanceHighABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof checkBalanceHighABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof checkBalanceHighAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractRead({
    abi: checkBalanceHighABI,
    address:
      checkBalanceHighAddress[chainId as keyof typeof checkBalanceHighAddress],
    functionName: 'check',
    ...config,
  } as UseContractReadConfig<typeof checkBalanceHighABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link checkBalanceHighABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x7eC64a8a591bFf829ff6C8be76074D540ACb813F)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x7eC64a8a591bFf829ff6C8be76074D540ACb813F)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5d7103853f12109A7d27F118e54BbC654ad847E9)
 */
export function useCheckBalanceHighEvent<TEventName extends string>(
  config: Omit<
    UseContractEventConfig<typeof checkBalanceHighABI, TEventName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof checkBalanceHighAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractEvent({
    abi: checkBalanceHighABI,
    address:
      checkBalanceHighAddress[chainId as keyof typeof checkBalanceHighAddress],
    ...config,
  } as UseContractEventConfig<typeof checkBalanceHighABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link checkBalanceHighABI}__ and `eventName` set to `"_EventToExposeStructInABI__Params"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x7eC64a8a591bFf829ff6C8be76074D540ACb813F)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x7eC64a8a591bFf829ff6C8be76074D540ACb813F)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5d7103853f12109A7d27F118e54BbC654ad847E9)
 */
export function useCheckBalanceHighEventToExposeStructInAbiParamsEvent(
  config: Omit<
    UseContractEventConfig<
      typeof checkBalanceHighABI,
      '_EventToExposeStructInABI__Params'
    >,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof checkBalanceHighAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractEvent({
    abi: checkBalanceHighABI,
    address:
      checkBalanceHighAddress[chainId as keyof typeof checkBalanceHighAddress],
    eventName: '_EventToExposeStructInABI__Params',
    ...config,
  } as UseContractEventConfig<typeof checkBalanceHighABI, '_EventToExposeStructInABI__Params'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link checkBalanceLowABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x381a4eFC2A2C914eA1889722bB4B44Fa6BD5b640)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x381a4eFC2A2C914eA1889722bB4B44Fa6BD5b640)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x7Ce13D154FAEE5C8B3E6b19d4Add16f21d884474)
 */
export function useCheckBalanceLowRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<typeof checkBalanceLowABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof checkBalanceLowABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address'
  > & { chainId?: keyof typeof checkBalanceLowAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractRead({
    abi: checkBalanceLowABI,
    address:
      checkBalanceLowAddress[chainId as keyof typeof checkBalanceLowAddress],
    ...config,
  } as UseContractReadConfig<typeof checkBalanceLowABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link checkBalanceLowABI}__ and `functionName` set to `"check"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x381a4eFC2A2C914eA1889722bB4B44Fa6BD5b640)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x381a4eFC2A2C914eA1889722bB4B44Fa6BD5b640)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x7Ce13D154FAEE5C8B3E6b19d4Add16f21d884474)
 */
export function useCheckBalanceLowCheck<
  TFunctionName extends 'check',
  TSelectData = ReadContractResult<typeof checkBalanceLowABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof checkBalanceLowABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof checkBalanceLowAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractRead({
    abi: checkBalanceLowABI,
    address:
      checkBalanceLowAddress[chainId as keyof typeof checkBalanceLowAddress],
    functionName: 'check',
    ...config,
  } as UseContractReadConfig<typeof checkBalanceLowABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link checkBalanceLowABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x381a4eFC2A2C914eA1889722bB4B44Fa6BD5b640)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x381a4eFC2A2C914eA1889722bB4B44Fa6BD5b640)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x7Ce13D154FAEE5C8B3E6b19d4Add16f21d884474)
 */
export function useCheckBalanceLowEvent<TEventName extends string>(
  config: Omit<
    UseContractEventConfig<typeof checkBalanceLowABI, TEventName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof checkBalanceLowAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractEvent({
    abi: checkBalanceLowABI,
    address:
      checkBalanceLowAddress[chainId as keyof typeof checkBalanceLowAddress],
    ...config,
  } as UseContractEventConfig<typeof checkBalanceLowABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link checkBalanceLowABI}__ and `eventName` set to `"_EventToExposeStructInABI__Params"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x381a4eFC2A2C914eA1889722bB4B44Fa6BD5b640)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x381a4eFC2A2C914eA1889722bB4B44Fa6BD5b640)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x7Ce13D154FAEE5C8B3E6b19d4Add16f21d884474)
 */
export function useCheckBalanceLowEventToExposeStructInAbiParamsEvent(
  config: Omit<
    UseContractEventConfig<
      typeof checkBalanceLowABI,
      '_EventToExposeStructInABI__Params'
    >,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof checkBalanceLowAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractEvent({
    abi: checkBalanceLowABI,
    address:
      checkBalanceLowAddress[chainId as keyof typeof checkBalanceLowAddress],
    eventName: '_EventToExposeStructInABI__Params',
    ...config,
  } as UseContractEventConfig<typeof checkBalanceLowABI, '_EventToExposeStructInABI__Params'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link checkGelatoLowABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4f7CFc43f6D262a085F3b946cAC69E7a8E39BBAa)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4f7CFc43f6D262a085F3b946cAC69E7a8E39BBAa)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0xF9c8a4Cb4021f57F9f6d69799cA9BefF64524862)
 */
export function useCheckGelatoLowRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<typeof checkGelatoLowABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof checkGelatoLowABI, TFunctionName, TSelectData>,
    'abi' | 'address'
  > & { chainId?: keyof typeof checkGelatoLowAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractRead({
    abi: checkGelatoLowABI,
    address:
      checkGelatoLowAddress[chainId as keyof typeof checkGelatoLowAddress],
    ...config,
  } as UseContractReadConfig<typeof checkGelatoLowABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link checkGelatoLowABI}__ and `functionName` set to `"check"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4f7CFc43f6D262a085F3b946cAC69E7a8E39BBAa)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4f7CFc43f6D262a085F3b946cAC69E7a8E39BBAa)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0xF9c8a4Cb4021f57F9f6d69799cA9BefF64524862)
 */
export function useCheckGelatoLowCheck<
  TFunctionName extends 'check',
  TSelectData = ReadContractResult<typeof checkGelatoLowABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof checkGelatoLowABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof checkGelatoLowAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractRead({
    abi: checkGelatoLowABI,
    address:
      checkGelatoLowAddress[chainId as keyof typeof checkGelatoLowAddress],
    functionName: 'check',
    ...config,
  } as UseContractReadConfig<typeof checkGelatoLowABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link checkGelatoLowABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4f7CFc43f6D262a085F3b946cAC69E7a8E39BBAa)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4f7CFc43f6D262a085F3b946cAC69E7a8E39BBAa)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0xF9c8a4Cb4021f57F9f6d69799cA9BefF64524862)
 */
export function useCheckGelatoLowEvent<TEventName extends string>(
  config: Omit<
    UseContractEventConfig<typeof checkGelatoLowABI, TEventName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof checkGelatoLowAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractEvent({
    abi: checkGelatoLowABI,
    address:
      checkGelatoLowAddress[chainId as keyof typeof checkGelatoLowAddress],
    ...config,
  } as UseContractEventConfig<typeof checkGelatoLowABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link checkGelatoLowABI}__ and `eventName` set to `"_EventToExposeStructInABI__Params"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4f7CFc43f6D262a085F3b946cAC69E7a8E39BBAa)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4f7CFc43f6D262a085F3b946cAC69E7a8E39BBAa)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0xF9c8a4Cb4021f57F9f6d69799cA9BefF64524862)
 */
export function useCheckGelatoLowEventToExposeStructInAbiParamsEvent(
  config: Omit<
    UseContractEventConfig<
      typeof checkGelatoLowABI,
      '_EventToExposeStructInABI__Params'
    >,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof checkGelatoLowAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractEvent({
    abi: checkGelatoLowABI,
    address:
      checkGelatoLowAddress[chainId as keyof typeof checkGelatoLowAddress],
    eventName: '_EventToExposeStructInABI__Params',
    ...config,
  } as UseContractEventConfig<typeof checkGelatoLowABI, '_EventToExposeStructInABI__Params'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link checkTrueABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x5c741a38cb11424711231777D71689C458eE835D)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5c741a38cb11424711231777D71689C458eE835D)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x47443D0C184e022F19BD1578F5bca6B8a9F58E32)
 */
export function useCheckTrueRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<typeof checkTrueABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof checkTrueABI, TFunctionName, TSelectData>,
    'abi' | 'address'
  > & { chainId?: keyof typeof checkTrueAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractRead({
    abi: checkTrueABI,
    address: checkTrueAddress[chainId as keyof typeof checkTrueAddress],
    ...config,
  } as UseContractReadConfig<typeof checkTrueABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link checkTrueABI}__ and `functionName` set to `"check"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x5c741a38cb11424711231777D71689C458eE835D)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5c741a38cb11424711231777D71689C458eE835D)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x47443D0C184e022F19BD1578F5bca6B8a9F58E32)
 */
export function useCheckTrueCheck<
  TFunctionName extends 'check',
  TSelectData = ReadContractResult<typeof checkTrueABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof checkTrueABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof checkTrueAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractRead({
    abi: checkTrueABI,
    address: checkTrueAddress[chainId as keyof typeof checkTrueAddress],
    functionName: 'check',
    ...config,
  } as UseContractReadConfig<typeof checkTrueABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link drippieABI}__.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<typeof drippieABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof drippieABI, TFunctionName, TSelectData>,
    'abi' | 'address'
  > & { chainId?: keyof typeof drippieAddress } = {} as any
) {
  return useContractRead({
    abi: drippieABI,
    address: drippieAddress[1],
    ...config,
  } as UseContractReadConfig<typeof drippieABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link drippieABI}__ and `functionName` set to `"drips"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieDrips<
  TFunctionName extends 'drips',
  TSelectData = ReadContractResult<typeof drippieABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof drippieABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieAddress } = {} as any
) {
  return useContractRead({
    abi: drippieABI,
    address: drippieAddress[1],
    functionName: 'drips',
    ...config,
  } as UseContractReadConfig<typeof drippieABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link drippieABI}__ and `functionName` set to `"executable"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieExecutable<
  TFunctionName extends 'executable',
  TSelectData = ReadContractResult<typeof drippieABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof drippieABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieAddress } = {} as any
) {
  return useContractRead({
    abi: drippieABI,
    address: drippieAddress[1],
    functionName: 'executable',
    ...config,
  } as UseContractReadConfig<typeof drippieABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link drippieABI}__ and `functionName` set to `"owner"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieOwner<
  TFunctionName extends 'owner',
  TSelectData = ReadContractResult<typeof drippieABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof drippieABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieAddress } = {} as any
) {
  return useContractRead({
    abi: drippieABI,
    address: drippieAddress[1],
    functionName: 'owner',
    ...config,
  } as UseContractReadConfig<typeof drippieABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieABI}__.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieWrite<
  TFunctionName extends string,
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<typeof drippieABI, string>['request']['abi'],
        TFunctionName,
        TMode
      > & { address?: Address; chainId?: TChainId }
    : UseContractWriteConfig<typeof drippieABI, TFunctionName, TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
      } = {} as any
) {
  return useContractWrite<typeof drippieABI, TFunctionName, TMode>({
    abi: drippieABI,
    address: drippieAddress[1],
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieABI}__ and `functionName` set to `"CALL"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieCall<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<typeof drippieABI, 'CALL'>['request']['abi'],
        'CALL',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'CALL' }
    : UseContractWriteConfig<typeof drippieABI, 'CALL', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'CALL'
      } = {} as any
) {
  return useContractWrite<typeof drippieABI, 'CALL', TMode>({
    abi: drippieABI,
    address: drippieAddress[1],
    functionName: 'CALL',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieABI}__ and `functionName` set to `"DELEGATECALL"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieDelegatecall<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof drippieABI,
          'DELEGATECALL'
        >['request']['abi'],
        'DELEGATECALL',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'DELEGATECALL'
      }
    : UseContractWriteConfig<typeof drippieABI, 'DELEGATECALL', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'DELEGATECALL'
      } = {} as any
) {
  return useContractWrite<typeof drippieABI, 'DELEGATECALL', TMode>({
    abi: drippieABI,
    address: drippieAddress[1],
    functionName: 'DELEGATECALL',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieABI}__ and `functionName` set to `"create"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieCreate<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof drippieABI,
          'create'
        >['request']['abi'],
        'create',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'create' }
    : UseContractWriteConfig<typeof drippieABI, 'create', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'create'
      } = {} as any
) {
  return useContractWrite<typeof drippieABI, 'create', TMode>({
    abi: drippieABI,
    address: drippieAddress[1],
    functionName: 'create',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieABI}__ and `functionName` set to `"drip"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieDrip<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<typeof drippieABI, 'drip'>['request']['abi'],
        'drip',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'drip' }
    : UseContractWriteConfig<typeof drippieABI, 'drip', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'drip'
      } = {} as any
) {
  return useContractWrite<typeof drippieABI, 'drip', TMode>({
    abi: drippieABI,
    address: drippieAddress[1],
    functionName: 'drip',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieABI}__ and `functionName` set to `"setOwner"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieSetOwner<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof drippieABI,
          'setOwner'
        >['request']['abi'],
        'setOwner',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'setOwner' }
    : UseContractWriteConfig<typeof drippieABI, 'setOwner', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'setOwner'
      } = {} as any
) {
  return useContractWrite<typeof drippieABI, 'setOwner', TMode>({
    abi: drippieABI,
    address: drippieAddress[1],
    functionName: 'setOwner',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieABI}__ and `functionName` set to `"status"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieStatus<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof drippieABI,
          'status'
        >['request']['abi'],
        'status',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'status' }
    : UseContractWriteConfig<typeof drippieABI, 'status', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'status'
      } = {} as any
) {
  return useContractWrite<typeof drippieABI, 'status', TMode>({
    abi: drippieABI,
    address: drippieAddress[1],
    functionName: 'status',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieABI}__ and `functionName` set to `"withdrawERC20"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieWithdrawErc20<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof drippieABI,
          'withdrawERC20'
        >['request']['abi'],
        'withdrawERC20',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'withdrawERC20'
      }
    : UseContractWriteConfig<typeof drippieABI, 'withdrawERC20', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'withdrawERC20'
      } = {} as any
) {
  return useContractWrite<typeof drippieABI, 'withdrawERC20', TMode>({
    abi: drippieABI,
    address: drippieAddress[1],
    functionName: 'withdrawERC20',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieABI}__ and `functionName` set to `"withdrawERC721"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieWithdrawErc721<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof drippieABI,
          'withdrawERC721'
        >['request']['abi'],
        'withdrawERC721',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'withdrawERC721'
      }
    : UseContractWriteConfig<typeof drippieABI, 'withdrawERC721', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'withdrawERC721'
      } = {} as any
) {
  return useContractWrite<typeof drippieABI, 'withdrawERC721', TMode>({
    abi: drippieABI,
    address: drippieAddress[1],
    functionName: 'withdrawERC721',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieABI}__ and `functionName` set to `"withdrawETH"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieWithdrawEth<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof drippieABI,
          'withdrawETH'
        >['request']['abi'],
        'withdrawETH',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'withdrawETH'
      }
    : UseContractWriteConfig<typeof drippieABI, 'withdrawETH', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'withdrawETH'
      } = {} as any
) {
  return useContractWrite<typeof drippieABI, 'withdrawETH', TMode>({
    abi: drippieABI,
    address: drippieAddress[1],
    functionName: 'withdrawETH',
    ...config,
  } as any)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieABI}__.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function usePrepareDrippieWrite<TFunctionName extends string>(
  config: Omit<
    UsePrepareContractWriteConfig<typeof drippieABI, TFunctionName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof drippieAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieABI,
    address: drippieAddress[1],
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieABI, TFunctionName>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieABI}__ and `functionName` set to `"CALL"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function usePrepareDrippieCall(
  config: Omit<
    UsePrepareContractWriteConfig<typeof drippieABI, 'CALL'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieABI,
    address: drippieAddress[1],
    functionName: 'CALL',
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieABI, 'CALL'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieABI}__ and `functionName` set to `"DELEGATECALL"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function usePrepareDrippieDelegatecall(
  config: Omit<
    UsePrepareContractWriteConfig<typeof drippieABI, 'DELEGATECALL'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieABI,
    address: drippieAddress[1],
    functionName: 'DELEGATECALL',
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieABI, 'DELEGATECALL'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieABI}__ and `functionName` set to `"create"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function usePrepareDrippieCreate(
  config: Omit<
    UsePrepareContractWriteConfig<typeof drippieABI, 'create'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieABI,
    address: drippieAddress[1],
    functionName: 'create',
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieABI, 'create'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieABI}__ and `functionName` set to `"drip"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function usePrepareDrippieDrip(
  config: Omit<
    UsePrepareContractWriteConfig<typeof drippieABI, 'drip'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieABI,
    address: drippieAddress[1],
    functionName: 'drip',
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieABI, 'drip'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieABI}__ and `functionName` set to `"setOwner"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function usePrepareDrippieSetOwner(
  config: Omit<
    UsePrepareContractWriteConfig<typeof drippieABI, 'setOwner'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieABI,
    address: drippieAddress[1],
    functionName: 'setOwner',
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieABI, 'setOwner'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieABI}__ and `functionName` set to `"status"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function usePrepareDrippieStatus(
  config: Omit<
    UsePrepareContractWriteConfig<typeof drippieABI, 'status'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieABI,
    address: drippieAddress[1],
    functionName: 'status',
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieABI, 'status'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieABI}__ and `functionName` set to `"withdrawERC20"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function usePrepareDrippieWithdrawErc20(
  config: Omit<
    UsePrepareContractWriteConfig<typeof drippieABI, 'withdrawERC20'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieABI,
    address: drippieAddress[1],
    functionName: 'withdrawERC20',
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieABI, 'withdrawERC20'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieABI}__ and `functionName` set to `"withdrawERC721"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function usePrepareDrippieWithdrawErc721(
  config: Omit<
    UsePrepareContractWriteConfig<typeof drippieABI, 'withdrawERC721'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieABI,
    address: drippieAddress[1],
    functionName: 'withdrawERC721',
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieABI, 'withdrawERC721'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieABI}__ and `functionName` set to `"withdrawETH"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function usePrepareDrippieWithdrawEth(
  config: Omit<
    UsePrepareContractWriteConfig<typeof drippieABI, 'withdrawETH'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieABI,
    address: drippieAddress[1],
    functionName: 'withdrawETH',
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieABI, 'withdrawETH'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link drippieABI}__.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieEvent<TEventName extends string>(
  config: Omit<
    UseContractEventConfig<typeof drippieABI, TEventName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof drippieAddress } = {} as any
) {
  return useContractEvent({
    abi: drippieABI,
    address: drippieAddress[1],
    ...config,
  } as UseContractEventConfig<typeof drippieABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link drippieABI}__ and `eventName` set to `"DripCreated"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieDripCreatedEvent(
  config: Omit<
    UseContractEventConfig<typeof drippieABI, 'DripCreated'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof drippieAddress } = {} as any
) {
  return useContractEvent({
    abi: drippieABI,
    address: drippieAddress[1],
    eventName: 'DripCreated',
    ...config,
  } as UseContractEventConfig<typeof drippieABI, 'DripCreated'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link drippieABI}__ and `eventName` set to `"DripExecuted"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieDripExecutedEvent(
  config: Omit<
    UseContractEventConfig<typeof drippieABI, 'DripExecuted'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof drippieAddress } = {} as any
) {
  return useContractEvent({
    abi: drippieABI,
    address: drippieAddress[1],
    eventName: 'DripExecuted',
    ...config,
  } as UseContractEventConfig<typeof drippieABI, 'DripExecuted'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link drippieABI}__ and `eventName` set to `"DripStatusUpdated"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieDripStatusUpdatedEvent(
  config: Omit<
    UseContractEventConfig<typeof drippieABI, 'DripStatusUpdated'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof drippieAddress } = {} as any
) {
  return useContractEvent({
    abi: drippieABI,
    address: drippieAddress[1],
    eventName: 'DripStatusUpdated',
    ...config,
  } as UseContractEventConfig<typeof drippieABI, 'DripStatusUpdated'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link drippieABI}__ and `eventName` set to `"OwnerUpdated"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieOwnerUpdatedEvent(
  config: Omit<
    UseContractEventConfig<typeof drippieABI, 'OwnerUpdated'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof drippieAddress } = {} as any
) {
  return useContractEvent({
    abi: drippieABI,
    address: drippieAddress[1],
    eventName: 'OwnerUpdated',
    ...config,
  } as UseContractEventConfig<typeof drippieABI, 'OwnerUpdated'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link drippieABI}__ and `eventName` set to `"ReceivedETH"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieReceivedEthEvent(
  config: Omit<
    UseContractEventConfig<typeof drippieABI, 'ReceivedETH'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof drippieAddress } = {} as any
) {
  return useContractEvent({
    abi: drippieABI,
    address: drippieAddress[1],
    eventName: 'ReceivedETH',
    ...config,
  } as UseContractEventConfig<typeof drippieABI, 'ReceivedETH'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link drippieABI}__ and `eventName` set to `"WithdrewERC20"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieWithdrewErc20Event(
  config: Omit<
    UseContractEventConfig<typeof drippieABI, 'WithdrewERC20'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof drippieAddress } = {} as any
) {
  return useContractEvent({
    abi: drippieABI,
    address: drippieAddress[1],
    eventName: 'WithdrewERC20',
    ...config,
  } as UseContractEventConfig<typeof drippieABI, 'WithdrewERC20'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link drippieABI}__ and `eventName` set to `"WithdrewERC721"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieWithdrewErc721Event(
  config: Omit<
    UseContractEventConfig<typeof drippieABI, 'WithdrewERC721'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof drippieAddress } = {} as any
) {
  return useContractEvent({
    abi: drippieABI,
    address: drippieAddress[1],
    eventName: 'WithdrewERC721',
    ...config,
  } as UseContractEventConfig<typeof drippieABI, 'WithdrewERC721'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link drippieABI}__ and `eventName` set to `"WithdrewETH"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieWithdrewEthEvent(
  config: Omit<
    UseContractEventConfig<typeof drippieABI, 'WithdrewETH'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof drippieAddress } = {} as any
) {
  return useContractEvent({
    abi: drippieABI,
    address: drippieAddress[1],
    eventName: 'WithdrewETH',
    ...config,
  } as UseContractEventConfig<typeof drippieABI, 'WithdrewETH'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link drippieGoerliABI}__.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieGoerliRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<typeof drippieGoerliABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof drippieGoerliABI, TFunctionName, TSelectData>,
    'abi' | 'address'
  > & { chainId?: keyof typeof drippieGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    ...config,
  } as UseContractReadConfig<typeof drippieGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link drippieGoerliABI}__ and `functionName` set to `"drips"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieGoerliDrips<
  TFunctionName extends 'drips',
  TSelectData = ReadContractResult<typeof drippieGoerliABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof drippieGoerliABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    functionName: 'drips',
    ...config,
  } as UseContractReadConfig<typeof drippieGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link drippieGoerliABI}__ and `functionName` set to `"executable"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieGoerliExecutable<
  TFunctionName extends 'executable',
  TSelectData = ReadContractResult<typeof drippieGoerliABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof drippieGoerliABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    functionName: 'executable',
    ...config,
  } as UseContractReadConfig<typeof drippieGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link drippieGoerliABI}__ and `functionName` set to `"owner"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieGoerliOwner<
  TFunctionName extends 'owner',
  TSelectData = ReadContractResult<typeof drippieGoerliABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof drippieGoerliABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    functionName: 'owner',
    ...config,
  } as UseContractReadConfig<typeof drippieGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieGoerliABI}__.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieGoerliWrite<
  TFunctionName extends string,
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof drippieGoerliABI,
          string
        >['request']['abi'],
        TFunctionName,
        TMode
      > & { address?: Address; chainId?: TChainId }
    : UseContractWriteConfig<typeof drippieGoerliABI, TFunctionName, TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
      } = {} as any
) {
  return useContractWrite<typeof drippieGoerliABI, TFunctionName, TMode>({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieGoerliABI}__ and `functionName` set to `"CALL"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieGoerliCall<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof drippieGoerliABI,
          'CALL'
        >['request']['abi'],
        'CALL',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'CALL' }
    : UseContractWriteConfig<typeof drippieGoerliABI, 'CALL', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'CALL'
      } = {} as any
) {
  return useContractWrite<typeof drippieGoerliABI, 'CALL', TMode>({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    functionName: 'CALL',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieGoerliABI}__ and `functionName` set to `"DELEGATECALL"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieGoerliDelegatecall<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof drippieGoerliABI,
          'DELEGATECALL'
        >['request']['abi'],
        'DELEGATECALL',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'DELEGATECALL'
      }
    : UseContractWriteConfig<typeof drippieGoerliABI, 'DELEGATECALL', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'DELEGATECALL'
      } = {} as any
) {
  return useContractWrite<typeof drippieGoerliABI, 'DELEGATECALL', TMode>({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    functionName: 'DELEGATECALL',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieGoerliABI}__ and `functionName` set to `"create"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieGoerliCreate<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof drippieGoerliABI,
          'create'
        >['request']['abi'],
        'create',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'create' }
    : UseContractWriteConfig<typeof drippieGoerliABI, 'create', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'create'
      } = {} as any
) {
  return useContractWrite<typeof drippieGoerliABI, 'create', TMode>({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    functionName: 'create',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieGoerliABI}__ and `functionName` set to `"drip"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieGoerliDrip<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof drippieGoerliABI,
          'drip'
        >['request']['abi'],
        'drip',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'drip' }
    : UseContractWriteConfig<typeof drippieGoerliABI, 'drip', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'drip'
      } = {} as any
) {
  return useContractWrite<typeof drippieGoerliABI, 'drip', TMode>({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    functionName: 'drip',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieGoerliABI}__ and `functionName` set to `"setOwner"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieGoerliSetOwner<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof drippieGoerliABI,
          'setOwner'
        >['request']['abi'],
        'setOwner',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'setOwner' }
    : UseContractWriteConfig<typeof drippieGoerliABI, 'setOwner', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'setOwner'
      } = {} as any
) {
  return useContractWrite<typeof drippieGoerliABI, 'setOwner', TMode>({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    functionName: 'setOwner',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieGoerliABI}__ and `functionName` set to `"status"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieGoerliStatus<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof drippieGoerliABI,
          'status'
        >['request']['abi'],
        'status',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'status' }
    : UseContractWriteConfig<typeof drippieGoerliABI, 'status', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'status'
      } = {} as any
) {
  return useContractWrite<typeof drippieGoerliABI, 'status', TMode>({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    functionName: 'status',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieGoerliABI}__ and `functionName` set to `"withdrawERC20"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieGoerliWithdrawErc20<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof drippieGoerliABI,
          'withdrawERC20'
        >['request']['abi'],
        'withdrawERC20',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'withdrawERC20'
      }
    : UseContractWriteConfig<
        typeof drippieGoerliABI,
        'withdrawERC20',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'withdrawERC20'
      } = {} as any
) {
  return useContractWrite<typeof drippieGoerliABI, 'withdrawERC20', TMode>({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    functionName: 'withdrawERC20',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieGoerliABI}__ and `functionName` set to `"withdrawERC721"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieGoerliWithdrawErc721<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof drippieGoerliABI,
          'withdrawERC721'
        >['request']['abi'],
        'withdrawERC721',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'withdrawERC721'
      }
    : UseContractWriteConfig<
        typeof drippieGoerliABI,
        'withdrawERC721',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'withdrawERC721'
      } = {} as any
) {
  return useContractWrite<typeof drippieGoerliABI, 'withdrawERC721', TMode>({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    functionName: 'withdrawERC721',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieGoerliABI}__ and `functionName` set to `"withdrawETH"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieGoerliWithdrawEth<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof drippieGoerliABI,
          'withdrawETH'
        >['request']['abi'],
        'withdrawETH',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'withdrawETH'
      }
    : UseContractWriteConfig<typeof drippieGoerliABI, 'withdrawETH', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'withdrawETH'
      } = {} as any
) {
  return useContractWrite<typeof drippieGoerliABI, 'withdrawETH', TMode>({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    functionName: 'withdrawETH',
    ...config,
  } as any)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieGoerliABI}__.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function usePrepareDrippieGoerliWrite<TFunctionName extends string>(
  config: Omit<
    UsePrepareContractWriteConfig<typeof drippieGoerliABI, TFunctionName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof drippieGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieGoerliABI, TFunctionName>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieGoerliABI}__ and `functionName` set to `"CALL"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function usePrepareDrippieGoerliCall(
  config: Omit<
    UsePrepareContractWriteConfig<typeof drippieGoerliABI, 'CALL'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    functionName: 'CALL',
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieGoerliABI, 'CALL'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieGoerliABI}__ and `functionName` set to `"DELEGATECALL"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function usePrepareDrippieGoerliDelegatecall(
  config: Omit<
    UsePrepareContractWriteConfig<typeof drippieGoerliABI, 'DELEGATECALL'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    functionName: 'DELEGATECALL',
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieGoerliABI, 'DELEGATECALL'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieGoerliABI}__ and `functionName` set to `"create"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function usePrepareDrippieGoerliCreate(
  config: Omit<
    UsePrepareContractWriteConfig<typeof drippieGoerliABI, 'create'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    functionName: 'create',
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieGoerliABI, 'create'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieGoerliABI}__ and `functionName` set to `"drip"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function usePrepareDrippieGoerliDrip(
  config: Omit<
    UsePrepareContractWriteConfig<typeof drippieGoerliABI, 'drip'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    functionName: 'drip',
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieGoerliABI, 'drip'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieGoerliABI}__ and `functionName` set to `"setOwner"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function usePrepareDrippieGoerliSetOwner(
  config: Omit<
    UsePrepareContractWriteConfig<typeof drippieGoerliABI, 'setOwner'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    functionName: 'setOwner',
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieGoerliABI, 'setOwner'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieGoerliABI}__ and `functionName` set to `"status"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function usePrepareDrippieGoerliStatus(
  config: Omit<
    UsePrepareContractWriteConfig<typeof drippieGoerliABI, 'status'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    functionName: 'status',
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieGoerliABI, 'status'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieGoerliABI}__ and `functionName` set to `"withdrawERC20"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function usePrepareDrippieGoerliWithdrawErc20(
  config: Omit<
    UsePrepareContractWriteConfig<typeof drippieGoerliABI, 'withdrawERC20'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    functionName: 'withdrawERC20',
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieGoerliABI, 'withdrawERC20'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieGoerliABI}__ and `functionName` set to `"withdrawERC721"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function usePrepareDrippieGoerliWithdrawErc721(
  config: Omit<
    UsePrepareContractWriteConfig<typeof drippieGoerliABI, 'withdrawERC721'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    functionName: 'withdrawERC721',
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieGoerliABI, 'withdrawERC721'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieGoerliABI}__ and `functionName` set to `"withdrawETH"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function usePrepareDrippieGoerliWithdrawEth(
  config: Omit<
    UsePrepareContractWriteConfig<typeof drippieGoerliABI, 'withdrawETH'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    functionName: 'withdrawETH',
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieGoerliABI, 'withdrawETH'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link drippieGoerliABI}__.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieGoerliEvent<TEventName extends string>(
  config: Omit<
    UseContractEventConfig<typeof drippieGoerliABI, TEventName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof drippieGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    ...config,
  } as UseContractEventConfig<typeof drippieGoerliABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link drippieGoerliABI}__ and `eventName` set to `"DripCreated"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieGoerliDripCreatedEvent(
  config: Omit<
    UseContractEventConfig<typeof drippieGoerliABI, 'DripCreated'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof drippieGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    eventName: 'DripCreated',
    ...config,
  } as UseContractEventConfig<typeof drippieGoerliABI, 'DripCreated'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link drippieGoerliABI}__ and `eventName` set to `"DripExecuted"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieGoerliDripExecutedEvent(
  config: Omit<
    UseContractEventConfig<typeof drippieGoerliABI, 'DripExecuted'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof drippieGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    eventName: 'DripExecuted',
    ...config,
  } as UseContractEventConfig<typeof drippieGoerliABI, 'DripExecuted'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link drippieGoerliABI}__ and `eventName` set to `"DripStatusUpdated"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieGoerliDripStatusUpdatedEvent(
  config: Omit<
    UseContractEventConfig<typeof drippieGoerliABI, 'DripStatusUpdated'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof drippieGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    eventName: 'DripStatusUpdated',
    ...config,
  } as UseContractEventConfig<typeof drippieGoerliABI, 'DripStatusUpdated'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link drippieGoerliABI}__ and `eventName` set to `"OwnerUpdated"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieGoerliOwnerUpdatedEvent(
  config: Omit<
    UseContractEventConfig<typeof drippieGoerliABI, 'OwnerUpdated'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof drippieGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    eventName: 'OwnerUpdated',
    ...config,
  } as UseContractEventConfig<typeof drippieGoerliABI, 'OwnerUpdated'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link drippieGoerliABI}__ and `eventName` set to `"ReceivedETH"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieGoerliReceivedEthEvent(
  config: Omit<
    UseContractEventConfig<typeof drippieGoerliABI, 'ReceivedETH'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof drippieGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    eventName: 'ReceivedETH',
    ...config,
  } as UseContractEventConfig<typeof drippieGoerliABI, 'ReceivedETH'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link drippieGoerliABI}__ and `eventName` set to `"WithdrewERC20"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieGoerliWithdrewErc20Event(
  config: Omit<
    UseContractEventConfig<typeof drippieGoerliABI, 'WithdrewERC20'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof drippieGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    eventName: 'WithdrewERC20',
    ...config,
  } as UseContractEventConfig<typeof drippieGoerliABI, 'WithdrewERC20'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link drippieGoerliABI}__ and `eventName` set to `"WithdrewERC721"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieGoerliWithdrewErc721Event(
  config: Omit<
    UseContractEventConfig<typeof drippieGoerliABI, 'WithdrewERC721'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof drippieGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    eventName: 'WithdrewERC721',
    ...config,
  } as UseContractEventConfig<typeof drippieGoerliABI, 'WithdrewERC721'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link drippieGoerliABI}__ and `eventName` set to `"WithdrewETH"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieGoerliWithdrewEthEvent(
  config: Omit<
    UseContractEventConfig<typeof drippieGoerliABI, 'WithdrewETH'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof drippieGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    eventName: 'WithdrewETH',
    ...config,
  } as UseContractEventConfig<typeof drippieGoerliABI, 'WithdrewETH'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link drippieOptimismGoerliABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function useDrippieOptimismGoerliRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<
    typeof drippieOptimismGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof drippieOptimismGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address'
  > & { chainId?: keyof typeof drippieOptimismGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    ...config,
  } as UseContractReadConfig<typeof drippieOptimismGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link drippieOptimismGoerliABI}__ and `functionName` set to `"drips"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function useDrippieOptimismGoerliDrips<
  TFunctionName extends 'drips',
  TSelectData = ReadContractResult<
    typeof drippieOptimismGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof drippieOptimismGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieOptimismGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    functionName: 'drips',
    ...config,
  } as UseContractReadConfig<typeof drippieOptimismGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link drippieOptimismGoerliABI}__ and `functionName` set to `"executable"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function useDrippieOptimismGoerliExecutable<
  TFunctionName extends 'executable',
  TSelectData = ReadContractResult<
    typeof drippieOptimismGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof drippieOptimismGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieOptimismGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    functionName: 'executable',
    ...config,
  } as UseContractReadConfig<typeof drippieOptimismGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link drippieOptimismGoerliABI}__ and `functionName` set to `"owner"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function useDrippieOptimismGoerliOwner<
  TFunctionName extends 'owner',
  TSelectData = ReadContractResult<
    typeof drippieOptimismGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof drippieOptimismGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieOptimismGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    functionName: 'owner',
    ...config,
  } as UseContractReadConfig<typeof drippieOptimismGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieOptimismGoerliABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function useDrippieOptimismGoerliWrite<
  TFunctionName extends string,
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieOptimismGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof drippieOptimismGoerliABI,
          string
        >['request']['abi'],
        TFunctionName,
        TMode
      > & { address?: Address; chainId?: TChainId }
    : UseContractWriteConfig<
        typeof drippieOptimismGoerliABI,
        TFunctionName,
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
      } = {} as any
) {
  return useContractWrite<
    typeof drippieOptimismGoerliABI,
    TFunctionName,
    TMode
  >({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieOptimismGoerliABI}__ and `functionName` set to `"CALL"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function useDrippieOptimismGoerliCall<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieOptimismGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof drippieOptimismGoerliABI,
          'CALL'
        >['request']['abi'],
        'CALL',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'CALL' }
    : UseContractWriteConfig<typeof drippieOptimismGoerliABI, 'CALL', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'CALL'
      } = {} as any
) {
  return useContractWrite<typeof drippieOptimismGoerliABI, 'CALL', TMode>({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    functionName: 'CALL',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieOptimismGoerliABI}__ and `functionName` set to `"DELEGATECALL"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function useDrippieOptimismGoerliDelegatecall<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieOptimismGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof drippieOptimismGoerliABI,
          'DELEGATECALL'
        >['request']['abi'],
        'DELEGATECALL',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'DELEGATECALL'
      }
    : UseContractWriteConfig<
        typeof drippieOptimismGoerliABI,
        'DELEGATECALL',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'DELEGATECALL'
      } = {} as any
) {
  return useContractWrite<
    typeof drippieOptimismGoerliABI,
    'DELEGATECALL',
    TMode
  >({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    functionName: 'DELEGATECALL',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieOptimismGoerliABI}__ and `functionName` set to `"create"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function useDrippieOptimismGoerliCreate<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieOptimismGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof drippieOptimismGoerliABI,
          'create'
        >['request']['abi'],
        'create',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'create' }
    : UseContractWriteConfig<
        typeof drippieOptimismGoerliABI,
        'create',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'create'
      } = {} as any
) {
  return useContractWrite<typeof drippieOptimismGoerliABI, 'create', TMode>({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    functionName: 'create',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieOptimismGoerliABI}__ and `functionName` set to `"drip"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function useDrippieOptimismGoerliDrip<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieOptimismGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof drippieOptimismGoerliABI,
          'drip'
        >['request']['abi'],
        'drip',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'drip' }
    : UseContractWriteConfig<typeof drippieOptimismGoerliABI, 'drip', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'drip'
      } = {} as any
) {
  return useContractWrite<typeof drippieOptimismGoerliABI, 'drip', TMode>({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    functionName: 'drip',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieOptimismGoerliABI}__ and `functionName` set to `"setOwner"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function useDrippieOptimismGoerliSetOwner<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieOptimismGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof drippieOptimismGoerliABI,
          'setOwner'
        >['request']['abi'],
        'setOwner',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'setOwner' }
    : UseContractWriteConfig<
        typeof drippieOptimismGoerliABI,
        'setOwner',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'setOwner'
      } = {} as any
) {
  return useContractWrite<typeof drippieOptimismGoerliABI, 'setOwner', TMode>({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    functionName: 'setOwner',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieOptimismGoerliABI}__ and `functionName` set to `"status"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function useDrippieOptimismGoerliStatus<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieOptimismGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof drippieOptimismGoerliABI,
          'status'
        >['request']['abi'],
        'status',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'status' }
    : UseContractWriteConfig<
        typeof drippieOptimismGoerliABI,
        'status',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'status'
      } = {} as any
) {
  return useContractWrite<typeof drippieOptimismGoerliABI, 'status', TMode>({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    functionName: 'status',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieOptimismGoerliABI}__ and `functionName` set to `"withdrawERC20"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function useDrippieOptimismGoerliWithdrawErc20<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieOptimismGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof drippieOptimismGoerliABI,
          'withdrawERC20'
        >['request']['abi'],
        'withdrawERC20',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'withdrawERC20'
      }
    : UseContractWriteConfig<
        typeof drippieOptimismGoerliABI,
        'withdrawERC20',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'withdrawERC20'
      } = {} as any
) {
  return useContractWrite<
    typeof drippieOptimismGoerliABI,
    'withdrawERC20',
    TMode
  >({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    functionName: 'withdrawERC20',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieOptimismGoerliABI}__ and `functionName` set to `"withdrawERC721"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function useDrippieOptimismGoerliWithdrawErc721<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieOptimismGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof drippieOptimismGoerliABI,
          'withdrawERC721'
        >['request']['abi'],
        'withdrawERC721',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'withdrawERC721'
      }
    : UseContractWriteConfig<
        typeof drippieOptimismGoerliABI,
        'withdrawERC721',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'withdrawERC721'
      } = {} as any
) {
  return useContractWrite<
    typeof drippieOptimismGoerliABI,
    'withdrawERC721',
    TMode
  >({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    functionName: 'withdrawERC721',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieOptimismGoerliABI}__ and `functionName` set to `"withdrawETH"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function useDrippieOptimismGoerliWithdrawEth<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieOptimismGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof drippieOptimismGoerliABI,
          'withdrawETH'
        >['request']['abi'],
        'withdrawETH',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'withdrawETH'
      }
    : UseContractWriteConfig<
        typeof drippieOptimismGoerliABI,
        'withdrawETH',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'withdrawETH'
      } = {} as any
) {
  return useContractWrite<
    typeof drippieOptimismGoerliABI,
    'withdrawETH',
    TMode
  >({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    functionName: 'withdrawETH',
    ...config,
  } as any)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieOptimismGoerliABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function usePrepareDrippieOptimismGoerliWrite<
  TFunctionName extends string
>(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof drippieOptimismGoerliABI,
      TFunctionName
    >,
    'abi' | 'address'
  > & { chainId?: keyof typeof drippieOptimismGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieOptimismGoerliABI, TFunctionName>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieOptimismGoerliABI}__ and `functionName` set to `"CALL"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function usePrepareDrippieOptimismGoerliCall(
  config: Omit<
    UsePrepareContractWriteConfig<typeof drippieOptimismGoerliABI, 'CALL'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieOptimismGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    functionName: 'CALL',
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieOptimismGoerliABI, 'CALL'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieOptimismGoerliABI}__ and `functionName` set to `"DELEGATECALL"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function usePrepareDrippieOptimismGoerliDelegatecall(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof drippieOptimismGoerliABI,
      'DELEGATECALL'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieOptimismGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    functionName: 'DELEGATECALL',
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieOptimismGoerliABI, 'DELEGATECALL'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieOptimismGoerliABI}__ and `functionName` set to `"create"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function usePrepareDrippieOptimismGoerliCreate(
  config: Omit<
    UsePrepareContractWriteConfig<typeof drippieOptimismGoerliABI, 'create'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieOptimismGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    functionName: 'create',
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieOptimismGoerliABI, 'create'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieOptimismGoerliABI}__ and `functionName` set to `"drip"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function usePrepareDrippieOptimismGoerliDrip(
  config: Omit<
    UsePrepareContractWriteConfig<typeof drippieOptimismGoerliABI, 'drip'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieOptimismGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    functionName: 'drip',
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieOptimismGoerliABI, 'drip'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieOptimismGoerliABI}__ and `functionName` set to `"setOwner"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function usePrepareDrippieOptimismGoerliSetOwner(
  config: Omit<
    UsePrepareContractWriteConfig<typeof drippieOptimismGoerliABI, 'setOwner'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieOptimismGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    functionName: 'setOwner',
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieOptimismGoerliABI, 'setOwner'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieOptimismGoerliABI}__ and `functionName` set to `"status"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function usePrepareDrippieOptimismGoerliStatus(
  config: Omit<
    UsePrepareContractWriteConfig<typeof drippieOptimismGoerliABI, 'status'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieOptimismGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    functionName: 'status',
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieOptimismGoerliABI, 'status'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieOptimismGoerliABI}__ and `functionName` set to `"withdrawERC20"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function usePrepareDrippieOptimismGoerliWithdrawErc20(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof drippieOptimismGoerliABI,
      'withdrawERC20'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieOptimismGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    functionName: 'withdrawERC20',
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieOptimismGoerliABI, 'withdrawERC20'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieOptimismGoerliABI}__ and `functionName` set to `"withdrawERC721"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function usePrepareDrippieOptimismGoerliWithdrawErc721(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof drippieOptimismGoerliABI,
      'withdrawERC721'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieOptimismGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    functionName: 'withdrawERC721',
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieOptimismGoerliABI, 'withdrawERC721'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieOptimismGoerliABI}__ and `functionName` set to `"withdrawETH"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function usePrepareDrippieOptimismGoerliWithdrawEth(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof drippieOptimismGoerliABI,
      'withdrawETH'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieOptimismGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    functionName: 'withdrawETH',
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieOptimismGoerliABI, 'withdrawETH'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link drippieOptimismGoerliABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function useDrippieOptimismGoerliEvent<TEventName extends string>(
  config: Omit<
    UseContractEventConfig<typeof drippieOptimismGoerliABI, TEventName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof drippieOptimismGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    ...config,
  } as UseContractEventConfig<typeof drippieOptimismGoerliABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link drippieOptimismGoerliABI}__ and `eventName` set to `"DripCreated"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function useDrippieOptimismGoerliDripCreatedEvent(
  config: Omit<
    UseContractEventConfig<typeof drippieOptimismGoerliABI, 'DripCreated'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof drippieOptimismGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    eventName: 'DripCreated',
    ...config,
  } as UseContractEventConfig<typeof drippieOptimismGoerliABI, 'DripCreated'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link drippieOptimismGoerliABI}__ and `eventName` set to `"DripExecuted"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function useDrippieOptimismGoerliDripExecutedEvent(
  config: Omit<
    UseContractEventConfig<typeof drippieOptimismGoerliABI, 'DripExecuted'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof drippieOptimismGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    eventName: 'DripExecuted',
    ...config,
  } as UseContractEventConfig<typeof drippieOptimismGoerliABI, 'DripExecuted'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link drippieOptimismGoerliABI}__ and `eventName` set to `"DripStatusUpdated"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function useDrippieOptimismGoerliDripStatusUpdatedEvent(
  config: Omit<
    UseContractEventConfig<
      typeof drippieOptimismGoerliABI,
      'DripStatusUpdated'
    >,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof drippieOptimismGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    eventName: 'DripStatusUpdated',
    ...config,
  } as UseContractEventConfig<typeof drippieOptimismGoerliABI, 'DripStatusUpdated'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link drippieOptimismGoerliABI}__ and `eventName` set to `"OwnerUpdated"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function useDrippieOptimismGoerliOwnerUpdatedEvent(
  config: Omit<
    UseContractEventConfig<typeof drippieOptimismGoerliABI, 'OwnerUpdated'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof drippieOptimismGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    eventName: 'OwnerUpdated',
    ...config,
  } as UseContractEventConfig<typeof drippieOptimismGoerliABI, 'OwnerUpdated'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link drippieOptimismGoerliABI}__ and `eventName` set to `"ReceivedETH"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function useDrippieOptimismGoerliReceivedEthEvent(
  config: Omit<
    UseContractEventConfig<typeof drippieOptimismGoerliABI, 'ReceivedETH'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof drippieOptimismGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    eventName: 'ReceivedETH',
    ...config,
  } as UseContractEventConfig<typeof drippieOptimismGoerliABI, 'ReceivedETH'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link drippieOptimismGoerliABI}__ and `eventName` set to `"WithdrewERC20"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function useDrippieOptimismGoerliWithdrewErc20Event(
  config: Omit<
    UseContractEventConfig<typeof drippieOptimismGoerliABI, 'WithdrewERC20'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof drippieOptimismGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    eventName: 'WithdrewERC20',
    ...config,
  } as UseContractEventConfig<typeof drippieOptimismGoerliABI, 'WithdrewERC20'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link drippieOptimismGoerliABI}__ and `eventName` set to `"WithdrewERC721"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function useDrippieOptimismGoerliWithdrewErc721Event(
  config: Omit<
    UseContractEventConfig<typeof drippieOptimismGoerliABI, 'WithdrewERC721'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof drippieOptimismGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    eventName: 'WithdrewERC721',
    ...config,
  } as UseContractEventConfig<typeof drippieOptimismGoerliABI, 'WithdrewERC721'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link drippieOptimismGoerliABI}__ and `eventName` set to `"WithdrewETH"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function useDrippieOptimismGoerliWithdrewEthEvent(
  config: Omit<
    UseContractEventConfig<typeof drippieOptimismGoerliABI, 'WithdrewETH'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof drippieOptimismGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    eventName: 'WithdrewETH',
    ...config,
  } as UseContractEventConfig<typeof drippieOptimismGoerliABI, 'WithdrewETH'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link easABI}__.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4E0275Ea5a89e7a3c1B58411379D1a0eDdc5b088)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5A633F1cc84B03F7588486CF2F386c102061E6e1)
 */
export function useEasRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<typeof easABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof easABI, TFunctionName, TSelectData>,
    'abi' | 'address'
  > & { chainId?: keyof typeof easAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractRead({
    abi: easABI,
    address: easAddress[chainId as keyof typeof easAddress],
    ...config,
  } as UseContractReadConfig<typeof easABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link easABI}__ and `functionName` set to `"getAttestTypeHash"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4E0275Ea5a89e7a3c1B58411379D1a0eDdc5b088)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5A633F1cc84B03F7588486CF2F386c102061E6e1)
 */
export function useEasGetAttestTypeHash<
  TFunctionName extends 'getAttestTypeHash',
  TSelectData = ReadContractResult<typeof easABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof easABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof easAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractRead({
    abi: easABI,
    address: easAddress[chainId as keyof typeof easAddress],
    functionName: 'getAttestTypeHash',
    ...config,
  } as UseContractReadConfig<typeof easABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link easABI}__ and `functionName` set to `"getAttestation"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4E0275Ea5a89e7a3c1B58411379D1a0eDdc5b088)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5A633F1cc84B03F7588486CF2F386c102061E6e1)
 */
export function useEasGetAttestation<
  TFunctionName extends 'getAttestation',
  TSelectData = ReadContractResult<typeof easABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof easABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof easAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractRead({
    abi: easABI,
    address: easAddress[chainId as keyof typeof easAddress],
    functionName: 'getAttestation',
    ...config,
  } as UseContractReadConfig<typeof easABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link easABI}__ and `functionName` set to `"getDomainSeparator"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4E0275Ea5a89e7a3c1B58411379D1a0eDdc5b088)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5A633F1cc84B03F7588486CF2F386c102061E6e1)
 */
export function useEasGetDomainSeparator<
  TFunctionName extends 'getDomainSeparator',
  TSelectData = ReadContractResult<typeof easABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof easABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof easAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractRead({
    abi: easABI,
    address: easAddress[chainId as keyof typeof easAddress],
    functionName: 'getDomainSeparator',
    ...config,
  } as UseContractReadConfig<typeof easABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link easABI}__ and `functionName` set to `"getName"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4E0275Ea5a89e7a3c1B58411379D1a0eDdc5b088)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5A633F1cc84B03F7588486CF2F386c102061E6e1)
 */
export function useEasGetName<
  TFunctionName extends 'getName',
  TSelectData = ReadContractResult<typeof easABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof easABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof easAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractRead({
    abi: easABI,
    address: easAddress[chainId as keyof typeof easAddress],
    functionName: 'getName',
    ...config,
  } as UseContractReadConfig<typeof easABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link easABI}__ and `functionName` set to `"getNonce"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4E0275Ea5a89e7a3c1B58411379D1a0eDdc5b088)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5A633F1cc84B03F7588486CF2F386c102061E6e1)
 */
export function useEasGetNonce<
  TFunctionName extends 'getNonce',
  TSelectData = ReadContractResult<typeof easABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof easABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof easAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractRead({
    abi: easABI,
    address: easAddress[chainId as keyof typeof easAddress],
    functionName: 'getNonce',
    ...config,
  } as UseContractReadConfig<typeof easABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link easABI}__ and `functionName` set to `"getRevokeOffchain"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4E0275Ea5a89e7a3c1B58411379D1a0eDdc5b088)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5A633F1cc84B03F7588486CF2F386c102061E6e1)
 */
export function useEasGetRevokeOffchain<
  TFunctionName extends 'getRevokeOffchain',
  TSelectData = ReadContractResult<typeof easABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof easABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof easAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractRead({
    abi: easABI,
    address: easAddress[chainId as keyof typeof easAddress],
    functionName: 'getRevokeOffchain',
    ...config,
  } as UseContractReadConfig<typeof easABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link easABI}__ and `functionName` set to `"getRevokeTypeHash"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4E0275Ea5a89e7a3c1B58411379D1a0eDdc5b088)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5A633F1cc84B03F7588486CF2F386c102061E6e1)
 */
export function useEasGetRevokeTypeHash<
  TFunctionName extends 'getRevokeTypeHash',
  TSelectData = ReadContractResult<typeof easABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof easABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof easAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractRead({
    abi: easABI,
    address: easAddress[chainId as keyof typeof easAddress],
    functionName: 'getRevokeTypeHash',
    ...config,
  } as UseContractReadConfig<typeof easABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link easABI}__ and `functionName` set to `"getSchemaRegistry"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4E0275Ea5a89e7a3c1B58411379D1a0eDdc5b088)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5A633F1cc84B03F7588486CF2F386c102061E6e1)
 */
export function useEasGetSchemaRegistry<
  TFunctionName extends 'getSchemaRegistry',
  TSelectData = ReadContractResult<typeof easABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof easABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof easAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractRead({
    abi: easABI,
    address: easAddress[chainId as keyof typeof easAddress],
    functionName: 'getSchemaRegistry',
    ...config,
  } as UseContractReadConfig<typeof easABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link easABI}__ and `functionName` set to `"getTimestamp"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4E0275Ea5a89e7a3c1B58411379D1a0eDdc5b088)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5A633F1cc84B03F7588486CF2F386c102061E6e1)
 */
export function useEasGetTimestamp<
  TFunctionName extends 'getTimestamp',
  TSelectData = ReadContractResult<typeof easABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof easABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof easAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractRead({
    abi: easABI,
    address: easAddress[chainId as keyof typeof easAddress],
    functionName: 'getTimestamp',
    ...config,
  } as UseContractReadConfig<typeof easABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link easABI}__ and `functionName` set to `"isAttestationValid"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4E0275Ea5a89e7a3c1B58411379D1a0eDdc5b088)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5A633F1cc84B03F7588486CF2F386c102061E6e1)
 */
export function useEasIsAttestationValid<
  TFunctionName extends 'isAttestationValid',
  TSelectData = ReadContractResult<typeof easABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof easABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof easAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractRead({
    abi: easABI,
    address: easAddress[chainId as keyof typeof easAddress],
    functionName: 'isAttestationValid',
    ...config,
  } as UseContractReadConfig<typeof easABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link easABI}__ and `functionName` set to `"version"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4E0275Ea5a89e7a3c1B58411379D1a0eDdc5b088)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5A633F1cc84B03F7588486CF2F386c102061E6e1)
 */
export function useEasVersion<
  TFunctionName extends 'version',
  TSelectData = ReadContractResult<typeof easABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof easABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof easAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractRead({
    abi: easABI,
    address: easAddress[chainId as keyof typeof easAddress],
    functionName: 'version',
    ...config,
  } as UseContractReadConfig<typeof easABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link easABI}__.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4E0275Ea5a89e7a3c1B58411379D1a0eDdc5b088)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5A633F1cc84B03F7588486CF2F386c102061E6e1)
 */
export function useEasWrite<
  TFunctionName extends string,
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof easAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<typeof easABI, string>['request']['abi'],
        TFunctionName,
        TMode
      > & { address?: Address; chainId?: TChainId }
    : UseContractWriteConfig<typeof easABI, TFunctionName, TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
      } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractWrite<typeof easABI, TFunctionName, TMode>({
    abi: easABI,
    address: easAddress[chainId as keyof typeof easAddress],
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link easABI}__ and `functionName` set to `"attest"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4E0275Ea5a89e7a3c1B58411379D1a0eDdc5b088)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5A633F1cc84B03F7588486CF2F386c102061E6e1)
 */
export function useEasAttest<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof easAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<typeof easABI, 'attest'>['request']['abi'],
        'attest',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'attest' }
    : UseContractWriteConfig<typeof easABI, 'attest', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'attest'
      } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractWrite<typeof easABI, 'attest', TMode>({
    abi: easABI,
    address: easAddress[chainId as keyof typeof easAddress],
    functionName: 'attest',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link easABI}__ and `functionName` set to `"attestByDelegation"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4E0275Ea5a89e7a3c1B58411379D1a0eDdc5b088)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5A633F1cc84B03F7588486CF2F386c102061E6e1)
 */
export function useEasAttestByDelegation<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof easAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof easABI,
          'attestByDelegation'
        >['request']['abi'],
        'attestByDelegation',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'attestByDelegation'
      }
    : UseContractWriteConfig<typeof easABI, 'attestByDelegation', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'attestByDelegation'
      } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractWrite<typeof easABI, 'attestByDelegation', TMode>({
    abi: easABI,
    address: easAddress[chainId as keyof typeof easAddress],
    functionName: 'attestByDelegation',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link easABI}__ and `functionName` set to `"multiAttest"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4E0275Ea5a89e7a3c1B58411379D1a0eDdc5b088)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5A633F1cc84B03F7588486CF2F386c102061E6e1)
 */
export function useEasMultiAttest<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof easAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof easABI,
          'multiAttest'
        >['request']['abi'],
        'multiAttest',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'multiAttest'
      }
    : UseContractWriteConfig<typeof easABI, 'multiAttest', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'multiAttest'
      } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractWrite<typeof easABI, 'multiAttest', TMode>({
    abi: easABI,
    address: easAddress[chainId as keyof typeof easAddress],
    functionName: 'multiAttest',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link easABI}__ and `functionName` set to `"multiAttestByDelegation"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4E0275Ea5a89e7a3c1B58411379D1a0eDdc5b088)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5A633F1cc84B03F7588486CF2F386c102061E6e1)
 */
export function useEasMultiAttestByDelegation<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof easAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof easABI,
          'multiAttestByDelegation'
        >['request']['abi'],
        'multiAttestByDelegation',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'multiAttestByDelegation'
      }
    : UseContractWriteConfig<
        typeof easABI,
        'multiAttestByDelegation',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'multiAttestByDelegation'
      } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractWrite<typeof easABI, 'multiAttestByDelegation', TMode>({
    abi: easABI,
    address: easAddress[chainId as keyof typeof easAddress],
    functionName: 'multiAttestByDelegation',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link easABI}__ and `functionName` set to `"multiRevoke"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4E0275Ea5a89e7a3c1B58411379D1a0eDdc5b088)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5A633F1cc84B03F7588486CF2F386c102061E6e1)
 */
export function useEasMultiRevoke<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof easAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof easABI,
          'multiRevoke'
        >['request']['abi'],
        'multiRevoke',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'multiRevoke'
      }
    : UseContractWriteConfig<typeof easABI, 'multiRevoke', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'multiRevoke'
      } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractWrite<typeof easABI, 'multiRevoke', TMode>({
    abi: easABI,
    address: easAddress[chainId as keyof typeof easAddress],
    functionName: 'multiRevoke',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link easABI}__ and `functionName` set to `"multiRevokeByDelegation"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4E0275Ea5a89e7a3c1B58411379D1a0eDdc5b088)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5A633F1cc84B03F7588486CF2F386c102061E6e1)
 */
export function useEasMultiRevokeByDelegation<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof easAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof easABI,
          'multiRevokeByDelegation'
        >['request']['abi'],
        'multiRevokeByDelegation',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'multiRevokeByDelegation'
      }
    : UseContractWriteConfig<
        typeof easABI,
        'multiRevokeByDelegation',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'multiRevokeByDelegation'
      } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractWrite<typeof easABI, 'multiRevokeByDelegation', TMode>({
    abi: easABI,
    address: easAddress[chainId as keyof typeof easAddress],
    functionName: 'multiRevokeByDelegation',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link easABI}__ and `functionName` set to `"multiRevokeOffchain"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4E0275Ea5a89e7a3c1B58411379D1a0eDdc5b088)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5A633F1cc84B03F7588486CF2F386c102061E6e1)
 */
export function useEasMultiRevokeOffchain<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof easAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof easABI,
          'multiRevokeOffchain'
        >['request']['abi'],
        'multiRevokeOffchain',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'multiRevokeOffchain'
      }
    : UseContractWriteConfig<typeof easABI, 'multiRevokeOffchain', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'multiRevokeOffchain'
      } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractWrite<typeof easABI, 'multiRevokeOffchain', TMode>({
    abi: easABI,
    address: easAddress[chainId as keyof typeof easAddress],
    functionName: 'multiRevokeOffchain',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link easABI}__ and `functionName` set to `"multiTimestamp"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4E0275Ea5a89e7a3c1B58411379D1a0eDdc5b088)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5A633F1cc84B03F7588486CF2F386c102061E6e1)
 */
export function useEasMultiTimestamp<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof easAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof easABI,
          'multiTimestamp'
        >['request']['abi'],
        'multiTimestamp',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'multiTimestamp'
      }
    : UseContractWriteConfig<typeof easABI, 'multiTimestamp', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'multiTimestamp'
      } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractWrite<typeof easABI, 'multiTimestamp', TMode>({
    abi: easABI,
    address: easAddress[chainId as keyof typeof easAddress],
    functionName: 'multiTimestamp',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link easABI}__ and `functionName` set to `"revoke"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4E0275Ea5a89e7a3c1B58411379D1a0eDdc5b088)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5A633F1cc84B03F7588486CF2F386c102061E6e1)
 */
export function useEasRevoke<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof easAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<typeof easABI, 'revoke'>['request']['abi'],
        'revoke',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'revoke' }
    : UseContractWriteConfig<typeof easABI, 'revoke', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'revoke'
      } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractWrite<typeof easABI, 'revoke', TMode>({
    abi: easABI,
    address: easAddress[chainId as keyof typeof easAddress],
    functionName: 'revoke',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link easABI}__ and `functionName` set to `"revokeByDelegation"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4E0275Ea5a89e7a3c1B58411379D1a0eDdc5b088)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5A633F1cc84B03F7588486CF2F386c102061E6e1)
 */
export function useEasRevokeByDelegation<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof easAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof easABI,
          'revokeByDelegation'
        >['request']['abi'],
        'revokeByDelegation',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'revokeByDelegation'
      }
    : UseContractWriteConfig<typeof easABI, 'revokeByDelegation', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'revokeByDelegation'
      } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractWrite<typeof easABI, 'revokeByDelegation', TMode>({
    abi: easABI,
    address: easAddress[chainId as keyof typeof easAddress],
    functionName: 'revokeByDelegation',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link easABI}__ and `functionName` set to `"revokeOffchain"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4E0275Ea5a89e7a3c1B58411379D1a0eDdc5b088)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5A633F1cc84B03F7588486CF2F386c102061E6e1)
 */
export function useEasRevokeOffchain<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof easAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof easABI,
          'revokeOffchain'
        >['request']['abi'],
        'revokeOffchain',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'revokeOffchain'
      }
    : UseContractWriteConfig<typeof easABI, 'revokeOffchain', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'revokeOffchain'
      } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractWrite<typeof easABI, 'revokeOffchain', TMode>({
    abi: easABI,
    address: easAddress[chainId as keyof typeof easAddress],
    functionName: 'revokeOffchain',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link easABI}__ and `functionName` set to `"timestamp"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4E0275Ea5a89e7a3c1B58411379D1a0eDdc5b088)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5A633F1cc84B03F7588486CF2F386c102061E6e1)
 */
export function useEasTimestamp<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof easAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof easABI,
          'timestamp'
        >['request']['abi'],
        'timestamp',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'timestamp' }
    : UseContractWriteConfig<typeof easABI, 'timestamp', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'timestamp'
      } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractWrite<typeof easABI, 'timestamp', TMode>({
    abi: easABI,
    address: easAddress[chainId as keyof typeof easAddress],
    functionName: 'timestamp',
    ...config,
  } as any)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link easABI}__.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4E0275Ea5a89e7a3c1B58411379D1a0eDdc5b088)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5A633F1cc84B03F7588486CF2F386c102061E6e1)
 */
export function usePrepareEasWrite<TFunctionName extends string>(
  config: Omit<
    UsePrepareContractWriteConfig<typeof easABI, TFunctionName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof easAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return usePrepareContractWrite({
    abi: easABI,
    address: easAddress[chainId as keyof typeof easAddress],
    ...config,
  } as UsePrepareContractWriteConfig<typeof easABI, TFunctionName>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link easABI}__ and `functionName` set to `"attest"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4E0275Ea5a89e7a3c1B58411379D1a0eDdc5b088)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5A633F1cc84B03F7588486CF2F386c102061E6e1)
 */
export function usePrepareEasAttest(
  config: Omit<
    UsePrepareContractWriteConfig<typeof easABI, 'attest'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof easAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return usePrepareContractWrite({
    abi: easABI,
    address: easAddress[chainId as keyof typeof easAddress],
    functionName: 'attest',
    ...config,
  } as UsePrepareContractWriteConfig<typeof easABI, 'attest'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link easABI}__ and `functionName` set to `"attestByDelegation"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4E0275Ea5a89e7a3c1B58411379D1a0eDdc5b088)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5A633F1cc84B03F7588486CF2F386c102061E6e1)
 */
export function usePrepareEasAttestByDelegation(
  config: Omit<
    UsePrepareContractWriteConfig<typeof easABI, 'attestByDelegation'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof easAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return usePrepareContractWrite({
    abi: easABI,
    address: easAddress[chainId as keyof typeof easAddress],
    functionName: 'attestByDelegation',
    ...config,
  } as UsePrepareContractWriteConfig<typeof easABI, 'attestByDelegation'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link easABI}__ and `functionName` set to `"multiAttest"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4E0275Ea5a89e7a3c1B58411379D1a0eDdc5b088)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5A633F1cc84B03F7588486CF2F386c102061E6e1)
 */
export function usePrepareEasMultiAttest(
  config: Omit<
    UsePrepareContractWriteConfig<typeof easABI, 'multiAttest'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof easAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return usePrepareContractWrite({
    abi: easABI,
    address: easAddress[chainId as keyof typeof easAddress],
    functionName: 'multiAttest',
    ...config,
  } as UsePrepareContractWriteConfig<typeof easABI, 'multiAttest'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link easABI}__ and `functionName` set to `"multiAttestByDelegation"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4E0275Ea5a89e7a3c1B58411379D1a0eDdc5b088)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5A633F1cc84B03F7588486CF2F386c102061E6e1)
 */
export function usePrepareEasMultiAttestByDelegation(
  config: Omit<
    UsePrepareContractWriteConfig<typeof easABI, 'multiAttestByDelegation'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof easAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return usePrepareContractWrite({
    abi: easABI,
    address: easAddress[chainId as keyof typeof easAddress],
    functionName: 'multiAttestByDelegation',
    ...config,
  } as UsePrepareContractWriteConfig<typeof easABI, 'multiAttestByDelegation'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link easABI}__ and `functionName` set to `"multiRevoke"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4E0275Ea5a89e7a3c1B58411379D1a0eDdc5b088)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5A633F1cc84B03F7588486CF2F386c102061E6e1)
 */
export function usePrepareEasMultiRevoke(
  config: Omit<
    UsePrepareContractWriteConfig<typeof easABI, 'multiRevoke'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof easAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return usePrepareContractWrite({
    abi: easABI,
    address: easAddress[chainId as keyof typeof easAddress],
    functionName: 'multiRevoke',
    ...config,
  } as UsePrepareContractWriteConfig<typeof easABI, 'multiRevoke'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link easABI}__ and `functionName` set to `"multiRevokeByDelegation"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4E0275Ea5a89e7a3c1B58411379D1a0eDdc5b088)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5A633F1cc84B03F7588486CF2F386c102061E6e1)
 */
export function usePrepareEasMultiRevokeByDelegation(
  config: Omit<
    UsePrepareContractWriteConfig<typeof easABI, 'multiRevokeByDelegation'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof easAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return usePrepareContractWrite({
    abi: easABI,
    address: easAddress[chainId as keyof typeof easAddress],
    functionName: 'multiRevokeByDelegation',
    ...config,
  } as UsePrepareContractWriteConfig<typeof easABI, 'multiRevokeByDelegation'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link easABI}__ and `functionName` set to `"multiRevokeOffchain"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4E0275Ea5a89e7a3c1B58411379D1a0eDdc5b088)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5A633F1cc84B03F7588486CF2F386c102061E6e1)
 */
export function usePrepareEasMultiRevokeOffchain(
  config: Omit<
    UsePrepareContractWriteConfig<typeof easABI, 'multiRevokeOffchain'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof easAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return usePrepareContractWrite({
    abi: easABI,
    address: easAddress[chainId as keyof typeof easAddress],
    functionName: 'multiRevokeOffchain',
    ...config,
  } as UsePrepareContractWriteConfig<typeof easABI, 'multiRevokeOffchain'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link easABI}__ and `functionName` set to `"multiTimestamp"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4E0275Ea5a89e7a3c1B58411379D1a0eDdc5b088)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5A633F1cc84B03F7588486CF2F386c102061E6e1)
 */
export function usePrepareEasMultiTimestamp(
  config: Omit<
    UsePrepareContractWriteConfig<typeof easABI, 'multiTimestamp'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof easAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return usePrepareContractWrite({
    abi: easABI,
    address: easAddress[chainId as keyof typeof easAddress],
    functionName: 'multiTimestamp',
    ...config,
  } as UsePrepareContractWriteConfig<typeof easABI, 'multiTimestamp'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link easABI}__ and `functionName` set to `"revoke"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4E0275Ea5a89e7a3c1B58411379D1a0eDdc5b088)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5A633F1cc84B03F7588486CF2F386c102061E6e1)
 */
export function usePrepareEasRevoke(
  config: Omit<
    UsePrepareContractWriteConfig<typeof easABI, 'revoke'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof easAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return usePrepareContractWrite({
    abi: easABI,
    address: easAddress[chainId as keyof typeof easAddress],
    functionName: 'revoke',
    ...config,
  } as UsePrepareContractWriteConfig<typeof easABI, 'revoke'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link easABI}__ and `functionName` set to `"revokeByDelegation"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4E0275Ea5a89e7a3c1B58411379D1a0eDdc5b088)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5A633F1cc84B03F7588486CF2F386c102061E6e1)
 */
export function usePrepareEasRevokeByDelegation(
  config: Omit<
    UsePrepareContractWriteConfig<typeof easABI, 'revokeByDelegation'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof easAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return usePrepareContractWrite({
    abi: easABI,
    address: easAddress[chainId as keyof typeof easAddress],
    functionName: 'revokeByDelegation',
    ...config,
  } as UsePrepareContractWriteConfig<typeof easABI, 'revokeByDelegation'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link easABI}__ and `functionName` set to `"revokeOffchain"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4E0275Ea5a89e7a3c1B58411379D1a0eDdc5b088)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5A633F1cc84B03F7588486CF2F386c102061E6e1)
 */
export function usePrepareEasRevokeOffchain(
  config: Omit<
    UsePrepareContractWriteConfig<typeof easABI, 'revokeOffchain'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof easAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return usePrepareContractWrite({
    abi: easABI,
    address: easAddress[chainId as keyof typeof easAddress],
    functionName: 'revokeOffchain',
    ...config,
  } as UsePrepareContractWriteConfig<typeof easABI, 'revokeOffchain'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link easABI}__ and `functionName` set to `"timestamp"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4E0275Ea5a89e7a3c1B58411379D1a0eDdc5b088)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5A633F1cc84B03F7588486CF2F386c102061E6e1)
 */
export function usePrepareEasTimestamp(
  config: Omit<
    UsePrepareContractWriteConfig<typeof easABI, 'timestamp'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof easAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return usePrepareContractWrite({
    abi: easABI,
    address: easAddress[chainId as keyof typeof easAddress],
    functionName: 'timestamp',
    ...config,
  } as UsePrepareContractWriteConfig<typeof easABI, 'timestamp'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link easABI}__.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4E0275Ea5a89e7a3c1B58411379D1a0eDdc5b088)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5A633F1cc84B03F7588486CF2F386c102061E6e1)
 */
export function useEasEvent<TEventName extends string>(
  config: Omit<
    UseContractEventConfig<typeof easABI, TEventName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof easAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractEvent({
    abi: easABI,
    address: easAddress[chainId as keyof typeof easAddress],
    ...config,
  } as UseContractEventConfig<typeof easABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link easABI}__ and `eventName` set to `"Attested"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4E0275Ea5a89e7a3c1B58411379D1a0eDdc5b088)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5A633F1cc84B03F7588486CF2F386c102061E6e1)
 */
export function useEasAttestedEvent(
  config: Omit<
    UseContractEventConfig<typeof easABI, 'Attested'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof easAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractEvent({
    abi: easABI,
    address: easAddress[chainId as keyof typeof easAddress],
    eventName: 'Attested',
    ...config,
  } as UseContractEventConfig<typeof easABI, 'Attested'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link easABI}__ and `eventName` set to `"Revoked"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4E0275Ea5a89e7a3c1B58411379D1a0eDdc5b088)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5A633F1cc84B03F7588486CF2F386c102061E6e1)
 */
export function useEasRevokedEvent(
  config: Omit<
    UseContractEventConfig<typeof easABI, 'Revoked'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof easAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractEvent({
    abi: easABI,
    address: easAddress[chainId as keyof typeof easAddress],
    eventName: 'Revoked',
    ...config,
  } as UseContractEventConfig<typeof easABI, 'Revoked'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link easABI}__ and `eventName` set to `"RevokedOffchain"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4E0275Ea5a89e7a3c1B58411379D1a0eDdc5b088)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5A633F1cc84B03F7588486CF2F386c102061E6e1)
 */
export function useEasRevokedOffchainEvent(
  config: Omit<
    UseContractEventConfig<typeof easABI, 'RevokedOffchain'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof easAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractEvent({
    abi: easABI,
    address: easAddress[chainId as keyof typeof easAddress],
    eventName: 'RevokedOffchain',
    ...config,
  } as UseContractEventConfig<typeof easABI, 'RevokedOffchain'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link easABI}__ and `eventName` set to `"Timestamped"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4E0275Ea5a89e7a3c1B58411379D1a0eDdc5b088)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5A633F1cc84B03F7588486CF2F386c102061E6e1)
 */
export function useEasTimestampedEvent(
  config: Omit<
    UseContractEventConfig<typeof easABI, 'Timestamped'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof easAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractEvent({
    abi: easABI,
    address: easAddress[chainId as keyof typeof easAddress],
    eventName: 'Timestamped',
    ...config,
  } as UseContractEventConfig<typeof easABI, 'Timestamped'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link gasPriceOracleABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x420000000000000000000000000000000000000F)
 */
export function useGasPriceOracleRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<typeof gasPriceOracleABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof gasPriceOracleABI, TFunctionName, TSelectData>,
    'abi' | 'address'
  > & { chainId?: keyof typeof gasPriceOracleAddress } = {} as any
) {
  return useContractRead({
    abi: gasPriceOracleABI,
    address: gasPriceOracleAddress[420],
    ...config,
  } as UseContractReadConfig<typeof gasPriceOracleABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link gasPriceOracleABI}__ and `functionName` set to `"baseFee"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x420000000000000000000000000000000000000F)
 */
export function useGasPriceOracleBaseFee<
  TFunctionName extends 'baseFee',
  TSelectData = ReadContractResult<typeof gasPriceOracleABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof gasPriceOracleABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof gasPriceOracleAddress } = {} as any
) {
  return useContractRead({
    abi: gasPriceOracleABI,
    address: gasPriceOracleAddress[420],
    functionName: 'baseFee',
    ...config,
  } as UseContractReadConfig<typeof gasPriceOracleABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link gasPriceOracleABI}__ and `functionName` set to `"decimals"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x420000000000000000000000000000000000000F)
 */
export function useGasPriceOracleDecimals<
  TFunctionName extends 'decimals',
  TSelectData = ReadContractResult<typeof gasPriceOracleABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof gasPriceOracleABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof gasPriceOracleAddress } = {} as any
) {
  return useContractRead({
    abi: gasPriceOracleABI,
    address: gasPriceOracleAddress[420],
    functionName: 'decimals',
    ...config,
  } as UseContractReadConfig<typeof gasPriceOracleABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link gasPriceOracleABI}__ and `functionName` set to `"gasPrice"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x420000000000000000000000000000000000000F)
 */
export function useGasPriceOracleGasPrice<
  TFunctionName extends 'gasPrice',
  TSelectData = ReadContractResult<typeof gasPriceOracleABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof gasPriceOracleABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof gasPriceOracleAddress } = {} as any
) {
  return useContractRead({
    abi: gasPriceOracleABI,
    address: gasPriceOracleAddress[420],
    functionName: 'gasPrice',
    ...config,
  } as UseContractReadConfig<typeof gasPriceOracleABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link gasPriceOracleABI}__ and `functionName` set to `"getL1Fee"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x420000000000000000000000000000000000000F)
 */
export function useGasPriceOracleGetL1Fee<
  TFunctionName extends 'getL1Fee',
  TSelectData = ReadContractResult<typeof gasPriceOracleABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof gasPriceOracleABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof gasPriceOracleAddress } = {} as any
) {
  return useContractRead({
    abi: gasPriceOracleABI,
    address: gasPriceOracleAddress[420],
    functionName: 'getL1Fee',
    ...config,
  } as UseContractReadConfig<typeof gasPriceOracleABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link gasPriceOracleABI}__ and `functionName` set to `"getL1GasUsed"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x420000000000000000000000000000000000000F)
 */
export function useGasPriceOracleGetL1GasUsed<
  TFunctionName extends 'getL1GasUsed',
  TSelectData = ReadContractResult<typeof gasPriceOracleABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof gasPriceOracleABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof gasPriceOracleAddress } = {} as any
) {
  return useContractRead({
    abi: gasPriceOracleABI,
    address: gasPriceOracleAddress[420],
    functionName: 'getL1GasUsed',
    ...config,
  } as UseContractReadConfig<typeof gasPriceOracleABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link gasPriceOracleABI}__ and `functionName` set to `"l1BaseFee"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x420000000000000000000000000000000000000F)
 */
export function useGasPriceOracleL1BaseFee<
  TFunctionName extends 'l1BaseFee',
  TSelectData = ReadContractResult<typeof gasPriceOracleABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof gasPriceOracleABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof gasPriceOracleAddress } = {} as any
) {
  return useContractRead({
    abi: gasPriceOracleABI,
    address: gasPriceOracleAddress[420],
    functionName: 'l1BaseFee',
    ...config,
  } as UseContractReadConfig<typeof gasPriceOracleABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link gasPriceOracleABI}__ and `functionName` set to `"overhead"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x420000000000000000000000000000000000000F)
 */
export function useGasPriceOracleOverhead<
  TFunctionName extends 'overhead',
  TSelectData = ReadContractResult<typeof gasPriceOracleABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof gasPriceOracleABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof gasPriceOracleAddress } = {} as any
) {
  return useContractRead({
    abi: gasPriceOracleABI,
    address: gasPriceOracleAddress[420],
    functionName: 'overhead',
    ...config,
  } as UseContractReadConfig<typeof gasPriceOracleABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link gasPriceOracleABI}__ and `functionName` set to `"scalar"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x420000000000000000000000000000000000000F)
 */
export function useGasPriceOracleScalar<
  TFunctionName extends 'scalar',
  TSelectData = ReadContractResult<typeof gasPriceOracleABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof gasPriceOracleABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof gasPriceOracleAddress } = {} as any
) {
  return useContractRead({
    abi: gasPriceOracleABI,
    address: gasPriceOracleAddress[420],
    functionName: 'scalar',
    ...config,
  } as UseContractReadConfig<typeof gasPriceOracleABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link gasPriceOracleABI}__ and `functionName` set to `"version"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x420000000000000000000000000000000000000F)
 */
export function useGasPriceOracleVersion<
  TFunctionName extends 'version',
  TSelectData = ReadContractResult<typeof gasPriceOracleABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof gasPriceOracleABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof gasPriceOracleAddress } = {} as any
) {
  return useContractRead({
    abi: gasPriceOracleABI,
    address: gasPriceOracleAddress[420],
    functionName: 'version',
    ...config,
  } as UseContractReadConfig<typeof gasPriceOracleABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1BlockABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000015)
 */
export function useL1BlockRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<typeof l1BlockABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l1BlockABI, TFunctionName, TSelectData>,
    'abi' | 'address'
  > & { chainId?: keyof typeof l1BlockAddress } = {} as any
) {
  return useContractRead({
    abi: l1BlockABI,
    address: l1BlockAddress[420],
    ...config,
  } as UseContractReadConfig<typeof l1BlockABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1BlockABI}__ and `functionName` set to `"DEPOSITOR_ACCOUNT"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000015)
 */
export function useL1BlockDepositorAccount<
  TFunctionName extends 'DEPOSITOR_ACCOUNT',
  TSelectData = ReadContractResult<typeof l1BlockABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l1BlockABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1BlockAddress } = {} as any
) {
  return useContractRead({
    abi: l1BlockABI,
    address: l1BlockAddress[420],
    functionName: 'DEPOSITOR_ACCOUNT',
    ...config,
  } as UseContractReadConfig<typeof l1BlockABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1BlockABI}__ and `functionName` set to `"basefee"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000015)
 */
export function useL1BlockBasefee<
  TFunctionName extends 'basefee',
  TSelectData = ReadContractResult<typeof l1BlockABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l1BlockABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1BlockAddress } = {} as any
) {
  return useContractRead({
    abi: l1BlockABI,
    address: l1BlockAddress[420],
    functionName: 'basefee',
    ...config,
  } as UseContractReadConfig<typeof l1BlockABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1BlockABI}__ and `functionName` set to `"batcherHash"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000015)
 */
export function useL1BlockBatcherHash<
  TFunctionName extends 'batcherHash',
  TSelectData = ReadContractResult<typeof l1BlockABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l1BlockABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1BlockAddress } = {} as any
) {
  return useContractRead({
    abi: l1BlockABI,
    address: l1BlockAddress[420],
    functionName: 'batcherHash',
    ...config,
  } as UseContractReadConfig<typeof l1BlockABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1BlockABI}__ and `functionName` set to `"hash"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000015)
 */
export function useL1BlockHash<
  TFunctionName extends 'hash',
  TSelectData = ReadContractResult<typeof l1BlockABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l1BlockABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1BlockAddress } = {} as any
) {
  return useContractRead({
    abi: l1BlockABI,
    address: l1BlockAddress[420],
    functionName: 'hash',
    ...config,
  } as UseContractReadConfig<typeof l1BlockABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1BlockABI}__ and `functionName` set to `"l1FeeOverhead"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000015)
 */
export function useL1BlockL1FeeOverhead<
  TFunctionName extends 'l1FeeOverhead',
  TSelectData = ReadContractResult<typeof l1BlockABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l1BlockABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1BlockAddress } = {} as any
) {
  return useContractRead({
    abi: l1BlockABI,
    address: l1BlockAddress[420],
    functionName: 'l1FeeOverhead',
    ...config,
  } as UseContractReadConfig<typeof l1BlockABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1BlockABI}__ and `functionName` set to `"l1FeeScalar"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000015)
 */
export function useL1BlockL1FeeScalar<
  TFunctionName extends 'l1FeeScalar',
  TSelectData = ReadContractResult<typeof l1BlockABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l1BlockABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1BlockAddress } = {} as any
) {
  return useContractRead({
    abi: l1BlockABI,
    address: l1BlockAddress[420],
    functionName: 'l1FeeScalar',
    ...config,
  } as UseContractReadConfig<typeof l1BlockABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1BlockABI}__ and `functionName` set to `"number"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000015)
 */
export function useL1BlockNumber<
  TFunctionName extends 'number',
  TSelectData = ReadContractResult<typeof l1BlockABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l1BlockABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1BlockAddress } = {} as any
) {
  return useContractRead({
    abi: l1BlockABI,
    address: l1BlockAddress[420],
    functionName: 'number',
    ...config,
  } as UseContractReadConfig<typeof l1BlockABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1BlockABI}__ and `functionName` set to `"sequenceNumber"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000015)
 */
export function useL1BlockSequenceNumber<
  TFunctionName extends 'sequenceNumber',
  TSelectData = ReadContractResult<typeof l1BlockABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l1BlockABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1BlockAddress } = {} as any
) {
  return useContractRead({
    abi: l1BlockABI,
    address: l1BlockAddress[420],
    functionName: 'sequenceNumber',
    ...config,
  } as UseContractReadConfig<typeof l1BlockABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1BlockABI}__ and `functionName` set to `"timestamp"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000015)
 */
export function useL1BlockTimestamp<
  TFunctionName extends 'timestamp',
  TSelectData = ReadContractResult<typeof l1BlockABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l1BlockABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1BlockAddress } = {} as any
) {
  return useContractRead({
    abi: l1BlockABI,
    address: l1BlockAddress[420],
    functionName: 'timestamp',
    ...config,
  } as UseContractReadConfig<typeof l1BlockABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1BlockABI}__ and `functionName` set to `"version"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000015)
 */
export function useL1BlockVersion<
  TFunctionName extends 'version',
  TSelectData = ReadContractResult<typeof l1BlockABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l1BlockABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1BlockAddress } = {} as any
) {
  return useContractRead({
    abi: l1BlockABI,
    address: l1BlockAddress[420],
    functionName: 'version',
    ...config,
  } as UseContractReadConfig<typeof l1BlockABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1BlockABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000015)
 */
export function useL1BlockWrite<
  TFunctionName extends string,
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1BlockAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<typeof l1BlockABI, string>['request']['abi'],
        TFunctionName,
        TMode
      > & { address?: Address; chainId?: TChainId }
    : UseContractWriteConfig<typeof l1BlockABI, TFunctionName, TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
      } = {} as any
) {
  return useContractWrite<typeof l1BlockABI, TFunctionName, TMode>({
    abi: l1BlockABI,
    address: l1BlockAddress[420],
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1BlockABI}__ and `functionName` set to `"setL1BlockValues"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000015)
 */
export function useL1BlockSetL1BlockValues<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1BlockAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1BlockABI,
          'setL1BlockValues'
        >['request']['abi'],
        'setL1BlockValues',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'setL1BlockValues'
      }
    : UseContractWriteConfig<typeof l1BlockABI, 'setL1BlockValues', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'setL1BlockValues'
      } = {} as any
) {
  return useContractWrite<typeof l1BlockABI, 'setL1BlockValues', TMode>({
    abi: l1BlockABI,
    address: l1BlockAddress[420],
    functionName: 'setL1BlockValues',
    ...config,
  } as any)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1BlockABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000015)
 */
export function usePrepareL1BlockWrite<TFunctionName extends string>(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l1BlockABI, TFunctionName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof l1BlockAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l1BlockABI,
    address: l1BlockAddress[420],
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1BlockABI, TFunctionName>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1BlockABI}__ and `functionName` set to `"setL1BlockValues"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000015)
 */
export function usePrepareL1BlockSetL1BlockValues(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l1BlockABI, 'setL1BlockValues'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1BlockAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l1BlockABI,
    address: l1BlockAddress[420],
    functionName: 'setL1BlockValues',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1BlockABI, 'setL1BlockValues'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 */
export function useL1CrossDomainMessengerRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<
    typeof l1CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address'
  > & { chainId?: keyof typeof l1CrossDomainMessengerAddress } = {} as any
) {
  return useContractRead({
    abi: l1CrossDomainMessengerABI,
    address: l1CrossDomainMessengerAddress[1],
    ...config,
  } as UseContractReadConfig<typeof l1CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__ and `functionName` set to `"MESSAGE_VERSION"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 */
export function useL1CrossDomainMessengerMessageVersion<
  TFunctionName extends 'MESSAGE_VERSION',
  TSelectData = ReadContractResult<
    typeof l1CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerAddress } = {} as any
) {
  return useContractRead({
    abi: l1CrossDomainMessengerABI,
    address: l1CrossDomainMessengerAddress[1],
    functionName: 'MESSAGE_VERSION',
    ...config,
  } as UseContractReadConfig<typeof l1CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__ and `functionName` set to `"MIN_GAS_CALLDATA_OVERHEAD"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 */
export function useL1CrossDomainMessengerMinGasCalldataOverhead<
  TFunctionName extends 'MIN_GAS_CALLDATA_OVERHEAD',
  TSelectData = ReadContractResult<
    typeof l1CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerAddress } = {} as any
) {
  return useContractRead({
    abi: l1CrossDomainMessengerABI,
    address: l1CrossDomainMessengerAddress[1],
    functionName: 'MIN_GAS_CALLDATA_OVERHEAD',
    ...config,
  } as UseContractReadConfig<typeof l1CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__ and `functionName` set to `"MIN_GAS_DYNAMIC_OVERHEAD_DENOMINATOR"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 */
export function useL1CrossDomainMessengerMinGasDynamicOverheadDenominator<
  TFunctionName extends 'MIN_GAS_DYNAMIC_OVERHEAD_DENOMINATOR',
  TSelectData = ReadContractResult<
    typeof l1CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerAddress } = {} as any
) {
  return useContractRead({
    abi: l1CrossDomainMessengerABI,
    address: l1CrossDomainMessengerAddress[1],
    functionName: 'MIN_GAS_DYNAMIC_OVERHEAD_DENOMINATOR',
    ...config,
  } as UseContractReadConfig<typeof l1CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__ and `functionName` set to `"MIN_GAS_DYNAMIC_OVERHEAD_NUMERATOR"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 */
export function useL1CrossDomainMessengerMinGasDynamicOverheadNumerator<
  TFunctionName extends 'MIN_GAS_DYNAMIC_OVERHEAD_NUMERATOR',
  TSelectData = ReadContractResult<
    typeof l1CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerAddress } = {} as any
) {
  return useContractRead({
    abi: l1CrossDomainMessengerABI,
    address: l1CrossDomainMessengerAddress[1],
    functionName: 'MIN_GAS_DYNAMIC_OVERHEAD_NUMERATOR',
    ...config,
  } as UseContractReadConfig<typeof l1CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__ and `functionName` set to `"OTHER_MESSENGER"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 */
export function useL1CrossDomainMessengerOtherMessenger<
  TFunctionName extends 'OTHER_MESSENGER',
  TSelectData = ReadContractResult<
    typeof l1CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerAddress } = {} as any
) {
  return useContractRead({
    abi: l1CrossDomainMessengerABI,
    address: l1CrossDomainMessengerAddress[1],
    functionName: 'OTHER_MESSENGER',
    ...config,
  } as UseContractReadConfig<typeof l1CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__ and `functionName` set to `"PORTAL"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 */
export function useL1CrossDomainMessengerPortal<
  TFunctionName extends 'PORTAL',
  TSelectData = ReadContractResult<
    typeof l1CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerAddress } = {} as any
) {
  return useContractRead({
    abi: l1CrossDomainMessengerABI,
    address: l1CrossDomainMessengerAddress[1],
    functionName: 'PORTAL',
    ...config,
  } as UseContractReadConfig<typeof l1CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__ and `functionName` set to `"RELAY_CALL_OVERHEAD"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 */
export function useL1CrossDomainMessengerRelayCallOverhead<
  TFunctionName extends 'RELAY_CALL_OVERHEAD',
  TSelectData = ReadContractResult<
    typeof l1CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerAddress } = {} as any
) {
  return useContractRead({
    abi: l1CrossDomainMessengerABI,
    address: l1CrossDomainMessengerAddress[1],
    functionName: 'RELAY_CALL_OVERHEAD',
    ...config,
  } as UseContractReadConfig<typeof l1CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__ and `functionName` set to `"RELAY_CONSTANT_OVERHEAD"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 */
export function useL1CrossDomainMessengerRelayConstantOverhead<
  TFunctionName extends 'RELAY_CONSTANT_OVERHEAD',
  TSelectData = ReadContractResult<
    typeof l1CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerAddress } = {} as any
) {
  return useContractRead({
    abi: l1CrossDomainMessengerABI,
    address: l1CrossDomainMessengerAddress[1],
    functionName: 'RELAY_CONSTANT_OVERHEAD',
    ...config,
  } as UseContractReadConfig<typeof l1CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__ and `functionName` set to `"RELAY_GAS_CHECK_BUFFER"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 */
export function useL1CrossDomainMessengerRelayGasCheckBuffer<
  TFunctionName extends 'RELAY_GAS_CHECK_BUFFER',
  TSelectData = ReadContractResult<
    typeof l1CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerAddress } = {} as any
) {
  return useContractRead({
    abi: l1CrossDomainMessengerABI,
    address: l1CrossDomainMessengerAddress[1],
    functionName: 'RELAY_GAS_CHECK_BUFFER',
    ...config,
  } as UseContractReadConfig<typeof l1CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__ and `functionName` set to `"RELAY_RESERVED_GAS"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 */
export function useL1CrossDomainMessengerRelayReservedGas<
  TFunctionName extends 'RELAY_RESERVED_GAS',
  TSelectData = ReadContractResult<
    typeof l1CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerAddress } = {} as any
) {
  return useContractRead({
    abi: l1CrossDomainMessengerABI,
    address: l1CrossDomainMessengerAddress[1],
    functionName: 'RELAY_RESERVED_GAS',
    ...config,
  } as UseContractReadConfig<typeof l1CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__ and `functionName` set to `"baseGas"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 */
export function useL1CrossDomainMessengerBaseGas<
  TFunctionName extends 'baseGas',
  TSelectData = ReadContractResult<
    typeof l1CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerAddress } = {} as any
) {
  return useContractRead({
    abi: l1CrossDomainMessengerABI,
    address: l1CrossDomainMessengerAddress[1],
    functionName: 'baseGas',
    ...config,
  } as UseContractReadConfig<typeof l1CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__ and `functionName` set to `"failedMessages"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 */
export function useL1CrossDomainMessengerFailedMessages<
  TFunctionName extends 'failedMessages',
  TSelectData = ReadContractResult<
    typeof l1CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerAddress } = {} as any
) {
  return useContractRead({
    abi: l1CrossDomainMessengerABI,
    address: l1CrossDomainMessengerAddress[1],
    functionName: 'failedMessages',
    ...config,
  } as UseContractReadConfig<typeof l1CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__ and `functionName` set to `"messageNonce"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 */
export function useL1CrossDomainMessengerMessageNonce<
  TFunctionName extends 'messageNonce',
  TSelectData = ReadContractResult<
    typeof l1CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerAddress } = {} as any
) {
  return useContractRead({
    abi: l1CrossDomainMessengerABI,
    address: l1CrossDomainMessengerAddress[1],
    functionName: 'messageNonce',
    ...config,
  } as UseContractReadConfig<typeof l1CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__ and `functionName` set to `"successfulMessages"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 */
export function useL1CrossDomainMessengerSuccessfulMessages<
  TFunctionName extends 'successfulMessages',
  TSelectData = ReadContractResult<
    typeof l1CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerAddress } = {} as any
) {
  return useContractRead({
    abi: l1CrossDomainMessengerABI,
    address: l1CrossDomainMessengerAddress[1],
    functionName: 'successfulMessages',
    ...config,
  } as UseContractReadConfig<typeof l1CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__ and `functionName` set to `"version"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 */
export function useL1CrossDomainMessengerVersion<
  TFunctionName extends 'version',
  TSelectData = ReadContractResult<
    typeof l1CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerAddress } = {} as any
) {
  return useContractRead({
    abi: l1CrossDomainMessengerABI,
    address: l1CrossDomainMessengerAddress[1],
    functionName: 'version',
    ...config,
  } as UseContractReadConfig<typeof l1CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__ and `functionName` set to `"xDomainMessageSender"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 */
export function useL1CrossDomainMessengerXDomainMessageSender<
  TFunctionName extends 'xDomainMessageSender',
  TSelectData = ReadContractResult<
    typeof l1CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerAddress } = {} as any
) {
  return useContractRead({
    abi: l1CrossDomainMessengerABI,
    address: l1CrossDomainMessengerAddress[1],
    functionName: 'xDomainMessageSender',
    ...config,
  } as UseContractReadConfig<typeof l1CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 */
export function useL1CrossDomainMessengerWrite<
  TFunctionName extends string,
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1CrossDomainMessengerAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1CrossDomainMessengerABI,
          string
        >['request']['abi'],
        TFunctionName,
        TMode
      > & { address?: Address; chainId?: TChainId }
    : UseContractWriteConfig<
        typeof l1CrossDomainMessengerABI,
        TFunctionName,
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
      } = {} as any
) {
  return useContractWrite<
    typeof l1CrossDomainMessengerABI,
    TFunctionName,
    TMode
  >({
    abi: l1CrossDomainMessengerABI,
    address: l1CrossDomainMessengerAddress[1],
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__ and `functionName` set to `"initialize"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 */
export function useL1CrossDomainMessengerInitialize<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1CrossDomainMessengerAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1CrossDomainMessengerABI,
          'initialize'
        >['request']['abi'],
        'initialize',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'initialize' }
    : UseContractWriteConfig<
        typeof l1CrossDomainMessengerABI,
        'initialize',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'initialize'
      } = {} as any
) {
  return useContractWrite<
    typeof l1CrossDomainMessengerABI,
    'initialize',
    TMode
  >({
    abi: l1CrossDomainMessengerABI,
    address: l1CrossDomainMessengerAddress[1],
    functionName: 'initialize',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__ and `functionName` set to `"relayMessage"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 */
export function useL1CrossDomainMessengerRelayMessage<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1CrossDomainMessengerAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1CrossDomainMessengerABI,
          'relayMessage'
        >['request']['abi'],
        'relayMessage',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'relayMessage'
      }
    : UseContractWriteConfig<
        typeof l1CrossDomainMessengerABI,
        'relayMessage',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'relayMessage'
      } = {} as any
) {
  return useContractWrite<
    typeof l1CrossDomainMessengerABI,
    'relayMessage',
    TMode
  >({
    abi: l1CrossDomainMessengerABI,
    address: l1CrossDomainMessengerAddress[1],
    functionName: 'relayMessage',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__ and `functionName` set to `"sendMessage"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 */
export function useL1CrossDomainMessengerSendMessage<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1CrossDomainMessengerAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1CrossDomainMessengerABI,
          'sendMessage'
        >['request']['abi'],
        'sendMessage',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'sendMessage'
      }
    : UseContractWriteConfig<
        typeof l1CrossDomainMessengerABI,
        'sendMessage',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'sendMessage'
      } = {} as any
) {
  return useContractWrite<
    typeof l1CrossDomainMessengerABI,
    'sendMessage',
    TMode
  >({
    abi: l1CrossDomainMessengerABI,
    address: l1CrossDomainMessengerAddress[1],
    functionName: 'sendMessage',
    ...config,
  } as any)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 */
export function usePrepareL1CrossDomainMessengerWrite<
  TFunctionName extends string
>(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof l1CrossDomainMessengerABI,
      TFunctionName
    >,
    'abi' | 'address'
  > & { chainId?: keyof typeof l1CrossDomainMessengerAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l1CrossDomainMessengerABI,
    address: l1CrossDomainMessengerAddress[1],
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1CrossDomainMessengerABI, TFunctionName>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__ and `functionName` set to `"initialize"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 */
export function usePrepareL1CrossDomainMessengerInitialize(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof l1CrossDomainMessengerABI,
      'initialize'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l1CrossDomainMessengerABI,
    address: l1CrossDomainMessengerAddress[1],
    functionName: 'initialize',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1CrossDomainMessengerABI, 'initialize'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__ and `functionName` set to `"relayMessage"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 */
export function usePrepareL1CrossDomainMessengerRelayMessage(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof l1CrossDomainMessengerABI,
      'relayMessage'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l1CrossDomainMessengerABI,
    address: l1CrossDomainMessengerAddress[1],
    functionName: 'relayMessage',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1CrossDomainMessengerABI, 'relayMessage'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__ and `functionName` set to `"sendMessage"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 */
export function usePrepareL1CrossDomainMessengerSendMessage(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof l1CrossDomainMessengerABI,
      'sendMessage'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l1CrossDomainMessengerABI,
    address: l1CrossDomainMessengerAddress[1],
    functionName: 'sendMessage',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1CrossDomainMessengerABI, 'sendMessage'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 */
export function useL1CrossDomainMessengerEvent<TEventName extends string>(
  config: Omit<
    UseContractEventConfig<typeof l1CrossDomainMessengerABI, TEventName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof l1CrossDomainMessengerAddress } = {} as any
) {
  return useContractEvent({
    abi: l1CrossDomainMessengerABI,
    address: l1CrossDomainMessengerAddress[1],
    ...config,
  } as UseContractEventConfig<typeof l1CrossDomainMessengerABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__ and `eventName` set to `"FailedRelayedMessage"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 */
export function useL1CrossDomainMessengerFailedRelayedMessageEvent(
  config: Omit<
    UseContractEventConfig<
      typeof l1CrossDomainMessengerABI,
      'FailedRelayedMessage'
    >,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerAddress } = {} as any
) {
  return useContractEvent({
    abi: l1CrossDomainMessengerABI,
    address: l1CrossDomainMessengerAddress[1],
    eventName: 'FailedRelayedMessage',
    ...config,
  } as UseContractEventConfig<typeof l1CrossDomainMessengerABI, 'FailedRelayedMessage'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__ and `eventName` set to `"Initialized"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 */
export function useL1CrossDomainMessengerInitializedEvent(
  config: Omit<
    UseContractEventConfig<typeof l1CrossDomainMessengerABI, 'Initialized'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerAddress } = {} as any
) {
  return useContractEvent({
    abi: l1CrossDomainMessengerABI,
    address: l1CrossDomainMessengerAddress[1],
    eventName: 'Initialized',
    ...config,
  } as UseContractEventConfig<typeof l1CrossDomainMessengerABI, 'Initialized'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__ and `eventName` set to `"RelayedMessage"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 */
export function useL1CrossDomainMessengerRelayedMessageEvent(
  config: Omit<
    UseContractEventConfig<typeof l1CrossDomainMessengerABI, 'RelayedMessage'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerAddress } = {} as any
) {
  return useContractEvent({
    abi: l1CrossDomainMessengerABI,
    address: l1CrossDomainMessengerAddress[1],
    eventName: 'RelayedMessage',
    ...config,
  } as UseContractEventConfig<typeof l1CrossDomainMessengerABI, 'RelayedMessage'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__ and `eventName` set to `"SentMessage"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 */
export function useL1CrossDomainMessengerSentMessageEvent(
  config: Omit<
    UseContractEventConfig<typeof l1CrossDomainMessengerABI, 'SentMessage'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerAddress } = {} as any
) {
  return useContractEvent({
    abi: l1CrossDomainMessengerABI,
    address: l1CrossDomainMessengerAddress[1],
    eventName: 'SentMessage',
    ...config,
  } as UseContractEventConfig<typeof l1CrossDomainMessengerABI, 'SentMessage'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__ and `eventName` set to `"SentMessageExtension1"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 */
export function useL1CrossDomainMessengerSentMessageExtension1Event(
  config: Omit<
    UseContractEventConfig<
      typeof l1CrossDomainMessengerABI,
      'SentMessageExtension1'
    >,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerAddress } = {} as any
) {
  return useContractEvent({
    abi: l1CrossDomainMessengerABI,
    address: l1CrossDomainMessengerAddress[1],
    eventName: 'SentMessageExtension1',
    ...config,
  } as UseContractEventConfig<typeof l1CrossDomainMessengerABI, 'SentMessageExtension1'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1CrossDomainMessengerGoerliABI}__.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function useL1CrossDomainMessengerGoerliRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<
    typeof l1CrossDomainMessengerGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1CrossDomainMessengerGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address'
  > & { chainId?: keyof typeof l1CrossDomainMessengerGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: l1CrossDomainMessengerGoerliABI,
    address: l1CrossDomainMessengerGoerliAddress[5],
    ...config,
  } as UseContractReadConfig<typeof l1CrossDomainMessengerGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1CrossDomainMessengerGoerliABI}__ and `functionName` set to `"MESSAGE_VERSION"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function useL1CrossDomainMessengerGoerliMessageVersion<
  TFunctionName extends 'MESSAGE_VERSION',
  TSelectData = ReadContractResult<
    typeof l1CrossDomainMessengerGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1CrossDomainMessengerGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: l1CrossDomainMessengerGoerliABI,
    address: l1CrossDomainMessengerGoerliAddress[5],
    functionName: 'MESSAGE_VERSION',
    ...config,
  } as UseContractReadConfig<typeof l1CrossDomainMessengerGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1CrossDomainMessengerGoerliABI}__ and `functionName` set to `"MIN_GAS_CALLDATA_OVERHEAD"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function useL1CrossDomainMessengerGoerliMinGasCalldataOverhead<
  TFunctionName extends 'MIN_GAS_CALLDATA_OVERHEAD',
  TSelectData = ReadContractResult<
    typeof l1CrossDomainMessengerGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1CrossDomainMessengerGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: l1CrossDomainMessengerGoerliABI,
    address: l1CrossDomainMessengerGoerliAddress[5],
    functionName: 'MIN_GAS_CALLDATA_OVERHEAD',
    ...config,
  } as UseContractReadConfig<typeof l1CrossDomainMessengerGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1CrossDomainMessengerGoerliABI}__ and `functionName` set to `"MIN_GAS_DYNAMIC_OVERHEAD_DENOMINATOR"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function useL1CrossDomainMessengerGoerliMinGasDynamicOverheadDenominator<
  TFunctionName extends 'MIN_GAS_DYNAMIC_OVERHEAD_DENOMINATOR',
  TSelectData = ReadContractResult<
    typeof l1CrossDomainMessengerGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1CrossDomainMessengerGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: l1CrossDomainMessengerGoerliABI,
    address: l1CrossDomainMessengerGoerliAddress[5],
    functionName: 'MIN_GAS_DYNAMIC_OVERHEAD_DENOMINATOR',
    ...config,
  } as UseContractReadConfig<typeof l1CrossDomainMessengerGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1CrossDomainMessengerGoerliABI}__ and `functionName` set to `"MIN_GAS_DYNAMIC_OVERHEAD_NUMERATOR"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function useL1CrossDomainMessengerGoerliMinGasDynamicOverheadNumerator<
  TFunctionName extends 'MIN_GAS_DYNAMIC_OVERHEAD_NUMERATOR',
  TSelectData = ReadContractResult<
    typeof l1CrossDomainMessengerGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1CrossDomainMessengerGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: l1CrossDomainMessengerGoerliABI,
    address: l1CrossDomainMessengerGoerliAddress[5],
    functionName: 'MIN_GAS_DYNAMIC_OVERHEAD_NUMERATOR',
    ...config,
  } as UseContractReadConfig<typeof l1CrossDomainMessengerGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1CrossDomainMessengerGoerliABI}__ and `functionName` set to `"OTHER_MESSENGER"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function useL1CrossDomainMessengerGoerliOtherMessenger<
  TFunctionName extends 'OTHER_MESSENGER',
  TSelectData = ReadContractResult<
    typeof l1CrossDomainMessengerGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1CrossDomainMessengerGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: l1CrossDomainMessengerGoerliABI,
    address: l1CrossDomainMessengerGoerliAddress[5],
    functionName: 'OTHER_MESSENGER',
    ...config,
  } as UseContractReadConfig<typeof l1CrossDomainMessengerGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1CrossDomainMessengerGoerliABI}__ and `functionName` set to `"RELAY_CALL_OVERHEAD"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function useL1CrossDomainMessengerGoerliRelayCallOverhead<
  TFunctionName extends 'RELAY_CALL_OVERHEAD',
  TSelectData = ReadContractResult<
    typeof l1CrossDomainMessengerGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1CrossDomainMessengerGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: l1CrossDomainMessengerGoerliABI,
    address: l1CrossDomainMessengerGoerliAddress[5],
    functionName: 'RELAY_CALL_OVERHEAD',
    ...config,
  } as UseContractReadConfig<typeof l1CrossDomainMessengerGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1CrossDomainMessengerGoerliABI}__ and `functionName` set to `"RELAY_CONSTANT_OVERHEAD"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function useL1CrossDomainMessengerGoerliRelayConstantOverhead<
  TFunctionName extends 'RELAY_CONSTANT_OVERHEAD',
  TSelectData = ReadContractResult<
    typeof l1CrossDomainMessengerGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1CrossDomainMessengerGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: l1CrossDomainMessengerGoerliABI,
    address: l1CrossDomainMessengerGoerliAddress[5],
    functionName: 'RELAY_CONSTANT_OVERHEAD',
    ...config,
  } as UseContractReadConfig<typeof l1CrossDomainMessengerGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1CrossDomainMessengerGoerliABI}__ and `functionName` set to `"RELAY_GAS_CHECK_BUFFER"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function useL1CrossDomainMessengerGoerliRelayGasCheckBuffer<
  TFunctionName extends 'RELAY_GAS_CHECK_BUFFER',
  TSelectData = ReadContractResult<
    typeof l1CrossDomainMessengerGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1CrossDomainMessengerGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: l1CrossDomainMessengerGoerliABI,
    address: l1CrossDomainMessengerGoerliAddress[5],
    functionName: 'RELAY_GAS_CHECK_BUFFER',
    ...config,
  } as UseContractReadConfig<typeof l1CrossDomainMessengerGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1CrossDomainMessengerGoerliABI}__ and `functionName` set to `"RELAY_RESERVED_GAS"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function useL1CrossDomainMessengerGoerliRelayReservedGas<
  TFunctionName extends 'RELAY_RESERVED_GAS',
  TSelectData = ReadContractResult<
    typeof l1CrossDomainMessengerGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1CrossDomainMessengerGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: l1CrossDomainMessengerGoerliABI,
    address: l1CrossDomainMessengerGoerliAddress[5],
    functionName: 'RELAY_RESERVED_GAS',
    ...config,
  } as UseContractReadConfig<typeof l1CrossDomainMessengerGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1CrossDomainMessengerGoerliABI}__ and `functionName` set to `"baseGas"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function useL1CrossDomainMessengerGoerliBaseGas<
  TFunctionName extends 'baseGas',
  TSelectData = ReadContractResult<
    typeof l1CrossDomainMessengerGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1CrossDomainMessengerGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: l1CrossDomainMessengerGoerliABI,
    address: l1CrossDomainMessengerGoerliAddress[5],
    functionName: 'baseGas',
    ...config,
  } as UseContractReadConfig<typeof l1CrossDomainMessengerGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1CrossDomainMessengerGoerliABI}__ and `functionName` set to `"failedMessages"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function useL1CrossDomainMessengerGoerliFailedMessages<
  TFunctionName extends 'failedMessages',
  TSelectData = ReadContractResult<
    typeof l1CrossDomainMessengerGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1CrossDomainMessengerGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: l1CrossDomainMessengerGoerliABI,
    address: l1CrossDomainMessengerGoerliAddress[5],
    functionName: 'failedMessages',
    ...config,
  } as UseContractReadConfig<typeof l1CrossDomainMessengerGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1CrossDomainMessengerGoerliABI}__ and `functionName` set to `"messageNonce"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function useL1CrossDomainMessengerGoerliMessageNonce<
  TFunctionName extends 'messageNonce',
  TSelectData = ReadContractResult<
    typeof l1CrossDomainMessengerGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1CrossDomainMessengerGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: l1CrossDomainMessengerGoerliABI,
    address: l1CrossDomainMessengerGoerliAddress[5],
    functionName: 'messageNonce',
    ...config,
  } as UseContractReadConfig<typeof l1CrossDomainMessengerGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1CrossDomainMessengerGoerliABI}__ and `functionName` set to `"portal"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function useL1CrossDomainMessengerGoerliPortal<
  TFunctionName extends 'portal',
  TSelectData = ReadContractResult<
    typeof l1CrossDomainMessengerGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1CrossDomainMessengerGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: l1CrossDomainMessengerGoerliABI,
    address: l1CrossDomainMessengerGoerliAddress[5],
    functionName: 'portal',
    ...config,
  } as UseContractReadConfig<typeof l1CrossDomainMessengerGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1CrossDomainMessengerGoerliABI}__ and `functionName` set to `"successfulMessages"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function useL1CrossDomainMessengerGoerliSuccessfulMessages<
  TFunctionName extends 'successfulMessages',
  TSelectData = ReadContractResult<
    typeof l1CrossDomainMessengerGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1CrossDomainMessengerGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: l1CrossDomainMessengerGoerliABI,
    address: l1CrossDomainMessengerGoerliAddress[5],
    functionName: 'successfulMessages',
    ...config,
  } as UseContractReadConfig<typeof l1CrossDomainMessengerGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1CrossDomainMessengerGoerliABI}__ and `functionName` set to `"version"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function useL1CrossDomainMessengerGoerliVersion<
  TFunctionName extends 'version',
  TSelectData = ReadContractResult<
    typeof l1CrossDomainMessengerGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1CrossDomainMessengerGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: l1CrossDomainMessengerGoerliABI,
    address: l1CrossDomainMessengerGoerliAddress[5],
    functionName: 'version',
    ...config,
  } as UseContractReadConfig<typeof l1CrossDomainMessengerGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1CrossDomainMessengerGoerliABI}__ and `functionName` set to `"xDomainMessageSender"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function useL1CrossDomainMessengerGoerliXDomainMessageSender<
  TFunctionName extends 'xDomainMessageSender',
  TSelectData = ReadContractResult<
    typeof l1CrossDomainMessengerGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1CrossDomainMessengerGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: l1CrossDomainMessengerGoerliABI,
    address: l1CrossDomainMessengerGoerliAddress[5],
    functionName: 'xDomainMessageSender',
    ...config,
  } as UseContractReadConfig<typeof l1CrossDomainMessengerGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1CrossDomainMessengerGoerliABI}__.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function useL1CrossDomainMessengerGoerliWrite<
  TFunctionName extends string,
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1CrossDomainMessengerGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1CrossDomainMessengerGoerliABI,
          string
        >['request']['abi'],
        TFunctionName,
        TMode
      > & { address?: Address; chainId?: TChainId }
    : UseContractWriteConfig<
        typeof l1CrossDomainMessengerGoerliABI,
        TFunctionName,
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
      } = {} as any
) {
  return useContractWrite<
    typeof l1CrossDomainMessengerGoerliABI,
    TFunctionName,
    TMode
  >({
    abi: l1CrossDomainMessengerGoerliABI,
    address: l1CrossDomainMessengerGoerliAddress[5],
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1CrossDomainMessengerGoerliABI}__ and `functionName` set to `"initialize"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function useL1CrossDomainMessengerGoerliInitialize<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1CrossDomainMessengerGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1CrossDomainMessengerGoerliABI,
          'initialize'
        >['request']['abi'],
        'initialize',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'initialize' }
    : UseContractWriteConfig<
        typeof l1CrossDomainMessengerGoerliABI,
        'initialize',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'initialize'
      } = {} as any
) {
  return useContractWrite<
    typeof l1CrossDomainMessengerGoerliABI,
    'initialize',
    TMode
  >({
    abi: l1CrossDomainMessengerGoerliABI,
    address: l1CrossDomainMessengerGoerliAddress[5],
    functionName: 'initialize',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1CrossDomainMessengerGoerliABI}__ and `functionName` set to `"relayMessage"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function useL1CrossDomainMessengerGoerliRelayMessage<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1CrossDomainMessengerGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1CrossDomainMessengerGoerliABI,
          'relayMessage'
        >['request']['abi'],
        'relayMessage',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'relayMessage'
      }
    : UseContractWriteConfig<
        typeof l1CrossDomainMessengerGoerliABI,
        'relayMessage',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'relayMessage'
      } = {} as any
) {
  return useContractWrite<
    typeof l1CrossDomainMessengerGoerliABI,
    'relayMessage',
    TMode
  >({
    abi: l1CrossDomainMessengerGoerliABI,
    address: l1CrossDomainMessengerGoerliAddress[5],
    functionName: 'relayMessage',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1CrossDomainMessengerGoerliABI}__ and `functionName` set to `"sendMessage"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function useL1CrossDomainMessengerGoerliSendMessage<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1CrossDomainMessengerGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1CrossDomainMessengerGoerliABI,
          'sendMessage'
        >['request']['abi'],
        'sendMessage',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'sendMessage'
      }
    : UseContractWriteConfig<
        typeof l1CrossDomainMessengerGoerliABI,
        'sendMessage',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'sendMessage'
      } = {} as any
) {
  return useContractWrite<
    typeof l1CrossDomainMessengerGoerliABI,
    'sendMessage',
    TMode
  >({
    abi: l1CrossDomainMessengerGoerliABI,
    address: l1CrossDomainMessengerGoerliAddress[5],
    functionName: 'sendMessage',
    ...config,
  } as any)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1CrossDomainMessengerGoerliABI}__.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function usePrepareL1CrossDomainMessengerGoerliWrite<
  TFunctionName extends string
>(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof l1CrossDomainMessengerGoerliABI,
      TFunctionName
    >,
    'abi' | 'address'
  > & { chainId?: keyof typeof l1CrossDomainMessengerGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l1CrossDomainMessengerGoerliABI,
    address: l1CrossDomainMessengerGoerliAddress[5],
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1CrossDomainMessengerGoerliABI, TFunctionName>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1CrossDomainMessengerGoerliABI}__ and `functionName` set to `"initialize"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function usePrepareL1CrossDomainMessengerGoerliInitialize(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof l1CrossDomainMessengerGoerliABI,
      'initialize'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l1CrossDomainMessengerGoerliABI,
    address: l1CrossDomainMessengerGoerliAddress[5],
    functionName: 'initialize',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1CrossDomainMessengerGoerliABI, 'initialize'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1CrossDomainMessengerGoerliABI}__ and `functionName` set to `"relayMessage"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function usePrepareL1CrossDomainMessengerGoerliRelayMessage(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof l1CrossDomainMessengerGoerliABI,
      'relayMessage'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l1CrossDomainMessengerGoerliABI,
    address: l1CrossDomainMessengerGoerliAddress[5],
    functionName: 'relayMessage',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1CrossDomainMessengerGoerliABI, 'relayMessage'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1CrossDomainMessengerGoerliABI}__ and `functionName` set to `"sendMessage"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function usePrepareL1CrossDomainMessengerGoerliSendMessage(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof l1CrossDomainMessengerGoerliABI,
      'sendMessage'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l1CrossDomainMessengerGoerliABI,
    address: l1CrossDomainMessengerGoerliAddress[5],
    functionName: 'sendMessage',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1CrossDomainMessengerGoerliABI, 'sendMessage'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1CrossDomainMessengerGoerliABI}__.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function useL1CrossDomainMessengerGoerliEvent<TEventName extends string>(
  config: Omit<
    UseContractEventConfig<typeof l1CrossDomainMessengerGoerliABI, TEventName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof l1CrossDomainMessengerGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: l1CrossDomainMessengerGoerliABI,
    address: l1CrossDomainMessengerGoerliAddress[5],
    ...config,
  } as UseContractEventConfig<typeof l1CrossDomainMessengerGoerliABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1CrossDomainMessengerGoerliABI}__ and `eventName` set to `"FailedRelayedMessage"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function useL1CrossDomainMessengerGoerliFailedRelayedMessageEvent(
  config: Omit<
    UseContractEventConfig<
      typeof l1CrossDomainMessengerGoerliABI,
      'FailedRelayedMessage'
    >,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: l1CrossDomainMessengerGoerliABI,
    address: l1CrossDomainMessengerGoerliAddress[5],
    eventName: 'FailedRelayedMessage',
    ...config,
  } as UseContractEventConfig<typeof l1CrossDomainMessengerGoerliABI, 'FailedRelayedMessage'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1CrossDomainMessengerGoerliABI}__ and `eventName` set to `"Initialized"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function useL1CrossDomainMessengerGoerliInitializedEvent(
  config: Omit<
    UseContractEventConfig<
      typeof l1CrossDomainMessengerGoerliABI,
      'Initialized'
    >,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: l1CrossDomainMessengerGoerliABI,
    address: l1CrossDomainMessengerGoerliAddress[5],
    eventName: 'Initialized',
    ...config,
  } as UseContractEventConfig<typeof l1CrossDomainMessengerGoerliABI, 'Initialized'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1CrossDomainMessengerGoerliABI}__ and `eventName` set to `"RelayedMessage"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function useL1CrossDomainMessengerGoerliRelayedMessageEvent(
  config: Omit<
    UseContractEventConfig<
      typeof l1CrossDomainMessengerGoerliABI,
      'RelayedMessage'
    >,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: l1CrossDomainMessengerGoerliABI,
    address: l1CrossDomainMessengerGoerliAddress[5],
    eventName: 'RelayedMessage',
    ...config,
  } as UseContractEventConfig<typeof l1CrossDomainMessengerGoerliABI, 'RelayedMessage'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1CrossDomainMessengerGoerliABI}__ and `eventName` set to `"SentMessage"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function useL1CrossDomainMessengerGoerliSentMessageEvent(
  config: Omit<
    UseContractEventConfig<
      typeof l1CrossDomainMessengerGoerliABI,
      'SentMessage'
    >,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: l1CrossDomainMessengerGoerliABI,
    address: l1CrossDomainMessengerGoerliAddress[5],
    eventName: 'SentMessage',
    ...config,
  } as UseContractEventConfig<typeof l1CrossDomainMessengerGoerliABI, 'SentMessage'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1CrossDomainMessengerGoerliABI}__ and `eventName` set to `"SentMessageExtension1"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function useL1CrossDomainMessengerGoerliSentMessageExtension1Event(
  config: Omit<
    UseContractEventConfig<
      typeof l1CrossDomainMessengerGoerliABI,
      'SentMessageExtension1'
    >,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: l1CrossDomainMessengerGoerliABI,
    address: l1CrossDomainMessengerGoerliAddress[5],
    eventName: 'SentMessageExtension1',
    ...config,
  } as UseContractEventConfig<typeof l1CrossDomainMessengerGoerliABI, 'SentMessageExtension1'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1Erc721BridgeABI}__.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x5a7749f83b81B301cAb5f48EB8516B986DAef23D)
 */
export function useL1Erc721BridgeRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<typeof l1Erc721BridgeABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l1Erc721BridgeABI, TFunctionName, TSelectData>,
    'abi' | 'address'
  > & { chainId?: keyof typeof l1Erc721BridgeAddress } = {} as any
) {
  return useContractRead({
    abi: l1Erc721BridgeABI,
    address: l1Erc721BridgeAddress[1],
    ...config,
  } as UseContractReadConfig<typeof l1Erc721BridgeABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1Erc721BridgeABI}__ and `functionName` set to `"deposits"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x5a7749f83b81B301cAb5f48EB8516B986DAef23D)
 */
export function useL1Erc721BridgeDeposits<
  TFunctionName extends 'deposits',
  TSelectData = ReadContractResult<typeof l1Erc721BridgeABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l1Erc721BridgeABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1Erc721BridgeAddress } = {} as any
) {
  return useContractRead({
    abi: l1Erc721BridgeABI,
    address: l1Erc721BridgeAddress[1],
    functionName: 'deposits',
    ...config,
  } as UseContractReadConfig<typeof l1Erc721BridgeABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1Erc721BridgeABI}__ and `functionName` set to `"messenger"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x5a7749f83b81B301cAb5f48EB8516B986DAef23D)
 */
export function useL1Erc721BridgeMessenger<
  TFunctionName extends 'messenger',
  TSelectData = ReadContractResult<typeof l1Erc721BridgeABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l1Erc721BridgeABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1Erc721BridgeAddress } = {} as any
) {
  return useContractRead({
    abi: l1Erc721BridgeABI,
    address: l1Erc721BridgeAddress[1],
    functionName: 'messenger',
    ...config,
  } as UseContractReadConfig<typeof l1Erc721BridgeABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1Erc721BridgeABI}__ and `functionName` set to `"otherBridge"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x5a7749f83b81B301cAb5f48EB8516B986DAef23D)
 */
export function useL1Erc721BridgeOtherBridge<
  TFunctionName extends 'otherBridge',
  TSelectData = ReadContractResult<typeof l1Erc721BridgeABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l1Erc721BridgeABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1Erc721BridgeAddress } = {} as any
) {
  return useContractRead({
    abi: l1Erc721BridgeABI,
    address: l1Erc721BridgeAddress[1],
    functionName: 'otherBridge',
    ...config,
  } as UseContractReadConfig<typeof l1Erc721BridgeABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1Erc721BridgeABI}__ and `functionName` set to `"version"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x5a7749f83b81B301cAb5f48EB8516B986DAef23D)
 */
export function useL1Erc721BridgeVersion<
  TFunctionName extends 'version',
  TSelectData = ReadContractResult<typeof l1Erc721BridgeABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l1Erc721BridgeABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1Erc721BridgeAddress } = {} as any
) {
  return useContractRead({
    abi: l1Erc721BridgeABI,
    address: l1Erc721BridgeAddress[1],
    functionName: 'version',
    ...config,
  } as UseContractReadConfig<typeof l1Erc721BridgeABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1Erc721BridgeABI}__.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x5a7749f83b81B301cAb5f48EB8516B986DAef23D)
 */
export function useL1Erc721BridgeWrite<
  TFunctionName extends string,
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1Erc721BridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1Erc721BridgeABI,
          string
        >['request']['abi'],
        TFunctionName,
        TMode
      > & { address?: Address; chainId?: TChainId }
    : UseContractWriteConfig<typeof l1Erc721BridgeABI, TFunctionName, TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
      } = {} as any
) {
  return useContractWrite<typeof l1Erc721BridgeABI, TFunctionName, TMode>({
    abi: l1Erc721BridgeABI,
    address: l1Erc721BridgeAddress[1],
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1Erc721BridgeABI}__ and `functionName` set to `"bridgeERC721"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x5a7749f83b81B301cAb5f48EB8516B986DAef23D)
 */
export function useL1Erc721BridgeBridgeErc721<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1Erc721BridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1Erc721BridgeABI,
          'bridgeERC721'
        >['request']['abi'],
        'bridgeERC721',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'bridgeERC721'
      }
    : UseContractWriteConfig<
        typeof l1Erc721BridgeABI,
        'bridgeERC721',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'bridgeERC721'
      } = {} as any
) {
  return useContractWrite<typeof l1Erc721BridgeABI, 'bridgeERC721', TMode>({
    abi: l1Erc721BridgeABI,
    address: l1Erc721BridgeAddress[1],
    functionName: 'bridgeERC721',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1Erc721BridgeABI}__ and `functionName` set to `"bridgeERC721To"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x5a7749f83b81B301cAb5f48EB8516B986DAef23D)
 */
export function useL1Erc721BridgeBridgeErc721To<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1Erc721BridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1Erc721BridgeABI,
          'bridgeERC721To'
        >['request']['abi'],
        'bridgeERC721To',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'bridgeERC721To'
      }
    : UseContractWriteConfig<
        typeof l1Erc721BridgeABI,
        'bridgeERC721To',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'bridgeERC721To'
      } = {} as any
) {
  return useContractWrite<typeof l1Erc721BridgeABI, 'bridgeERC721To', TMode>({
    abi: l1Erc721BridgeABI,
    address: l1Erc721BridgeAddress[1],
    functionName: 'bridgeERC721To',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1Erc721BridgeABI}__ and `functionName` set to `"finalizeBridgeERC721"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x5a7749f83b81B301cAb5f48EB8516B986DAef23D)
 */
export function useL1Erc721BridgeFinalizeBridgeErc721<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1Erc721BridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1Erc721BridgeABI,
          'finalizeBridgeERC721'
        >['request']['abi'],
        'finalizeBridgeERC721',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'finalizeBridgeERC721'
      }
    : UseContractWriteConfig<
        typeof l1Erc721BridgeABI,
        'finalizeBridgeERC721',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'finalizeBridgeERC721'
      } = {} as any
) {
  return useContractWrite<
    typeof l1Erc721BridgeABI,
    'finalizeBridgeERC721',
    TMode
  >({
    abi: l1Erc721BridgeABI,
    address: l1Erc721BridgeAddress[1],
    functionName: 'finalizeBridgeERC721',
    ...config,
  } as any)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1Erc721BridgeABI}__.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x5a7749f83b81B301cAb5f48EB8516B986DAef23D)
 */
export function usePrepareL1Erc721BridgeWrite<TFunctionName extends string>(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l1Erc721BridgeABI, TFunctionName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof l1Erc721BridgeAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l1Erc721BridgeABI,
    address: l1Erc721BridgeAddress[1],
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1Erc721BridgeABI, TFunctionName>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1Erc721BridgeABI}__ and `functionName` set to `"bridgeERC721"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x5a7749f83b81B301cAb5f48EB8516B986DAef23D)
 */
export function usePrepareL1Erc721BridgeBridgeErc721(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l1Erc721BridgeABI, 'bridgeERC721'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1Erc721BridgeAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l1Erc721BridgeABI,
    address: l1Erc721BridgeAddress[1],
    functionName: 'bridgeERC721',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1Erc721BridgeABI, 'bridgeERC721'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1Erc721BridgeABI}__ and `functionName` set to `"bridgeERC721To"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x5a7749f83b81B301cAb5f48EB8516B986DAef23D)
 */
export function usePrepareL1Erc721BridgeBridgeErc721To(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l1Erc721BridgeABI, 'bridgeERC721To'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1Erc721BridgeAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l1Erc721BridgeABI,
    address: l1Erc721BridgeAddress[1],
    functionName: 'bridgeERC721To',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1Erc721BridgeABI, 'bridgeERC721To'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1Erc721BridgeABI}__ and `functionName` set to `"finalizeBridgeERC721"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x5a7749f83b81B301cAb5f48EB8516B986DAef23D)
 */
export function usePrepareL1Erc721BridgeFinalizeBridgeErc721(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof l1Erc721BridgeABI,
      'finalizeBridgeERC721'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1Erc721BridgeAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l1Erc721BridgeABI,
    address: l1Erc721BridgeAddress[1],
    functionName: 'finalizeBridgeERC721',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1Erc721BridgeABI, 'finalizeBridgeERC721'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1Erc721BridgeABI}__.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x5a7749f83b81B301cAb5f48EB8516B986DAef23D)
 */
export function useL1Erc721BridgeEvent<TEventName extends string>(
  config: Omit<
    UseContractEventConfig<typeof l1Erc721BridgeABI, TEventName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof l1Erc721BridgeAddress } = {} as any
) {
  return useContractEvent({
    abi: l1Erc721BridgeABI,
    address: l1Erc721BridgeAddress[1],
    ...config,
  } as UseContractEventConfig<typeof l1Erc721BridgeABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1Erc721BridgeABI}__ and `eventName` set to `"ERC721BridgeFinalized"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x5a7749f83b81B301cAb5f48EB8516B986DAef23D)
 */
export function useL1Erc721BridgeErc721BridgeFinalizedEvent(
  config: Omit<
    UseContractEventConfig<typeof l1Erc721BridgeABI, 'ERC721BridgeFinalized'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l1Erc721BridgeAddress } = {} as any
) {
  return useContractEvent({
    abi: l1Erc721BridgeABI,
    address: l1Erc721BridgeAddress[1],
    eventName: 'ERC721BridgeFinalized',
    ...config,
  } as UseContractEventConfig<typeof l1Erc721BridgeABI, 'ERC721BridgeFinalized'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1Erc721BridgeABI}__ and `eventName` set to `"ERC721BridgeInitiated"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x5a7749f83b81B301cAb5f48EB8516B986DAef23D)
 */
export function useL1Erc721BridgeErc721BridgeInitiatedEvent(
  config: Omit<
    UseContractEventConfig<typeof l1Erc721BridgeABI, 'ERC721BridgeInitiated'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l1Erc721BridgeAddress } = {} as any
) {
  return useContractEvent({
    abi: l1Erc721BridgeABI,
    address: l1Erc721BridgeAddress[1],
    eventName: 'ERC721BridgeInitiated',
    ...config,
  } as UseContractEventConfig<typeof l1Erc721BridgeABI, 'ERC721BridgeInitiated'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1Erc721BridgeGoerliABI}__.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x8DD330DdE8D9898d43b4dc840Da27A07dF91b3c9)
 */
export function useL1Erc721BridgeGoerliRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<
    typeof l1Erc721BridgeGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1Erc721BridgeGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address'
  > & { chainId?: keyof typeof l1Erc721BridgeGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: l1Erc721BridgeGoerliABI,
    address: l1Erc721BridgeGoerliAddress[5],
    ...config,
  } as UseContractReadConfig<typeof l1Erc721BridgeGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1Erc721BridgeGoerliABI}__ and `functionName` set to `"deposits"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x8DD330DdE8D9898d43b4dc840Da27A07dF91b3c9)
 */
export function useL1Erc721BridgeGoerliDeposits<
  TFunctionName extends 'deposits',
  TSelectData = ReadContractResult<
    typeof l1Erc721BridgeGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1Erc721BridgeGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1Erc721BridgeGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: l1Erc721BridgeGoerliABI,
    address: l1Erc721BridgeGoerliAddress[5],
    functionName: 'deposits',
    ...config,
  } as UseContractReadConfig<typeof l1Erc721BridgeGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1Erc721BridgeGoerliABI}__ and `functionName` set to `"messenger"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x8DD330DdE8D9898d43b4dc840Da27A07dF91b3c9)
 */
export function useL1Erc721BridgeGoerliMessenger<
  TFunctionName extends 'messenger',
  TSelectData = ReadContractResult<
    typeof l1Erc721BridgeGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1Erc721BridgeGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1Erc721BridgeGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: l1Erc721BridgeGoerliABI,
    address: l1Erc721BridgeGoerliAddress[5],
    functionName: 'messenger',
    ...config,
  } as UseContractReadConfig<typeof l1Erc721BridgeGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1Erc721BridgeGoerliABI}__ and `functionName` set to `"otherBridge"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x8DD330DdE8D9898d43b4dc840Da27A07dF91b3c9)
 */
export function useL1Erc721BridgeGoerliOtherBridge<
  TFunctionName extends 'otherBridge',
  TSelectData = ReadContractResult<
    typeof l1Erc721BridgeGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1Erc721BridgeGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1Erc721BridgeGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: l1Erc721BridgeGoerliABI,
    address: l1Erc721BridgeGoerliAddress[5],
    functionName: 'otherBridge',
    ...config,
  } as UseContractReadConfig<typeof l1Erc721BridgeGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1Erc721BridgeGoerliABI}__ and `functionName` set to `"version"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x8DD330DdE8D9898d43b4dc840Da27A07dF91b3c9)
 */
export function useL1Erc721BridgeGoerliVersion<
  TFunctionName extends 'version',
  TSelectData = ReadContractResult<
    typeof l1Erc721BridgeGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1Erc721BridgeGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1Erc721BridgeGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: l1Erc721BridgeGoerliABI,
    address: l1Erc721BridgeGoerliAddress[5],
    functionName: 'version',
    ...config,
  } as UseContractReadConfig<typeof l1Erc721BridgeGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1Erc721BridgeGoerliABI}__.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x8DD330DdE8D9898d43b4dc840Da27A07dF91b3c9)
 */
export function useL1Erc721BridgeGoerliWrite<
  TFunctionName extends string,
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1Erc721BridgeGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1Erc721BridgeGoerliABI,
          string
        >['request']['abi'],
        TFunctionName,
        TMode
      > & { address?: Address; chainId?: TChainId }
    : UseContractWriteConfig<
        typeof l1Erc721BridgeGoerliABI,
        TFunctionName,
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
      } = {} as any
) {
  return useContractWrite<typeof l1Erc721BridgeGoerliABI, TFunctionName, TMode>(
    {
      abi: l1Erc721BridgeGoerliABI,
      address: l1Erc721BridgeGoerliAddress[5],
      ...config,
    } as any
  )
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1Erc721BridgeGoerliABI}__ and `functionName` set to `"bridgeERC721"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x8DD330DdE8D9898d43b4dc840Da27A07dF91b3c9)
 */
export function useL1Erc721BridgeGoerliBridgeErc721<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1Erc721BridgeGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1Erc721BridgeGoerliABI,
          'bridgeERC721'
        >['request']['abi'],
        'bridgeERC721',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'bridgeERC721'
      }
    : UseContractWriteConfig<
        typeof l1Erc721BridgeGoerliABI,
        'bridgeERC721',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'bridgeERC721'
      } = {} as any
) {
  return useContractWrite<
    typeof l1Erc721BridgeGoerliABI,
    'bridgeERC721',
    TMode
  >({
    abi: l1Erc721BridgeGoerliABI,
    address: l1Erc721BridgeGoerliAddress[5],
    functionName: 'bridgeERC721',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1Erc721BridgeGoerliABI}__ and `functionName` set to `"bridgeERC721To"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x8DD330DdE8D9898d43b4dc840Da27A07dF91b3c9)
 */
export function useL1Erc721BridgeGoerliBridgeErc721To<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1Erc721BridgeGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1Erc721BridgeGoerliABI,
          'bridgeERC721To'
        >['request']['abi'],
        'bridgeERC721To',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'bridgeERC721To'
      }
    : UseContractWriteConfig<
        typeof l1Erc721BridgeGoerliABI,
        'bridgeERC721To',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'bridgeERC721To'
      } = {} as any
) {
  return useContractWrite<
    typeof l1Erc721BridgeGoerliABI,
    'bridgeERC721To',
    TMode
  >({
    abi: l1Erc721BridgeGoerliABI,
    address: l1Erc721BridgeGoerliAddress[5],
    functionName: 'bridgeERC721To',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1Erc721BridgeGoerliABI}__ and `functionName` set to `"finalizeBridgeERC721"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x8DD330DdE8D9898d43b4dc840Da27A07dF91b3c9)
 */
export function useL1Erc721BridgeGoerliFinalizeBridgeErc721<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1Erc721BridgeGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1Erc721BridgeGoerliABI,
          'finalizeBridgeERC721'
        >['request']['abi'],
        'finalizeBridgeERC721',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'finalizeBridgeERC721'
      }
    : UseContractWriteConfig<
        typeof l1Erc721BridgeGoerliABI,
        'finalizeBridgeERC721',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'finalizeBridgeERC721'
      } = {} as any
) {
  return useContractWrite<
    typeof l1Erc721BridgeGoerliABI,
    'finalizeBridgeERC721',
    TMode
  >({
    abi: l1Erc721BridgeGoerliABI,
    address: l1Erc721BridgeGoerliAddress[5],
    functionName: 'finalizeBridgeERC721',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1Erc721BridgeGoerliABI}__ and `functionName` set to `"initialize"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x8DD330DdE8D9898d43b4dc840Da27A07dF91b3c9)
 */
export function useL1Erc721BridgeGoerliInitialize<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1Erc721BridgeGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1Erc721BridgeGoerliABI,
          'initialize'
        >['request']['abi'],
        'initialize',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'initialize' }
    : UseContractWriteConfig<
        typeof l1Erc721BridgeGoerliABI,
        'initialize',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'initialize'
      } = {} as any
) {
  return useContractWrite<typeof l1Erc721BridgeGoerliABI, 'initialize', TMode>({
    abi: l1Erc721BridgeGoerliABI,
    address: l1Erc721BridgeGoerliAddress[5],
    functionName: 'initialize',
    ...config,
  } as any)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1Erc721BridgeGoerliABI}__.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x8DD330DdE8D9898d43b4dc840Da27A07dF91b3c9)
 */
export function usePrepareL1Erc721BridgeGoerliWrite<
  TFunctionName extends string
>(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof l1Erc721BridgeGoerliABI,
      TFunctionName
    >,
    'abi' | 'address'
  > & { chainId?: keyof typeof l1Erc721BridgeGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l1Erc721BridgeGoerliABI,
    address: l1Erc721BridgeGoerliAddress[5],
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1Erc721BridgeGoerliABI, TFunctionName>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1Erc721BridgeGoerliABI}__ and `functionName` set to `"bridgeERC721"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x8DD330DdE8D9898d43b4dc840Da27A07dF91b3c9)
 */
export function usePrepareL1Erc721BridgeGoerliBridgeErc721(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof l1Erc721BridgeGoerliABI,
      'bridgeERC721'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1Erc721BridgeGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l1Erc721BridgeGoerliABI,
    address: l1Erc721BridgeGoerliAddress[5],
    functionName: 'bridgeERC721',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1Erc721BridgeGoerliABI, 'bridgeERC721'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1Erc721BridgeGoerliABI}__ and `functionName` set to `"bridgeERC721To"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x8DD330DdE8D9898d43b4dc840Da27A07dF91b3c9)
 */
export function usePrepareL1Erc721BridgeGoerliBridgeErc721To(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof l1Erc721BridgeGoerliABI,
      'bridgeERC721To'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1Erc721BridgeGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l1Erc721BridgeGoerliABI,
    address: l1Erc721BridgeGoerliAddress[5],
    functionName: 'bridgeERC721To',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1Erc721BridgeGoerliABI, 'bridgeERC721To'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1Erc721BridgeGoerliABI}__ and `functionName` set to `"finalizeBridgeERC721"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x8DD330DdE8D9898d43b4dc840Da27A07dF91b3c9)
 */
export function usePrepareL1Erc721BridgeGoerliFinalizeBridgeErc721(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof l1Erc721BridgeGoerliABI,
      'finalizeBridgeERC721'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1Erc721BridgeGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l1Erc721BridgeGoerliABI,
    address: l1Erc721BridgeGoerliAddress[5],
    functionName: 'finalizeBridgeERC721',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1Erc721BridgeGoerliABI, 'finalizeBridgeERC721'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1Erc721BridgeGoerliABI}__ and `functionName` set to `"initialize"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x8DD330DdE8D9898d43b4dc840Da27A07dF91b3c9)
 */
export function usePrepareL1Erc721BridgeGoerliInitialize(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l1Erc721BridgeGoerliABI, 'initialize'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1Erc721BridgeGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l1Erc721BridgeGoerliABI,
    address: l1Erc721BridgeGoerliAddress[5],
    functionName: 'initialize',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1Erc721BridgeGoerliABI, 'initialize'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1Erc721BridgeGoerliABI}__.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x8DD330DdE8D9898d43b4dc840Da27A07dF91b3c9)
 */
export function useL1Erc721BridgeGoerliEvent<TEventName extends string>(
  config: Omit<
    UseContractEventConfig<typeof l1Erc721BridgeGoerliABI, TEventName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof l1Erc721BridgeGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: l1Erc721BridgeGoerliABI,
    address: l1Erc721BridgeGoerliAddress[5],
    ...config,
  } as UseContractEventConfig<typeof l1Erc721BridgeGoerliABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1Erc721BridgeGoerliABI}__ and `eventName` set to `"ERC721BridgeFinalized"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x8DD330DdE8D9898d43b4dc840Da27A07dF91b3c9)
 */
export function useL1Erc721BridgeGoerliErc721BridgeFinalizedEvent(
  config: Omit<
    UseContractEventConfig<
      typeof l1Erc721BridgeGoerliABI,
      'ERC721BridgeFinalized'
    >,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l1Erc721BridgeGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: l1Erc721BridgeGoerliABI,
    address: l1Erc721BridgeGoerliAddress[5],
    eventName: 'ERC721BridgeFinalized',
    ...config,
  } as UseContractEventConfig<typeof l1Erc721BridgeGoerliABI, 'ERC721BridgeFinalized'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1Erc721BridgeGoerliABI}__ and `eventName` set to `"ERC721BridgeInitiated"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x8DD330DdE8D9898d43b4dc840Da27A07dF91b3c9)
 */
export function useL1Erc721BridgeGoerliErc721BridgeInitiatedEvent(
  config: Omit<
    UseContractEventConfig<
      typeof l1Erc721BridgeGoerliABI,
      'ERC721BridgeInitiated'
    >,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l1Erc721BridgeGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: l1Erc721BridgeGoerliABI,
    address: l1Erc721BridgeGoerliAddress[5],
    eventName: 'ERC721BridgeInitiated',
    ...config,
  } as UseContractEventConfig<typeof l1Erc721BridgeGoerliABI, 'ERC721BridgeInitiated'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1Erc721BridgeGoerliABI}__ and `eventName` set to `"Initialized"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x8DD330DdE8D9898d43b4dc840Da27A07dF91b3c9)
 */
export function useL1Erc721BridgeGoerliInitializedEvent(
  config: Omit<
    UseContractEventConfig<typeof l1Erc721BridgeGoerliABI, 'Initialized'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l1Erc721BridgeGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: l1Erc721BridgeGoerliABI,
    address: l1Erc721BridgeGoerliAddress[5],
    eventName: 'Initialized',
    ...config,
  } as UseContractEventConfig<typeof l1Erc721BridgeGoerliABI, 'Initialized'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1FeeVaultABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x420000000000000000000000000000000000001a)
 */
export function useL1FeeVaultRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<typeof l1FeeVaultABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l1FeeVaultABI, TFunctionName, TSelectData>,
    'abi' | 'address'
  > & { chainId?: keyof typeof l1FeeVaultAddress } = {} as any
) {
  return useContractRead({
    abi: l1FeeVaultABI,
    address: l1FeeVaultAddress[420],
    ...config,
  } as UseContractReadConfig<typeof l1FeeVaultABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1FeeVaultABI}__ and `functionName` set to `"MIN_WITHDRAWAL_AMOUNT"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x420000000000000000000000000000000000001a)
 */
export function useL1FeeVaultMinWithdrawalAmount<
  TFunctionName extends 'MIN_WITHDRAWAL_AMOUNT',
  TSelectData = ReadContractResult<typeof l1FeeVaultABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l1FeeVaultABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1FeeVaultAddress } = {} as any
) {
  return useContractRead({
    abi: l1FeeVaultABI,
    address: l1FeeVaultAddress[420],
    functionName: 'MIN_WITHDRAWAL_AMOUNT',
    ...config,
  } as UseContractReadConfig<typeof l1FeeVaultABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1FeeVaultABI}__ and `functionName` set to `"RECIPIENT"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x420000000000000000000000000000000000001a)
 */
export function useL1FeeVaultRecipient<
  TFunctionName extends 'RECIPIENT',
  TSelectData = ReadContractResult<typeof l1FeeVaultABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l1FeeVaultABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1FeeVaultAddress } = {} as any
) {
  return useContractRead({
    abi: l1FeeVaultABI,
    address: l1FeeVaultAddress[420],
    functionName: 'RECIPIENT',
    ...config,
  } as UseContractReadConfig<typeof l1FeeVaultABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1FeeVaultABI}__ and `functionName` set to `"totalProcessed"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x420000000000000000000000000000000000001a)
 */
export function useL1FeeVaultTotalProcessed<
  TFunctionName extends 'totalProcessed',
  TSelectData = ReadContractResult<typeof l1FeeVaultABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l1FeeVaultABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1FeeVaultAddress } = {} as any
) {
  return useContractRead({
    abi: l1FeeVaultABI,
    address: l1FeeVaultAddress[420],
    functionName: 'totalProcessed',
    ...config,
  } as UseContractReadConfig<typeof l1FeeVaultABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1FeeVaultABI}__ and `functionName` set to `"version"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x420000000000000000000000000000000000001a)
 */
export function useL1FeeVaultVersion<
  TFunctionName extends 'version',
  TSelectData = ReadContractResult<typeof l1FeeVaultABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l1FeeVaultABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1FeeVaultAddress } = {} as any
) {
  return useContractRead({
    abi: l1FeeVaultABI,
    address: l1FeeVaultAddress[420],
    functionName: 'version',
    ...config,
  } as UseContractReadConfig<typeof l1FeeVaultABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1FeeVaultABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x420000000000000000000000000000000000001a)
 */
export function useL1FeeVaultWrite<
  TFunctionName extends string,
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1FeeVaultAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1FeeVaultABI,
          string
        >['request']['abi'],
        TFunctionName,
        TMode
      > & { address?: Address; chainId?: TChainId }
    : UseContractWriteConfig<typeof l1FeeVaultABI, TFunctionName, TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
      } = {} as any
) {
  return useContractWrite<typeof l1FeeVaultABI, TFunctionName, TMode>({
    abi: l1FeeVaultABI,
    address: l1FeeVaultAddress[420],
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1FeeVaultABI}__ and `functionName` set to `"withdraw"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x420000000000000000000000000000000000001a)
 */
export function useL1FeeVaultWithdraw<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1FeeVaultAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1FeeVaultABI,
          'withdraw'
        >['request']['abi'],
        'withdraw',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'withdraw' }
    : UseContractWriteConfig<typeof l1FeeVaultABI, 'withdraw', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'withdraw'
      } = {} as any
) {
  return useContractWrite<typeof l1FeeVaultABI, 'withdraw', TMode>({
    abi: l1FeeVaultABI,
    address: l1FeeVaultAddress[420],
    functionName: 'withdraw',
    ...config,
  } as any)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1FeeVaultABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x420000000000000000000000000000000000001a)
 */
export function usePrepareL1FeeVaultWrite<TFunctionName extends string>(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l1FeeVaultABI, TFunctionName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof l1FeeVaultAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l1FeeVaultABI,
    address: l1FeeVaultAddress[420],
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1FeeVaultABI, TFunctionName>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1FeeVaultABI}__ and `functionName` set to `"withdraw"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x420000000000000000000000000000000000001a)
 */
export function usePrepareL1FeeVaultWithdraw(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l1FeeVaultABI, 'withdraw'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1FeeVaultAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l1FeeVaultABI,
    address: l1FeeVaultAddress[420],
    functionName: 'withdraw',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1FeeVaultABI, 'withdraw'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1FeeVaultABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x420000000000000000000000000000000000001a)
 */
export function useL1FeeVaultEvent<TEventName extends string>(
  config: Omit<
    UseContractEventConfig<typeof l1FeeVaultABI, TEventName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof l1FeeVaultAddress } = {} as any
) {
  return useContractEvent({
    abi: l1FeeVaultABI,
    address: l1FeeVaultAddress[420],
    ...config,
  } as UseContractEventConfig<typeof l1FeeVaultABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1FeeVaultABI}__ and `eventName` set to `"Withdrawal"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x420000000000000000000000000000000000001a)
 */
export function useL1FeeVaultWithdrawalEvent(
  config: Omit<
    UseContractEventConfig<typeof l1FeeVaultABI, 'Withdrawal'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l1FeeVaultAddress } = {} as any
) {
  return useContractEvent({
    abi: l1FeeVaultABI,
    address: l1FeeVaultAddress[420],
    eventName: 'Withdrawal',
    ...config,
  } as UseContractEventConfig<typeof l1FeeVaultABI, 'Withdrawal'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1StandardBridgeABI}__.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 */
export function useL1StandardBridgeRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<typeof l1StandardBridgeABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1StandardBridgeABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address'
  > & { chainId?: keyof typeof l1StandardBridgeAddress } = {} as any
) {
  return useContractRead({
    abi: l1StandardBridgeABI,
    address: l1StandardBridgeAddress[1],
    ...config,
  } as UseContractReadConfig<typeof l1StandardBridgeABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `functionName` set to `"OTHER_BRIDGE"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 */
export function useL1StandardBridgeOtherBridge<
  TFunctionName extends 'OTHER_BRIDGE',
  TSelectData = ReadContractResult<typeof l1StandardBridgeABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1StandardBridgeABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1StandardBridgeAddress } = {} as any
) {
  return useContractRead({
    abi: l1StandardBridgeABI,
    address: l1StandardBridgeAddress[1],
    functionName: 'OTHER_BRIDGE',
    ...config,
  } as UseContractReadConfig<typeof l1StandardBridgeABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `functionName` set to `"deposits"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 */
export function useL1StandardBridgeDeposits<
  TFunctionName extends 'deposits',
  TSelectData = ReadContractResult<typeof l1StandardBridgeABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1StandardBridgeABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1StandardBridgeAddress } = {} as any
) {
  return useContractRead({
    abi: l1StandardBridgeABI,
    address: l1StandardBridgeAddress[1],
    functionName: 'deposits',
    ...config,
  } as UseContractReadConfig<typeof l1StandardBridgeABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `functionName` set to `"l2TokenBridge"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 */
export function useL1StandardBridgeL2TokenBridge<
  TFunctionName extends 'l2TokenBridge',
  TSelectData = ReadContractResult<typeof l1StandardBridgeABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1StandardBridgeABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1StandardBridgeAddress } = {} as any
) {
  return useContractRead({
    abi: l1StandardBridgeABI,
    address: l1StandardBridgeAddress[1],
    functionName: 'l2TokenBridge',
    ...config,
  } as UseContractReadConfig<typeof l1StandardBridgeABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `functionName` set to `"messenger"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 */
export function useL1StandardBridgeMessenger<
  TFunctionName extends 'messenger',
  TSelectData = ReadContractResult<typeof l1StandardBridgeABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1StandardBridgeABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1StandardBridgeAddress } = {} as any
) {
  return useContractRead({
    abi: l1StandardBridgeABI,
    address: l1StandardBridgeAddress[1],
    functionName: 'messenger',
    ...config,
  } as UseContractReadConfig<typeof l1StandardBridgeABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `functionName` set to `"version"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 */
export function useL1StandardBridgeVersion<
  TFunctionName extends 'version',
  TSelectData = ReadContractResult<typeof l1StandardBridgeABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1StandardBridgeABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1StandardBridgeAddress } = {} as any
) {
  return useContractRead({
    abi: l1StandardBridgeABI,
    address: l1StandardBridgeAddress[1],
    functionName: 'version',
    ...config,
  } as UseContractReadConfig<typeof l1StandardBridgeABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1StandardBridgeABI}__.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 */
export function useL1StandardBridgeWrite<
  TFunctionName extends string,
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1StandardBridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1StandardBridgeABI,
          string
        >['request']['abi'],
        TFunctionName,
        TMode
      > & { address?: Address; chainId?: TChainId }
    : UseContractWriteConfig<
        typeof l1StandardBridgeABI,
        TFunctionName,
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
      } = {} as any
) {
  return useContractWrite<typeof l1StandardBridgeABI, TFunctionName, TMode>({
    abi: l1StandardBridgeABI,
    address: l1StandardBridgeAddress[1],
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `functionName` set to `"bridgeERC20"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 */
export function useL1StandardBridgeBridgeErc20<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1StandardBridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1StandardBridgeABI,
          'bridgeERC20'
        >['request']['abi'],
        'bridgeERC20',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'bridgeERC20'
      }
    : UseContractWriteConfig<
        typeof l1StandardBridgeABI,
        'bridgeERC20',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'bridgeERC20'
      } = {} as any
) {
  return useContractWrite<typeof l1StandardBridgeABI, 'bridgeERC20', TMode>({
    abi: l1StandardBridgeABI,
    address: l1StandardBridgeAddress[1],
    functionName: 'bridgeERC20',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `functionName` set to `"bridgeERC20To"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 */
export function useL1StandardBridgeBridgeErc20To<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1StandardBridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1StandardBridgeABI,
          'bridgeERC20To'
        >['request']['abi'],
        'bridgeERC20To',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'bridgeERC20To'
      }
    : UseContractWriteConfig<
        typeof l1StandardBridgeABI,
        'bridgeERC20To',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'bridgeERC20To'
      } = {} as any
) {
  return useContractWrite<typeof l1StandardBridgeABI, 'bridgeERC20To', TMode>({
    abi: l1StandardBridgeABI,
    address: l1StandardBridgeAddress[1],
    functionName: 'bridgeERC20To',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `functionName` set to `"bridgeETH"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 */
export function useL1StandardBridgeBridgeEth<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1StandardBridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1StandardBridgeABI,
          'bridgeETH'
        >['request']['abi'],
        'bridgeETH',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'bridgeETH' }
    : UseContractWriteConfig<typeof l1StandardBridgeABI, 'bridgeETH', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'bridgeETH'
      } = {} as any
) {
  return useContractWrite<typeof l1StandardBridgeABI, 'bridgeETH', TMode>({
    abi: l1StandardBridgeABI,
    address: l1StandardBridgeAddress[1],
    functionName: 'bridgeETH',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `functionName` set to `"bridgeETHTo"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 */
export function useL1StandardBridgeBridgeEthTo<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1StandardBridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1StandardBridgeABI,
          'bridgeETHTo'
        >['request']['abi'],
        'bridgeETHTo',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'bridgeETHTo'
      }
    : UseContractWriteConfig<
        typeof l1StandardBridgeABI,
        'bridgeETHTo',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'bridgeETHTo'
      } = {} as any
) {
  return useContractWrite<typeof l1StandardBridgeABI, 'bridgeETHTo', TMode>({
    abi: l1StandardBridgeABI,
    address: l1StandardBridgeAddress[1],
    functionName: 'bridgeETHTo',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `functionName` set to `"depositERC20"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 */
export function useL1StandardBridgeDepositErc20<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1StandardBridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1StandardBridgeABI,
          'depositERC20'
        >['request']['abi'],
        'depositERC20',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'depositERC20'
      }
    : UseContractWriteConfig<
        typeof l1StandardBridgeABI,
        'depositERC20',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'depositERC20'
      } = {} as any
) {
  return useContractWrite<typeof l1StandardBridgeABI, 'depositERC20', TMode>({
    abi: l1StandardBridgeABI,
    address: l1StandardBridgeAddress[1],
    functionName: 'depositERC20',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `functionName` set to `"depositERC20To"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 */
export function useL1StandardBridgeDepositErc20To<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1StandardBridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1StandardBridgeABI,
          'depositERC20To'
        >['request']['abi'],
        'depositERC20To',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'depositERC20To'
      }
    : UseContractWriteConfig<
        typeof l1StandardBridgeABI,
        'depositERC20To',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'depositERC20To'
      } = {} as any
) {
  return useContractWrite<typeof l1StandardBridgeABI, 'depositERC20To', TMode>({
    abi: l1StandardBridgeABI,
    address: l1StandardBridgeAddress[1],
    functionName: 'depositERC20To',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `functionName` set to `"depositETH"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 */
export function useL1StandardBridgeDepositEth<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1StandardBridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1StandardBridgeABI,
          'depositETH'
        >['request']['abi'],
        'depositETH',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'depositETH' }
    : UseContractWriteConfig<
        typeof l1StandardBridgeABI,
        'depositETH',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'depositETH'
      } = {} as any
) {
  return useContractWrite<typeof l1StandardBridgeABI, 'depositETH', TMode>({
    abi: l1StandardBridgeABI,
    address: l1StandardBridgeAddress[1],
    functionName: 'depositETH',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `functionName` set to `"depositETHTo"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 */
export function useL1StandardBridgeDepositEthTo<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1StandardBridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1StandardBridgeABI,
          'depositETHTo'
        >['request']['abi'],
        'depositETHTo',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'depositETHTo'
      }
    : UseContractWriteConfig<
        typeof l1StandardBridgeABI,
        'depositETHTo',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'depositETHTo'
      } = {} as any
) {
  return useContractWrite<typeof l1StandardBridgeABI, 'depositETHTo', TMode>({
    abi: l1StandardBridgeABI,
    address: l1StandardBridgeAddress[1],
    functionName: 'depositETHTo',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `functionName` set to `"finalizeBridgeERC20"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 */
export function useL1StandardBridgeFinalizeBridgeErc20<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1StandardBridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1StandardBridgeABI,
          'finalizeBridgeERC20'
        >['request']['abi'],
        'finalizeBridgeERC20',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'finalizeBridgeERC20'
      }
    : UseContractWriteConfig<
        typeof l1StandardBridgeABI,
        'finalizeBridgeERC20',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'finalizeBridgeERC20'
      } = {} as any
) {
  return useContractWrite<
    typeof l1StandardBridgeABI,
    'finalizeBridgeERC20',
    TMode
  >({
    abi: l1StandardBridgeABI,
    address: l1StandardBridgeAddress[1],
    functionName: 'finalizeBridgeERC20',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `functionName` set to `"finalizeBridgeETH"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 */
export function useL1StandardBridgeFinalizeBridgeEth<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1StandardBridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1StandardBridgeABI,
          'finalizeBridgeETH'
        >['request']['abi'],
        'finalizeBridgeETH',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'finalizeBridgeETH'
      }
    : UseContractWriteConfig<
        typeof l1StandardBridgeABI,
        'finalizeBridgeETH',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'finalizeBridgeETH'
      } = {} as any
) {
  return useContractWrite<
    typeof l1StandardBridgeABI,
    'finalizeBridgeETH',
    TMode
  >({
    abi: l1StandardBridgeABI,
    address: l1StandardBridgeAddress[1],
    functionName: 'finalizeBridgeETH',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `functionName` set to `"finalizeERC20Withdrawal"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 */
export function useL1StandardBridgeFinalizeErc20Withdrawal<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1StandardBridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1StandardBridgeABI,
          'finalizeERC20Withdrawal'
        >['request']['abi'],
        'finalizeERC20Withdrawal',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'finalizeERC20Withdrawal'
      }
    : UseContractWriteConfig<
        typeof l1StandardBridgeABI,
        'finalizeERC20Withdrawal',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'finalizeERC20Withdrawal'
      } = {} as any
) {
  return useContractWrite<
    typeof l1StandardBridgeABI,
    'finalizeERC20Withdrawal',
    TMode
  >({
    abi: l1StandardBridgeABI,
    address: l1StandardBridgeAddress[1],
    functionName: 'finalizeERC20Withdrawal',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `functionName` set to `"finalizeETHWithdrawal"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 */
export function useL1StandardBridgeFinalizeEthWithdrawal<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1StandardBridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1StandardBridgeABI,
          'finalizeETHWithdrawal'
        >['request']['abi'],
        'finalizeETHWithdrawal',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'finalizeETHWithdrawal'
      }
    : UseContractWriteConfig<
        typeof l1StandardBridgeABI,
        'finalizeETHWithdrawal',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'finalizeETHWithdrawal'
      } = {} as any
) {
  return useContractWrite<
    typeof l1StandardBridgeABI,
    'finalizeETHWithdrawal',
    TMode
  >({
    abi: l1StandardBridgeABI,
    address: l1StandardBridgeAddress[1],
    functionName: 'finalizeETHWithdrawal',
    ...config,
  } as any)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1StandardBridgeABI}__.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 */
export function usePrepareL1StandardBridgeWrite<TFunctionName extends string>(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l1StandardBridgeABI, TFunctionName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof l1StandardBridgeAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l1StandardBridgeABI,
    address: l1StandardBridgeAddress[1],
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1StandardBridgeABI, TFunctionName>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `functionName` set to `"bridgeERC20"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 */
export function usePrepareL1StandardBridgeBridgeErc20(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l1StandardBridgeABI, 'bridgeERC20'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1StandardBridgeAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l1StandardBridgeABI,
    address: l1StandardBridgeAddress[1],
    functionName: 'bridgeERC20',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1StandardBridgeABI, 'bridgeERC20'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `functionName` set to `"bridgeERC20To"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 */
export function usePrepareL1StandardBridgeBridgeErc20To(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l1StandardBridgeABI, 'bridgeERC20To'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1StandardBridgeAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l1StandardBridgeABI,
    address: l1StandardBridgeAddress[1],
    functionName: 'bridgeERC20To',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1StandardBridgeABI, 'bridgeERC20To'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `functionName` set to `"bridgeETH"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 */
export function usePrepareL1StandardBridgeBridgeEth(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l1StandardBridgeABI, 'bridgeETH'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1StandardBridgeAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l1StandardBridgeABI,
    address: l1StandardBridgeAddress[1],
    functionName: 'bridgeETH',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1StandardBridgeABI, 'bridgeETH'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `functionName` set to `"bridgeETHTo"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 */
export function usePrepareL1StandardBridgeBridgeEthTo(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l1StandardBridgeABI, 'bridgeETHTo'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1StandardBridgeAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l1StandardBridgeABI,
    address: l1StandardBridgeAddress[1],
    functionName: 'bridgeETHTo',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1StandardBridgeABI, 'bridgeETHTo'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `functionName` set to `"depositERC20"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 */
export function usePrepareL1StandardBridgeDepositErc20(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l1StandardBridgeABI, 'depositERC20'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1StandardBridgeAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l1StandardBridgeABI,
    address: l1StandardBridgeAddress[1],
    functionName: 'depositERC20',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1StandardBridgeABI, 'depositERC20'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `functionName` set to `"depositERC20To"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 */
export function usePrepareL1StandardBridgeDepositErc20To(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l1StandardBridgeABI, 'depositERC20To'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1StandardBridgeAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l1StandardBridgeABI,
    address: l1StandardBridgeAddress[1],
    functionName: 'depositERC20To',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1StandardBridgeABI, 'depositERC20To'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `functionName` set to `"depositETH"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 */
export function usePrepareL1StandardBridgeDepositEth(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l1StandardBridgeABI, 'depositETH'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1StandardBridgeAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l1StandardBridgeABI,
    address: l1StandardBridgeAddress[1],
    functionName: 'depositETH',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1StandardBridgeABI, 'depositETH'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `functionName` set to `"depositETHTo"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 */
export function usePrepareL1StandardBridgeDepositEthTo(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l1StandardBridgeABI, 'depositETHTo'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1StandardBridgeAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l1StandardBridgeABI,
    address: l1StandardBridgeAddress[1],
    functionName: 'depositETHTo',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1StandardBridgeABI, 'depositETHTo'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `functionName` set to `"finalizeBridgeERC20"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 */
export function usePrepareL1StandardBridgeFinalizeBridgeErc20(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof l1StandardBridgeABI,
      'finalizeBridgeERC20'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1StandardBridgeAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l1StandardBridgeABI,
    address: l1StandardBridgeAddress[1],
    functionName: 'finalizeBridgeERC20',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1StandardBridgeABI, 'finalizeBridgeERC20'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `functionName` set to `"finalizeBridgeETH"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 */
export function usePrepareL1StandardBridgeFinalizeBridgeEth(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof l1StandardBridgeABI,
      'finalizeBridgeETH'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1StandardBridgeAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l1StandardBridgeABI,
    address: l1StandardBridgeAddress[1],
    functionName: 'finalizeBridgeETH',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1StandardBridgeABI, 'finalizeBridgeETH'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `functionName` set to `"finalizeERC20Withdrawal"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 */
export function usePrepareL1StandardBridgeFinalizeErc20Withdrawal(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof l1StandardBridgeABI,
      'finalizeERC20Withdrawal'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1StandardBridgeAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l1StandardBridgeABI,
    address: l1StandardBridgeAddress[1],
    functionName: 'finalizeERC20Withdrawal',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1StandardBridgeABI, 'finalizeERC20Withdrawal'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `functionName` set to `"finalizeETHWithdrawal"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 */
export function usePrepareL1StandardBridgeFinalizeEthWithdrawal(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof l1StandardBridgeABI,
      'finalizeETHWithdrawal'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1StandardBridgeAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l1StandardBridgeABI,
    address: l1StandardBridgeAddress[1],
    functionName: 'finalizeETHWithdrawal',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1StandardBridgeABI, 'finalizeETHWithdrawal'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1StandardBridgeABI}__.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 */
export function useL1StandardBridgeEvent<TEventName extends string>(
  config: Omit<
    UseContractEventConfig<typeof l1StandardBridgeABI, TEventName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof l1StandardBridgeAddress } = {} as any
) {
  return useContractEvent({
    abi: l1StandardBridgeABI,
    address: l1StandardBridgeAddress[1],
    ...config,
  } as UseContractEventConfig<typeof l1StandardBridgeABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `eventName` set to `"ERC20BridgeFinalized"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 */
export function useL1StandardBridgeErc20BridgeFinalizedEvent(
  config: Omit<
    UseContractEventConfig<typeof l1StandardBridgeABI, 'ERC20BridgeFinalized'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l1StandardBridgeAddress } = {} as any
) {
  return useContractEvent({
    abi: l1StandardBridgeABI,
    address: l1StandardBridgeAddress[1],
    eventName: 'ERC20BridgeFinalized',
    ...config,
  } as UseContractEventConfig<typeof l1StandardBridgeABI, 'ERC20BridgeFinalized'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `eventName` set to `"ERC20BridgeInitiated"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 */
export function useL1StandardBridgeErc20BridgeInitiatedEvent(
  config: Omit<
    UseContractEventConfig<typeof l1StandardBridgeABI, 'ERC20BridgeInitiated'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l1StandardBridgeAddress } = {} as any
) {
  return useContractEvent({
    abi: l1StandardBridgeABI,
    address: l1StandardBridgeAddress[1],
    eventName: 'ERC20BridgeInitiated',
    ...config,
  } as UseContractEventConfig<typeof l1StandardBridgeABI, 'ERC20BridgeInitiated'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `eventName` set to `"ERC20DepositInitiated"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 */
export function useL1StandardBridgeErc20DepositInitiatedEvent(
  config: Omit<
    UseContractEventConfig<typeof l1StandardBridgeABI, 'ERC20DepositInitiated'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l1StandardBridgeAddress } = {} as any
) {
  return useContractEvent({
    abi: l1StandardBridgeABI,
    address: l1StandardBridgeAddress[1],
    eventName: 'ERC20DepositInitiated',
    ...config,
  } as UseContractEventConfig<typeof l1StandardBridgeABI, 'ERC20DepositInitiated'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `eventName` set to `"ERC20WithdrawalFinalized"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 */
export function useL1StandardBridgeErc20WithdrawalFinalizedEvent(
  config: Omit<
    UseContractEventConfig<
      typeof l1StandardBridgeABI,
      'ERC20WithdrawalFinalized'
    >,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l1StandardBridgeAddress } = {} as any
) {
  return useContractEvent({
    abi: l1StandardBridgeABI,
    address: l1StandardBridgeAddress[1],
    eventName: 'ERC20WithdrawalFinalized',
    ...config,
  } as UseContractEventConfig<typeof l1StandardBridgeABI, 'ERC20WithdrawalFinalized'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `eventName` set to `"ETHBridgeFinalized"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 */
export function useL1StandardBridgeEthBridgeFinalizedEvent(
  config: Omit<
    UseContractEventConfig<typeof l1StandardBridgeABI, 'ETHBridgeFinalized'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l1StandardBridgeAddress } = {} as any
) {
  return useContractEvent({
    abi: l1StandardBridgeABI,
    address: l1StandardBridgeAddress[1],
    eventName: 'ETHBridgeFinalized',
    ...config,
  } as UseContractEventConfig<typeof l1StandardBridgeABI, 'ETHBridgeFinalized'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `eventName` set to `"ETHBridgeInitiated"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 */
export function useL1StandardBridgeEthBridgeInitiatedEvent(
  config: Omit<
    UseContractEventConfig<typeof l1StandardBridgeABI, 'ETHBridgeInitiated'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l1StandardBridgeAddress } = {} as any
) {
  return useContractEvent({
    abi: l1StandardBridgeABI,
    address: l1StandardBridgeAddress[1],
    eventName: 'ETHBridgeInitiated',
    ...config,
  } as UseContractEventConfig<typeof l1StandardBridgeABI, 'ETHBridgeInitiated'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `eventName` set to `"ETHDepositInitiated"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 */
export function useL1StandardBridgeEthDepositInitiatedEvent(
  config: Omit<
    UseContractEventConfig<typeof l1StandardBridgeABI, 'ETHDepositInitiated'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l1StandardBridgeAddress } = {} as any
) {
  return useContractEvent({
    abi: l1StandardBridgeABI,
    address: l1StandardBridgeAddress[1],
    eventName: 'ETHDepositInitiated',
    ...config,
  } as UseContractEventConfig<typeof l1StandardBridgeABI, 'ETHDepositInitiated'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `eventName` set to `"ETHWithdrawalFinalized"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 */
export function useL1StandardBridgeEthWithdrawalFinalizedEvent(
  config: Omit<
    UseContractEventConfig<
      typeof l1StandardBridgeABI,
      'ETHWithdrawalFinalized'
    >,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l1StandardBridgeAddress } = {} as any
) {
  return useContractEvent({
    abi: l1StandardBridgeABI,
    address: l1StandardBridgeAddress[1],
    eventName: 'ETHWithdrawalFinalized',
    ...config,
  } as UseContractEventConfig<typeof l1StandardBridgeABI, 'ETHWithdrawalFinalized'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1StandardBridgeGoerliABI}__.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function useL1StandardBridgeGoerliRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<
    typeof l1StandardBridgeGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1StandardBridgeGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address'
  > & { chainId?: keyof typeof l1StandardBridgeGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: l1StandardBridgeGoerliABI,
    address: l1StandardBridgeGoerliAddress[5],
    ...config,
  } as UseContractReadConfig<typeof l1StandardBridgeGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1StandardBridgeGoerliABI}__ and `functionName` set to `"deposits"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function useL1StandardBridgeGoerliDeposits<
  TFunctionName extends 'deposits',
  TSelectData = ReadContractResult<
    typeof l1StandardBridgeGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1StandardBridgeGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1StandardBridgeGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: l1StandardBridgeGoerliABI,
    address: l1StandardBridgeGoerliAddress[5],
    functionName: 'deposits',
    ...config,
  } as UseContractReadConfig<typeof l1StandardBridgeGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1StandardBridgeGoerliABI}__ and `functionName` set to `"l2TokenBridge"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function useL1StandardBridgeGoerliL2TokenBridge<
  TFunctionName extends 'l2TokenBridge',
  TSelectData = ReadContractResult<
    typeof l1StandardBridgeGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1StandardBridgeGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1StandardBridgeGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: l1StandardBridgeGoerliABI,
    address: l1StandardBridgeGoerliAddress[5],
    functionName: 'l2TokenBridge',
    ...config,
  } as UseContractReadConfig<typeof l1StandardBridgeGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1StandardBridgeGoerliABI}__ and `functionName` set to `"messenger"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function useL1StandardBridgeGoerliMessenger<
  TFunctionName extends 'messenger',
  TSelectData = ReadContractResult<
    typeof l1StandardBridgeGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1StandardBridgeGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1StandardBridgeGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: l1StandardBridgeGoerliABI,
    address: l1StandardBridgeGoerliAddress[5],
    functionName: 'messenger',
    ...config,
  } as UseContractReadConfig<typeof l1StandardBridgeGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1StandardBridgeGoerliABI}__ and `functionName` set to `"otherBridge"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function useL1StandardBridgeGoerliOtherBridge<
  TFunctionName extends 'otherBridge',
  TSelectData = ReadContractResult<
    typeof l1StandardBridgeGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1StandardBridgeGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1StandardBridgeGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: l1StandardBridgeGoerliABI,
    address: l1StandardBridgeGoerliAddress[5],
    functionName: 'otherBridge',
    ...config,
  } as UseContractReadConfig<typeof l1StandardBridgeGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1StandardBridgeGoerliABI}__ and `functionName` set to `"version"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function useL1StandardBridgeGoerliVersion<
  TFunctionName extends 'version',
  TSelectData = ReadContractResult<
    typeof l1StandardBridgeGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1StandardBridgeGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1StandardBridgeGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: l1StandardBridgeGoerliABI,
    address: l1StandardBridgeGoerliAddress[5],
    functionName: 'version',
    ...config,
  } as UseContractReadConfig<typeof l1StandardBridgeGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1StandardBridgeGoerliABI}__.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function useL1StandardBridgeGoerliWrite<
  TFunctionName extends string,
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1StandardBridgeGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1StandardBridgeGoerliABI,
          string
        >['request']['abi'],
        TFunctionName,
        TMode
      > & { address?: Address; chainId?: TChainId }
    : UseContractWriteConfig<
        typeof l1StandardBridgeGoerliABI,
        TFunctionName,
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
      } = {} as any
) {
  return useContractWrite<
    typeof l1StandardBridgeGoerliABI,
    TFunctionName,
    TMode
  >({
    abi: l1StandardBridgeGoerliABI,
    address: l1StandardBridgeGoerliAddress[5],
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1StandardBridgeGoerliABI}__ and `functionName` set to `"bridgeERC20"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function useL1StandardBridgeGoerliBridgeErc20<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1StandardBridgeGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1StandardBridgeGoerliABI,
          'bridgeERC20'
        >['request']['abi'],
        'bridgeERC20',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'bridgeERC20'
      }
    : UseContractWriteConfig<
        typeof l1StandardBridgeGoerliABI,
        'bridgeERC20',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'bridgeERC20'
      } = {} as any
) {
  return useContractWrite<
    typeof l1StandardBridgeGoerliABI,
    'bridgeERC20',
    TMode
  >({
    abi: l1StandardBridgeGoerliABI,
    address: l1StandardBridgeGoerliAddress[5],
    functionName: 'bridgeERC20',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1StandardBridgeGoerliABI}__ and `functionName` set to `"bridgeERC20To"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function useL1StandardBridgeGoerliBridgeErc20To<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1StandardBridgeGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1StandardBridgeGoerliABI,
          'bridgeERC20To'
        >['request']['abi'],
        'bridgeERC20To',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'bridgeERC20To'
      }
    : UseContractWriteConfig<
        typeof l1StandardBridgeGoerliABI,
        'bridgeERC20To',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'bridgeERC20To'
      } = {} as any
) {
  return useContractWrite<
    typeof l1StandardBridgeGoerliABI,
    'bridgeERC20To',
    TMode
  >({
    abi: l1StandardBridgeGoerliABI,
    address: l1StandardBridgeGoerliAddress[5],
    functionName: 'bridgeERC20To',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1StandardBridgeGoerliABI}__ and `functionName` set to `"bridgeETH"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function useL1StandardBridgeGoerliBridgeEth<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1StandardBridgeGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1StandardBridgeGoerliABI,
          'bridgeETH'
        >['request']['abi'],
        'bridgeETH',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'bridgeETH' }
    : UseContractWriteConfig<
        typeof l1StandardBridgeGoerliABI,
        'bridgeETH',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'bridgeETH'
      } = {} as any
) {
  return useContractWrite<typeof l1StandardBridgeGoerliABI, 'bridgeETH', TMode>(
    {
      abi: l1StandardBridgeGoerliABI,
      address: l1StandardBridgeGoerliAddress[5],
      functionName: 'bridgeETH',
      ...config,
    } as any
  )
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1StandardBridgeGoerliABI}__ and `functionName` set to `"bridgeETHTo"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function useL1StandardBridgeGoerliBridgeEthTo<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1StandardBridgeGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1StandardBridgeGoerliABI,
          'bridgeETHTo'
        >['request']['abi'],
        'bridgeETHTo',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'bridgeETHTo'
      }
    : UseContractWriteConfig<
        typeof l1StandardBridgeGoerliABI,
        'bridgeETHTo',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'bridgeETHTo'
      } = {} as any
) {
  return useContractWrite<
    typeof l1StandardBridgeGoerliABI,
    'bridgeETHTo',
    TMode
  >({
    abi: l1StandardBridgeGoerliABI,
    address: l1StandardBridgeGoerliAddress[5],
    functionName: 'bridgeETHTo',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1StandardBridgeGoerliABI}__ and `functionName` set to `"depositERC20"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function useL1StandardBridgeGoerliDepositErc20<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1StandardBridgeGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1StandardBridgeGoerliABI,
          'depositERC20'
        >['request']['abi'],
        'depositERC20',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'depositERC20'
      }
    : UseContractWriteConfig<
        typeof l1StandardBridgeGoerliABI,
        'depositERC20',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'depositERC20'
      } = {} as any
) {
  return useContractWrite<
    typeof l1StandardBridgeGoerliABI,
    'depositERC20',
    TMode
  >({
    abi: l1StandardBridgeGoerliABI,
    address: l1StandardBridgeGoerliAddress[5],
    functionName: 'depositERC20',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1StandardBridgeGoerliABI}__ and `functionName` set to `"depositERC20To"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function useL1StandardBridgeGoerliDepositErc20To<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1StandardBridgeGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1StandardBridgeGoerliABI,
          'depositERC20To'
        >['request']['abi'],
        'depositERC20To',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'depositERC20To'
      }
    : UseContractWriteConfig<
        typeof l1StandardBridgeGoerliABI,
        'depositERC20To',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'depositERC20To'
      } = {} as any
) {
  return useContractWrite<
    typeof l1StandardBridgeGoerliABI,
    'depositERC20To',
    TMode
  >({
    abi: l1StandardBridgeGoerliABI,
    address: l1StandardBridgeGoerliAddress[5],
    functionName: 'depositERC20To',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1StandardBridgeGoerliABI}__ and `functionName` set to `"depositETH"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function useL1StandardBridgeGoerliDepositEth<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1StandardBridgeGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1StandardBridgeGoerliABI,
          'depositETH'
        >['request']['abi'],
        'depositETH',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'depositETH' }
    : UseContractWriteConfig<
        typeof l1StandardBridgeGoerliABI,
        'depositETH',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'depositETH'
      } = {} as any
) {
  return useContractWrite<
    typeof l1StandardBridgeGoerliABI,
    'depositETH',
    TMode
  >({
    abi: l1StandardBridgeGoerliABI,
    address: l1StandardBridgeGoerliAddress[5],
    functionName: 'depositETH',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1StandardBridgeGoerliABI}__ and `functionName` set to `"depositETHTo"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function useL1StandardBridgeGoerliDepositEthTo<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1StandardBridgeGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1StandardBridgeGoerliABI,
          'depositETHTo'
        >['request']['abi'],
        'depositETHTo',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'depositETHTo'
      }
    : UseContractWriteConfig<
        typeof l1StandardBridgeGoerliABI,
        'depositETHTo',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'depositETHTo'
      } = {} as any
) {
  return useContractWrite<
    typeof l1StandardBridgeGoerliABI,
    'depositETHTo',
    TMode
  >({
    abi: l1StandardBridgeGoerliABI,
    address: l1StandardBridgeGoerliAddress[5],
    functionName: 'depositETHTo',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1StandardBridgeGoerliABI}__ and `functionName` set to `"finalizeBridgeERC20"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function useL1StandardBridgeGoerliFinalizeBridgeErc20<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1StandardBridgeGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1StandardBridgeGoerliABI,
          'finalizeBridgeERC20'
        >['request']['abi'],
        'finalizeBridgeERC20',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'finalizeBridgeERC20'
      }
    : UseContractWriteConfig<
        typeof l1StandardBridgeGoerliABI,
        'finalizeBridgeERC20',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'finalizeBridgeERC20'
      } = {} as any
) {
  return useContractWrite<
    typeof l1StandardBridgeGoerliABI,
    'finalizeBridgeERC20',
    TMode
  >({
    abi: l1StandardBridgeGoerliABI,
    address: l1StandardBridgeGoerliAddress[5],
    functionName: 'finalizeBridgeERC20',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1StandardBridgeGoerliABI}__ and `functionName` set to `"finalizeBridgeETH"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function useL1StandardBridgeGoerliFinalizeBridgeEth<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1StandardBridgeGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1StandardBridgeGoerliABI,
          'finalizeBridgeETH'
        >['request']['abi'],
        'finalizeBridgeETH',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'finalizeBridgeETH'
      }
    : UseContractWriteConfig<
        typeof l1StandardBridgeGoerliABI,
        'finalizeBridgeETH',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'finalizeBridgeETH'
      } = {} as any
) {
  return useContractWrite<
    typeof l1StandardBridgeGoerliABI,
    'finalizeBridgeETH',
    TMode
  >({
    abi: l1StandardBridgeGoerliABI,
    address: l1StandardBridgeGoerliAddress[5],
    functionName: 'finalizeBridgeETH',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1StandardBridgeGoerliABI}__ and `functionName` set to `"finalizeERC20Withdrawal"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function useL1StandardBridgeGoerliFinalizeErc20Withdrawal<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1StandardBridgeGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1StandardBridgeGoerliABI,
          'finalizeERC20Withdrawal'
        >['request']['abi'],
        'finalizeERC20Withdrawal',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'finalizeERC20Withdrawal'
      }
    : UseContractWriteConfig<
        typeof l1StandardBridgeGoerliABI,
        'finalizeERC20Withdrawal',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'finalizeERC20Withdrawal'
      } = {} as any
) {
  return useContractWrite<
    typeof l1StandardBridgeGoerliABI,
    'finalizeERC20Withdrawal',
    TMode
  >({
    abi: l1StandardBridgeGoerliABI,
    address: l1StandardBridgeGoerliAddress[5],
    functionName: 'finalizeERC20Withdrawal',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1StandardBridgeGoerliABI}__ and `functionName` set to `"finalizeETHWithdrawal"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function useL1StandardBridgeGoerliFinalizeEthWithdrawal<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1StandardBridgeGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1StandardBridgeGoerliABI,
          'finalizeETHWithdrawal'
        >['request']['abi'],
        'finalizeETHWithdrawal',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'finalizeETHWithdrawal'
      }
    : UseContractWriteConfig<
        typeof l1StandardBridgeGoerliABI,
        'finalizeETHWithdrawal',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'finalizeETHWithdrawal'
      } = {} as any
) {
  return useContractWrite<
    typeof l1StandardBridgeGoerliABI,
    'finalizeETHWithdrawal',
    TMode
  >({
    abi: l1StandardBridgeGoerliABI,
    address: l1StandardBridgeGoerliAddress[5],
    functionName: 'finalizeETHWithdrawal',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1StandardBridgeGoerliABI}__ and `functionName` set to `"initialize"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function useL1StandardBridgeGoerliInitialize<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1StandardBridgeGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1StandardBridgeGoerliABI,
          'initialize'
        >['request']['abi'],
        'initialize',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'initialize' }
    : UseContractWriteConfig<
        typeof l1StandardBridgeGoerliABI,
        'initialize',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'initialize'
      } = {} as any
) {
  return useContractWrite<
    typeof l1StandardBridgeGoerliABI,
    'initialize',
    TMode
  >({
    abi: l1StandardBridgeGoerliABI,
    address: l1StandardBridgeGoerliAddress[5],
    functionName: 'initialize',
    ...config,
  } as any)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1StandardBridgeGoerliABI}__.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function usePrepareL1StandardBridgeGoerliWrite<
  TFunctionName extends string
>(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof l1StandardBridgeGoerliABI,
      TFunctionName
    >,
    'abi' | 'address'
  > & { chainId?: keyof typeof l1StandardBridgeGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l1StandardBridgeGoerliABI,
    address: l1StandardBridgeGoerliAddress[5],
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1StandardBridgeGoerliABI, TFunctionName>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1StandardBridgeGoerliABI}__ and `functionName` set to `"bridgeERC20"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function usePrepareL1StandardBridgeGoerliBridgeErc20(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof l1StandardBridgeGoerliABI,
      'bridgeERC20'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1StandardBridgeGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l1StandardBridgeGoerliABI,
    address: l1StandardBridgeGoerliAddress[5],
    functionName: 'bridgeERC20',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1StandardBridgeGoerliABI, 'bridgeERC20'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1StandardBridgeGoerliABI}__ and `functionName` set to `"bridgeERC20To"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function usePrepareL1StandardBridgeGoerliBridgeErc20To(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof l1StandardBridgeGoerliABI,
      'bridgeERC20To'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1StandardBridgeGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l1StandardBridgeGoerliABI,
    address: l1StandardBridgeGoerliAddress[5],
    functionName: 'bridgeERC20To',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1StandardBridgeGoerliABI, 'bridgeERC20To'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1StandardBridgeGoerliABI}__ and `functionName` set to `"bridgeETH"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function usePrepareL1StandardBridgeGoerliBridgeEth(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof l1StandardBridgeGoerliABI,
      'bridgeETH'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1StandardBridgeGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l1StandardBridgeGoerliABI,
    address: l1StandardBridgeGoerliAddress[5],
    functionName: 'bridgeETH',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1StandardBridgeGoerliABI, 'bridgeETH'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1StandardBridgeGoerliABI}__ and `functionName` set to `"bridgeETHTo"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function usePrepareL1StandardBridgeGoerliBridgeEthTo(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof l1StandardBridgeGoerliABI,
      'bridgeETHTo'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1StandardBridgeGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l1StandardBridgeGoerliABI,
    address: l1StandardBridgeGoerliAddress[5],
    functionName: 'bridgeETHTo',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1StandardBridgeGoerliABI, 'bridgeETHTo'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1StandardBridgeGoerliABI}__ and `functionName` set to `"depositERC20"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function usePrepareL1StandardBridgeGoerliDepositErc20(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof l1StandardBridgeGoerliABI,
      'depositERC20'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1StandardBridgeGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l1StandardBridgeGoerliABI,
    address: l1StandardBridgeGoerliAddress[5],
    functionName: 'depositERC20',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1StandardBridgeGoerliABI, 'depositERC20'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1StandardBridgeGoerliABI}__ and `functionName` set to `"depositERC20To"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function usePrepareL1StandardBridgeGoerliDepositErc20To(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof l1StandardBridgeGoerliABI,
      'depositERC20To'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1StandardBridgeGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l1StandardBridgeGoerliABI,
    address: l1StandardBridgeGoerliAddress[5],
    functionName: 'depositERC20To',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1StandardBridgeGoerliABI, 'depositERC20To'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1StandardBridgeGoerliABI}__ and `functionName` set to `"depositETH"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function usePrepareL1StandardBridgeGoerliDepositEth(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof l1StandardBridgeGoerliABI,
      'depositETH'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1StandardBridgeGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l1StandardBridgeGoerliABI,
    address: l1StandardBridgeGoerliAddress[5],
    functionName: 'depositETH',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1StandardBridgeGoerliABI, 'depositETH'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1StandardBridgeGoerliABI}__ and `functionName` set to `"depositETHTo"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function usePrepareL1StandardBridgeGoerliDepositEthTo(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof l1StandardBridgeGoerliABI,
      'depositETHTo'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1StandardBridgeGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l1StandardBridgeGoerliABI,
    address: l1StandardBridgeGoerliAddress[5],
    functionName: 'depositETHTo',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1StandardBridgeGoerliABI, 'depositETHTo'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1StandardBridgeGoerliABI}__ and `functionName` set to `"finalizeBridgeERC20"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function usePrepareL1StandardBridgeGoerliFinalizeBridgeErc20(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof l1StandardBridgeGoerliABI,
      'finalizeBridgeERC20'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1StandardBridgeGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l1StandardBridgeGoerliABI,
    address: l1StandardBridgeGoerliAddress[5],
    functionName: 'finalizeBridgeERC20',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1StandardBridgeGoerliABI, 'finalizeBridgeERC20'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1StandardBridgeGoerliABI}__ and `functionName` set to `"finalizeBridgeETH"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function usePrepareL1StandardBridgeGoerliFinalizeBridgeEth(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof l1StandardBridgeGoerliABI,
      'finalizeBridgeETH'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1StandardBridgeGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l1StandardBridgeGoerliABI,
    address: l1StandardBridgeGoerliAddress[5],
    functionName: 'finalizeBridgeETH',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1StandardBridgeGoerliABI, 'finalizeBridgeETH'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1StandardBridgeGoerliABI}__ and `functionName` set to `"finalizeERC20Withdrawal"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function usePrepareL1StandardBridgeGoerliFinalizeErc20Withdrawal(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof l1StandardBridgeGoerliABI,
      'finalizeERC20Withdrawal'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1StandardBridgeGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l1StandardBridgeGoerliABI,
    address: l1StandardBridgeGoerliAddress[5],
    functionName: 'finalizeERC20Withdrawal',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1StandardBridgeGoerliABI, 'finalizeERC20Withdrawal'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1StandardBridgeGoerliABI}__ and `functionName` set to `"finalizeETHWithdrawal"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function usePrepareL1StandardBridgeGoerliFinalizeEthWithdrawal(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof l1StandardBridgeGoerliABI,
      'finalizeETHWithdrawal'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1StandardBridgeGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l1StandardBridgeGoerliABI,
    address: l1StandardBridgeGoerliAddress[5],
    functionName: 'finalizeETHWithdrawal',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1StandardBridgeGoerliABI, 'finalizeETHWithdrawal'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1StandardBridgeGoerliABI}__ and `functionName` set to `"initialize"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function usePrepareL1StandardBridgeGoerliInitialize(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof l1StandardBridgeGoerliABI,
      'initialize'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1StandardBridgeGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l1StandardBridgeGoerliABI,
    address: l1StandardBridgeGoerliAddress[5],
    functionName: 'initialize',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1StandardBridgeGoerliABI, 'initialize'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1StandardBridgeGoerliABI}__.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function useL1StandardBridgeGoerliEvent<TEventName extends string>(
  config: Omit<
    UseContractEventConfig<typeof l1StandardBridgeGoerliABI, TEventName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof l1StandardBridgeGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: l1StandardBridgeGoerliABI,
    address: l1StandardBridgeGoerliAddress[5],
    ...config,
  } as UseContractEventConfig<typeof l1StandardBridgeGoerliABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1StandardBridgeGoerliABI}__ and `eventName` set to `"ERC20BridgeFinalized"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function useL1StandardBridgeGoerliErc20BridgeFinalizedEvent(
  config: Omit<
    UseContractEventConfig<
      typeof l1StandardBridgeGoerliABI,
      'ERC20BridgeFinalized'
    >,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l1StandardBridgeGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: l1StandardBridgeGoerliABI,
    address: l1StandardBridgeGoerliAddress[5],
    eventName: 'ERC20BridgeFinalized',
    ...config,
  } as UseContractEventConfig<typeof l1StandardBridgeGoerliABI, 'ERC20BridgeFinalized'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1StandardBridgeGoerliABI}__ and `eventName` set to `"ERC20BridgeInitiated"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function useL1StandardBridgeGoerliErc20BridgeInitiatedEvent(
  config: Omit<
    UseContractEventConfig<
      typeof l1StandardBridgeGoerliABI,
      'ERC20BridgeInitiated'
    >,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l1StandardBridgeGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: l1StandardBridgeGoerliABI,
    address: l1StandardBridgeGoerliAddress[5],
    eventName: 'ERC20BridgeInitiated',
    ...config,
  } as UseContractEventConfig<typeof l1StandardBridgeGoerliABI, 'ERC20BridgeInitiated'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1StandardBridgeGoerliABI}__ and `eventName` set to `"ERC20DepositInitiated"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function useL1StandardBridgeGoerliErc20DepositInitiatedEvent(
  config: Omit<
    UseContractEventConfig<
      typeof l1StandardBridgeGoerliABI,
      'ERC20DepositInitiated'
    >,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l1StandardBridgeGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: l1StandardBridgeGoerliABI,
    address: l1StandardBridgeGoerliAddress[5],
    eventName: 'ERC20DepositInitiated',
    ...config,
  } as UseContractEventConfig<typeof l1StandardBridgeGoerliABI, 'ERC20DepositInitiated'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1StandardBridgeGoerliABI}__ and `eventName` set to `"ERC20WithdrawalFinalized"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function useL1StandardBridgeGoerliErc20WithdrawalFinalizedEvent(
  config: Omit<
    UseContractEventConfig<
      typeof l1StandardBridgeGoerliABI,
      'ERC20WithdrawalFinalized'
    >,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l1StandardBridgeGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: l1StandardBridgeGoerliABI,
    address: l1StandardBridgeGoerliAddress[5],
    eventName: 'ERC20WithdrawalFinalized',
    ...config,
  } as UseContractEventConfig<typeof l1StandardBridgeGoerliABI, 'ERC20WithdrawalFinalized'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1StandardBridgeGoerliABI}__ and `eventName` set to `"ETHBridgeFinalized"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function useL1StandardBridgeGoerliEthBridgeFinalizedEvent(
  config: Omit<
    UseContractEventConfig<
      typeof l1StandardBridgeGoerliABI,
      'ETHBridgeFinalized'
    >,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l1StandardBridgeGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: l1StandardBridgeGoerliABI,
    address: l1StandardBridgeGoerliAddress[5],
    eventName: 'ETHBridgeFinalized',
    ...config,
  } as UseContractEventConfig<typeof l1StandardBridgeGoerliABI, 'ETHBridgeFinalized'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1StandardBridgeGoerliABI}__ and `eventName` set to `"ETHBridgeInitiated"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function useL1StandardBridgeGoerliEthBridgeInitiatedEvent(
  config: Omit<
    UseContractEventConfig<
      typeof l1StandardBridgeGoerliABI,
      'ETHBridgeInitiated'
    >,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l1StandardBridgeGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: l1StandardBridgeGoerliABI,
    address: l1StandardBridgeGoerliAddress[5],
    eventName: 'ETHBridgeInitiated',
    ...config,
  } as UseContractEventConfig<typeof l1StandardBridgeGoerliABI, 'ETHBridgeInitiated'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1StandardBridgeGoerliABI}__ and `eventName` set to `"ETHDepositInitiated"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function useL1StandardBridgeGoerliEthDepositInitiatedEvent(
  config: Omit<
    UseContractEventConfig<
      typeof l1StandardBridgeGoerliABI,
      'ETHDepositInitiated'
    >,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l1StandardBridgeGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: l1StandardBridgeGoerliABI,
    address: l1StandardBridgeGoerliAddress[5],
    eventName: 'ETHDepositInitiated',
    ...config,
  } as UseContractEventConfig<typeof l1StandardBridgeGoerliABI, 'ETHDepositInitiated'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1StandardBridgeGoerliABI}__ and `eventName` set to `"ETHWithdrawalFinalized"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function useL1StandardBridgeGoerliEthWithdrawalFinalizedEvent(
  config: Omit<
    UseContractEventConfig<
      typeof l1StandardBridgeGoerliABI,
      'ETHWithdrawalFinalized'
    >,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l1StandardBridgeGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: l1StandardBridgeGoerliABI,
    address: l1StandardBridgeGoerliAddress[5],
    eventName: 'ETHWithdrawalFinalized',
    ...config,
  } as UseContractEventConfig<typeof l1StandardBridgeGoerliABI, 'ETHWithdrawalFinalized'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1StandardBridgeGoerliABI}__ and `eventName` set to `"Initialized"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function useL1StandardBridgeGoerliInitializedEvent(
  config: Omit<
    UseContractEventConfig<typeof l1StandardBridgeGoerliABI, 'Initialized'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l1StandardBridgeGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: l1StandardBridgeGoerliABI,
    address: l1StandardBridgeGoerliAddress[5],
    eventName: 'Initialized',
    ...config,
  } as UseContractEventConfig<typeof l1StandardBridgeGoerliABI, 'Initialized'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function useL2CrossDomainMessengerRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<
    typeof l2CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address'
  > & { chainId?: keyof typeof l2CrossDomainMessengerAddress } = {} as any
) {
  return useContractRead({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    ...config,
  } as UseContractReadConfig<typeof l2CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__ and `functionName` set to `"MESSAGE_VERSION"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function useL2CrossDomainMessengerMessageVersion<
  TFunctionName extends 'MESSAGE_VERSION',
  TSelectData = ReadContractResult<
    typeof l2CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2CrossDomainMessengerAddress } = {} as any
) {
  return useContractRead({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    functionName: 'MESSAGE_VERSION',
    ...config,
  } as UseContractReadConfig<typeof l2CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__ and `functionName` set to `"MIN_GAS_CALLDATA_OVERHEAD"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function useL2CrossDomainMessengerMinGasCalldataOverhead<
  TFunctionName extends 'MIN_GAS_CALLDATA_OVERHEAD',
  TSelectData = ReadContractResult<
    typeof l2CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2CrossDomainMessengerAddress } = {} as any
) {
  return useContractRead({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    functionName: 'MIN_GAS_CALLDATA_OVERHEAD',
    ...config,
  } as UseContractReadConfig<typeof l2CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__ and `functionName` set to `"MIN_GAS_DYNAMIC_OVERHEAD_DENOMINATOR"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function useL2CrossDomainMessengerMinGasDynamicOverheadDenominator<
  TFunctionName extends 'MIN_GAS_DYNAMIC_OVERHEAD_DENOMINATOR',
  TSelectData = ReadContractResult<
    typeof l2CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2CrossDomainMessengerAddress } = {} as any
) {
  return useContractRead({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    functionName: 'MIN_GAS_DYNAMIC_OVERHEAD_DENOMINATOR',
    ...config,
  } as UseContractReadConfig<typeof l2CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__ and `functionName` set to `"MIN_GAS_DYNAMIC_OVERHEAD_NUMERATOR"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function useL2CrossDomainMessengerMinGasDynamicOverheadNumerator<
  TFunctionName extends 'MIN_GAS_DYNAMIC_OVERHEAD_NUMERATOR',
  TSelectData = ReadContractResult<
    typeof l2CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2CrossDomainMessengerAddress } = {} as any
) {
  return useContractRead({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    functionName: 'MIN_GAS_DYNAMIC_OVERHEAD_NUMERATOR',
    ...config,
  } as UseContractReadConfig<typeof l2CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__ and `functionName` set to `"OTHER_MESSENGER"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function useL2CrossDomainMessengerOtherMessenger<
  TFunctionName extends 'OTHER_MESSENGER',
  TSelectData = ReadContractResult<
    typeof l2CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2CrossDomainMessengerAddress } = {} as any
) {
  return useContractRead({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    functionName: 'OTHER_MESSENGER',
    ...config,
  } as UseContractReadConfig<typeof l2CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__ and `functionName` set to `"RELAY_CALL_OVERHEAD"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function useL2CrossDomainMessengerRelayCallOverhead<
  TFunctionName extends 'RELAY_CALL_OVERHEAD',
  TSelectData = ReadContractResult<
    typeof l2CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2CrossDomainMessengerAddress } = {} as any
) {
  return useContractRead({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    functionName: 'RELAY_CALL_OVERHEAD',
    ...config,
  } as UseContractReadConfig<typeof l2CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__ and `functionName` set to `"RELAY_CONSTANT_OVERHEAD"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function useL2CrossDomainMessengerRelayConstantOverhead<
  TFunctionName extends 'RELAY_CONSTANT_OVERHEAD',
  TSelectData = ReadContractResult<
    typeof l2CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2CrossDomainMessengerAddress } = {} as any
) {
  return useContractRead({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    functionName: 'RELAY_CONSTANT_OVERHEAD',
    ...config,
  } as UseContractReadConfig<typeof l2CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__ and `functionName` set to `"RELAY_GAS_CHECK_BUFFER"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function useL2CrossDomainMessengerRelayGasCheckBuffer<
  TFunctionName extends 'RELAY_GAS_CHECK_BUFFER',
  TSelectData = ReadContractResult<
    typeof l2CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2CrossDomainMessengerAddress } = {} as any
) {
  return useContractRead({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    functionName: 'RELAY_GAS_CHECK_BUFFER',
    ...config,
  } as UseContractReadConfig<typeof l2CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__ and `functionName` set to `"RELAY_RESERVED_GAS"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function useL2CrossDomainMessengerRelayReservedGas<
  TFunctionName extends 'RELAY_RESERVED_GAS',
  TSelectData = ReadContractResult<
    typeof l2CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2CrossDomainMessengerAddress } = {} as any
) {
  return useContractRead({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    functionName: 'RELAY_RESERVED_GAS',
    ...config,
  } as UseContractReadConfig<typeof l2CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__ and `functionName` set to `"baseGas"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function useL2CrossDomainMessengerBaseGas<
  TFunctionName extends 'baseGas',
  TSelectData = ReadContractResult<
    typeof l2CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2CrossDomainMessengerAddress } = {} as any
) {
  return useContractRead({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    functionName: 'baseGas',
    ...config,
  } as UseContractReadConfig<typeof l2CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__ and `functionName` set to `"failedMessages"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function useL2CrossDomainMessengerFailedMessages<
  TFunctionName extends 'failedMessages',
  TSelectData = ReadContractResult<
    typeof l2CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2CrossDomainMessengerAddress } = {} as any
) {
  return useContractRead({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    functionName: 'failedMessages',
    ...config,
  } as UseContractReadConfig<typeof l2CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__ and `functionName` set to `"l1CrossDomainMessenger"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function useL2CrossDomainMessengerL1CrossDomainMessenger<
  TFunctionName extends 'l1CrossDomainMessenger',
  TSelectData = ReadContractResult<
    typeof l2CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2CrossDomainMessengerAddress } = {} as any
) {
  return useContractRead({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    functionName: 'l1CrossDomainMessenger',
    ...config,
  } as UseContractReadConfig<typeof l2CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__ and `functionName` set to `"messageNonce"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function useL2CrossDomainMessengerMessageNonce<
  TFunctionName extends 'messageNonce',
  TSelectData = ReadContractResult<
    typeof l2CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2CrossDomainMessengerAddress } = {} as any
) {
  return useContractRead({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    functionName: 'messageNonce',
    ...config,
  } as UseContractReadConfig<typeof l2CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__ and `functionName` set to `"successfulMessages"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function useL2CrossDomainMessengerSuccessfulMessages<
  TFunctionName extends 'successfulMessages',
  TSelectData = ReadContractResult<
    typeof l2CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2CrossDomainMessengerAddress } = {} as any
) {
  return useContractRead({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    functionName: 'successfulMessages',
    ...config,
  } as UseContractReadConfig<typeof l2CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__ and `functionName` set to `"version"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function useL2CrossDomainMessengerVersion<
  TFunctionName extends 'version',
  TSelectData = ReadContractResult<
    typeof l2CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2CrossDomainMessengerAddress } = {} as any
) {
  return useContractRead({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    functionName: 'version',
    ...config,
  } as UseContractReadConfig<typeof l2CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__ and `functionName` set to `"xDomainMessageSender"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function useL2CrossDomainMessengerXDomainMessageSender<
  TFunctionName extends 'xDomainMessageSender',
  TSelectData = ReadContractResult<
    typeof l2CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2CrossDomainMessengerAddress } = {} as any
) {
  return useContractRead({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    functionName: 'xDomainMessageSender',
    ...config,
  } as UseContractReadConfig<typeof l2CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function useL2CrossDomainMessengerWrite<
  TFunctionName extends string,
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l2CrossDomainMessengerAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l2CrossDomainMessengerABI,
          string
        >['request']['abi'],
        TFunctionName,
        TMode
      > & { address?: Address; chainId?: TChainId }
    : UseContractWriteConfig<
        typeof l2CrossDomainMessengerABI,
        TFunctionName,
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
      } = {} as any
) {
  return useContractWrite<
    typeof l2CrossDomainMessengerABI,
    TFunctionName,
    TMode
  >({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__ and `functionName` set to `"initialize"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function useL2CrossDomainMessengerInitialize<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l2CrossDomainMessengerAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l2CrossDomainMessengerABI,
          'initialize'
        >['request']['abi'],
        'initialize',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'initialize' }
    : UseContractWriteConfig<
        typeof l2CrossDomainMessengerABI,
        'initialize',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'initialize'
      } = {} as any
) {
  return useContractWrite<
    typeof l2CrossDomainMessengerABI,
    'initialize',
    TMode
  >({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    functionName: 'initialize',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__ and `functionName` set to `"relayMessage"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function useL2CrossDomainMessengerRelayMessage<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l2CrossDomainMessengerAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l2CrossDomainMessengerABI,
          'relayMessage'
        >['request']['abi'],
        'relayMessage',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'relayMessage'
      }
    : UseContractWriteConfig<
        typeof l2CrossDomainMessengerABI,
        'relayMessage',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'relayMessage'
      } = {} as any
) {
  return useContractWrite<
    typeof l2CrossDomainMessengerABI,
    'relayMessage',
    TMode
  >({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    functionName: 'relayMessage',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__ and `functionName` set to `"sendMessage"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function useL2CrossDomainMessengerSendMessage<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l2CrossDomainMessengerAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l2CrossDomainMessengerABI,
          'sendMessage'
        >['request']['abi'],
        'sendMessage',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'sendMessage'
      }
    : UseContractWriteConfig<
        typeof l2CrossDomainMessengerABI,
        'sendMessage',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'sendMessage'
      } = {} as any
) {
  return useContractWrite<
    typeof l2CrossDomainMessengerABI,
    'sendMessage',
    TMode
  >({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    functionName: 'sendMessage',
    ...config,
  } as any)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function usePrepareL2CrossDomainMessengerWrite<
  TFunctionName extends string
>(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof l2CrossDomainMessengerABI,
      TFunctionName
    >,
    'abi' | 'address'
  > & { chainId?: keyof typeof l2CrossDomainMessengerAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    ...config,
  } as UsePrepareContractWriteConfig<typeof l2CrossDomainMessengerABI, TFunctionName>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__ and `functionName` set to `"initialize"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function usePrepareL2CrossDomainMessengerInitialize(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof l2CrossDomainMessengerABI,
      'initialize'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2CrossDomainMessengerAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    functionName: 'initialize',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l2CrossDomainMessengerABI, 'initialize'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__ and `functionName` set to `"relayMessage"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function usePrepareL2CrossDomainMessengerRelayMessage(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof l2CrossDomainMessengerABI,
      'relayMessage'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2CrossDomainMessengerAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    functionName: 'relayMessage',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l2CrossDomainMessengerABI, 'relayMessage'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__ and `functionName` set to `"sendMessage"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function usePrepareL2CrossDomainMessengerSendMessage(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof l2CrossDomainMessengerABI,
      'sendMessage'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2CrossDomainMessengerAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    functionName: 'sendMessage',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l2CrossDomainMessengerABI, 'sendMessage'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function useL2CrossDomainMessengerEvent<TEventName extends string>(
  config: Omit<
    UseContractEventConfig<typeof l2CrossDomainMessengerABI, TEventName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof l2CrossDomainMessengerAddress } = {} as any
) {
  return useContractEvent({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    ...config,
  } as UseContractEventConfig<typeof l2CrossDomainMessengerABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__ and `eventName` set to `"FailedRelayedMessage"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function useL2CrossDomainMessengerFailedRelayedMessageEvent(
  config: Omit<
    UseContractEventConfig<
      typeof l2CrossDomainMessengerABI,
      'FailedRelayedMessage'
    >,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l2CrossDomainMessengerAddress } = {} as any
) {
  return useContractEvent({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    eventName: 'FailedRelayedMessage',
    ...config,
  } as UseContractEventConfig<typeof l2CrossDomainMessengerABI, 'FailedRelayedMessage'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__ and `eventName` set to `"Initialized"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function useL2CrossDomainMessengerInitializedEvent(
  config: Omit<
    UseContractEventConfig<typeof l2CrossDomainMessengerABI, 'Initialized'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l2CrossDomainMessengerAddress } = {} as any
) {
  return useContractEvent({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    eventName: 'Initialized',
    ...config,
  } as UseContractEventConfig<typeof l2CrossDomainMessengerABI, 'Initialized'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__ and `eventName` set to `"RelayedMessage"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function useL2CrossDomainMessengerRelayedMessageEvent(
  config: Omit<
    UseContractEventConfig<typeof l2CrossDomainMessengerABI, 'RelayedMessage'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l2CrossDomainMessengerAddress } = {} as any
) {
  return useContractEvent({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    eventName: 'RelayedMessage',
    ...config,
  } as UseContractEventConfig<typeof l2CrossDomainMessengerABI, 'RelayedMessage'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__ and `eventName` set to `"SentMessage"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function useL2CrossDomainMessengerSentMessageEvent(
  config: Omit<
    UseContractEventConfig<typeof l2CrossDomainMessengerABI, 'SentMessage'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l2CrossDomainMessengerAddress } = {} as any
) {
  return useContractEvent({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    eventName: 'SentMessage',
    ...config,
  } as UseContractEventConfig<typeof l2CrossDomainMessengerABI, 'SentMessage'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__ and `eventName` set to `"SentMessageExtension1"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function useL2CrossDomainMessengerSentMessageExtension1Event(
  config: Omit<
    UseContractEventConfig<
      typeof l2CrossDomainMessengerABI,
      'SentMessageExtension1'
    >,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l2CrossDomainMessengerAddress } = {} as any
) {
  return useContractEvent({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    eventName: 'SentMessageExtension1',
    ...config,
  } as UseContractEventConfig<typeof l2CrossDomainMessengerABI, 'SentMessageExtension1'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2Erc721BridgeABI}__.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000014)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000014)
 */
export function useL2Erc721BridgeRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<typeof l2Erc721BridgeABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l2Erc721BridgeABI, TFunctionName, TSelectData>,
    'abi' | 'address'
  > & { chainId?: keyof typeof l2Erc721BridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractRead({
    abi: l2Erc721BridgeABI,
    address:
      l2Erc721BridgeAddress[chainId as keyof typeof l2Erc721BridgeAddress],
    ...config,
  } as UseContractReadConfig<typeof l2Erc721BridgeABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2Erc721BridgeABI}__ and `functionName` set to `"messenger"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000014)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000014)
 */
export function useL2Erc721BridgeMessenger<
  TFunctionName extends 'messenger',
  TSelectData = ReadContractResult<typeof l2Erc721BridgeABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l2Erc721BridgeABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2Erc721BridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractRead({
    abi: l2Erc721BridgeABI,
    address:
      l2Erc721BridgeAddress[chainId as keyof typeof l2Erc721BridgeAddress],
    functionName: 'messenger',
    ...config,
  } as UseContractReadConfig<typeof l2Erc721BridgeABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2Erc721BridgeABI}__ and `functionName` set to `"otherBridge"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000014)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000014)
 */
export function useL2Erc721BridgeOtherBridge<
  TFunctionName extends 'otherBridge',
  TSelectData = ReadContractResult<typeof l2Erc721BridgeABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l2Erc721BridgeABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2Erc721BridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractRead({
    abi: l2Erc721BridgeABI,
    address:
      l2Erc721BridgeAddress[chainId as keyof typeof l2Erc721BridgeAddress],
    functionName: 'otherBridge',
    ...config,
  } as UseContractReadConfig<typeof l2Erc721BridgeABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2Erc721BridgeABI}__ and `functionName` set to `"version"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000014)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000014)
 */
export function useL2Erc721BridgeVersion<
  TFunctionName extends 'version',
  TSelectData = ReadContractResult<typeof l2Erc721BridgeABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l2Erc721BridgeABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2Erc721BridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractRead({
    abi: l2Erc721BridgeABI,
    address:
      l2Erc721BridgeAddress[chainId as keyof typeof l2Erc721BridgeAddress],
    functionName: 'version',
    ...config,
  } as UseContractReadConfig<typeof l2Erc721BridgeABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l2Erc721BridgeABI}__.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000014)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000014)
 */
export function useL2Erc721BridgeWrite<
  TFunctionName extends string,
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l2Erc721BridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l2Erc721BridgeABI,
          string
        >['request']['abi'],
        TFunctionName,
        TMode
      > & { address?: Address; chainId?: TChainId }
    : UseContractWriteConfig<typeof l2Erc721BridgeABI, TFunctionName, TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
      } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractWrite<typeof l2Erc721BridgeABI, TFunctionName, TMode>({
    abi: l2Erc721BridgeABI,
    address:
      l2Erc721BridgeAddress[chainId as keyof typeof l2Erc721BridgeAddress],
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l2Erc721BridgeABI}__ and `functionName` set to `"bridgeERC721"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000014)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000014)
 */
export function useL2Erc721BridgeBridgeErc721<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l2Erc721BridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l2Erc721BridgeABI,
          'bridgeERC721'
        >['request']['abi'],
        'bridgeERC721',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'bridgeERC721'
      }
    : UseContractWriteConfig<
        typeof l2Erc721BridgeABI,
        'bridgeERC721',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'bridgeERC721'
      } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractWrite<typeof l2Erc721BridgeABI, 'bridgeERC721', TMode>({
    abi: l2Erc721BridgeABI,
    address:
      l2Erc721BridgeAddress[chainId as keyof typeof l2Erc721BridgeAddress],
    functionName: 'bridgeERC721',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l2Erc721BridgeABI}__ and `functionName` set to `"bridgeERC721To"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000014)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000014)
 */
export function useL2Erc721BridgeBridgeErc721To<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l2Erc721BridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l2Erc721BridgeABI,
          'bridgeERC721To'
        >['request']['abi'],
        'bridgeERC721To',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'bridgeERC721To'
      }
    : UseContractWriteConfig<
        typeof l2Erc721BridgeABI,
        'bridgeERC721To',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'bridgeERC721To'
      } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractWrite<typeof l2Erc721BridgeABI, 'bridgeERC721To', TMode>({
    abi: l2Erc721BridgeABI,
    address:
      l2Erc721BridgeAddress[chainId as keyof typeof l2Erc721BridgeAddress],
    functionName: 'bridgeERC721To',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l2Erc721BridgeABI}__ and `functionName` set to `"finalizeBridgeERC721"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000014)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000014)
 */
export function useL2Erc721BridgeFinalizeBridgeErc721<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l2Erc721BridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l2Erc721BridgeABI,
          'finalizeBridgeERC721'
        >['request']['abi'],
        'finalizeBridgeERC721',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'finalizeBridgeERC721'
      }
    : UseContractWriteConfig<
        typeof l2Erc721BridgeABI,
        'finalizeBridgeERC721',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'finalizeBridgeERC721'
      } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractWrite<
    typeof l2Erc721BridgeABI,
    'finalizeBridgeERC721',
    TMode
  >({
    abi: l2Erc721BridgeABI,
    address:
      l2Erc721BridgeAddress[chainId as keyof typeof l2Erc721BridgeAddress],
    functionName: 'finalizeBridgeERC721',
    ...config,
  } as any)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l2Erc721BridgeABI}__.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000014)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000014)
 */
export function usePrepareL2Erc721BridgeWrite<TFunctionName extends string>(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l2Erc721BridgeABI, TFunctionName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof l2Erc721BridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return usePrepareContractWrite({
    abi: l2Erc721BridgeABI,
    address:
      l2Erc721BridgeAddress[chainId as keyof typeof l2Erc721BridgeAddress],
    ...config,
  } as UsePrepareContractWriteConfig<typeof l2Erc721BridgeABI, TFunctionName>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l2Erc721BridgeABI}__ and `functionName` set to `"bridgeERC721"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000014)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000014)
 */
export function usePrepareL2Erc721BridgeBridgeErc721(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l2Erc721BridgeABI, 'bridgeERC721'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2Erc721BridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return usePrepareContractWrite({
    abi: l2Erc721BridgeABI,
    address:
      l2Erc721BridgeAddress[chainId as keyof typeof l2Erc721BridgeAddress],
    functionName: 'bridgeERC721',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l2Erc721BridgeABI, 'bridgeERC721'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l2Erc721BridgeABI}__ and `functionName` set to `"bridgeERC721To"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000014)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000014)
 */
export function usePrepareL2Erc721BridgeBridgeErc721To(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l2Erc721BridgeABI, 'bridgeERC721To'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2Erc721BridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return usePrepareContractWrite({
    abi: l2Erc721BridgeABI,
    address:
      l2Erc721BridgeAddress[chainId as keyof typeof l2Erc721BridgeAddress],
    functionName: 'bridgeERC721To',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l2Erc721BridgeABI, 'bridgeERC721To'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l2Erc721BridgeABI}__ and `functionName` set to `"finalizeBridgeERC721"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000014)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000014)
 */
export function usePrepareL2Erc721BridgeFinalizeBridgeErc721(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof l2Erc721BridgeABI,
      'finalizeBridgeERC721'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2Erc721BridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return usePrepareContractWrite({
    abi: l2Erc721BridgeABI,
    address:
      l2Erc721BridgeAddress[chainId as keyof typeof l2Erc721BridgeAddress],
    functionName: 'finalizeBridgeERC721',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l2Erc721BridgeABI, 'finalizeBridgeERC721'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l2Erc721BridgeABI}__.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000014)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000014)
 */
export function useL2Erc721BridgeEvent<TEventName extends string>(
  config: Omit<
    UseContractEventConfig<typeof l2Erc721BridgeABI, TEventName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof l2Erc721BridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractEvent({
    abi: l2Erc721BridgeABI,
    address:
      l2Erc721BridgeAddress[chainId as keyof typeof l2Erc721BridgeAddress],
    ...config,
  } as UseContractEventConfig<typeof l2Erc721BridgeABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l2Erc721BridgeABI}__ and `eventName` set to `"ERC721BridgeFinalized"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000014)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000014)
 */
export function useL2Erc721BridgeErc721BridgeFinalizedEvent(
  config: Omit<
    UseContractEventConfig<typeof l2Erc721BridgeABI, 'ERC721BridgeFinalized'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l2Erc721BridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractEvent({
    abi: l2Erc721BridgeABI,
    address:
      l2Erc721BridgeAddress[chainId as keyof typeof l2Erc721BridgeAddress],
    eventName: 'ERC721BridgeFinalized',
    ...config,
  } as UseContractEventConfig<typeof l2Erc721BridgeABI, 'ERC721BridgeFinalized'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l2Erc721BridgeABI}__ and `eventName` set to `"ERC721BridgeInitiated"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000014)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000014)
 */
export function useL2Erc721BridgeErc721BridgeInitiatedEvent(
  config: Omit<
    UseContractEventConfig<typeof l2Erc721BridgeABI, 'ERC721BridgeInitiated'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l2Erc721BridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractEvent({
    abi: l2Erc721BridgeABI,
    address:
      l2Erc721BridgeAddress[chainId as keyof typeof l2Erc721BridgeAddress],
    eventName: 'ERC721BridgeInitiated',
    ...config,
  } as UseContractEventConfig<typeof l2Erc721BridgeABI, 'ERC721BridgeInitiated'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2OutputOracleABI}__.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 */
export function useL2OutputOracleRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<typeof l2OutputOracleABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>,
    'abi' | 'address'
  > & { chainId?: keyof typeof l2OutputOracleAddress } = {} as any
) {
  return useContractRead({
    abi: l2OutputOracleABI,
    address: l2OutputOracleAddress[1],
    ...config,
  } as UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2OutputOracleABI}__ and `functionName` set to `"CHALLENGER"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 */
export function useL2OutputOracleChallenger<
  TFunctionName extends 'CHALLENGER',
  TSelectData = ReadContractResult<typeof l2OutputOracleABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2OutputOracleAddress } = {} as any
) {
  return useContractRead({
    abi: l2OutputOracleABI,
    address: l2OutputOracleAddress[1],
    functionName: 'CHALLENGER',
    ...config,
  } as UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2OutputOracleABI}__ and `functionName` set to `"FINALIZATION_PERIOD_SECONDS"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 */
export function useL2OutputOracleFinalizationPeriodSeconds<
  TFunctionName extends 'FINALIZATION_PERIOD_SECONDS',
  TSelectData = ReadContractResult<typeof l2OutputOracleABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2OutputOracleAddress } = {} as any
) {
  return useContractRead({
    abi: l2OutputOracleABI,
    address: l2OutputOracleAddress[1],
    functionName: 'FINALIZATION_PERIOD_SECONDS',
    ...config,
  } as UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2OutputOracleABI}__ and `functionName` set to `"L2_BLOCK_TIME"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 */
export function useL2OutputOracleL2BlockTime<
  TFunctionName extends 'L2_BLOCK_TIME',
  TSelectData = ReadContractResult<typeof l2OutputOracleABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2OutputOracleAddress } = {} as any
) {
  return useContractRead({
    abi: l2OutputOracleABI,
    address: l2OutputOracleAddress[1],
    functionName: 'L2_BLOCK_TIME',
    ...config,
  } as UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2OutputOracleABI}__ and `functionName` set to `"PROPOSER"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 */
export function useL2OutputOracleProposer<
  TFunctionName extends 'PROPOSER',
  TSelectData = ReadContractResult<typeof l2OutputOracleABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2OutputOracleAddress } = {} as any
) {
  return useContractRead({
    abi: l2OutputOracleABI,
    address: l2OutputOracleAddress[1],
    functionName: 'PROPOSER',
    ...config,
  } as UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2OutputOracleABI}__ and `functionName` set to `"SUBMISSION_INTERVAL"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 */
export function useL2OutputOracleSubmissionInterval<
  TFunctionName extends 'SUBMISSION_INTERVAL',
  TSelectData = ReadContractResult<typeof l2OutputOracleABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2OutputOracleAddress } = {} as any
) {
  return useContractRead({
    abi: l2OutputOracleABI,
    address: l2OutputOracleAddress[1],
    functionName: 'SUBMISSION_INTERVAL',
    ...config,
  } as UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2OutputOracleABI}__ and `functionName` set to `"computeL2Timestamp"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 */
export function useL2OutputOracleComputeL2Timestamp<
  TFunctionName extends 'computeL2Timestamp',
  TSelectData = ReadContractResult<typeof l2OutputOracleABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2OutputOracleAddress } = {} as any
) {
  return useContractRead({
    abi: l2OutputOracleABI,
    address: l2OutputOracleAddress[1],
    functionName: 'computeL2Timestamp',
    ...config,
  } as UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2OutputOracleABI}__ and `functionName` set to `"getL2Output"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 */
export function useL2OutputOracleGetL2Output<
  TFunctionName extends 'getL2Output',
  TSelectData = ReadContractResult<typeof l2OutputOracleABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2OutputOracleAddress } = {} as any
) {
  return useContractRead({
    abi: l2OutputOracleABI,
    address: l2OutputOracleAddress[1],
    functionName: 'getL2Output',
    ...config,
  } as UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2OutputOracleABI}__ and `functionName` set to `"getL2OutputAfter"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 */
export function useL2OutputOracleGetL2OutputAfter<
  TFunctionName extends 'getL2OutputAfter',
  TSelectData = ReadContractResult<typeof l2OutputOracleABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2OutputOracleAddress } = {} as any
) {
  return useContractRead({
    abi: l2OutputOracleABI,
    address: l2OutputOracleAddress[1],
    functionName: 'getL2OutputAfter',
    ...config,
  } as UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2OutputOracleABI}__ and `functionName` set to `"getL2OutputIndexAfter"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 */
export function useL2OutputOracleGetL2OutputIndexAfter<
  TFunctionName extends 'getL2OutputIndexAfter',
  TSelectData = ReadContractResult<typeof l2OutputOracleABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2OutputOracleAddress } = {} as any
) {
  return useContractRead({
    abi: l2OutputOracleABI,
    address: l2OutputOracleAddress[1],
    functionName: 'getL2OutputIndexAfter',
    ...config,
  } as UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2OutputOracleABI}__ and `functionName` set to `"latestBlockNumber"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 */
export function useL2OutputOracleLatestBlockNumber<
  TFunctionName extends 'latestBlockNumber',
  TSelectData = ReadContractResult<typeof l2OutputOracleABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2OutputOracleAddress } = {} as any
) {
  return useContractRead({
    abi: l2OutputOracleABI,
    address: l2OutputOracleAddress[1],
    functionName: 'latestBlockNumber',
    ...config,
  } as UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2OutputOracleABI}__ and `functionName` set to `"latestOutputIndex"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 */
export function useL2OutputOracleLatestOutputIndex<
  TFunctionName extends 'latestOutputIndex',
  TSelectData = ReadContractResult<typeof l2OutputOracleABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2OutputOracleAddress } = {} as any
) {
  return useContractRead({
    abi: l2OutputOracleABI,
    address: l2OutputOracleAddress[1],
    functionName: 'latestOutputIndex',
    ...config,
  } as UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2OutputOracleABI}__ and `functionName` set to `"nextBlockNumber"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 */
export function useL2OutputOracleNextBlockNumber<
  TFunctionName extends 'nextBlockNumber',
  TSelectData = ReadContractResult<typeof l2OutputOracleABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2OutputOracleAddress } = {} as any
) {
  return useContractRead({
    abi: l2OutputOracleABI,
    address: l2OutputOracleAddress[1],
    functionName: 'nextBlockNumber',
    ...config,
  } as UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2OutputOracleABI}__ and `functionName` set to `"nextOutputIndex"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 */
export function useL2OutputOracleNextOutputIndex<
  TFunctionName extends 'nextOutputIndex',
  TSelectData = ReadContractResult<typeof l2OutputOracleABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2OutputOracleAddress } = {} as any
) {
  return useContractRead({
    abi: l2OutputOracleABI,
    address: l2OutputOracleAddress[1],
    functionName: 'nextOutputIndex',
    ...config,
  } as UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2OutputOracleABI}__ and `functionName` set to `"startingBlockNumber"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 */
export function useL2OutputOracleStartingBlockNumber<
  TFunctionName extends 'startingBlockNumber',
  TSelectData = ReadContractResult<typeof l2OutputOracleABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2OutputOracleAddress } = {} as any
) {
  return useContractRead({
    abi: l2OutputOracleABI,
    address: l2OutputOracleAddress[1],
    functionName: 'startingBlockNumber',
    ...config,
  } as UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2OutputOracleABI}__ and `functionName` set to `"startingTimestamp"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 */
export function useL2OutputOracleStartingTimestamp<
  TFunctionName extends 'startingTimestamp',
  TSelectData = ReadContractResult<typeof l2OutputOracleABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2OutputOracleAddress } = {} as any
) {
  return useContractRead({
    abi: l2OutputOracleABI,
    address: l2OutputOracleAddress[1],
    functionName: 'startingTimestamp',
    ...config,
  } as UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2OutputOracleABI}__ and `functionName` set to `"version"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 */
export function useL2OutputOracleVersion<
  TFunctionName extends 'version',
  TSelectData = ReadContractResult<typeof l2OutputOracleABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2OutputOracleAddress } = {} as any
) {
  return useContractRead({
    abi: l2OutputOracleABI,
    address: l2OutputOracleAddress[1],
    functionName: 'version',
    ...config,
  } as UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l2OutputOracleABI}__.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 */
export function useL2OutputOracleWrite<
  TFunctionName extends string,
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l2OutputOracleAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l2OutputOracleABI,
          string
        >['request']['abi'],
        TFunctionName,
        TMode
      > & { address?: Address; chainId?: TChainId }
    : UseContractWriteConfig<typeof l2OutputOracleABI, TFunctionName, TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
      } = {} as any
) {
  return useContractWrite<typeof l2OutputOracleABI, TFunctionName, TMode>({
    abi: l2OutputOracleABI,
    address: l2OutputOracleAddress[1],
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l2OutputOracleABI}__ and `functionName` set to `"deleteL2Outputs"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 */
export function useL2OutputOracleDeleteL2Outputs<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l2OutputOracleAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l2OutputOracleABI,
          'deleteL2Outputs'
        >['request']['abi'],
        'deleteL2Outputs',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'deleteL2Outputs'
      }
    : UseContractWriteConfig<
        typeof l2OutputOracleABI,
        'deleteL2Outputs',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'deleteL2Outputs'
      } = {} as any
) {
  return useContractWrite<typeof l2OutputOracleABI, 'deleteL2Outputs', TMode>({
    abi: l2OutputOracleABI,
    address: l2OutputOracleAddress[1],
    functionName: 'deleteL2Outputs',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l2OutputOracleABI}__ and `functionName` set to `"initialize"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 */
export function useL2OutputOracleInitialize<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l2OutputOracleAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l2OutputOracleABI,
          'initialize'
        >['request']['abi'],
        'initialize',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'initialize' }
    : UseContractWriteConfig<typeof l2OutputOracleABI, 'initialize', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'initialize'
      } = {} as any
) {
  return useContractWrite<typeof l2OutputOracleABI, 'initialize', TMode>({
    abi: l2OutputOracleABI,
    address: l2OutputOracleAddress[1],
    functionName: 'initialize',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l2OutputOracleABI}__ and `functionName` set to `"proposeL2Output"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 */
export function useL2OutputOracleProposeL2Output<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l2OutputOracleAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l2OutputOracleABI,
          'proposeL2Output'
        >['request']['abi'],
        'proposeL2Output',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'proposeL2Output'
      }
    : UseContractWriteConfig<
        typeof l2OutputOracleABI,
        'proposeL2Output',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'proposeL2Output'
      } = {} as any
) {
  return useContractWrite<typeof l2OutputOracleABI, 'proposeL2Output', TMode>({
    abi: l2OutputOracleABI,
    address: l2OutputOracleAddress[1],
    functionName: 'proposeL2Output',
    ...config,
  } as any)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l2OutputOracleABI}__.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 */
export function usePrepareL2OutputOracleWrite<TFunctionName extends string>(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l2OutputOracleABI, TFunctionName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof l2OutputOracleAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l2OutputOracleABI,
    address: l2OutputOracleAddress[1],
    ...config,
  } as UsePrepareContractWriteConfig<typeof l2OutputOracleABI, TFunctionName>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l2OutputOracleABI}__ and `functionName` set to `"deleteL2Outputs"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 */
export function usePrepareL2OutputOracleDeleteL2Outputs(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l2OutputOracleABI, 'deleteL2Outputs'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2OutputOracleAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l2OutputOracleABI,
    address: l2OutputOracleAddress[1],
    functionName: 'deleteL2Outputs',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l2OutputOracleABI, 'deleteL2Outputs'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l2OutputOracleABI}__ and `functionName` set to `"initialize"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 */
export function usePrepareL2OutputOracleInitialize(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l2OutputOracleABI, 'initialize'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2OutputOracleAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l2OutputOracleABI,
    address: l2OutputOracleAddress[1],
    functionName: 'initialize',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l2OutputOracleABI, 'initialize'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l2OutputOracleABI}__ and `functionName` set to `"proposeL2Output"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 */
export function usePrepareL2OutputOracleProposeL2Output(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l2OutputOracleABI, 'proposeL2Output'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2OutputOracleAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l2OutputOracleABI,
    address: l2OutputOracleAddress[1],
    functionName: 'proposeL2Output',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l2OutputOracleABI, 'proposeL2Output'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l2OutputOracleABI}__.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 */
export function useL2OutputOracleEvent<TEventName extends string>(
  config: Omit<
    UseContractEventConfig<typeof l2OutputOracleABI, TEventName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof l2OutputOracleAddress } = {} as any
) {
  return useContractEvent({
    abi: l2OutputOracleABI,
    address: l2OutputOracleAddress[1],
    ...config,
  } as UseContractEventConfig<typeof l2OutputOracleABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l2OutputOracleABI}__ and `eventName` set to `"Initialized"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 */
export function useL2OutputOracleInitializedEvent(
  config: Omit<
    UseContractEventConfig<typeof l2OutputOracleABI, 'Initialized'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l2OutputOracleAddress } = {} as any
) {
  return useContractEvent({
    abi: l2OutputOracleABI,
    address: l2OutputOracleAddress[1],
    eventName: 'Initialized',
    ...config,
  } as UseContractEventConfig<typeof l2OutputOracleABI, 'Initialized'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l2OutputOracleABI}__ and `eventName` set to `"OutputProposed"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 */
export function useL2OutputOracleOutputProposedEvent(
  config: Omit<
    UseContractEventConfig<typeof l2OutputOracleABI, 'OutputProposed'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l2OutputOracleAddress } = {} as any
) {
  return useContractEvent({
    abi: l2OutputOracleABI,
    address: l2OutputOracleAddress[1],
    eventName: 'OutputProposed',
    ...config,
  } as UseContractEventConfig<typeof l2OutputOracleABI, 'OutputProposed'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l2OutputOracleABI}__ and `eventName` set to `"OutputsDeleted"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 */
export function useL2OutputOracleOutputsDeletedEvent(
  config: Omit<
    UseContractEventConfig<typeof l2OutputOracleABI, 'OutputsDeleted'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l2OutputOracleAddress } = {} as any
) {
  return useContractEvent({
    abi: l2OutputOracleABI,
    address: l2OutputOracleAddress[1],
    eventName: 'OutputsDeleted',
    ...config,
  } as UseContractEventConfig<typeof l2OutputOracleABI, 'OutputsDeleted'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2OutputOracleGoerliABI}__.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export function useL2OutputOracleGoerliRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<
    typeof l2OutputOracleGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2OutputOracleGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address'
  > & { chainId?: keyof typeof l2OutputOracleGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: l2OutputOracleGoerliABI,
    address: l2OutputOracleGoerliAddress[5],
    ...config,
  } as UseContractReadConfig<typeof l2OutputOracleGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2OutputOracleGoerliABI}__ and `functionName` set to `"challenger"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export function useL2OutputOracleGoerliChallenger<
  TFunctionName extends 'challenger',
  TSelectData = ReadContractResult<
    typeof l2OutputOracleGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2OutputOracleGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2OutputOracleGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: l2OutputOracleGoerliABI,
    address: l2OutputOracleGoerliAddress[5],
    functionName: 'challenger',
    ...config,
  } as UseContractReadConfig<typeof l2OutputOracleGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2OutputOracleGoerliABI}__ and `functionName` set to `"computeL2Timestamp"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export function useL2OutputOracleGoerliComputeL2Timestamp<
  TFunctionName extends 'computeL2Timestamp',
  TSelectData = ReadContractResult<
    typeof l2OutputOracleGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2OutputOracleGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2OutputOracleGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: l2OutputOracleGoerliABI,
    address: l2OutputOracleGoerliAddress[5],
    functionName: 'computeL2Timestamp',
    ...config,
  } as UseContractReadConfig<typeof l2OutputOracleGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2OutputOracleGoerliABI}__ and `functionName` set to `"finalizationPeriodSeconds"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export function useL2OutputOracleGoerliFinalizationPeriodSeconds<
  TFunctionName extends 'finalizationPeriodSeconds',
  TSelectData = ReadContractResult<
    typeof l2OutputOracleGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2OutputOracleGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2OutputOracleGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: l2OutputOracleGoerliABI,
    address: l2OutputOracleGoerliAddress[5],
    functionName: 'finalizationPeriodSeconds',
    ...config,
  } as UseContractReadConfig<typeof l2OutputOracleGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2OutputOracleGoerliABI}__ and `functionName` set to `"getL2Output"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export function useL2OutputOracleGoerliGetL2Output<
  TFunctionName extends 'getL2Output',
  TSelectData = ReadContractResult<
    typeof l2OutputOracleGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2OutputOracleGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2OutputOracleGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: l2OutputOracleGoerliABI,
    address: l2OutputOracleGoerliAddress[5],
    functionName: 'getL2Output',
    ...config,
  } as UseContractReadConfig<typeof l2OutputOracleGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2OutputOracleGoerliABI}__ and `functionName` set to `"getL2OutputAfter"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export function useL2OutputOracleGoerliGetL2OutputAfter<
  TFunctionName extends 'getL2OutputAfter',
  TSelectData = ReadContractResult<
    typeof l2OutputOracleGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2OutputOracleGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2OutputOracleGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: l2OutputOracleGoerliABI,
    address: l2OutputOracleGoerliAddress[5],
    functionName: 'getL2OutputAfter',
    ...config,
  } as UseContractReadConfig<typeof l2OutputOracleGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2OutputOracleGoerliABI}__ and `functionName` set to `"getL2OutputIndexAfter"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export function useL2OutputOracleGoerliGetL2OutputIndexAfter<
  TFunctionName extends 'getL2OutputIndexAfter',
  TSelectData = ReadContractResult<
    typeof l2OutputOracleGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2OutputOracleGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2OutputOracleGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: l2OutputOracleGoerliABI,
    address: l2OutputOracleGoerliAddress[5],
    functionName: 'getL2OutputIndexAfter',
    ...config,
  } as UseContractReadConfig<typeof l2OutputOracleGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2OutputOracleGoerliABI}__ and `functionName` set to `"l2BlockTime"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export function useL2OutputOracleGoerliL2BlockTime<
  TFunctionName extends 'l2BlockTime',
  TSelectData = ReadContractResult<
    typeof l2OutputOracleGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2OutputOracleGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2OutputOracleGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: l2OutputOracleGoerliABI,
    address: l2OutputOracleGoerliAddress[5],
    functionName: 'l2BlockTime',
    ...config,
  } as UseContractReadConfig<typeof l2OutputOracleGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2OutputOracleGoerliABI}__ and `functionName` set to `"latestBlockNumber"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export function useL2OutputOracleGoerliLatestBlockNumber<
  TFunctionName extends 'latestBlockNumber',
  TSelectData = ReadContractResult<
    typeof l2OutputOracleGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2OutputOracleGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2OutputOracleGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: l2OutputOracleGoerliABI,
    address: l2OutputOracleGoerliAddress[5],
    functionName: 'latestBlockNumber',
    ...config,
  } as UseContractReadConfig<typeof l2OutputOracleGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2OutputOracleGoerliABI}__ and `functionName` set to `"latestOutputIndex"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export function useL2OutputOracleGoerliLatestOutputIndex<
  TFunctionName extends 'latestOutputIndex',
  TSelectData = ReadContractResult<
    typeof l2OutputOracleGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2OutputOracleGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2OutputOracleGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: l2OutputOracleGoerliABI,
    address: l2OutputOracleGoerliAddress[5],
    functionName: 'latestOutputIndex',
    ...config,
  } as UseContractReadConfig<typeof l2OutputOracleGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2OutputOracleGoerliABI}__ and `functionName` set to `"nextBlockNumber"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export function useL2OutputOracleGoerliNextBlockNumber<
  TFunctionName extends 'nextBlockNumber',
  TSelectData = ReadContractResult<
    typeof l2OutputOracleGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2OutputOracleGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2OutputOracleGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: l2OutputOracleGoerliABI,
    address: l2OutputOracleGoerliAddress[5],
    functionName: 'nextBlockNumber',
    ...config,
  } as UseContractReadConfig<typeof l2OutputOracleGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2OutputOracleGoerliABI}__ and `functionName` set to `"nextOutputIndex"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export function useL2OutputOracleGoerliNextOutputIndex<
  TFunctionName extends 'nextOutputIndex',
  TSelectData = ReadContractResult<
    typeof l2OutputOracleGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2OutputOracleGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2OutputOracleGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: l2OutputOracleGoerliABI,
    address: l2OutputOracleGoerliAddress[5],
    functionName: 'nextOutputIndex',
    ...config,
  } as UseContractReadConfig<typeof l2OutputOracleGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2OutputOracleGoerliABI}__ and `functionName` set to `"proposer"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export function useL2OutputOracleGoerliProposer<
  TFunctionName extends 'proposer',
  TSelectData = ReadContractResult<
    typeof l2OutputOracleGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2OutputOracleGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2OutputOracleGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: l2OutputOracleGoerliABI,
    address: l2OutputOracleGoerliAddress[5],
    functionName: 'proposer',
    ...config,
  } as UseContractReadConfig<typeof l2OutputOracleGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2OutputOracleGoerliABI}__ and `functionName` set to `"startingBlockNumber"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export function useL2OutputOracleGoerliStartingBlockNumber<
  TFunctionName extends 'startingBlockNumber',
  TSelectData = ReadContractResult<
    typeof l2OutputOracleGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2OutputOracleGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2OutputOracleGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: l2OutputOracleGoerliABI,
    address: l2OutputOracleGoerliAddress[5],
    functionName: 'startingBlockNumber',
    ...config,
  } as UseContractReadConfig<typeof l2OutputOracleGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2OutputOracleGoerliABI}__ and `functionName` set to `"startingTimestamp"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export function useL2OutputOracleGoerliStartingTimestamp<
  TFunctionName extends 'startingTimestamp',
  TSelectData = ReadContractResult<
    typeof l2OutputOracleGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2OutputOracleGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2OutputOracleGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: l2OutputOracleGoerliABI,
    address: l2OutputOracleGoerliAddress[5],
    functionName: 'startingTimestamp',
    ...config,
  } as UseContractReadConfig<typeof l2OutputOracleGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2OutputOracleGoerliABI}__ and `functionName` set to `"submissionInterval"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export function useL2OutputOracleGoerliSubmissionInterval<
  TFunctionName extends 'submissionInterval',
  TSelectData = ReadContractResult<
    typeof l2OutputOracleGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2OutputOracleGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2OutputOracleGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: l2OutputOracleGoerliABI,
    address: l2OutputOracleGoerliAddress[5],
    functionName: 'submissionInterval',
    ...config,
  } as UseContractReadConfig<typeof l2OutputOracleGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2OutputOracleGoerliABI}__ and `functionName` set to `"version"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export function useL2OutputOracleGoerliVersion<
  TFunctionName extends 'version',
  TSelectData = ReadContractResult<
    typeof l2OutputOracleGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2OutputOracleGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2OutputOracleGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: l2OutputOracleGoerliABI,
    address: l2OutputOracleGoerliAddress[5],
    functionName: 'version',
    ...config,
  } as UseContractReadConfig<typeof l2OutputOracleGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l2OutputOracleGoerliABI}__.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export function useL2OutputOracleGoerliWrite<
  TFunctionName extends string,
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l2OutputOracleGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l2OutputOracleGoerliABI,
          string
        >['request']['abi'],
        TFunctionName,
        TMode
      > & { address?: Address; chainId?: TChainId }
    : UseContractWriteConfig<
        typeof l2OutputOracleGoerliABI,
        TFunctionName,
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
      } = {} as any
) {
  return useContractWrite<typeof l2OutputOracleGoerliABI, TFunctionName, TMode>(
    {
      abi: l2OutputOracleGoerliABI,
      address: l2OutputOracleGoerliAddress[5],
      ...config,
    } as any
  )
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l2OutputOracleGoerliABI}__ and `functionName` set to `"deleteL2Outputs"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export function useL2OutputOracleGoerliDeleteL2Outputs<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l2OutputOracleGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l2OutputOracleGoerliABI,
          'deleteL2Outputs'
        >['request']['abi'],
        'deleteL2Outputs',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'deleteL2Outputs'
      }
    : UseContractWriteConfig<
        typeof l2OutputOracleGoerliABI,
        'deleteL2Outputs',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'deleteL2Outputs'
      } = {} as any
) {
  return useContractWrite<
    typeof l2OutputOracleGoerliABI,
    'deleteL2Outputs',
    TMode
  >({
    abi: l2OutputOracleGoerliABI,
    address: l2OutputOracleGoerliAddress[5],
    functionName: 'deleteL2Outputs',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l2OutputOracleGoerliABI}__ and `functionName` set to `"initialize"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export function useL2OutputOracleGoerliInitialize<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l2OutputOracleGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l2OutputOracleGoerliABI,
          'initialize'
        >['request']['abi'],
        'initialize',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'initialize' }
    : UseContractWriteConfig<
        typeof l2OutputOracleGoerliABI,
        'initialize',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'initialize'
      } = {} as any
) {
  return useContractWrite<typeof l2OutputOracleGoerliABI, 'initialize', TMode>({
    abi: l2OutputOracleGoerliABI,
    address: l2OutputOracleGoerliAddress[5],
    functionName: 'initialize',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l2OutputOracleGoerliABI}__ and `functionName` set to `"proposeL2Output"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export function useL2OutputOracleGoerliProposeL2Output<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l2OutputOracleGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l2OutputOracleGoerliABI,
          'proposeL2Output'
        >['request']['abi'],
        'proposeL2Output',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'proposeL2Output'
      }
    : UseContractWriteConfig<
        typeof l2OutputOracleGoerliABI,
        'proposeL2Output',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'proposeL2Output'
      } = {} as any
) {
  return useContractWrite<
    typeof l2OutputOracleGoerliABI,
    'proposeL2Output',
    TMode
  >({
    abi: l2OutputOracleGoerliABI,
    address: l2OutputOracleGoerliAddress[5],
    functionName: 'proposeL2Output',
    ...config,
  } as any)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l2OutputOracleGoerliABI}__.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export function usePrepareL2OutputOracleGoerliWrite<
  TFunctionName extends string
>(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof l2OutputOracleGoerliABI,
      TFunctionName
    >,
    'abi' | 'address'
  > & { chainId?: keyof typeof l2OutputOracleGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l2OutputOracleGoerliABI,
    address: l2OutputOracleGoerliAddress[5],
    ...config,
  } as UsePrepareContractWriteConfig<typeof l2OutputOracleGoerliABI, TFunctionName>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l2OutputOracleGoerliABI}__ and `functionName` set to `"deleteL2Outputs"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export function usePrepareL2OutputOracleGoerliDeleteL2Outputs(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof l2OutputOracleGoerliABI,
      'deleteL2Outputs'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2OutputOracleGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l2OutputOracleGoerliABI,
    address: l2OutputOracleGoerliAddress[5],
    functionName: 'deleteL2Outputs',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l2OutputOracleGoerliABI, 'deleteL2Outputs'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l2OutputOracleGoerliABI}__ and `functionName` set to `"initialize"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export function usePrepareL2OutputOracleGoerliInitialize(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l2OutputOracleGoerliABI, 'initialize'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2OutputOracleGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l2OutputOracleGoerliABI,
    address: l2OutputOracleGoerliAddress[5],
    functionName: 'initialize',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l2OutputOracleGoerliABI, 'initialize'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l2OutputOracleGoerliABI}__ and `functionName` set to `"proposeL2Output"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export function usePrepareL2OutputOracleGoerliProposeL2Output(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof l2OutputOracleGoerliABI,
      'proposeL2Output'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2OutputOracleGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l2OutputOracleGoerliABI,
    address: l2OutputOracleGoerliAddress[5],
    functionName: 'proposeL2Output',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l2OutputOracleGoerliABI, 'proposeL2Output'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l2OutputOracleGoerliABI}__.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export function useL2OutputOracleGoerliEvent<TEventName extends string>(
  config: Omit<
    UseContractEventConfig<typeof l2OutputOracleGoerliABI, TEventName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof l2OutputOracleGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: l2OutputOracleGoerliABI,
    address: l2OutputOracleGoerliAddress[5],
    ...config,
  } as UseContractEventConfig<typeof l2OutputOracleGoerliABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l2OutputOracleGoerliABI}__ and `eventName` set to `"Initialized"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export function useL2OutputOracleGoerliInitializedEvent(
  config: Omit<
    UseContractEventConfig<typeof l2OutputOracleGoerliABI, 'Initialized'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l2OutputOracleGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: l2OutputOracleGoerliABI,
    address: l2OutputOracleGoerliAddress[5],
    eventName: 'Initialized',
    ...config,
  } as UseContractEventConfig<typeof l2OutputOracleGoerliABI, 'Initialized'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l2OutputOracleGoerliABI}__ and `eventName` set to `"OutputProposed"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export function useL2OutputOracleGoerliOutputProposedEvent(
  config: Omit<
    UseContractEventConfig<typeof l2OutputOracleGoerliABI, 'OutputProposed'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l2OutputOracleGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: l2OutputOracleGoerliABI,
    address: l2OutputOracleGoerliAddress[5],
    eventName: 'OutputProposed',
    ...config,
  } as UseContractEventConfig<typeof l2OutputOracleGoerliABI, 'OutputProposed'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l2OutputOracleGoerliABI}__ and `eventName` set to `"OutputsDeleted"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export function useL2OutputOracleGoerliOutputsDeletedEvent(
  config: Omit<
    UseContractEventConfig<typeof l2OutputOracleGoerliABI, 'OutputsDeleted'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l2OutputOracleGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: l2OutputOracleGoerliABI,
    address: l2OutputOracleGoerliAddress[5],
    eventName: 'OutputsDeleted',
    ...config,
  } as UseContractEventConfig<typeof l2OutputOracleGoerliABI, 'OutputsDeleted'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2StandardBridgeABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export function useL2StandardBridgeRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<typeof l2StandardBridgeABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2StandardBridgeABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address'
  > & { chainId?: keyof typeof l2StandardBridgeAddress } = {} as any
) {
  return useContractRead({
    abi: l2StandardBridgeABI,
    address: l2StandardBridgeAddress[420],
    ...config,
  } as UseContractReadConfig<typeof l2StandardBridgeABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2StandardBridgeABI}__ and `functionName` set to `"OTHER_BRIDGE"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export function useL2StandardBridgeOtherBridge<
  TFunctionName extends 'OTHER_BRIDGE',
  TSelectData = ReadContractResult<typeof l2StandardBridgeABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2StandardBridgeABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2StandardBridgeAddress } = {} as any
) {
  return useContractRead({
    abi: l2StandardBridgeABI,
    address: l2StandardBridgeAddress[420],
    functionName: 'OTHER_BRIDGE',
    ...config,
  } as UseContractReadConfig<typeof l2StandardBridgeABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2StandardBridgeABI}__ and `functionName` set to `"deposits"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export function useL2StandardBridgeDeposits<
  TFunctionName extends 'deposits',
  TSelectData = ReadContractResult<typeof l2StandardBridgeABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2StandardBridgeABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2StandardBridgeAddress } = {} as any
) {
  return useContractRead({
    abi: l2StandardBridgeABI,
    address: l2StandardBridgeAddress[420],
    functionName: 'deposits',
    ...config,
  } as UseContractReadConfig<typeof l2StandardBridgeABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2StandardBridgeABI}__ and `functionName` set to `"l1TokenBridge"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export function useL2StandardBridgeL1TokenBridge<
  TFunctionName extends 'l1TokenBridge',
  TSelectData = ReadContractResult<typeof l2StandardBridgeABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2StandardBridgeABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2StandardBridgeAddress } = {} as any
) {
  return useContractRead({
    abi: l2StandardBridgeABI,
    address: l2StandardBridgeAddress[420],
    functionName: 'l1TokenBridge',
    ...config,
  } as UseContractReadConfig<typeof l2StandardBridgeABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2StandardBridgeABI}__ and `functionName` set to `"messenger"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export function useL2StandardBridgeMessenger<
  TFunctionName extends 'messenger',
  TSelectData = ReadContractResult<typeof l2StandardBridgeABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2StandardBridgeABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2StandardBridgeAddress } = {} as any
) {
  return useContractRead({
    abi: l2StandardBridgeABI,
    address: l2StandardBridgeAddress[420],
    functionName: 'messenger',
    ...config,
  } as UseContractReadConfig<typeof l2StandardBridgeABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2StandardBridgeABI}__ and `functionName` set to `"version"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export function useL2StandardBridgeVersion<
  TFunctionName extends 'version',
  TSelectData = ReadContractResult<typeof l2StandardBridgeABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2StandardBridgeABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2StandardBridgeAddress } = {} as any
) {
  return useContractRead({
    abi: l2StandardBridgeABI,
    address: l2StandardBridgeAddress[420],
    functionName: 'version',
    ...config,
  } as UseContractReadConfig<typeof l2StandardBridgeABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l2StandardBridgeABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export function useL2StandardBridgeWrite<
  TFunctionName extends string,
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l2StandardBridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l2StandardBridgeABI,
          string
        >['request']['abi'],
        TFunctionName,
        TMode
      > & { address?: Address; chainId?: TChainId }
    : UseContractWriteConfig<
        typeof l2StandardBridgeABI,
        TFunctionName,
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
      } = {} as any
) {
  return useContractWrite<typeof l2StandardBridgeABI, TFunctionName, TMode>({
    abi: l2StandardBridgeABI,
    address: l2StandardBridgeAddress[420],
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l2StandardBridgeABI}__ and `functionName` set to `"bridgeERC20"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export function useL2StandardBridgeBridgeErc20<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l2StandardBridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l2StandardBridgeABI,
          'bridgeERC20'
        >['request']['abi'],
        'bridgeERC20',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'bridgeERC20'
      }
    : UseContractWriteConfig<
        typeof l2StandardBridgeABI,
        'bridgeERC20',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'bridgeERC20'
      } = {} as any
) {
  return useContractWrite<typeof l2StandardBridgeABI, 'bridgeERC20', TMode>({
    abi: l2StandardBridgeABI,
    address: l2StandardBridgeAddress[420],
    functionName: 'bridgeERC20',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l2StandardBridgeABI}__ and `functionName` set to `"bridgeERC20To"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export function useL2StandardBridgeBridgeErc20To<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l2StandardBridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l2StandardBridgeABI,
          'bridgeERC20To'
        >['request']['abi'],
        'bridgeERC20To',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'bridgeERC20To'
      }
    : UseContractWriteConfig<
        typeof l2StandardBridgeABI,
        'bridgeERC20To',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'bridgeERC20To'
      } = {} as any
) {
  return useContractWrite<typeof l2StandardBridgeABI, 'bridgeERC20To', TMode>({
    abi: l2StandardBridgeABI,
    address: l2StandardBridgeAddress[420],
    functionName: 'bridgeERC20To',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l2StandardBridgeABI}__ and `functionName` set to `"bridgeETH"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export function useL2StandardBridgeBridgeEth<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l2StandardBridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l2StandardBridgeABI,
          'bridgeETH'
        >['request']['abi'],
        'bridgeETH',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'bridgeETH' }
    : UseContractWriteConfig<typeof l2StandardBridgeABI, 'bridgeETH', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'bridgeETH'
      } = {} as any
) {
  return useContractWrite<typeof l2StandardBridgeABI, 'bridgeETH', TMode>({
    abi: l2StandardBridgeABI,
    address: l2StandardBridgeAddress[420],
    functionName: 'bridgeETH',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l2StandardBridgeABI}__ and `functionName` set to `"bridgeETHTo"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export function useL2StandardBridgeBridgeEthTo<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l2StandardBridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l2StandardBridgeABI,
          'bridgeETHTo'
        >['request']['abi'],
        'bridgeETHTo',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'bridgeETHTo'
      }
    : UseContractWriteConfig<
        typeof l2StandardBridgeABI,
        'bridgeETHTo',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'bridgeETHTo'
      } = {} as any
) {
  return useContractWrite<typeof l2StandardBridgeABI, 'bridgeETHTo', TMode>({
    abi: l2StandardBridgeABI,
    address: l2StandardBridgeAddress[420],
    functionName: 'bridgeETHTo',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l2StandardBridgeABI}__ and `functionName` set to `"finalizeBridgeERC20"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export function useL2StandardBridgeFinalizeBridgeErc20<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l2StandardBridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l2StandardBridgeABI,
          'finalizeBridgeERC20'
        >['request']['abi'],
        'finalizeBridgeERC20',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'finalizeBridgeERC20'
      }
    : UseContractWriteConfig<
        typeof l2StandardBridgeABI,
        'finalizeBridgeERC20',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'finalizeBridgeERC20'
      } = {} as any
) {
  return useContractWrite<
    typeof l2StandardBridgeABI,
    'finalizeBridgeERC20',
    TMode
  >({
    abi: l2StandardBridgeABI,
    address: l2StandardBridgeAddress[420],
    functionName: 'finalizeBridgeERC20',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l2StandardBridgeABI}__ and `functionName` set to `"finalizeBridgeETH"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export function useL2StandardBridgeFinalizeBridgeEth<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l2StandardBridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l2StandardBridgeABI,
          'finalizeBridgeETH'
        >['request']['abi'],
        'finalizeBridgeETH',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'finalizeBridgeETH'
      }
    : UseContractWriteConfig<
        typeof l2StandardBridgeABI,
        'finalizeBridgeETH',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'finalizeBridgeETH'
      } = {} as any
) {
  return useContractWrite<
    typeof l2StandardBridgeABI,
    'finalizeBridgeETH',
    TMode
  >({
    abi: l2StandardBridgeABI,
    address: l2StandardBridgeAddress[420],
    functionName: 'finalizeBridgeETH',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l2StandardBridgeABI}__ and `functionName` set to `"finalizeDeposit"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export function useL2StandardBridgeFinalizeDeposit<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l2StandardBridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l2StandardBridgeABI,
          'finalizeDeposit'
        >['request']['abi'],
        'finalizeDeposit',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'finalizeDeposit'
      }
    : UseContractWriteConfig<
        typeof l2StandardBridgeABI,
        'finalizeDeposit',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'finalizeDeposit'
      } = {} as any
) {
  return useContractWrite<typeof l2StandardBridgeABI, 'finalizeDeposit', TMode>(
    {
      abi: l2StandardBridgeABI,
      address: l2StandardBridgeAddress[420],
      functionName: 'finalizeDeposit',
      ...config,
    } as any
  )
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l2StandardBridgeABI}__ and `functionName` set to `"withdraw"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export function useL2StandardBridgeWithdraw<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l2StandardBridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l2StandardBridgeABI,
          'withdraw'
        >['request']['abi'],
        'withdraw',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'withdraw' }
    : UseContractWriteConfig<typeof l2StandardBridgeABI, 'withdraw', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'withdraw'
      } = {} as any
) {
  return useContractWrite<typeof l2StandardBridgeABI, 'withdraw', TMode>({
    abi: l2StandardBridgeABI,
    address: l2StandardBridgeAddress[420],
    functionName: 'withdraw',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l2StandardBridgeABI}__ and `functionName` set to `"withdrawTo"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export function useL2StandardBridgeWithdrawTo<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l2StandardBridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l2StandardBridgeABI,
          'withdrawTo'
        >['request']['abi'],
        'withdrawTo',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'withdrawTo' }
    : UseContractWriteConfig<
        typeof l2StandardBridgeABI,
        'withdrawTo',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'withdrawTo'
      } = {} as any
) {
  return useContractWrite<typeof l2StandardBridgeABI, 'withdrawTo', TMode>({
    abi: l2StandardBridgeABI,
    address: l2StandardBridgeAddress[420],
    functionName: 'withdrawTo',
    ...config,
  } as any)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l2StandardBridgeABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export function usePrepareL2StandardBridgeWrite<TFunctionName extends string>(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l2StandardBridgeABI, TFunctionName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof l2StandardBridgeAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l2StandardBridgeABI,
    address: l2StandardBridgeAddress[420],
    ...config,
  } as UsePrepareContractWriteConfig<typeof l2StandardBridgeABI, TFunctionName>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l2StandardBridgeABI}__ and `functionName` set to `"bridgeERC20"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export function usePrepareL2StandardBridgeBridgeErc20(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l2StandardBridgeABI, 'bridgeERC20'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2StandardBridgeAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l2StandardBridgeABI,
    address: l2StandardBridgeAddress[420],
    functionName: 'bridgeERC20',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l2StandardBridgeABI, 'bridgeERC20'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l2StandardBridgeABI}__ and `functionName` set to `"bridgeERC20To"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export function usePrepareL2StandardBridgeBridgeErc20To(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l2StandardBridgeABI, 'bridgeERC20To'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2StandardBridgeAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l2StandardBridgeABI,
    address: l2StandardBridgeAddress[420],
    functionName: 'bridgeERC20To',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l2StandardBridgeABI, 'bridgeERC20To'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l2StandardBridgeABI}__ and `functionName` set to `"bridgeETH"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export function usePrepareL2StandardBridgeBridgeEth(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l2StandardBridgeABI, 'bridgeETH'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2StandardBridgeAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l2StandardBridgeABI,
    address: l2StandardBridgeAddress[420],
    functionName: 'bridgeETH',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l2StandardBridgeABI, 'bridgeETH'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l2StandardBridgeABI}__ and `functionName` set to `"bridgeETHTo"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export function usePrepareL2StandardBridgeBridgeEthTo(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l2StandardBridgeABI, 'bridgeETHTo'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2StandardBridgeAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l2StandardBridgeABI,
    address: l2StandardBridgeAddress[420],
    functionName: 'bridgeETHTo',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l2StandardBridgeABI, 'bridgeETHTo'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l2StandardBridgeABI}__ and `functionName` set to `"finalizeBridgeERC20"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export function usePrepareL2StandardBridgeFinalizeBridgeErc20(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof l2StandardBridgeABI,
      'finalizeBridgeERC20'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2StandardBridgeAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l2StandardBridgeABI,
    address: l2StandardBridgeAddress[420],
    functionName: 'finalizeBridgeERC20',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l2StandardBridgeABI, 'finalizeBridgeERC20'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l2StandardBridgeABI}__ and `functionName` set to `"finalizeBridgeETH"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export function usePrepareL2StandardBridgeFinalizeBridgeEth(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof l2StandardBridgeABI,
      'finalizeBridgeETH'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2StandardBridgeAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l2StandardBridgeABI,
    address: l2StandardBridgeAddress[420],
    functionName: 'finalizeBridgeETH',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l2StandardBridgeABI, 'finalizeBridgeETH'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l2StandardBridgeABI}__ and `functionName` set to `"finalizeDeposit"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export function usePrepareL2StandardBridgeFinalizeDeposit(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof l2StandardBridgeABI,
      'finalizeDeposit'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2StandardBridgeAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l2StandardBridgeABI,
    address: l2StandardBridgeAddress[420],
    functionName: 'finalizeDeposit',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l2StandardBridgeABI, 'finalizeDeposit'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l2StandardBridgeABI}__ and `functionName` set to `"withdraw"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export function usePrepareL2StandardBridgeWithdraw(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l2StandardBridgeABI, 'withdraw'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2StandardBridgeAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l2StandardBridgeABI,
    address: l2StandardBridgeAddress[420],
    functionName: 'withdraw',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l2StandardBridgeABI, 'withdraw'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l2StandardBridgeABI}__ and `functionName` set to `"withdrawTo"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export function usePrepareL2StandardBridgeWithdrawTo(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l2StandardBridgeABI, 'withdrawTo'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2StandardBridgeAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l2StandardBridgeABI,
    address: l2StandardBridgeAddress[420],
    functionName: 'withdrawTo',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l2StandardBridgeABI, 'withdrawTo'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l2StandardBridgeABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export function useL2StandardBridgeEvent<TEventName extends string>(
  config: Omit<
    UseContractEventConfig<typeof l2StandardBridgeABI, TEventName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof l2StandardBridgeAddress } = {} as any
) {
  return useContractEvent({
    abi: l2StandardBridgeABI,
    address: l2StandardBridgeAddress[420],
    ...config,
  } as UseContractEventConfig<typeof l2StandardBridgeABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l2StandardBridgeABI}__ and `eventName` set to `"DepositFinalized"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export function useL2StandardBridgeDepositFinalizedEvent(
  config: Omit<
    UseContractEventConfig<typeof l2StandardBridgeABI, 'DepositFinalized'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l2StandardBridgeAddress } = {} as any
) {
  return useContractEvent({
    abi: l2StandardBridgeABI,
    address: l2StandardBridgeAddress[420],
    eventName: 'DepositFinalized',
    ...config,
  } as UseContractEventConfig<typeof l2StandardBridgeABI, 'DepositFinalized'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l2StandardBridgeABI}__ and `eventName` set to `"ERC20BridgeFinalized"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export function useL2StandardBridgeErc20BridgeFinalizedEvent(
  config: Omit<
    UseContractEventConfig<typeof l2StandardBridgeABI, 'ERC20BridgeFinalized'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l2StandardBridgeAddress } = {} as any
) {
  return useContractEvent({
    abi: l2StandardBridgeABI,
    address: l2StandardBridgeAddress[420],
    eventName: 'ERC20BridgeFinalized',
    ...config,
  } as UseContractEventConfig<typeof l2StandardBridgeABI, 'ERC20BridgeFinalized'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l2StandardBridgeABI}__ and `eventName` set to `"ERC20BridgeInitiated"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export function useL2StandardBridgeErc20BridgeInitiatedEvent(
  config: Omit<
    UseContractEventConfig<typeof l2StandardBridgeABI, 'ERC20BridgeInitiated'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l2StandardBridgeAddress } = {} as any
) {
  return useContractEvent({
    abi: l2StandardBridgeABI,
    address: l2StandardBridgeAddress[420],
    eventName: 'ERC20BridgeInitiated',
    ...config,
  } as UseContractEventConfig<typeof l2StandardBridgeABI, 'ERC20BridgeInitiated'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l2StandardBridgeABI}__ and `eventName` set to `"ETHBridgeFinalized"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export function useL2StandardBridgeEthBridgeFinalizedEvent(
  config: Omit<
    UseContractEventConfig<typeof l2StandardBridgeABI, 'ETHBridgeFinalized'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l2StandardBridgeAddress } = {} as any
) {
  return useContractEvent({
    abi: l2StandardBridgeABI,
    address: l2StandardBridgeAddress[420],
    eventName: 'ETHBridgeFinalized',
    ...config,
  } as UseContractEventConfig<typeof l2StandardBridgeABI, 'ETHBridgeFinalized'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l2StandardBridgeABI}__ and `eventName` set to `"ETHBridgeInitiated"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export function useL2StandardBridgeEthBridgeInitiatedEvent(
  config: Omit<
    UseContractEventConfig<typeof l2StandardBridgeABI, 'ETHBridgeInitiated'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l2StandardBridgeAddress } = {} as any
) {
  return useContractEvent({
    abi: l2StandardBridgeABI,
    address: l2StandardBridgeAddress[420],
    eventName: 'ETHBridgeInitiated',
    ...config,
  } as UseContractEventConfig<typeof l2StandardBridgeABI, 'ETHBridgeInitiated'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l2StandardBridgeABI}__ and `eventName` set to `"WithdrawalInitiated"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export function useL2StandardBridgeWithdrawalInitiatedEvent(
  config: Omit<
    UseContractEventConfig<typeof l2StandardBridgeABI, 'WithdrawalInitiated'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l2StandardBridgeAddress } = {} as any
) {
  return useContractEvent({
    abi: l2StandardBridgeABI,
    address: l2StandardBridgeAddress[420],
    eventName: 'WithdrawalInitiated',
    ...config,
  } as UseContractEventConfig<typeof l2StandardBridgeABI, 'WithdrawalInitiated'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2ToL1MessagePasserABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000016)
 */
export function useL2ToL1MessagePasserRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<typeof l2ToL1MessagePasserABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2ToL1MessagePasserABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address'
  > & { chainId?: keyof typeof l2ToL1MessagePasserAddress } = {} as any
) {
  return useContractRead({
    abi: l2ToL1MessagePasserABI,
    address: l2ToL1MessagePasserAddress[420],
    ...config,
  } as UseContractReadConfig<typeof l2ToL1MessagePasserABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2ToL1MessagePasserABI}__ and `functionName` set to `"MESSAGE_VERSION"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000016)
 */
export function useL2ToL1MessagePasserMessageVersion<
  TFunctionName extends 'MESSAGE_VERSION',
  TSelectData = ReadContractResult<typeof l2ToL1MessagePasserABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2ToL1MessagePasserABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2ToL1MessagePasserAddress } = {} as any
) {
  return useContractRead({
    abi: l2ToL1MessagePasserABI,
    address: l2ToL1MessagePasserAddress[420],
    functionName: 'MESSAGE_VERSION',
    ...config,
  } as UseContractReadConfig<typeof l2ToL1MessagePasserABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2ToL1MessagePasserABI}__ and `functionName` set to `"messageNonce"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000016)
 */
export function useL2ToL1MessagePasserMessageNonce<
  TFunctionName extends 'messageNonce',
  TSelectData = ReadContractResult<typeof l2ToL1MessagePasserABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2ToL1MessagePasserABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2ToL1MessagePasserAddress } = {} as any
) {
  return useContractRead({
    abi: l2ToL1MessagePasserABI,
    address: l2ToL1MessagePasserAddress[420],
    functionName: 'messageNonce',
    ...config,
  } as UseContractReadConfig<typeof l2ToL1MessagePasserABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2ToL1MessagePasserABI}__ and `functionName` set to `"sentMessages"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000016)
 */
export function useL2ToL1MessagePasserSentMessages<
  TFunctionName extends 'sentMessages',
  TSelectData = ReadContractResult<typeof l2ToL1MessagePasserABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2ToL1MessagePasserABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2ToL1MessagePasserAddress } = {} as any
) {
  return useContractRead({
    abi: l2ToL1MessagePasserABI,
    address: l2ToL1MessagePasserAddress[420],
    functionName: 'sentMessages',
    ...config,
  } as UseContractReadConfig<typeof l2ToL1MessagePasserABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2ToL1MessagePasserABI}__ and `functionName` set to `"version"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000016)
 */
export function useL2ToL1MessagePasserVersion<
  TFunctionName extends 'version',
  TSelectData = ReadContractResult<typeof l2ToL1MessagePasserABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2ToL1MessagePasserABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2ToL1MessagePasserAddress } = {} as any
) {
  return useContractRead({
    abi: l2ToL1MessagePasserABI,
    address: l2ToL1MessagePasserAddress[420],
    functionName: 'version',
    ...config,
  } as UseContractReadConfig<typeof l2ToL1MessagePasserABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l2ToL1MessagePasserABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000016)
 */
export function useL2ToL1MessagePasserWrite<
  TFunctionName extends string,
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l2ToL1MessagePasserAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l2ToL1MessagePasserABI,
          string
        >['request']['abi'],
        TFunctionName,
        TMode
      > & { address?: Address; chainId?: TChainId }
    : UseContractWriteConfig<
        typeof l2ToL1MessagePasserABI,
        TFunctionName,
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
      } = {} as any
) {
  return useContractWrite<typeof l2ToL1MessagePasserABI, TFunctionName, TMode>({
    abi: l2ToL1MessagePasserABI,
    address: l2ToL1MessagePasserAddress[420],
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l2ToL1MessagePasserABI}__ and `functionName` set to `"burn"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000016)
 */
export function useL2ToL1MessagePasserBurn<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l2ToL1MessagePasserAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l2ToL1MessagePasserABI,
          'burn'
        >['request']['abi'],
        'burn',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'burn' }
    : UseContractWriteConfig<typeof l2ToL1MessagePasserABI, 'burn', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'burn'
      } = {} as any
) {
  return useContractWrite<typeof l2ToL1MessagePasserABI, 'burn', TMode>({
    abi: l2ToL1MessagePasserABI,
    address: l2ToL1MessagePasserAddress[420],
    functionName: 'burn',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l2ToL1MessagePasserABI}__ and `functionName` set to `"initiateWithdrawal"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000016)
 */
export function useL2ToL1MessagePasserInitiateWithdrawal<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l2ToL1MessagePasserAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l2ToL1MessagePasserABI,
          'initiateWithdrawal'
        >['request']['abi'],
        'initiateWithdrawal',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'initiateWithdrawal'
      }
    : UseContractWriteConfig<
        typeof l2ToL1MessagePasserABI,
        'initiateWithdrawal',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'initiateWithdrawal'
      } = {} as any
) {
  return useContractWrite<
    typeof l2ToL1MessagePasserABI,
    'initiateWithdrawal',
    TMode
  >({
    abi: l2ToL1MessagePasserABI,
    address: l2ToL1MessagePasserAddress[420],
    functionName: 'initiateWithdrawal',
    ...config,
  } as any)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l2ToL1MessagePasserABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000016)
 */
export function usePrepareL2ToL1MessagePasserWrite<
  TFunctionName extends string
>(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l2ToL1MessagePasserABI, TFunctionName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof l2ToL1MessagePasserAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l2ToL1MessagePasserABI,
    address: l2ToL1MessagePasserAddress[420],
    ...config,
  } as UsePrepareContractWriteConfig<typeof l2ToL1MessagePasserABI, TFunctionName>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l2ToL1MessagePasserABI}__ and `functionName` set to `"burn"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000016)
 */
export function usePrepareL2ToL1MessagePasserBurn(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l2ToL1MessagePasserABI, 'burn'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2ToL1MessagePasserAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l2ToL1MessagePasserABI,
    address: l2ToL1MessagePasserAddress[420],
    functionName: 'burn',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l2ToL1MessagePasserABI, 'burn'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l2ToL1MessagePasserABI}__ and `functionName` set to `"initiateWithdrawal"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000016)
 */
export function usePrepareL2ToL1MessagePasserInitiateWithdrawal(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof l2ToL1MessagePasserABI,
      'initiateWithdrawal'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2ToL1MessagePasserAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l2ToL1MessagePasserABI,
    address: l2ToL1MessagePasserAddress[420],
    functionName: 'initiateWithdrawal',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l2ToL1MessagePasserABI, 'initiateWithdrawal'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l2ToL1MessagePasserABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000016)
 */
export function useL2ToL1MessagePasserEvent<TEventName extends string>(
  config: Omit<
    UseContractEventConfig<typeof l2ToL1MessagePasserABI, TEventName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof l2ToL1MessagePasserAddress } = {} as any
) {
  return useContractEvent({
    abi: l2ToL1MessagePasserABI,
    address: l2ToL1MessagePasserAddress[420],
    ...config,
  } as UseContractEventConfig<typeof l2ToL1MessagePasserABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l2ToL1MessagePasserABI}__ and `eventName` set to `"MessagePassed"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000016)
 */
export function useL2ToL1MessagePasserMessagePassedEvent(
  config: Omit<
    UseContractEventConfig<typeof l2ToL1MessagePasserABI, 'MessagePassed'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l2ToL1MessagePasserAddress } = {} as any
) {
  return useContractEvent({
    abi: l2ToL1MessagePasserABI,
    address: l2ToL1MessagePasserAddress[420],
    eventName: 'MessagePassed',
    ...config,
  } as UseContractEventConfig<typeof l2ToL1MessagePasserABI, 'MessagePassed'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l2ToL1MessagePasserABI}__ and `eventName` set to `"WithdrawerBalanceBurnt"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000016)
 */
export function useL2ToL1MessagePasserWithdrawerBalanceBurntEvent(
  config: Omit<
    UseContractEventConfig<
      typeof l2ToL1MessagePasserABI,
      'WithdrawerBalanceBurnt'
    >,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l2ToL1MessagePasserAddress } = {} as any
) {
  return useContractEvent({
    abi: l2ToL1MessagePasserABI,
    address: l2ToL1MessagePasserAddress[420],
    eventName: 'WithdrawerBalanceBurnt',
    ...config,
  } as UseContractEventConfig<typeof l2ToL1MessagePasserABI, 'WithdrawerBalanceBurnt'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link mintManagerABI}__.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x5C4e7Ba1E219E47948e6e3F55019A647bA501005)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x038a8825A3C3B0c08d52Cc76E5E361953Cf6Dc76)
 */
export function useMintManagerRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<typeof mintManagerABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof mintManagerABI, TFunctionName, TSelectData>,
    'abi' | 'address'
  > & { chainId?: keyof typeof mintManagerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractRead({
    abi: mintManagerABI,
    address: mintManagerAddress[chainId as keyof typeof mintManagerAddress],
    ...config,
  } as UseContractReadConfig<typeof mintManagerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link mintManagerABI}__ and `functionName` set to `"DENOMINATOR"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x5C4e7Ba1E219E47948e6e3F55019A647bA501005)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x038a8825A3C3B0c08d52Cc76E5E361953Cf6Dc76)
 */
export function useMintManagerDenominator<
  TFunctionName extends 'DENOMINATOR',
  TSelectData = ReadContractResult<typeof mintManagerABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof mintManagerABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof mintManagerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractRead({
    abi: mintManagerABI,
    address: mintManagerAddress[chainId as keyof typeof mintManagerAddress],
    functionName: 'DENOMINATOR',
    ...config,
  } as UseContractReadConfig<typeof mintManagerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link mintManagerABI}__ and `functionName` set to `"MINT_CAP"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x5C4e7Ba1E219E47948e6e3F55019A647bA501005)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x038a8825A3C3B0c08d52Cc76E5E361953Cf6Dc76)
 */
export function useMintManagerMintCap<
  TFunctionName extends 'MINT_CAP',
  TSelectData = ReadContractResult<typeof mintManagerABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof mintManagerABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof mintManagerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractRead({
    abi: mintManagerABI,
    address: mintManagerAddress[chainId as keyof typeof mintManagerAddress],
    functionName: 'MINT_CAP',
    ...config,
  } as UseContractReadConfig<typeof mintManagerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link mintManagerABI}__ and `functionName` set to `"MINT_PERIOD"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x5C4e7Ba1E219E47948e6e3F55019A647bA501005)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x038a8825A3C3B0c08d52Cc76E5E361953Cf6Dc76)
 */
export function useMintManagerMintPeriod<
  TFunctionName extends 'MINT_PERIOD',
  TSelectData = ReadContractResult<typeof mintManagerABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof mintManagerABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof mintManagerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractRead({
    abi: mintManagerABI,
    address: mintManagerAddress[chainId as keyof typeof mintManagerAddress],
    functionName: 'MINT_PERIOD',
    ...config,
  } as UseContractReadConfig<typeof mintManagerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link mintManagerABI}__ and `functionName` set to `"governanceToken"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x5C4e7Ba1E219E47948e6e3F55019A647bA501005)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x038a8825A3C3B0c08d52Cc76E5E361953Cf6Dc76)
 */
export function useMintManagerGovernanceToken<
  TFunctionName extends 'governanceToken',
  TSelectData = ReadContractResult<typeof mintManagerABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof mintManagerABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof mintManagerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractRead({
    abi: mintManagerABI,
    address: mintManagerAddress[chainId as keyof typeof mintManagerAddress],
    functionName: 'governanceToken',
    ...config,
  } as UseContractReadConfig<typeof mintManagerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link mintManagerABI}__ and `functionName` set to `"mintPermittedAfter"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x5C4e7Ba1E219E47948e6e3F55019A647bA501005)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x038a8825A3C3B0c08d52Cc76E5E361953Cf6Dc76)
 */
export function useMintManagerMintPermittedAfter<
  TFunctionName extends 'mintPermittedAfter',
  TSelectData = ReadContractResult<typeof mintManagerABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof mintManagerABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof mintManagerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractRead({
    abi: mintManagerABI,
    address: mintManagerAddress[chainId as keyof typeof mintManagerAddress],
    functionName: 'mintPermittedAfter',
    ...config,
  } as UseContractReadConfig<typeof mintManagerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link mintManagerABI}__ and `functionName` set to `"owner"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x5C4e7Ba1E219E47948e6e3F55019A647bA501005)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x038a8825A3C3B0c08d52Cc76E5E361953Cf6Dc76)
 */
export function useMintManagerOwner<
  TFunctionName extends 'owner',
  TSelectData = ReadContractResult<typeof mintManagerABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof mintManagerABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof mintManagerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractRead({
    abi: mintManagerABI,
    address: mintManagerAddress[chainId as keyof typeof mintManagerAddress],
    functionName: 'owner',
    ...config,
  } as UseContractReadConfig<typeof mintManagerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link mintManagerABI}__.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x5C4e7Ba1E219E47948e6e3F55019A647bA501005)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x038a8825A3C3B0c08d52Cc76E5E361953Cf6Dc76)
 */
export function useMintManagerWrite<
  TFunctionName extends string,
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof mintManagerAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof mintManagerABI,
          string
        >['request']['abi'],
        TFunctionName,
        TMode
      > & { address?: Address; chainId?: TChainId }
    : UseContractWriteConfig<typeof mintManagerABI, TFunctionName, TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
      } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractWrite<typeof mintManagerABI, TFunctionName, TMode>({
    abi: mintManagerABI,
    address: mintManagerAddress[chainId as keyof typeof mintManagerAddress],
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link mintManagerABI}__ and `functionName` set to `"mint"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x5C4e7Ba1E219E47948e6e3F55019A647bA501005)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x038a8825A3C3B0c08d52Cc76E5E361953Cf6Dc76)
 */
export function useMintManagerMint<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof mintManagerAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof mintManagerABI,
          'mint'
        >['request']['abi'],
        'mint',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'mint' }
    : UseContractWriteConfig<typeof mintManagerABI, 'mint', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'mint'
      } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractWrite<typeof mintManagerABI, 'mint', TMode>({
    abi: mintManagerABI,
    address: mintManagerAddress[chainId as keyof typeof mintManagerAddress],
    functionName: 'mint',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link mintManagerABI}__ and `functionName` set to `"renounceOwnership"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x5C4e7Ba1E219E47948e6e3F55019A647bA501005)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x038a8825A3C3B0c08d52Cc76E5E361953Cf6Dc76)
 */
export function useMintManagerRenounceOwnership<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof mintManagerAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof mintManagerABI,
          'renounceOwnership'
        >['request']['abi'],
        'renounceOwnership',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'renounceOwnership'
      }
    : UseContractWriteConfig<
        typeof mintManagerABI,
        'renounceOwnership',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'renounceOwnership'
      } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractWrite<typeof mintManagerABI, 'renounceOwnership', TMode>({
    abi: mintManagerABI,
    address: mintManagerAddress[chainId as keyof typeof mintManagerAddress],
    functionName: 'renounceOwnership',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link mintManagerABI}__ and `functionName` set to `"transferOwnership"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x5C4e7Ba1E219E47948e6e3F55019A647bA501005)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x038a8825A3C3B0c08d52Cc76E5E361953Cf6Dc76)
 */
export function useMintManagerTransferOwnership<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof mintManagerAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof mintManagerABI,
          'transferOwnership'
        >['request']['abi'],
        'transferOwnership',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'transferOwnership'
      }
    : UseContractWriteConfig<
        typeof mintManagerABI,
        'transferOwnership',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'transferOwnership'
      } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractWrite<typeof mintManagerABI, 'transferOwnership', TMode>({
    abi: mintManagerABI,
    address: mintManagerAddress[chainId as keyof typeof mintManagerAddress],
    functionName: 'transferOwnership',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link mintManagerABI}__ and `functionName` set to `"upgrade"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x5C4e7Ba1E219E47948e6e3F55019A647bA501005)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x038a8825A3C3B0c08d52Cc76E5E361953Cf6Dc76)
 */
export function useMintManagerUpgrade<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof mintManagerAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof mintManagerABI,
          'upgrade'
        >['request']['abi'],
        'upgrade',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'upgrade' }
    : UseContractWriteConfig<typeof mintManagerABI, 'upgrade', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'upgrade'
      } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractWrite<typeof mintManagerABI, 'upgrade', TMode>({
    abi: mintManagerABI,
    address: mintManagerAddress[chainId as keyof typeof mintManagerAddress],
    functionName: 'upgrade',
    ...config,
  } as any)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link mintManagerABI}__.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x5C4e7Ba1E219E47948e6e3F55019A647bA501005)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x038a8825A3C3B0c08d52Cc76E5E361953Cf6Dc76)
 */
export function usePrepareMintManagerWrite<TFunctionName extends string>(
  config: Omit<
    UsePrepareContractWriteConfig<typeof mintManagerABI, TFunctionName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof mintManagerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return usePrepareContractWrite({
    abi: mintManagerABI,
    address: mintManagerAddress[chainId as keyof typeof mintManagerAddress],
    ...config,
  } as UsePrepareContractWriteConfig<typeof mintManagerABI, TFunctionName>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link mintManagerABI}__ and `functionName` set to `"mint"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x5C4e7Ba1E219E47948e6e3F55019A647bA501005)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x038a8825A3C3B0c08d52Cc76E5E361953Cf6Dc76)
 */
export function usePrepareMintManagerMint(
  config: Omit<
    UsePrepareContractWriteConfig<typeof mintManagerABI, 'mint'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof mintManagerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return usePrepareContractWrite({
    abi: mintManagerABI,
    address: mintManagerAddress[chainId as keyof typeof mintManagerAddress],
    functionName: 'mint',
    ...config,
  } as UsePrepareContractWriteConfig<typeof mintManagerABI, 'mint'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link mintManagerABI}__ and `functionName` set to `"renounceOwnership"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x5C4e7Ba1E219E47948e6e3F55019A647bA501005)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x038a8825A3C3B0c08d52Cc76E5E361953Cf6Dc76)
 */
export function usePrepareMintManagerRenounceOwnership(
  config: Omit<
    UsePrepareContractWriteConfig<typeof mintManagerABI, 'renounceOwnership'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof mintManagerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return usePrepareContractWrite({
    abi: mintManagerABI,
    address: mintManagerAddress[chainId as keyof typeof mintManagerAddress],
    functionName: 'renounceOwnership',
    ...config,
  } as UsePrepareContractWriteConfig<typeof mintManagerABI, 'renounceOwnership'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link mintManagerABI}__ and `functionName` set to `"transferOwnership"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x5C4e7Ba1E219E47948e6e3F55019A647bA501005)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x038a8825A3C3B0c08d52Cc76E5E361953Cf6Dc76)
 */
export function usePrepareMintManagerTransferOwnership(
  config: Omit<
    UsePrepareContractWriteConfig<typeof mintManagerABI, 'transferOwnership'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof mintManagerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return usePrepareContractWrite({
    abi: mintManagerABI,
    address: mintManagerAddress[chainId as keyof typeof mintManagerAddress],
    functionName: 'transferOwnership',
    ...config,
  } as UsePrepareContractWriteConfig<typeof mintManagerABI, 'transferOwnership'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link mintManagerABI}__ and `functionName` set to `"upgrade"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x5C4e7Ba1E219E47948e6e3F55019A647bA501005)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x038a8825A3C3B0c08d52Cc76E5E361953Cf6Dc76)
 */
export function usePrepareMintManagerUpgrade(
  config: Omit<
    UsePrepareContractWriteConfig<typeof mintManagerABI, 'upgrade'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof mintManagerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return usePrepareContractWrite({
    abi: mintManagerABI,
    address: mintManagerAddress[chainId as keyof typeof mintManagerAddress],
    functionName: 'upgrade',
    ...config,
  } as UsePrepareContractWriteConfig<typeof mintManagerABI, 'upgrade'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link mintManagerABI}__.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x5C4e7Ba1E219E47948e6e3F55019A647bA501005)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x038a8825A3C3B0c08d52Cc76E5E361953Cf6Dc76)
 */
export function useMintManagerEvent<TEventName extends string>(
  config: Omit<
    UseContractEventConfig<typeof mintManagerABI, TEventName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof mintManagerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractEvent({
    abi: mintManagerABI,
    address: mintManagerAddress[chainId as keyof typeof mintManagerAddress],
    ...config,
  } as UseContractEventConfig<typeof mintManagerABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link mintManagerABI}__ and `eventName` set to `"OwnershipTransferred"`.
 *
 * - [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x5C4e7Ba1E219E47948e6e3F55019A647bA501005)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x038a8825A3C3B0c08d52Cc76E5E361953Cf6Dc76)
 */
export function useMintManagerOwnershipTransferredEvent(
  config: Omit<
    UseContractEventConfig<typeof mintManagerABI, 'OwnershipTransferred'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof mintManagerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const defaultChainId = useChainId()
  const chainId = config.chainId ?? chain?.id ?? defaultChainId
  return useContractEvent({
    abi: mintManagerABI,
    address: mintManagerAddress[chainId as keyof typeof mintManagerAddress],
    eventName: 'OwnershipTransferred',
    ...config,
  } as UseContractEventConfig<typeof mintManagerABI, 'OwnershipTransferred'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimismMintableErc20FactoryABI}__.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export function useOptimismMintableErc20FactoryRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<
    typeof optimismMintableErc20FactoryABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof optimismMintableErc20FactoryABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address'
  > & { chainId?: keyof typeof optimismMintableErc20FactoryAddress } = {} as any
) {
  return useContractRead({
    abi: optimismMintableErc20FactoryABI,
    address: optimismMintableErc20FactoryAddress[1],
    ...config,
  } as UseContractReadConfig<typeof optimismMintableErc20FactoryABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimismMintableErc20FactoryABI}__ and `functionName` set to `"BRIDGE"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export function useOptimismMintableErc20FactoryBridge<
  TFunctionName extends 'BRIDGE',
  TSelectData = ReadContractResult<
    typeof optimismMintableErc20FactoryABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof optimismMintableErc20FactoryABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimismMintableErc20FactoryAddress } = {} as any
) {
  return useContractRead({
    abi: optimismMintableErc20FactoryABI,
    address: optimismMintableErc20FactoryAddress[1],
    functionName: 'BRIDGE',
    ...config,
  } as UseContractReadConfig<typeof optimismMintableErc20FactoryABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimismMintableErc20FactoryABI}__ and `functionName` set to `"version"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export function useOptimismMintableErc20FactoryVersion<
  TFunctionName extends 'version',
  TSelectData = ReadContractResult<
    typeof optimismMintableErc20FactoryABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof optimismMintableErc20FactoryABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimismMintableErc20FactoryAddress } = {} as any
) {
  return useContractRead({
    abi: optimismMintableErc20FactoryABI,
    address: optimismMintableErc20FactoryAddress[1],
    functionName: 'version',
    ...config,
  } as UseContractReadConfig<typeof optimismMintableErc20FactoryABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link optimismMintableErc20FactoryABI}__.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export function useOptimismMintableErc20FactoryWrite<
  TFunctionName extends string,
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof optimismMintableErc20FactoryAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof optimismMintableErc20FactoryABI,
          string
        >['request']['abi'],
        TFunctionName,
        TMode
      > & { address?: Address; chainId?: TChainId }
    : UseContractWriteConfig<
        typeof optimismMintableErc20FactoryABI,
        TFunctionName,
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
      } = {} as any
) {
  return useContractWrite<
    typeof optimismMintableErc20FactoryABI,
    TFunctionName,
    TMode
  >({
    abi: optimismMintableErc20FactoryABI,
    address: optimismMintableErc20FactoryAddress[1],
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link optimismMintableErc20FactoryABI}__ and `functionName` set to `"createOptimismMintableERC20"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export function useOptimismMintableErc20FactoryCreateOptimismMintableErc20<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof optimismMintableErc20FactoryAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof optimismMintableErc20FactoryABI,
          'createOptimismMintableERC20'
        >['request']['abi'],
        'createOptimismMintableERC20',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'createOptimismMintableERC20'
      }
    : UseContractWriteConfig<
        typeof optimismMintableErc20FactoryABI,
        'createOptimismMintableERC20',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'createOptimismMintableERC20'
      } = {} as any
) {
  return useContractWrite<
    typeof optimismMintableErc20FactoryABI,
    'createOptimismMintableERC20',
    TMode
  >({
    abi: optimismMintableErc20FactoryABI,
    address: optimismMintableErc20FactoryAddress[1],
    functionName: 'createOptimismMintableERC20',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link optimismMintableErc20FactoryABI}__ and `functionName` set to `"createStandardL2Token"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export function useOptimismMintableErc20FactoryCreateStandardL2Token<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof optimismMintableErc20FactoryAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof optimismMintableErc20FactoryABI,
          'createStandardL2Token'
        >['request']['abi'],
        'createStandardL2Token',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'createStandardL2Token'
      }
    : UseContractWriteConfig<
        typeof optimismMintableErc20FactoryABI,
        'createStandardL2Token',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'createStandardL2Token'
      } = {} as any
) {
  return useContractWrite<
    typeof optimismMintableErc20FactoryABI,
    'createStandardL2Token',
    TMode
  >({
    abi: optimismMintableErc20FactoryABI,
    address: optimismMintableErc20FactoryAddress[1],
    functionName: 'createStandardL2Token',
    ...config,
  } as any)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link optimismMintableErc20FactoryABI}__.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export function usePrepareOptimismMintableErc20FactoryWrite<
  TFunctionName extends string
>(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof optimismMintableErc20FactoryABI,
      TFunctionName
    >,
    'abi' | 'address'
  > & { chainId?: keyof typeof optimismMintableErc20FactoryAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: optimismMintableErc20FactoryABI,
    address: optimismMintableErc20FactoryAddress[1],
    ...config,
  } as UsePrepareContractWriteConfig<typeof optimismMintableErc20FactoryABI, TFunctionName>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link optimismMintableErc20FactoryABI}__ and `functionName` set to `"createOptimismMintableERC20"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export function usePrepareOptimismMintableErc20FactoryCreateOptimismMintableErc20(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof optimismMintableErc20FactoryABI,
      'createOptimismMintableERC20'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimismMintableErc20FactoryAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: optimismMintableErc20FactoryABI,
    address: optimismMintableErc20FactoryAddress[1],
    functionName: 'createOptimismMintableERC20',
    ...config,
  } as UsePrepareContractWriteConfig<typeof optimismMintableErc20FactoryABI, 'createOptimismMintableERC20'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link optimismMintableErc20FactoryABI}__ and `functionName` set to `"createStandardL2Token"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export function usePrepareOptimismMintableErc20FactoryCreateStandardL2Token(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof optimismMintableErc20FactoryABI,
      'createStandardL2Token'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimismMintableErc20FactoryAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: optimismMintableErc20FactoryABI,
    address: optimismMintableErc20FactoryAddress[1],
    functionName: 'createStandardL2Token',
    ...config,
  } as UsePrepareContractWriteConfig<typeof optimismMintableErc20FactoryABI, 'createStandardL2Token'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link optimismMintableErc20FactoryABI}__.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export function useOptimismMintableErc20FactoryEvent<TEventName extends string>(
  config: Omit<
    UseContractEventConfig<typeof optimismMintableErc20FactoryABI, TEventName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof optimismMintableErc20FactoryAddress } = {} as any
) {
  return useContractEvent({
    abi: optimismMintableErc20FactoryABI,
    address: optimismMintableErc20FactoryAddress[1],
    ...config,
  } as UseContractEventConfig<typeof optimismMintableErc20FactoryABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link optimismMintableErc20FactoryABI}__ and `eventName` set to `"OptimismMintableERC20Created"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export function useOptimismMintableErc20FactoryOptimismMintableErc20CreatedEvent(
  config: Omit<
    UseContractEventConfig<
      typeof optimismMintableErc20FactoryABI,
      'OptimismMintableERC20Created'
    >,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof optimismMintableErc20FactoryAddress } = {} as any
) {
  return useContractEvent({
    abi: optimismMintableErc20FactoryABI,
    address: optimismMintableErc20FactoryAddress[1],
    eventName: 'OptimismMintableERC20Created',
    ...config,
  } as UseContractEventConfig<typeof optimismMintableErc20FactoryABI, 'OptimismMintableERC20Created'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link optimismMintableErc20FactoryABI}__ and `eventName` set to `"StandardL2TokenCreated"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export function useOptimismMintableErc20FactoryStandardL2TokenCreatedEvent(
  config: Omit<
    UseContractEventConfig<
      typeof optimismMintableErc20FactoryABI,
      'StandardL2TokenCreated'
    >,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof optimismMintableErc20FactoryAddress } = {} as any
) {
  return useContractEvent({
    abi: optimismMintableErc20FactoryABI,
    address: optimismMintableErc20FactoryAddress[1],
    eventName: 'StandardL2TokenCreated',
    ...config,
  } as UseContractEventConfig<typeof optimismMintableErc20FactoryABI, 'StandardL2TokenCreated'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimismMintableErc20FactoryGoerliABI}__.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export function useOptimismMintableErc20FactoryGoerliRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<
    typeof optimismMintableErc20FactoryGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof optimismMintableErc20FactoryGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address'
  > & {
    chainId?: keyof typeof optimismMintableErc20FactoryGoerliAddress
  } = {} as any
) {
  return useContractRead({
    abi: optimismMintableErc20FactoryGoerliABI,
    address: optimismMintableErc20FactoryGoerliAddress[5],
    ...config,
  } as UseContractReadConfig<typeof optimismMintableErc20FactoryGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimismMintableErc20FactoryGoerliABI}__ and `functionName` set to `"bridge"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export function useOptimismMintableErc20FactoryGoerliBridge<
  TFunctionName extends 'bridge',
  TSelectData = ReadContractResult<
    typeof optimismMintableErc20FactoryGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof optimismMintableErc20FactoryGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & {
    chainId?: keyof typeof optimismMintableErc20FactoryGoerliAddress
  } = {} as any
) {
  return useContractRead({
    abi: optimismMintableErc20FactoryGoerliABI,
    address: optimismMintableErc20FactoryGoerliAddress[5],
    functionName: 'bridge',
    ...config,
  } as UseContractReadConfig<typeof optimismMintableErc20FactoryGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimismMintableErc20FactoryGoerliABI}__ and `functionName` set to `"version"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export function useOptimismMintableErc20FactoryGoerliVersion<
  TFunctionName extends 'version',
  TSelectData = ReadContractResult<
    typeof optimismMintableErc20FactoryGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof optimismMintableErc20FactoryGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & {
    chainId?: keyof typeof optimismMintableErc20FactoryGoerliAddress
  } = {} as any
) {
  return useContractRead({
    abi: optimismMintableErc20FactoryGoerliABI,
    address: optimismMintableErc20FactoryGoerliAddress[5],
    functionName: 'version',
    ...config,
  } as UseContractReadConfig<typeof optimismMintableErc20FactoryGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link optimismMintableErc20FactoryGoerliABI}__.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export function useOptimismMintableErc20FactoryGoerliWrite<
  TFunctionName extends string,
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof optimismMintableErc20FactoryGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof optimismMintableErc20FactoryGoerliABI,
          string
        >['request']['abi'],
        TFunctionName,
        TMode
      > & { address?: Address; chainId?: TChainId }
    : UseContractWriteConfig<
        typeof optimismMintableErc20FactoryGoerliABI,
        TFunctionName,
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
      } = {} as any
) {
  return useContractWrite<
    typeof optimismMintableErc20FactoryGoerliABI,
    TFunctionName,
    TMode
  >({
    abi: optimismMintableErc20FactoryGoerliABI,
    address: optimismMintableErc20FactoryGoerliAddress[5],
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link optimismMintableErc20FactoryGoerliABI}__ and `functionName` set to `"createOptimismMintableERC20"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export function useOptimismMintableErc20FactoryGoerliCreateOptimismMintableErc20<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof optimismMintableErc20FactoryGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof optimismMintableErc20FactoryGoerliABI,
          'createOptimismMintableERC20'
        >['request']['abi'],
        'createOptimismMintableERC20',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'createOptimismMintableERC20'
      }
    : UseContractWriteConfig<
        typeof optimismMintableErc20FactoryGoerliABI,
        'createOptimismMintableERC20',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'createOptimismMintableERC20'
      } = {} as any
) {
  return useContractWrite<
    typeof optimismMintableErc20FactoryGoerliABI,
    'createOptimismMintableERC20',
    TMode
  >({
    abi: optimismMintableErc20FactoryGoerliABI,
    address: optimismMintableErc20FactoryGoerliAddress[5],
    functionName: 'createOptimismMintableERC20',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link optimismMintableErc20FactoryGoerliABI}__ and `functionName` set to `"createOptimismMintableERC20WithDecimals"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export function useOptimismMintableErc20FactoryGoerliCreateOptimismMintableErc20WithDecimals<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof optimismMintableErc20FactoryGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof optimismMintableErc20FactoryGoerliABI,
          'createOptimismMintableERC20WithDecimals'
        >['request']['abi'],
        'createOptimismMintableERC20WithDecimals',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'createOptimismMintableERC20WithDecimals'
      }
    : UseContractWriteConfig<
        typeof optimismMintableErc20FactoryGoerliABI,
        'createOptimismMintableERC20WithDecimals',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'createOptimismMintableERC20WithDecimals'
      } = {} as any
) {
  return useContractWrite<
    typeof optimismMintableErc20FactoryGoerliABI,
    'createOptimismMintableERC20WithDecimals',
    TMode
  >({
    abi: optimismMintableErc20FactoryGoerliABI,
    address: optimismMintableErc20FactoryGoerliAddress[5],
    functionName: 'createOptimismMintableERC20WithDecimals',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link optimismMintableErc20FactoryGoerliABI}__ and `functionName` set to `"createStandardL2Token"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export function useOptimismMintableErc20FactoryGoerliCreateStandardL2Token<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof optimismMintableErc20FactoryGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof optimismMintableErc20FactoryGoerliABI,
          'createStandardL2Token'
        >['request']['abi'],
        'createStandardL2Token',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'createStandardL2Token'
      }
    : UseContractWriteConfig<
        typeof optimismMintableErc20FactoryGoerliABI,
        'createStandardL2Token',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'createStandardL2Token'
      } = {} as any
) {
  return useContractWrite<
    typeof optimismMintableErc20FactoryGoerliABI,
    'createStandardL2Token',
    TMode
  >({
    abi: optimismMintableErc20FactoryGoerliABI,
    address: optimismMintableErc20FactoryGoerliAddress[5],
    functionName: 'createStandardL2Token',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link optimismMintableErc20FactoryGoerliABI}__ and `functionName` set to `"initialize"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export function useOptimismMintableErc20FactoryGoerliInitialize<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof optimismMintableErc20FactoryGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof optimismMintableErc20FactoryGoerliABI,
          'initialize'
        >['request']['abi'],
        'initialize',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'initialize' }
    : UseContractWriteConfig<
        typeof optimismMintableErc20FactoryGoerliABI,
        'initialize',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'initialize'
      } = {} as any
) {
  return useContractWrite<
    typeof optimismMintableErc20FactoryGoerliABI,
    'initialize',
    TMode
  >({
    abi: optimismMintableErc20FactoryGoerliABI,
    address: optimismMintableErc20FactoryGoerliAddress[5],
    functionName: 'initialize',
    ...config,
  } as any)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link optimismMintableErc20FactoryGoerliABI}__.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export function usePrepareOptimismMintableErc20FactoryGoerliWrite<
  TFunctionName extends string
>(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof optimismMintableErc20FactoryGoerliABI,
      TFunctionName
    >,
    'abi' | 'address'
  > & {
    chainId?: keyof typeof optimismMintableErc20FactoryGoerliAddress
  } = {} as any
) {
  return usePrepareContractWrite({
    abi: optimismMintableErc20FactoryGoerliABI,
    address: optimismMintableErc20FactoryGoerliAddress[5],
    ...config,
  } as UsePrepareContractWriteConfig<typeof optimismMintableErc20FactoryGoerliABI, TFunctionName>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link optimismMintableErc20FactoryGoerliABI}__ and `functionName` set to `"createOptimismMintableERC20"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export function usePrepareOptimismMintableErc20FactoryGoerliCreateOptimismMintableErc20(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof optimismMintableErc20FactoryGoerliABI,
      'createOptimismMintableERC20'
    >,
    'abi' | 'address' | 'functionName'
  > & {
    chainId?: keyof typeof optimismMintableErc20FactoryGoerliAddress
  } = {} as any
) {
  return usePrepareContractWrite({
    abi: optimismMintableErc20FactoryGoerliABI,
    address: optimismMintableErc20FactoryGoerliAddress[5],
    functionName: 'createOptimismMintableERC20',
    ...config,
  } as UsePrepareContractWriteConfig<typeof optimismMintableErc20FactoryGoerliABI, 'createOptimismMintableERC20'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link optimismMintableErc20FactoryGoerliABI}__ and `functionName` set to `"createOptimismMintableERC20WithDecimals"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export function usePrepareOptimismMintableErc20FactoryGoerliCreateOptimismMintableErc20WithDecimals(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof optimismMintableErc20FactoryGoerliABI,
      'createOptimismMintableERC20WithDecimals'
    >,
    'abi' | 'address' | 'functionName'
  > & {
    chainId?: keyof typeof optimismMintableErc20FactoryGoerliAddress
  } = {} as any
) {
  return usePrepareContractWrite({
    abi: optimismMintableErc20FactoryGoerliABI,
    address: optimismMintableErc20FactoryGoerliAddress[5],
    functionName: 'createOptimismMintableERC20WithDecimals',
    ...config,
  } as UsePrepareContractWriteConfig<typeof optimismMintableErc20FactoryGoerliABI, 'createOptimismMintableERC20WithDecimals'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link optimismMintableErc20FactoryGoerliABI}__ and `functionName` set to `"createStandardL2Token"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export function usePrepareOptimismMintableErc20FactoryGoerliCreateStandardL2Token(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof optimismMintableErc20FactoryGoerliABI,
      'createStandardL2Token'
    >,
    'abi' | 'address' | 'functionName'
  > & {
    chainId?: keyof typeof optimismMintableErc20FactoryGoerliAddress
  } = {} as any
) {
  return usePrepareContractWrite({
    abi: optimismMintableErc20FactoryGoerliABI,
    address: optimismMintableErc20FactoryGoerliAddress[5],
    functionName: 'createStandardL2Token',
    ...config,
  } as UsePrepareContractWriteConfig<typeof optimismMintableErc20FactoryGoerliABI, 'createStandardL2Token'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link optimismMintableErc20FactoryGoerliABI}__ and `functionName` set to `"initialize"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export function usePrepareOptimismMintableErc20FactoryGoerliInitialize(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof optimismMintableErc20FactoryGoerliABI,
      'initialize'
    >,
    'abi' | 'address' | 'functionName'
  > & {
    chainId?: keyof typeof optimismMintableErc20FactoryGoerliAddress
  } = {} as any
) {
  return usePrepareContractWrite({
    abi: optimismMintableErc20FactoryGoerliABI,
    address: optimismMintableErc20FactoryGoerliAddress[5],
    functionName: 'initialize',
    ...config,
  } as UsePrepareContractWriteConfig<typeof optimismMintableErc20FactoryGoerliABI, 'initialize'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link optimismMintableErc20FactoryGoerliABI}__.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export function useOptimismMintableErc20FactoryGoerliEvent<
  TEventName extends string
>(
  config: Omit<
    UseContractEventConfig<
      typeof optimismMintableErc20FactoryGoerliABI,
      TEventName
    >,
    'abi' | 'address'
  > & {
    chainId?: keyof typeof optimismMintableErc20FactoryGoerliAddress
  } = {} as any
) {
  return useContractEvent({
    abi: optimismMintableErc20FactoryGoerliABI,
    address: optimismMintableErc20FactoryGoerliAddress[5],
    ...config,
  } as UseContractEventConfig<typeof optimismMintableErc20FactoryGoerliABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link optimismMintableErc20FactoryGoerliABI}__ and `eventName` set to `"Initialized"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export function useOptimismMintableErc20FactoryGoerliInitializedEvent(
  config: Omit<
    UseContractEventConfig<
      typeof optimismMintableErc20FactoryGoerliABI,
      'Initialized'
    >,
    'abi' | 'address' | 'eventName'
  > & {
    chainId?: keyof typeof optimismMintableErc20FactoryGoerliAddress
  } = {} as any
) {
  return useContractEvent({
    abi: optimismMintableErc20FactoryGoerliABI,
    address: optimismMintableErc20FactoryGoerliAddress[5],
    eventName: 'Initialized',
    ...config,
  } as UseContractEventConfig<typeof optimismMintableErc20FactoryGoerliABI, 'Initialized'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link optimismMintableErc20FactoryGoerliABI}__ and `eventName` set to `"OptimismMintableERC20Created"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export function useOptimismMintableErc20FactoryGoerliOptimismMintableErc20CreatedEvent(
  config: Omit<
    UseContractEventConfig<
      typeof optimismMintableErc20FactoryGoerliABI,
      'OptimismMintableERC20Created'
    >,
    'abi' | 'address' | 'eventName'
  > & {
    chainId?: keyof typeof optimismMintableErc20FactoryGoerliAddress
  } = {} as any
) {
  return useContractEvent({
    abi: optimismMintableErc20FactoryGoerliABI,
    address: optimismMintableErc20FactoryGoerliAddress[5],
    eventName: 'OptimismMintableERC20Created',
    ...config,
  } as UseContractEventConfig<typeof optimismMintableErc20FactoryGoerliABI, 'OptimismMintableERC20Created'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link optimismMintableErc20FactoryGoerliABI}__ and `eventName` set to `"StandardL2TokenCreated"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export function useOptimismMintableErc20FactoryGoerliStandardL2TokenCreatedEvent(
  config: Omit<
    UseContractEventConfig<
      typeof optimismMintableErc20FactoryGoerliABI,
      'StandardL2TokenCreated'
    >,
    'abi' | 'address' | 'eventName'
  > & {
    chainId?: keyof typeof optimismMintableErc20FactoryGoerliAddress
  } = {} as any
) {
  return useContractEvent({
    abi: optimismMintableErc20FactoryGoerliABI,
    address: optimismMintableErc20FactoryGoerliAddress[5],
    eventName: 'StandardL2TokenCreated',
    ...config,
  } as UseContractEventConfig<typeof optimismMintableErc20FactoryGoerliABI, 'StandardL2TokenCreated'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimismMintableErc20FactoryOptimismGoerliABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export function useOptimismMintableErc20FactoryOptimismGoerliRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<
    typeof optimismMintableErc20FactoryOptimismGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof optimismMintableErc20FactoryOptimismGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address'
  > & {
    chainId?: keyof typeof optimismMintableErc20FactoryOptimismGoerliAddress
  } = {} as any
) {
  return useContractRead({
    abi: optimismMintableErc20FactoryOptimismGoerliABI,
    address: optimismMintableErc20FactoryOptimismGoerliAddress[420],
    ...config,
  } as UseContractReadConfig<typeof optimismMintableErc20FactoryOptimismGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimismMintableErc20FactoryOptimismGoerliABI}__ and `functionName` set to `"BRIDGE"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export function useOptimismMintableErc20FactoryOptimismGoerliBridge<
  TFunctionName extends 'BRIDGE',
  TSelectData = ReadContractResult<
    typeof optimismMintableErc20FactoryOptimismGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof optimismMintableErc20FactoryOptimismGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & {
    chainId?: keyof typeof optimismMintableErc20FactoryOptimismGoerliAddress
  } = {} as any
) {
  return useContractRead({
    abi: optimismMintableErc20FactoryOptimismGoerliABI,
    address: optimismMintableErc20FactoryOptimismGoerliAddress[420],
    functionName: 'BRIDGE',
    ...config,
  } as UseContractReadConfig<typeof optimismMintableErc20FactoryOptimismGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimismMintableErc20FactoryOptimismGoerliABI}__ and `functionName` set to `"version"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export function useOptimismMintableErc20FactoryOptimismGoerliVersion<
  TFunctionName extends 'version',
  TSelectData = ReadContractResult<
    typeof optimismMintableErc20FactoryOptimismGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof optimismMintableErc20FactoryOptimismGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & {
    chainId?: keyof typeof optimismMintableErc20FactoryOptimismGoerliAddress
  } = {} as any
) {
  return useContractRead({
    abi: optimismMintableErc20FactoryOptimismGoerliABI,
    address: optimismMintableErc20FactoryOptimismGoerliAddress[420],
    functionName: 'version',
    ...config,
  } as UseContractReadConfig<typeof optimismMintableErc20FactoryOptimismGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link optimismMintableErc20FactoryOptimismGoerliABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export function useOptimismMintableErc20FactoryOptimismGoerliWrite<
  TFunctionName extends string,
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof optimismMintableErc20FactoryOptimismGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof optimismMintableErc20FactoryOptimismGoerliABI,
          string
        >['request']['abi'],
        TFunctionName,
        TMode
      > & { address?: Address; chainId?: TChainId }
    : UseContractWriteConfig<
        typeof optimismMintableErc20FactoryOptimismGoerliABI,
        TFunctionName,
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
      } = {} as any
) {
  return useContractWrite<
    typeof optimismMintableErc20FactoryOptimismGoerliABI,
    TFunctionName,
    TMode
  >({
    abi: optimismMintableErc20FactoryOptimismGoerliABI,
    address: optimismMintableErc20FactoryOptimismGoerliAddress[420],
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link optimismMintableErc20FactoryOptimismGoerliABI}__ and `functionName` set to `"createOptimismMintableERC20"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export function useOptimismMintableErc20FactoryOptimismGoerliCreateOptimismMintableErc20<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof optimismMintableErc20FactoryOptimismGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof optimismMintableErc20FactoryOptimismGoerliABI,
          'createOptimismMintableERC20'
        >['request']['abi'],
        'createOptimismMintableERC20',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'createOptimismMintableERC20'
      }
    : UseContractWriteConfig<
        typeof optimismMintableErc20FactoryOptimismGoerliABI,
        'createOptimismMintableERC20',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'createOptimismMintableERC20'
      } = {} as any
) {
  return useContractWrite<
    typeof optimismMintableErc20FactoryOptimismGoerliABI,
    'createOptimismMintableERC20',
    TMode
  >({
    abi: optimismMintableErc20FactoryOptimismGoerliABI,
    address: optimismMintableErc20FactoryOptimismGoerliAddress[420],
    functionName: 'createOptimismMintableERC20',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link optimismMintableErc20FactoryOptimismGoerliABI}__ and `functionName` set to `"createStandardL2Token"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export function useOptimismMintableErc20FactoryOptimismGoerliCreateStandardL2Token<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof optimismMintableErc20FactoryOptimismGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof optimismMintableErc20FactoryOptimismGoerliABI,
          'createStandardL2Token'
        >['request']['abi'],
        'createStandardL2Token',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'createStandardL2Token'
      }
    : UseContractWriteConfig<
        typeof optimismMintableErc20FactoryOptimismGoerliABI,
        'createStandardL2Token',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'createStandardL2Token'
      } = {} as any
) {
  return useContractWrite<
    typeof optimismMintableErc20FactoryOptimismGoerliABI,
    'createStandardL2Token',
    TMode
  >({
    abi: optimismMintableErc20FactoryOptimismGoerliABI,
    address: optimismMintableErc20FactoryOptimismGoerliAddress[420],
    functionName: 'createStandardL2Token',
    ...config,
  } as any)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link optimismMintableErc20FactoryOptimismGoerliABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export function usePrepareOptimismMintableErc20FactoryOptimismGoerliWrite<
  TFunctionName extends string
>(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof optimismMintableErc20FactoryOptimismGoerliABI,
      TFunctionName
    >,
    'abi' | 'address'
  > & {
    chainId?: keyof typeof optimismMintableErc20FactoryOptimismGoerliAddress
  } = {} as any
) {
  return usePrepareContractWrite({
    abi: optimismMintableErc20FactoryOptimismGoerliABI,
    address: optimismMintableErc20FactoryOptimismGoerliAddress[420],
    ...config,
  } as UsePrepareContractWriteConfig<typeof optimismMintableErc20FactoryOptimismGoerliABI, TFunctionName>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link optimismMintableErc20FactoryOptimismGoerliABI}__ and `functionName` set to `"createOptimismMintableERC20"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export function usePrepareOptimismMintableErc20FactoryOptimismGoerliCreateOptimismMintableErc20(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof optimismMintableErc20FactoryOptimismGoerliABI,
      'createOptimismMintableERC20'
    >,
    'abi' | 'address' | 'functionName'
  > & {
    chainId?: keyof typeof optimismMintableErc20FactoryOptimismGoerliAddress
  } = {} as any
) {
  return usePrepareContractWrite({
    abi: optimismMintableErc20FactoryOptimismGoerliABI,
    address: optimismMintableErc20FactoryOptimismGoerliAddress[420],
    functionName: 'createOptimismMintableERC20',
    ...config,
  } as UsePrepareContractWriteConfig<typeof optimismMintableErc20FactoryOptimismGoerliABI, 'createOptimismMintableERC20'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link optimismMintableErc20FactoryOptimismGoerliABI}__ and `functionName` set to `"createStandardL2Token"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export function usePrepareOptimismMintableErc20FactoryOptimismGoerliCreateStandardL2Token(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof optimismMintableErc20FactoryOptimismGoerliABI,
      'createStandardL2Token'
    >,
    'abi' | 'address' | 'functionName'
  > & {
    chainId?: keyof typeof optimismMintableErc20FactoryOptimismGoerliAddress
  } = {} as any
) {
  return usePrepareContractWrite({
    abi: optimismMintableErc20FactoryOptimismGoerliABI,
    address: optimismMintableErc20FactoryOptimismGoerliAddress[420],
    functionName: 'createStandardL2Token',
    ...config,
  } as UsePrepareContractWriteConfig<typeof optimismMintableErc20FactoryOptimismGoerliABI, 'createStandardL2Token'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link optimismMintableErc20FactoryOptimismGoerliABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export function useOptimismMintableErc20FactoryOptimismGoerliEvent<
  TEventName extends string
>(
  config: Omit<
    UseContractEventConfig<
      typeof optimismMintableErc20FactoryOptimismGoerliABI,
      TEventName
    >,
    'abi' | 'address'
  > & {
    chainId?: keyof typeof optimismMintableErc20FactoryOptimismGoerliAddress
  } = {} as any
) {
  return useContractEvent({
    abi: optimismMintableErc20FactoryOptimismGoerliABI,
    address: optimismMintableErc20FactoryOptimismGoerliAddress[420],
    ...config,
  } as UseContractEventConfig<typeof optimismMintableErc20FactoryOptimismGoerliABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link optimismMintableErc20FactoryOptimismGoerliABI}__ and `eventName` set to `"OptimismMintableERC20Created"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export function useOptimismMintableErc20FactoryOptimismGoerliOptimismMintableErc20CreatedEvent(
  config: Omit<
    UseContractEventConfig<
      typeof optimismMintableErc20FactoryOptimismGoerliABI,
      'OptimismMintableERC20Created'
    >,
    'abi' | 'address' | 'eventName'
  > & {
    chainId?: keyof typeof optimismMintableErc20FactoryOptimismGoerliAddress
  } = {} as any
) {
  return useContractEvent({
    abi: optimismMintableErc20FactoryOptimismGoerliABI,
    address: optimismMintableErc20FactoryOptimismGoerliAddress[420],
    eventName: 'OptimismMintableERC20Created',
    ...config,
  } as UseContractEventConfig<typeof optimismMintableErc20FactoryOptimismGoerliABI, 'OptimismMintableERC20Created'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link optimismMintableErc20FactoryOptimismGoerliABI}__ and `eventName` set to `"StandardL2TokenCreated"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export function useOptimismMintableErc20FactoryOptimismGoerliStandardL2TokenCreatedEvent(
  config: Omit<
    UseContractEventConfig<
      typeof optimismMintableErc20FactoryOptimismGoerliABI,
      'StandardL2TokenCreated'
    >,
    'abi' | 'address' | 'eventName'
  > & {
    chainId?: keyof typeof optimismMintableErc20FactoryOptimismGoerliAddress
  } = {} as any
) {
  return useContractEvent({
    abi: optimismMintableErc20FactoryOptimismGoerliABI,
    address: optimismMintableErc20FactoryOptimismGoerliAddress[420],
    eventName: 'StandardL2TokenCreated',
    ...config,
  } as UseContractEventConfig<typeof optimismMintableErc20FactoryOptimismGoerliABI, 'StandardL2TokenCreated'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimismMintableErc721FactoryABI}__.
 *
 * [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000017)
 */
export function useOptimismMintableErc721FactoryRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<
    typeof optimismMintableErc721FactoryABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof optimismMintableErc721FactoryABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address'
  > & {
    chainId?: keyof typeof optimismMintableErc721FactoryAddress
  } = {} as any
) {
  return useContractRead({
    abi: optimismMintableErc721FactoryABI,
    address: optimismMintableErc721FactoryAddress[10],
    ...config,
  } as UseContractReadConfig<typeof optimismMintableErc721FactoryABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimismMintableErc721FactoryABI}__ and `functionName` set to `"bridge"`.
 *
 * [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000017)
 */
export function useOptimismMintableErc721FactoryBridge<
  TFunctionName extends 'bridge',
  TSelectData = ReadContractResult<
    typeof optimismMintableErc721FactoryABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof optimismMintableErc721FactoryABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & {
    chainId?: keyof typeof optimismMintableErc721FactoryAddress
  } = {} as any
) {
  return useContractRead({
    abi: optimismMintableErc721FactoryABI,
    address: optimismMintableErc721FactoryAddress[10],
    functionName: 'bridge',
    ...config,
  } as UseContractReadConfig<typeof optimismMintableErc721FactoryABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimismMintableErc721FactoryABI}__ and `functionName` set to `"isOptimismMintableERC721"`.
 *
 * [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000017)
 */
export function useOptimismMintableErc721FactoryIsOptimismMintableErc721<
  TFunctionName extends 'isOptimismMintableERC721',
  TSelectData = ReadContractResult<
    typeof optimismMintableErc721FactoryABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof optimismMintableErc721FactoryABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & {
    chainId?: keyof typeof optimismMintableErc721FactoryAddress
  } = {} as any
) {
  return useContractRead({
    abi: optimismMintableErc721FactoryABI,
    address: optimismMintableErc721FactoryAddress[10],
    functionName: 'isOptimismMintableERC721',
    ...config,
  } as UseContractReadConfig<typeof optimismMintableErc721FactoryABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimismMintableErc721FactoryABI}__ and `functionName` set to `"remoteChainId"`.
 *
 * [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000017)
 */
export function useOptimismMintableErc721FactoryRemoteChainId<
  TFunctionName extends 'remoteChainId',
  TSelectData = ReadContractResult<
    typeof optimismMintableErc721FactoryABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof optimismMintableErc721FactoryABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & {
    chainId?: keyof typeof optimismMintableErc721FactoryAddress
  } = {} as any
) {
  return useContractRead({
    abi: optimismMintableErc721FactoryABI,
    address: optimismMintableErc721FactoryAddress[10],
    functionName: 'remoteChainId',
    ...config,
  } as UseContractReadConfig<typeof optimismMintableErc721FactoryABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimismMintableErc721FactoryABI}__ and `functionName` set to `"version"`.
 *
 * [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000017)
 */
export function useOptimismMintableErc721FactoryVersion<
  TFunctionName extends 'version',
  TSelectData = ReadContractResult<
    typeof optimismMintableErc721FactoryABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof optimismMintableErc721FactoryABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & {
    chainId?: keyof typeof optimismMintableErc721FactoryAddress
  } = {} as any
) {
  return useContractRead({
    abi: optimismMintableErc721FactoryABI,
    address: optimismMintableErc721FactoryAddress[10],
    functionName: 'version',
    ...config,
  } as UseContractReadConfig<typeof optimismMintableErc721FactoryABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link optimismMintableErc721FactoryABI}__.
 *
 * [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000017)
 */
export function useOptimismMintableErc721FactoryWrite<
  TFunctionName extends string,
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof optimismMintableErc721FactoryAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof optimismMintableErc721FactoryABI,
          string
        >['request']['abi'],
        TFunctionName,
        TMode
      > & { address?: Address; chainId?: TChainId }
    : UseContractWriteConfig<
        typeof optimismMintableErc721FactoryABI,
        TFunctionName,
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
      } = {} as any
) {
  return useContractWrite<
    typeof optimismMintableErc721FactoryABI,
    TFunctionName,
    TMode
  >({
    abi: optimismMintableErc721FactoryABI,
    address: optimismMintableErc721FactoryAddress[10],
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link optimismMintableErc721FactoryABI}__ and `functionName` set to `"createOptimismMintableERC721"`.
 *
 * [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000017)
 */
export function useOptimismMintableErc721FactoryCreateOptimismMintableErc721<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof optimismMintableErc721FactoryAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof optimismMintableErc721FactoryABI,
          'createOptimismMintableERC721'
        >['request']['abi'],
        'createOptimismMintableERC721',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'createOptimismMintableERC721'
      }
    : UseContractWriteConfig<
        typeof optimismMintableErc721FactoryABI,
        'createOptimismMintableERC721',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'createOptimismMintableERC721'
      } = {} as any
) {
  return useContractWrite<
    typeof optimismMintableErc721FactoryABI,
    'createOptimismMintableERC721',
    TMode
  >({
    abi: optimismMintableErc721FactoryABI,
    address: optimismMintableErc721FactoryAddress[10],
    functionName: 'createOptimismMintableERC721',
    ...config,
  } as any)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link optimismMintableErc721FactoryABI}__.
 *
 * [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000017)
 */
export function usePrepareOptimismMintableErc721FactoryWrite<
  TFunctionName extends string
>(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof optimismMintableErc721FactoryABI,
      TFunctionName
    >,
    'abi' | 'address'
  > & {
    chainId?: keyof typeof optimismMintableErc721FactoryAddress
  } = {} as any
) {
  return usePrepareContractWrite({
    abi: optimismMintableErc721FactoryABI,
    address: optimismMintableErc721FactoryAddress[10],
    ...config,
  } as UsePrepareContractWriteConfig<typeof optimismMintableErc721FactoryABI, TFunctionName>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link optimismMintableErc721FactoryABI}__ and `functionName` set to `"createOptimismMintableERC721"`.
 *
 * [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000017)
 */
export function usePrepareOptimismMintableErc721FactoryCreateOptimismMintableErc721(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof optimismMintableErc721FactoryABI,
      'createOptimismMintableERC721'
    >,
    'abi' | 'address' | 'functionName'
  > & {
    chainId?: keyof typeof optimismMintableErc721FactoryAddress
  } = {} as any
) {
  return usePrepareContractWrite({
    abi: optimismMintableErc721FactoryABI,
    address: optimismMintableErc721FactoryAddress[10],
    functionName: 'createOptimismMintableERC721',
    ...config,
  } as UsePrepareContractWriteConfig<typeof optimismMintableErc721FactoryABI, 'createOptimismMintableERC721'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link optimismMintableErc721FactoryABI}__.
 *
 * [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000017)
 */
export function useOptimismMintableErc721FactoryEvent<
  TEventName extends string
>(
  config: Omit<
    UseContractEventConfig<typeof optimismMintableErc721FactoryABI, TEventName>,
    'abi' | 'address'
  > & {
    chainId?: keyof typeof optimismMintableErc721FactoryAddress
  } = {} as any
) {
  return useContractEvent({
    abi: optimismMintableErc721FactoryABI,
    address: optimismMintableErc721FactoryAddress[10],
    ...config,
  } as UseContractEventConfig<typeof optimismMintableErc721FactoryABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link optimismMintableErc721FactoryABI}__ and `eventName` set to `"OptimismMintableERC721Created"`.
 *
 * [__View Contract on Op Mainnet Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000017)
 */
export function useOptimismMintableErc721FactoryOptimismMintableErc721CreatedEvent(
  config: Omit<
    UseContractEventConfig<
      typeof optimismMintableErc721FactoryABI,
      'OptimismMintableERC721Created'
    >,
    'abi' | 'address' | 'eventName'
  > & {
    chainId?: keyof typeof optimismMintableErc721FactoryAddress
  } = {} as any
) {
  return useContractEvent({
    abi: optimismMintableErc721FactoryABI,
    address: optimismMintableErc721FactoryAddress[10],
    eventName: 'OptimismMintableERC721Created',
    ...config,
  } as UseContractEventConfig<typeof optimismMintableErc721FactoryABI, 'OptimismMintableERC721Created'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimismMintableErc721FactoryOptimismGoerliABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000017)
 */
export function useOptimismMintableErc721FactoryOptimismGoerliRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<
    typeof optimismMintableErc721FactoryOptimismGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof optimismMintableErc721FactoryOptimismGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address'
  > & {
    chainId?: keyof typeof optimismMintableErc721FactoryOptimismGoerliAddress
  } = {} as any
) {
  return useContractRead({
    abi: optimismMintableErc721FactoryOptimismGoerliABI,
    address: optimismMintableErc721FactoryOptimismGoerliAddress[420],
    ...config,
  } as UseContractReadConfig<typeof optimismMintableErc721FactoryOptimismGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimismMintableErc721FactoryOptimismGoerliABI}__ and `functionName` set to `"BRIDGE"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000017)
 */
export function useOptimismMintableErc721FactoryOptimismGoerliBridge<
  TFunctionName extends 'BRIDGE',
  TSelectData = ReadContractResult<
    typeof optimismMintableErc721FactoryOptimismGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof optimismMintableErc721FactoryOptimismGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & {
    chainId?: keyof typeof optimismMintableErc721FactoryOptimismGoerliAddress
  } = {} as any
) {
  return useContractRead({
    abi: optimismMintableErc721FactoryOptimismGoerliABI,
    address: optimismMintableErc721FactoryOptimismGoerliAddress[420],
    functionName: 'BRIDGE',
    ...config,
  } as UseContractReadConfig<typeof optimismMintableErc721FactoryOptimismGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimismMintableErc721FactoryOptimismGoerliABI}__ and `functionName` set to `"REMOTE_CHAIN_ID"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000017)
 */
export function useOptimismMintableErc721FactoryOptimismGoerliRemoteChainId<
  TFunctionName extends 'REMOTE_CHAIN_ID',
  TSelectData = ReadContractResult<
    typeof optimismMintableErc721FactoryOptimismGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof optimismMintableErc721FactoryOptimismGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & {
    chainId?: keyof typeof optimismMintableErc721FactoryOptimismGoerliAddress
  } = {} as any
) {
  return useContractRead({
    abi: optimismMintableErc721FactoryOptimismGoerliABI,
    address: optimismMintableErc721FactoryOptimismGoerliAddress[420],
    functionName: 'REMOTE_CHAIN_ID',
    ...config,
  } as UseContractReadConfig<typeof optimismMintableErc721FactoryOptimismGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimismMintableErc721FactoryOptimismGoerliABI}__ and `functionName` set to `"isOptimismMintableERC721"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000017)
 */
export function useOptimismMintableErc721FactoryOptimismGoerliIsOptimismMintableErc721<
  TFunctionName extends 'isOptimismMintableERC721',
  TSelectData = ReadContractResult<
    typeof optimismMintableErc721FactoryOptimismGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof optimismMintableErc721FactoryOptimismGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & {
    chainId?: keyof typeof optimismMintableErc721FactoryOptimismGoerliAddress
  } = {} as any
) {
  return useContractRead({
    abi: optimismMintableErc721FactoryOptimismGoerliABI,
    address: optimismMintableErc721FactoryOptimismGoerliAddress[420],
    functionName: 'isOptimismMintableERC721',
    ...config,
  } as UseContractReadConfig<typeof optimismMintableErc721FactoryOptimismGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimismMintableErc721FactoryOptimismGoerliABI}__ and `functionName` set to `"version"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000017)
 */
export function useOptimismMintableErc721FactoryOptimismGoerliVersion<
  TFunctionName extends 'version',
  TSelectData = ReadContractResult<
    typeof optimismMintableErc721FactoryOptimismGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof optimismMintableErc721FactoryOptimismGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & {
    chainId?: keyof typeof optimismMintableErc721FactoryOptimismGoerliAddress
  } = {} as any
) {
  return useContractRead({
    abi: optimismMintableErc721FactoryOptimismGoerliABI,
    address: optimismMintableErc721FactoryOptimismGoerliAddress[420],
    functionName: 'version',
    ...config,
  } as UseContractReadConfig<typeof optimismMintableErc721FactoryOptimismGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link optimismMintableErc721FactoryOptimismGoerliABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000017)
 */
export function useOptimismMintableErc721FactoryOptimismGoerliWrite<
  TFunctionName extends string,
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof optimismMintableErc721FactoryOptimismGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof optimismMintableErc721FactoryOptimismGoerliABI,
          string
        >['request']['abi'],
        TFunctionName,
        TMode
      > & { address?: Address; chainId?: TChainId }
    : UseContractWriteConfig<
        typeof optimismMintableErc721FactoryOptimismGoerliABI,
        TFunctionName,
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
      } = {} as any
) {
  return useContractWrite<
    typeof optimismMintableErc721FactoryOptimismGoerliABI,
    TFunctionName,
    TMode
  >({
    abi: optimismMintableErc721FactoryOptimismGoerliABI,
    address: optimismMintableErc721FactoryOptimismGoerliAddress[420],
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link optimismMintableErc721FactoryOptimismGoerliABI}__ and `functionName` set to `"createOptimismMintableERC721"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000017)
 */
export function useOptimismMintableErc721FactoryOptimismGoerliCreateOptimismMintableErc721<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof optimismMintableErc721FactoryOptimismGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof optimismMintableErc721FactoryOptimismGoerliABI,
          'createOptimismMintableERC721'
        >['request']['abi'],
        'createOptimismMintableERC721',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'createOptimismMintableERC721'
      }
    : UseContractWriteConfig<
        typeof optimismMintableErc721FactoryOptimismGoerliABI,
        'createOptimismMintableERC721',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'createOptimismMintableERC721'
      } = {} as any
) {
  return useContractWrite<
    typeof optimismMintableErc721FactoryOptimismGoerliABI,
    'createOptimismMintableERC721',
    TMode
  >({
    abi: optimismMintableErc721FactoryOptimismGoerliABI,
    address: optimismMintableErc721FactoryOptimismGoerliAddress[420],
    functionName: 'createOptimismMintableERC721',
    ...config,
  } as any)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link optimismMintableErc721FactoryOptimismGoerliABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000017)
 */
export function usePrepareOptimismMintableErc721FactoryOptimismGoerliWrite<
  TFunctionName extends string
>(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof optimismMintableErc721FactoryOptimismGoerliABI,
      TFunctionName
    >,
    'abi' | 'address'
  > & {
    chainId?: keyof typeof optimismMintableErc721FactoryOptimismGoerliAddress
  } = {} as any
) {
  return usePrepareContractWrite({
    abi: optimismMintableErc721FactoryOptimismGoerliABI,
    address: optimismMintableErc721FactoryOptimismGoerliAddress[420],
    ...config,
  } as UsePrepareContractWriteConfig<typeof optimismMintableErc721FactoryOptimismGoerliABI, TFunctionName>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link optimismMintableErc721FactoryOptimismGoerliABI}__ and `functionName` set to `"createOptimismMintableERC721"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000017)
 */
export function usePrepareOptimismMintableErc721FactoryOptimismGoerliCreateOptimismMintableErc721(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof optimismMintableErc721FactoryOptimismGoerliABI,
      'createOptimismMintableERC721'
    >,
    'abi' | 'address' | 'functionName'
  > & {
    chainId?: keyof typeof optimismMintableErc721FactoryOptimismGoerliAddress
  } = {} as any
) {
  return usePrepareContractWrite({
    abi: optimismMintableErc721FactoryOptimismGoerliABI,
    address: optimismMintableErc721FactoryOptimismGoerliAddress[420],
    functionName: 'createOptimismMintableERC721',
    ...config,
  } as UsePrepareContractWriteConfig<typeof optimismMintableErc721FactoryOptimismGoerliABI, 'createOptimismMintableERC721'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link optimismMintableErc721FactoryOptimismGoerliABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000017)
 */
export function useOptimismMintableErc721FactoryOptimismGoerliEvent<
  TEventName extends string
>(
  config: Omit<
    UseContractEventConfig<
      typeof optimismMintableErc721FactoryOptimismGoerliABI,
      TEventName
    >,
    'abi' | 'address'
  > & {
    chainId?: keyof typeof optimismMintableErc721FactoryOptimismGoerliAddress
  } = {} as any
) {
  return useContractEvent({
    abi: optimismMintableErc721FactoryOptimismGoerliABI,
    address: optimismMintableErc721FactoryOptimismGoerliAddress[420],
    ...config,
  } as UseContractEventConfig<typeof optimismMintableErc721FactoryOptimismGoerliABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link optimismMintableErc721FactoryOptimismGoerliABI}__ and `eventName` set to `"OptimismMintableERC721Created"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000017)
 */
export function useOptimismMintableErc721FactoryOptimismGoerliOptimismMintableErc721CreatedEvent(
  config: Omit<
    UseContractEventConfig<
      typeof optimismMintableErc721FactoryOptimismGoerliABI,
      'OptimismMintableERC721Created'
    >,
    'abi' | 'address' | 'eventName'
  > & {
    chainId?: keyof typeof optimismMintableErc721FactoryOptimismGoerliAddress
  } = {} as any
) {
  return useContractEvent({
    abi: optimismMintableErc721FactoryOptimismGoerliABI,
    address: optimismMintableErc721FactoryOptimismGoerliAddress[420],
    eventName: 'OptimismMintableERC721Created',
    ...config,
  } as UseContractEventConfig<typeof optimismMintableErc721FactoryOptimismGoerliABI, 'OptimismMintableERC721Created'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimismPortalABI}__.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 */
export function useOptimismPortalRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<typeof optimismPortalABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof optimismPortalABI, TFunctionName, TSelectData>,
    'abi' | 'address'
  > & { chainId?: keyof typeof optimismPortalAddress } = {} as any
) {
  return useContractRead({
    abi: optimismPortalABI,
    address: optimismPortalAddress[1],
    ...config,
  } as UseContractReadConfig<typeof optimismPortalABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimismPortalABI}__ and `functionName` set to `"GUARDIAN"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 */
export function useOptimismPortalGuardian<
  TFunctionName extends 'GUARDIAN',
  TSelectData = ReadContractResult<typeof optimismPortalABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof optimismPortalABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimismPortalAddress } = {} as any
) {
  return useContractRead({
    abi: optimismPortalABI,
    address: optimismPortalAddress[1],
    functionName: 'GUARDIAN',
    ...config,
  } as UseContractReadConfig<typeof optimismPortalABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimismPortalABI}__ and `functionName` set to `"L2_ORACLE"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 */
export function useOptimismPortalL2Oracle<
  TFunctionName extends 'L2_ORACLE',
  TSelectData = ReadContractResult<typeof optimismPortalABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof optimismPortalABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimismPortalAddress } = {} as any
) {
  return useContractRead({
    abi: optimismPortalABI,
    address: optimismPortalAddress[1],
    functionName: 'L2_ORACLE',
    ...config,
  } as UseContractReadConfig<typeof optimismPortalABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimismPortalABI}__ and `functionName` set to `"SYSTEM_CONFIG"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 */
export function useOptimismPortalSystemConfig<
  TFunctionName extends 'SYSTEM_CONFIG',
  TSelectData = ReadContractResult<typeof optimismPortalABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof optimismPortalABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimismPortalAddress } = {} as any
) {
  return useContractRead({
    abi: optimismPortalABI,
    address: optimismPortalAddress[1],
    functionName: 'SYSTEM_CONFIG',
    ...config,
  } as UseContractReadConfig<typeof optimismPortalABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimismPortalABI}__ and `functionName` set to `"finalizedWithdrawals"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 */
export function useOptimismPortalFinalizedWithdrawals<
  TFunctionName extends 'finalizedWithdrawals',
  TSelectData = ReadContractResult<typeof optimismPortalABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof optimismPortalABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimismPortalAddress } = {} as any
) {
  return useContractRead({
    abi: optimismPortalABI,
    address: optimismPortalAddress[1],
    functionName: 'finalizedWithdrawals',
    ...config,
  } as UseContractReadConfig<typeof optimismPortalABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimismPortalABI}__ and `functionName` set to `"isOutputFinalized"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 */
export function useOptimismPortalIsOutputFinalized<
  TFunctionName extends 'isOutputFinalized',
  TSelectData = ReadContractResult<typeof optimismPortalABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof optimismPortalABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimismPortalAddress } = {} as any
) {
  return useContractRead({
    abi: optimismPortalABI,
    address: optimismPortalAddress[1],
    functionName: 'isOutputFinalized',
    ...config,
  } as UseContractReadConfig<typeof optimismPortalABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimismPortalABI}__ and `functionName` set to `"l2Sender"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 */
export function useOptimismPortalL2Sender<
  TFunctionName extends 'l2Sender',
  TSelectData = ReadContractResult<typeof optimismPortalABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof optimismPortalABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimismPortalAddress } = {} as any
) {
  return useContractRead({
    abi: optimismPortalABI,
    address: optimismPortalAddress[1],
    functionName: 'l2Sender',
    ...config,
  } as UseContractReadConfig<typeof optimismPortalABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimismPortalABI}__ and `functionName` set to `"minimumGasLimit"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 */
export function useOptimismPortalMinimumGasLimit<
  TFunctionName extends 'minimumGasLimit',
  TSelectData = ReadContractResult<typeof optimismPortalABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof optimismPortalABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimismPortalAddress } = {} as any
) {
  return useContractRead({
    abi: optimismPortalABI,
    address: optimismPortalAddress[1],
    functionName: 'minimumGasLimit',
    ...config,
  } as UseContractReadConfig<typeof optimismPortalABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimismPortalABI}__ and `functionName` set to `"params"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 */
export function useOptimismPortalParams<
  TFunctionName extends 'params',
  TSelectData = ReadContractResult<typeof optimismPortalABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof optimismPortalABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimismPortalAddress } = {} as any
) {
  return useContractRead({
    abi: optimismPortalABI,
    address: optimismPortalAddress[1],
    functionName: 'params',
    ...config,
  } as UseContractReadConfig<typeof optimismPortalABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimismPortalABI}__ and `functionName` set to `"paused"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 */
export function useOptimismPortalPaused<
  TFunctionName extends 'paused',
  TSelectData = ReadContractResult<typeof optimismPortalABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof optimismPortalABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimismPortalAddress } = {} as any
) {
  return useContractRead({
    abi: optimismPortalABI,
    address: optimismPortalAddress[1],
    functionName: 'paused',
    ...config,
  } as UseContractReadConfig<typeof optimismPortalABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimismPortalABI}__ and `functionName` set to `"provenWithdrawals"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 */
export function useOptimismPortalProvenWithdrawals<
  TFunctionName extends 'provenWithdrawals',
  TSelectData = ReadContractResult<typeof optimismPortalABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof optimismPortalABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimismPortalAddress } = {} as any
) {
  return useContractRead({
    abi: optimismPortalABI,
    address: optimismPortalAddress[1],
    functionName: 'provenWithdrawals',
    ...config,
  } as UseContractReadConfig<typeof optimismPortalABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimismPortalABI}__ and `functionName` set to `"version"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 */
export function useOptimismPortalVersion<
  TFunctionName extends 'version',
  TSelectData = ReadContractResult<typeof optimismPortalABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof optimismPortalABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimismPortalAddress } = {} as any
) {
  return useContractRead({
    abi: optimismPortalABI,
    address: optimismPortalAddress[1],
    functionName: 'version',
    ...config,
  } as UseContractReadConfig<typeof optimismPortalABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link optimismPortalABI}__.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 */
export function useOptimismPortalWrite<
  TFunctionName extends string,
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof optimismPortalAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof optimismPortalABI,
          string
        >['request']['abi'],
        TFunctionName,
        TMode
      > & { address?: Address; chainId?: TChainId }
    : UseContractWriteConfig<typeof optimismPortalABI, TFunctionName, TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
      } = {} as any
) {
  return useContractWrite<typeof optimismPortalABI, TFunctionName, TMode>({
    abi: optimismPortalABI,
    address: optimismPortalAddress[1],
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link optimismPortalABI}__ and `functionName` set to `"depositTransaction"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 */
export function useOptimismPortalDepositTransaction<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof optimismPortalAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof optimismPortalABI,
          'depositTransaction'
        >['request']['abi'],
        'depositTransaction',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'depositTransaction'
      }
    : UseContractWriteConfig<
        typeof optimismPortalABI,
        'depositTransaction',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'depositTransaction'
      } = {} as any
) {
  return useContractWrite<
    typeof optimismPortalABI,
    'depositTransaction',
    TMode
  >({
    abi: optimismPortalABI,
    address: optimismPortalAddress[1],
    functionName: 'depositTransaction',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link optimismPortalABI}__ and `functionName` set to `"donateETH"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 */
export function useOptimismPortalDonateEth<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof optimismPortalAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof optimismPortalABI,
          'donateETH'
        >['request']['abi'],
        'donateETH',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'donateETH' }
    : UseContractWriteConfig<typeof optimismPortalABI, 'donateETH', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'donateETH'
      } = {} as any
) {
  return useContractWrite<typeof optimismPortalABI, 'donateETH', TMode>({
    abi: optimismPortalABI,
    address: optimismPortalAddress[1],
    functionName: 'donateETH',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link optimismPortalABI}__ and `functionName` set to `"finalizeWithdrawalTransaction"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 */
export function useOptimismPortalFinalizeWithdrawalTransaction<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof optimismPortalAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof optimismPortalABI,
          'finalizeWithdrawalTransaction'
        >['request']['abi'],
        'finalizeWithdrawalTransaction',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'finalizeWithdrawalTransaction'
      }
    : UseContractWriteConfig<
        typeof optimismPortalABI,
        'finalizeWithdrawalTransaction',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'finalizeWithdrawalTransaction'
      } = {} as any
) {
  return useContractWrite<
    typeof optimismPortalABI,
    'finalizeWithdrawalTransaction',
    TMode
  >({
    abi: optimismPortalABI,
    address: optimismPortalAddress[1],
    functionName: 'finalizeWithdrawalTransaction',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link optimismPortalABI}__ and `functionName` set to `"initialize"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 */
export function useOptimismPortalInitialize<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof optimismPortalAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof optimismPortalABI,
          'initialize'
        >['request']['abi'],
        'initialize',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'initialize' }
    : UseContractWriteConfig<typeof optimismPortalABI, 'initialize', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'initialize'
      } = {} as any
) {
  return useContractWrite<typeof optimismPortalABI, 'initialize', TMode>({
    abi: optimismPortalABI,
    address: optimismPortalAddress[1],
    functionName: 'initialize',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link optimismPortalABI}__ and `functionName` set to `"pause"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 */
export function useOptimismPortalPause<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof optimismPortalAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof optimismPortalABI,
          'pause'
        >['request']['abi'],
        'pause',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'pause' }
    : UseContractWriteConfig<typeof optimismPortalABI, 'pause', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'pause'
      } = {} as any
) {
  return useContractWrite<typeof optimismPortalABI, 'pause', TMode>({
    abi: optimismPortalABI,
    address: optimismPortalAddress[1],
    functionName: 'pause',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link optimismPortalABI}__ and `functionName` set to `"proveWithdrawalTransaction"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 */
export function useOptimismPortalProveWithdrawalTransaction<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof optimismPortalAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof optimismPortalABI,
          'proveWithdrawalTransaction'
        >['request']['abi'],
        'proveWithdrawalTransaction',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'proveWithdrawalTransaction'
      }
    : UseContractWriteConfig<
        typeof optimismPortalABI,
        'proveWithdrawalTransaction',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'proveWithdrawalTransaction'
      } = {} as any
) {
  return useContractWrite<
    typeof optimismPortalABI,
    'proveWithdrawalTransaction',
    TMode
  >({
    abi: optimismPortalABI,
    address: optimismPortalAddress[1],
    functionName: 'proveWithdrawalTransaction',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link optimismPortalABI}__ and `functionName` set to `"unpause"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 */
export function useOptimismPortalUnpause<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof optimismPortalAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof optimismPortalABI,
          'unpause'
        >['request']['abi'],
        'unpause',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'unpause' }
    : UseContractWriteConfig<typeof optimismPortalABI, 'unpause', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'unpause'
      } = {} as any
) {
  return useContractWrite<typeof optimismPortalABI, 'unpause', TMode>({
    abi: optimismPortalABI,
    address: optimismPortalAddress[1],
    functionName: 'unpause',
    ...config,
  } as any)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link optimismPortalABI}__.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 */
export function usePrepareOptimismPortalWrite<TFunctionName extends string>(
  config: Omit<
    UsePrepareContractWriteConfig<typeof optimismPortalABI, TFunctionName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof optimismPortalAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: optimismPortalABI,
    address: optimismPortalAddress[1],
    ...config,
  } as UsePrepareContractWriteConfig<typeof optimismPortalABI, TFunctionName>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link optimismPortalABI}__ and `functionName` set to `"depositTransaction"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 */
export function usePrepareOptimismPortalDepositTransaction(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof optimismPortalABI,
      'depositTransaction'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimismPortalAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: optimismPortalABI,
    address: optimismPortalAddress[1],
    functionName: 'depositTransaction',
    ...config,
  } as UsePrepareContractWriteConfig<typeof optimismPortalABI, 'depositTransaction'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link optimismPortalABI}__ and `functionName` set to `"donateETH"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 */
export function usePrepareOptimismPortalDonateEth(
  config: Omit<
    UsePrepareContractWriteConfig<typeof optimismPortalABI, 'donateETH'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimismPortalAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: optimismPortalABI,
    address: optimismPortalAddress[1],
    functionName: 'donateETH',
    ...config,
  } as UsePrepareContractWriteConfig<typeof optimismPortalABI, 'donateETH'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link optimismPortalABI}__ and `functionName` set to `"finalizeWithdrawalTransaction"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 */
export function usePrepareOptimismPortalFinalizeWithdrawalTransaction(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof optimismPortalABI,
      'finalizeWithdrawalTransaction'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimismPortalAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: optimismPortalABI,
    address: optimismPortalAddress[1],
    functionName: 'finalizeWithdrawalTransaction',
    ...config,
  } as UsePrepareContractWriteConfig<typeof optimismPortalABI, 'finalizeWithdrawalTransaction'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link optimismPortalABI}__ and `functionName` set to `"initialize"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 */
export function usePrepareOptimismPortalInitialize(
  config: Omit<
    UsePrepareContractWriteConfig<typeof optimismPortalABI, 'initialize'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimismPortalAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: optimismPortalABI,
    address: optimismPortalAddress[1],
    functionName: 'initialize',
    ...config,
  } as UsePrepareContractWriteConfig<typeof optimismPortalABI, 'initialize'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link optimismPortalABI}__ and `functionName` set to `"pause"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 */
export function usePrepareOptimismPortalPause(
  config: Omit<
    UsePrepareContractWriteConfig<typeof optimismPortalABI, 'pause'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimismPortalAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: optimismPortalABI,
    address: optimismPortalAddress[1],
    functionName: 'pause',
    ...config,
  } as UsePrepareContractWriteConfig<typeof optimismPortalABI, 'pause'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link optimismPortalABI}__ and `functionName` set to `"proveWithdrawalTransaction"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 */
export function usePrepareOptimismPortalProveWithdrawalTransaction(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof optimismPortalABI,
      'proveWithdrawalTransaction'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimismPortalAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: optimismPortalABI,
    address: optimismPortalAddress[1],
    functionName: 'proveWithdrawalTransaction',
    ...config,
  } as UsePrepareContractWriteConfig<typeof optimismPortalABI, 'proveWithdrawalTransaction'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link optimismPortalABI}__ and `functionName` set to `"unpause"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 */
export function usePrepareOptimismPortalUnpause(
  config: Omit<
    UsePrepareContractWriteConfig<typeof optimismPortalABI, 'unpause'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimismPortalAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: optimismPortalABI,
    address: optimismPortalAddress[1],
    functionName: 'unpause',
    ...config,
  } as UsePrepareContractWriteConfig<typeof optimismPortalABI, 'unpause'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link optimismPortalABI}__.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 */
export function useOptimismPortalEvent<TEventName extends string>(
  config: Omit<
    UseContractEventConfig<typeof optimismPortalABI, TEventName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof optimismPortalAddress } = {} as any
) {
  return useContractEvent({
    abi: optimismPortalABI,
    address: optimismPortalAddress[1],
    ...config,
  } as UseContractEventConfig<typeof optimismPortalABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link optimismPortalABI}__ and `eventName` set to `"Initialized"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 */
export function useOptimismPortalInitializedEvent(
  config: Omit<
    UseContractEventConfig<typeof optimismPortalABI, 'Initialized'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof optimismPortalAddress } = {} as any
) {
  return useContractEvent({
    abi: optimismPortalABI,
    address: optimismPortalAddress[1],
    eventName: 'Initialized',
    ...config,
  } as UseContractEventConfig<typeof optimismPortalABI, 'Initialized'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link optimismPortalABI}__ and `eventName` set to `"Paused"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 */
export function useOptimismPortalPausedEvent(
  config: Omit<
    UseContractEventConfig<typeof optimismPortalABI, 'Paused'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof optimismPortalAddress } = {} as any
) {
  return useContractEvent({
    abi: optimismPortalABI,
    address: optimismPortalAddress[1],
    eventName: 'Paused',
    ...config,
  } as UseContractEventConfig<typeof optimismPortalABI, 'Paused'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link optimismPortalABI}__ and `eventName` set to `"TransactionDeposited"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 */
export function useOptimismPortalTransactionDepositedEvent(
  config: Omit<
    UseContractEventConfig<typeof optimismPortalABI, 'TransactionDeposited'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof optimismPortalAddress } = {} as any
) {
  return useContractEvent({
    abi: optimismPortalABI,
    address: optimismPortalAddress[1],
    eventName: 'TransactionDeposited',
    ...config,
  } as UseContractEventConfig<typeof optimismPortalABI, 'TransactionDeposited'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link optimismPortalABI}__ and `eventName` set to `"Unpaused"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 */
export function useOptimismPortalUnpausedEvent(
  config: Omit<
    UseContractEventConfig<typeof optimismPortalABI, 'Unpaused'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof optimismPortalAddress } = {} as any
) {
  return useContractEvent({
    abi: optimismPortalABI,
    address: optimismPortalAddress[1],
    eventName: 'Unpaused',
    ...config,
  } as UseContractEventConfig<typeof optimismPortalABI, 'Unpaused'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link optimismPortalABI}__ and `eventName` set to `"WithdrawalFinalized"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 */
export function useOptimismPortalWithdrawalFinalizedEvent(
  