// Code generated - DO NOT EDIT.
// This file is a generated binding and any manual changes will be lost.

package bindings

import (
	"encoding/json"

	"github.com/ethereum-optimism/optimism/op-bindings/solc"
)

const MIPSStorageLayoutJSON = "{\"storage\":[{\"astId\":1000,\"contract\":\"contracts/cannon/MIPS.sol:MIPS\",\"label\":\"oracle\",\"offset\":0,\"slot\":\"0\",\"type\":\"t_contract(IPreimageOracle)1001\"}],\"types\":{\"t_contract(IPreimageOracle)1001\":{\"encoding\":\"inplace\",\"label\":\"contract IPreimageOracle\",\"numberOfBytes\":\"20\"}}}"

var MIPSStorageLayout = new(solc.StorageLayout)

var MIPSDeployedBin = "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"

var MIPSDeployedSourceMap = "1075:32558:0:-:0;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;1655:45;;;:::i;:::-;;;;;;;;;;;;;;;;;;;2081:29;;;:::i;:::-;;;;;;;;;;;;;;;;;;;21344:5721;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;-1:-1:-1;21344:5721:0;;-1:-1:-1;21344:5721:0;-1:-1:-1;21344:5721:0;:::i;:::-;;;;;;;;;;;;;;;;1655:45;1690:10;1655:45;:::o;2081:29::-;;;;;;:::o;21344:5721::-;21422:7;21441:18;;:::i;:::-;21576:4;21569:5;21566:15;21556:2;;21645:1;21643;21636:11;21556:2;21693:4;21687:11;21700;21684:28;21674:2;;21766:1;21764;21757:11;21674:2;21826:3;21808:16;21805:25;21795:2;;21900:1;21898;21891:11;21795:2;21956:3;21942:12;21939:21;21929:2;;22029:1;22027;22020:11;21929:2;22059:416;;;22293:24;;22281:2;22277:13;;;22274:1;22270:21;22266:52;;;;22335:20;;22389:21;;;22443:18;;;22137:338::o;:::-;22552:16;22610:4;22662:18;22677:2;22674:1;22671;22662:18;:::i;:::-;22654:26;;;;22712:18;22727:2;22724:1;22721;22712:18;:::i;:::-;22704:26;;;;22766:17;22781:1;22778;22775;22766:17;:::i;:::-;22758:25;;;;22823:17;22838:1;22835;22832;22823:17;:::i;:::-;22815:25;;;;22868:17;22883:1;22880;22877;22868:17;:::i;:::-;22860:25;;;;22917:17;22932:1;22929;22926;22917:17;:::i;:::-;22909:25;;;;22962:17;22977:1;22974;22971;22962:17;:::i;:::-;22954:25;;;;23007:17;23022:1;23019;23016;23007:17;:::i;:::-;22999:25;;;;23054:17;23069:1;23066;23063;23054:17;:::i;:::-;23046:25;;;;23105:17;23120:1;23117;23114;23105:17;:::i;:::-;23097:25;;;;23154:17;23169:1;23166;23163;23154:17;:::i;:::-;23263:2;23256:10;;23246:21;;;;23146:25;;-1:-1:-1;23256:10:0;-1:-1:-1;23351:1:0;23336:105;23361:2;23358:1;23355:9;23336:105;;;23410:17;23425:1;23422;23419;23410:17;:::i;:::-;23402:25;;-1:-1:-1;23402:25:0;-1:-1:-1;23379:1:0;23372:9;23336:105;;;23340:14;;;23507:5;:12;;;23503:63;;;23542:13;:11;:13::i;:::-;23535:20;;;;;23503:63;23576:10;;;:15;;23590:1;23576:15;;;;;23653:8;;;;-1:-1:-1;;23645:20:0;;-1:-1:-1;23645:7:0;:20::i;:::-;23631:34;-1:-1:-1;23691:10:0;23699:2;23691:10;;;;23760:1;23750:11;;;:26;;;23765:6;:11;;23775:1;23765:11;23750:26;23746:332;;;24003:64;24014:6;:11;;24024:1;24014:11;:20;;24032:2;24014:20;;;24028:1;24014:20;24003:64;;24065:1;24036:25;24039:4;24046:10;24039:17;24058:2;24036;:25::i;:::-;:30;;;;24003:10;:64::i;:::-;23996:71;;;;;;;23746:332;24303:15;;;;24114:9;;;;24243:4;24237:2;24229:10;;;24228:19;;;24303:15;24328:2;24320:10;;;24319:19;24303:36;;;;;;;;;;;;-1:-1:-1;24364:5:0;24384:11;;;;;:29;;;24399:6;:14;;24409:4;24399:14;24384:29;24380:756;;;24468:5;:15;;;24484:5;24468:22;;;;;;;;;;;;;;-1:-1:-1;;24527:4:0;24521:2;24513:10;;;24512:19;24380:756;;;24561:4;24552:6;:13;;;24548:588;;;24670:6;:13;;24680:3;24670:13;:30;;;;24687:6;:13;;24697:3;24687:13;24670:30;:47;;;;24704:6;:13;;24714:3;24704:13;24670:47;24666:229;;;24772:4;24779:6;24772:13;24767:18;;24666:229;;;24859:21;24862:4;24869:6;24862:13;24877:2;24859;:21::i;:::-;24854:26;;24666:229;24548:588;;;24925:4;24915:6;:14;;;;:32;;;;24933:6;:14;;24943:4;24933:14;24915:32;:50;;;;24951:6;:14;;24961:4;24951:14;24915:50;24911:225;;;25027:5;:15;;;25043:5;25027:22;;;;;;;;;;;;;25022:27;;25120:5;25112:13;;24911:225;25161:1;25151:6;:11;;;;:25;;;;;25175:1;25166:6;:10;;;25151:25;25150:42;;;;25181:6;:11;;25191:1;25181:11;25150:42;25146:117;;;25215:37;25228:6;25236:4;25242:5;25249:2;25215:12;:37::i;:::-;25208:44;;;;;;;;;;;25146:117;25292:13;25273:16;25428:4;25418:14;;;;25414:400;;25489:19;25492:4;25497:6;25492:11;25505:2;25489;:19::i;:::-;25483:25;;;;25541:10;25536:15;;25571:16;25536:15;25585:1;25571:7;:16::i;:::-;25565:22;;25615:4;25605:6;:14;;;;:32;;;;;25623:6;:14;;25633:4;25623:14;;25605:32;25601:203;;;25694:4;25682:16;;25788:1;25780:9;;25601:203;25414:400;;25839:10;25852:26;25860:4;25866:2;25870;25874:3;25852:7;:26::i;:::-;25881:10;25852:39;;;;-1:-1:-1;25973:4:0;25966:11;;;26001;;;:24;;;;;26024:1;26016:4;:9;;;;26001:24;:39;;;;;26036:4;26029;:11;;;26001:39;25997:711;;;26060:4;:9;;26068:1;26060:9;:22;;;;26073:4;:9;;26081:1;26073:9;26060:22;26056:116;;;26120:37;26131:4;:9;;26139:1;26131:9;:21;;26147:5;26131:21;;;26143:1;26131:21;26154:2;26120:10;:37::i;:::-;26113:44;;;;;;;;;;;;;;;26056:116;26190:4;:11;;26198:3;26190:11;26186:93;;;26236:28;26245:5;26252:2;26256:7;;;;26236:8;:28::i;26186:93::-;26296:4;:11;;26304:3;26296:11;26292:93;;;26342:28;26351:5;26358:2;26362:7;;;;;26342:8;:28::i;26292:93::-;26447:4;:11;;26455:3;26447:11;26443:72;;;26485:15;:13;:15::i;26443:72::-;26606:4;26598;:12;;;;:27;;;;;26621:4;26614;:11;;;26598:27;26594:104;;;26652:31;26663:4;26669:2;26673;26677:5;26652:10;:31::i;26594:104::-;26760:6;:14;;26770:4;26760:14;:28;;;;-1:-1:-1;26778:10:0;;;;;26760:28;26756:85;;;26829:1;26804:5;:15;;;26820:5;26804:22;;;;;;;;;:26;;;;:22;;;;;;:26;26756:85;26879:9;:26;;26892:13;26879:26;26875:84;;26921:27;26930:9;26941:1;26944:3;26921:8;:27::i;:::-;27032:26;27041:5;27048:3;27053:4;27032:8;:26::i;:::-;27025:33;;;;;;;;;;;;;21344:5721;;;;;;;:::o;2597:1791::-;2638:12;2783:206;;;2883:2;2879:13;;;2869:24;;2863:31;2852:43;;2923:13;;2962;;;2834:155::o;:::-;3060:4;3144;3138:11;3172:5;3244:21;3262:2;3258;3252:4;3244:21;:::i;:::-;3232:33;;;;3302:21;3320:2;3316;3310:4;3302:21;:::i;:::-;3290:33;;;;3364:20;3382:1;3378:2;3372:4;3364:20;:::i;:::-;3352:32;;;;3429:20;3447:1;3443:2;3437:4;3429:20;:::i;:::-;3417:32;;;;3482:20;3500:1;3496:2;3490:4;3482:20;:::i;:::-;3470:32;;;;3539:20;3557:1;3553:2;3547:4;3539:20;:::i;:::-;3527:32;;;;3592:20;3610:1;3606:2;3600:4;3592:20;:::i;:::-;3580:32;;;;3645:20;3663:1;3659:2;3653:4;3645:20;:::i;:::-;3633:32;;;;3700:20;3718:1;3714:2;3708:4;3700:20;:::i;:::-;3688:32;;;;3759:20;3777:1;3773:2;3767:4;3759:20;:::i;:::-;3747:32;;;;3816:20;3834:1;3830:2;3824:4;3816:20;:::i;:::-;3877:2;3867:13;;;;-1:-1:-1;3804:32:0;-1:-1:-1;3975:1:0;3960:112;3985:2;3982:1;3979:9;3960:112;;;4038:20;4056:1;4052:2;4046:4;4038:20;:::i;:::-;4026:32;;-1:-1:-1;4026:32:0;-1:-1:-1;4003:1:0;3996:9;3960:112;;;3964:14;4135:1;4131:2;4124:13;4230:5;4226:2;4222:14;4215:5;4210:27;4336:14;;;4319:32;;;-1:-1:-1;;2597:1791:0;;:::o;17559:1741::-;17632:11;17715:14;17732:24;17744:11;17732;:24::i;:::-;17715:41;;17852:1;17845:5;17841:13;17838:2;;;17883:1;17880;17873:12;17838:2;18016;18004:15;;;17961:20;18114:141;;;;18161:12;;;18197:2;18190:13;;;;18238:2;18225:16;;;18143:112::o;:::-;18410:5;18407:1;18403:13;18441:4;18473:1;18458:375;18483:2;18480:1;18477:9;18458:375;;;18598:2;18586:15;;;18539:20;18629:12;;;18643:1;18625:20;18662:78;;;;18746:1;18741:78;;;;18618:201;;18662:78;18699:23;18714:7;18708:4;18699:23;:::i;:::-;18691:31;;18662:78;;18741;18778:23;18796:4;18787:7;18778:23;:::i;:::-;18770:31;;18618:201;-1:-1:-1;;18501:1:0;18494:9;18458:375;;;18462:14;18935:4;18929:11;18914:26;;19013:7;19007:4;19004:17;18994:2;;19051:10;19048:1;19041:21;19089:2;19086:1;19079:13;18994:2;-1:-1:-1;;19225:2:0;19214:14;;;;19202:10;19198:31;19195:1;19191:39;19255:16;;;;19273:10;19251:33;;17776:1518;-1:-1:-1;;;17776:1518:0:o;2209:280::-;2268:6;2303:16;;;;2311:7;;;;2303:16;;;;;;2302:23;;;;;2317:1;2360:2;:8;;;2354:15;;;;;2353:21;;2352:30;;;;;;;2408:8;;2407:14;2302:23;2459:21;;2479:1;2459:21;;;2470:6;2459:21;2445:10;;;;;:36;;-1:-1:-1;;;2209:280:0;;;;:::o;15048:624::-;15117:12;15176:18;;:::i;:::-;-1:-1:-1;15331:8:0;;;15360:12;;;15349:23;;;;;;;15382:20;;;;;15236:4;;15506:13;;;15502:82;;15563:6;15572:1;15563:10;15535:5;:15;;;15551:8;15535:25;;;;;;;;;:38;;;;:25;;;;;;:38;15502:82;15652:13;:11;:13::i;:::-;15645:20;15048:624;-1:-1:-1;;;;;15048:624:0:o;10480:1713::-;10577:12;10635:18;;:::i;:::-;-1:-1:-1;10695:4:0;10719:17;10818:1;10807:12;;;;;:28;;;10823:7;:12;;10834:1;10823:12;10807:28;10803:859;;;10851:9;10863:5;:15;;;10879:6;10863:23;;;;;;;;;;;;;10851:35;;10923:2;10916:9;;:3;:9;;;:25;;;;;10929:7;:12;;10940:1;10929:12;10916:25;10915:58;;;;10954:2;10947:9;;:3;:9;;;;:25;;;;;10960:7;:12;;10971:1;10960:12;10947:25;10900:73;;10803:859;;;;11073:7;:12;;11084:1;11073:12;11069:593;;;11130:1;11122:3;11116:15;;;;11101:30;;11069:593;;;11222:7;:12;;11233:1;11222:12;11218:444;;;11278:1;11271:3;11265:14;;;11250:29;;11218:444;;;11387:7;:12;;11398:1;11387:12;11383:279;;;11467:4;11461:2;11452:11;;;11451:20;11490:8;11486:76;;11546:1;11539:3;11533:14;;;11518:29;;11486:76;11579:3;:8;;11586:1;11579:8;11575:77;;;11636:1;11628:3;11622:15;;;;11607:30;;11575:77;11383:279;;11730:8;;;;;11800:12;;;;11789:23;;;;;11944:162;;;;12031:1;12005:22;12008:5;12016:6;12008:14;12024:2;12005;:22::i;:::-;:27;;;;;;;11991:42;;12000:1;11991:42;11976:57;:12;;;:57;11944:162;;;12079:12;;;;;12094:1;12079:16;12064:31;;;;11944:162;12173:13;:11;:13::i;:::-;12166:20;10480:1713;-1:-1:-1;;;;;;;;10480:1713:0:o;27111:6520::-;27198:6;27232:10;27240:2;27232:10;;;;;;27279:11;;27383:4;27374:13;;27370:6215;;;27502:1;27492:6;:11;;;;:27;;;;;27516:3;27507:6;:12;;;27492:27;27488:532;;;27543:6;:11;;27553:1;27543:11;27539:431;;;-1:-1:-1;27565:4:0;27539:431;;;27613:6;:11;;27623:1;27613:11;27609:361;;;-1:-1:-1;27635:4:0;27609:361;;;27679:6;:13;;27689:3;27679:13;27675:295;;;-1:-1:-1;27703:4:0;27675:295;;;27744:6;:13;;27754:3;27744:13;27740:230;;;-1:-1:-1;27768:4:0;27740:230;;;27810:6;:13;;27820:3;27810:13;27806:164;;;-1:-1:-1;27834:4:0;27806:164;;;27875:6;:13;;27885:3;27875:13;27871:99;;;-1:-1:-1;27899:4:0;27871:99;;;27939:6;:13;;27949:3;27939:13;27935:35;;;-1:-1:-1;27963:4:0;27935:35;28004:1;27995:10;;27488:532;28073:11;;;28069:3190;;28133:4;28128:1;28120:9;;;28119:18;28166:4;28120:9;28159:11;;;28155:1203;;;28250:4;28242;:12;;;28238:1102;;28289:2;28282:9;;;;;;;28238:1102;28391:12;;;28387:953;;28438:11;;;;;;;;-1:-1:-1;28431:18:0;;-1:-1:-1;;28431:18:0;28387:953;28550:4;:12;;28558:4;28550:12;28546:794;;;28597:11;;;;;;;;-1:-1:-1;28590:18:0;;-1:-1:-1;;28590:18:0;28546:794;28712:4;:12;;28720:4;28712:12;28708:632;;;28759:27;28768:5;28762:11;;:2;:11;;;;28780:5;28775:2;:10;28759:2;:27::i;28708:632::-;28896:4;:12;;28904:4;28896:12;28892:448;;;-1:-1:-1;;;;28943:17:0;;;28955:4;28950:9;;28943:17;28936:24;;28892:448;29071:4;:12;;29079:4;29071:12;29067:273;;;-1:-1:-1;;;;29118:17:0;;;29130:4;29125:9;;29118:17;29111:24;;29067:273;29249:4;:12;;29257:4;29249:12;29245:95;;;29296:21;29305:2;29299:8;;:2;:8;;;;29314:2;29309;:7;29296:2;:21::i;29245:95::-;29502:4;:12;;29510:4;29502:12;:28;;;;29518:4;:12;;29526:4;29518:12;29502:28;29498:1025;;;29566:2;29561;:7;29554:14;;;;;;;29498:1025;29644:4;:12;;29652:4;29644:12;:28;;;;29660:4;:12;;29668:4;29660:12;29644:28;29640:883;;;29708:2;29703;:7;29696:14;;;;;;;29640:883;29778:4;:12;;29786:4;29778:12;29774:749;;;29826:2;29821;:7;29814:14;;;;;;;29774:749;29895:4;:12;;29903:4;29895:12;29891:632;;;29944:2;29939;:7;29931:16;;;;;;;29891:632;30015:4;:12;;30023:4;30015:12;30011:512;;;30064:2;30059;:7;30051:16;;;;;;;30011:512;30135:4;:12;;30143:4;30135:12;30131:392;;;-1:-1:-1;;;;30180:7:0;;;30178:10;30171:17;;30131:392;30279:4;:12;;30287:4;30279:12;30275:248;;;30338:2;30320:21;;30326:2;30320:21;;;:29;;30348:1;30320:29;;;30344:1;30320:29;30313:36;;;;;;;;;30275:248;30450:4;:12;;30458:4;30450:12;30446:77;;;30494:2;30491:5;;:2;:5;;;:13;;30503:1;30491:13;;30446:77;28069:3190;;;;30600:6;:13;;30610:3;30600:13;30596:663;;;30646:2;30640;:8;;;;30633:15;;;;;;30596:663;30709:6;:14;;30719:4;30709:14;30705:554;;;30770:4;:9;;30778:1;30770:9;30766:92;;;-1:-1:-1;;;30817:21:0;;;30803:36;;30766:92;30902:4;:12;;30910:4;30902:12;:28;;;;30918:4;:12;;30926:4;30918:12;30902:28;30898:347;;;30958:4;:12;;30966:4;30958:12;30954:75;;;31003:3;;;30954:75;31050:8;31084:113;31094:10;31091:13;;:18;31084:113;;31166:8;31137:3;31166:8;;;;;31137:3;31084:113;;;31225:1;-1:-1:-1;31218:8:0;;-1:-1:-1;;31218:8:0;30898:347;27370:6215;;;31296:4;31287:6;:13;;;31283:2302;;;31338:6;:14;;31348:4;31338:14;31334:1088;;;31379:42;31397:2;31402:1;31397:6;31407:1;31396:12;31391:2;:17;31383:26;;:3;:26;;;;31413:4;31382:35;31419:1;31379:2;:42::i;:::-;31372:49;;;;;;31334:1088;31476:6;:14;;31486:4;31476:14;31472:950;;;31517:45;31535:2;31540:1;31535:6;31545:1;31534:12;31529:2;:17;31521:26;;:3;:26;;;;31551:6;31520:37;31559:2;31517;:45::i;31472:950::-;31618:6;:14;;31628:4;31618:14;31614:808;;;-1:-1:-1;;;31665:21:0;31684:1;31679;31674:6;;31673:12;31665:21;;31718:36;;;31785:5;31780:10;;31665:21;;;;;31779:18;31772:25;;31614:808;31852:6;:14;;31862:4;31852:14;31848:574;;;31893:3;31886:10;;;;;;31848:574;31952:6;:14;;31962:4;31952:14;31948:474;;;32008:2;32013:1;32008:6;32018:1;32007:12;32002:2;:17;31994:26;;:3;:26;;;;32024:4;31993:35;31986:42;;;;;;31948:474;32084:6;:14;;32094:4;32084:14;32080:342;;;32140:2;32145:1;32140:6;32150:1;32139:12;32134:2;:17;32126:26;;:3;:26;;;;32156:6;32125:37;32118:44;;;;;;32080:342;32218:6;:14;;32228:4;32218:14;32214:208;;;-1:-1:-1;;;32265:26:0;32289:1;32284;32279:6;;32278:12;32273:2;:17;32265:26;;32323:41;;;32395:5;32390:10;;32265:26;;;;;32389:18;32382:25;;31283:2302;32464:6;:14;;32474:4;32464:14;32460:1125;;;-1:-1:-1;;;32513:4:0;32507:34;32539:1;32534;32529:6;;32528:12;32523:2;:17;32507:34;;32589:27;;;32569:48;;;32639:10;;32508:9;;;32507:34;;32638:18;32631:25;;32460:1125;32699:6;:14;;32709:4;32699:14;32695:890;;;-1:-1:-1;;;32748:6:0;32742:36;32776:1;32771;32766:6;;32765:12;32760:2;:17;32742:36;;32826:29;;;32806:50;;;32878:10;;32743:11;;;32742:36;;32877:18;32870:25;;32695:890;32939:6;:14;;32949:4;32939:14;32935:650;;;-1:-1:-1;;;32982:20:0;33000:1;32995;32990:6;;32989:12;32982:20;;33030:36;;;33094:5;33088:11;;32982:20;;;;;33087:19;33080:26;;32935:650;33149:6;:14;;33159:4;33149:14;33145:440;;;33186:2;33179:9;;;;;;33145:440;33232:6;:14;;33242:4;33232:14;33228:357;;;-1:-1:-1;;;33275:25:0;33298:1;33293;33288:6;;33287:12;33282:2;:17;33275:25;;33328:41;;;33397:5;33391:11;;33275:25;;;;;33390:19;33383:26;;33228:357;33452:6;:14;;33462:4;33452:14;33448:137;;;33489:3;33482:10;;;;;;33448:137;33535:6;:14;;33545:4;33535:14;33531:54;;;33572:2;33565:9;;;;;;33531:54;33595:29;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;15953:688;16039:12;16098:18;;:::i;:::-;-1:-1:-1;16158:4:0;16253:2;16241:14;;;;16233:41;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;16362:14;;;;;;;:30;;;16380:12;16362:30;16358:94;;;16437:4;16408:5;:15;;;16424:9;16408:26;;;;;;;;;:33;;;;:26;;;;;;:33;16358:94;16499:12;;;;;16488:23;;;;:8;;;:23;16551:1;16536:16;;;16521:31;;;16621:13;:11;:13::i;4429:5665::-;4472:7;4525:18;;:::i;:::-;-1:-1:-1;4629:15:0;;:18;;;;4585:4;4716:18;;;;4756;;;;4796;;;;;4585:4;;4609:17;;;;4716:18;4756;4829;;;4843:4;4829:18;4825:5090;;;4895:2;4918:4;4915:7;;:12;4911:112;;5003:4;5000:7;;4992:4;:16;4986:22;4911:112;5040:7;;;5036:141;;5072:10;;;;;5100:16;;;;;;;;5072:10;-1:-1:-1;5036:141:0;;;5160:2;5155:7;;5036:141;4825:5090;;;;5197:10;:18;;5211:4;5197:18;5193:4722;;;1690:10;5250:14;;5193:4722;;;5285:10;:18;;5299:4;5285:18;5281:4634;;;5361:1;5356:6;;5281:4634;;;5383:10;:18;;5397:4;5383:18;5379:4536;;;5458:4;5443:12;;;:19;5476:26;;;:14;;;:26;5523:13;:11;:13::i;:::-;5516:20;;;;;;;;;;;5379:4536;5557:10;:18;;5571:4;5557:18;5553:4362;;;5704:14;;;5700:2017;;;;;5809:22;;;1923:1;5809:22;5805:1912;;;5946:10;5959:27;5967:2;5972:10;5967:15;5984:1;5959:7;:27::i;:::-;6045:11;6076:6;;6096:17;;;;6115:20;;;;;6076:60;;;;;;;;;;;;;;;;;;;;5946:40;;-1:-1:-1;6045:11:0;;;;6076:6;;;;;:19;;:60;;;;;;;;;;;:6;:60;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;-1:-1:-1;6076:60:0;;;;;;;;;-1:-1:-1;6076:60:0;-1:-1:-1;6267:1:0;6259:10;;6357:1;6353:17;;;6428;;;6425:2;;;6458:5;6448:15;;6425:2;;6537:6;6533:2;6530:14;6527:2;;;6557;6547:12;;6527:2;6659:3;6654:1;6646:6;6642:14;6637:3;6633:24;6629:34;6622:41;;6755:3;6751:1;6739:9;6730:6;6727:1;6723:14;6719:30;6715:38;6711:48;6704:55;;6875:1;6871;6867;6855:9;6852:1;6848:17;6844:25;6840:33;6836:41;6998:1;6994;6990;6981:6;6969:9;6966:1;6962:17;6958:30;6954:38;6950:46;6946:54;6928:72;;7094:10;7090:15;7084:4;7080:26;7072:34;;7206:3;7198:4;7194:9;7189:3;7185:19;7182:28;7175:35;;;;7302:33;7311:2;7316:10;7311:15;7328:1;7331:3;7302:8;:33::i;:::-;7353:20;;;:38;;;;;;;;;-1:-1:-1;5805:1912:0;;-1:-1:-1;;5805:1912:0;;7453:18;;;1842:1;7453:18;7449:268;;;7618:2;7613:7;;7449:268;;;7664:10;7659:15;;1998:3;7692:10;;7449:268;5553:4362;;;7737:10;:18;;7751:4;7737:18;7733:2182;;;7888:15;;;1769:1;7888:15;;:34;;-1:-1:-1;7907:15:0;;;1804:1;7907:15;7888:34;:57;;;-1:-1:-1;7926:19:0;;;1881:1;7926:19;7888:57;7884:1340;;;7970:2;7965:7;;7884:1340;;;8040:23;;;1966:1;8040:23;8036:1188;;;8103:10;8116:27;8124:2;8129:10;8124:15;8141:1;8116:7;:27::i;:::-;8215:17;;;;8103:40;;-1:-1:-1;8363:1:0;8355:10;;8453:1;8449:17;8524:13;;;8521:2;;;8546:5;8540:11;;8521:2;8820:14;;;8634:1;8816:22;;;8812:32;;;;8713:26;8737:1;8626:10;;;8717:18;;;8713:26;8808:43;8622:20;;8912:12;8978:17;;;:23;9042:1;9019:20;;;:24;8630:2;-1:-1:-1;8630:2:0;8036:1188;;7733:2182;9244:10;:18;;9258:4;9244:18;9240:675;;;9330:2;:7;;9336:1;9330:7;9326:579;;;9399:14;;;;;:40;;-1:-1:-1;9417:22:0;;;1923:1;9417:22;9399:40;:62;;;-1:-1:-1;9443:18:0;;;1842:1;9443:18;9399:62;9395:376;;;9490:1;9485:6;;9395:376;;;9532:15;;;1769:1;9532:15;;:34;;-1:-1:-1;9551:15:0;;;1804:1;9551:15;9532:34;:61;;;-1:-1:-1;9570:23:0;;;1966:1;9570:23;9532:61;:84;;;-1:-1:-1;9597:19:0;;;1881:1;9597:19;9532:84;9528:243;;;9645:1;9640:6;;9528:243;;9326:579;9814:10;9809:15;;2032:4;9842:11;;9326:579;9925:15;;;;;:23;;;;:18;;;;:23;;;;9958:15;;:23;;;:18;;;;:23;-1:-1:-1;10003:12:0;;;;9992:23;;;:8;;;:23;10055:1;10040:16;10025:31;;;;;10074:13;:11;:13::i;:::-;10067:20;;;;;;;;;4429:5665;:::o;12534:2222::-;12628:12;12686:18;;:::i;:::-;-1:-1:-1;12746:4:0;12770:10;12879:4;12870:13;;;;12866:1545;;;-1:-1:-1;12905:8:0;;;;12866:1545;;;13012:5;:13;;13021:4;13012:13;13008:1403;;;13041:14;;;:8;;;:14;13008:1403;;;13159:5;:13;;13168:4;13159:13;13155:1256;;;-1:-1:-1;13194:8:0;;;;13155:1256;;;13301:5;:13;;13310:4;13301:13;13297:1114;;;13330:14;;;:8;;;:14;13297:1114;;;13459:5;:13;;13468:4;13459:13;13455:956;;;13578:9;13528:17;13508;;;13528;;;;13508:37;13585:2;13578:9;;;;;13560:8;;;:28;13602:22;:8;;;:22;13455:956;;;13749:5;:13;;13758:4;13749:13;13745:666;;;13812:11;13798;;;13812;;;13798:25;13863:2;13856:9;;;;;13838:8;;;:28;13880:22;:8;;;:22;13745:666;;;14041:5;:13;;14050:4;14041:13;14037:374;;;14107:3;14088:23;;14094:3;14088:23;;;;;;;;14070:42;;:8;;;:42;14144:23;;;;;;;;;;;;;;14126:42;;:8;;;:42;14037:374;;;14317:5;:13;;14326:4;14317:13;14313:98;;;14363:3;14357:9;;:3;:9;;;;;;;;14346:20;;;;:8;;;:20;14391:9;;;;;;;;;;;;14380:20;;:8;;;:20;14313:98;14496:14;;;;14492:77;;14555:3;14526:5;:15;;;14542:9;14526:26;;;;;;;;;:32;;;;:26;;;;;;:32;14492:77;14615:12;;;;;14604:23;;;;:8;;;:23;14667:1;14652:16;;;14637:31;;;14736:13;:11;:13::i;:::-;14729:20;12534:2222;-1:-1:-1;;;;;;;12534:2222:0:o;19636:1584::-;19784:14;19801:24;19813:11;19801;:24::i;:::-;19784:41;;19921:1;19914:5;19910:13;19907:2;;;19952:1;19949;19942:12;19907:2;20091;20273:15;;;20110:2;20099:14;;20087:10;20083:31;20080:1;20076:39;20233:16;;;20030:20;;20218:10;20207:22;;;20203:27;20193:38;20190:60;20679:5;20676:1;20672:13;20742:1;20727:375;20752:2;20749:1;20746:9;20727:375;;;20867:2;20855:15;;;20808:20;20898:12;;;20912:1;20894:20;20931:78;;;;21015:1;21010:78;;;;20887:201;;20931:78;20968:23;20983:7;20977:4;20968:23;:::i;:::-;20960:31;;20931:78;;21010;21047:23;21065:4;21056:7;21047:23;:::i;:::-;21039:31;;20887:201;-1:-1:-1;;20770:1:0;20763:9;20727:375;;;-1:-1:-1;;21193:4:0;21186:18;-1:-1:-1;;;;19845:1369:0:o;16845:500::-;17135:20;;;17159:7;17135:32;17128:3;:40;;;17217:14;;17256:17;;17250:24;;;17242:72;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;17324:14;16845:500;;;:::o;-1:-1:-1:-;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;:::i;:::-;;;;:::o;:::-;;;;;;;;;;;;;;;;;;;;;;;;:::o"

func init() {
	if err := json.Unmarshal([]byte(MIPSStorageLayoutJSON), MIPSStorageLayout); err != nil {
		panic(err)
	}

	layouts["MIPS"] = MIPSStorageLayout
	deployedBytecodes["MIPS"] = MIPSDeployedBin
}
