# Security Reviews

The following is a list of past security reviews.

Each review is focused on a different part of the codebase, and at a different point in time.
Please see the report for the specific details.

| Date    | Reviewer             | Focus and Scope                                                                                                                                                                                                           | Report Link                                                                                                                                                | Commit                                       | Subsequent Release  |
|---------|----------------------| ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |------------------------------------------------------------------------------------------------------------------------------------------------------------| -------------------------------------------- |---------------------|
| 2020-10 | Trail of Bits        | Rollup                                                                                                                                                                                                                    | [2020_10-TrailOfBits.pdf](./2020_10-Rollup-TrailOfBits.pdf)                                                                                                |                                              |                     |
| 2020-11 | Dapphub              | ECDSA Wallet                                                                                                                                                                                                              | [2020_11-Dapphub-ECDSA_Wallet.pdf](./2020_11-Dapphub-ECDSA_Wallet.pdf)                                                                                     |                                              |                     |
| 2021-03 | OpenZeppelin         | OVM and Rollup                                                                                                                                                                                                            | [2021_03-OVM_and_Rollup-OpenZeppelin.pdf](./2021_03-OVM_and_Rollup-OpenZeppelin.pdf)                                                                       |                                              |                     |
| 2021-03 | ConsenSys Diligence  | Safety Checker                                                                                                                                                                                                            | [2021_03-SafetyChecker-ConsenSysDiligence.pdf](./2021_03-SafetyChecker-ConsenSysDiligence.pdf)                                                             |                                              |                     |
| 2022-05 | Zeppelin             | Bedrock Contracts                                                                                                                                                                                                         | [2022_05-Bedrock_Contracts-Zeppelin.pdf](./2022_05-Bedrock_Contracts-Zeppelin.pdf)                                                                         |                                              |                     |
| 2022-05 | Trail of Bits        | OpNode                                                                                                                                                                                                                    | [2022_05-OpNode-TrailOfBits.pdf](./2022_05-OpNode-TrailOfBits.pdf)                                                                                         |                                              |                     |
| 2022-08 | Sigma Prime          | Bedrock GoLang                                                                                                                                                                                                            | [2022_08-Bedrock_GoLang-SigmaPrime.pdf](./2022_08-Bedrock_GoLang-SigmaPrime.pdf)                                                                           |                                              |                     |
| 2022-09 | Zeppelin             | Bedrock and Periphery: All contracts in `packages/contracts-bedrock/contracts`                                                                                                                                            | [2022_09-Bedrock_and_Periphery-Zeppelin.pdf](./2022_09-Bedrock_and_Periphery-Zeppelin.pdf)                                                                 | 93d3bd411a8ae75702539ac9c5fe00bad21d4104     | op-contracts/v1.0.0 |
| 2022-10 | Spearbit             | Drippie: `Drippie.sol`                                                                                                                                                                                                    | [2022_10-Drippie-Spearbit.pdf](./2022_10-Drippie-Spearbit.pdf)                                                                                             | 2a7be367634f147736f960eb2f38a77291cdfcad     | op-contracts/v1.0.0 |
| 2022-11 | Trail of Bits        | Invariant Testing: `OptimismPortal.sol`                                                                                                                                                                                   | [2022_11-Invariant_Testing-TrailOfBits.pdf](./2022_11-Invariant_Testing-TrailOfBits.pdf)                                                                   | b31d35b67755479645dd150e7cc8c6710f0b4a56     | op-contracts/v1.0.0 |
| 2022-12 | Runtime Verification | Deposit Transaction: `OptimismPortal.sol`                                                                                                                                                                                 | [2022_12-DepositTransaction-RuntimeVerification.pdf](./2022_12-DepositTransaction-RuntimeVerification.pdf)                                                 |                                              | op-contracts/v1.0.0 |
| 2023-01 | Trail of Bits        | Bedrock Updates: `SystemConfig.sol`                                                                                                                                                                                       | [2023_01-Bedrock_Updates-TrailOfBits.pdf](./2023_01-Bedrock_Updates-TrailOfBits.pdf)                                                                       | ee96ff8585699b054c95c6ff4a2411ee9fedcc87     | op-contracts/v1.0.0 |
| 2023-01 | Sherlock             | Bedrock: All contracts in `packages/contracts-bedrock/src`                                                                                                                                                                | Sherlock Bedrock Contest ([site](https://audits.sherlock.xyz/contests/38), [repo](https://github.com/sherlock-audit/2023-01-optimism))                     | 3f4b3c328153a8aa03611158b6984d624b17c1d9     | op-contracts/v1.0.0 |
| 2023-03 | Sherlock             | Bedrock Fixes: All contracts in `packages/contracts-bedrock/src`                                                                                                                                                          | Sherlock Bedrock Contest: Fix Review ([site](https://audits.sherlock.xyz/contests/63), [repo](https://github.com/sherlock-audit/2023-03-optimism))         | 20229b9f78c6613c6ee53b93ca43c71bb74479f4b975 | op-contracts/v1.0.0 |
| 2023-12 | Trust                | Superchain Config Upgrade: `SuperchainConfig.sol`, `L1CrossDomainMessenger.sol`, `L1ERC721Bridge.sol`, `L1StandardBridge.sol`, `OptimismPortal.sol`, `CrossDomainMessenger.sol`, `ERC721Bridge.sol`, `StandardBridge.sol` | [2023_12_SuperchainConfigUpgrade_Trust.pdf](./2023_12_SuperchainConfigUpgrade_Trust.pdf)                                                                   | d1651bb22645ebd41ac4bb2ab4786f9a56fc1003     | op-contracts/v1.2.0 |
| 2024-02 | Runtime Verification | Pausability                                                                                                                                                                                                               | [Kontrol Verification][kontrol]                                                                                                                            |                                              |                     |
| 2024-02 | Cantina              | MCP L1: `OptimismPortal.sol`, `L1CrossDomainMessenger.sol`, `L1StandardBridge.sol`, `L1ERC721Bridge.sol`, `OptimismMintableERC20Factory.sol`, `L2OutputOracle.sol`, `SystemConfig.sol`                                    | [2024_02-MCP_L1-Cantina.pdf](./2024_02-MCP_L1-Cantina.pdf)                                                                                                 | e6ef3a900c42c8722e72c2e2314027f85d12ced5     | op-contracts/v1.3.0 |
| 2024-03 | Sherlock             | Fault Proofs                                                                                                                                                                                                              | Sherlock Optimism Fault Proofs Contest ([site](https://audits.sherlock.xyz/contests/205), [repo](https://github.com/sherlock-audit/2024-02-optimism-2024)) |                                              |                     |
| 2024-08 | Cantina              | Fault proof MIPS: `MIPS.sol`                                                                                                                                                                                              | [./2024_08_Fault-Proofs-MIPS_Cantina.pdf](./2024_08_Fault-Proofs-MIPS_Cantina.pdf)                                                                         | 71b93116738ee98c9f8713b1a5dfe626ce06c1b2     | op-contracts/v1.4.0 |
| 2024-08 | Spearbit             | Fault proof no-MIPS: All contracts in the `packages/contracts-bedrock/src/dispute` directory                                                                                                                              | [./2024_08_Fault-Proofs-No-MIPS_Spearbit.pdf](./2024_08_Fault-Proofs-No-MIPS_Spearbit.pdf)                                                                 | 1f7081798ce2d49b8643514663d10681cb853a3d     | op-contracts/v1.6.0 |
| 2024-10 | 3Doc Security        | Fault proof MIPS: `MIPS.sol`                                                                                                                                                                                              | [./2024_10-Cannon-FGETFD-3DocSecurity.md](./2024_10-Cannon-FGETFD-3DocSecurity.md)                                                                         | 52d0e60c16498ad4efec8798e3fc1b36b13f46a2     | op-contracts/v1.8.0 |

[kontrol]: https://github.com/ethereum-optimism/optimism/blob/876e16ad04968f0bb641eb76f98eb77e7e1a3e16/packages/contracts-bedrock/test/kontrol/README.md
