#!/bin/bash
rootdir=$(pwd)
configdir=$(pwd)/deployer

deploymentdir=$rootdir/packages/contracts-bedrock/deployments


source $rootdir/.envrc

cd $rootdir/packages/contracts-bedrock && ./scripts/getting-started/config.sh

echo "configure finished"

cd $rootdir/packages/contracts-bedrock && \
DEPLOYMENT_OUTFILE=$deploymentdir/artifact.json \
DEPLOY_CONFIG_PATH=$deploymentdir/config.json  \
  forge script scripts/deploy/Deploy.s.sol:Deploy \
    --non-interactive \
    --broadcast --private-key $PRIVATE_KEY \
    --rpc-url $L1_RPC_URL

echo "contract deploy finished"

cp $deploymentdir/config.json $configdir/
cp $deploymentdir/artifact.json $configdir/
cd $rootdir
