package exchain

import "github.com/holiman/uint256"

const (
	ChainCheckpointInterval = uint64(120) // 1 checkpoint every 120 blocks, from 1 to 120, 121 to 240, etc.

)

var (
	big1 = uint256.NewInt(1)
)

type Checkpoint uint64

func (c Checkpoint) Start() uint64 {
	// start = interval * cp + 1
	start := ChainCheckpointInterval*uint64(c) + 1
	return start
}

func (c Checkpoint) End() uint64 {
	// end = interval * (cp + 1)
	end := ChainCheckpointInterval * (uint64(c) + 1)
	return end
}

func ToCheckpoint(number uint64) Checkpoint {
	if number == 0 {
		return 0
	}
	cp := (number - 1) / ChainCheckpointInterval
	return Checkpoint(cp)
}
