package exchain

import (
	"github.com/ethereum/go-ethereum/common"
	nebulav1 "github.com/exchain/go-exchain/exchain/protocol/gen/go/nebula/v1"
	"github.com/holiman/uint256"
)

// This file define all database interfaces for exchain.

// Database is a simple key-value store.
type Database interface {
	Get(key []byte) ([]byte, error)
	Put(key []byte, value []byte) error
	Delete(key []byte) error
}

type StateDB interface {
	GetAccount(address common.Address) *nebulav1.Account
	FrozenBalance(address common.Address, coin common.Address, balance uint256.Int) error
	UnFrozenBalance(address common.Address, coin common.Address, balance uint256.Int) error
	SubBalance(address common.Address, coin common.Address, balance uint256.Int) error
	AddBalance(address common.Address, coin common.Address, balance uint256.Int) error
}

type ChainDB interface {
	AddCoin()
	GetCoin()
	AddPair()
	GetPair()
}
