// Code generated - DO NOT EDIT.
// This file is a generated binding and any manual changes will be lost.

package bindings

import (
	"encoding/json"

	"github.com/ethereum-optimism/optimism/op-bindings/solc"
)

const OptimismPortalStorageLayoutJSON = "{\"storage\":[{\"astId\":1000,\"contract\":\"contracts/L1/OptimismPortal.sol:OptimismPortal\",\"label\":\"_initialized\",\"offset\":0,\"slot\":\"0\",\"type\":\"t_uint8\"},{\"astId\":1001,\"contract\":\"contracts/L1/OptimismPortal.sol:OptimismPortal\",\"label\":\"_initializing\",\"offset\":1,\"slot\":\"0\",\"type\":\"t_bool\"},{\"astId\":1002,\"contract\":\"contracts/L1/OptimismPortal.sol:OptimismPortal\",\"label\":\"params\",\"offset\":0,\"slot\":\"1\",\"type\":\"t_struct(ResourceParams)1009_storage\"},{\"astId\":1003,\"contract\":\"contracts/L1/OptimismPortal.sol:OptimismPortal\",\"label\":\"__gap\",\"offset\":0,\"slot\":\"2\",\"type\":\"t_array(t_uint256)1007_storage\"},{\"astId\":1004,\"contract\":\"contracts/L1/OptimismPortal.sol:OptimismPortal\",\"label\":\"l2Sender\",\"offset\":0,\"slot\":\"50\",\"type\":\"t_address\"},{\"astId\":1005,\"contract\":\"contracts/L1/OptimismPortal.sol:OptimismPortal\",\"label\":\"finalizedWithdrawals\",\"offset\":0,\"slot\":\"51\",\"type\":\"t_mapping(t_bytes32,t_bool)\"},{\"astId\":1006,\"contract\":\"contracts/L1/OptimismPortal.sol:OptimismPortal\",\"label\":\"provenWithdrawals\",\"offset\":0,\"slot\":\"52\",\"type\":\"t_mapping(t_bytes32,t_struct(ProvenWithdrawal)1008_storage)\"}],\"types\":{\"t_address\":{\"encoding\":\"inplace\",\"label\":\"address\",\"numberOfBytes\":\"20\"},\"t_array(t_uint256)1007_storage\":{\"encoding\":\"inplace\",\"label\":\"uint256[48]\",\"numberOfBytes\":\"1536\"},\"t_bool\":{\"encoding\":\"inplace\",\"label\":\"bool\",\"numberOfBytes\":\"1\"},\"t_bytes32\":{\"encoding\":\"inplace\",\"label\":\"bytes32\",\"numberOfBytes\":\"32\"},\"t_mapping(t_bytes32,t_bool)\":{\"encoding\":\"mapping\",\"label\":\"mapping(bytes32 =\u003e bool)\",\"numberOfBytes\":\"32\",\"key\":\"t_bytes32\",\"value\":\"t_bool\"},\"t_mapping(t_bytes32,t_struct(ProvenWithdrawal)1008_storage)\":{\"encoding\":\"mapping\",\"label\":\"mapping(bytes32 =\u003e struct OptimismPortal.ProvenWithdrawal)\",\"numberOfBytes\":\"32\",\"key\":\"t_bytes32\",\"value\":\"t_struct(ProvenWithdrawal)1008_storage\"},\"t_struct(ProvenWithdrawal)1008_storage\":{\"encoding\":\"inplace\",\"label\":\"struct OptimismPortal.ProvenWithdrawal\",\"numberOfBytes\":\"64\"},\"t_struct(ResourceParams)1009_storage\":{\"encoding\":\"inplace\",\"label\":\"struct ResourceMetering.ResourceParams\",\"numberOfBytes\":\"32\"},\"t_uint128\":{\"encoding\":\"inplace\",\"label\":\"uint128\",\"numberOfBytes\":\"16\"},\"t_uint256\":{\"encoding\":\"inplace\",\"label\":\"uint256\",\"numberOfBytes\":\"32\"},\"t_uint64\":{\"encoding\":\"inplace\",\"label\":\"uint64\",\"numberOfBytes\":\"8\"},\"t_uint8\":{\"encoding\":\"inplace\",\"label\":\"uint8\",\"numberOfBytes\":\"1\"}}}"

var OptimismPortalStorageLayout = new(solc.StorageLayout)

var OptimismPortalDeployedBin = "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"

func init() {
	if err := json.Unmarshal([]byte(OptimismPortalStorageLayoutJSON), OptimismPortalStorageLayout); err != nil {
		panic(err)
	}

	layouts["OptimismPortal"] = OptimismPortalStorageLayout
	deployedBytecodes["OptimismPortal"] = OptimismPortalDeployedBin
}
