// Code generated - DO NOT EDIT.
// This file is a generated binding and any manual changes will be lost.

package bindings

import (
	"errors"
	"math/big"
	"strings"

	ethereum "github.com/ethereum/go-ethereum"
	"github.com/ethereum/go-ethereum/accounts/abi"
	"github.com/ethereum/go-ethereum/accounts/abi/bind"
	"github.com/ethereum/go-ethereum/common"
	"github.com/ethereum/go-ethereum/core/types"
	"github.com/ethereum/go-ethereum/event"
)

// Reference imports to suppress errors if they are not otherwise used.
var (
	_ = errors.New
	_ = big.NewInt
	_ = strings.NewReader
	_ = ethereum.NotFound
	_ = bind.Bind
	_ = common.Big1
	_ = types.BloomLookup
	_ = event.NewSubscription
)

// MIPSMetaData contains all meta data concerning the MIPS contract.
var MIPSMetaData = &bind.MetaData{
	ABI: "[{\"inputs\":[{\"internalType\":\"contractIPreimageOracle\",\"name\":\"_oracle\",\"type\":\"address\"}],\"stateMutability\":\"nonpayable\",\"type\":\"constructor\"},{\"inputs\":[],\"name\":\"BRK_START\",\"outputs\":[{\"internalType\":\"uint32\",\"name\":\"\",\"type\":\"uint32\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"oracle\",\"outputs\":[{\"internalType\":\"contractIPreimageOracle\",\"name\":\"oracle_\",\"type\":\"address\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"bytes\",\"name\":\"stateData\",\"type\":\"bytes\"},{\"internalType\":\"bytes\",\"name\":\"proof\",\"type\":\"bytes\"}],\"name\":\"step\",\"outputs\":[{\"internalType\":\"bytes32\",\"name\":\"\",\"type\":\"bytes32\"}],\"stateMutability\":\"nonpayable\",\"type\":\"function\"}]",
	Bin: "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",
}

// MIPSABI is the input ABI used to generate the binding from.
// Deprecated: Use MIPSMetaData.ABI instead.
var MIPSABI = MIPSMetaData.ABI

// MIPSBin is the compiled bytecode used for deploying new contracts.
// Deprecated: Use MIPSMetaData.Bin instead.
var MIPSBin = MIPSMetaData.Bin

// DeployMIPS deploys a new Ethereum contract, binding an instance of MIPS to it.
func DeployMIPS(auth *bind.TransactOpts, backend bind.ContractBackend, _oracle common.Address) (common.Address, *types.Transaction, *MIPS, error) {
	parsed, err := MIPSMetaData.GetAbi()
	if err != nil {
		return common.Address{}, nil, nil, err
	}
	if parsed == nil {
		return common.Address{}, nil, nil, errors.New("GetABI returned nil")
	}

	address, tx, contract, err := bind.DeployContract(auth, *parsed, common.FromHex(MIPSBin), backend, _oracle)
	if err != nil {
		return common.Address{}, nil, nil, err
	}
	return address, tx, &MIPS{MIPSCaller: MIPSCaller{contract: contract}, MIPSTransactor: MIPSTransactor{contract: contract}, MIPSFilterer: MIPSFilterer{contract: contract}}, nil
}

// MIPS is an auto generated Go binding around an Ethereum contract.
type MIPS struct {
	MIPSCaller     // Read-only binding to the contract
	MIPSTransactor // Write-only binding to the contract
	MIPSFilterer   // Log filterer for contract events
}

// MIPSCaller is an auto generated read-only Go binding around an Ethereum contract.
type MIPSCaller struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// MIPSTransactor is an auto generated write-only Go binding around an Ethereum contract.
type MIPSTransactor struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// MIPSFilterer is an auto generated log filtering Go binding around an Ethereum contract events.
type MIPSFilterer struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// MIPSSession is an auto generated Go binding around an Ethereum contract,
// with pre-set call and transact options.
type MIPSSession struct {
	Contract     *MIPS             // Generic contract binding to set the session for
	CallOpts     bind.CallOpts     // Call options to use throughout this session
	TransactOpts bind.TransactOpts // Transaction auth options to use throughout this session
}

// MIPSCallerSession is an auto generated read-only Go binding around an Ethereum contract,
// with pre-set call options.
type MIPSCallerSession struct {
	Contract *MIPSCaller   // Generic contract caller binding to set the session for
	CallOpts bind.CallOpts // Call options to use throughout this session
}

// MIPSTransactorSession is an auto generated write-only Go binding around an Ethereum contract,
// with pre-set transact options.
type MIPSTransactorSession struct {
	Contract     *MIPSTransactor   // Generic contract transactor binding to set the session for
	TransactOpts bind.TransactOpts // Transaction auth options to use throughout this session
}

// MIPSRaw is an auto generated low-level Go binding around an Ethereum contract.
type MIPSRaw struct {
	Contract *MIPS // Generic contract binding to access the raw methods on
}

// MIPSCallerRaw is an auto generated low-level read-only Go binding around an Ethereum contract.
type MIPSCallerRaw struct {
	Contract *MIPSCaller // Generic read-only contract binding to access the raw methods on
}

// MIPSTransactorRaw is an auto generated low-level write-only Go binding around an Ethereum contract.
type MIPSTransactorRaw struct {
	Contract *MIPSTransactor // Generic write-only contract binding to access the raw methods on
}

// NewMIPS creates a new instance of MIPS, bound to a specific deployed contract.
func NewMIPS(address common.Address, backend bind.ContractBackend) (*MIPS, error) {
	contract, err := bindMIPS(address, backend, backend, backend)
	if err != nil {
		return nil, err
	}
	return &MIPS{MIPSCaller: MIPSCaller{contract: contract}, MIPSTransactor: MIPSTransactor{contract: contract}, MIPSFilterer: MIPSFilterer{contract: contract}}, nil
}

// NewMIPSCaller creates a new read-only instance of MIPS, bound to a specific deployed contract.
func NewMIPSCaller(address common.Address, caller bind.ContractCaller) (*MIPSCaller, error) {
	contract, err := bindMIPS(address, caller, nil, nil)
	if err != nil {
		return nil, err
	}
	return &MIPSCaller{contract: contract}, nil
}

// NewMIPSTransactor creates a new write-only instance of MIPS, bound to a specific deployed contract.
func NewMIPSTransactor(address common.Address, transactor bind.ContractTransactor) (*MIPSTransactor, error) {
	contract, err := bindMIPS(address, nil, transactor, nil)
	if err != nil {
		return nil, err
	}
	return &MIPSTransactor{contract: contract}, nil
}

// NewMIPSFilterer creates a new log filterer instance of MIPS, bound to a specific deployed contract.
func NewMIPSFilterer(address common.Address, filterer bind.ContractFilterer) (*MIPSFilterer, error) {
	contract, err := bindMIPS(address, nil, nil, filterer)
	if err != nil {
		return nil, err
	}
	return &MIPSFilterer{contract: contract}, nil
}

// bindMIPS binds a generic wrapper to an already deployed contract.
func bindMIPS(address common.Address, caller bind.ContractCaller, transactor bind.ContractTransactor, filterer bind.ContractFilterer) (*bind.BoundContract, error) {
	parsed, err := abi.JSON(strings.NewReader(MIPSABI))
	if err != nil {
		return nil, err
	}
	return bind.NewBoundContract(address, parsed, caller, transactor, filterer), nil
}

// Call invokes the (constant) contract method with params as input values and
// sets the output to result. The result type might be a single field for simple
// returns, a slice of interfaces for anonymous returns and a struct for named
// returns.
func (_MIPS *MIPSRaw) Call(opts *bind.CallOpts, result *[]interface{}, method string, params ...interface{}) error {
	return _MIPS.Contract.MIPSCaller.contract.Call(opts, result, method, params...)
}

// Transfer initiates a plain transaction to move funds to the contract, calling
// its default method if one is available.
func (_MIPS *MIPSRaw) Transfer(opts *bind.TransactOpts) (*types.Transaction, error) {
	return _MIPS.Contract.MIPSTransactor.contract.Transfer(opts)
}

// Transact invokes the (paid) contract method with params as input values.
func (_MIPS *MIPSRaw) Transact(opts *bind.TransactOpts, method string, params ...interface{}) (*types.Transaction, error) {
	return _MIPS.Contract.MIPSTransactor.contract.Transact(opts, method, params...)
}

// Call invokes the (constant) contract method with params as input values and
// sets the output to result. The result type might be a single field for simple
// returns, a slice of interfaces for anonymous returns and a struct for named
// returns.
func (_MIPS *MIPSCallerRaw) Call(opts *bind.CallOpts, result *[]interface{}, method string, params ...interface{}) error {
	return _MIPS.Contract.contract.Call(opts, result, method, params...)
}

// Transfer initiates a plain transaction to move funds to the contract, calling
// its default method if one is available.
func (_MIPS *MIPSTransactorRaw) Transfer(opts *bind.TransactOpts) (*types.Transaction, error) {
	return _MIPS.Contract.contract.Transfer(opts)
}

// Transact invokes the (paid) contract method with params as input values.
func (_MIPS *MIPSTransactorRaw) Transact(opts *bind.TransactOpts, method string, params ...interface{}) (*types.Transaction, error) {
	return _MIPS.Contract.contract.Transact(opts, method, params...)
}

// BRKSTART is a free data retrieval call binding the contract method 0x155633fe.
//
// Solidity: function BRK_START() view returns(uint32)
func (_MIPS *MIPSCaller) BRKSTART(opts *bind.CallOpts) (uint32, error) {
	var out []interface{}
	err := _MIPS.contract.Call(opts, &out, "BRK_START")

	if err != nil {
		return *new(uint32), err
	}

	out0 := *abi.ConvertType(out[0], new(uint32)).(*uint32)

	return out0, err

}

// BRKSTART is a free data retrieval call binding the contract method 0x155633fe.
//
// Solidity: function BRK_START() view returns(uint32)
func (_MIPS *MIPSSession) BRKSTART() (uint32, error) {
	return _MIPS.Contract.BRKSTART(&_MIPS.CallOpts)
}

// BRKSTART is a free data retrieval call binding the contract method 0x155633fe.
//
// Solidity: function BRK_START() view returns(uint32)
func (_MIPS *MIPSCallerSession) BRKSTART() (uint32, error) {
	return _MIPS.Contract.BRKSTART(&_MIPS.CallOpts)
}

// Oracle is a free data retrieval call binding the contract method 0x7dc0d1d0.
//
// Solidity: function oracle() view returns(address oracle_)
func (_MIPS *MIPSCaller) Oracle(opts *bind.CallOpts) (common.Address, error) {
	var out []interface{}
	err := _MIPS.contract.Call(opts, &out, "oracle")

	if err != nil {
		return *new(common.Address), err
	}

	out0 := *abi.ConvertType(out[0], new(common.Address)).(*common.Address)

	return out0, err

}

// Oracle is a free data retrieval call binding the contract method 0x7dc0d1d0.
//
// Solidity: function oracle() view returns(address oracle_)
func (_MIPS *MIPSSession) Oracle() (common.Address, error) {
	return _MIPS.Contract.Oracle(&_MIPS.CallOpts)
}

// Oracle is a free data retrieval call binding the contract method 0x7dc0d1d0.
//
// Solidity: function oracle() view returns(address oracle_)
func (_MIPS *MIPSCallerSession) Oracle() (common.Address, error) {
	return _MIPS.Contract.Oracle(&_MIPS.CallOpts)
}

// Step is a paid mutator transaction binding the contract method 0xf8e0cb96.
//
// Solidity: function step(bytes stateData, bytes proof) returns(bytes32)
func (_MIPS *MIPSTransactor) Step(opts *bind.TransactOpts, stateData []byte, proof []byte) (*types.Transaction, error) {
	return _MIPS.contract.Transact(opts, "step", stateData, proof)
}

// Step is a paid mutator transaction binding the contract method 0xf8e0cb96.
//
// Solidity: function step(bytes stateData, bytes proof) returns(bytes32)
func (_MIPS *MIPSSession) Step(stateData []byte, proof []byte) (*types.Transaction, error) {
	return _MIPS.Contract.Step(&_MIPS.TransactOpts, stateData, proof)
}

// Step is a paid mutator transaction binding the contract method 0xf8e0cb96.
//
// Solidity: function step(bytes stateData, bytes proof) returns(bytes32)
func (_MIPS *MIPSTransactorSession) Step(stateData []byte, proof []byte) (*types.Transaction, error) {
	return _MIPS.Contract.Step(&_MIPS.TransactOpts, stateData, proof)
}
