// Code generated by github.com/fjl/gencodec. DO NOT EDIT.

package types

import (
	"encoding/json"
	"errors"
	"math/big"

	"github.com/ethereum/go-ethereum/common"
)

// MarshalJSON marshals as JSON.
func (t TransactionMeta) MarshalJSON() ([]byte, error) {
	type TransactionMeta struct {
		L1BlockNumber     *big.Int          `json:"l1BlockNumber"`
		L1MessageSender   *common.Address   `json:"l1MessageSender" gencodec:"required"`
		SignatureHashType SignatureHashType `json:"signatureHashType" gencodec:"required"`
		QueueOrigin       *big.Int          `json:"queueOrigin" gencodec:"required"`
		Index             *uint64           `json:"index" gencodec:"required"`
	}
	var enc TransactionMeta
	enc.L1BlockNumber = t.L1BlockNumber
	enc.L1MessageSender = t.L1MessageSender
	enc.SignatureHashType = t.SignatureHashType
	enc.QueueOrigin = t.QueueOrigin
	enc.Index = t.Index
	return json.Marshal(&enc)
}

// UnmarshalJSON unmarshals from JSON.
func (t *TransactionMeta) UnmarshalJSON(input []byte) error {
	type TransactionMeta struct {
		L1BlockNumber     *big.Int           `json:"l1BlockNumber"`
		L1MessageSender   *common.Address    `json:"l1MessageSender" gencodec:"required"`
		SignatureHashType *SignatureHashType `json:"signatureHashType" gencodec:"required"`
		QueueOrigin       *big.Int           `json:"queueOrigin" gencodec:"required"`
		Index             *uint64            `json:"index" gencodec:"required"`
	}
	var dec TransactionMeta
	if err := json.Unmarshal(input, &dec); err != nil {
		return err
	}
	if dec.L1BlockNumber != nil {
		t.L1BlockNumber = dec.L1BlockNumber
	}
	if dec.L1MessageSender == nil {
		return errors.New("missing required field 'l1MessageSender' for TransactionMeta")
	}
	t.L1MessageSender = dec.L1MessageSender
	if dec.SignatureHashType == nil {
		return errors.New("missing required field 'signatureHashType' for TransactionMeta")
	}
	t.SignatureHashType = *dec.SignatureHashType
	if dec.QueueOrigin == nil {
		return errors.New("missing required field 'queueOrigin' for TransactionMeta")
	}
	t.QueueOrigin = dec.QueueOrigin
	if dec.Index == nil {
		return errors.New("missing required field 'index' for TransactionMeta")
	}
	t.Index = dec.Index
	return nil
}
