package exchain

import "github.com/holiman/uint256"

const (
	ChainCheckpointInterval = 120 // 1 checkpoint every 120 blocks, from 1 to 120, 121 to 240, etc.

)

var (
	big1 = uint256.NewInt(1)
)

type Checkpoint uint64

func (c Checkpoint) Start() *uint256.Int {
	// start = interval * cp + 1
	start := new(uint256.Int).Add(big1, new(uint256.Int).Mul(uint256.NewInt(uint64(c)), uint256.NewInt(ChainCheckpointInterval)))
	return start
}

func (c Checkpoint) End() *uint256.Int {
	// end = interval * (cp + 1)
	end := new(uint256.Int).Mul(new(uint256.Int).Add(big1, uint256.NewInt(uint64(c))), uint256.NewInt(ChainCheckpointInterval))
	return end
}

func ToCheckpoint(number uint256.Int) Checkpoint {
	if number.IsZero() {
		return 0
	}
	cp := new(uint256.Int).Div(new(uint256.Int).SubUint64(&number, 1), uint256.NewInt(ChainCheckpointInterval))
	return Checkpoint(cp.Uint64())
}
