package exchain

import (
	"github.com/ethereum/go-ethereum/common"
	nebulav1 "github.com/exchain/go-exchain/exchain/protocol/gen/go/nebula/v1"
)

type Signer func(data []byte) ([]byte, error)

type Engine interface {
	Start() error
	NewPayload(params PayloadParams) (ExecutionResult, error)
	ProcessPayload(block *nebulav1.Block) (ExecutionResult, error)
}

type PayloadParams struct {
	Timestamp    uint64
	Proposer     common.Address
	L1Info       L1BlockInfo
	Transactions *nebulav1.TransactionList
	Signer       Signer
}

type ExecutionResult struct {
	Payload  *nebulav1.Block
	Receipts *nebulav1.TransactionReceiptList
}
