// Code generated - DO NOT EDIT.
// This file is a generated binding and any manual changes will be lost.

package bindings

import (
	"encoding/json"

	"github.com/ethereum-optimism/optimism/op-bindings/solc"
)

const MIPSStorageLayoutJSON = "{\"storage\":[{\"astId\":1000,\"contract\":\"src/cannon/MIPS.sol:MIPS\",\"label\":\"oracle\",\"offset\":0,\"slot\":\"0\",\"type\":\"t_contract(IPreimageOracle)1001\"}],\"types\":{\"t_contract(IPreimageOracle)1001\":{\"encoding\":\"inplace\",\"label\":\"contract IPreimageOracle\",\"numberOfBytes\":\"20\"}}}"

var MIPSStorageLayout = new(solc.StorageLayout)

var MIPSDeployedBin = "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"

var MIPSDeployedSourceMap = "1131:37326:106:-:0;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;1711:45;;1746:10;1711:45;;;;;188:10:257;176:23;;;158:42;;146:2;131:18;1711:45:106;;;;;;;;2145:29;;;;;;;;;;;;412:42:257;400:55;;;382:74;;370:2;355:18;2145:29:106;211:251:257;24844:6295:106;;;;;;:::i;:::-;;:::i;:::-;;;1687:25:257;;;1675:2;1660:18;24844:6295:106;1541:177:257;24844:6295:106;24922:7;24965:18;;:::i;:::-;25112:4;25105:5;25102:15;25092:113;;25185:1;25183;25176:11;25092:113;25241:4;25235:11;25248;25232:28;25222:116;;25318:1;25316;25309:11;25222:116;25386:3;25368:16;25365:25;25355:129;;25464:1;25462;25455:11;25355:129;25528:3;25514:12;25511:21;25501:124;;25605:1;25603;25596:11;25501:124;25885:24;;26230:4;25931:20;26301:2;25989:21;;25885:24;26047:18;25931:20;25989:21;;;25885:24;25862:21;25858:52;;;26047:18;25931:20;;;25989:21;;;25885:24;25858:52;;25931:20;;25989:21;;;25885:24;25858:52;;26047:18;25931:20;25989:21;;;25885:24;25858:52;;26047:18;25931:20;25989:21;;;25885:24;25858:52;;26047:18;25931:20;25989:21;;;25885:24;25858:52;;;26047:18;25931:20;25989:21;;;25885:24;25862:21;25858:52;;;26047:18;25931:20;25989:21;;;25885:24;25858:52;;26047:18;25931:20;25989:21;;;25885:24;25858:52;;26047:18;25931:20;26928:10;26047:18;26918:21;;;25989;;;;27031:1;27016:113;27041:2;27038:1;27035:9;27016:113;;;25885:24;;25862:21;25858:52;25931:20;;27109:1;25989:21;;;;25873:2;26047:18;;;;27059:1;27052:9;27016:113;;;27020:14;;;27207:5;:12;;;27203:71;;;27246:13;:11;:13::i;:::-;27239:20;;;;;27203:71;27288:10;;;:15;;27302:1;27288:15;;;;;27373:8;;;;-1:-1:-1;;27365:20:106;;-1:-1:-1;27365:7:106;:20::i;:::-;27351:34;-1:-1:-1;27415:10:106;27423:2;27415:10;;;;27492:1;27482:11;;;:26;;;27497:6;:11;;27507:1;27497:11;27482:26;27478:348;;;27747:64;27758:6;:11;;27768:1;27758:11;:20;;27776:2;27758:20;;;27772:1;27758:20;27747:64;;27809:1;27780:25;27783:4;27790:10;27783:17;27802:2;27780;:25::i;:::-;:30;;;;27747:10;:64::i;:::-;27740:71;;;;;;;27478:348;28075:15;;;;27870:9;;;;28007:4;28001:2;27993:10;;;27992:19;;;28075:15;28100:2;28092:10;;;28091:19;28075:36;;;;;;;:::i;:::-;;;;;;-1:-1:-1;28140:5:106;28164:11;;;;;:29;;;28179:6;:14;;28189:4;28179:14;28164:29;28160:832;;;28256:5;:15;;;28272:5;28256:22;;;;;;;;;:::i;:::-;;;;;;-1:-1:-1;;28319:4:106;28313:2;28305:10;;;28304:19;28160:832;;;28357:4;28348:6;:13;;;28344:648;;;28478:6;:13;;28488:3;28478:13;:30;;;;28495:6;:13;;28505:3;28495:13;28478:30;:47;;;;28512:6;:13;;28522:3;28512:13;28478:47;28474:253;;;28588:4;28595:6;28588:13;28583:18;;28344:648;;28474:253;28687:21;28690:4;28697:6;28690:13;28705:2;28687;:21::i;:::-;28682:26;;28344:648;;;28761:4;28751:6;:14;;;;:32;;;;28769:6;:14;;28779:4;28769:14;28751:32;:50;;;;28787:6;:14;;28797:4;28787:14;28751:50;28747:245;;;28871:5;:15;;;28887:5;28871:22;;;;;;;;;:::i;:::-;;;;;28866:27;;28972:5;28964:13;;28747:245;29021:1;29011:6;:11;;;;:25;;;;;29035:1;29026:6;:10;;;29011:25;29010:42;;;;29041:6;:11;;29051:1;29041:11;29010:42;29006:125;;;29079:37;29092:6;29100:4;29106:5;29113:2;29079:12;:37::i;:::-;29072:44;;;;;;;;;;;29006:125;29164:13;29145:16;29316:4;29306:14;;;;29302:444;;29385:19;29388:4;29393:6;29388:11;29401:2;29385;:19::i;:::-;29379:25;;;;29441:10;29436:15;;29475:16;29436:15;29489:1;29475:7;:16::i;:::-;29469:22;;29523:4;29513:6;:14;;;;:32;;;;;29531:6;:14;;29541:4;29531:14;;29513:32;29509:223;;;29610:4;29598:16;;29712:1;29704:9;;29509:223;29322:424;29302:444;29779:10;29792:26;29800:4;29806:2;29810;29814:3;29792:7;:26::i;:::-;29821:10;29792:39;;;;-1:-1:-1;29917:4:106;29910:11;;;29949;;;:24;;;;;29972:1;29964:4;:9;;;;29949:24;:39;;;;;29984:4;29977;:11;;;29949:39;29945:787;;;30012:4;:9;;30020:1;30012:9;:22;;;;30025:4;:9;;30033:1;30025:9;30012:22;30008:124;;;30076:37;30087:4;:9;;30095:1;30087:9;:21;;30103:5;30087:21;;;30099:1;30087:21;30110:2;30076:10;:37::i;:::-;30069:44;;;;;;;;;;;;;;;30008:124;30154:4;:11;;30162:3;30154:11;30150:101;;30204:28;30213:5;30220:2;30224:7;;;;30204:8;:28::i;30150:101::-;30272:4;:11;;30280:3;30272:11;30268:101;;30322:28;30331:5;30338:2;30342:7;;;;;30322:8;:28::i;30268:101::-;30439:4;:11;;30447:3;30439:11;30435:80;;30481:15;:13;:15::i;30435:80::-;30618:4;30610;:12;;;;:27;;;;;30633:4;30626;:11;;;30610:27;30606:112;;;30668:31;30679:4;30685:2;30689;30693:5;30668:10;:31::i;30606:112::-;30792:6;:14;;30802:4;30792:14;:28;;;;-1:-1:-1;30810:10:106;;;;;30792:28;30788:93;;;30865:1;30840:5;:15;;;30856:5;30840:22;;;;;;;;;:::i;:::-;:26;;;;:22;;;;;;:26;30788:93;30927:9;:26;;30940:13;30927:26;30923:92;;30973:27;30982:9;30993:1;30996:3;30973:8;:27::i;:::-;31096:26;31105:5;31112:3;31117:4;31096:8;:26::i;:::-;31089:33;;;;;;;;;;;;;24844:6295;;;;;;;:::o;2859:1770::-;3406:4;3400:11;;3322:4;3125:31;3114:43;;3185:13;3125:31;3524:2;3224:13;;3114:43;3131:24;3125:31;3224:13;;;3114:43;;;;3131:24;3125:31;3224:13;;;3114:43;3131:24;3125:31;3224:13;;;3114:43;3131:24;3125:31;3224:13;;;3114:43;3131:24;3125:31;3224:13;;;3114:43;3131:24;3125:31;3224:13;;;3114:43;3131:24;3125:31;3224:13;;;3114:43;3131:24;3125:31;3224:13;;;3114:43;3131:24;3125:31;3224:13;;;3114:43;2900:12;;4129:13;;3224;;;2900:12;4222:112;4247:2;4244:1;4241:9;4222:112;;;3141:13;3131:24;;3125:31;3114:43;;3145:2;3185:13;;;;4318:1;3224:13;;;;4265:1;4258:9;4222:112;;;4226:14;4397:1;4393:2;4386:13;4492:5;4488:2;4484:14;4477:5;4472:27;4598:14;;;4581:32;;;2859:1770;-1:-1:-1;;2859:1770:106:o;20691:1935::-;20764:11;20875:14;20892:24;20904:11;20892;:24::i;:::-;20875:41;;21024:1;21017:5;21013:13;21010:69;;;21059:1;21056;21049:12;21010:69;21208:2;21196:15;;;21149:20;21638:5;21635:1;21631:13;21673:4;21709:1;21694:411;21719:2;21716:1;21713:9;21694:411;;;21842:2;21830:15;;;21779:20;21877:12;;;21891:1;21873:20;21914:86;;;;22006:1;22001:86;;;;21866:221;;21914:86;21372:1;21365:12;;;21405:2;21398:13;;;21450:2;21437:16;;21947:31;;21914:86;;22001;21372:1;21365:12;;;21405:2;21398:13;;;21450:2;21437:16;;22034:31;;21866:221;-1:-1:-1;;21737:1:106;21730:9;21694:411;;;21698:14;22215:4;22209:11;22194:26;;22301:7;22295:4;22292:17;22282:124;;22343:10;22340:1;22333:21;22385:2;22382:1;22375:13;22282:124;-1:-1:-1;;22533:2:106;22522:14;;;;22510:10;22506:31;22503:1;22499:39;22567:16;;;;22585:10;22563:33;;20691:1935;-1:-1:-1;;;20691:1935:106:o;2417:334::-;2478:6;2537:18;;;;2546:8;;;;2537:18;;;;;;2536:25;;;;;2553:1;2600:2;:9;;;2594:16;;;;;2593:22;;2592:32;;;;;;;2654:9;;2653:15;2536:25;2711:21;;2731:1;2711:21;;;2722:6;2711:21;2696:11;;;;;:37;;-1:-1:-1;;;2417:334:106;;;;:::o;17831:821::-;17900:12;17987:18;;:::i;:::-;18055:4;18046:13;;18107:5;:8;;;18116:1;18107:10;18091:26;;:5;:12;;;:26;;;18087:93;;18137:28;;;;;2114:2:257;18137:28:106;;;2096:21:257;2153:2;2133:18;;;2126:30;2192:20;2172:18;;;2165:48;2230:18;;18137:28:106;;;;;;;;18087:93;18269:8;;;;;18302:12;;;;;18291:23;;;;;;;18328:20;;;;;18269:8;18460:13;;;18456:90;;18521:6;18530:1;18521:10;18493:5;:15;;;18509:8;18493:25;;;;;;;;;:::i;:::-;:38;;;;:25;;;;;;:38;18456:90;18622:13;:11;:13::i;:::-;18615:20;17831:821;-1:-1:-1;;;;;17831:821:106:o;12694:2024::-;12791:12;12877:18;;:::i;:::-;12945:4;12936:13;;12977:17;13037:5;:8;;;13046:1;13037:10;13021:26;;:5;:12;;;:26;;;13017:95;;13067:30;;;;;2461:2:257;13067:30:106;;;2443:21:257;2500:2;2480:18;;;2473:30;2539:22;2519:18;;;2512:50;2579:18;;13067:30:106;2259:344:257;13017:95:106;13182:7;:12;;13193:1;13182:12;:28;;;;13198:7;:12;;13209:1;13198:12;13182:28;13178:947;;;13230:9;13242:5;:15;;;13258:6;13242:23;;;;;;;;;:::i;:::-;;;;;13230:35;;13306:2;13299:9;;:3;:9;;;:25;;;;;13312:7;:12;;13323:1;13312:12;13299:25;13298:58;;;;13337:2;13330:9;;:3;:9;;;;:25;;;;;13343:7;:12;;13354:1;13343:12;13330:25;13283:73;;13212:159;13178:947;;;13468:7;:12;;13479:1;13468:12;13464:661;;13529:1;13521:3;13515:15;;;;13500:30;;13464:661;;;13633:7;:12;;13644:1;13633:12;13629:496;;13693:1;13686:3;13680:14;;;13665:29;;13629:496;;;13814:7;:12;;13825:1;13814:12;13810:315;;13902:4;13896:2;13887:11;;;13886:20;13872:10;13929:8;;;13925:84;;13989:1;13982:3;13976:14;;;13961:29;;13925:84;14030:3;:8;;14037:1;14030:8;14026:85;;14091:1;14083:3;14077:15;;;;14062:30;;14026:85;13828:297;13810:315;14201:8;;;;;14279:12;;;;14268:23;;;;;14435:178;;;;14526:1;14500:22;14503:5;14511:6;14503:14;14519:2;14500;:22::i;:::-;:27;;;;;;;14486:42;;14495:1;14486:42;14471:57;:12;;;:57;14435:178;;;14582:12;;;;;14597:1;14582:16;14567:31;;;;14435:178;14688:13;:11;:13::i;:::-;14681:20;12694:2024;-1:-1:-1;;;;;;;;12694:2024:106:o;31185:7270::-;31272:6;31330:10;31338:2;31330:10;;;;;;31381:11;;31493:4;31484:13;;31480:6915;;;31624:1;31614:6;:11;;;;:27;;;;;31638:3;31629:6;:12;;;31614:27;31610:568;;;31669:6;:11;;31679:1;31669:11;31665:455;;-1:-1:-1;31691:4:106;31665:455;;;31743:6;:11;;31753:1;31743:11;31739:381;;-1:-1:-1;31765:4:106;31739:381;;;31813:6;:13;;31823:3;31813:13;31809:311;;-1:-1:-1;31837:4:106;31809:311;;;31882:6;:13;;31892:3;31882:13;31878:242;;-1:-1:-1;31906:4:106;31878:242;;;31952:6;:13;;31962:3;31952:13;31948:172;;-1:-1:-1;31976:4:106;31948:172;;;32021:6;:13;;32031:3;32021:13;32017:103;;-1:-1:-1;32045:4:106;32017:103;;;32089:6;:13;;32099:3;32089:13;32085:35;;-1:-1:-1;32113:4:106;32085:35;32158:1;32149:10;;31610:568;32239:6;:11;;32249:1;32239:11;32235:3550;;32303:4;32298:1;32290:9;;;32289:18;32340:4;32290:9;32333:11;;;32329:1319;;;32432:4;32424;:12;;;32420:1206;;32475:2;32468:9;;;;;;;32420:1206;32589:4;:12;;32597:4;32589:12;32585:1041;;32640:11;;;;;;;;-1:-1:-1;32633:18:106;;-1:-1:-1;;32633:18:106;32585:1041;32764:4;:12;;32772:4;32764:12;32760:866;;32815:11;;;;;;;;-1:-1:-1;32808:18:106;;-1:-1:-1;;32808:18:106;32760:866;32942:4;:12;;32950:4;32942:12;32938:688;;32993:27;33002:5;32996:11;;:2;:11;;;;33014:5;33009:2;:10;32993:2;:27::i;32938:688::-;33142:4;:12;;33150:4;33142:12;33138:488;;-1:-1:-1;;;;33193:17:106;;;33205:4;33200:9;;33193:17;33186:24;;33138:488;33333:4;:12;;33341:4;33333:12;33329:297;;-1:-1:-1;;;;33384:17:106;;;33396:4;33391:9;;33384:17;33377:24;;33329:297;33527:4;:12;;33535:4;33527:12;33523:103;;33578:21;33587:2;33581:8;;:2;:8;;;;33596:2;33591;:7;33578:2;:21::i;33523:103::-;33808:4;:12;;33816:4;33808:12;:28;;;;33824:4;:12;;33832:4;33824:12;33808:28;33804:1149;;;33876:2;33871;:7;33864:14;;;;;;;33804:1149;33966:4;:12;;33974:4;33966:12;:28;;;;33982:4;:12;;33990:4;33982:12;33966:28;33962:991;;;34034:2;34029;:7;34022:14;;;;;;;33962:991;34116:4;:12;;34124:4;34116:12;34112:841;;34168:2;34163;:7;34156:14;;;;;;;34112:841;34249:4;:12;;34257:4;34249:12;34245:708;;34302:2;34297;:7;34289:16;;;;;;;34245:708;34385:4;:12;;34393:4;34385:12;34381:572;;34438:2;34433;:7;34425:16;;;;;;;34381:572;34521:4;:12;;34529:4;34521:12;34517:436;;-1:-1:-1;;;;34570:7:106;;;34568:10;34561:17;;34517:436;34681:4;:12;;34689:4;34681:12;34677:276;;34746:2;34728:21;;34734:2;34728:21;;;:29;;34756:1;34728:29;;;34752:1;34728:29;34721:36;;;;;;;;;34677:276;34870:4;:12;;34878:4;34870:12;34866:87;;34920:2;34917:5;;:2;:5;;;:13;;34929:1;34917:13;;34866:87;32252:2719;31480:6915;;32235:3550;35042:6;:13;;35052:3;35042:13;35038:747;;35092:2;35086;:8;;;;35079:15;;;;;;35038:747;35167:6;:14;;35177:4;35167:14;35163:622;;35236:4;:9;;35244:1;35236:9;35232:100;;-1:-1:-1;;;35287:21:106;;;35273:36;;35232:100;35384:4;:12;;35392:4;35384:12;:28;;;;35400:4;:12;;35408:4;35400:12;35384:28;35380:387;;;35444:4;:12;;35452:4;35444:12;35440:83;;35493:3;;;35440:83;35548:8;35586:125;35596:10;35593:13;;:18;35586:125;;35676:8;35643:3;35676:8;;;;;35643:3;35586:125;;;35743:1;-1:-1:-1;35736:8:106;;-1:-1:-1;;35736:8:106;35380:387;31480:6915;;;35830:4;35821:6;:13;;;35817:2578;;;35880:6;:14;;35890:4;35880:14;35876:1208;;35925:42;35943:2;35948:1;35943:6;35953:1;35942:12;35937:2;:17;35929:26;;:3;:26;;;;35959:4;35928:35;35965:1;35925:2;:42::i;:::-;35918:49;;;;;;35876:1208;36034:6;:14;;36044:4;36034:14;36030:1054;;36079:45;36097:2;36102:1;36097:6;36107:1;36096:12;36091:2;:17;36083:26;;:3;:26;;;;36113:6;36082:37;36121:2;36079;:45::i;36030:1054::-;36192:6;:14;;36202:4;36192:14;36188:896;;-1:-1:-1;;;36243:21:106;36262:1;36257;36252:6;;36251:12;36243:21;;36300:36;;;36371:5;36366:10;;36243:21;;;;;36365:18;36358:25;;36188:896;36450:6;:14;;36460:4;36450:14;36446:638;;36495:3;36488:10;;;;;;36446:638;36566:6;:14;;36576:4;36566:14;36562:522;;36626:2;36631:1;36626:6;36636:1;36625:12;36620:2;:17;36612:26;;:3;:26;;;;36642:4;36611:35;36604:42;;;;;;36562:522;36714:6;:14;;36724:4;36714:14;36710:374;;36774:2;36779:1;36774:6;36784:1;36773:12;36768:2;:17;36760:26;;:3;:26;;;;36790:6;36759:37;36752:44;;;;;;36710:374;36864:6;:14;;36874:4;36864:14;36860:224;;-1:-1:-1;;;36915:26:106;36939:1;36934;36929:6;;36928:12;36923:2;:17;36915:26;;36977:41;;;37053:5;37048:10;;36915:26;;;;;37047:18;37040:25;;35817:2578;37138:6;:14;;37148:4;37138:14;37134:1261;;-1:-1:-1;;;37191:4:106;37185:34;37217:1;37212;37207:6;;37206:12;37201:2;:17;37185:34;;37271:27;;;37251:48;;;37325:10;;37186:9;;;37185:34;;37324:18;37317:25;;37134:1261;37397:6;:14;;37407:4;37397:14;37393:1002;;-1:-1:-1;;;37450:6:106;37444:36;37478:1;37473;37468:6;;37467:12;37462:2;:17;37444:36;;37532:29;;;37512:50;;;37588:10;;37445:11;;;37444:36;;37587:18;37580:25;;37393:1002;37661:6;:14;;37671:4;37661:14;37657:738;;-1:-1:-1;;;37708:20:106;37726:1;37721;37716:6;;37715:12;37708:20;;37760:36;;;37828:5;37822:11;;37708:20;;;;;37821:19;37814:26;;37657:738;37895:6;:14;;37905:4;37895:14;37891:504;;37936:2;37929:9;;;;;;37891:504;37994:6;:14;;38004:4;37994:14;37990:405;;-1:-1:-1;;;38041:25:106;38064:1;38059;38054:6;;38053:12;38048:2;:17;38041:25;;38098:41;;;38171:5;38165:11;;38041:25;;;;;38164:19;38157:26;;37990:405;38238:6;:14;;38248:4;38238:14;38234:161;;38279:3;38272:10;;;;;;38234:161;38337:6;:14;;38347:4;38337:14;38333:62;;38378:2;38371:9;;;;;;38333:62;38409:29;;;;;2810:2:257;38409:29:106;;;2792:21:257;2849:2;2829:18;;;2822:30;2888:21;2868:18;;;2861:49;2927:18;;38409:29:106;2608:343:257;18933:782:106;19019:12;19106:18;;:::i;:::-;-1:-1:-1;19174:4:106;19281:2;19269:14;;;;19261:41;;;;;;;3158:2:257;19261:41:106;;;3140:21:257;3197:2;3177:18;;;3170:30;3236:16;3216:18;;;3209:44;3270:18;;19261:41:106;2956:338:257;19261:41:106;19398:14;;;;;;;:30;;;19416:12;19398:30;19394:102;;;19477:4;19448:5;:15;;;19464:9;19448:26;;;;;;;;;:::i;:::-;:33;;;;:26;;;;;;:33;19394:102;19551:12;;;;;19540:23;;;;:8;;;:23;19607:1;19592:16;;;19577:31;;;19685:13;:11;:13::i;4670:7638::-;4713:12;4799:18;;:::i;:::-;-1:-1:-1;4977:15:106;;:18;;;;4867:4;5137:18;;;;5181;;;;5225;;;;;4867:4;;4957:17;;;;5137:18;5181;5315;;;5329:4;5315:18;5311:6687;;5365:2;5392:4;5389:7;;:12;5385:120;;5481:4;5478:7;;5470:4;:16;5464:22;5385:120;5526:2;:7;;5532:1;5526:7;5522:161;;5562:10;;;;;5594:16;;;;;;;;5562:10;-1:-1:-1;5522:161:106;;;5662:2;5657:7;;5522:161;5335:362;5311:6687;;;5799:10;:18;;5813:4;5799:18;5795:6203;;1746:10;5837:14;;5795:6203;;;5935:10;:18;;5949:4;5935:18;5931:6067;;5978:1;5973:6;;5931:6067;;;6103:10;:18;;6117:4;6103:18;6099:5899;;6156:4;6141:12;;;:19;6178:26;;;:14;;;:26;6229:13;:11;:13::i;:::-;6222:20;;;;;;;;;4670:7638;:::o;6099:5899::-;6368:10;:18;;6382:4;6368:18;6364:5634;;6519:14;;;6515:2662;6364:5634;6515:2662;6689:22;;;;;6685:2492;;6814:10;6827:27;6835:2;6840:10;6835:15;6852:1;6827:7;:27::i;:::-;6938:17;;;;6814:40;;-1:-1:-1;6938:17:106;6916:19;7088:14;7107:1;7082:26;7078:131;;7150:36;7174:11;1277:21:107;1426:15;;;1467:8;1461:4;1454:22;1595:4;1582:18;;1602:19;1578:44;1624:11;1575:61;;1222:430;7150:36:106;7136:50;;7078:131;7231:11;7262:6;;7295:20;;;;;7262:54;;;;;;;;3472:25:257;;;3545:10;3533:23;;;3513:18;;;3506:51;7231:11:106;;7262:6;;;:19;;3445:18:257;;7262:54:106;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;:::i;:::-;7230:86;;;;7543:1;7539:2;7535:10;7640:9;7637:1;7633:17;7722:6;7715:5;7712:17;7709:40;;;7742:5;7732:15;;7709:40;;7825:6;7821:2;7818:14;7815:34;;;7845:2;7835:12;;7815:34;7951:3;7946:1;7938:6;7934:14;7929:3;7925:24;7921:34;7914:41;;8051:3;8047:1;8035:9;8026:6;8023:1;8019:14;8015:30;8011:38;8007:48;8000:55;;8175:1;8171;8167;8155:9;8152:1;8148:17;8144:25;8140:33;8136:41;8302:1;8298;8294;8285:6;8273:9;8270:1;8266:17;8262:30;8258:38;8254:46;8250:54;8232:72;;8402:10;8398:15;8392:4;8388:26;8380:34;;8518:3;8510:4;8506:9;8501:3;8497:19;8494:28;8487:35;;;;8664:33;8673:2;8678:10;8673:15;8690:1;8693:3;8664:8;:33::i;:::-;8719:20;;;:38;;;;;;;;;-1:-1:-1;6685:2492:106;;-1:-1:-1;;;6685:2492:106;;8876:18;;;;;8872:305;;9046:2;9041:7;;6364:5634;;8872:305;9116:10;9111:15;;2054:3;9148:10;;8872:305;6364:5634;;;9306:10;:18;;9320:4;9306:18;9302:2696;;9460:15;;;1825:1;9460:15;;:34;;-1:-1:-1;9479:15:106;;;1860:1;9479:15;9460:34;:57;;;-1:-1:-1;9498:19:106;;;1937:1;9498:19;9460:57;9456:1609;;;9546:2;9541:7;;9302:2696;;9456:1609;9672:23;;;;;9668:1397;;9719:10;9732:27;9740:2;9745:10;9740:15;9757:1;9732:7;:27::i;:::-;9835:17;;;;9719:40;;-1:-1:-1;10078:1:106;10070:10;;10172:1;10168:17;10247:13;;;10244:32;;;10269:5;10263:11;;10244:32;10555:14;;;10361:1;10551:22;;;10547:32;;;;10444:26;10468:1;10353:10;;;10448:18;;;10444:26;10543:43;10349:20;;10651:12;10779:17;;;:23;10847:1;10824:20;;;:24;10357:2;-1:-1:-1;10357:2:106;6364:5634;;9302:2696;11267:10;:18;;11281:4;11267:18;11263:735;;11361:2;:7;;11367:1;11361:7;11357:627;;11434:14;;;;;:40;;-1:-1:-1;11452:22:106;;;1979:1;11452:22;11434:40;:62;;;-1:-1:-1;11478:18:106;;;1898:1;11478:18;11434:62;11430:404;;;11529:1;11524:6;;11357:627;;11430:404;11575:15;;;1825:1;11575:15;;:34;;-1:-1:-1;11594:15:106;;;1860:1;11594:15;11575:34;:61;;;-1:-1:-1;11613:23:106;;;2022:1;11613:23;11575:61;:84;;;-1:-1:-1;11640:19:106;;;1937:1;11640:19;11575:84;11571:263;;;11692:1;11687:6;;6364:5634;;11357:627;11885:10;11880:15;;2088:4;11917:11;;11357:627;12073:15;;;;;:23;;;;:18;;;;:23;;;;12110:15;;:23;;;:18;;;;:23;-1:-1:-1;12199:12:106;;;;12188:23;;;:8;;;:23;12255:1;12240:16;12225:31;;;;;12278:13;:11;:13::i;15059:2480::-;15153:12;15239:18;;:::i;:::-;-1:-1:-1;15307:4:106;15339:10;15447:13;;;15456:4;15447:13;15443:1705;;-1:-1:-1;15486:8:106;;;;15443:1705;;;15605:5;:13;;15614:4;15605:13;15601:1547;;15638:14;;;:8;;;:14;15601:1547;;;15768:5;:13;;15777:4;15768:13;15764:1384;;-1:-1:-1;15807:8:106;;;;15764:1384;;;15926:5;:13;;15935:4;15926:13;15922:1226;;15959:14;;;:8;;;:14;15922:1226;;;16100:5;:13;;16109:4;16100:13;16096:1052;;16227:9;16173:17;16153;;;16173;;;;16153:37;16234:2;16227:9;;;;;16209:8;;;:28;16255:22;:8;;;:22;16096:1052;;;16414:5;:13;;16423:4;16414:13;16410:738;;16481:11;16467;;;16481;;;16467:25;16536:2;16529:9;;;;;16511:8;;;:28;16557:22;:8;;;:22;16410:738;;;16738:5;:13;;16747:4;16738:13;16734:414;;16808:3;16789:23;;16795:3;16789:23;;;;;;;:::i;:::-;;16771:42;;:8;;;:42;16849:23;;;;;;;;;;;;;:::i;:::-;;16831:42;;:8;;;:42;16734:414;;;17042:5;:13;;17051:4;17042:13;17038:110;;17092:3;17086:9;;:3;:9;;;;;;;:::i;:::-;;17075:20;;;;:8;;;:20;17124:9;;;;;;;;;;;:::i;:::-;;17113:20;;:8;;;:20;17038:110;17241:14;;;;17237:85;;17304:3;17275:5;:15;;;17291:9;17275:26;;;;;;;;;:::i;:::-;:32;;;;:26;;;;;;:32;17237:85;17376:12;;;;;17365:23;;;;:8;;;:23;17432:1;17417:16;;;17402:31;;;17509:13;:11;:13::i;:::-;17502:20;15059:2480;-1:-1:-1;;;;;;;15059:2480:106:o;22962:1758::-;23138:14;23155:24;23167:11;23155;:24::i;:::-;23138:41;;23287:1;23280:5;23276:13;23273:69;;;23322:1;23319;23312:12;23273:69;23477:2;23671:15;;;23496:2;23485:14;;23473:10;23469:31;23466:1;23462:39;23627:16;;;23412:20;;23612:10;23601:22;;;23597:27;23587:38;23584:60;24113:5;24110:1;24106:13;24184:1;24169:411;24194:2;24191:1;24188:9;24169:411;;;24317:2;24305:15;;;24254:20;24352:12;;;24366:1;24348:20;24389:86;;;;24481:1;24476:86;;;;24341:221;;24389:86;21372:1;21365:12;;;21405:2;21398:13;;;21450:2;21437:16;;24422:31;;24389:86;;24476;21372:1;21365:12;;;21405:2;21398:13;;;21450:2;21437:16;;24509:31;;24341:221;-1:-1:-1;;24212:1:106;24205:9;24169:411;;;-1:-1:-1;;24679:4:106;24672:18;-1:-1:-1;;;;22962:1758:106:o;19919:558::-;20241:20;;;20265:7;20241:32;20234:3;:40;;;20331:14;;20374:17;;20368:24;;;20360:72;;;;;;;4209:2:257;20360:72:106;;;4191:21:257;4248:2;4228:18;;;4221:30;4287:34;4267:18;;;4260:62;4358:5;4338:18;;;4331:33;4381:19;;20360:72:106;4007:399:257;20360:72:106;20446:14;19919:558;;;:::o;-1:-1:-1:-;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;:::i;:::-;;;;:::o;:::-;;;;;;;;;;;;;;;;;;;;;;;;:::o;467:347:257:-;518:8;528:6;582:3;575:4;567:6;563:17;559:27;549:55;;600:1;597;590:12;549:55;-1:-1:-1;623:20:257;;666:18;655:30;;652:50;;;698:1;695;688:12;652:50;735:4;727:6;723:17;711:29;;787:3;780:4;771:6;763;759:19;755:30;752:39;749:59;;;804:1;801;794:12;749:59;467:347;;;;;:::o;819:717::-;909:6;917;925;933;986:2;974:9;965:7;961:23;957:32;954:52;;;1002:1;999;992:12;954:52;1042:9;1029:23;1071:18;1112:2;1104:6;1101:14;1098:34;;;1128:1;1125;1118:12;1098:34;1167:58;1217:7;1208:6;1197:9;1193:22;1167:58;:::i;:::-;1244:8;;-1:-1:-1;1141:84:257;-1:-1:-1;1332:2:257;1317:18;;1304:32;;-1:-1:-1;1348:16:257;;;1345:36;;;1377:1;1374;1367:12;1345:36;;1416:60;1468:7;1457:8;1446:9;1442:24;1416:60;:::i;:::-;819:717;;;;-1:-1:-1;1495:8:257;-1:-1:-1;;;;819:717:257:o;1723:184::-;1775:77;1772:1;1765:88;1872:4;1869:1;1862:15;1896:4;1893:1;1886:15;3568:245;3647:6;3655;3708:2;3696:9;3687:7;3683:23;3679:32;3676:52;;;3724:1;3721;3714:12;3676:52;-1:-1:-1;;3747:16:257;;3803:2;3788:18;;;3782:25;3747:16;;3782:25;;-1:-1:-1;3568:245:257:o;3818:184::-;3870:77;3867:1;3860:88;3967:4;3964:1;3957:15;3991:4;3988:1;3981:15"

func init() {
	if err := json.Unmarshal([]byte(MIPSStorageLayoutJSON), MIPSStorageLayout); err != nil {
		panic(err)
	}

	layouts["MIPS"] = MIPSStorageLayout
	deployedBytecodes["MIPS"] = MIPSDeployedBin
}
