package wrapper

import (
	"github.com/ethereum/go-ethereum/common"
	"github.com/ethereum/go-ethereum/crypto"
	"math/big"
	"testing"
)

func TestWhash(t *testing.T) {
	user := common.HexToAddress("0x000000000000000000000000000000000000dead")
	coin := "ETH"
	value := big.NewInt(1e18)
	//ethers.keccak256(ethers.toUtf8Bytes("test transaction"));
	hash := crypto.Keccak256Hash([]byte("test transaction"))
	whash := Whash(user, coin, value, hash)
	expected := common.HexToHash("0xe7251ba12a5199190894e1c38c2bc80324901f054ccd2523640e47032630c560")
	if whash != expected {
		t.Errorf("expected %s, got %s", expected.Hex(), whash.Hex())
	} else {
		t.Logf("success")
	}
}
