package metrics

import (
	"github.com/exchain/go-exchain/exchain/wrapper"
)

type TestMetrics struct {
	noopMetrics
	PendingBlocksBytesCurrent float64
}

var _ Metricer = new(TestMetrics)

func (m *TestMetrics) RecordL2BlockInPendingQueue(block *wrapper.BlkWrapper) {
	_, rawSize := estimateBatchSize(block)
	m.PendingBlocksBytesCurrent += float64(rawSize)

}
func (m *TestMetrics) RecordL2BlockInChannel(block *wrapper.BlkWrapper) {
	_, rawSize := estimateBatchSize(block)
	m.PendingBlocksBytesCurrent -= float64(rawSize)
}
