package dial

import (
	"context"
	"github.com/exchain/go-exchain/exchain/wrapper"
	"math/big"
)

// ExchainClientInterface is an interface for providing an ethclient.Client
// It does not describe all of the functions an ethclient.Client has, only the ones used by callers of the L2 Providers
type ExchainClientInterface interface {
	BlockByNumber(ctx context.Context, number *big.Int) (*wrapper.BlkWrapper, error)
	Close()
}
