package bindings

import (
	"github.com/ethereum/go-ethereum/accounts/abi/bind"
	"github.com/ethereum/go-ethereum/common"
	"github.com/ethereum/go-ethereum/ethclient"
	"math/big"
	"testing"
)

func TestL2oo(t *testing.T) {
	url := "https://achain.bitheart.org"
	client, _ := ethclient.Dial(url)
	l2ooContract, _ := NewL2OutputOracle(common.HexToAddress("0xB90B39722517Fcaa565146Ee3877fF9AEa0C9a85"), client)
	callOpts := &bind.CallOpts{}
	index, err := l2ooContract.GetL2OutputIndexAfter(callOpts, big.NewInt(10))
	if err != nil {
		t.Error(err)
	} else {
		t.Log("index:", index)
	}
}
