# Glossary

<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->
**Table of Contents**

- [General Terms](#general-terms)
  - [Layer 1 (L1)](#layer-1-l1)
  - [Layer 2 (L2)](#layer-2-l2)
  - [Block](#block)
  - [EOA](#eoa)
  - [Merkle Patricia Trie](#merkle-patricia-trie)
  - [Chain Re-Organization](#chain-re-organization)
  - [Predeployed Contract ("Predeploy")](#predeployed-contract-predeploy)
  - [Receipt](#receipt)
  - [Transaction Type](#transaction-type)
  - [Fork Choice Rule](#fork-choice-rule)
- [Sequencing](#sequencing)
  - [Sequencing window](#sequencing-window)
  - [Sequencing epoch](#sequencing-epoch)
  - [Sequencer batch](#sequencer-batch)
- [Deposits](#deposits)
  - [Deposited Transaction](#deposited-transaction)
  - [L1 Attributes Deposited Transaction](#l1-attributes-deposited-transaction)
  - [User-Deposited Transaction](#user-deposited-transaction)
  - [Depositing Call](#depositing-call)
  - [Depositing Transaction](#depositing-transaction)
  - [Depositor](#depositor)
  - [Deposited Transaction Type](#deposited-transaction-type)
  - [Deposit Contract](#deposit-contract)
- [Withdrawals](#withdrawals)
  - [Relayer](#relayer)
- [Other L2 Chain Concepts](#other-l2-chain-concepts)
  - [Address Aliasing](#address-aliasing)
  - [L2 Chain Inception](#l2-chain-inception)
  - [Rollup Node](#rollup-node)
  - [Rollup Driver](#rollup-driver)
  - [L2 Chain Derivation](#l2-chain-derivation)
  - [L2 Derivation Inputs](#l2-derivation-inputs)
  - [Payload Attributes](#payload-attributes)
  - [L1 Attributes Predeployed Contract](#l1-attributes-predeployed-contract)
  - [L2 Output Root](#l2-output-root)
- [Execution Engine Concepts](#execution-engine-concepts)
  - [Execution Engine](#execution-engine)

<!-- END doctoc generated TOC please keep comment here to allow auto update -->

------------------------------------------------------------------------------------------------------------------------

# General Terms

## Layer 1 (L1)

[L1]: glossary.md#layer-1-L1

Refers the Ethereum blockchain, used in contrast to [layer 2][L2], which refers to Optimism.

## Layer 2 (L2)

[L2]: glossary.md#layer-2-L2

Refers to the Optimism blockchain (specified in this repository), used in contrast to [layer 1][L1], which
refers to the Ethereum blockchain.

## Block

[block]: glossary.md#block

Can refer to an [L1] block, or to an [L2] block, which are structured similarly.

A block is a sequential list of transactions, along with a couple of properties stored in the *header* of the block. A
description of these properties can be found in code comments [here][nano-header], or in the [Ethereum yellow paper
(pdf)][yellow], section 4.3.

It is useful to distinguish between input block properties, which are known before executing the transactions in the
block, and output block properties, which are derived after executing the block's transactions. These include various
[Merkle Patricia Trie roots][mpt] that notably commit to the L2 state and to the log events emitted during execution.

## EOA

[EOA]: glossary.md#EOA

"Externally Owned Account", an Ethereum term to designate addresses operated by users, as opposed to contract addresses.

## Merkle Patricia Trie

[mpt]: glossary.md#merkle-patricia-trie

A [Merkle Patricia Trie (MPT)][mpt-details] is a sparse trie, which is a tree-like structure that maps keys to values.
The root hash of a MPT is a commitment to the contents of the tree, which allows a
proof to be constructed for any key-value mapping encoded in the tree. Such a proof is called a Merkle proof, and can be
verified against the Merkle root.

## Chain Re-Organization

[reorg]: glossary.md#chain-re-organization

A re-organization, or re-org for short, is whenever the head of a blockchain (its last block) changes (as dictated by
the [fork choice rule][fork-choice-rule]) to a block that is not a child of the previous head.

L1 re-orgs can happen because of network conditions or attacks. L2 re-orgs are a consequence of L1 re-orgs, mediated via
[L2 chain derivation][derivation].

## Predeployed Contract ("Predeploy")

[predeploy]: glossary.md#predeployed-contract-predeploy

A contract placed in the L2 genesis state (i.e. at the start of the chain).

Optimism has the following predeploys:

- [L1 Attributes Predeployed Contract][l1-attr-predeploy]

## Receipt

[receipt]: glossary.md#receipt

A receipt is an output generated by a transaction, comprising a status code, the amount of gas used, a list of log
entries, and a [bloom filter] indexing these entries. Log entries are most notably used to encode [Solidity events].

Receipts are not stored in blocks, but blocks store a [Merkle Patricia Trie root][mpt] for a tree containing the receipt
for every transaction in the block.

Receipts are specified in the [yellow paper (pdf)][yellow] section 4.3.1.

## Transaction Type

[transaction-type]: glossary.md#transaction-type

Ethereum provides a mechanism (as described in [EIP-2718]) for defining different transaction types.
Different transaction types can contain different payloads, and be handled differently by the protocol.

[EIP-2718]: https://eips.ethereum.org/EIPS/eip-2718

## Fork Choice Rule

[fork-choice-rule]: glossary.md#fork-choice-rule

The fork choice rule is the rule used to determined which block is to be considered as the head of a blockchain. On L1,
this is determined by the proof of stake rules.

L2 also has a fork choice rule, although the rules vary depending on wether we want the sequencer-confirmed head, the
on-chain-confirmed head, or the on-chain-finalized head.

> TODO: define and link to those concepts

------------------------------------------------------------------------------------------------------------------------

# Sequencing

[sequencing]: glossary.md#sequencing

Transactions in the rollup can be included in two ways:

- Through a [deposited transaction](#deposited-transaction), enforced by the system
- Through a regular transaction, embedded in a [sequencer batch](#sequencer-batch)

Submitting transactions for inclusion in a batch saves costs by reducing overhead, and enables the sequencer to
pre-confirm the transactions before the L1 confirms the data.

## Sequencing window

[sequencing-window]: glossary.md#sequencing-window

A sequencing window is a range of L1 blocks, to parse inputs from during a derivation step.

## Sequencing epoch

A sequencing epoch is a number identifying the start of a [sequencing window](#sequencing-window),
equal to the L1 block number of the first block in the window.

## Sequencer batch

[sequencer-batch]: glossary.md#sequencer-batch

A sequencer batch is list of L2 transactions tagged with an [`epoch`](#sequencing-epoch) and L2 block `timestamp`.
Each L2 block can have one batch of transactions, an input for the block derivation.

------------------------------------------------------------------------------------------------------------------------

# Deposits

[deposits]: glossary.md#deposits

In general, a deposit is an L2 transaction derived from an L1 block (by the [rollup driver]).

While transaction deposits are notably (but not only) used to "deposit" (bridge) ETH and tokens to L2, the word
*deposit* should be understood as "a transaction *deposited* to L2 from L1".

This term *deposit* is somewhat ambiguous as these "transactions" exist at multiple levels. This section disambiguates
all deposit-related terms.

Notably, a *deposit* can refer to:

- A [deposited transaction][deposited] (on L2) that is part of a [deposite block][deposit-block].
- A [depositing call][depositing-call] that causes a [deposited transaction][deposited] to be derived.
- The event/log data generated by the [depositing call][depositing-call], which is what the [rollup driver] reads to
  derive the [deposited transaction][deposited].

We sometimes also talk about *user deposit* which is a similar term that explicitly excludes [L1 attributes deposited
transactions][l1-attr-deposit].

Deposits are specified in the [deposits specification][deposits-spec].

[deposits-spec]: deposits.md

## Deposited Transaction

[deposited]: glossary.md#deposited-transaction

A *deposited transaction* is a L2 transaction that was derived from L1 and included in a L2 block.

There are two kinds of deposited transactions:

- [L1 attributes deposited transaction][l1-attr-deposit], which submits the L1 block's attributes to the [L1 Attributes
  Predeployed Contract][l1-attr-predeploy].
- [User-deposited transactions][user-deposited], which are transactions derived from an L1 call to the [deposit
  contract][deposit-contract].

[deposits-spec]: deposits.md

## L1 Attributes Deposited Transaction

[l1-attr-deposit]: glossary.md#l1-attributes-deposited-transaction

An *L1 attributes deposited transaction* is [deposited transaction][deposited] that is used to register the L1 block
attributes (number, timestamp, ...) on L2 via a call to the [L1 Attributes Predeployed Contract][l1-attr-predeploy].
That contract can then be used to read the the attributes of the L1 block corresponding to the current L2 block.

L1 attributes deposited transactions are specified in the [L1 Attributes Deposit][l1-attributes-tx-spec] section of the
deposits specification.

[l1-attributes-tx-spec]: deposits.md#l1-attributes-deposited-transaction

## User-Deposited Transaction

[user-deposited]: glossary.md#user-deposited-transaction

A *user-deposited transaction* is a [deposited transaction][deposited] which is derived from an L1 call to the [deposit
  contract][deposit-contract] (a [depositing call][depositing-call]).

User-deposited transactions are specified in the [Transaction Deposits][tx-deposits-spec] section of the deposits
specification.

[tx-deposits-spec]: deposits.md#user-deposited-transactions

## Depositing Call

[depositing-call]: glossary.md#depositing-call

A *depositing call* is an L1 call to the [deposit contract][deposit-contract], which will be derived to a
[user-deposited transaction][user-deposited] by the [rollup driver].

This call specifies all the data (destination, value, calldata, ...) for the deposited transaction. "submits*

## Depositing Transaction

[depositing-tx]: glossary.md#depositing-transaction

A *depositing transaction* is an L1 transaction that makes one or more [depositing calls][depositing-call].

## Depositor

[depositor]: glossary.md#depositor

The *depositor* is the L1 account (contract or [EOA]) that makes (is the `msg.sender` of) the [depositing
call][depositing-call]. The *depositor* is **NOT** the originator of the depositing transaction (i.e. `tx.origin`).

## Deposited Transaction Type

[deposit-tx-type]: glossary.md#deposited-transaction-type

The *deposited transaction type* is an [EIP-2718] [transaction type][transaction-type], which specifies the input fields
and correct handling of a [deposited transaction][deposited].

## Deposit Contract

[deposit-contract]: glossary.md#deposit-contract

The *deposit contract* is qn [L1] contract to which [EOAs][EOA] and contracts may send [deposits]. The deposits are
emitted as log records (in Solidity, these are called *events*) for consumption by [rollup nodes][rollup node].

Advanced note: the deposits are not stored in calldata because they can be sent by contracts, in which case the calldata
is part of the *internal* execution between contracts, and this intermediate calldata is not captured in one of the
[Merkle Patricia Trie roots][mpt] included in the L1 block.

cf. [Deposits Specification](deposits.md)

------------------------------------------------------------------------------------------------------------------------

# Withdrawals

[withdrawals]: glossary.md#withdrawals

In general, a withdrawal is a transaction sent from L2 to L1 that may transfer data and/or value.

The term *withdrawal* is somewhat ambiguous as these "transactions" exist at multiple levels. In order to differentiate
 between the L1 and L2 components of a withdrawal we introduce the following terms:

- A *withdrawal initiating transaction* refers specifically to a transaction on L2 sent to the Withdrawals predeploy.
- A *withdrawal finalizing transaction* refers specifically to an L1 transaction which finalizes and relays the
  withdrawal.

## Relayer

[relayer]: glossary.md#withdrawals

An EOA on L1 which finalizes a withdrawal by submitting the data necessary to verify its inclusion on L2.

------------------------------------------------------------------------------------------------------------------------

# Other L2 Chain Concepts

## Address Aliasing

[address-aliasing]: glossary.md#address-aliasing

When a contract submits a [deposit][deposits] from L1 to L2, it's address (as returned by `ORIGIN` and `CALLER`) will be
aliased with a modified representation of the address of a contract.

- cf. [Deposit Specification](deposits.md#address-aliasing)

## L2 Chain Inception

[L2 chain inception]: glossary.md#L2-chain-inception

The L1 block number for which the first block of the L2 chain was generated.

## Rollup Node

[rollup node]: glossary.md#rollup-node

The rollup node is responsible for [deriving the L2 chain][derivation] from the L1 chain (L1 [blocks][block] and their
associated [receipts][receipt]). This is done by its [rollup driver] component.

- cf. [Rollup Node Specification](rollup-node.md)

## Rollup Driver

[rollup driver]: glossary.md#rollup-driver

The rollup driver is the [rollup node] component responsible for [deriving the L2 chain][derivation] from the L1 chain
(L1 [blocks][block] and their associated [receipts][receipt]).

## L2 Chain Derivation

[derivation]: glossary.md#L2-chain-derivation

A process that reads [L2 derivation inputs][deriv-inputs] from L1 in order to derive the L2 chain.

cf. [L2 Chain Derivation (in Rollup Node
Specification)](rollup-node.md#l2-chain-derivation)

## L2 Derivation Inputs

[deriv-inputs]: glossary.md#l2-chain-derivation-inputs

This term refers to data that is found in L1 blocks and is read by the [rollup node] to construct [payload attributes].

L2 derivation inputs include:

- L1 block attributes
  - block number
  - timestamp
  - basefee
- [deposits] (as log data)
- [sequencer batches][sequencer-batch] (as transaction data)

## Payload Attributes

[payload attributes]: glossary.md#payload-attributes

This term refers to an object that can be derived from [L2 chain derivation inputs][deriv-inputs] found on L1, which are
then passed to the [execution engine][execution-engine] to construct L2 blocks.

The payload attributes object essentially essentially encodes a [a block without output properties][block].

Payload attributes are originally specified in the [Ethereum Engine API specification][engine-api], which we expand in
the [Execution Engine Specification](exec-engine.md).

See also the [Building The Payload Attributes][building-payload-attr] section of the rollup node specification.

[building-payload-attr]: rollup-node.md#building-the-payload-attributes

## L1 Attributes Predeployed Contract

[l1-attr-predeploy]: glossary.md#l1-attributes-predeployed-contract

A [predeployed contract][predeploy] on L2 that can be used to retrieve the L1 block attributes of L1 blocks with a given
block number or a given block hash.

cf. [L1 Attributes Predeployed Contract Specification](deposits.md#l1-attributes-predeployed-contract)

## L2 Output Root

[l2-output]: glossary.md#l2-output

A 32 byte value which serves as a commitment to the current state of the L2 chain.

cf. [Proposing L2 output commitments](proposals.md#l2-output-root-proposals-specification)

------------------------------------------------------------------------------------------------------------------------

# Execution Engine Concepts

## Execution Engine

[execution-engine]: glossary.md#execution-engine

The execution engine is responsible for executing transactions in blocks and computing the resulting state roots,
receipts roots and block hash.

Both L1 (post-[merge]) and L2 have an execution engine.

On L1, the executed blocks can come from L1 block synchronization; or from a block freshly minted by the execution
engine (using transactions from the L1 [mempool]), at the request of the L1 consensus layer.

On L2, the executed blocks are freshly minted by the execution engine at the request of the [rollup node], using
transactions [derived from L1 blocks][derivation].

In these specifications, "execution engine" always refer to the L2 execution engine, unless otherwise specified.

- cf. [Execution Engine Specification](exec-engine.md)

<!-- External Links -->
[mpt-details]: https://github.com/norswap/nanoeth/blob/d4c0c89cc774d4225d16970aa44c74114c1cfa63/src/com/norswap/nanoeth/trees/patricia/README.md
[trie]: https://en.wikipedia.org/wiki/Trie
[bloom filter]: https://en.wikipedia.org/wiki/Bloom_filter
[Solidity events]: https://docs.soliditylang.org/en/latest/contracts.html?highlight=events#events
[nano-header]: https://github.com/norswap/nanoeth/blob/cc5d94a349c90627024f3cd629a2d830008fec72/src/com/norswap/nanoeth/blocks/BlockHeader.java#L22-L156
[yellow]: https://ethereum.github.io/yellowpaper/paper.pdf
[engine-api]: https://github.com/ethereum/execution-apis/blob/main/src/engine/specification.md#PayloadAttributesV1
[merge]: https://ethereum.org/en/eth2/merge/
[mempool]: https://www.quicknode.com/guides/defi/how-to-access-ethereum-mempool
[L1 consensus layer]: https://github.com/ethereum/consensus-specs/#readme
