## Optimistic Ethereum Protocol Specification

This page serves as an annotated table of contents for the documents within the protocol specification.

## Contents

- **[Glossary](./glossary.md):** A list of definitions and abbreviations for commonly used terms.
- **[Data Structures](./data-structures.md):** All of the Data Structures found in the Protocol are listed here, along with descriptions and validation information.
- **[Actors and Roles](./actors-and-roles.md):** Describes the various actors within the system, and what actions they are permitted to take.
- **components:** These pages describe the correct functioning of key processes within the protocol.
  - [Chains](./components/chains.md): Specification of the CTC and SCC.
  - [Execution](./components/execution.md): Specification of the EM and SM.
  - [Fraud Proving](./components/verification.md): Specification of the Fraud Proving process.
  - [Cross Domain Messaging](./components/bridge.md): Specification of Cross Domain Messaging components.
  - [Cross Domain Messaging](./components/predeploys.md): Specification of Cross Domain Messaging components.
