package exmonitor

import (
	"context"
	"fmt"
	"go.mongodb.org/mongo-driver/mongo"
)

// MongoMarketHandler handles market data operations
type mongoMarketHandler struct {
	client *mongo.Client
	db     *mongo.Database
}

// HandleTrade inserts an ExchangeTrade into the corresponding collection
func (h *mongoMarketHandler) HandleTrade(symbol string, trade *ExchangeTrade) error {
	collection := h.db.Collection("exchange_trade_" + symbol)
	_, err := collection.InsertOne(context.Background(), trade)
	if err != nil {
		return fmt.Errorf("failed to insert trade: %v", err)
	}
	return nil
}

// HandleKLine inserts a KLine into the corresponding collection
func (h *mongoMarketHandler) HandleKLine(symbol string, kline *KLine) error {
	collection := h.db.Collection("exchange_kline_" + symbol + "_" + kline.Period)
	_, err := collection.InsertOne(context.Background(), kline)
	if err != nil {
		return fmt.Errorf("failed to insert KLine: %v", err)
	}
	return nil
}
