package exmonitor

import "github.com/exchain/go-exchain/op-supervisor/config"

type Monitor struct {
	kline   *KLineGeneratorJob
	service MarketService
}

func NewMonitor(conf *config.Config) *Monitor {
	service := NewMarketService(conf)
	kline := NewKLineGeneratorJob(&coinProcessorFactory{}, service)

	return &Monitor{
		kline:   kline,
		service: service,
	}
}

func (m *Monitor) Start() {
	// Initialize the monitor
	// Start the monitoring process
	m.kline.Start()
}
