package engine

import (
	"github.com/ethereum/go-ethereum/common"
	"github.com/ethereum/go-ethereum/crypto"
	"github.com/exchain/go-exchain/op-service/eth"
	"testing"
)

func TestOutput(t *testing.T) {
	storageRoot := "0xa643dc6f566a3d40490d9d973679230dd44a2f9314da325cecc83e10a183d273"
	output := &eth.OutputV0{
		StateRoot:                eth.Bytes32{},
		MessagePasserStorageRoot: eth.Bytes32{},
		BlockHash:                common.HexToHash("0xe48501598976f79351f9e2f2cc4474ca5646999aa0dfe6a469c5a13c3d02f7b4"),
	}
	if err := output.MessagePasserStorageRoot.UnmarshalText([]byte(storageRoot)); err != nil {
		t.Fatalf("failed to unmarshal storage root: %v", err)
	}
	//t.Log("message passer root", output.MessagePasserStorageRoot.String())
	marshaled := output.Marshal()
	outputRoot := eth.Bytes32(crypto.Keccak256Hash(marshaled))
	t.Logf("Storage root: %s", outputRoot.String())
}
