# op-program

Implements a fault proof program that runs through the rollup state-transition to verify an L2 output from L1 inputs.
This verifiable output can then resolve a disputed output on L1.

The program is designed such that it can be run in a deterministic way such that two invocations with the same input
data will result in not only the same output, but the same program execution trace. This allows it to be run in an
on-chain VM as part of the dispute resolution process.

## Compiling

To build op-program, from within the `op-program` directory run:

```shell
make op-program
```

This resulting executable will be in `./bin/op-program`

## Testing

To run op-program unit tests, from within the `op-program` directory run:

```shell
make test
```

## Running

From within the `op-program` directory, options can be reviewed with:

```shell
./bin/op-program --help
```

## Generating the Absolute Prestate

The absolute pre-state of the op-program can be generated by executing the makefile
`reproducible-prestate` target. Effectively, this builds a docker image specified
by [Dockerfile.repro](./Dockerfile.repro) pinned with the following dependencies:
- golang version `1.21.3`
- alpine `3.18`

After running `make reproducible-prestate`, the following files can be found in
[./bin/](./bin/):
- [`op-program`](./bin/op-program)
- [`op-program-client.elf`](./bin/op-program-client.elf)
- [`prestate.bin.gz`](./bin/prestate.bin.gz)
- [`prestate-proof.json`](./bin/prestate-proof.json)

The `prestate-proof.json` file is what contains the absolute pre-state hash under
the `.pre` key that is also used by the [contracts][ctb] deploy script.

[ctb]: ../packages/contracts-bedrock/
