// Code generated - DO NOT EDIT.
// This file is a generated binding and any manual changes will be lost.

package bindings

import (
	"encoding/json"

	"github.com/ethereum-optimism/optimism/op-bindings/solc"
)

const MIPSStorageLayoutJSON = "{\"storage\":[{\"astId\":1000,\"contract\":\"contracts/cannon/MIPS.sol:MIPS\",\"label\":\"oracle\",\"offset\":0,\"slot\":\"0\",\"type\":\"t_contract(IPreimageOracle)1001\"}],\"types\":{\"t_contract(IPreimageOracle)1001\":{\"encoding\":\"inplace\",\"label\":\"contract IPreimageOracle\",\"numberOfBytes\":\"20\"}}}"

var MIPSStorageLayout = new(solc.StorageLayout)

var MIPSDeployedBin = "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"

var MIPSDeployedSourceMap = "1075:33645:0:-:0;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;1655:45;;;:::i;:::-;;;;;;;;;;;;;;;;;;;2081:29;;;:::i;:::-;;;;;;;;;;;;;;;;;;;22431:5721;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;-1:-1:-1;22431:5721:0;;-1:-1:-1;22431:5721:0;-1:-1:-1;22431:5721:0;:::i;:::-;;;;;;;;;;;;;;;;1655:45;1690:10;1655:45;:::o;2081:29::-;;;;;;:::o;22431:5721::-;22509:7;22528:18;;:::i;:::-;22663:4;22656:5;22653:15;22643:2;;22732:1;22730;22723:11;22643:2;22780:4;22774:11;22787;22771:28;22761:2;;22853:1;22851;22844:11;22761:2;22913:3;22895:16;22892:25;22882:2;;22987:1;22985;22978:11;22882:2;23043:3;23029:12;23026:21;23016:2;;23116:1;23114;23107:11;23016:2;23146:416;;;23380:24;;23368:2;23364:13;;;23361:1;23357:21;23353:52;;;;23422:20;;23476:21;;;23530:18;;;23224:338::o;:::-;23639:16;23697:4;23749:18;23764:2;23761:1;23758;23749:18;:::i;:::-;23741:26;;;;23799:18;23814:2;23811:1;23808;23799:18;:::i;:::-;23791:26;;;;23853:17;23868:1;23865;23862;23853:17;:::i;:::-;23845:25;;;;23910:17;23925:1;23922;23919;23910:17;:::i;:::-;23902:25;;;;23955:17;23970:1;23967;23964;23955:17;:::i;:::-;23947:25;;;;24004:17;24019:1;24016;24013;24004:17;:::i;:::-;23996:25;;;;24049:17;24064:1;24061;24058;24049:17;:::i;:::-;24041:25;;;;24094:17;24109:1;24106;24103;24094:17;:::i;:::-;24086:25;;;;24141:17;24156:1;24153;24150;24141:17;:::i;:::-;24133:25;;;;24192:17;24207:1;24204;24201;24192:17;:::i;:::-;24184:25;;;;24241:17;24256:1;24253;24250;24241:17;:::i;:::-;24350:2;24343:10;;24333:21;;;;24233:25;;-1:-1:-1;24343:10:0;-1:-1:-1;24438:1:0;24423:105;24448:2;24445:1;24442:9;24423:105;;;24497:17;24512:1;24509;24506;24497:17;:::i;:::-;24489:25;;-1:-1:-1;24489:25:0;-1:-1:-1;24466:1:0;24459:9;24423:105;;;24427:14;;;24594:5;:12;;;24590:63;;;24629:13;:11;:13::i;:::-;24622:20;;;;;24590:63;24663:10;;;:15;;24677:1;24663:15;;;;;24740:8;;;;-1:-1:-1;;24732:20:0;;-1:-1:-1;24732:7:0;:20::i;:::-;24718:34;-1:-1:-1;24778:10:0;24786:2;24778:10;;;;24847:1;24837:11;;;:26;;;24852:6;:11;;24862:1;24852:11;24837:26;24833:332;;;25090:64;25101:6;:11;;25111:1;25101:11;:20;;25119:2;25101:20;;;25115:1;25101:20;25090:64;;25152:1;25123:25;25126:4;25133:10;25126:17;25145:2;25123;:25::i;:::-;:30;;;;25090:10;:64::i;:::-;25083:71;;;;;;;24833:332;25390:15;;;;25201:9;;;;25330:4;25324:2;25316:10;;;25315:19;;;25390:15;25415:2;25407:10;;;25406:19;25390:36;;;;;;;;;;;;-1:-1:-1;25451:5:0;25471:11;;;;;:29;;;25486:6;:14;;25496:4;25486:14;25471:29;25467:756;;;25555:5;:15;;;25571:5;25555:22;;;;;;;;;;;;;;-1:-1:-1;;25614:4:0;25608:2;25600:10;;;25599:19;25467:756;;;25648:4;25639:6;:13;;;25635:588;;;25757:6;:13;;25767:3;25757:13;:30;;;;25774:6;:13;;25784:3;25774:13;25757:30;:47;;;;25791:6;:13;;25801:3;25791:13;25757:47;25753:229;;;25859:4;25866:6;25859:13;25854:18;;25753:229;;;25946:21;25949:4;25956:6;25949:13;25964:2;25946;:21::i;:::-;25941:26;;25753:229;25635:588;;;26012:4;26002:6;:14;;;;:32;;;;26020:6;:14;;26030:4;26020:14;26002:32;:50;;;;26038:6;:14;;26048:4;26038:14;26002:50;25998:225;;;26114:5;:15;;;26130:5;26114:22;;;;;;;;;;;;;26109:27;;26207:5;26199:13;;25998:225;26248:1;26238:6;:11;;;;:25;;;;;26262:1;26253:6;:10;;;26238:25;26237:42;;;;26268:6;:11;;26278:1;26268:11;26237:42;26233:117;;;26302:37;26315:6;26323:4;26329:5;26336:2;26302:12;:37::i;:::-;26295:44;;;;;;;;;;;26233:117;26379:13;26360:16;26515:4;26505:14;;;;26501:400;;26576:19;26579:4;26584:6;26579:11;26592:2;26576;:19::i;:::-;26570:25;;;;26628:10;26623:15;;26658:16;26623:15;26672:1;26658:7;:16::i;:::-;26652:22;;26702:4;26692:6;:14;;;;:32;;;;;26710:6;:14;;26720:4;26710:14;;26692:32;26688:203;;;26781:4;26769:16;;26875:1;26867:9;;26688:203;26501:400;;26926:10;26939:26;26947:4;26953:2;26957;26961:3;26939:7;:26::i;:::-;26968:10;26939:39;;;;-1:-1:-1;27060:4:0;27053:11;;;27088;;;:24;;;;;27111:1;27103:4;:9;;;;27088:24;:39;;;;;27123:4;27116;:11;;;27088:39;27084:711;;;27147:4;:9;;27155:1;27147:9;:22;;;;27160:4;:9;;27168:1;27160:9;27147:22;27143:116;;;27207:37;27218:4;:9;;27226:1;27218:9;:21;;27234:5;27218:21;;;27230:1;27218:21;27241:2;27207:10;:37::i;:::-;27200:44;;;;;;;;;;;;;;;27143:116;27277:4;:11;;27285:3;27277:11;27273:93;;;27323:28;27332:5;27339:2;27343:7;;;;27323:8;:28::i;27273:93::-;27383:4;:11;;27391:3;27383:11;27379:93;;;27429:28;27438:5;27445:2;27449:7;;;;;27429:8;:28::i;27379:93::-;27534:4;:11;;27542:3;27534:11;27530:72;;;27572:15;:13;:15::i;27530:72::-;27693:4;27685;:12;;;;:27;;;;;27708:4;27701;:11;;;27685:27;27681:104;;;27739:31;27750:4;27756:2;27760;27764:5;27739:10;:31::i;27681:104::-;27847:6;:14;;27857:4;27847:14;:28;;;;-1:-1:-1;27865:10:0;;;;;27847:28;27843:85;;;27916:1;27891:5;:15;;;27907:5;27891:22;;;;;;;;;:26;;;;:22;;;;;;:26;27843:85;27966:9;:26;;27979:13;27966:26;27962:84;;28008:27;28017:9;28028:1;28031:3;28008:8;:27::i;:::-;28119:26;28128:5;28135:3;28140:4;28119:8;:26::i;:::-;28112:33;;;;;;;;;;;;;22431:5721;;;;;;;:::o;2605:1791::-;2646:12;2791:206;;;2891:2;2887:13;;;2877:24;;2871:31;2860:43;;2931:13;;2970;;;2842:155::o;:::-;3068:4;3152;3146:11;3180:5;3252:21;3270:2;3266;3260:4;3252:21;:::i;:::-;3240:33;;;;3310:21;3328:2;3324;3318:4;3310:21;:::i;:::-;3298:33;;;;3372:20;3390:1;3386:2;3380:4;3372:20;:::i;:::-;3360:32;;;;3437:20;3455:1;3451:2;3445:4;3437:20;:::i;:::-;3425:32;;;;3490:20;3508:1;3504:2;3498:4;3490:20;:::i;:::-;3478:32;;;;3547:20;3565:1;3561:2;3555:4;3547:20;:::i;:::-;3535:32;;;;3600:20;3618:1;3614:2;3608:4;3600:20;:::i;:::-;3588:32;;;;3653:20;3671:1;3667:2;3661:4;3653:20;:::i;:::-;3641:32;;;;3708:20;3726:1;3722:2;3716:4;3708:20;:::i;:::-;3696:32;;;;3767:20;3785:1;3781:2;3775:4;3767:20;:::i;:::-;3755:32;;;;3824:20;3842:1;3838:2;3832:4;3824:20;:::i;:::-;3885:2;3875:13;;;;-1:-1:-1;3812:32:0;-1:-1:-1;3983:1:0;3968:112;3993:2;3990:1;3987:9;3968:112;;;4046:20;4064:1;4060:2;4054:4;4046:20;:::i;:::-;4034:32;;-1:-1:-1;4034:32:0;-1:-1:-1;4011:1:0;4004:9;3968:112;;;3972:14;4143:1;4139:2;4132:13;4238:5;4234:2;4230:14;4223:5;4218:27;4344:14;;;4327:32;;;-1:-1:-1;;2605:1791:0;;:::o;18646:1741::-;18719:11;18802:14;18819:24;18831:11;18819;:24::i;:::-;18802:41;;18939:1;18932:5;18928:13;18925:2;;;18970:1;18967;18960:12;18925:2;19103;19091:15;;;19048:20;19201:141;;;;19248:12;;;19284:2;19277:13;;;;19325:2;19312:16;;;19230:112::o;:::-;19497:5;19494:1;19490:13;19528:4;19560:1;19545:375;19570:2;19567:1;19564:9;19545:375;;;19685:2;19673:15;;;19626:20;19716:12;;;19730:1;19712:20;19749:78;;;;19833:1;19828:78;;;;19705:201;;19749:78;19786:23;19801:7;19795:4;19786:23;:::i;:::-;19778:31;;19749:78;;19828;19865:23;19883:4;19874:7;19865:23;:::i;:::-;19857:31;;19705:201;-1:-1:-1;;19588:1:0;19581:9;19545:375;;;19549:14;20022:4;20016:11;20001:26;;20100:7;20094:4;20091:17;20081:2;;20138:10;20135:1;20128:21;20176:2;20173:1;20166:13;20081:2;-1:-1:-1;;20312:2:0;20301:14;;;;20289:10;20285:31;20282:1;20278:39;20342:16;;;;20360:10;20338:33;;18863:1518;-1:-1:-1;;;18863:1518:0:o;2209:288::-;2270:6;2305:18;;;;2314:8;;;;2305:18;;;;;;2304:25;;;;;2321:1;2364:2;:9;;;2358:16;;;;;2357:22;;2356:32;;;;;;;2414:9;;2413:15;2304:25;2467:21;;2487:1;2467:21;;;2478:6;2467:21;2452:11;;;;;:37;;-1:-1:-1;;;2209:288:0;;;;:::o;16135:624::-;16204:12;16263:18;;:::i;:::-;-1:-1:-1;16418:8:0;;;16447:12;;;16436:23;;;;;;;16469:20;;;;;16323:4;;16593:13;;;16589:82;;16650:6;16659:1;16650:10;16622:5;:15;;;16638:8;16622:25;;;;;;;;;:38;;;;:25;;;;;;:38;16589:82;16739:13;:11;:13::i;:::-;16732:20;16135:624;-1:-1:-1;;;;;16135:624:0:o;11567:1713::-;11664:12;11722:18;;:::i;:::-;-1:-1:-1;11782:4:0;11806:17;11905:1;11894:12;;;;;:28;;;11910:7;:12;;11921:1;11910:12;11894:28;11890:859;;;11938:9;11950:5;:15;;;11966:6;11950:23;;;;;;;;;;;;;11938:35;;12010:2;12003:9;;:3;:9;;;:25;;;;;12016:7;:12;;12027:1;12016:12;12003:25;12002:58;;;;12041:2;12034:9;;:3;:9;;;;:25;;;;;12047:7;:12;;12058:1;12047:12;12034:25;11987:73;;11890:859;;;;12160:7;:12;;12171:1;12160:12;12156:593;;;12217:1;12209:3;12203:15;;;;12188:30;;12156:593;;;12309:7;:12;;12320:1;12309:12;12305:444;;;12365:1;12358:3;12352:14;;;12337:29;;12305:444;;;12474:7;:12;;12485:1;12474:12;12470:279;;;12554:4;12548:2;12539:11;;;12538:20;12577:8;12573:76;;12633:1;12626:3;12620:14;;;12605:29;;12573:76;12666:3;:8;;12673:1;12666:8;12662:77;;;12723:1;12715:3;12709:15;;;;12694:30;;12662:77;12470:279;;12817:8;;;;;12887:12;;;;12876:23;;;;;13031:162;;;;13118:1;13092:22;13095:5;13103:6;13095:14;13111:2;13092;:22::i;:::-;:27;;;;;;;13078:42;;13087:1;13078:42;13063:57;:12;;;:57;13031:162;;;13166:12;;;;;13181:1;13166:16;13151:31;;;;13031:162;13260:13;:11;:13::i;:::-;13253:20;11567:1713;-1:-1:-1;;;;;;;;11567:1713:0:o;28198:6520::-;28285:6;28319:10;28327:2;28319:10;;;;;;28366:11;;28470:4;28461:13;;28457:6215;;;28589:1;28579:6;:11;;;;:27;;;;;28603:3;28594:6;:12;;;28579:27;28575:532;;;28630:6;:11;;28640:1;28630:11;28626:431;;;-1:-1:-1;28652:4:0;28626:431;;;28700:6;:11;;28710:1;28700:11;28696:361;;;-1:-1:-1;28722:4:0;28696:361;;;28766:6;:13;;28776:3;28766:13;28762:295;;;-1:-1:-1;28790:4:0;28762:295;;;28831:6;:13;;28841:3;28831:13;28827:230;;;-1:-1:-1;28855:4:0;28827:230;;;28897:6;:13;;28907:3;28897:13;28893:164;;;-1:-1:-1;28921:4:0;28893:164;;;28962:6;:13;;28972:3;28962:13;28958:99;;;-1:-1:-1;28986:4:0;28958:99;;;29026:6;:13;;29036:3;29026:13;29022:35;;;-1:-1:-1;29050:4:0;29022:35;29091:1;29082:10;;28575:532;29160:11;;;29156:3190;;29220:4;29215:1;29207:9;;;29206:18;29253:4;29207:9;29246:11;;;29242:1203;;;29337:4;29329;:12;;;29325:1102;;29376:2;29369:9;;;;;;;29325:1102;29478:12;;;29474:953;;29525:11;;;;;;;;-1:-1:-1;29518:18:0;;-1:-1:-1;;29518:18:0;29474:953;29637:4;:12;;29645:4;29637:12;29633:794;;;29684:11;;;;;;;;-1:-1:-1;29677:18:0;;-1:-1:-1;;29677:18:0;29633:794;29799:4;:12;;29807:4;29799:12;29795:632;;;29846:27;29855:5;29849:11;;:2;:11;;;;29867:5;29862:2;:10;29846:2;:27::i;29795:632::-;29983:4;:12;;29991:4;29983:12;29979:448;;;-1:-1:-1;;;;30030:17:0;;;30042:4;30037:9;;30030:17;30023:24;;29979:448;30158:4;:12;;30166:4;30158:12;30154:273;;;-1:-1:-1;;;;30205:17:0;;;30217:4;30212:9;;30205:17;30198:24;;30154:273;30336:4;:12;;30344:4;30336:12;30332:95;;;30383:21;30392:2;30386:8;;:2;:8;;;;30401:2;30396;:7;30383:2;:21::i;30332:95::-;30589:4;:12;;30597:4;30589:12;:28;;;;30605:4;:12;;30613:4;30605:12;30589:28;30585:1025;;;30653:2;30648;:7;30641:14;;;;;;;30585:1025;30731:4;:12;;30739:4;30731:12;:28;;;;30747:4;:12;;30755:4;30747:12;30731:28;30727:883;;;30795:2;30790;:7;30783:14;;;;;;;30727:883;30865:4;:12;;30873:4;30865:12;30861:749;;;30913:2;30908;:7;30901:14;;;;;;;30861:749;30982:4;:12;;30990:4;30982:12;30978:632;;;31031:2;31026;:7;31018:16;;;;;;;30978:632;31102:4;:12;;31110:4;31102:12;31098:512;;;31151:2;31146;:7;31138:16;;;;;;;31098:512;31222:4;:12;;31230:4;31222:12;31218:392;;;-1:-1:-1;;;;31267:7:0;;;31265:10;31258:17;;31218:392;31366:4;:12;;31374:4;31366:12;31362:248;;;31425:2;31407:21;;31413:2;31407:21;;;:29;;31435:1;31407:29;;;31431:1;31407:29;31400:36;;;;;;;;;31362:248;31537:4;:12;;31545:4;31537:12;31533:77;;;31581:2;31578:5;;:2;:5;;;:13;;31590:1;31578:13;;31533:77;29156:3190;;;;31687:6;:13;;31697:3;31687:13;31683:663;;;31733:2;31727;:8;;;;31720:15;;;;;;31683:663;31796:6;:14;;31806:4;31796:14;31792:554;;;31857:4;:9;;31865:1;31857:9;31853:92;;;-1:-1:-1;;;31904:21:0;;;31890:36;;31853:92;31989:4;:12;;31997:4;31989:12;:28;;;;32005:4;:12;;32013:4;32005:12;31989:28;31985:347;;;32045:4;:12;;32053:4;32045:12;32041:75;;;32090:3;;;32041:75;32137:8;32171:113;32181:10;32178:13;;:18;32171:113;;32253:8;32224:3;32253:8;;;;;32224:3;32171:113;;;32312:1;-1:-1:-1;32305:8:0;;-1:-1:-1;;32305:8:0;31985:347;28457:6215;;;32383:4;32374:6;:13;;;32370:2302;;;32425:6;:14;;32435:4;32425:14;32421:1088;;;32466:42;32484:2;32489:1;32484:6;32494:1;32483:12;32478:2;:17;32470:26;;:3;:26;;;;32500:4;32469:35;32506:1;32466:2;:42::i;:::-;32459:49;;;;;;32421:1088;32563:6;:14;;32573:4;32563:14;32559:950;;;32604:45;32622:2;32627:1;32622:6;32632:1;32621:12;32616:2;:17;32608:26;;:3;:26;;;;32638:6;32607:37;32646:2;32604;:45::i;32559:950::-;32705:6;:14;;32715:4;32705:14;32701:808;;;-1:-1:-1;;;32752:21:0;32771:1;32766;32761:6;;32760:12;32752:21;;32805:36;;;32872:5;32867:10;;32752:21;;;;;32866:18;32859:25;;32701:808;32939:6;:14;;32949:4;32939:14;32935:574;;;32980:3;32973:10;;;;;;32935:574;33039:6;:14;;33049:4;33039:14;33035:474;;;33095:2;33100:1;33095:6;33105:1;33094:12;33089:2;:17;33081:26;;:3;:26;;;;33111:4;33080:35;33073:42;;;;;;33035:474;33171:6;:14;;33181:4;33171:14;33167:342;;;33227:2;33232:1;33227:6;33237:1;33226:12;33221:2;:17;33213:26;;:3;:26;;;;33243:6;33212:37;33205:44;;;;;;33167:342;33305:6;:14;;33315:4;33305:14;33301:208;;;-1:-1:-1;;;33352:26:0;33376:1;33371;33366:6;;33365:12;33360:2;:17;33352:26;;33410:41;;;33482:5;33477:10;;33352:26;;;;;33476:18;33469:25;;32370:2302;33551:6;:14;;33561:4;33551:14;33547:1125;;;-1:-1:-1;;;33600:4:0;33594:34;33626:1;33621;33616:6;;33615:12;33610:2;:17;33594:34;;33676:27;;;33656:48;;;33726:10;;33595:9;;;33594:34;;33725:18;33718:25;;33547:1125;33786:6;:14;;33796:4;33786:14;33782:890;;;-1:-1:-1;;;33835:6:0;33829:36;33863:1;33858;33853:6;;33852:12;33847:2;:17;33829:36;;33913:29;;;33893:50;;;33965:10;;33830:11;;;33829:36;;33964:18;33957:25;;33782:890;34026:6;:14;;34036:4;34026:14;34022:650;;;-1:-1:-1;;;34069:20:0;34087:1;34082;34077:6;;34076:12;34069:20;;34117:36;;;34181:5;34175:11;;34069:20;;;;;34174:19;34167:26;;34022:650;34236:6;:14;;34246:4;34236:14;34232:440;;;34273:2;34266:9;;;;;;34232:440;34319:6;:14;;34329:4;34319:14;34315:357;;;-1:-1:-1;;;34362:25:0;34385:1;34380;34375:6;;34374:12;34369:2;:17;34362:25;;34415:41;;;34484:5;34478:11;;34362:25;;;;;34477:19;34470:26;;34315:357;34539:6;:14;;34549:4;34539:14;34535:137;;;34576:3;34569:10;;;;;;34535:137;34622:6;:14;;34632:4;34622:14;34618:54;;;34659:2;34652:9;;;;;;34618:54;34682:29;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;17040:688;17126:12;17185:18;;:::i;:::-;-1:-1:-1;17245:4:0;17340:2;17328:14;;;;17320:41;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;17449:14;;;;;;;:30;;;17467:12;17449:30;17445:94;;;17524:4;17495:5;:15;;;17511:9;17495:26;;;;;;;;;:33;;;;:26;;;;;;:33;17445:94;17586:12;;;;;17575:23;;;;:8;;;:23;17638:1;17623:16;;;17608:31;;;17708:13;:11;:13::i;4437:6744::-;4480:12;4538:18;;:::i;:::-;-1:-1:-1;4696:15:0;;:18;;;;4598:4;4840:18;;;;4880;;;;4920;;;;;4598:4;;4676:17;;;;4840:18;4880;5002;;;5016:4;5002:18;4998:5911;;;5048:2;5071:4;5068:7;;:12;5064:112;;5156:4;5153:7;;5145:4;:16;5139:22;5064:112;5193:7;;;5189:141;;5225:10;;;;;5253:16;;;;;;;;5225:10;-1:-1:-1;5189:141:0;;;5313:2;5308:7;;5189:141;4998:5911;;;;5434:10;:18;;5448:4;5434:18;5430:5479;;;1690:10;5468:14;;5430:5479;;;5554:10;:18;;5568:4;5554:18;5550:5359;;;5593:1;5588:6;;5550:5359;;;5706:10;:18;;5720:4;5706:18;5702:5207;;;5755:4;5740:12;;;:19;5773:26;;;:14;;;:26;5820:13;:11;:13::i;:::-;5813:20;;;;;;;;;;;5702:5207;5947:10;:18;;5961:4;5947:18;5943:4966;;;6086:14;;;6082:2210;;;;;6240:22;;;1923:1;6240:22;6236:2056;;;6357:10;6370:27;6378:2;6383:10;6378:15;6395:1;6370:7;:27::i;:::-;6456:11;6487:6;;6507:17;;;;6526:20;;;;;6487:60;;;;;;;;;;;;;;;;;;;;6357:40;;-1:-1:-1;6456:11:0;;;;6487:6;;;;;:19;;:60;;;;;;;;;;;:6;:60;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;-1:-1:-1;6487:60:0;;;;;;;;;-1:-1:-1;6487:60:0;-1:-1:-1;6758:1:0;6750:10;;6848:1;6844:17;;;6919;;;6916:2;;;6949:5;6939:15;;6916:2;;7028:6;7024:2;7021:14;7018:2;;;7048;7038:12;;7018:2;7150:3;7145:1;7137:6;7133:14;7128:3;7124:24;7120:34;7113:41;;7246:3;7242:1;7230:9;7221:6;7218:1;7214:14;7210:30;7206:38;7202:48;7195:55;;7366:1;7362;7358;7346:9;7343:1;7339:17;7335:25;7331:33;7327:41;7489:1;7485;7481;7472:6;7460:9;7457:1;7453:17;7449:30;7445:38;7441:46;7437:54;7419:72;;7585:10;7581:15;7575:4;7571:26;7563:34;;7697:3;7689:4;7685:9;7680:3;7676:19;7673:28;7666:35;;;;7831:33;7840:2;7845:10;7840:15;7857:1;7860:3;7831:8;:33::i;:::-;7882:20;;;:38;;;;;;;;;-1:-1:-1;6236:2056:0;;-1:-1:-1;;6236:2056:0;;8023:18;;;1842:1;8023:18;8019:273;;;8181:2;8176:7;;8019:273;;;8239:10;8234:15;;1998:3;8267:10;;8019:273;5943:4966;;;8409:10;:18;;8423:4;8409:18;8405:2504;;;8551:15;;;1769:1;8551:15;;:34;;-1:-1:-1;8570:15:0;;;1804:1;8570:15;8551:34;:57;;;-1:-1:-1;8589:19:0;;;1881:1;8589:19;8551:57;8547:1505;;;8633:2;8628:7;;8547:1505;;;8747:23;;;1966:1;8747:23;8743:1309;;;8790:10;8803:27;8811:2;8816:10;8811:15;8828:1;8803:7;:27::i;:::-;8902:17;;;;8790:40;;-1:-1:-1;9129:1:0;9121:10;;9219:1;9215:17;9290:13;;;9287:2;;;9312:5;9306:11;;9287:2;9586:14;;;9400:1;9582:22;;;9578:32;;;;9479:26;9503:1;9392:10;;;9483:18;;;9479:26;9574:43;9388:20;;9678:12;9794:17;;;:23;9858:1;9835:20;;;:24;9396:2;-1:-1:-1;9396:2:0;8743:1309;;8405:2504;10238:10;:18;;10252:4;10238:18;10234:675;;;10324:2;:7;;10330:1;10324:7;10320:579;;;10393:14;;;;;:40;;-1:-1:-1;10411:22:0;;;1923:1;10411:22;10393:40;:62;;;-1:-1:-1;10437:18:0;;;1842:1;10437:18;10393:62;10389:376;;;10484:1;10479:6;;10389:376;;;10526:15;;;1769:1;10526:15;;:34;;-1:-1:-1;10545:15:0;;;1804:1;10545:15;10526:34;:61;;;-1:-1:-1;10564:23:0;;;1966:1;10564:23;10526:61;:84;;;-1:-1:-1;10591:19:0;;;1881:1;10591:19;10526:84;10522:243;;;10639:1;10634:6;;10522:243;;10320:579;10808:10;10803:15;;2032:4;10836:11;;10320:579;10976:15;;;;;:23;;;;:18;;;;:23;;;;11009:15;;:23;;;:18;;;;:23;-1:-1:-1;11090:12:0;;;;11079:23;;;:8;;;:23;11142:1;11127:16;11112:31;;;;;11161:13;:11;:13::i;:::-;11154:20;;4437:6744;;;;;;;;:::o;13621:2222::-;13715:12;13773:18;;:::i;:::-;-1:-1:-1;13833:4:0;13857:10;13966:4;13957:13;;;;13953:1545;;;-1:-1:-1;13992:8:0;;;;13953:1545;;;14099:5;:13;;14108:4;14099:13;14095:1403;;;14128:14;;;:8;;;:14;14095:1403;;;14246:5;:13;;14255:4;14246:13;14242:1256;;;-1:-1:-1;14281:8:0;;;;14242:1256;;;14388:5;:13;;14397:4;14388:13;14384:1114;;;14417:14;;;:8;;;:14;14384:1114;;;14546:5;:13;;14555:4;14546:13;14542:956;;;14665:9;14615:17;14595;;;14615;;;;14595:37;14672:2;14665:9;;;;;14647:8;;;:28;14689:22;:8;;;:22;14542:956;;;14836:5;:13;;14845:4;14836:13;14832:666;;;14899:11;14885;;;14899;;;14885:25;14950:2;14943:9;;;;;14925:8;;;:28;14967:22;:8;;;:22;14832:666;;;15128:5;:13;;15137:4;15128:13;15124:374;;;15194:3;15175:23;;15181:3;15175:23;;;;;;;;15157:42;;:8;;;:42;15231:23;;;;;;;;;;;;;;15213:42;;:8;;;:42;15124:374;;;15404:5;:13;;15413:4;15404:13;15400:98;;;15450:3;15444:9;;:3;:9;;;;;;;;15433:20;;;;:8;;;:20;15478:9;;;;;;;;;;;;15467:20;;:8;;;:20;15400:98;15583:14;;;;15579:77;;15642:3;15613:5;:15;;;15629:9;15613:26;;;;;;;;;:32;;;;:26;;;;;;:32;15579:77;15702:12;;;;;15691:23;;;;:8;;;:23;15754:1;15739:16;;;15724:31;;;15823:13;:11;:13::i;:::-;15816:20;13621:2222;-1:-1:-1;;;;;;;13621:2222:0:o;20723:1584::-;20871:14;20888:24;20900:11;20888;:24::i;:::-;20871:41;;21008:1;21001:5;20997:13;20994:2;;;21039:1;21036;21029:12;20994:2;21178;21360:15;;;21197:2;21186:14;;21174:10;21170:31;21167:1;21163:39;21320:16;;;21117:20;;21305:10;21294:22;;;21290:27;21280:38;21277:60;21766:5;21763:1;21759:13;21829:1;21814:375;21839:2;21836:1;21833:9;21814:375;;;21954:2;21942:15;;;21895:20;21985:12;;;21999:1;21981:20;22018:78;;;;22102:1;22097:78;;;;21974:201;;22018:78;22055:23;22070:7;22064:4;22055:23;:::i;:::-;22047:31;;22018:78;;22097;22134:23;22152:4;22143:7;22134:23;:::i;:::-;22126:31;;21974:201;-1:-1:-1;;21857:1:0;21850:9;21814:375;;;-1:-1:-1;;22280:4:0;22273:18;-1:-1:-1;;;;20932:1369:0:o;17932:500::-;18222:20;;;18246:7;18222:32;18215:3;:40;;;18304:14;;18343:17;;18337:24;;;18329:72;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;18411:14;17932:500;;;:::o;-1:-1:-1:-;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;:::i;:::-;;;;:::o;:::-;;;;;;;;;;;;;;;;;;;;;;;;:::o"

func init() {
	if err := json.Unmarshal([]byte(MIPSStorageLayoutJSON), MIPSStorageLayout); err != nil {
		panic(err)
	}

	layouts["MIPS"] = MIPSStorageLayout
	deployedBytecodes["MIPS"] = MIPSDeployedBin
}
