// Code generated - DO NOT EDIT.
// This file is a generated binding and any manual changes will be lost.

package bindings

import (
	"errors"
	"math/big"
	"strings"

	ethereum "github.com/ethereum/go-ethereum"
	"github.com/ethereum/go-ethereum/accounts/abi"
	"github.com/ethereum/go-ethereum/accounts/abi/bind"
	"github.com/ethereum/go-ethereum/common"
	"github.com/ethereum/go-ethereum/core/types"
	"github.com/ethereum/go-ethereum/event"
)

// Reference imports to suppress errors if they are not otherwise used.
var (
	_ = errors.New
	_ = big.NewInt
	_ = strings.NewReader
	_ = ethereum.NotFound
	_ = bind.Bind
	_ = common.Big1
	_ = types.BloomLookup
	_ = event.NewSubscription
)

// OutputBisectionGameMetaData contains all meta data concerning the OutputBisectionGame contract.
var OutputBisectionGameMetaData = &bind.MetaData{
	ABI: "[{\"inputs\":[{\"internalType\":\"GameType\",\"name\":\"_gameType\",\"type\":\"uint8\"},{\"internalType\":\"Claim\",\"name\":\"_absolutePrestate\",\"type\":\"bytes32\"},{\"internalType\":\"uint256\",\"name\":\"_genesisBlockNumber\",\"type\":\"uint256\"},{\"internalType\":\"Hash\",\"name\":\"_genesisOutputRoot\",\"type\":\"bytes32\"},{\"internalType\":\"uint256\",\"name\":\"_maxGameDepth\",\"type\":\"uint256\"},{\"internalType\":\"uint256\",\"name\":\"_splitDepth\",\"type\":\"uint256\"},{\"internalType\":\"Duration\",\"name\":\"_gameDuration\",\"type\":\"uint64\"},{\"internalType\":\"contractIBigStepper\",\"name\":\"_vm\",\"type\":\"address\"}],\"stateMutability\":\"nonpayable\",\"type\":\"constructor\"},{\"inputs\":[],\"name\":\"CannotDefendRootClaim\",\"type\":\"error\"},{\"inputs\":[],\"name\":\"ClaimAboveSplit\",\"type\":\"error\"},{\"inputs\":[],\"name\":\"ClaimAlreadyExists\",\"type\":\"error\"},{\"inputs\":[],\"name\":\"ClaimAlreadyResolved\",\"type\":\"error\"},{\"inputs\":[],\"name\":\"ClockNotExpired\",\"type\":\"error\"},{\"inputs\":[],\"name\":\"ClockTimeExceeded\",\"type\":\"error\"},{\"inputs\":[],\"name\":\"GameDepthExceeded\",\"type\":\"error\"},{\"inputs\":[],\"name\":\"GameNotInProgress\",\"type\":\"error\"},{\"inputs\":[],\"name\":\"InvalidLocalIdent\",\"type\":\"error\"},{\"inputs\":[],\"name\":\"InvalidParent\",\"type\":\"error\"},{\"inputs\":[],\"name\":\"InvalidPrestate\",\"type\":\"error\"},{\"inputs\":[],\"name\":\"InvalidSplitDepth\",\"type\":\"error\"},{\"inputs\":[],\"name\":\"OutOfOrderResolution\",\"type\":\"error\"},{\"inputs\":[{\"internalType\":\"Claim\",\"name\":\"rootClaim\",\"type\":\"bytes32\"}],\"name\":\"UnexpectedRootClaim\",\"type\":\"error\"},{\"inputs\":[],\"name\":\"ValidStep\",\"type\":\"error\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":true,\"internalType\":\"uint256\",\"name\":\"parentIndex\",\"type\":\"uint256\"},{\"indexed\":true,\"internalType\":\"Claim\",\"name\":\"claim\",\"type\":\"bytes32\"},{\"indexed\":true,\"internalType\":\"address\",\"name\":\"claimant\",\"type\":\"address\"}],\"name\":\"Move\",\"type\":\"event\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":true,\"internalType\":\"enumGameStatus\",\"name\":\"status\",\"type\":\"uint8\"}],\"name\":\"Resolved\",\"type\":\"event\"},{\"inputs\":[],\"name\":\"ABSOLUTE_PRESTATE\",\"outputs\":[{\"internalType\":\"Claim\",\"name\":\"\",\"type\":\"bytes32\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"GAME_DURATION\",\"outputs\":[{\"internalType\":\"Duration\",\"name\":\"\",\"type\":\"uint64\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"GENESIS_BLOCK_NUMBER\",\"outputs\":[{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"GENESIS_OUTPUT_ROOT\",\"outputs\":[{\"internalType\":\"Hash\",\"name\":\"\",\"type\":\"bytes32\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"MAX_GAME_DEPTH\",\"outputs\":[{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"SPLIT_DEPTH\",\"outputs\":[{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"VM\",\"outputs\":[{\"internalType\":\"contractIBigStepper\",\"name\":\"\",\"type\":\"address\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"_ident\",\"type\":\"uint256\"},{\"internalType\":\"uint256\",\"name\":\"_execLeafIdx\",\"type\":\"uint256\"},{\"internalType\":\"uint256\",\"name\":\"_partOffset\",\"type\":\"uint256\"}],\"name\":\"addLocalData\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"_parentIndex\",\"type\":\"uint256\"},{\"internalType\":\"Claim\",\"name\":\"_claim\",\"type\":\"bytes32\"}],\"name\":\"attack\",\"outputs\":[],\"stateMutability\":\"payable\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"bondManager\",\"outputs\":[{\"internalType\":\"contractIBondManager\",\"name\":\"\",\"type\":\"address\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"}],\"name\":\"claimData\",\"outputs\":[{\"internalType\":\"uint32\",\"name\":\"parentIndex\",\"type\":\"uint32\"},{\"internalType\":\"bool\",\"name\":\"countered\",\"type\":\"bool\"},{\"internalType\":\"Claim\",\"name\":\"claim\",\"type\":\"bytes32\"},{\"internalType\":\"Position\",\"name\":\"position\",\"type\":\"uint128\"},{\"internalType\":\"Clock\",\"name\":\"clock\",\"type\":\"uint128\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"claimDataLen\",\"outputs\":[{\"internalType\":\"uint256\",\"name\":\"len_\",\"type\":\"uint256\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"createdAt\",\"outputs\":[{\"internalType\":\"Timestamp\",\"name\":\"\",\"type\":\"uint64\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"_parentIndex\",\"type\":\"uint256\"},{\"internalType\":\"Claim\",\"name\":\"_claim\",\"type\":\"bytes32\"}],\"name\":\"defend\",\"outputs\":[],\"stateMutability\":\"payable\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"extraData\",\"outputs\":[{\"internalType\":\"bytes\",\"name\":\"extraData_\",\"type\":\"bytes\"}],\"stateMutability\":\"pure\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"gameData\",\"outputs\":[{\"internalType\":\"GameType\",\"name\":\"gameType_\",\"type\":\"uint8\"},{\"internalType\":\"Claim\",\"name\":\"rootClaim_\",\"type\":\"bytes32\"},{\"internalType\":\"bytes\",\"name\":\"extraData_\",\"type\":\"bytes\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"gameType\",\"outputs\":[{\"internalType\":\"GameType\",\"name\":\"gameType_\",\"type\":\"uint8\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"initialize\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"l1Head\",\"outputs\":[{\"internalType\":\"Hash\",\"name\":\"\",\"type\":\"bytes32\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"l2BlockNumber\",\"outputs\":[{\"internalType\":\"uint256\",\"name\":\"l2BlockNumber_\",\"type\":\"uint256\"}],\"stateMutability\":\"pure\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"_challengeIndex\",\"type\":\"uint256\"},{\"internalType\":\"Claim\",\"name\":\"_claim\",\"type\":\"bytes32\"},{\"internalType\":\"bool\",\"name\":\"_isAttack\",\"type\":\"bool\"}],\"name\":\"move\",\"outputs\":[],\"stateMutability\":\"payable\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"resolve\",\"outputs\":[{\"internalType\":\"enumGameStatus\",\"name\":\"status_\",\"type\":\"uint8\"}],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"_claimIndex\",\"type\":\"uint256\"}],\"name\":\"resolveClaim\",\"outputs\":[],\"stateMutability\":\"payable\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"resolvedAt\",\"outputs\":[{\"internalType\":\"Timestamp\",\"name\":\"\",\"type\":\"uint64\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"rootClaim\",\"outputs\":[{\"internalType\":\"Claim\",\"name\":\"rootClaim_\",\"type\":\"bytes32\"}],\"stateMutability\":\"pure\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"status\",\"outputs\":[{\"internalType\":\"enumGameStatus\",\"name\":\"\",\"type\":\"uint8\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"_claimIndex\",\"type\":\"uint256\"},{\"internalType\":\"bool\",\"name\":\"_isAttack\",\"type\":\"bool\"},{\"internalType\":\"bytes\",\"name\":\"_stateData\",\"type\":\"bytes\"},{\"internalType\":\"bytes\",\"name\":\"_proof\",\"type\":\"bytes\"}],\"name\":\"step\",\"outputs\":[],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"version\",\"outputs\":[{\"internalType\":\"string\",\"name\":\"\",\"type\":\"string\"}],\"stateMutability\":\"view\",\"type\":\"function\"}]",
	Bin: "0x6101806040523480156200001257600080fd5b50604051620033ad380380620033ad8339810160408190526200003591620000b1565b83831015806200005057506200004d60028462000153565b15155b156200006f5760405163e62ccf3960e01b815260040160405180910390fd5b60ff90971661016052608095909552610120939093526101409190915260a05260c0526001600160401b031660e0526001600160a01b03166101005262000176565b600080600080600080600080610100898b031215620000cf57600080fd5b885160ff81168114620000e157600080fd5b60208a015160408b015160608c015160808d015160a08e015160c08f0151959d50939b509199509750955093506001600160401b03811681146200012457600080fd5b60e08a01519092506001600160a01b03811681146200014257600080fd5b809150509295985092959890939650565b6000826200017157634e487b7160e01b600052601260045260246000fd5b500690565b60805160a05160c05160e0516101005161012051610140516101605161314562000268600039600081816104e20152611bc2015260008181610606015261253601526000818161040e015281816119fa0152611a300152600081816104ac01528181611449015261175901526000818161055b01528181610c3a0152611cb901526000818161025401528181610a7801528181610b41015281816112eb015281816119d0015281816121100152818161223e01528181612346015261242201526000818161034601528181610ae4015281816111da015261130c015260008181610296015261139701526131456000f3fe6080604052600436106101b75760003560e01c80638980e0cc116100ec578063c6f0308c1161008a578063d8cc1a3c11610064578063d8cc1a3c14610649578063f8f43ff614610669578063fa24f74314610689578063fdffbb28146106ad57600080fd5b8063c6f0308c14610590578063caa4ba2d146105f4578063cf09e0d01461062857600080fd5b8063bbdc02db116100c6578063bbdc02db146104ce578063bcef3b551461050c578063c31b29ce14610549578063c55cd0c71461057d57600080fd5b80638980e0cc146104455780638b85902b1461045a578063929312981461049a57600080fd5b80634778efe811610159578063632247ea11610133578063632247ea146103d35780636361506d146103e65780636737abeb146103fc5780638129fc1c1461043057600080fd5b80634778efe81461033457806354fd4d5014610368578063609d3334146103be57600080fd5b8063266198f911610195578063266198f9146102845780632810e1d6146102b857806335fef567146102cd578063363cc427146102e257600080fd5b806319effeb4146101bc578063200d2ed21461020757806324185bc614610242575b600080fd5b3480156101c857600080fd5b506000546101e99068010000000000000000900467ffffffffffffffff1681565b60405167ffffffffffffffff90911681526020015b60405180910390f35b34801561021357600080fd5b5060005461023590700100000000000000000000000000000000900460ff1681565b6040516101fe9190612ad1565b34801561024e57600080fd5b506102767f000000000000000000000000000000000000000000000000000000000000000081565b6040519081526020016101fe565b34801561029057600080fd5b506102767f000000000000000000000000000000000000000000000000000000000000000081565b3480156102c457600080fd5b506102356106c0565b6102e06102db366004612b12565b610891565b005b3480156102ee57600080fd5b5060015461030f9073ffffffffffffffffffffffffffffffffffffffff1681565b60405173ffffffffffffffffffffffffffffffffffffffff90911681526020016101fe565b34801561034057600080fd5b506102767f000000000000000000000000000000000000000000000000000000000000000081565b34801561037457600080fd5b506103b16040518060400160405280600681526020017f302e302e3135000000000000000000000000000000000000000000000000000081525081565b6040516101fe9190612b9f565b3480156103ca57600080fd5b506103b16108a1565b6102e06103e1366004612bc7565b6108b3565b3480156103f257600080fd5b5061027660025481565b34801561040857600080fd5b506102767f000000000000000000000000000000000000000000000000000000000000000081565b34801561043c57600080fd5b506102e0610f5b565b34801561045157600080fd5b50600354610276565b34801561046657600080fd5b50367ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffe81013560f01c900360200135610276565b3480156104a657600080fd5b5061030f7f000000000000000000000000000000000000000000000000000000000000000081565b3480156104da57600080fd5b5060405160ff7f00000000000000000000000000000000000000000000000000000000000000001681526020016101fe565b34801561051857600080fd5b50367ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffe81013560f01c900335610276565b34801561055557600080fd5b506101e97f000000000000000000000000000000000000000000000000000000000000000081565b6102e061058b366004612b12565b6110ac565b34801561059c57600080fd5b506105b06105ab366004612bfc565b6110b8565b6040805163ffffffff90961686529315156020860152928401919091526fffffffffffffffffffffffffffffffff908116606084015216608082015260a0016101fe565b34801561060057600080fd5b506102767f000000000000000000000000000000000000000000000000000000000000000081565b34801561063457600080fd5b506000546101e99067ffffffffffffffff1681565b34801561065557600080fd5b506102e0610664366004612c5e565b611129565b34801561067557600080fd5b506102e0610684366004612ce8565b6116cb565b34801561069557600080fd5b5061069e611bc0565b6040516101fe93929190612d14565b6102e06106bb366004612bfc565b611c1d565b600080600054700100000000000000000000000000000000900460ff1660028111156106ee576106ee612aa2565b14610725576040517f67fe195000000000000000000000000000000000000000000000000000000000815260040160405180910390fd5b60065460ff16610761576040517f9a07664600000000000000000000000000000000000000000000000000000000815260040160405180910390fd5b600360008154811061077557610775612d3f565b6000918252602090912060039091020154640100000000900460ff1661079c57600261079f565b60015b6000805467ffffffffffffffff421668010000000000000000027fffffffffffffffffffffffffffffffff0000000000000000ffffffffffffffff82168117835592935083927fffffffffffffffffffffffffffffff00ffffffffffffffffffffffffffffffff167fffffffffffffffffffffffffffffff000000000000000000ffffffffffffffff9091161770010000000000000000000000000000000083600281111561085057610850612aa2565b02179055600281111561086557610865612aa2565b6040517f5e186f09b9c93491f14e277eea7faa5de6a2d4bda75a79af7a3684fbfb42da6090600090a290565b61089d828260006108b3565b5050565b60606108ae602080611f57565b905090565b60008054700100000000000000000000000000000000900460ff1660028111156108df576108df612aa2565b14610916576040517f67fe195000000000000000000000000000000000000000000000000000000000815260040160405180910390fd5b60006003848154811061092b5761092b612d3f565b600091825260208083206040805160a081018252600394909402909101805463ffffffff808216865264010000000090910460ff16151593850193909352600181015491840191909152600201546fffffffffffffffffffffffffffffffff808216606085018190527001000000000000000000000000000000009092041660808401529193506109bf91908590611fee16565b90506000610a5f826fffffffffffffffffffffffffffffffff167e09010a0d15021d0b0e10121619031e080c141c0f111807131b17061a05041f7f07c4acdd0000000000000000000000000000000000000000000000000000000067ffffffffffffffff831160061b83811c63ffffffff1060051b1792831c600181901c17600281901c17600481901c17600881901c17601081901c170260fb1c1a1790565b67ffffffffffffffff169050851580610aa15750610a9e7f00000000000000000000000000000000000000000000000000000000000000006002612d9d565b81145b8015610aab575083155b15610ae2576040517fa42637bc00000000000000000000000000000000000000000000000000000000815260040160405180910390fd5b7f0000000000000000000000000000000000000000000000000000000000000000811115610b3c576040517f56f57b2b00000000000000000000000000000000000000000000000000000000815260040160405180910390fd5b610b677f00000000000000000000000000000000000000000000000000000000000000006001612d9d565b8103610b7657610b7685611ff6565b825160009063ffffffff90811614610bd6576003846000015163ffffffff1681548110610ba557610ba5612d3f565b906000526020600020906003020160020160109054906101000a90046fffffffffffffffffffffffffffffffff1690505b608084015160009067ffffffffffffffff1667ffffffffffffffff1642610c0f846fffffffffffffffffffffffffffffffff1660401c90565b67ffffffffffffffff16610c239190612d9d565b610c2d9190612db5565b9050677fffffffffffffff7f000000000000000000000000000000000000000000000000000000000000000060011c1667ffffffffffffffff82161115610ca0576040517f3381d11400000000000000000000000000000000000000000000000000000000815260040160405180910390fd5b6000604082901b42176000898152608087901b6fffffffffffffffffffffffffffffffff8c1617602052604081209192509060008181526004602052604090205490915060ff1615610d1e576040517f80497e3b00000000000000000000000000000000000000000000000000000000815260040160405180910390fd5b60016004600083815260200190815260200160002060006101000a81548160ff02191690831515021790555060036040518060a001604052808c63ffffffff1681526020016000151581526020018b8152602001886fffffffffffffffffffffffffffffffff168152602001846fffffffffffffffffffffffffffffffff16815250908060018154018082558091505060019003906000526020600020906003020160009091909190915060008201518160000160006101000a81548163ffffffff021916908363ffffffff16021790555060208201518160000160046101000a81548160ff0219169083151502179055506040820151816001015560608201518160020160006101000a8154816fffffffffffffffffffffffffffffffff02191690836fffffffffffffffffffffffffffffffff16021790555060808201518160020160106101000a8154816fffffffffffffffffffffffffffffffff02191690836fffffffffffffffffffffffffffffffff1602179055505050600160038b81548110610eaf57610eaf612d3f565b600091825260208083206003928302018054941515640100000000027fffffffffffffffffffffffffffffffffffffffffffffffffffffff00ffffffff909516949094179093558c82526005909252604090209054610f1090600190612db5565b8154600181018355600092835260208320015560405133918b918d917f9b3245740ec3b155098a55be84957a4da13eaf7f14a8bc6f53126c0b9350f2be91a450505050505050505050565b600080547fffffffffffffffffffffffffffffffffffffffffffffffff0000000000000000164267ffffffffffffffff161781556040805160a08101825263ffffffff81526020810192909252600391908101610fe07ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffe369081013560f01c90033590565b815260016020820152604001426fffffffffffffffffffffffffffffffff908116909152825460018181018555600094855260209485902084516003909302018054958501511515640100000000027fffffffffffffffffffffffffffffffffffffffffffffffffffffff000000000090961663ffffffff90931692909217949094178155604083015181850155606083015160809093015182167001000000000000000000000000000000000292909116919091176002909101556110a69043612db5565b40600255565b61089d828260016108b3565b600381815481106110c857600080fd5b600091825260209091206003909102018054600182015460029092015463ffffffff8216935064010000000090910460ff1691906fffffffffffffffffffffffffffffffff8082169170010000000000000000000000000000000090041685565b60008054700100000000000000000000000000000000900460ff16600281111561115557611155612aa2565b1461118c576040517f67fe195000000000000000000000000000000000000000000000000000000000815260040160405180910390fd5b6000600387815481106111a1576111a1612d3f565b6000918252602082206003919091020160028101549092506fffffffffffffffffffffffffffffffff16908715821760011b90506112007f00000000000000000000000000000000000000000000000000000000000000006001612d9d565b61129c826fffffffffffffffffffffffffffffffff167e09010a0d15021d0b0e10121619031e080c141c0f111807131b17061a05041f7f07c4acdd0000000000000000000000000000000000000000000000000000000067ffffffffffffffff831160061b83811c63ffffffff1060051b1792831c600181901c17600281901c17600481901c17600881901c17601081901c170260fb1c1a1790565b67ffffffffffffffff16146112dd576040517f5f53dd9800000000000000000000000000000000000000000000000000000000815260040160405180910390fd5b60008089156113c1576113307f00000000000000000000000000000000000000000000000000000000000000007f0000000000000000000000000000000000000000000000000000000000000000612db5565b61133b906002612eec565b611356846fffffffffffffffffffffffffffffffff1661204a565b67ffffffffffffffff1661136a9190612f27565b156113955761138c61137d600186612f3b565b865463ffffffff1660006120f0565b600101546113b7565b7f00000000000000000000000000000000000000000000000000000000000000005b91508490506113db565b846001015491506113d884600161137d9190612f6c565b90505b600882901b60088a8a6040516113f2929190612fa0565b6040518091039020901b14611433576040517f696550ff00000000000000000000000000000000000000000000000000000000815260040160405180910390fd5b600061143e8c6121d4565b9050600082600101547f000000000000000000000000000000000000000000000000000000000000000073ffffffffffffffffffffffffffffffffffffffff1663e14ced328d8d8d8d886040518663ffffffff1660e01b81526004016114a8959493929190612ff9565b6020604051808303816000875af11580156114c7573d6000803e3d6000fd5b505050506040513d601f19601f820116820180604052508101906114eb9190613033565b600285810154929091149250600091611596906fffffffffffffffffffffffffffffffff167e09010a0d15021d0b0e10121619031e080c141c0f111807131b17061a05041f7f07c4acdd0000000000000000000000000000000000000000000000000000000067ffffffffffffffff831160061b83811c63ffffffff1060051b1792831c600181901c17600281901c17600481901c17600881901c17601081901c170260fb1c1a1790565b611632896fffffffffffffffffffffffffffffffff167e09010a0d15021d0b0e10121619031e080c141c0f111807131b17061a05041f7f07c4acdd0000000000000000000000000000000000000000000000000000000067ffffffffffffffff831160061b83811c63ffffffff1060051b1792831c600181901c17600281901c17600481901c17600881901c17601081901c170260fb1c1a1790565b61163c919061304c565b611646919061306d565b67ffffffffffffffff16159050811515810361168e576040517ffb4e40dd00000000000000000000000000000000000000000000000000000000815260040160405180910390fd5b505085547fffffffffffffffffffffffffffffffffffffffffffffffffffffff00ffffffff16640100000000179095555050505050505050505050565b60008054700100000000000000000000000000000000900460ff1660028111156116f7576116f7612aa2565b1461172e576040517f67fe195000000000000000000000000000000000000000000000000000000000815260040160405180910390fd5b60008060008061173d86612203565b93509350935093506000611753858585856125d0565b905060007f000000000000000000000000000000000000000000000000000000000000000073ffffffffffffffffffffffffffffffffffffffff16637dc0d1d06040518163ffffffff1660e01b8152600401602060405180830381865afa1580156117c2573d6000803e3d6000fd5b505050506040513d601f19601f820116820180604052508101906117e69190613094565b9050600189036118a8576002546040517f52f0f3ad000000000000000000000000000000000000000000000000000000008152600481018b9052602481018490526044810191909152602060648201526084810188905273ffffffffffffffffffffffffffffffffffffffff8216906352f0f3ad9060a4015b6020604051808303816000875af115801561187e573d6000803e3d6000fd5b505050506040513d601f19601f820116820180604052508101906118a29190613033565b50611bb5565b6002890361191f576040517f52f0f3ad000000000000000000000000000000000000000000000000000000008152600481018a90526024810183905260448101879052602060648201526084810188905273ffffffffffffffffffffffffffffffffffffffff8216906352f0f3ad9060a40161185f565b60038903611996576040517f52f0f3ad000000000000000000000000000000000000000000000000000000008152600481018a90526024810183905260448101859052602060648201526084810188905273ffffffffffffffffffffffffffffffffffffffff8216906352f0f3ad9060a40161185f565b60048903611b0a5760006fffffffffffffffffffffffffffffffff861615611a2e576119f46fffffffffffffffffffffffffffffffff87167f0000000000000000000000000000000000000000000000000000000000000000612690565b611a1e907f0000000000000000000000000000000000000000000000000000000000000000612d9d565b611a29906001612d9d565b611a50565b7f00000000000000000000000000000000000000000000000000000000000000005b6040517f52f0f3ad000000000000000000000000000000000000000000000000000000008152600481018c90526024810185905260c082901b604482015260086064820152608481018a905290915073ffffffffffffffffffffffffffffffffffffffff8316906352f0f3ad9060a4016020604051808303816000875af1158015611adf573d6000803e3d6000fd5b505050506040513d601f19601f82011682018060405250810190611b039190613033565b5050611bb5565b60058903611b83576040517f52f0f3ad000000000000000000000000000000000000000000000000000000008152600481018a9052602481018390524660c01b6044820152600860648201526084810188905273ffffffffffffffffffffffffffffffffffffffff8216906352f0f3ad9060a40161185f565b6040517fff137e6500000000000000000000000000000000000000000000000000000000815260040160405180910390fd5b505050505050505050565b7f0000000000000000000000000000000000000000000000000000000000000000367ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffe81013560f01c9003356060611c166108a1565b9050909192565b60008054700100000000000000000000000000000000900460ff166002811115611c4957611c49612aa2565b14611c80576040517f67fe195000000000000000000000000000000000000000000000000000000000815260040160405180910390fd5b600060038281548110611c9557611c95612d3f565b60009182526020909120600260039092020190810154909150677fffffffffffffff7f000000000000000000000000000000000000000000000000000000000000000060011c1690611d0590700100000000000000000000000000000000900467ffffffffffffffff1642612db5565b6002830154611d359190700100000000000000000000000000000000900460401c67ffffffffffffffff16612d9d565b11611d6c576040517ff2440b5300000000000000000000000000000000000000000000000000000000815260040160405180910390fd5b600082815260056020526040902082158015611d8a575060065460ff165b15611dc1576040517ff1a9458100000000000000000000000000000000000000000000000000000000815260040160405180910390fd5b8054158015611dcf57508215155b15611e06576040517ff1a9458100000000000000000000000000000000000000000000000000000000815260040160405180910390fd5b6000805b8254811015611ed4576000838281548110611e2757611e27612d3f565b6000918252602080832090910154808352600590915260409091205490915015611e7d576040517f9a07664600000000000000000000000000000000000000000000000000000000815260040160405180910390fd5b600060038281548110611e9257611e92612d3f565b600091825260209091206003909102018054909150640100000000900460ff16611ec157600193505050611ed4565b505080611ecd906130d1565b9050611e0a565b5082547fffffffffffffffffffffffffffffffffffffffffffffffffffffff00ffffffff16640100000000821515021783556000848152600560205260408120611f1d91612a68565b83600003611f5157600680547fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff001660011790555b50505050565b60606000611f8e84367ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffe81013560f01c9003612d9d565b90508267ffffffffffffffff1667ffffffffffffffff811115611fb357611fb3613109565b6040519080825280601f01601f191660200182016040528015611fdd576020820181803683370190505b509150828160208401375092915050565b151760011b90565b600081901a600181148061200d575060ff81166002145b61089d576040517ff40239db0000000000000000000000000000000000000000000000000000000081526004810183905260240160405180910390fd5b6000806120d7837e09010a0d15021d0b0e10121619031e080c141c0f111807131b17061a05041f7f07c4acdd0000000000000000000000000000000000000000000000000000000067ffffffffffffffff831160061b83811c63ffffffff1060051b1792831c600181901c17600281901c17600481901c17600881901c17601081901c170260fb1c1a1790565b600167ffffffffffffffff919091161b90920392915050565b60008082612139576121346fffffffffffffffffffffffffffffffff86167f0000000000000000000000000000000000000000000000000000000000000000612745565b612154565b612154856fffffffffffffffffffffffffffffffff1661290c565b90506003848154811061216957612169612d3f565b906000526020600020906003020191505b60028201546fffffffffffffffffffffffffffffffff8281169116146121cc57815460038054909163ffffffff169081106121b7576121b7612d3f565b9060005260206000209060030201915061217a565b509392505050565b60008060008060006121e586612203565b93509350935093506121f9848484846125d0565b9695505050505050565b600080600080600085905060006003828154811061222357612223612d3f565b600091825260209091206002600390920201908101549091507f0000000000000000000000000000000000000000000000000000000000000000906122fa906fffffffffffffffffffffffffffffffff167e09010a0d15021d0b0e10121619031e080c141c0f111807131b17061a05041f7f07c4acdd0000000000000000000000000000000000000000000000000000000067ffffffffffffffff831160061b83811c63ffffffff1060051b1792831c600181901c17600281901c17600481901c17600881901c17601081901c170260fb1c1a1790565b67ffffffffffffffff161161233b576040517fb34b5c2200000000000000000000000000000000000000000000000000000000815260040160405180910390fd5b6000815b60028301547f000000000000000000000000000000000000000000000000000000000000000090612402906fffffffffffffffffffffffffffffffff167e09010a0d15021d0b0e10121619031e080c141c0f111807131b17061a05041f7f07c4acdd0000000000000000000000000000000000000000000000000000000067ffffffffffffffff831160061b83811c63ffffffff1060051b1792831c600181901c17600281901c17600481901c17600881901c17601081901c170260fb1c1a1790565b67ffffffffffffffff16925082111561247e57825463ffffffff166124487f00000000000000000000000000000000000000000000000000000000000000006001612d9d565b8303612452578391505b6003818154811061246557612465612d3f565b906000526020600020906003020193508094505061233f565b600280820154908401546fffffffffffffffffffffffffffffffff91821691166000816124ab8460011c90565b6fffffffffffffffffffffffffffffffff16149050801561257e5760006124e3836fffffffffffffffffffffffffffffffff1661204a565b67ffffffffffffffff16111561253457600061250b612503600185612f3b565b8960016120f0565b6001810154600290910154909c506fffffffffffffffffffffffffffffffff169a506125589050565b7f00000000000000000000000000000000000000000000000000000000000000009a505b600186015460028701549099506fffffffffffffffffffffffffffffffff1697506125c2565b600061258e612503846001612f6c565b6001808901546002808b015492840154930154909e506fffffffffffffffffffffffffffffffff9182169d50919b50169850505b505050505050509193509193565b6000836fffffffffffffffffffffffffffffffff1660000361263757828260405160200161261a9291909182526fffffffffffffffffffffffffffffffff16602082015260400190565b604051602081830303815290604052805190602001209050612688565b60408051602081018790526fffffffffffffffffffffffffffffffff8087169282019290925260608101859052908316608082015260a0016040516020818303038152906040528051906020012090505b949350505050565b60008061271d847e09010a0d15021d0b0e10121619031e080c141c0f111807131b17061a05041f7f07c4acdd0000000000000000000000000000000000000000000000000000000067ffffffffffffffff831160061b83811c63ffffffff1060051b1792831c600181901c17600281901c17600481901c17600881901c17601081901c170260fb1c1a1790565b67ffffffffffffffff1690508083036001841b600180831b0386831b17039250505092915050565b6000816127e4846fffffffffffffffffffffffffffffffff167e09010a0d15021d0b0e10121619031e080c141c0f111807131b17061a05041f7f07c4acdd0000000000000000000000000000000000000000000000000000000067ffffffffffffffff831160061b83811c63ffffffff1060051b1792831c600181901c17600281901c17600481901c17600881901c17601081901c170260fb1c1a1790565b67ffffffffffffffff1611612825576040517fb34b5c2200000000000000000000000000000000000000000000000000000000815260040160405180910390fd5b61282e8361290c565b9050816128cd826fffffffffffffffffffffffffffffffff167e09010a0d15021d0b0e10121619031e080c141c0f111807131b17061a05041f7f07c4acdd0000000000000000000000000000000000000000000000000000000067ffffffffffffffff831160061b83811c63ffffffff1060051b1792831c600181901c17600281901c17600481901c17600881901c17601081901c170260fb1c1a1790565b67ffffffffffffffff1611612906576129036128ea836001612d9d565b6fffffffffffffffffffffffffffffffff8316906129b8565b90505b92915050565b600081196001830116816129a0827e09010a0d15021d0b0e10121619031e080c141c0f111807131b17061a05041f7f07c4acdd0000000000000000000000000000000000000000000000000000000067ffffffffffffffff831160061b83811c63ffffffff1060051b1792831c600181901c17600281901c17600481901c17600881901c17601081901c170260fb1c1a1790565b67ffffffffffffffff169390931c8015179392505050565b600080612a45847e09010a0d15021d0b0e10121619031e080c141c0f111807131b17061a05041f7f07c4acdd0000000000000000000000000000000000000000000000000000000067ffffffffffffffff831160061b83811c63ffffffff1060051b1792831c600181901c17600281901c17600481901c17600881901c17601081901c170260fb1c1a1790565b67ffffffffffffffff169050808303600180821b0385821b179250505092915050565b5080546000825590600052602060002090810190612a869190612a89565b50565b5b80821115612a9e5760008155600101612a8a565b5090565b7f4e487b7100000000000000000000000000000000000000000000000000000000600052602160045260246000fd5b6020810160038310612b0c577f4e487b7100000000000000000000000000000000000000000000000000000000600052602160045260246000fd5b91905290565b60008060408385031215612b2557600080fd5b50508035926020909101359150565b6000815180845260005b81811015612b5a57602081850181015186830182015201612b3e565b81811115612b6c576000602083870101525b50601f017fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffe0169290920160200192915050565b6020815260006129036020830184612b34565b80358015158114612bc257600080fd5b919050565b600080600060608486031215612bdc57600080fd5b8335925060208401359150612bf360408501612bb2565b90509250925092565b600060208284031215612c0e57600080fd5b5035919050565b60008083601f840112612c2757600080fd5b50813567ffffffffffffffff811115612c3f57600080fd5b602083019150836020828501011115612c5757600080fd5b9250929050565b60008060008060008060808789031215612c7757600080fd5b86359550612c8760208801612bb2565b9450604087013567ffffffffffffffff80821115612ca457600080fd5b612cb08a838b01612c15565b90965094506060890135915080821115612cc957600080fd5b50612cd689828a01612c15565b979a9699509497509295939492505050565b600080600060608486031215612cfd57600080fd5b505081359360208301359350604090920135919050565b60ff84168152826020820152606060408201526000612d366060830184612b34565b95945050505050565b7f4e487b7100000000000000000000000000000000000000000000000000000000600052603260045260246000fd5b7f4e487b7100000000000000000000000000000000000000000000000000000000600052601160045260246000fd5b60008219821115612db057612db0612d6e565b500190565b600082821015612dc757612dc7612d6e565b500390565b600181815b80851115612e2557817fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff04821115612e0b57612e0b612d6e565b80851615612e1857918102915b93841c9390800290612dd1565b509250929050565b600082612e3c57506001612906565b81612e4957506000612906565b8160018114612e5f5760028114612e6957612e85565b6001915050612906565b60ff841115612e7a57612e7a612d6e565b50506001821b612906565b5060208310610133831016604e8410600b8410161715612ea8575081810a612906565b612eb28383612dcc565b807fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff04821115612ee457612ee4612d6e565b029392505050565b60006129038383612e2d565b7f4e487b7100000000000000000000000000000000000000000000000000000000600052601260045260246000fd5b600082612f3657612f36612ef8565b500690565b60006fffffffffffffffffffffffffffffffff83811690831681811015612f6457612f64612d6e565b039392505050565b60006fffffffffffffffffffffffffffffffff808316818516808303821115612f9757612f97612d6e565b01949350505050565b8183823760009101908152919050565b8183528181602085013750600060208284010152600060207fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffe0601f840116840101905092915050565b60608152600061300d606083018789612fb0565b8281036020840152613020818688612fb0565b9150508260408301529695505050505050565b60006020828403121561304557600080fd5b5051919050565b600067ffffffffffffffff83811690831681811015612f6457612f64612d6e565b600067ffffffffffffffff8084168061308857613088612ef8565b92169190910692915050565b6000602082840312156130a657600080fd5b815173ffffffffffffffffffffffffffffffffffffffff811681146130ca57600080fd5b9392505050565b60007fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff820361310257613102612d6e565b5060010190565b7f4e487b7100000000000000000000000000000000000000000000000000000000600052604160045260246000fdfea164736f6c634300080f000a",
}

// OutputBisectionGameABI is the input ABI used to generate the binding from.
// Deprecated: Use OutputBisectionGameMetaData.ABI instead.
var OutputBisectionGameABI = OutputBisectionGameMetaData.ABI

// OutputBisectionGameBin is the compiled bytecode used for deploying new contracts.
// Deprecated: Use OutputBisectionGameMetaData.Bin instead.
var OutputBisectionGameBin = OutputBisectionGameMetaData.Bin

// DeployOutputBisectionGame deploys a new Ethereum contract, binding an instance of OutputBisectionGame to it.
func DeployOutputBisectionGame(auth *bind.TransactOpts, backend bind.ContractBackend, _gameType uint8, _absolutePrestate [32]byte, _genesisBlockNumber *big.Int, _genesisOutputRoot [32]byte, _maxGameDepth *big.Int, _splitDepth *big.Int, _gameDuration uint64, _vm common.Address) (common.Address, *types.Transaction, *OutputBisectionGame, error) {
	parsed, err := OutputBisectionGameMetaData.GetAbi()
	if err != nil {
		return common.Address{}, nil, nil, err
	}
	if parsed == nil {
		return common.Address{}, nil, nil, errors.New("GetABI returned nil")
	}

	address, tx, contract, err := bind.DeployContract(auth, *parsed, common.FromHex(OutputBisectionGameBin), backend, _gameType, _absolutePrestate, _genesisBlockNumber, _genesisOutputRoot, _maxGameDepth, _splitDepth, _gameDuration, _vm)
	if err != nil {
		return common.Address{}, nil, nil, err
	}
	return address, tx, &OutputBisectionGame{OutputBisectionGameCaller: OutputBisectionGameCaller{contract: contract}, OutputBisectionGameTransactor: OutputBisectionGameTransactor{contract: contract}, OutputBisectionGameFilterer: OutputBisectionGameFilterer{contract: contract}}, nil
}

// OutputBisectionGame is an auto generated Go binding around an Ethereum contract.
type OutputBisectionGame struct {
	OutputBisectionGameCaller     // Read-only binding to the contract
	OutputBisectionGameTransactor // Write-only binding to the contract
	OutputBisectionGameFilterer   // Log filterer for contract events
}

// OutputBisectionGameCaller is an auto generated read-only Go binding around an Ethereum contract.
type OutputBisectionGameCaller struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// OutputBisectionGameTransactor is an auto generated write-only Go binding around an Ethereum contract.
type OutputBisectionGameTransactor struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// OutputBisectionGameFilterer is an auto generated log filtering Go binding around an Ethereum contract events.
type OutputBisectionGameFilterer struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// OutputBisectionGameSession is an auto generated Go binding around an Ethereum contract,
// with pre-set call and transact options.
type OutputBisectionGameSession struct {
	Contract     *OutputBisectionGame // Generic contract binding to set the session for
	CallOpts     bind.CallOpts        // Call options to use throughout this session
	TransactOpts bind.TransactOpts    // Transaction auth options to use throughout this session
}

// OutputBisectionGameCallerSession is an auto generated read-only Go binding around an Ethereum contract,
// with pre-set call options.
type OutputBisectionGameCallerSession struct {
	Contract *OutputBisectionGameCaller // Generic contract caller binding to set the session for
	CallOpts bind.CallOpts              // Call options to use throughout this session
}

// OutputBisectionGameTransactorSession is an auto generated write-only Go binding around an Ethereum contract,
// with pre-set transact options.
type OutputBisectionGameTransactorSession struct {
	Contract     *OutputBisectionGameTransactor // Generic contract transactor binding to set the session for
	TransactOpts bind.TransactOpts              // Transaction auth options to use throughout this session
}

// OutputBisectionGameRaw is an auto generated low-level Go binding around an Ethereum contract.
type OutputBisectionGameRaw struct {
	Contract *OutputBisectionGame // Generic contract binding to access the raw methods on
}

// OutputBisectionGameCallerRaw is an auto generated low-level read-only Go binding around an Ethereum contract.
type OutputBisectionGameCallerRaw struct {
	Contract *OutputBisectionGameCaller // Generic read-only contract binding to access the raw methods on
}

// OutputBisectionGameTransactorRaw is an auto generated low-level write-only Go binding around an Ethereum contract.
type OutputBisectionGameTransactorRaw struct {
	Contract *OutputBisectionGameTransactor // Generic write-only contract binding to access the raw methods on
}

// NewOutputBisectionGame creates a new instance of OutputBisectionGame, bound to a specific deployed contract.
func NewOutputBisectionGame(address common.Address, backend bind.ContractBackend) (*OutputBisectionGame, error) {
	contract, err := bindOutputBisectionGame(address, backend, backend, backend)
	if err != nil {
		return nil, err
	}
	return &OutputBisectionGame{OutputBisectionGameCaller: OutputBisectionGameCaller{contract: contract}, OutputBisectionGameTransactor: OutputBisectionGameTransactor{contract: contract}, OutputBisectionGameFilterer: OutputBisectionGameFilterer{contract: contract}}, nil
}

// NewOutputBisectionGameCaller creates a new read-only instance of OutputBisectionGame, bound to a specific deployed contract.
func NewOutputBisectionGameCaller(address common.Address, caller bind.ContractCaller) (*OutputBisectionGameCaller, error) {
	contract, err := bindOutputBisectionGame(address, caller, nil, nil)
	if err != nil {
		return nil, err
	}
	return &OutputBisectionGameCaller{contract: contract}, nil
}

// NewOutputBisectionGameTransactor creates a new write-only instance of OutputBisectionGame, bound to a specific deployed contract.
func NewOutputBisectionGameTransactor(address common.Address, transactor bind.ContractTransactor) (*OutputBisectionGameTransactor, error) {
	contract, err := bindOutputBisectionGame(address, nil, transactor, nil)
	if err != nil {
		return nil, err
	}
	return &OutputBisectionGameTransactor{contract: contract}, nil
}

// NewOutputBisectionGameFilterer creates a new log filterer instance of OutputBisectionGame, bound to a specific deployed contract.
func NewOutputBisectionGameFilterer(address common.Address, filterer bind.ContractFilterer) (*OutputBisectionGameFilterer, error) {
	contract, err := bindOutputBisectionGame(address, nil, nil, filterer)
	if err != nil {
		return nil, err
	}
	return &OutputBisectionGameFilterer{contract: contract}, nil
}

// bindOutputBisectionGame binds a generic wrapper to an already deployed contract.
func bindOutputBisectionGame(address common.Address, caller bind.ContractCaller, transactor bind.ContractTransactor, filterer bind.ContractFilterer) (*bind.BoundContract, error) {
	parsed, err := abi.JSON(strings.NewReader(OutputBisectionGameABI))
	if err != nil {
		return nil, err
	}
	return bind.NewBoundContract(address, parsed, caller, transactor, filterer), nil
}

// Call invokes the (constant) contract method with params as input values and
// sets the output to result. The result type might be a single field for simple
// returns, a slice of interfaces for anonymous returns and a struct for named
// returns.
func (_OutputBisectionGame *OutputBisectionGameRaw) Call(opts *bind.CallOpts, result *[]interface{}, method string, params ...interface{}) error {
	return _OutputBisectionGame.Contract.OutputBisectionGameCaller.contract.Call(opts, result, method, params...)
}

// Transfer initiates a plain transaction to move funds to the contract, calling
// its default method if one is available.
func (_OutputBisectionGame *OutputBisectionGameRaw) Transfer(opts *bind.TransactOpts) (*types.Transaction, error) {
	return _OutputBisectionGame.Contract.OutputBisectionGameTransactor.contract.Transfer(opts)
}

// Transact invokes the (paid) contract method with params as input values.
func (_OutputBisectionGame *OutputBisectionGameRaw) Transact(opts *bind.TransactOpts, method string, params ...interface{}) (*types.Transaction, error) {
	return _OutputBisectionGame.Contract.OutputBisectionGameTransactor.contract.Transact(opts, method, params...)
}

// Call invokes the (constant) contract method with params as input values and
// sets the output to result. The result type might be a single field for simple
// returns, a slice of interfaces for anonymous returns and a struct for named
// returns.
func (_OutputBisectionGame *OutputBisectionGameCallerRaw) Call(opts *bind.CallOpts, result *[]interface{}, method string, params ...interface{}) error {
	return _OutputBisectionGame.Contract.contract.Call(opts, result, method, params...)
}

// Transfer initiates a plain transaction to move funds to the contract, calling
// its default method if one is available.
func (_OutputBisectionGame *OutputBisectionGameTransactorRaw) Transfer(opts *bind.TransactOpts) (*types.Transaction, error) {
	return _OutputBisectionGame.Contract.contract.Transfer(opts)
}

// Transact invokes the (paid) contract method with params as input values.
func (_OutputBisectionGame *OutputBisectionGameTransactorRaw) Transact(opts *bind.TransactOpts, method string, params ...interface{}) (*types.Transaction, error) {
	return _OutputBisectionGame.Contract.contract.Transact(opts, method, params...)
}

// ABSOLUTEPRESTATE is a free data retrieval call binding the contract method 0x266198f9.
//
// Solidity: function ABSOLUTE_PRESTATE() view returns(bytes32)
func (_OutputBisectionGame *OutputBisectionGameCaller) ABSOLUTEPRESTATE(opts *bind.CallOpts) ([32]byte, error) {
	var out []interface{}
	err := _OutputBisectionGame.contract.Call(opts, &out, "ABSOLUTE_PRESTATE")

	if err != nil {
		return *new([32]byte), err
	}

	out0 := *abi.ConvertType(out[0], new([32]byte)).(*[32]byte)

	return out0, err

}

// ABSOLUTEPRESTATE is a free data retrieval call binding the contract method 0x266198f9.
//
// Solidity: function ABSOLUTE_PRESTATE() view returns(bytes32)
func (_OutputBisectionGame *OutputBisectionGameSession) ABSOLUTEPRESTATE() ([32]byte, error) {
	return _OutputBisectionGame.Contract.ABSOLUTEPRESTATE(&_OutputBisectionGame.CallOpts)
}

// ABSOLUTEPRESTATE is a free data retrieval call binding the contract method 0x266198f9.
//
// Solidity: function ABSOLUTE_PRESTATE() view returns(bytes32)
func (_OutputBisectionGame *OutputBisectionGameCallerSession) ABSOLUTEPRESTATE() ([32]byte, error) {
	return _OutputBisectionGame.Contract.ABSOLUTEPRESTATE(&_OutputBisectionGame.CallOpts)
}

// GAMEDURATION is a free data retrieval call binding the contract method 0xc31b29ce.
//
// Solidity: function GAME_DURATION() view returns(uint64)
func (_OutputBisectionGame *OutputBisectionGameCaller) GAMEDURATION(opts *bind.CallOpts) (uint64, error) {
	var out []interface{}
	err := _OutputBisectionGame.contract.Call(opts, &out, "GAME_DURATION")

	if err != nil {
		return *new(uint64), err
	}

	out0 := *abi.ConvertType(out[0], new(uint64)).(*uint64)

	return out0, err

}

// GAMEDURATION is a free data retrieval call binding the contract method 0xc31b29ce.
//
// Solidity: function GAME_DURATION() view returns(uint64)
func (_OutputBisectionGame *OutputBisectionGameSession) GAMEDURATION() (uint64, error) {
	return _OutputBisectionGame.Contract.GAMEDURATION(&_OutputBisectionGame.CallOpts)
}

// GAMEDURATION is a free data retrieval call binding the contract method 0xc31b29ce.
//
// Solidity: function GAME_DURATION() view returns(uint64)
func (_OutputBisectionGame *OutputBisectionGameCallerSession) GAMEDURATION() (uint64, error) {
	return _OutputBisectionGame.Contract.GAMEDURATION(&_OutputBisectionGame.CallOpts)
}

// GENESISBLOCKNUMBER is a free data retrieval call binding the contract method 0x6737abeb.
//
// Solidity: function GENESIS_BLOCK_NUMBER() view returns(uint256)
func (_OutputBisectionGame *OutputBisectionGameCaller) GENESISBLOCKNUMBER(opts *bind.CallOpts) (*big.Int, error) {
	var out []interface{}
	err := _OutputBisectionGame.contract.Call(opts, &out, "GENESIS_BLOCK_NUMBER")

	if err != nil {
		return *new(*big.Int), err
	}

	out0 := *abi.ConvertType(out[0], new(*big.Int)).(**big.Int)

	return out0, err

}

// GENESISBLOCKNUMBER is a free data retrieval call binding the contract method 0x6737abeb.
//
// Solidity: function GENESIS_BLOCK_NUMBER() view returns(uint256)
func (_OutputBisectionGame *OutputBisectionGameSession) GENESISBLOCKNUMBER() (*big.Int, error) {
	return _OutputBisectionGame.Contract.GENESISBLOCKNUMBER(&_OutputBisectionGame.CallOpts)
}

// GENESISBLOCKNUMBER is a free data retrieval call binding the contract method 0x6737abeb.
//
// Solidity: function GENESIS_BLOCK_NUMBER() view returns(uint256)
func (_OutputBisectionGame *OutputBisectionGameCallerSession) GENESISBLOCKNUMBER() (*big.Int, error) {
	return _OutputBisectionGame.Contract.GENESISBLOCKNUMBER(&_OutputBisectionGame.CallOpts)
}

// GENESISOUTPUTROOT is a free data retrieval call binding the contract method 0xcaa4ba2d.
//
// Solidity: function GENESIS_OUTPUT_ROOT() view returns(bytes32)
func (_OutputBisectionGame *OutputBisectionGameCaller) GENESISOUTPUTROOT(opts *bind.CallOpts) ([32]byte, error) {
	var out []interface{}
	err := _OutputBisectionGame.contract.Call(opts, &out, "GENESIS_OUTPUT_ROOT")

	if err != nil {
		return *new([32]byte), err
	}

	out0 := *abi.ConvertType(out[0], new([32]byte)).(*[32]byte)

	return out0, err

}

// GENESISOUTPUTROOT is a free data retrieval call binding the contract method 0xcaa4ba2d.
//
// Solidity: function GENESIS_OUTPUT_ROOT() view returns(bytes32)
func (_OutputBisectionGame *OutputBisectionGameSession) GENESISOUTPUTROOT() ([32]byte, error) {
	return _OutputBisectionGame.Contract.GENESISOUTPUTROOT(&_OutputBisectionGame.CallOpts)
}

// GENESISOUTPUTROOT is a free data retrieval call binding the contract method 0xcaa4ba2d.
//
// Solidity: function GENESIS_OUTPUT_ROOT() view returns(bytes32)
func (_OutputBisectionGame *OutputBisectionGameCallerSession) GENESISOUTPUTROOT() ([32]byte, error) {
	return _OutputBisectionGame.Contract.GENESISOUTPUTROOT(&_OutputBisectionGame.CallOpts)
}

// MAXGAMEDEPTH is a free data retrieval call binding the contract method 0x4778efe8.
//
// Solidity: function MAX_GAME_DEPTH() view returns(uint256)
func (_OutputBisectionGame *OutputBisectionGameCaller) MAXGAMEDEPTH(opts *bind.CallOpts) (*big.Int, error) {
	var out []interface{}
	err := _OutputBisectionGame.contract.Call(opts, &out, "MAX_GAME_DEPTH")

	if err != nil {
		return *new(*big.Int), err
	}

	out0 := *abi.ConvertType(out[0], new(*big.Int)).(**big.Int)

	return out0, err

}

// MAXGAMEDEPTH is a free data retrieval call binding the contract method 0x4778efe8.
//
// Solidity: function MAX_GAME_DEPTH() view returns(uint256)
func (_OutputBisectionGame *OutputBisectionGameSession) MAXGAMEDEPTH() (*big.Int, error) {
	return _OutputBisectionGame.Contract.MAXGAMEDEPTH(&_OutputBisectionGame.CallOpts)
}

// MAXGAMEDEPTH is a free data retrieval call binding the contract method 0x4778efe8.
//
// Solidity: function MAX_GAME_DEPTH() view returns(uint256)
func (_OutputBisectionGame *OutputBisectionGameCallerSession) MAXGAMEDEPTH() (*big.Int, error) {
	return _OutputBisectionGame.Contract.MAXGAMEDEPTH(&_OutputBisectionGame.CallOpts)
}

// SPLITDEPTH is a free data retrieval call binding the contract method 0x24185bc6.
//
// Solidity: function SPLIT_DEPTH() view returns(uint256)
func (_OutputBisectionGame *OutputBisectionGameCaller) SPLITDEPTH(opts *bind.CallOpts) (*big.Int, error) {
	var out []interface{}
	err := _OutputBisectionGame.contract.Call(opts, &out, "SPLIT_DEPTH")

	if err != nil {
		return *new(*big.Int), err
	}

	out0 := *abi.ConvertType(out[0], new(*big.Int)).(**big.Int)

	return out0, err

}

// SPLITDEPTH is a free data retrieval call binding the contract method 0x24185bc6.
//
// Solidity: function SPLIT_DEPTH() view returns(uint256)
func (_OutputBisectionGame *OutputBisectionGameSession) SPLITDEPTH() (*big.Int, error) {
	return _OutputBisectionGame.Contract.SPLITDEPTH(&_OutputBisectionGame.CallOpts)
}

// SPLITDEPTH is a free data retrieval call binding the contract method 0x24185bc6.
//
// Solidity: function SPLIT_DEPTH() view returns(uint256)
func (_OutputBisectionGame *OutputBisectionGameCallerSession) SPLITDEPTH() (*big.Int, error) {
	return _OutputBisectionGame.Contract.SPLITDEPTH(&_OutputBisectionGame.CallOpts)
}

// VM is a free data retrieval call binding the contract method 0x92931298.
//
// Solidity: function VM() view returns(address)
func (_OutputBisectionGame *OutputBisectionGameCaller) VM(opts *bind.CallOpts) (common.Address, error) {
	var out []interface{}
	err := _OutputBisectionGame.contract.Call(opts, &out, "VM")

	if err != nil {
		return *new(common.Address), err
	}

	out0 := *abi.ConvertType(out[0], new(common.Address)).(*common.Address)

	return out0, err

}

// VM is a free data retrieval call binding the contract method 0x92931298.
//
// Solidity: function VM() view returns(address)
func (_OutputBisectionGame *OutputBisectionGameSession) VM() (common.Address, error) {
	return _OutputBisectionGame.Contract.VM(&_OutputBisectionGame.CallOpts)
}

// VM is a free data retrieval call binding the contract method 0x92931298.
//
// Solidity: function VM() view returns(address)
func (_OutputBisectionGame *OutputBisectionGameCallerSession) VM() (common.Address, error) {
	return _OutputBisectionGame.Contract.VM(&_OutputBisectionGame.CallOpts)
}

// BondManager is a free data retrieval call binding the contract method 0x363cc427.
//
// Solidity: function bondManager() view returns(address)
func (_OutputBisectionGame *OutputBisectionGameCaller) BondManager(opts *bind.CallOpts) (common.Address, error) {
	var out []interface{}
	err := _OutputBisectionGame.contract.Call(opts, &out, "bondManager")

	if err != nil {
		return *new(common.Address), err
	}

	out0 := *abi.ConvertType(out[0], new(common.Address)).(*common.Address)

	return out0, err

}

// BondManager is a free data retrieval call binding the contract method 0x363cc427.
//
// Solidity: function bondManager() view returns(address)
func (_OutputBisectionGame *OutputBisectionGameSession) BondManager() (common.Address, error) {
	return _OutputBisectionGame.Contract.BondManager(&_OutputBisectionGame.CallOpts)
}

// BondManager is a free data retrieval call binding the contract method 0x363cc427.
//
// Solidity: function bondManager() view returns(address)
func (_OutputBisectionGame *OutputBisectionGameCallerSession) BondManager() (common.Address, error) {
	return _OutputBisectionGame.Contract.BondManager(&_OutputBisectionGame.CallOpts)
}

// ClaimData is a free data retrieval call binding the contract method 0xc6f0308c.
//
// Solidity: function claimData(uint256 ) view returns(uint32 parentIndex, bool countered, bytes32 claim, uint128 position, uint128 clock)
func (_OutputBisectionGame *OutputBisectionGameCaller) ClaimData(opts *bind.CallOpts, arg0 *big.Int) (struct {
	ParentIndex uint32
	Countered   bool
	Claim       [32]byte
	Position    *big.Int
	Clock       *big.Int
}, error) {
	var out []interface{}
	err := _OutputBisectionGame.contract.Call(opts, &out, "claimData", arg0)

	outstruct := new(struct {
		ParentIndex uint32
		Countered   bool
		Claim       [32]byte
		Position    *big.Int
		Clock       *big.Int
	})
	if err != nil {
		return *outstruct, err
	}

	outstruct.ParentIndex = *abi.ConvertType(out[0], new(uint32)).(*uint32)
	outstruct.Countered = *abi.ConvertType(out[1], new(bool)).(*bool)
	outstruct.Claim = *abi.ConvertType(out[2], new([32]byte)).(*[32]byte)
	outstruct.Position = *abi.ConvertType(out[3], new(*big.Int)).(**big.Int)
	outstruct.Clock = *abi.ConvertType(out[4], new(*big.Int)).(**big.Int)

	return *outstruct, err

}

// ClaimData is a free data retrieval call binding the contract method 0xc6f0308c.
//
// Solidity: function claimData(uint256 ) view returns(uint32 parentIndex, bool countered, bytes32 claim, uint128 position, uint128 clock)
func (_OutputBisectionGame *OutputBisectionGameSession) ClaimData(arg0 *big.Int) (struct {
	ParentIndex uint32
	Countered   bool
	Claim       [32]byte
	Position    *big.Int
	Clock       *big.Int
}, error) {
	return _OutputBisectionGame.Contract.ClaimData(&_OutputBisectionGame.CallOpts, arg0)
}

// ClaimData is a free data retrieval call binding the contract method 0xc6f0308c.
//
// Solidity: function claimData(uint256 ) view returns(uint32 parentIndex, bool countered, bytes32 claim, uint128 position, uint128 clock)
func (_OutputBisectionGame *OutputBisectionGameCallerSession) ClaimData(arg0 *big.Int) (struct {
	ParentIndex uint32
	Countered   bool
	Claim       [32]byte
	Position    *big.Int
	Clock       *big.Int
}, error) {
	return _OutputBisectionGame.Contract.ClaimData(&_OutputBisectionGame.CallOpts, arg0)
}

// ClaimDataLen is a free data retrieval call binding the contract method 0x8980e0cc.
//
// Solidity: function claimDataLen() view returns(uint256 len_)
func (_OutputBisectionGame *OutputBisectionGameCaller) ClaimDataLen(opts *bind.CallOpts) (*big.Int, error) {
	var out []interface{}
	err := _OutputBisectionGame.contract.Call(opts, &out, "claimDataLen")

	if err != nil {
		return *new(*big.Int), err
	}

	out0 := *abi.ConvertType(out[0], new(*big.Int)).(**big.Int)

	return out0, err

}

// ClaimDataLen is a free data retrieval call binding the contract method 0x8980e0cc.
//
// Solidity: function claimDataLen() view returns(uint256 len_)
func (_OutputBisectionGame *OutputBisectionGameSession) ClaimDataLen() (*big.Int, error) {
	return _OutputBisectionGame.Contract.ClaimDataLen(&_OutputBisectionGame.CallOpts)
}

// ClaimDataLen is a free data retrieval call binding the contract method 0x8980e0cc.
//
// Solidity: function claimDataLen() view returns(uint256 len_)
func (_OutputBisectionGame *OutputBisectionGameCallerSession) ClaimDataLen() (*big.Int, error) {
	return _OutputBisectionGame.Contract.ClaimDataLen(&_OutputBisectionGame.CallOpts)
}

// CreatedAt is a free data retrieval call binding the contract method 0xcf09e0d0.
//
// Solidity: function createdAt() view returns(uint64)
func (_OutputBisectionGame *OutputBisectionGameCaller) CreatedAt(opts *bind.CallOpts) (uint64, error) {
	var out []interface{}
	err := _OutputBisectionGame.contract.Call(opts, &out, "createdAt")

	if err != nil {
		return *new(uint64), err
	}

	out0 := *abi.ConvertType(out[0], new(uint64)).(*uint64)

	return out0, err

}

// CreatedAt is a free data retrieval call binding the contract method 0xcf09e0d0.
//
// Solidity: function createdAt() view returns(uint64)
func (_OutputBisectionGame *OutputBisectionGameSession) CreatedAt() (uint64, error) {
	return _OutputBisectionGame.Contract.CreatedAt(&_OutputBisectionGame.CallOpts)
}

// CreatedAt is a free data retrieval call binding the contract method 0xcf09e0d0.
//
// Solidity: function createdAt() view returns(uint64)
func (_OutputBisectionGame *OutputBisectionGameCallerSession) CreatedAt() (uint64, error) {
	return _OutputBisectionGame.Contract.CreatedAt(&_OutputBisectionGame.CallOpts)
}

// ExtraData is a free data retrieval call binding the contract method 0x609d3334.
//
// Solidity: function extraData() pure returns(bytes extraData_)
func (_OutputBisectionGame *OutputBisectionGameCaller) ExtraData(opts *bind.CallOpts) ([]byte, error) {
	var out []interface{}
	err := _OutputBisectionGame.contract.Call(opts, &out, "extraData")

	if err != nil {
		return *new([]byte), err
	}

	out0 := *abi.ConvertType(out[0], new([]byte)).(*[]byte)

	return out0, err

}

// ExtraData is a free data retrieval call binding the contract method 0x609d3334.
//
// Solidity: function extraData() pure returns(bytes extraData_)
func (_OutputBisectionGame *OutputBisectionGameSession) ExtraData() ([]byte, error) {
	return _OutputBisectionGame.Contract.ExtraData(&_OutputBisectionGame.CallOpts)
}

// ExtraData is a free data retrieval call binding the contract method 0x609d3334.
//
// Solidity: function extraData() pure returns(bytes extraData_)
func (_OutputBisectionGame *OutputBisectionGameCallerSession) ExtraData() ([]byte, error) {
	return _OutputBisectionGame.Contract.ExtraData(&_OutputBisectionGame.CallOpts)
}

// GameData is a free data retrieval call binding the contract method 0xfa24f743.
//
// Solidity: function gameData() view returns(uint8 gameType_, bytes32 rootClaim_, bytes extraData_)
func (_OutputBisectionGame *OutputBisectionGameCaller) GameData(opts *bind.CallOpts) (struct {
	GameType  uint8
	RootClaim [32]byte
	ExtraData []byte
}, error) {
	var out []interface{}
	err := _OutputBisectionGame.contract.Call(opts, &out, "gameData")

	outstruct := new(struct {
		GameType  uint8
		RootClaim [32]byte
		ExtraData []byte
	})
	if err != nil {
		return *outstruct, err
	}

	outstruct.GameType = *abi.ConvertType(out[0], new(uint8)).(*uint8)
	outstruct.RootClaim = *abi.ConvertType(out[1], new([32]byte)).(*[32]byte)
	outstruct.ExtraData = *abi.ConvertType(out[2], new([]byte)).(*[]byte)

	return *outstruct, err

}

// GameData is a free data retrieval call binding the contract method 0xfa24f743.
//
// Solidity: function gameData() view returns(uint8 gameType_, bytes32 rootClaim_, bytes extraData_)
func (_OutputBisectionGame *OutputBisectionGameSession) GameData() (struct {
	GameType  uint8
	RootClaim [32]byte
	ExtraData []byte
}, error) {
	return _OutputBisectionGame.Contract.GameData(&_OutputBisectionGame.CallOpts)
}

// GameData is a free data retrieval call binding the contract method 0xfa24f743.
//
// Solidity: function gameData() view returns(uint8 gameType_, bytes32 rootClaim_, bytes extraData_)
func (_OutputBisectionGame *OutputBisectionGameCallerSession) GameData() (struct {
	GameType  uint8
	RootClaim [32]byte
	ExtraData []byte
}, error) {
	return _OutputBisectionGame.Contract.GameData(&_OutputBisectionGame.CallOpts)
}

// GameType is a free data retrieval call binding the contract method 0xbbdc02db.
//
// Solidity: function gameType() view returns(uint8 gameType_)
func (_OutputBisectionGame *OutputBisectionGameCaller) GameType(opts *bind.CallOpts) (uint8, error) {
	var out []interface{}
	err := _OutputBisectionGame.contract.Call(opts, &out, "gameType")

	if err != nil {
		return *new(uint8), err
	}

	out0 := *abi.ConvertType(out[0], new(uint8)).(*uint8)

	return out0, err

}

// GameType is a free data retrieval call binding the contract method 0xbbdc02db.
//
// Solidity: function gameType() view returns(uint8 gameType_)
func (_OutputBisectionGame *OutputBisectionGameSession) GameType() (uint8, error) {
	return _OutputBisectionGame.Contract.GameType(&_OutputBisectionGame.CallOpts)
}

// GameType is a free data retrieval call binding the contract method 0xbbdc02db.
//
// Solidity: function gameType() view returns(uint8 gameType_)
func (_OutputBisectionGame *OutputBisectionGameCallerSession) GameType() (uint8, error) {
	return _OutputBisectionGame.Contract.GameType(&_OutputBisectionGame.CallOpts)
}

// L1Head is a free data retrieval call binding the contract method 0x6361506d.
//
// Solidity: function l1Head() view returns(bytes32)
func (_OutputBisectionGame *OutputBisectionGameCaller) L1Head(opts *bind.CallOpts) ([32]byte, error) {
	var out []interface{}
	err := _OutputBisectionGame.contract.Call(opts, &out, "l1Head")

	if err != nil {
		return *new([32]byte), err
	}

	out0 := *abi.ConvertType(out[0], new([32]byte)).(*[32]byte)

	return out0, err

}

// L1Head is a free data retrieval call binding the contract method 0x6361506d.
//
// Solidity: function l1Head() view returns(bytes32)
func (_OutputBisectionGame *OutputBisectionGameSession) L1Head() ([32]byte, error) {
	return _OutputBisectionGame.Contract.L1Head(&_OutputBisectionGame.CallOpts)
}

// L1Head is a free data retrieval call binding the contract method 0x6361506d.
//
// Solidity: function l1Head() view returns(bytes32)
func (_OutputBisectionGame *OutputBisectionGameCallerSession) L1Head() ([32]byte, error) {
	return _OutputBisectionGame.Contract.L1Head(&_OutputBisectionGame.CallOpts)
}

// L2BlockNumber is a free data retrieval call binding the contract method 0x8b85902b.
//
// Solidity: function l2BlockNumber() pure returns(uint256 l2BlockNumber_)
func (_OutputBisectionGame *OutputBisectionGameCaller) L2BlockNumber(opts *bind.CallOpts) (*big.Int, error) {
	var out []interface{}
	err := _OutputBisectionGame.contract.Call(opts, &out, "l2BlockNumber")

	if err != nil {
		return *new(*big.Int), err
	}

	out0 := *abi.ConvertType(out[0], new(*big.Int)).(**big.Int)

	return out0, err

}

// L2BlockNumber is a free data retrieval call binding the contract method 0x8b85902b.
//
// Solidity: function l2BlockNumber() pure returns(uint256 l2BlockNumber_)
func (_OutputBisectionGame *OutputBisectionGameSession) L2BlockNumber() (*big.Int, error) {
	return _OutputBisectionGame.Contract.L2BlockNumber(&_OutputBisectionGame.CallOpts)
}

// L2BlockNumber is a free data retrieval call binding the contract method 0x8b85902b.
//
// Solidity: function l2BlockNumber() pure returns(uint256 l2BlockNumber_)
func (_OutputBisectionGame *OutputBisectionGameCallerSession) L2BlockNumber() (*big.Int, error) {
	return _OutputBisectionGame.Contract.L2BlockNumber(&_OutputBisectionGame.CallOpts)
}

// ResolvedAt is a free data retrieval call binding the contract method 0x19effeb4.
//
// Solidity: function resolvedAt() view returns(uint64)
func (_OutputBisectionGame *OutputBisectionGameCaller) ResolvedAt(opts *bind.CallOpts) (uint64, error) {
	var out []interface{}
	err := _OutputBisectionGame.contract.Call(opts, &out, "resolvedAt")

	if err != nil {
		return *new(uint64), err
	}

	out0 := *abi.ConvertType(out[0], new(uint64)).(*uint64)

	return out0, err

}

// ResolvedAt is a free data retrieval call binding the contract method 0x19effeb4.
//
// Solidity: function resolvedAt() view returns(uint64)
func (_OutputBisectionGame *OutputBisectionGameSession) ResolvedAt() (uint64, error) {
	return _OutputBisectionGame.Contract.ResolvedAt(&_OutputBisectionGame.CallOpts)
}

// ResolvedAt is a free data retrieval call binding the contract method 0x19effeb4.
//
// Solidity: function resolvedAt() view returns(uint64)
func (_OutputBisectionGame *OutputBisectionGameCallerSession) ResolvedAt() (uint64, error) {
	return _OutputBisectionGame.Contract.ResolvedAt(&_OutputBisectionGame.CallOpts)
}

// RootClaim is a free data retrieval call binding the contract method 0xbcef3b55.
//
// Solidity: function rootClaim() pure returns(bytes32 rootClaim_)
func (_OutputBisectionGame *OutputBisectionGameCaller) RootClaim(opts *bind.CallOpts) ([32]byte, error) {
	var out []interface{}
	err := _OutputBisectionGame.contract.Call(opts, &out, "rootClaim")

	if err != nil {
		return *new([32]byte), err
	}

	out0 := *abi.ConvertType(out[0], new([32]byte)).(*[32]byte)

	return out0, err

}

// RootClaim is a free data retrieval call binding the contract method 0xbcef3b55.
//
// Solidity: function rootClaim() pure returns(bytes32 rootClaim_)
func (_OutputBisectionGame *OutputBisectionGameSession) RootClaim() ([32]byte, error) {
	return _OutputBisectionGame.Contract.RootClaim(&_OutputBisectionGame.CallOpts)
}

// RootClaim is a free data retrieval call binding the contract method 0xbcef3b55.
//
// Solidity: function rootClaim() pure returns(bytes32 rootClaim_)
func (_OutputBisectionGame *OutputBisectionGameCallerSession) RootClaim() ([32]byte, error) {
	return _OutputBisectionGame.Contract.RootClaim(&_OutputBisectionGame.CallOpts)
}

// Status is a free data retrieval call binding the contract method 0x200d2ed2.
//
// Solidity: function status() view returns(uint8)
func (_OutputBisectionGame *OutputBisectionGameCaller) Status(opts *bind.CallOpts) (uint8, error) {
	var out []interface{}
	err := _OutputBisectionGame.contract.Call(opts, &out, "status")

	if err != nil {
		return *new(uint8), err
	}

	out0 := *abi.ConvertType(out[0], new(uint8)).(*uint8)

	return out0, err

}

// Status is a free data retrieval call binding the contract method 0x200d2ed2.
//
// Solidity: function status() view returns(uint8)
func (_OutputBisectionGame *OutputBisectionGameSession) Status() (uint8, error) {
	return _OutputBisectionGame.Contract.Status(&_OutputBisectionGame.CallOpts)
}

// Status is a free data retrieval call binding the contract method 0x200d2ed2.
//
// Solidity: function status() view returns(uint8)
func (_OutputBisectionGame *OutputBisectionGameCallerSession) Status() (uint8, error) {
	return _OutputBisectionGame.Contract.Status(&_OutputBisectionGame.CallOpts)
}

// Version is a free data retrieval call binding the contract method 0x54fd4d50.
//
// Solidity: function version() view returns(string)
func (_OutputBisectionGame *OutputBisectionGameCaller) Version(opts *bind.CallOpts) (string, error) {
	var out []interface{}
	err := _OutputBisectionGame.contract.Call(opts, &out, "version")

	if err != nil {
		return *new(string), err
	}

	out0 := *abi.ConvertType(out[0], new(string)).(*string)

	return out0, err

}

// Version is a free data retrieval call binding the contract method 0x54fd4d50.
//
// Solidity: function version() view returns(string)
func (_OutputBisectionGame *OutputBisectionGameSession) Version() (string, error) {
	return _OutputBisectionGame.Contract.Version(&_OutputBisectionGame.CallOpts)
}

// Version is a free data retrieval call binding the contract method 0x54fd4d50.
//
// Solidity: function version() view returns(string)
func (_OutputBisectionGame *OutputBisectionGameCallerSession) Version() (string, error) {
	return _OutputBisectionGame.Contract.Version(&_OutputBisectionGame.CallOpts)
}

// AddLocalData is a paid mutator transaction binding the contract method 0xf8f43ff6.
//
// Solidity: function addLocalData(uint256 _ident, uint256 _execLeafIdx, uint256 _partOffset) returns()
func (_OutputBisectionGame *OutputBisectionGameTransactor) AddLocalData(opts *bind.TransactOpts, _ident *big.Int, _execLeafIdx *big.Int, _partOffset *big.Int) (*types.Transaction, error) {
	return _OutputBisectionGame.contract.Transact(opts, "addLocalData", _ident, _execLeafIdx, _partOffset)
}

// AddLocalData is a paid mutator transaction binding the contract method 0xf8f43ff6.
//
// Solidity: function addLocalData(uint256 _ident, uint256 _execLeafIdx, uint256 _partOffset) returns()
func (_OutputBisectionGame *OutputBisectionGameSession) AddLocalData(_ident *big.Int, _execLeafIdx *big.Int, _partOffset *big.Int) (*types.Transaction, error) {
	return _OutputBisectionGame.Contract.AddLocalData(&_OutputBisectionGame.TransactOpts, _ident, _execLeafIdx, _partOffset)
}

// AddLocalData is a paid mutator transaction binding the contract method 0xf8f43ff6.
//
// Solidity: function addLocalData(uint256 _ident, uint256 _execLeafIdx, uint256 _partOffset) returns()
func (_OutputBisectionGame *OutputBisectionGameTransactorSession) AddLocalData(_ident *big.Int, _execLeafIdx *big.Int, _partOffset *big.Int) (*types.Transaction, error) {
	return _OutputBisectionGame.Contract.AddLocalData(&_OutputBisectionGame.TransactOpts, _ident, _execLeafIdx, _partOffset)
}

// Attack is a paid mutator transaction binding the contract method 0xc55cd0c7.
//
// Solidity: function attack(uint256 _parentIndex, bytes32 _claim) payable returns()
func (_OutputBisectionGame *OutputBisectionGameTransactor) Attack(opts *bind.TransactOpts, _parentIndex *big.Int, _claim [32]byte) (*types.Transaction, error) {
	return _OutputBisectionGame.contract.Transact(opts, "attack", _parentIndex, _claim)
}

// Attack is a paid mutator transaction binding the contract method 0xc55cd0c7.
//
// Solidity: function attack(uint256 _parentIndex, bytes32 _claim) payable returns()
func (_OutputBisectionGame *OutputBisectionGameSession) Attack(_parentIndex *big.Int, _claim [32]byte) (*types.Transaction, error) {
	return _OutputBisectionGame.Contract.Attack(&_OutputBisectionGame.TransactOpts, _parentIndex, _claim)
}

// Attack is a paid mutator transaction binding the contract method 0xc55cd0c7.
//
// Solidity: function attack(uint256 _parentIndex, bytes32 _claim) payable returns()
func (_OutputBisectionGame *OutputBisectionGameTransactorSession) Attack(_parentIndex *big.Int, _claim [32]byte) (*types.Transaction, error) {
	return _OutputBisectionGame.Contract.Attack(&_OutputBisectionGame.TransactOpts, _parentIndex, _claim)
}

// Defend is a paid mutator transaction binding the contract method 0x35fef567.
//
// Solidity: function defend(uint256 _parentIndex, bytes32 _claim) payable returns()
func (_OutputBisectionGame *OutputBisectionGameTransactor) Defend(opts *bind.TransactOpts, _parentIndex *big.Int, _claim [32]byte) (*types.Transaction, error) {
	return _OutputBisectionGame.contract.Transact(opts, "defend", _parentIndex, _claim)
}

// Defend is a paid mutator transaction binding the contract method 0x35fef567.
//
// Solidity: function defend(uint256 _parentIndex, bytes32 _claim) payable returns()
func (_OutputBisectionGame *OutputBisectionGameSession) Defend(_parentIndex *big.Int, _claim [32]byte) (*types.Transaction, error) {
	return _OutputBisectionGame.Contract.Defend(&_OutputBisectionGame.TransactOpts, _parentIndex, _claim)
}

// Defend is a paid mutator transaction binding the contract method 0x35fef567.
//
// Solidity: function defend(uint256 _parentIndex, bytes32 _claim) payable returns()
func (_OutputBisectionGame *OutputBisectionGameTransactorSession) Defend(_parentIndex *big.Int, _claim [32]byte) (*types.Transaction, error) {
	return _OutputBisectionGame.Contract.Defend(&_OutputBisectionGame.TransactOpts, _parentIndex, _claim)
}

// Initialize is a paid mutator transaction binding the contract method 0x8129fc1c.
//
// Solidity: function initialize() returns()
func (_OutputBisectionGame *OutputBisectionGameTransactor) Initialize(opts *bind.TransactOpts) (*types.Transaction, error) {
	return _OutputBisectionGame.contract.Transact(opts, "initialize")
}

// Initialize is a paid mutator transaction binding the contract method 0x8129fc1c.
//
// Solidity: function initialize() returns()
func (_OutputBisectionGame *OutputBisectionGameSession) Initialize() (*types.Transaction, error) {
	return _OutputBisectionGame.Contract.Initialize(&_OutputBisectionGame.TransactOpts)
}

// Initialize is a paid mutator transaction binding the contract method 0x8129fc1c.
//
// Solidity: function initialize() returns()
func (_OutputBisectionGame *OutputBisectionGameTransactorSession) Initialize() (*types.Transaction, error) {
	return _OutputBisectionGame.Contract.Initialize(&_OutputBisectionGame.TransactOpts)
}

// Move is a paid mutator transaction binding the contract method 0x632247ea.
//
// Solidity: function move(uint256 _challengeIndex, bytes32 _claim, bool _isAttack) payable returns()
func (_OutputBisectionGame *OutputBisectionGameTransactor) Move(opts *bind.TransactOpts, _challengeIndex *big.Int, _claim [32]byte, _isAttack bool) (*types.Transaction, error) {
	return _OutputBisectionGame.contract.Transact(opts, "move", _challengeIndex, _claim, _isAttack)
}

// Move is a paid mutator transaction binding the contract method 0x632247ea.
//
// Solidity: function move(uint256 _challengeIndex, bytes32 _claim, bool _isAttack) payable returns()
func (_OutputBisectionGame *OutputBisectionGameSession) Move(_challengeIndex *big.Int, _claim [32]byte, _isAttack bool) (*types.Transaction, error) {
	return _OutputBisectionGame.Contract.Move(&_OutputBisectionGame.TransactOpts, _challengeIndex, _claim, _isAttack)
}

// Move is a paid mutator transaction binding the contract method 0x632247ea.
//
// Solidity: function move(uint256 _challengeIndex, bytes32 _claim, bool _isAttack) payable returns()
func (_OutputBisectionGame *OutputBisectionGameTransactorSession) Move(_challengeIndex *big.Int, _claim [32]byte, _isAttack bool) (*types.Transaction, error) {
	return _OutputBisectionGame.Contract.Move(&_OutputBisectionGame.TransactOpts, _challengeIndex, _claim, _isAttack)
}

// Resolve is a paid mutator transaction binding the contract method 0x2810e1d6.
//
// Solidity: function resolve() returns(uint8 status_)
func (_OutputBisectionGame *OutputBisectionGameTransactor) Resolve(opts *bind.TransactOpts) (*types.Transaction, error) {
	return _OutputBisectionGame.contract.Transact(opts, "resolve")
}

// Resolve is a paid mutator transaction binding the contract method 0x2810e1d6.
//
// Solidity: function resolve() returns(uint8 status_)
func (_OutputBisectionGame *OutputBisectionGameSession) Resolve() (*types.Transaction, error) {
	return _OutputBisectionGame.Contract.Resolve(&_OutputBisectionGame.TransactOpts)
}

// Resolve is a paid mutator transaction binding the contract method 0x2810e1d6.
//
// Solidity: function resolve() returns(uint8 status_)
func (_OutputBisectionGame *OutputBisectionGameTransactorSession) Resolve() (*types.Transaction, error) {
	return _OutputBisectionGame.Contract.Resolve(&_OutputBisectionGame.TransactOpts)
}

// ResolveClaim is a paid mutator transaction binding the contract method 0xfdffbb28.
//
// Solidity: function resolveClaim(uint256 _claimIndex) payable returns()
func (_OutputBisectionGame *OutputBisectionGameTransactor) ResolveClaim(opts *bind.TransactOpts, _claimIndex *big.Int) (*types.Transaction, error) {
	return _OutputBisectionGame.contract.Transact(opts, "resolveClaim", _claimIndex)
}

// ResolveClaim is a paid mutator transaction binding the contract method 0xfdffbb28.
//
// Solidity: function resolveClaim(uint256 _claimIndex) payable returns()
func (_OutputBisectionGame *OutputBisectionGameSession) ResolveClaim(_claimIndex *big.Int) (*types.Transaction, error) {
	return _OutputBisectionGame.Contract.ResolveClaim(&_OutputBisectionGame.TransactOpts, _claimIndex)
}

// ResolveClaim is a paid mutator transaction binding the contract method 0xfdffbb28.
//
// Solidity: function resolveClaim(uint256 _claimIndex) payable returns()
func (_OutputBisectionGame *OutputBisectionGameTransactorSession) ResolveClaim(_claimIndex *big.Int) (*types.Transaction, error) {
	return _OutputBisectionGame.Contract.ResolveClaim(&_OutputBisectionGame.TransactOpts, _claimIndex)
}

// Step is a paid mutator transaction binding the contract method 0xd8cc1a3c.
//
// Solidity: function step(uint256 _claimIndex, bool _isAttack, bytes _stateData, bytes _proof) returns()
func (_OutputBisectionGame *OutputBisectionGameTransactor) Step(opts *bind.TransactOpts, _claimIndex *big.Int, _isAttack bool, _stateData []byte, _proof []byte) (*types.Transaction, error) {
	return _OutputBisectionGame.contract.Transact(opts, "step", _claimIndex, _isAttack, _stateData, _proof)
}

// Step is a paid mutator transaction binding the contract method 0xd8cc1a3c.
//
// Solidity: function step(uint256 _claimIndex, bool _isAttack, bytes _stateData, bytes _proof) returns()
func (_OutputBisectionGame *OutputBisectionGameSession) Step(_claimIndex *big.Int, _isAttack bool, _stateData []byte, _proof []byte) (*types.Transaction, error) {
	return _OutputBisectionGame.Contract.Step(&_OutputBisectionGame.TransactOpts, _claimIndex, _isAttack, _stateData, _proof)
}

// Step is a paid mutator transaction binding the contract method 0xd8cc1a3c.
//
// Solidity: function step(uint256 _claimIndex, bool _isAttack, bytes _stateData, bytes _proof) returns()
func (_OutputBisectionGame *OutputBisectionGameTransactorSession) Step(_claimIndex *big.Int, _isAttack bool, _stateData []byte, _proof []byte) (*types.Transaction, error) {
	return _OutputBisectionGame.Contract.Step(&_OutputBisectionGame.TransactOpts, _claimIndex, _isAttack, _stateData, _proof)
}

// OutputBisectionGameMoveIterator is returned from FilterMove and is used to iterate over the raw logs and unpacked data for Move events raised by the OutputBisectionGame contract.
type OutputBisectionGameMoveIterator struct {
	Event *OutputBisectionGameMove // Event containing the contract specifics and raw log

	contract *bind.BoundContract // Generic contract to use for unpacking event data
	event    string              // Event name to use for unpacking event data

	logs chan types.Log        // Log channel receiving the found contract events
	sub  ethereum.Subscription // Subscription for errors, completion and termination
	done bool                  // Whether the subscription completed delivering logs
	fail error                 // Occurred error to stop iteration
}

// Next advances the iterator to the subsequent event, returning whether there
// are any more events found. In case of a retrieval or parsing error, false is
// returned and Error() can be queried for the exact failure.
func (it *OutputBisectionGameMoveIterator) Next() bool {
	// If the iterator failed, stop iterating
	if it.fail != nil {
		return false
	}
	// If the iterator completed, deliver directly whatever's available
	if it.done {
		select {
		case log := <-it.logs:
			it.Event = new(OutputBisectionGameMove)
			if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
				it.fail = err
				return false
			}
			it.Event.Raw = log
			return true

		default:
			return false
		}
	}
	// Iterator still in progress, wait for either a data or an error event
	select {
	case log := <-it.logs:
		it.Event = new(OutputBisectionGameMove)
		if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
			it.fail = err
			return false
		}
		it.Event.Raw = log
		return true

	case err := <-it.sub.Err():
		it.done = true
		it.fail = err
		return it.Next()
	}
}

// Error returns any retrieval or parsing error occurred during filtering.
func (it *OutputBisectionGameMoveIterator) Error() error {
	return it.fail
}

// Close terminates the iteration process, releasing any pending underlying
// resources.
func (it *OutputBisectionGameMoveIterator) Close() error {
	it.sub.Unsubscribe()
	return nil
}

// OutputBisectionGameMove represents a Move event raised by the OutputBisectionGame contract.
type OutputBisectionGameMove struct {
	ParentIndex *big.Int
	Claim       [32]byte
	Claimant    common.Address
	Raw         types.Log // Blockchain specific contextual infos
}

// FilterMove is a free log retrieval operation binding the contract event 0x9b3245740ec3b155098a55be84957a4da13eaf7f14a8bc6f53126c0b9350f2be.
//
// Solidity: event Move(uint256 indexed parentIndex, bytes32 indexed claim, address indexed claimant)
func (_OutputBisectionGame *OutputBisectionGameFilterer) FilterMove(opts *bind.FilterOpts, parentIndex []*big.Int, claim [][32]byte, claimant []common.Address) (*OutputBisectionGameMoveIterator, error) {

	var parentIndexRule []interface{}
	for _, parentIndexItem := range parentIndex {
		parentIndexRule = append(parentIndexRule, parentIndexItem)
	}
	var claimRule []interface{}
	for _, claimItem := range claim {
		claimRule = append(claimRule, claimItem)
	}
	var claimantRule []interface{}
	for _, claimantItem := range claimant {
		claimantRule = append(claimantRule, claimantItem)
	}

	logs, sub, err := _OutputBisectionGame.contract.FilterLogs(opts, "Move", parentIndexRule, claimRule, claimantRule)
	if err != nil {
		return nil, err
	}
	return &OutputBisectionGameMoveIterator{contract: _OutputBisectionGame.contract, event: "Move", logs: logs, sub: sub}, nil
}

// WatchMove is a free log subscription operation binding the contract event 0x9b3245740ec3b155098a55be84957a4da13eaf7f14a8bc6f53126c0b9350f2be.
//
// Solidity: event Move(uint256 indexed parentIndex, bytes32 indexed claim, address indexed claimant)
func (_OutputBisectionGame *OutputBisectionGameFilterer) WatchMove(opts *bind.WatchOpts, sink chan<- *OutputBisectionGameMove, parentIndex []*big.Int, claim [][32]byte, claimant []common.Address) (event.Subscription, error) {

	var parentIndexRule []interface{}
	for _, parentIndexItem := range parentIndex {
		parentIndexRule = append(parentIndexRule, parentIndexItem)
	}
	var claimRule []interface{}
	for _, claimItem := range claim {
		claimRule = append(claimRule, claimItem)
	}
	var claimantRule []interface{}
	for _, claimantItem := range claimant {
		claimantRule = append(claimantRule, claimantItem)
	}

	logs, sub, err := _OutputBisectionGame.contract.WatchLogs(opts, "Move", parentIndexRule, claimRule, claimantRule)
	if err != nil {
		return nil, err
	}
	return event.NewSubscription(func(quit <-chan struct{}) error {
		defer sub.Unsubscribe()
		for {
			select {
			case log := <-logs:
				// New log arrived, parse the event and forward to the user
				event := new(OutputBisectionGameMove)
				if err := _OutputBisectionGame.contract.UnpackLog(event, "Move", log); err != nil {
					return err
				}
				event.Raw = log

				select {
				case sink <- event:
				case err := <-sub.Err():
					return err
				case <-quit:
					return nil
				}
			case err := <-sub.Err():
				return err
			case <-quit:
				return nil
			}
		}
	}), nil
}

// ParseMove is a log parse operation binding the contract event 0x9b3245740ec3b155098a55be84957a4da13eaf7f14a8bc6f53126c0b9350f2be.
//
// Solidity: event Move(uint256 indexed parentIndex, bytes32 indexed claim, address indexed claimant)
func (_OutputBisectionGame *OutputBisectionGameFilterer) ParseMove(log types.Log) (*OutputBisectionGameMove, error) {
	event := new(OutputBisectionGameMove)
	if err := _OutputBisectionGame.contract.UnpackLog(event, "Move", log); err != nil {
		return nil, err
	}
	event.Raw = log
	return event, nil
}

// OutputBisectionGameResolvedIterator is returned from FilterResolved and is used to iterate over the raw logs and unpacked data for Resolved events raised by the OutputBisectionGame contract.
type OutputBisectionGameResolvedIterator struct {
	Event *OutputBisectionGameResolved // Event containing the contract specifics and raw log

	contract *bind.BoundContract // Generic contract to use for unpacking event data
	event    string              // Event name to use for unpacking event data

	logs chan types.Log        // Log channel receiving the found contract events
	sub  ethereum.Subscription // Subscription for errors, completion and termination
	done bool                  // Whether the subscription completed delivering logs
	fail error                 // Occurred error to stop iteration
}

// Next advances the iterator to the subsequent event, returning whether there
// are any more events found. In case of a retrieval or parsing error, false is
// returned and Error() can be queried for the exact failure.
func (it *OutputBisectionGameResolvedIterator) Next() bool {
	// If the iterator failed, stop iterating
	if it.fail != nil {
		return false
	}
	// If the iterator completed, deliver directly whatever's available
	if it.done {
		select {
		case log := <-it.logs:
			it.Event = new(OutputBisectionGameResolved)
			if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
				it.fail = err
				return false
			}
			it.Event.Raw = log
			return true

		default:
			return false
		}
	}
	// Iterator still in progress, wait for either a data or an error event
	select {
	case log := <-it.logs:
		it.Event = new(OutputBisectionGameResolved)
		if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
			it.fail = err
			return false
		}
		it.Event.Raw = log
		return true

	case err := <-it.sub.Err():
		it.done = true
		it.fail = err
		return it.Next()
	}
}

// Error returns any retrieval or parsing error occurred during filtering.
func (it *OutputBisectionGameResolvedIterator) Error() error {
	return it.fail
}

// Close terminates the iteration process, releasing any pending underlying
// resources.
func (it *OutputBisectionGameResolvedIterator) Close() error {
	it.sub.Unsubscribe()
	return nil
}

// OutputBisectionGameResolved represents a Resolved event raised by the OutputBisectionGame contract.
type OutputBisectionGameResolved struct {
	Status uint8
	Raw    types.Log // Blockchain specific contextual infos
}

// FilterResolved is a free log retrieval operation binding the contract event 0x5e186f09b9c93491f14e277eea7faa5de6a2d4bda75a79af7a3684fbfb42da60.
//
// Solidity: event Resolved(uint8 indexed status)
func (_OutputBisectionGame *OutputBisectionGameFilterer) FilterResolved(opts *bind.FilterOpts, status []uint8) (*OutputBisectionGameResolvedIterator, error) {

	var statusRule []interface{}
	for _, statusItem := range status {
		statusRule = append(statusRule, statusItem)
	}

	logs, sub, err := _OutputBisectionGame.contract.FilterLogs(opts, "Resolved", statusRule)
	if err != nil {
		return nil, err
	}
	return &OutputBisectionGameResolvedIterator{contract: _OutputBisectionGame.contract, event: "Resolved", logs: logs, sub: sub}, nil
}

// WatchResolved is a free log subscription operation binding the contract event 0x5e186f09b9c93491f14e277eea7faa5de6a2d4bda75a79af7a3684fbfb42da60.
//
// Solidity: event Resolved(uint8 indexed status)
func (_OutputBisectionGame *OutputBisectionGameFilterer) WatchResolved(opts *bind.WatchOpts, sink chan<- *OutputBisectionGameResolved, status []uint8) (event.Subscription, error) {

	var statusRule []interface{}
	for _, statusItem := range status {
		statusRule = append(statusRule, statusItem)
	}

	logs, sub, err := _OutputBisectionGame.contract.WatchLogs(opts, "Resolved", statusRule)
	if err != nil {
		return nil, err
	}
	return event.NewSubscription(func(quit <-chan struct{}) error {
		defer sub.Unsubscribe()
		for {
			select {
			case log := <-logs:
				// New log arrived, parse the event and forward to the user
				event := new(OutputBisectionGameResolved)
				if err := _OutputBisectionGame.contract.UnpackLog(event, "Resolved", log); err != nil {
					return err
				}
				event.Raw = log

				select {
				case sink <- event:
				case err := <-sub.Err():
					return err
				case <-quit:
					return nil
				}
			case err := <-sub.Err():
				return err
			case <-quit:
				return nil
			}
		}
	}), nil
}

// ParseResolved is a log parse operation binding the contract event 0x5e186f09b9c93491f14e277eea7faa5de6a2d4bda75a79af7a3684fbfb42da60.
//
// Solidity: event Resolved(uint8 indexed status)
func (_OutputBisectionGame *OutputBisectionGameFilterer) ParseResolved(log types.Log) (*OutputBisectionGameResolved, error) {
	event := new(OutputBisectionGameResolved)
	if err := _OutputBisectionGame.contract.UnpackLog(event, "Resolved", log); err != nil {
		return nil, err
	}
	event.Raw = log
	return event, nil
}
