package wrapper

import (
	"github.com/ethereum/go-ethereum/common"
	"github.com/ethereum/go-ethereum/crypto"
	nebulav1 "github.com/exchain/go-exchain/exchain/protocol/gen/go/nebula/v1"
	"github.com/golang/protobuf/proto"
)

type TxWrapper struct {
	tx   *nebulav1.Transaction
	hash common.Hash
}

func NewTxWrapper(tx *nebulav1.Transaction) *TxWrapper {
	return &TxWrapper{tx: tx}
}

func (t *TxWrapper) Hash() common.Hash {
	if t.hash == (common.Hash{}) {
		t.hash = t.calcHash()
	}
	return t.hash
}

func (t *TxWrapper) Clone() *nebulav1.Transaction {
	return proto.Clone(t.tx).(*nebulav1.Transaction)
}

func (t *TxWrapper) calcHash() common.Hash {
	ntx := t.Clone()
	ntx.Signature = nil

	data, _ := proto.Marshal(ntx)
	return crypto.Keccak256Hash(data)

}

func (t *TxWrapper) Bytes() ([]byte, error) {
	return proto.Marshal(t.tx)
}

func (t *TxWrapper) IsProtocolTx() bool {
	return t.tx.TxType == nebulav1.TxType_ProtocolTx
}
