import { DeployFunction } from 'hardhat-deploy/dist/types'

import { assertContractVariable, deploy } from '../src/deploy-utils'

const deployFn: DeployFunction = async (hre) => {
  const { deployer } = await hre.getNamedAccounts()

  await deploy({
    hre,
    name: 'Lib_AddressManager',
    contract: 'AddressManager',
    args: [],
    postDeployAction: async (contract) => {
      await assertContractVariable(contract, 'owner', deployer)
    },
  })
}

deployFn.tags = ['AddressManager', 'setup', 'l1']

export default deployFn
