// Code generated - DO NOT EDIT.
// This file is a generated binding and any manual changes will be lost.

package bindings

import (
	"encoding/json"

	"github.com/ethereum-optimism/optimism/op-bindings/solc"
)

const MIPSStorageLayoutJSON = "{\"storage\":[{\"astId\":1000,\"contract\":\"contracts/cannon/MIPS.sol:MIPS\",\"label\":\"oracle\",\"offset\":0,\"slot\":\"0\",\"type\":\"t_contract(IPreimageOracle)1001\"}],\"types\":{\"t_contract(IPreimageOracle)1001\":{\"encoding\":\"inplace\",\"label\":\"contract IPreimageOracle\",\"numberOfBytes\":\"20\"}}}"

var MIPSStorageLayout = new(solc.StorageLayout)

var MIPSDeployedBin = "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"

var MIPSDeployedSourceMap = "1025:22415:0:-:0;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;1423:45;;;:::i;:::-;;;;;;;;;;;;;;;;;;;1791:29;;;:::i;:::-;;;;;;;;;;;;;;;;;;;14376:4789;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;-1:-1:-1;14376:4789:0;;-1:-1:-1;14376:4789:0;-1:-1:-1;14376:4789:0;:::i;:::-;;;;;;;;;;;;;;;;1423:45;1458:10;1423:45;:::o;1791:29::-;;;;;;:::o;14376:4789::-;14454:7;14469:18;;:::i;:::-;14569:4;14562:5;14559:15;14549:2;;14630:1;14628;14621:11;14549:2;14666:4;14660:11;14673;14657:28;14647:2;;14731:1;14729;14722:11;14647:2;14779:3;14761:16;14758:25;14748:2;;14845:1;14843;14836:11;14748:2;14889:3;14875:12;14872:21;14862:2;;14954:1;14952;14945:11;14862:2;14971:370;;;15189:24;;15177:2;15173:13;;;15170:1;15166:21;15162:52;;;;15223:20;;15269:21;;;15315:18;;;15049:292::o;:::-;15357:16;15408:4;15441:18;15456:2;15453:1;15450;15441:18;:::i;:::-;15433:26;;;;15485:18;15500:2;15497:1;15494;15485:18;:::i;:::-;15477:26;;;;15533:17;15548:1;15545;15542;15533:17;:::i;:::-;15525:25;;;;15583:17;15598:1;15595;15592;15583:17;:::i;:::-;15575:25;;;;15621:17;15636:1;15633;15630;15621:17;:::i;:::-;15613:25;;;;15663:17;15678:1;15675;15672;15663:17;:::i;:::-;15655:25;;;;15701:17;15716:1;15713;15710;15701:17;:::i;:::-;15693:25;;;;15739:17;15754:1;15751;15748;15739:17;:::i;:::-;15731:25;;;;15779:17;15794:1;15791;15788;15779:17;:::i;:::-;15771:25;;;;15823:17;15838:1;15835;15832;15823:17;:::i;:::-;15815:25;;;;15865:17;15880:1;15877;15874;15865:17;:::i;:::-;15914:2;15907:10;;15897:21;;;;15857:25;;-1:-1:-1;15907:10:0;-1:-1:-1;15985:1:0;15970:77;15995:2;15992:1;15989:9;15970:77;;;16028:17;16043:1;16040;16037;16028:17;:::i;:::-;16020:25;;-1:-1:-1;16020:25:0;-1:-1:-1;16013:1:0;16006:9;15970:77;;;15974:14;;;16074:5;:12;;;16071:86;;;16137:13;:11;:13::i;:::-;16130:20;;;;;16071:86;16162:10;;;:15;;16176:1;16162:15;;;;;16231:8;;;;-1:-1:-1;;16223:20:0;;-1:-1:-1;16223:7:0;:20::i;:::-;16209:34;-1:-1:-1;16266:10:0;16274:2;16266:10;;;;16327:1;16317:11;;;:26;;;16332:6;:11;;16342:1;16332:11;16317:26;16313:308;;;16552:62;16563:6;:11;;16573:1;16563:11;:20;;16581:2;16563:20;;;16577:1;16563:20;16552:62;;16612:1;16585:23;16588:4;16593:10;16588:15;16605:2;16585;:23::i;:::-;:28;;;;16552:10;:62::i;:::-;16545:69;;;;;;;16313:308;16822:15;;;;16649:9;;;;16770:4;16764:2;16756:10;;;16755:19;;;16822:15;16847:2;16839:10;;;16838:19;16822:36;;;;;;;;;;;;-1:-1:-1;16879:5:0;16894:11;;;;;:29;;;16909:6;:14;;16919:4;16909:14;16894:29;16890:636;;;16966:5;:15;;;16982:5;16966:22;;;;;;;;;;;;;;-1:-1:-1;;17019:4:0;17013:2;17005:10;;;17004:19;16890:636;;;17049:4;17040:6;:13;;;17036:490;;;17140:6;:13;;17150:3;17140:13;:30;;;;17157:6;:13;;17167:3;17157:13;17140:30;:47;;;;17174:6;:13;;17184:3;17174:13;17140:47;17136:181;;;17226:4;17231:6;17226:11;17221:16;;17136:181;;;17289:19;17292:4;17297:6;17292:11;17305:2;17289;:19::i;:::-;17284:24;;17136:181;17036:490;;;17343:4;17333:6;:14;;;;:32;;;;17351:6;:14;;17361:4;17351:14;17333:32;:50;;;;17369:6;:14;;17379:4;17369:14;17333:50;17329:197;;;17433:5;:15;;;17449:5;17433:22;;;;;;;;;;;;;17428:27;;17514:5;17506:13;;17329:197;17547:1;17537:6;:11;;;;:25;;;;;17561:1;17552:6;:10;;;17537:25;17536:42;;;;17567:6;:11;;17577:1;17567:11;17536:42;17532:107;;;17595:37;17608:6;17616:4;17622:5;17629:2;17595:12;:37::i;:::-;17588:44;;;;;;;;;;;17532:107;17664:13;17645:16;17784:4;17774:14;;;;17770:328;;17833:19;17836:4;17841:6;17836:11;17849:2;17833;:19::i;:::-;17827:25;;;;17879:10;17874:15;;17903:16;17874:15;17917:1;17903:7;:16::i;:::-;17897:22;;17941:4;17931:6;:14;;;;:32;;;;;17949:6;:14;;17959:4;17949:14;;17931:32;17927:165;;;18004:4;17992:16;;18082:1;18074:9;;17927:165;17770:328;;18115:10;18128:26;18136:4;18142:2;18146;18150:3;18128:7;:26::i;:::-;18157:10;18128:39;;;;-1:-1:-1;18245:4:0;18238:11;;;18269;;;:24;;;;;18292:1;18284:4;:9;;;;18269:24;:39;;;;;18304:4;18297;:11;;;18269:39;18265:589;;;18322:4;:9;;18330:1;18322:9;:22;;;;18335:4;:9;;18343:1;18335:9;18322:22;18318:102;;;18374:37;18385:4;:9;;18393:1;18385:9;:21;;18401:5;18385:21;;;18397:1;18385:21;18408:2;18374:10;:37::i;:::-;18367:44;;;;;;;;;;;;;;;18318:102;18432:4;:11;;18440:3;18432:11;18428:79;;;18470:28;18479:5;18486:2;18490:7;;;;18470:8;:28::i;18428:79::-;18518:4;:11;;18526:3;18518:11;18514:79;;;18556:28;18565:5;18572:2;18576:7;;;;;18556:8;:28::i;18514:79::-;18643:4;:11;;18651:3;18643:11;18639:58;;;18673:15;:13;:15::i;18639:58::-;18770:4;18762;:12;;;;:27;;;;;18785:4;18778;:11;;;18762:27;18758:90;;;18808:31;18819:4;18825:2;18829;18833:5;18808:10;:31::i;18758:90::-;18898:6;:14;;18908:4;18898:14;:28;;;;-1:-1:-1;18916:10:0;;;;;18898:28;18894:75;;;18961:1;18936:5;:15;;;18952:5;18936:22;;;;;;;;;:26;;;;:22;;;;;;:26;18894:75;18999:9;:26;;19012:13;18999:26;18995:74;;19035:27;19044:9;19055:1;19058:3;19035:8;:27::i;:::-;19134:26;19143:5;19150:3;19155:4;19134:8;:26::i;:::-;19127:33;;;;;;;;;;;;;14376:4789;;;;;;;:::o;2085:1331::-;2126:11;2254:176;;;2346:2;2342:13;;;2332:24;;2326:31;2315:43;;2378:13;;2409;;;2305:125::o;:::-;2449:4;2488;2482:11;2526:5;2550:21;2568:2;2564;2558:4;2550:21;:::i;:::-;2538:33;;;;2601:21;2619:2;2615;2609:4;2601:21;:::i;:::-;2589:33;;;;2656:20;2674:1;2670:2;2664:4;2656:20;:::i;:::-;2644:32;;;;2713:20;2731:1;2727:2;2721:4;2713:20;:::i;:::-;2701:32;;;;2758:20;2776:1;2772:2;2766:4;2758:20;:::i;:::-;2746:32;;;;2807:20;2825:1;2821:2;2815:4;2807:20;:::i;:::-;2795:32;;;;2852:20;2870:1;2866:2;2860:4;2852:20;:::i;:::-;2840:32;;;;2897:20;2915:1;2911:2;2905:4;2897:20;:::i;:::-;2885:32;;;;2944:20;2962:1;2958:2;2952:4;2944:20;:::i;:::-;2932:32;;;;2995:20;3013:1;3009:2;3003:4;2995:20;:::i;:::-;2983:32;;;;3044:20;3062:1;3058:2;3052:4;3044:20;:::i;:::-;3097:2;3087:13;;;;-1:-1:-1;3032:32:0;-1:-1:-1;3145:1:0;3130:84;3155:2;3152:1;3149:9;3130:84;;;3192:20;3210:1;3206:2;3200:4;3192:20;:::i;:::-;3180:32;;-1:-1:-1;3180:32:0;-1:-1:-1;3173:1:0;3166:9;3130:84;;;3134:14;3245:1;3241:2;3234:13;3290:5;3286:2;3282:14;3275:5;3270:27;3375:14;;;3358:32;;;-1:-1:-1;;2085:1331:0;;:::o;11778:1270::-;11849:10;11867:14;11884:23;11896:10;11884:11;:23::i;:::-;11867:40;;11943:1;11937:4;11933:12;11930:2;;;11958:1;11955;11948:12;11930:2;12060;12048:15;;;12011:20;12070:169;;;;12109:12;;;12195:2;12188:13;;;;12228:2;12215:16;;;12099:140::o;:::-;12265:4;12262:1;12258:12;12289:4;12412:1;12397:273;12422:2;12419:1;12416:9;12397:273;;;12521:2;12509:15;;;12470:20;12544:12;;;12558:1;12540:20;12569:42;;;;12625:1;12620:42;;;;12533:129;;12569:42;12586:23;12601:7;12595:4;12586:23;:::i;:::-;12578:31;;12569:42;;12620;12637:23;12655:4;12646:7;12637:23;:::i;:::-;12629:31;;12533:129;-1:-1:-1;;12440:1:0;12433:9;12397:273;;;12401:14;12698:4;12692:11;12677:26;;12767:7;12761:4;12758:17;12748:2;;12824:10;12821:1;12814:21;12854:2;12851:1;12844:13;12748:2;-1:-1:-1;;12970:2:0;12960:13;;12948:10;12944:30;12941:1;12937:38;12993:16;13011:10;12989:33;;-1:-1:-1;;11778:1270:0;;;;:::o;1825:256::-;1884:6;1915:14;;;;1923:5;;;;1915:14;;;;;;1914:21;;;;;1927:1;1966:2;:6;;;1960:13;;;;;1959:19;;1958:28;;;;;;;2008:8;;2007:14;1914:21;2053;;2073:1;2053:21;;;2064:6;2053:21;2041:8;;;;;:34;;-1:-1:-1;;;1825:256:0;;;;:::o;10450:401::-;10517:7;10532:18;;:::i;:::-;-1:-1:-1;10613:8:0;;;10638:12;;;10627:23;;;;;;;10656:19;;;;;10582:4;;10685:12;;;10681:140;;10734:6;10741:1;10734:8;10707:5;:15;;;10723:7;10707:24;;;;;;;;;:35;;;;:24;;;;;;:35;10681:140;10833:13;:11;:13::i;:::-;10826:20;10450:401;-1:-1:-1;;;;;10450:401:0:o;8292:1063::-;8385:7;8400:18;;:::i;:::-;-1:-1:-1;8450:4:0;8465:17;8511:1;8501:11;;;;;:26;;;8516:6;:11;;8526:1;8516:11;8501:26;8497:514;;;8550:9;8562:5;:15;;;8578:5;8562:22;;;;;;;;;;;;;8550:34;;8614:2;8608:8;;:2;:8;;;:23;;;;;8620:6;:11;;8630:1;8620:11;8608:23;8607:54;;;;8643:2;8637:8;;:2;:8;;;;:23;;;;;8649:6;:11;;8659:1;8649:11;8637:23;8592:69;;8497:514;;;;8678:6;:11;;8688:1;8678:11;8674:337;;;8721:1;8714:2;8708:14;;;;8693:29;;8674:337;;;8747:6;:11;;8757:1;8747:11;8743:268;;;8789:1;8783:2;8777:13;;;8762:28;;8743:268;;;8815:6;:11;;8825:1;8815:11;8811:200;;;8881:4;8875:2;8867:10;;;8866:19;8898:8;8894:42;;8935:1;8929:2;8923:13;;;8908:28;;8894:42;8957:3;:8;;8964:1;8957:8;8953:43;;;8995:1;8988:2;8982:14;;;;8967:29;;8953:43;8811:200;;9033:8;;;;;9058:12;;;;9047:23;;;;;9108:216;;;;9184:1;9163:19;9166:4;9171:6;9166:11;9179:2;9163;:19::i;:::-;:22;;;;;;;9149:37;;9158:1;9149:37;9134:52;:12;;;:52;9108:216;;;9281:12;;;;;9296:1;9281:16;9266:31;;;;9108:216;9337:13;:11;:13::i;:::-;9330:20;8292:1063;-1:-1:-1;;;;;;;;8292:1063:0:o;19169:4269::-;19256:6;19286:10;19294:2;19286:10;;;;;;19329:11;;19425:4;19416:13;;19412:3986;;;19526:1;19516:6;:11;;;;:27;;;;;19540:3;19531:6;:12;;;19516:27;19512:462;;;19559:6;:11;;19569:1;19559:11;19555:383;;;-1:-1:-1;19581:4:0;19555:383;;;19621:6;:11;;19631:1;19621:11;19617:321;;;-1:-1:-1;19643:4:0;19617:321;;;19679:6;:13;;19689:3;19679:13;19675:263;;;-1:-1:-1;19703:4:0;19675:263;;;19736:6;:13;;19746:3;19736:13;19732:206;;;-1:-1:-1;19760:4:0;19732:206;;;19794:6;:13;;19804:3;19794:13;19790:148;;;-1:-1:-1;19818:4:0;19790:148;;;19851:6;:13;;19861:3;19851:13;19847:91;;;-1:-1:-1;19875:4:0;19847:91;;;19907:6;:13;;19917:3;19907:13;19903:35;;;-1:-1:-1;19931:4:0;19903:35;19964:1;19955:10;;19512:462;20015:11;;;20011:1701;;20067:4;20062:1;20054:9;;;20053:18;20092:4;20054:9;20085:11;;;20081:588;;;20122:4;20114;:12;;;20110:549;;20137:2;20130:9;;;;;;;20110:549;20217:12;;;20213:446;;20240:11;;;;;;;;-1:-1:-1;20233:18:0;;-1:-1:-1;;20233:18:0;20213:446;20286:4;:12;;20294:4;20286:12;20282:377;;;20309:11;;;;;;;;-1:-1:-1;20302:18:0;;-1:-1:-1;;20302:18:0;20282:377;20355:4;:12;;20363:4;20355:12;20351:308;;;20378:25;20387:5;20381:11;;:2;:11;;;;20397:5;20394:2;:8;20378:2;:25::i;20351:308::-;20438:4;:12;;20446:4;20438:12;20434:225;;;-1:-1:-1;;;;20461:15:0;;;20471:4;20468:7;;20461:15;20454:22;;20434:225;20515:4;:12;;20523:4;20515:12;20511:148;;;-1:-1:-1;;;;20538:15:0;;;20548:4;20545:7;;20538:15;20531:22;;20511:148;20592:4;:12;;20600:4;20592:12;20588:71;;;20615:19;20624:2;20618:8;;:2;:8;;;;20631:2;20628;:5;20615:2;:19::i;20588:71::-;20757:4;:12;;20765:4;20757:12;:28;;;;20773:4;:12;;20781:4;20773:12;20757:28;20753:602;;;20799:2;20796;:5;20789:12;;;;;;;20753:602;20839:4;:12;;20847:4;20839:12;:28;;;;20855:4;:12;;20863:4;20855:12;20839:28;20835:520;;;20881:2;20878;:5;20871:12;;;;;;;20835:520;20921:4;:12;;20929:4;20921:12;20917:438;;;20947:2;20944;:5;20937:12;;;;;;;20917:438;20988:4;:12;;20996:4;20988:12;20984:371;;;21015:2;21012;:5;21004:14;;;;;;;20984:371;21054:4;:12;;21062:4;21054:12;21050:305;;;21081:2;21078;:5;21070:14;;;;;;;21050:305;21121:4;:12;;21129:4;21121:12;21117:238;;;-1:-1:-1;;;;21146:5:0;;;21144:8;21137:15;;21117:238;21188:4;:12;;21196:4;21188:12;21184:171;;;21237:2;21221:19;;21227:2;21221:19;;;:27;;21247:1;21221:27;;;21243:1;21221:27;21214:34;;;;;;;;;21184:171;21276:4;:12;;21284:4;21276:12;21272:83;;;21312:2;21309:5;;:2;:5;;;:13;;21321:1;21309:13;;21272:83;20011:1701;;;;21373:6;:13;;21383:3;21373:13;21369:343;;;21401:2;21397;:6;;;;21390:13;;;;;;21369:343;21429:6;:14;;21439:4;21429:14;21425:287;;;21472:4;:9;;21480:1;21472:9;21468:49;;;-1:-1:-1;;;21497:19:0;;;21483:34;;21468:49;21538:4;:12;;21546:4;21538:12;:28;;;;21554:4;:12;;21562:4;21554:12;21538:28;21534:170;;;21591:4;:12;;21599:4;21591:12;21587:26;;;21610:3;;;21587:26;21625:8;21639:45;21649:10;21646:13;;:18;21639:45;;21673:8;21668:3;21673:8;;;;;21668:3;21639:45;;;21692:1;-1:-1:-1;21685:8:0;;-1:-1:-1;;21685:8:0;21534:170;19412:3986;;;21737:4;21728:6;:13;;;21724:1674;;;21755:6;:14;;21765:4;21755:14;21751:776;;;21795:36;21811:2;21814:1;21811:4;21817:1;21810:8;21807:2;:11;21799:20;;:3;:20;;;;21823:4;21798:29;21829:1;21795:2;:36::i;:::-;21788:43;;;;;;21751:776;21850:6;:14;;21860:4;21850:14;21846:681;;;21890:39;21906:2;21909:1;21906:4;21912:1;21905:8;21902:2;:11;21894:20;;:3;:20;;;;21918:6;21893:31;21926:2;21890;:39::i;21846:681::-;21948:6;:14;;21958:4;21948:14;21944:583;;;-1:-1:-1;;;21995:17:0;22010:1;22007;22004:4;;22003:8;21995:17;;22036:32;;;22091:5;22086:10;;21995:17;;;;;22085:18;22078:25;;21944:583;22122:6;:14;;22132:4;22122:14;22118:409;;;22147:3;22140:10;;;;;;22118:409;22177:6;:14;;22187:4;22177:14;22173:354;;;22231:2;22234:1;22231:4;22237:1;22230:8;22227:2;:11;22219:20;;:3;:20;;;;22243:4;22218:29;22211:36;;;;;;22173:354;22266:6;:14;;22276:4;22266:14;22262:265;;;22320:2;22323:1;22320:4;22326:1;22319:8;22316:2;:11;22308:20;;:3;:20;;;;22332:6;22307:31;22300:38;;;;;;22262:265;22357:6;:14;;22367:4;22357:14;22353:174;;;-1:-1:-1;;;22404:20:0;22422:1;22419;22416:4;;22415:8;22412:2;:11;22404:20;;22448:35;;;22506:5;22501:10;;22404:20;;;;;22500:18;22493:25;;21724:1674;22543:6;:14;;22553:4;22543:14;22539:859;;;-1:-1:-1;;;22590:4:0;22586:26;22610:1;22607;22604:4;;22603:8;22600:2;:11;22586:26;;22654:21;;;22634:42;;;22692:10;;22587:7;;;22586:26;;22691:18;22684:25;;22539:859;22726:6;:14;;22736:4;22726:14;22722:676;;;-1:-1:-1;;;22773:6:0;22769:28;22795:1;22792;22789:4;;22788:8;22785:2;:11;22769:28;;22839:23;;;22819:44;;;22879:10;;22770:9;;;22769:28;;22878:18;22871:25;;22722:676;22913:6;:14;;22923:4;22913:14;22909:489;;;-1:-1:-1;;;22958:16:0;22972:1;22969;22966:4;;22965:8;22958:16;;22996:32;;;23050:5;23044:11;;22958:16;;;;;23043:19;23036:26;;22909:489;23079:6;:14;;23089:4;23079:14;23075:323;;;23116:2;23109:9;;;;;;23075:323;23135:6;:14;;23145:4;23135:14;23131:267;;;-1:-1:-1;;;23180:19:0;23197:1;23194;23191:4;;23190:8;23187:2;:11;23180:19;;23221:35;;;23278:5;23272:11;;23180:19;;;;;23271;23264:26;;23131:267;23307:6;:14;;23317:4;23307:14;23303:95;;;23332:3;23325:10;;;;;;23303:95;23358:6;:14;;23368:4;23358:14;23354:44;;;23383:2;23376:9;;;;;;23354:44;23404:29;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;10855:455;10938:7;10953:18;;:::i;:::-;-1:-1:-1;11003:4:0;11037:2;11026:13;;;;11018:40;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;11136:13;;;;;;;:28;;;11153:11;11136:28;11132:80;;;11202:3;11174:5;:15;;;11190:8;11174:25;;;;;;;;;:31;;;;:25;;;;;;:31;11132:80;11229:12;;;;;11218:23;;;;:8;;;:23;11277:1;11262:16;;;11247:31;;;11292:13;:11;:13::i;3420:4868::-;3463:7;3478:18;;:::i;:::-;-1:-1:-1;3563:15:0;;:18;;;;3528:4;3638:18;;;;3674;;;;3710;;;;;3528:4;;3543:17;;;;3638:18;3674;3739;;;3753:4;3739:18;3735:4396;;;3793:2;3810:4;3807:7;;:12;3803:98;;3887:4;3884:7;;3876:4;:16;3870:22;3803:98;3912:7;;;3908:105;;3936:10;;;;;3956:16;;;;;;;;3936:10;-1:-1:-1;3908:105:0;;;4002:2;3997:7;;3908:105;3735:4396;;;;4029:10;:18;;4043:4;4029:18;4025:4106;;;1458:10;4070:14;;4025:4106;;;4101:10;:18;;4115:4;4101:18;4097:4034;;;4165:1;4160:6;;4097:4034;;;4183:10;:18;;4197:4;4183:18;4179:3952;;;4246:4;4231:12;;;:19;4258:26;;;:14;;;:26;4299:13;:11;:13::i;:::-;4292:20;;;;;;;;;;;4179:3952;4329:10;:18;;4343:4;4329:18;4325:3806;;;4458:14;;;4454:1789;;;;;4549:22;;;1679:1;4549:22;4545:1698;;;4670:10;4683:27;4691:2;4696:10;4691:15;4708:1;4683:7;:27::i;:::-;4761:11;4792:6;;4812:17;;;;4831:20;;;;;4792:60;;;;;;;;;;;;;;;;;;;;4670:40;;-1:-1:-1;4761:11:0;;;;4792:6;;;;;:19;;:60;;;;;;;;;;;:6;:60;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;-1:-1:-1;4792:60:0;;;;;;;;;-1:-1:-1;4792:60:0;-1:-1:-1;4965:1:0;4957:10;;5045:1;5041:17;;;5106;;;5103:2;;;5136:5;5126:15;;5103:2;;5205:6;5201:2;5198:14;5195:2;;;5225;5215:12;;5195:2;5317:3;5312:1;5304:6;5300:14;5295:3;5291:24;5287:34;5280:41;;5403:3;5399:1;5387:9;5378:6;5375:1;5371:14;5367:30;5363:38;5359:48;5352:55;;5513:1;5509;5505;5493:9;5490:1;5486:17;5482:25;5478:33;5474:41;5626:1;5622;5618;5609:6;5597:9;5594:1;5590:17;5586:30;5582:38;5578:46;5574:54;5556:72;;5712:10;5708:15;5702:4;5698:26;5690:34;;5814:3;5806:4;5802:9;5797:3;5793:19;5790:28;5783:35;;;;5894:33;5903:2;5908:10;5903:15;5920:1;5923:3;5894:8;:33::i;:::-;5937:20;;;:38;;;;;;;;;-1:-1:-1;4545:1698:0;;-1:-1:-1;;4545:1698:0;;6023:18;;;1602:1;6023:18;6019:224;;;6172:2;6167:7;;6019:224;;;6204:10;6199:15;;1750:3;6224:10;;6019:224;4325:3806;;;6259:10;:18;;6273:4;6259:18;6255:1876;;;6392:15;;;1533:1;6392:15;;:34;;-1:-1:-1;6411:15:0;;;1566:1;6411:15;6392:34;:57;;;-1:-1:-1;6430:19:0;;;1639:1;6430:19;6392:57;6388:1172;;;6466:2;6461:7;;6388:1172;;;6530:23;;;1720:1;6530:23;6526:1034;;;6585:10;6598:27;6606:2;6611:10;6606:15;6623:1;6598:7;:27::i;:::-;6689:17;;;;6585:40;;-1:-1:-1;6819:1:0;6811:10;;6899:1;6895:17;6960:13;;;6957:2;;;6982:5;6976:11;;6957:2;7226:14;;;7060:1;7222:22;;;7218:32;;;;7129:26;7153:1;7052:10;;;7133:18;;;7129:26;7214:43;7048:20;;7308:12;7358:17;;;:23;7414:1;7391:20;;;:24;7056:2;-1:-1:-1;7056:2:0;6526:1034;;6255:1876;7576:10;:18;;7590:4;7576:18;7572:559;;;7650:2;:7;;7656:1;7650:7;7646:479;;;7711:14;;;;;:40;;-1:-1:-1;7729:22:0;;;1679:1;7729:22;7711:40;:62;;;-1:-1:-1;7755:18:0;;;1602:1;7755:18;7711:62;7707:312;;;7792:1;7787:6;;7707:312;;;7826:15;;;1533:1;7826:15;;:34;;-1:-1:-1;7845:15:0;;;1566:1;7845:15;7826:34;:61;;;-1:-1:-1;7864:23:0;;;1720:1;7864:23;7826:61;:84;;;-1:-1:-1;7891:19:0;;;1639:1;7891:19;7826:84;7822:197;;;7929:1;7924:6;;7822:197;;7646:479;8048:10;8043:15;;1782:4;8068:11;;7646:479;8137:15;;;;;:23;;;;:18;;;;:23;;;;8166:15;;:23;;;:18;;;;:23;-1:-1:-1;8207:12:0;;;;8196:23;;;:8;;;:23;8255:1;8240:16;8225:31;;;;;8270:13;:11;:13::i;:::-;8263:20;;;;;;;;;3420:4868;:::o;9359:1087::-;9449:7;9464:18;;:::i;:::-;-1:-1:-1;9514:4:0;9529:10;9557:4;9549:12;;;;9545:732;;;-1:-1:-1;9569:8:0;;;;9545:732;;;9600:4;:12;;9608:4;9600:12;9596:681;;;9614:13;;;:8;;;:13;9596:681;;;9650:4;:12;;9658:4;9650:12;9646:631;;;-1:-1:-1;9670:8:0;;;;9646:631;;;9701:4;:12;;9709:4;9701:12;9697:580;;;9715:13;;;:8;;;:13;9697:580;;;9751:4;:12;;9759:4;9751:12;9747:530;;;9861:7;9818:16;9801;;;9818;;;;9801:33;9866:2;9861:7;;;;;9843:8;;;:26;9877:22;:8;;;:22;9747:530;;;9916:4;:12;;9924:4;9916:12;9912:365;;;9978:10;9967;;;9978;;;9967:21;10020:2;10015:7;;;;;9997:8;;;:26;10031:22;:8;;;:22;9912:365;;;10070:4;:12;;10078:4;10070:12;10066:211;;;10133:2;10117:19;;10123:2;10117:19;;;;;;;;10099:38;;:8;;;:38;10163:19;;;;;;;;;;;;;;10145:38;;:8;;;:38;10066:211;;;10200:4;:12;;10208:4;10200:12;10196:81;;;10244:2;10241:5;;:2;:5;;;;;;;;10230:16;;;;:8;;;:16;10265:5;;;;;;;;;;;;10254:16;;:8;;;:16;10196:81;10287:13;;;;10283:65;;10338:3;10310:5;:15;;;10326:8;10310:25;;;;;;;;;:31;;;;:25;;;;;;:31;10283:65;10365:12;;;;;10354:23;;;;:8;;;:23;10413:1;10398:16;;;10383:31;;;10428:13;:11;:13::i;:::-;10421:20;9359:1087;-1:-1:-1;;;;;;;9359:1087:0:o;13171:1145::-;13254:14;13271:23;13283:10;13271:11;:23::i;:::-;13254:40;;13330:1;13324:4;13320:12;13317:2;;;13345:1;13342;13335:12;13317:2;13453;13616:15;;;13471:2;13461:13;;13449:10;13445:30;13442:1;13438:38;13581:17;;;13398:20;;13566:10;13555:22;;;13551:27;13541:38;13538:61;13833:4;13830:1;13826:12;13980:1;13965:273;13990:2;13987:1;13984:9;13965:273;;;14089:2;14077:15;;;14038:20;14112:12;;;14126:1;14108:20;14137:42;;;;14193:1;14188:42;;;;14101:129;;14137:42;14154:23;14169:7;14163:4;14154:23;:::i;:::-;14146:31;;14137:42;;14188;14205:23;14223:4;14214:7;14205:23;:::i;:::-;14197:31;;14101:129;-1:-1:-1;;14008:1:0;14001:9;13965:273;;;-1:-1:-1;;14252:4:0;14245:18;-1:-1:-1;;;;13309:1003:0:o;11314:460::-;11589:19;;;11612:5;11589:29;11582:3;:37;;;11660:14;;11695;;11689:21;;;11681:69;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;11756:13;11314:460;;;:::o;-1:-1:-1:-;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;:::i;:::-;;;;:::o;:::-;;;;;;;;;;;;;;;;;;;;;;;;:::o"

func init() {
	if err := json.Unmarshal([]byte(MIPSStorageLayoutJSON), MIPSStorageLayout); err != nil {
		panic(err)
	}

	layouts["MIPS"] = MIPSStorageLayout
	deployedBytecodes["MIPS"] = MIPSDeployedBin
}
