// Code generated - DO NOT EDIT.
// This file is a generated binding and any manual changes will be lost.

package bindingspreview

import (
	"errors"
	"math/big"
	"strings"

	ethereum "github.com/ethereum/go-ethereum"
	"github.com/ethereum/go-ethereum/accounts/abi"
	"github.com/ethereum/go-ethereum/accounts/abi/bind"
	"github.com/ethereum/go-ethereum/common"
	"github.com/ethereum/go-ethereum/core/types"
	"github.com/ethereum/go-ethereum/event"
)

// Reference imports to suppress errors if they are not otherwise used.
var (
	_ = errors.New
	_ = big.NewInt
	_ = strings.NewReader
	_ = ethereum.NotFound
	_ = bind.Bind
	_ = common.Big1
	_ = types.BloomLookup
	_ = event.NewSubscription
)

// TypesOutputRootProof is an auto generated low-level Go binding around an user-defined struct.
type TypesOutputRootProof struct {
	Version                  [32]byte
	StateRoot                [32]byte
	MessagePasserStorageRoot [32]byte
	LatestBlockhash          [32]byte
}

// TypesWithdrawalTransaction is an auto generated low-level Go binding around an user-defined struct.
type TypesWithdrawalTransaction struct {
	Nonce    *big.Int
	Sender   common.Address
	Target   common.Address
	Value    *big.Int
	GasLimit *big.Int
	Data     []byte
}

// OptimismPortal2MetaData contains all meta data concerning the OptimismPortal2 contract.
var OptimismPortal2MetaData = &bind.MetaData{
	ABI: "[{\"type\":\"constructor\",\"inputs\":[{\"name\":\"_proofMaturityDelaySeconds\",\"type\":\"uint256\",\"internalType\":\"uint256\"},{\"name\":\"_disputeGameFinalityDelaySeconds\",\"type\":\"uint256\",\"internalType\":\"uint256\"},{\"name\":\"_initialRespectedGameType\",\"type\":\"uint32\",\"internalType\":\"GameType\"}],\"stateMutability\":\"nonpayable\"},{\"type\":\"receive\",\"stateMutability\":\"payable\"},{\"type\":\"function\",\"name\":\"blacklistDisputeGame\",\"inputs\":[{\"name\":\"_disputeGame\",\"type\":\"address\",\"internalType\":\"contractIDisputeGame\"}],\"outputs\":[],\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"checkWithdrawal\",\"inputs\":[{\"name\":\"_withdrawalHash\",\"type\":\"bytes32\",\"internalType\":\"bytes32\"},{\"name\":\"_proofSubmitter\",\"type\":\"address\",\"internalType\":\"address\"}],\"outputs\":[],\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"depositTransaction\",\"inputs\":[{\"name\":\"_to\",\"type\":\"address\",\"internalType\":\"address\"},{\"name\":\"_value\",\"type\":\"uint256\",\"internalType\":\"uint256\"},{\"name\":\"_gasLimit\",\"type\":\"uint64\",\"internalType\":\"uint64\"},{\"name\":\"_isCreation\",\"type\":\"bool\",\"internalType\":\"bool\"},{\"name\":\"_data\",\"type\":\"bytes\",\"internalType\":\"bytes\"}],\"outputs\":[],\"stateMutability\":\"payable\"},{\"type\":\"function\",\"name\":\"disputeGameBlacklist\",\"inputs\":[{\"name\":\"\",\"type\":\"address\",\"internalType\":\"contractIDisputeGame\"}],\"outputs\":[{\"name\":\"\",\"type\":\"bool\",\"internalType\":\"bool\"}],\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"disputeGameFactory\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"address\",\"internalType\":\"contractDisputeGameFactory\"}],\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"disputeGameFinalityDelaySeconds\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"uint256\",\"internalType\":\"uint256\"}],\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"donateETH\",\"inputs\":[],\"outputs\":[],\"stateMutability\":\"payable\"},{\"type\":\"function\",\"name\":\"finalizeWithdrawalTransaction\",\"inputs\":[{\"name\":\"_tx\",\"type\":\"tuple\",\"internalType\":\"structTypes.WithdrawalTransaction\",\"components\":[{\"name\":\"nonce\",\"type\":\"uint256\",\"internalType\":\"uint256\"},{\"name\":\"sender\",\"type\":\"address\",\"internalType\":\"address\"},{\"name\":\"target\",\"type\":\"address\",\"internalType\":\"address\"},{\"name\":\"value\",\"type\":\"uint256\",\"internalType\":\"uint256\"},{\"name\":\"gasLimit\",\"type\":\"uint256\",\"internalType\":\"uint256\"},{\"name\":\"data\",\"type\":\"bytes\",\"internalType\":\"bytes\"}]}],\"outputs\":[],\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"finalizeWithdrawalTransactionExternalProof\",\"inputs\":[{\"name\":\"_tx\",\"type\":\"tuple\",\"internalType\":\"structTypes.WithdrawalTransaction\",\"components\":[{\"name\":\"nonce\",\"type\":\"uint256\",\"internalType\":\"uint256\"},{\"name\":\"sender\",\"type\":\"address\",\"internalType\":\"address\"},{\"name\":\"target\",\"type\":\"address\",\"internalType\":\"address\"},{\"name\":\"value\",\"type\":\"uint256\",\"internalType\":\"uint256\"},{\"name\":\"gasLimit\",\"type\":\"uint256\",\"internalType\":\"uint256\"},{\"name\":\"data\",\"type\":\"bytes\",\"internalType\":\"bytes\"}]},{\"name\":\"_proofSubmitter\",\"type\":\"address\",\"internalType\":\"address\"}],\"outputs\":[],\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"finalizedWithdrawals\",\"inputs\":[{\"name\":\"\",\"type\":\"bytes32\",\"internalType\":\"bytes32\"}],\"outputs\":[{\"name\":\"\",\"type\":\"bool\",\"internalType\":\"bool\"}],\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"guardian\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"address\",\"internalType\":\"address\"}],\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"initialize\",\"inputs\":[{\"name\":\"_disputeGameFactory\",\"type\":\"address\",\"internalType\":\"contractDisputeGameFactory\"},{\"name\":\"_systemConfig\",\"type\":\"address\",\"internalType\":\"contractSystemConfig\"},{\"name\":\"_superchainConfig\",\"type\":\"address\",\"internalType\":\"contractSuperchainConfig\"}],\"outputs\":[],\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"l2Sender\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"address\",\"internalType\":\"address\"}],\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"minimumGasLimit\",\"inputs\":[{\"name\":\"_byteCount\",\"type\":\"uint64\",\"internalType\":\"uint64\"}],\"outputs\":[{\"name\":\"\",\"type\":\"uint64\",\"internalType\":\"uint64\"}],\"stateMutability\":\"pure\"},{\"type\":\"function\",\"name\":\"numProofSubmitters\",\"inputs\":[{\"name\":\"_withdrawalHash\",\"type\":\"bytes32\",\"internalType\":\"bytes32\"}],\"outputs\":[{\"name\":\"\",\"type\":\"uint256\",\"internalType\":\"uint256\"}],\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"params\",\"inputs\":[],\"outputs\":[{\"name\":\"prevBaseFee\",\"type\":\"uint128\",\"internalType\":\"uint128\"},{\"name\":\"prevBoughtGas\",\"type\":\"uint64\",\"internalType\":\"uint64\"},{\"name\":\"prevBlockNum\",\"type\":\"uint64\",\"internalType\":\"uint64\"}],\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"paused\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"bool\",\"internalType\":\"bool\"}],\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"proofMaturityDelaySeconds\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"uint256\",\"internalType\":\"uint256\"}],\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"proofSubmitters\",\"inputs\":[{\"name\":\"\",\"type\":\"bytes32\",\"internalType\":\"bytes32\"},{\"name\":\"\",\"type\":\"uint256\",\"internalType\":\"uint256\"}],\"outputs\":[{\"name\":\"\",\"type\":\"address\",\"internalType\":\"address\"}],\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"proveWithdrawalTransaction\",\"inputs\":[{\"name\":\"_tx\",\"type\":\"tuple\",\"internalType\":\"structTypes.WithdrawalTransaction\",\"components\":[{\"name\":\"nonce\",\"type\":\"uint256\",\"internalType\":\"uint256\"},{\"name\":\"sender\",\"type\":\"address\",\"internalType\":\"address\"},{\"name\":\"target\",\"type\":\"address\",\"internalType\":\"address\"},{\"name\":\"value\",\"type\":\"uint256\",\"internalType\":\"uint256\"},{\"name\":\"gasLimit\",\"type\":\"uint256\",\"internalType\":\"uint256\"},{\"name\":\"data\",\"type\":\"bytes\",\"internalType\":\"bytes\"}]},{\"name\":\"_disputeGameIndex\",\"type\":\"uint256\",\"internalType\":\"uint256\"},{\"name\":\"_outputRootProof\",\"type\":\"tuple\",\"internalType\":\"structTypes.OutputRootProof\",\"components\":[{\"name\":\"version\",\"type\":\"bytes32\",\"internalType\":\"bytes32\"},{\"name\":\"stateRoot\",\"type\":\"bytes32\",\"internalType\":\"bytes32\"},{\"name\":\"messagePasserStorageRoot\",\"type\":\"bytes32\",\"internalType\":\"bytes32\"},{\"name\":\"latestBlockhash\",\"type\":\"bytes32\",\"internalType\":\"bytes32\"}]},{\"name\":\"_withdrawalProof\",\"type\":\"bytes[]\",\"internalType\":\"bytes[]\"}],\"outputs\":[],\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"provenWithdrawals\",\"inputs\":[{\"name\":\"\",\"type\":\"bytes32\",\"internalType\":\"bytes32\"},{\"name\":\"\",\"type\":\"address\",\"internalType\":\"address\"}],\"outputs\":[{\"name\":\"disputeGameProxy\",\"type\":\"address\",\"internalType\":\"contractIDisputeGame\"},{\"name\":\"timestamp\",\"type\":\"uint64\",\"internalType\":\"uint64\"}],\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"respectedGameType\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"uint32\",\"internalType\":\"GameType\"}],\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"respectedGameTypeUpdatedAt\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"uint64\",\"internalType\":\"uint64\"}],\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"setRespectedGameType\",\"inputs\":[{\"name\":\"_gameType\",\"type\":\"uint32\",\"internalType\":\"GameType\"}],\"outputs\":[],\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"superchainConfig\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"address\",\"internalType\":\"contractSuperchainConfig\"}],\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"systemConfig\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"address\",\"internalType\":\"contractSystemConfig\"}],\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"version\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"string\",\"internalType\":\"string\"}],\"stateMutability\":\"view\"},{\"type\":\"event\",\"name\":\"Initialized\",\"inputs\":[{\"name\":\"version\",\"type\":\"uint8\",\"indexed\":false,\"internalType\":\"uint8\"}],\"anonymous\":false},{\"type\":\"event\",\"name\":\"TransactionDeposited\",\"inputs\":[{\"name\":\"from\",\"type\":\"address\",\"indexed\":true,\"internalType\":\"address\"},{\"name\":\"to\",\"type\":\"address\",\"indexed\":true,\"internalType\":\"address\"},{\"name\":\"version\",\"type\":\"uint256\",\"indexed\":true,\"internalType\":\"uint256\"},{\"name\":\"opaqueData\",\"type\":\"bytes\",\"indexed\":false,\"internalType\":\"bytes\"}],\"anonymous\":false},{\"type\":\"event\",\"name\":\"WithdrawalFinalized\",\"inputs\":[{\"name\":\"withdrawalHash\",\"type\":\"bytes32\",\"indexed\":true,\"internalType\":\"bytes32\"},{\"name\":\"success\",\"type\":\"bool\",\"indexed\":false,\"internalType\":\"bool\"}],\"anonymous\":false},{\"type\":\"event\",\"name\":\"WithdrawalProven\",\"inputs\":[{\"name\":\"withdrawalHash\",\"type\":\"bytes32\",\"indexed\":true,\"internalType\":\"bytes32\"},{\"name\":\"from\",\"type\":\"address\",\"indexed\":true,\"internalType\":\"address\"},{\"name\":\"to\",\"type\":\"address\",\"indexed\":true,\"internalType\":\"address\"}],\"anonymous\":false},{\"type\":\"error\",\"name\":\"BadTarget\",\"inputs\":[]},{\"type\":\"error\",\"name\":\"CallPaused\",\"inputs\":[]},{\"type\":\"error\",\"name\":\"GasEstimation\",\"inputs\":[]},{\"type\":\"error\",\"name\":\"LargeCalldata\",\"inputs\":[]},{\"type\":\"error\",\"name\":\"OutOfGas\",\"inputs\":[]},{\"type\":\"error\",\"name\":\"SmallGasLimit\",\"inputs\":[]},{\"type\":\"error\",\"name\":\"Unauthorized\",\"inputs\":[]}]",
	Bin: "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",
}

// OptimismPortal2ABI is the input ABI used to generate the binding from.
// Deprecated: Use OptimismPortal2MetaData.ABI instead.
var OptimismPortal2ABI = OptimismPortal2MetaData.ABI

// OptimismPortal2Bin is the compiled bytecode used for deploying new contracts.
// Deprecated: Use OptimismPortal2MetaData.Bin instead.
var OptimismPortal2Bin = OptimismPortal2MetaData.Bin

// DeployOptimismPortal2 deploys a new Ethereum contract, binding an instance of OptimismPortal2 to it.
func DeployOptimismPortal2(auth *bind.TransactOpts, backend bind.ContractBackend, _proofMaturityDelaySeconds *big.Int, _disputeGameFinalityDelaySeconds *big.Int, _initialRespectedGameType uint32) (common.Address, *types.Transaction, *OptimismPortal2, error) {
	parsed, err := OptimismPortal2MetaData.GetAbi()
	if err != nil {
		return common.Address{}, nil, nil, err
	}
	if parsed == nil {
		return common.Address{}, nil, nil, errors.New("GetABI returned nil")
	}

	address, tx, contract, err := bind.DeployContract(auth, *parsed, common.FromHex(OptimismPortal2Bin), backend, _proofMaturityDelaySeconds, _disputeGameFinalityDelaySeconds, _initialRespectedGameType)
	if err != nil {
		return common.Address{}, nil, nil, err
	}
	return address, tx, &OptimismPortal2{OptimismPortal2Caller: OptimismPortal2Caller{contract: contract}, OptimismPortal2Transactor: OptimismPortal2Transactor{contract: contract}, OptimismPortal2Filterer: OptimismPortal2Filterer{contract: contract}}, nil
}

// OptimismPortal2 is an auto generated Go binding around an Ethereum contract.
type OptimismPortal2 struct {
	OptimismPortal2Caller     // Read-only binding to the contract
	OptimismPortal2Transactor // Write-only binding to the contract
	OptimismPortal2Filterer   // Log filterer for contract events
}

// OptimismPortal2Caller is an auto generated read-only Go binding around an Ethereum contract.
type OptimismPortal2Caller struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// OptimismPortal2Transactor is an auto generated write-only Go binding around an Ethereum contract.
type OptimismPortal2Transactor struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// OptimismPortal2Filterer is an auto generated log filtering Go binding around an Ethereum contract events.
type OptimismPortal2Filterer struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// OptimismPortal2Session is an auto generated Go binding around an Ethereum contract,
// with pre-set call and transact options.
type OptimismPortal2Session struct {
	Contract     *OptimismPortal2  // Generic contract binding to set the session for
	CallOpts     bind.CallOpts     // Call options to use throughout this session
	TransactOpts bind.TransactOpts // Transaction auth options to use throughout this session
}

// OptimismPortal2CallerSession is an auto generated read-only Go binding around an Ethereum contract,
// with pre-set call options.
type OptimismPortal2CallerSession struct {
	Contract *OptimismPortal2Caller // Generic contract caller binding to set the session for
	CallOpts bind.CallOpts          // Call options to use throughout this session
}

// OptimismPortal2TransactorSession is an auto generated write-only Go binding around an Ethereum contract,
// with pre-set transact options.
type OptimismPortal2TransactorSession struct {
	Contract     *OptimismPortal2Transactor // Generic contract transactor binding to set the session for
	TransactOpts bind.TransactOpts          // Transaction auth options to use throughout this session
}

// OptimismPortal2Raw is an auto generated low-level Go binding around an Ethereum contract.
type OptimismPortal2Raw struct {
	Contract *OptimismPortal2 // Generic contract binding to access the raw methods on
}

// OptimismPortal2CallerRaw is an auto generated low-level read-only Go binding around an Ethereum contract.
type OptimismPortal2CallerRaw struct {
	Contract *OptimismPortal2Caller // Generic read-only contract binding to access the raw methods on
}

// OptimismPortal2TransactorRaw is an auto generated low-level write-only Go binding around an Ethereum contract.
type OptimismPortal2TransactorRaw struct {
	Contract *OptimismPortal2Transactor // Generic write-only contract binding to access the raw methods on
}

// NewOptimismPortal2 creates a new instance of OptimismPortal2, bound to a specific deployed contract.
func NewOptimismPortal2(address common.Address, backend bind.ContractBackend) (*OptimismPortal2, error) {
	contract, err := bindOptimismPortal2(address, backend, backend, backend)
	if err != nil {
		return nil, err
	}
	return &OptimismPortal2{OptimismPortal2Caller: OptimismPortal2Caller{contract: contract}, OptimismPortal2Transactor: OptimismPortal2Transactor{contract: contract}, OptimismPortal2Filterer: OptimismPortal2Filterer{contract: contract}}, nil
}

// NewOptimismPortal2Caller creates a new read-only instance of OptimismPortal2, bound to a specific deployed contract.
func NewOptimismPortal2Caller(address common.Address, caller bind.ContractCaller) (*OptimismPortal2Caller, error) {
	contract, err := bindOptimismPortal2(address, caller, nil, nil)
	if err != nil {
		return nil, err
	}
	return &OptimismPortal2Caller{contract: contract}, nil
}

// NewOptimismPortal2Transactor creates a new write-only instance of OptimismPortal2, bound to a specific deployed contract.
func NewOptimismPortal2Transactor(address common.Address, transactor bind.ContractTransactor) (*OptimismPortal2Transactor, error) {
	contract, err := bindOptimismPortal2(address, nil, transactor, nil)
	if err != nil {
		return nil, err
	}
	return &OptimismPortal2Transactor{contract: contract}, nil
}

// NewOptimismPortal2Filterer creates a new log filterer instance of OptimismPortal2, bound to a specific deployed contract.
func NewOptimismPortal2Filterer(address common.Address, filterer bind.ContractFilterer) (*OptimismPortal2Filterer, error) {
	contract, err := bindOptimismPortal2(address, nil, nil, filterer)
	if err != nil {
		return nil, err
	}
	return &OptimismPortal2Filterer{contract: contract}, nil
}

// bindOptimismPortal2 binds a generic wrapper to an already deployed contract.
func bindOptimismPortal2(address common.Address, caller bind.ContractCaller, transactor bind.ContractTransactor, filterer bind.ContractFilterer) (*bind.BoundContract, error) {
	parsed, err := abi.JSON(strings.NewReader(OptimismPortal2ABI))
	if err != nil {
		return nil, err
	}
	return bind.NewBoundContract(address, parsed, caller, transactor, filterer), nil
}

// Call invokes the (constant) contract method with params as input values and
// sets the output to result. The result type might be a single field for simple
// returns, a slice of interfaces for anonymous returns and a struct for named
// returns.
func (_OptimismPortal2 *OptimismPortal2Raw) Call(opts *bind.CallOpts, result *[]interface{}, method string, params ...interface{}) error {
	return _OptimismPortal2.Contract.OptimismPortal2Caller.contract.Call(opts, result, method, params...)
}

// Transfer initiates a plain transaction to move funds to the contract, calling
// its default method if one is available.
func (_OptimismPortal2 *OptimismPortal2Raw) Transfer(opts *bind.TransactOpts) (*types.Transaction, error) {
	return _OptimismPortal2.Contract.OptimismPortal2Transactor.contract.Transfer(opts)
}

// Transact invokes the (paid) contract method with params as input values.
func (_OptimismPortal2 *OptimismPortal2Raw) Transact(opts *bind.TransactOpts, method string, params ...interface{}) (*types.Transaction, error) {
	return _OptimismPortal2.Contract.OptimismPortal2Transactor.contract.Transact(opts, method, params...)
}

// Call invokes the (constant) contract method with params as input values and
// sets the output to result. The result type might be a single field for simple
// returns, a slice of interfaces for anonymous returns and a struct for named
// returns.
func (_OptimismPortal2 *OptimismPortal2CallerRaw) Call(opts *bind.CallOpts, result *[]interface{}, method string, params ...interface{}) error {
	return _OptimismPortal2.Contract.contract.Call(opts, result, method, params...)
}

// Transfer initiates a plain transaction to move funds to the contract, calling
// its default method if one is available.
func (_OptimismPortal2 *OptimismPortal2TransactorRaw) Transfer(opts *bind.TransactOpts) (*types.Transaction, error) {
	return _OptimismPortal2.Contract.contract.Transfer(opts)
}

// Transact invokes the (paid) contract method with params as input values.
func (_OptimismPortal2 *OptimismPortal2TransactorRaw) Transact(opts *bind.TransactOpts, method string, params ...interface{}) (*types.Transaction, error) {
	return _OptimismPortal2.Contract.contract.Transact(opts, method, params...)
}

// CheckWithdrawal is a free data retrieval call binding the contract method 0x71c1566e.
//
// Solidity: function checkWithdrawal(bytes32 _withdrawalHash, address _proofSubmitter) view returns()
func (_OptimismPortal2 *OptimismPortal2Caller) CheckWithdrawal(opts *bind.CallOpts, _withdrawalHash [32]byte, _proofSubmitter common.Address) error {
	var out []interface{}
	err := _OptimismPortal2.contract.Call(opts, &out, "checkWithdrawal", _withdrawalHash, _proofSubmitter)

	if err != nil {
		return err
	}

	return err

}

// CheckWithdrawal is a free data retrieval call binding the contract method 0x71c1566e.
//
// Solidity: function checkWithdrawal(bytes32 _withdrawalHash, address _proofSubmitter) view returns()
func (_OptimismPortal2 *OptimismPortal2Session) CheckWithdrawal(_withdrawalHash [32]byte, _proofSubmitter common.Address) error {
	return _OptimismPortal2.Contract.CheckWithdrawal(&_OptimismPortal2.CallOpts, _withdrawalHash, _proofSubmitter)
}

// CheckWithdrawal is a free data retrieval call binding the contract method 0x71c1566e.
//
// Solidity: function checkWithdrawal(bytes32 _withdrawalHash, address _proofSubmitter) view returns()
func (_OptimismPortal2 *OptimismPortal2CallerSession) CheckWithdrawal(_withdrawalHash [32]byte, _proofSubmitter common.Address) error {
	return _OptimismPortal2.Contract.CheckWithdrawal(&_OptimismPortal2.CallOpts, _withdrawalHash, _proofSubmitter)
}

// DisputeGameBlacklist is a free data retrieval call binding the contract method 0x45884d32.
//
// Solidity: function disputeGameBlacklist(address ) view returns(bool)
func (_OptimismPortal2 *OptimismPortal2Caller) DisputeGameBlacklist(opts *bind.CallOpts, arg0 common.Address) (bool, error) {
	var out []interface{}
	err := _OptimismPortal2.contract.Call(opts, &out, "disputeGameBlacklist", arg0)

	if err != nil {
		return *new(bool), err
	}

	out0 := *abi.ConvertType(out[0], new(bool)).(*bool)

	return out0, err

}

// DisputeGameBlacklist is a free data retrieval call binding the contract method 0x45884d32.
//
// Solidity: function disputeGameBlacklist(address ) view returns(bool)
func (_OptimismPortal2 *OptimismPortal2Session) DisputeGameBlacklist(arg0 common.Address) (bool, error) {
	return _OptimismPortal2.Contract.DisputeGameBlacklist(&_OptimismPortal2.CallOpts, arg0)
}

// DisputeGameBlacklist is a free data retrieval call binding the contract method 0x45884d32.
//
// Solidity: function disputeGameBlacklist(address ) view returns(bool)
func (_OptimismPortal2 *OptimismPortal2CallerSession) DisputeGameBlacklist(arg0 common.Address) (bool, error) {
	return _OptimismPortal2.Contract.DisputeGameBlacklist(&_OptimismPortal2.CallOpts, arg0)
}

// DisputeGameFactory is a free data retrieval call binding the contract method 0xf2b4e617.
//
// Solidity: function disputeGameFactory() view returns(address)
func (_OptimismPortal2 *OptimismPortal2Caller) DisputeGameFactory(opts *bind.CallOpts) (common.Address, error) {
	var out []interface{}
	err := _OptimismPortal2.contract.Call(opts, &out, "disputeGameFactory")

	if err != nil {
		return *new(common.Address), err
	}

	out0 := *abi.ConvertType(out[0], new(common.Address)).(*common.Address)

	return out0, err

}

// DisputeGameFactory is a free data retrieval call binding the contract method 0xf2b4e617.
//
// Solidity: function disputeGameFactory() view returns(address)
func (_OptimismPortal2 *OptimismPortal2Session) DisputeGameFactory() (common.Address, error) {
	return _OptimismPortal2.Contract.DisputeGameFactory(&_OptimismPortal2.CallOpts)
}

// DisputeGameFactory is a free data retrieval call binding the contract method 0xf2b4e617.
//
// Solidity: function disputeGameFactory() view returns(address)
func (_OptimismPortal2 *OptimismPortal2CallerSession) DisputeGameFactory() (common.Address, error) {
	return _OptimismPortal2.Contract.DisputeGameFactory(&_OptimismPortal2.CallOpts)
}

// DisputeGameFinalityDelaySeconds is a free data retrieval call binding the contract method 0x952b2797.
//
// Solidity: function disputeGameFinalityDelaySeconds() view returns(uint256)
func (_OptimismPortal2 *OptimismPortal2Caller) DisputeGameFinalityDelaySeconds(opts *bind.CallOpts) (*big.Int, error) {
	var out []interface{}
	err := _OptimismPortal2.contract.Call(opts, &out, "disputeGameFinalityDelaySeconds")

	if err != nil {
		return *new(*big.Int), err
	}

	out0 := *abi.ConvertType(out[0], new(*big.Int)).(**big.Int)

	return out0, err

}

// DisputeGameFinalityDelaySeconds is a free data retrieval call binding the contract method 0x952b2797.
//
// Solidity: function disputeGameFinalityDelaySeconds() view returns(uint256)
func (_OptimismPortal2 *OptimismPortal2Session) DisputeGameFinalityDelaySeconds() (*big.Int, error) {
	return _OptimismPortal2.Contract.DisputeGameFinalityDelaySeconds(&_OptimismPortal2.CallOpts)
}

// DisputeGameFinalityDelaySeconds is a free data retrieval call binding the contract method 0x952b2797.
//
// Solidity: function disputeGameFinalityDelaySeconds() view returns(uint256)
func (_OptimismPortal2 *OptimismPortal2CallerSession) DisputeGameFinalityDelaySeconds() (*big.Int, error) {
	return _OptimismPortal2.Contract.DisputeGameFinalityDelaySeconds(&_OptimismPortal2.CallOpts)
}

// FinalizedWithdrawals is a free data retrieval call binding the contract method 0xa14238e7.
//
// Solidity: function finalizedWithdrawals(bytes32 ) view returns(bool)
func (_OptimismPortal2 *OptimismPortal2Caller) FinalizedWithdrawals(opts *bind.CallOpts, arg0 [32]byte) (bool, error) {
	var out []interface{}
	err := _OptimismPortal2.contract.Call(opts, &out, "finalizedWithdrawals", arg0)

	if err != nil {
		return *new(bool), err
	}

	out0 := *abi.ConvertType(out[0], new(bool)).(*bool)

	return out0, err

}

// FinalizedWithdrawals is a free data retrieval call binding the contract method 0xa14238e7.
//
// Solidity: function finalizedWithdrawals(bytes32 ) view returns(bool)
func (_OptimismPortal2 *OptimismPortal2Session) FinalizedWithdrawals(arg0 [32]byte) (bool, error) {
	return _OptimismPortal2.Contract.FinalizedWithdrawals(&_OptimismPortal2.CallOpts, arg0)
}

// FinalizedWithdrawals is a free data retrieval call binding the contract method 0xa14238e7.
//
// Solidity: function finalizedWithdrawals(bytes32 ) view returns(bool)
func (_OptimismPortal2 *OptimismPortal2CallerSession) FinalizedWithdrawals(arg0 [32]byte) (bool, error) {
	return _OptimismPortal2.Contract.FinalizedWithdrawals(&_OptimismPortal2.CallOpts, arg0)
}

// Guardian is a free data retrieval call binding the contract method 0x452a9320.
//
// Solidity: function guardian() view returns(address)
func (_OptimismPortal2 *OptimismPortal2Caller) Guardian(opts *bind.CallOpts) (common.Address, error) {
	var out []interface{}
	err := _OptimismPortal2.contract.Call(opts, &out, "guardian")

	if err != nil {
		return *new(common.Address), err
	}

	out0 := *abi.ConvertType(out[0], new(common.Address)).(*common.Address)

	return out0, err

}

// Guardian is a free data retrieval call binding the contract method 0x452a9320.
//
// Solidity: function guardian() view returns(address)
func (_OptimismPortal2 *OptimismPortal2Session) Guardian() (common.Address, error) {
	return _OptimismPortal2.Contract.Guardian(&_OptimismPortal2.CallOpts)
}

// Guardian is a free data retrieval call binding the contract method 0x452a9320.
//
// Solidity: function guardian() view returns(address)
func (_OptimismPortal2 *OptimismPortal2CallerSession) Guardian() (common.Address, error) {
	return _OptimismPortal2.Contract.Guardian(&_OptimismPortal2.CallOpts)
}

// L2Sender is a free data retrieval call binding the contract method 0x9bf62d82.
//
// Solidity: function l2Sender() view returns(address)
func (_OptimismPortal2 *OptimismPortal2Caller) L2Sender(opts *bind.CallOpts) (common.Address, error) {
	var out []interface{}
	err := _OptimismPortal2.contract.Call(opts, &out, "l2Sender")

	if err != nil {
		return *new(common.Address), err
	}

	out0 := *abi.ConvertType(out[0], new(common.Address)).(*common.Address)

	return out0, err

}

// L2Sender is a free data retrieval call binding the contract method 0x9bf62d82.
//
// Solidity: function l2Sender() view returns(address)
func (_OptimismPortal2 *OptimismPortal2Session) L2Sender() (common.Address, error) {
	return _OptimismPortal2.Contract.L2Sender(&_OptimismPortal2.CallOpts)
}

// L2Sender is a free data retrieval call binding the contract method 0x9bf62d82.
//
// Solidity: function l2Sender() view returns(address)
func (_OptimismPortal2 *OptimismPortal2CallerSession) L2Sender() (common.Address, error) {
	return _OptimismPortal2.Contract.L2Sender(&_OptimismPortal2.CallOpts)
}

// MinimumGasLimit is a free data retrieval call binding the contract method 0xa35d99df.
//
// Solidity: function minimumGasLimit(uint64 _byteCount) pure returns(uint64)
func (_OptimismPortal2 *OptimismPortal2Caller) MinimumGasLimit(opts *bind.CallOpts, _byteCount uint64) (uint64, error) {
	var out []interface{}
	err := _OptimismPortal2.contract.Call(opts, &out, "minimumGasLimit", _byteCount)

	if err != nil {
		return *new(uint64), err
	}

	out0 := *abi.ConvertType(out[0], new(uint64)).(*uint64)

	return out0, err

}

// MinimumGasLimit is a free data retrieval call binding the contract method 0xa35d99df.
//
// Solidity: function minimumGasLimit(uint64 _byteCount) pure returns(uint64)
func (_OptimismPortal2 *OptimismPortal2Session) MinimumGasLimit(_byteCount uint64) (uint64, error) {
	return _OptimismPortal2.Contract.MinimumGasLimit(&_OptimismPortal2.CallOpts, _byteCount)
}

// MinimumGasLimit is a free data retrieval call binding the contract method 0xa35d99df.
//
// Solidity: function minimumGasLimit(uint64 _byteCount) pure returns(uint64)
func (_OptimismPortal2 *OptimismPortal2CallerSession) MinimumGasLimit(_byteCount uint64) (uint64, error) {
	return _OptimismPortal2.Contract.MinimumGasLimit(&_OptimismPortal2.CallOpts, _byteCount)
}

// NumProofSubmitters is a free data retrieval call binding the contract method 0x513747ab.
//
// Solidity: function numProofSubmitters(bytes32 _withdrawalHash) view returns(uint256)
func (_OptimismPortal2 *OptimismPortal2Caller) NumProofSubmitters(opts *bind.CallOpts, _withdrawalHash [32]byte) (*big.Int, error) {
	var out []interface{}
	err := _OptimismPortal2.contract.Call(opts, &out, "numProofSubmitters", _withdrawalHash)

	if err != nil {
		return *new(*big.Int), err
	}

	out0 := *abi.ConvertType(out[0], new(*big.Int)).(**big.Int)

	return out0, err

}

// NumProofSubmitters is a free data retrieval call binding the contract method 0x513747ab.
//
// Solidity: function numProofSubmitters(bytes32 _withdrawalHash) view returns(uint256)
func (_OptimismPortal2 *OptimismPortal2Session) NumProofSubmitters(_withdrawalHash [32]byte) (*big.Int, error) {
	return _OptimismPortal2.Contract.NumProofSubmitters(&_OptimismPortal2.CallOpts, _withdrawalHash)
}

// NumProofSubmitters is a free data retrieval call binding the contract method 0x513747ab.
//
// Solidity: function numProofSubmitters(bytes32 _withdrawalHash) view returns(uint256)
func (_OptimismPortal2 *OptimismPortal2CallerSession) NumProofSubmitters(_withdrawalHash [32]byte) (*big.Int, error) {
	return _OptimismPortal2.Contract.NumProofSubmitters(&_OptimismPortal2.CallOpts, _withdrawalHash)
}

// Params is a free data retrieval call binding the contract method 0xcff0ab96.
//
// Solidity: function params() view returns(uint128 prevBaseFee, uint64 prevBoughtGas, uint64 prevBlockNum)
func (_OptimismPortal2 *OptimismPortal2Caller) Params(opts *bind.CallOpts) (struct {
	PrevBaseFee   *big.Int
	PrevBoughtGas uint64
	PrevBlockNum  uint64
}, error) {
	var out []interface{}
	err := _OptimismPortal2.contract.Call(opts, &out, "params")

	outstruct := new(struct {
		PrevBaseFee   *big.Int
		PrevBoughtGas uint64
		PrevBlockNum  uint64
	})
	if err != nil {
		return *outstruct, err
	}

	outstruct.PrevBaseFee = *abi.ConvertType(out[0], new(*big.Int)).(**big.Int)
	outstruct.PrevBoughtGas = *abi.ConvertType(out[1], new(uint64)).(*uint64)
	outstruct.PrevBlockNum = *abi.ConvertType(out[2], new(uint64)).(*uint64)

	return *outstruct, err

}

// Params is a free data retrieval call binding the contract method 0xcff0ab96.
//
// Solidity: function params() view returns(uint128 prevBaseFee, uint64 prevBoughtGas, uint64 prevBlockNum)
func (_OptimismPortal2 *OptimismPortal2Session) Params() (struct {
	PrevBaseFee   *big.Int
	PrevBoughtGas uint64
	PrevBlockNum  uint64
}, error) {
	return _OptimismPortal2.Contract.Params(&_OptimismPortal2.CallOpts)
}

// Params is a free data retrieval call binding the contract method 0xcff0ab96.
//
// Solidity: function params() view returns(uint128 prevBaseFee, uint64 prevBoughtGas, uint64 prevBlockNum)
func (_OptimismPortal2 *OptimismPortal2CallerSession) Params() (struct {
	PrevBaseFee   *big.Int
	PrevBoughtGas uint64
	PrevBlockNum  uint64
}, error) {
	return _OptimismPortal2.Contract.Params(&_OptimismPortal2.CallOpts)
}

// Paused is a free data retrieval call binding the contract method 0x5c975abb.
//
// Solidity: function paused() view returns(bool)
func (_OptimismPortal2 *OptimismPortal2Caller) Paused(opts *bind.CallOpts) (bool, error) {
	var out []interface{}
	err := _OptimismPortal2.contract.Call(opts, &out, "paused")

	if err != nil {
		return *new(bool), err
	}

	out0 := *abi.ConvertType(out[0], new(bool)).(*bool)

	return out0, err

}

// Paused is a free data retrieval call binding the contract method 0x5c975abb.
//
// Solidity: function paused() view returns(bool)
func (_OptimismPortal2 *OptimismPortal2Session) Paused() (bool, error) {
	return _OptimismPortal2.Contract.Paused(&_OptimismPortal2.CallOpts)
}

// Paused is a free data retrieval call binding the contract method 0x5c975abb.
//
// Solidity: function paused() view returns(bool)
func (_OptimismPortal2 *OptimismPortal2CallerSession) Paused() (bool, error) {
	return _OptimismPortal2.Contract.Paused(&_OptimismPortal2.CallOpts)
}

// ProofMaturityDelaySeconds is a free data retrieval call binding the contract method 0xbf653a5c.
//
// Solidity: function proofMaturityDelaySeconds() view returns(uint256)
func (_OptimismPortal2 *OptimismPortal2Caller) ProofMaturityDelaySeconds(opts *bind.CallOpts) (*big.Int, error) {
	var out []interface{}
	err := _OptimismPortal2.contract.Call(opts, &out, "proofMaturityDelaySeconds")

	if err != nil {
		return *new(*big.Int), err
	}

	out0 := *abi.ConvertType(out[0], new(*big.Int)).(**big.Int)

	return out0, err

}

// ProofMaturityDelaySeconds is a free data retrieval call binding the contract method 0xbf653a5c.
//
// Solidity: function proofMaturityDelaySeconds() view returns(uint256)
func (_OptimismPortal2 *OptimismPortal2Session) ProofMaturityDelaySeconds() (*big.Int, error) {
	return _OptimismPortal2.Contract.ProofMaturityDelaySeconds(&_OptimismPortal2.CallOpts)
}

// ProofMaturityDelaySeconds is a free data retrieval call binding the contract method 0xbf653a5c.
//
// Solidity: function proofMaturityDelaySeconds() view returns(uint256)
func (_OptimismPortal2 *OptimismPortal2CallerSession) ProofMaturityDelaySeconds() (*big.Int, error) {
	return _OptimismPortal2.Contract.ProofMaturityDelaySeconds(&_OptimismPortal2.CallOpts)
}

// ProofSubmitters is a free data retrieval call binding the contract method 0xa3860f48.
//
// Solidity: function proofSubmitters(bytes32 , uint256 ) view returns(address)
func (_OptimismPortal2 *OptimismPortal2Caller) ProofSubmitters(opts *bind.CallOpts, arg0 [32]byte, arg1 *big.Int) (common.Address, error) {
	var out []interface{}
	err := _OptimismPortal2.contract.Call(opts, &out, "proofSubmitters", arg0, arg1)

	if err != nil {
		return *new(common.Address), err
	}

	out0 := *abi.ConvertType(out[0], new(common.Address)).(*common.Address)

	return out0, err

}

// ProofSubmitters is a free data retrieval call binding the contract method 0xa3860f48.
//
// Solidity: function proofSubmitters(bytes32 , uint256 ) view returns(address)
func (_OptimismPortal2 *OptimismPortal2Session) ProofSubmitters(arg0 [32]byte, arg1 *big.Int) (common.Address, error) {
	return _OptimismPortal2.Contract.ProofSubmitters(&_OptimismPortal2.CallOpts, arg0, arg1)
}

// ProofSubmitters is a free data retrieval call binding the contract method 0xa3860f48.
//
// Solidity: function proofSubmitters(bytes32 , uint256 ) view returns(address)
func (_OptimismPortal2 *OptimismPortal2CallerSession) ProofSubmitters(arg0 [32]byte, arg1 *big.Int) (common.Address, error) {
	return _OptimismPortal2.Contract.ProofSubmitters(&_OptimismPortal2.CallOpts, arg0, arg1)
}

// ProvenWithdrawals is a free data retrieval call binding the contract method 0xbb2c727e.
//
// Solidity: function provenWithdrawals(bytes32 , address ) view returns(address disputeGameProxy, uint64 timestamp)
func (_OptimismPortal2 *OptimismPortal2Caller) ProvenWithdrawals(opts *bind.CallOpts, arg0 [32]byte, arg1 common.Address) (struct {
	DisputeGameProxy common.Address
	Timestamp        uint64
}, error) {
	var out []interface{}
	err := _OptimismPortal2.contract.Call(opts, &out, "provenWithdrawals", arg0, arg1)

	outstruct := new(struct {
		DisputeGameProxy common.Address
		Timestamp        uint64
	})
	if err != nil {
		return *outstruct, err
	}

	outstruct.DisputeGameProxy = *abi.ConvertType(out[0], new(common.Address)).(*common.Address)
	outstruct.Timestamp = *abi.ConvertType(out[1], new(uint64)).(*uint64)

	return *outstruct, err

}

// ProvenWithdrawals is a free data retrieval call binding the contract method 0xbb2c727e.
//
// Solidity: function provenWithdrawals(bytes32 , address ) view returns(address disputeGameProxy, uint64 timestamp)
func (_OptimismPortal2 *OptimismPortal2Session) ProvenWithdrawals(arg0 [32]byte, arg1 common.Address) (struct {
	DisputeGameProxy common.Address
	Timestamp        uint64
}, error) {
	return _OptimismPortal2.Contract.ProvenWithdrawals(&_OptimismPortal2.CallOpts, arg0, arg1)
}

// ProvenWithdrawals is a free data retrieval call binding the contract method 0xbb2c727e.
//
// Solidity: function provenWithdrawals(bytes32 , address ) view returns(address disputeGameProxy, uint64 timestamp)
func (_OptimismPortal2 *OptimismPortal2CallerSession) ProvenWithdrawals(arg0 [32]byte, arg1 common.Address) (struct {
	DisputeGameProxy common.Address
	Timestamp        uint64
}, error) {
	return _OptimismPortal2.Contract.ProvenWithdrawals(&_OptimismPortal2.CallOpts, arg0, arg1)
}

// RespectedGameType is a free data retrieval call binding the contract method 0x3c9f397c.
//
// Solidity: function respectedGameType() view returns(uint32)
func (_OptimismPortal2 *OptimismPortal2Caller) RespectedGameType(opts *bind.CallOpts) (uint32, error) {
	var out []interface{}
	err := _OptimismPortal2.contract.Call(opts, &out, "respectedGameType")

	if err != nil {
		return *new(uint32), err
	}

	out0 := *abi.ConvertType(out[0], new(uint32)).(*uint32)

	return out0, err

}

// RespectedGameType is a free data retrieval call binding the contract method 0x3c9f397c.
//
// Solidity: function respectedGameType() view returns(uint32)
func (_OptimismPortal2 *OptimismPortal2Session) RespectedGameType() (uint32, error) {
	return _OptimismPortal2.Contract.RespectedGameType(&_OptimismPortal2.CallOpts)
}

// RespectedGameType is a free data retrieval call binding the contract method 0x3c9f397c.
//
// Solidity: function respectedGameType() view returns(uint32)
func (_OptimismPortal2 *OptimismPortal2CallerSession) RespectedGameType() (uint32, error) {
	return _OptimismPortal2.Contract.RespectedGameType(&_OptimismPortal2.CallOpts)
}

// RespectedGameTypeUpdatedAt is a free data retrieval call binding the contract method 0x4fd0434c.
//
// Solidity: function respectedGameTypeUpdatedAt() view returns(uint64)
func (_OptimismPortal2 *OptimismPortal2Caller) RespectedGameTypeUpdatedAt(opts *bind.CallOpts) (uint64, error) {
	var out []interface{}
	err := _OptimismPortal2.contract.Call(opts, &out, "respectedGameTypeUpdatedAt")

	if err != nil {
		return *new(uint64), err
	}

	out0 := *abi.ConvertType(out[0], new(uint64)).(*uint64)

	return out0, err

}

// RespectedGameTypeUpdatedAt is a free data retrieval call binding the contract method 0x4fd0434c.
//
// Solidity: function respectedGameTypeUpdatedAt() view returns(uint64)
func (_OptimismPortal2 *OptimismPortal2Session) RespectedGameTypeUpdatedAt() (uint64, error) {
	return _OptimismPortal2.Contract.RespectedGameTypeUpdatedAt(&_OptimismPortal2.CallOpts)
}

// RespectedGameTypeUpdatedAt is a free data retrieval call binding the contract method 0x4fd0434c.
//
// Solidity: function respectedGameTypeUpdatedAt() view returns(uint64)
func (_OptimismPortal2 *OptimismPortal2CallerSession) RespectedGameTypeUpdatedAt() (uint64, error) {
	return _OptimismPortal2.Contract.RespectedGameTypeUpdatedAt(&_OptimismPortal2.CallOpts)
}

// SuperchainConfig is a free data retrieval call binding the contract method 0x35e80ab3.
//
// Solidity: function superchainConfig() view returns(address)
func (_OptimismPortal2 *OptimismPortal2Caller) SuperchainConfig(opts *bind.CallOpts) (common.Address, error) {
	var out []interface{}
	err := _OptimismPortal2.contract.Call(opts, &out, "superchainConfig")

	if err != nil {
		return *new(common.Address), err
	}

	out0 := *abi.ConvertType(out[0], new(common.Address)).(*common.Address)

	return out0, err

}

// SuperchainConfig is a free data retrieval call binding the contract method 0x35e80ab3.
//
// Solidity: function superchainConfig() view returns(address)
func (_OptimismPortal2 *OptimismPortal2Session) SuperchainConfig() (common.Address, error) {
	return _OptimismPortal2.Contract.SuperchainConfig(&_OptimismPortal2.CallOpts)
}

// SuperchainConfig is a free data retrieval call binding the contract method 0x35e80ab3.
//
// Solidity: function superchainConfig() view returns(address)
func (_OptimismPortal2 *OptimismPortal2CallerSession) SuperchainConfig() (common.Address, error) {
	return _OptimismPortal2.Contract.SuperchainConfig(&_OptimismPortal2.CallOpts)
}

// SystemConfig is a free data retrieval call binding the contract method 0x33d7e2bd.
//
// Solidity: function systemConfig() view returns(address)
func (_OptimismPortal2 *OptimismPortal2Caller) SystemConfig(opts *bind.CallOpts) (common.Address, error) {
	var out []interface{}
	err := _OptimismPortal2.contract.Call(opts, &out, "systemConfig")

	if err != nil {
		return *new(common.Address), err
	}

	out0 := *abi.ConvertType(out[0], new(common.Address)).(*common.Address)

	return out0, err

}

// SystemConfig is a free data retrieval call binding the contract method 0x33d7e2bd.
//
// Solidity: function systemConfig() view returns(address)
func (_OptimismPortal2 *OptimismPortal2Session) SystemConfig() (common.Address, error) {
	return _OptimismPortal2.Contract.SystemConfig(&_OptimismPortal2.CallOpts)
}

// SystemConfig is a free data retrieval call binding the contract method 0x33d7e2bd.
//
// Solidity: function systemConfig() view returns(address)
func (_OptimismPortal2 *OptimismPortal2CallerSession) SystemConfig() (common.Address, error) {
	return _OptimismPortal2.Contract.SystemConfig(&_OptimismPortal2.CallOpts)
}

// Version is a free data retrieval call binding the contract method 0x54fd4d50.
//
// Solidity: function version() view returns(string)
func (_OptimismPortal2 *OptimismPortal2Caller) Version(opts *bind.CallOpts) (string, error) {
	var out []interface{}
	err := _OptimismPortal2.contract.Call(opts, &out, "version")

	if err != nil {
		return *new(string), err
	}

	out0 := *abi.ConvertType(out[0], new(string)).(*string)

	return out0, err

}

// Version is a free data retrieval call binding the contract method 0x54fd4d50.
//
// Solidity: function version() view returns(string)
func (_OptimismPortal2 *OptimismPortal2Session) Version() (string, error) {
	return _OptimismPortal2.Contract.Version(&_OptimismPortal2.CallOpts)
}

// Version is a free data retrieval call binding the contract method 0x54fd4d50.
//
// Solidity: function version() view returns(string)
func (_OptimismPortal2 *OptimismPortal2CallerSession) Version() (string, error) {
	return _OptimismPortal2.Contract.Version(&_OptimismPortal2.CallOpts)
}

// BlacklistDisputeGame is a paid mutator transaction binding the contract method 0x7d6be8dc.
//
// Solidity: function blacklistDisputeGame(address _disputeGame) returns()
func (_OptimismPortal2 *OptimismPortal2Transactor) BlacklistDisputeGame(opts *bind.TransactOpts, _disputeGame common.Address) (*types.Transaction, error) {
	return _OptimismPortal2.contract.Transact(opts, "blacklistDisputeGame", _disputeGame)
}

// BlacklistDisputeGame is a paid mutator transaction binding the contract method 0x7d6be8dc.
//
// Solidity: function blacklistDisputeGame(address _disputeGame) returns()
func (_OptimismPortal2 *OptimismPortal2Session) BlacklistDisputeGame(_disputeGame common.Address) (*types.Transaction, error) {
	return _OptimismPortal2.Contract.BlacklistDisputeGame(&_OptimismPortal2.TransactOpts, _disputeGame)
}

// BlacklistDisputeGame is a paid mutator transaction binding the contract method 0x7d6be8dc.
//
// Solidity: function blacklistDisputeGame(address _disputeGame) returns()
func (_OptimismPortal2 *OptimismPortal2TransactorSession) BlacklistDisputeGame(_disputeGame common.Address) (*types.Transaction, error) {
	return _OptimismPortal2.Contract.BlacklistDisputeGame(&_OptimismPortal2.TransactOpts, _disputeGame)
}

// DepositTransaction is a paid mutator transaction binding the contract method 0xe9e05c42.
//
// Solidity: function depositTransaction(address _to, uint256 _value, uint64 _gasLimit, bool _isCreation, bytes _data) payable returns()
func (_OptimismPortal2 *OptimismPortal2Transactor) DepositTransaction(opts *bind.TransactOpts, _to common.Address, _value *big.Int, _gasLimit uint64, _isCreation bool, _data []byte) (*types.Transaction, error) {
	return _OptimismPortal2.contract.Transact(opts, "depositTransaction", _to, _value, _gasLimit, _isCreation, _data)
}

// DepositTransaction is a paid mutator transaction binding the contract method 0xe9e05c42.
//
// Solidity: function depositTransaction(address _to, uint256 _value, uint64 _gasLimit, bool _isCreation, bytes _data) payable returns()
func (_OptimismPortal2 *OptimismPortal2Session) DepositTransaction(_to common.Address, _value *big.Int, _gasLimit uint64, _isCreation bool, _data []byte) (*types.Transaction, error) {
	return _OptimismPortal2.Contract.DepositTransaction(&_OptimismPortal2.TransactOpts, _to, _value, _gasLimit, _isCreation, _data)
}

// DepositTransaction is a paid mutator transaction binding the contract method 0xe9e05c42.
//
// Solidity: function depositTransaction(address _to, uint256 _value, uint64 _gasLimit, bool _isCreation, bytes _data) payable returns()
func (_OptimismPortal2 *OptimismPortal2TransactorSession) DepositTransaction(_to common.Address, _value *big.Int, _gasLimit uint64, _isCreation bool, _data []byte) (*types.Transaction, error) {
	return _OptimismPortal2.Contract.DepositTransaction(&_OptimismPortal2.TransactOpts, _to, _value, _gasLimit, _isCreation, _data)
}

// DonateETH is a paid mutator transaction binding the contract method 0x8b4c40b0.
//
// Solidity: function donateETH() payable returns()
func (_OptimismPortal2 *OptimismPortal2Transactor) DonateETH(opts *bind.TransactOpts) (*types.Transaction, error) {
	return _OptimismPortal2.contract.Transact(opts, "donateETH")
}

// DonateETH is a paid mutator transaction binding the contract method 0x8b4c40b0.
//
// Solidity: function donateETH() payable returns()
func (_OptimismPortal2 *OptimismPortal2Session) DonateETH() (*types.Transaction, error) {
	return _OptimismPortal2.Contract.DonateETH(&_OptimismPortal2.TransactOpts)
}

// DonateETH is a paid mutator transaction binding the contract method 0x8b4c40b0.
//
// Solidity: function donateETH() payable returns()
func (_OptimismPortal2 *OptimismPortal2TransactorSession) DonateETH() (*types.Transaction, error) {
	return _OptimismPortal2.Contract.DonateETH(&_OptimismPortal2.TransactOpts)
}

// FinalizeWithdrawalTransaction is a paid mutator transaction binding the contract method 0x8c3152e9.
//
// Solidity: function finalizeWithdrawalTransaction((uint256,address,address,uint256,uint256,bytes) _tx) returns()
func (_OptimismPortal2 *OptimismPortal2Transactor) FinalizeWithdrawalTransaction(opts *bind.TransactOpts, _tx TypesWithdrawalTransaction) (*types.Transaction, error) {
	return _OptimismPortal2.contract.Transact(opts, "finalizeWithdrawalTransaction", _tx)
}

// FinalizeWithdrawalTransaction is a paid mutator transaction binding the contract method 0x8c3152e9.
//
// Solidity: function finalizeWithdrawalTransaction((uint256,address,address,uint256,uint256,bytes) _tx) returns()
func (_OptimismPortal2 *OptimismPortal2Session) FinalizeWithdrawalTransaction(_tx TypesWithdrawalTransaction) (*types.Transaction, error) {
	return _OptimismPortal2.Contract.FinalizeWithdrawalTransaction(&_OptimismPortal2.TransactOpts, _tx)
}

// FinalizeWithdrawalTransaction is a paid mutator transaction binding the contract method 0x8c3152e9.
//
// Solidity: function finalizeWithdrawalTransaction((uint256,address,address,uint256,uint256,bytes) _tx) returns()
func (_OptimismPortal2 *OptimismPortal2TransactorSession) FinalizeWithdrawalTransaction(_tx TypesWithdrawalTransaction) (*types.Transaction, error) {
	return _OptimismPortal2.Contract.FinalizeWithdrawalTransaction(&_OptimismPortal2.TransactOpts, _tx)
}

// FinalizeWithdrawalTransactionExternalProof is a paid mutator transaction binding the contract method 0x43ca1c50.
//
// Solidity: function finalizeWithdrawalTransactionExternalProof((uint256,address,address,uint256,uint256,bytes) _tx, address _proofSubmitter) returns()
func (_OptimismPortal2 *OptimismPortal2Transactor) FinalizeWithdrawalTransactionExternalProof(opts *bind.TransactOpts, _tx TypesWithdrawalTransaction, _proofSubmitter common.Address) (*types.Transaction, error) {
	return _OptimismPortal2.contract.Transact(opts, "finalizeWithdrawalTransactionExternalProof", _tx, _proofSubmitter)
}

// FinalizeWithdrawalTransactionExternalProof is a paid mutator transaction binding the contract method 0x43ca1c50.
//
// Solidity: function finalizeWithdrawalTransactionExternalProof((uint256,address,address,uint256,uint256,bytes) _tx, address _proofSubmitter) returns()
func (_OptimismPortal2 *OptimismPortal2Session) FinalizeWithdrawalTransactionExternalProof(_tx TypesWithdrawalTransaction, _proofSubmitter common.Address) (*types.Transaction, error) {
	return _OptimismPortal2.Contract.FinalizeWithdrawalTransactionExternalProof(&_OptimismPortal2.TransactOpts, _tx, _proofSubmitter)
}

// FinalizeWithdrawalTransactionExternalProof is a paid mutator transaction binding the contract method 0x43ca1c50.
//
// Solidity: function finalizeWithdrawalTransactionExternalProof((uint256,address,address,uint256,uint256,bytes) _tx, address _proofSubmitter) returns()
func (_OptimismPortal2 *OptimismPortal2TransactorSession) FinalizeWithdrawalTransactionExternalProof(_tx TypesWithdrawalTransaction, _proofSubmitter common.Address) (*types.Transaction, error) {
	return _OptimismPortal2.Contract.FinalizeWithdrawalTransactionExternalProof(&_OptimismPortal2.TransactOpts, _tx, _proofSubmitter)
}

// Initialize is a paid mutator transaction binding the contract method 0xc0c53b8b.
//
// Solidity: function initialize(address _disputeGameFactory, address _systemConfig, address _superchainConfig) returns()
func (_OptimismPortal2 *OptimismPortal2Transactor) Initialize(opts *bind.TransactOpts, _disputeGameFactory common.Address, _systemConfig common.Address, _superchainConfig common.Address) (*types.Transaction, error) {
	return _OptimismPortal2.contract.Transact(opts, "initialize", _disputeGameFactory, _systemConfig, _superchainConfig)
}

// Initialize is a paid mutator transaction binding the contract method 0xc0c53b8b.
//
// Solidity: function initialize(address _disputeGameFactory, address _systemConfig, address _superchainConfig) returns()
func (_OptimismPortal2 *OptimismPortal2Session) Initialize(_disputeGameFactory common.Address, _systemConfig common.Address, _superchainConfig common.Address) (*types.Transaction, error) {
	return _OptimismPortal2.Contract.Initialize(&_OptimismPortal2.TransactOpts, _disputeGameFactory, _systemConfig, _superchainConfig)
}

// Initialize is a paid mutator transaction binding the contract method 0xc0c53b8b.
//
// Solidity: function initialize(address _disputeGameFactory, address _systemConfig, address _superchainConfig) returns()
func (_OptimismPortal2 *OptimismPortal2TransactorSession) Initialize(_disputeGameFactory common.Address, _systemConfig common.Address, _superchainConfig common.Address) (*types.Transaction, error) {
	return _OptimismPortal2.Contract.Initialize(&_OptimismPortal2.TransactOpts, _disputeGameFactory, _systemConfig, _superchainConfig)
}

// ProveWithdrawalTransaction is a paid mutator transaction binding the contract method 0x4870496f.
//
// Solidity: function proveWithdrawalTransaction((uint256,address,address,uint256,uint256,bytes) _tx, uint256 _disputeGameIndex, (bytes32,bytes32,bytes32,bytes32) _outputRootProof, bytes[] _withdrawalProof) returns()
func (_OptimismPortal2 *OptimismPortal2Transactor) ProveWithdrawalTransaction(opts *bind.TransactOpts, _tx TypesWithdrawalTransaction, _disputeGameIndex *big.Int, _outputRootProof TypesOutputRootProof, _withdrawalProof [][]byte) (*types.Transaction, error) {
	return _OptimismPortal2.contract.Transact(opts, "proveWithdrawalTransaction", _tx, _disputeGameIndex, _outputRootProof, _withdrawalProof)
}

// ProveWithdrawalTransaction is a paid mutator transaction binding the contract method 0x4870496f.
//
// Solidity: function proveWithdrawalTransaction((uint256,address,address,uint256,uint256,bytes) _tx, uint256 _disputeGameIndex, (bytes32,bytes32,bytes32,bytes32) _outputRootProof, bytes[] _withdrawalProof) returns()
func (_OptimismPortal2 *OptimismPortal2Session) ProveWithdrawalTransaction(_tx TypesWithdrawalTransaction, _disputeGameIndex *big.Int, _outputRootProof TypesOutputRootProof, _withdrawalProof [][]byte) (*types.Transaction, error) {
	return _OptimismPortal2.Contract.ProveWithdrawalTransaction(&_OptimismPortal2.TransactOpts, _tx, _disputeGameIndex, _outputRootProof, _withdrawalProof)
}

// ProveWithdrawalTransaction is a paid mutator transaction binding the contract method 0x4870496f.
//
// Solidity: function proveWithdrawalTransaction((uint256,address,address,uint256,uint256,bytes) _tx, uint256 _disputeGameIndex, (bytes32,bytes32,bytes32,bytes32) _outputRootProof, bytes[] _withdrawalProof) returns()
func (_OptimismPortal2 *OptimismPortal2TransactorSession) ProveWithdrawalTransaction(_tx TypesWithdrawalTransaction, _disputeGameIndex *big.Int, _outputRootProof TypesOutputRootProof, _withdrawalProof [][]byte) (*types.Transaction, error) {
	return _OptimismPortal2.Contract.ProveWithdrawalTransaction(&_OptimismPortal2.TransactOpts, _tx, _disputeGameIndex, _outputRootProof, _withdrawalProof)
}

// SetRespectedGameType is a paid mutator transaction binding the contract method 0x7fc48504.
//
// Solidity: function setRespectedGameType(uint32 _gameType) returns()
func (_OptimismPortal2 *OptimismPortal2Transactor) SetRespectedGameType(opts *bind.TransactOpts, _gameType uint32) (*types.Transaction, error) {
	return _OptimismPortal2.contract.Transact(opts, "setRespectedGameType", _gameType)
}

// SetRespectedGameType is a paid mutator transaction binding the contract method 0x7fc48504.
//
// Solidity: function setRespectedGameType(uint32 _gameType) returns()
func (_OptimismPortal2 *OptimismPortal2Session) SetRespectedGameType(_gameType uint32) (*types.Transaction, error) {
	return _OptimismPortal2.Contract.SetRespectedGameType(&_OptimismPortal2.TransactOpts, _gameType)
}

// SetRespectedGameType is a paid mutator transaction binding the contract method 0x7fc48504.
//
// Solidity: function setRespectedGameType(uint32 _gameType) returns()
func (_OptimismPortal2 *OptimismPortal2TransactorSession) SetRespectedGameType(_gameType uint32) (*types.Transaction, error) {
	return _OptimismPortal2.Contract.SetRespectedGameType(&_OptimismPortal2.TransactOpts, _gameType)
}

// Receive is a paid mutator transaction binding the contract receive function.
//
// Solidity: receive() payable returns()
func (_OptimismPortal2 *OptimismPortal2Transactor) Receive(opts *bind.TransactOpts) (*types.Transaction, error) {
	return _OptimismPortal2.contract.RawTransact(opts, nil) // calldata is disallowed for receive function
}

// Receive is a paid mutator transaction binding the contract receive function.
//
// Solidity: receive() payable returns()
func (_OptimismPortal2 *OptimismPortal2Session) Receive() (*types.Transaction, error) {
	return _OptimismPortal2.Contract.Receive(&_OptimismPortal2.TransactOpts)
}

// Receive is a paid mutator transaction binding the contract receive function.
//
// Solidity: receive() payable returns()
func (_OptimismPortal2 *OptimismPortal2TransactorSession) Receive() (*types.Transaction, error) {
	return _OptimismPortal2.Contract.Receive(&_OptimismPortal2.TransactOpts)
}

// OptimismPortal2InitializedIterator is returned from FilterInitialized and is used to iterate over the raw logs and unpacked data for Initialized events raised by the OptimismPortal2 contract.
type OptimismPortal2InitializedIterator struct {
	Event *OptimismPortal2Initialized // Event containing the contract specifics and raw log

	contract *bind.BoundContract // Generic contract to use for unpacking event data
	event    string              // Event name to use for unpacking event data

	logs chan types.Log        // Log channel receiving the found contract events
	sub  ethereum.Subscription // Subscription for errors, completion and termination
	done bool                  // Whether the subscription completed delivering logs
	fail error                 // Occurred error to stop iteration
}

// Next advances the iterator to the subsequent event, returning whether there
// are any more events found. In case of a retrieval or parsing error, false is
// returned and Error() can be queried for the exact failure.
func (it *OptimismPortal2InitializedIterator) Next() bool {
	// If the iterator failed, stop iterating
	if it.fail != nil {
		return false
	}
	// If the iterator completed, deliver directly whatever's available
	if it.done {
		select {
		case log := <-it.logs:
			it.Event = new(OptimismPortal2Initialized)
			if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
				it.fail = err
				return false
			}
			it.Event.Raw = log
			return true

		default:
			return false
		}
	}
	// Iterator still in progress, wait for either a data or an error event
	select {
	case log := <-it.logs:
		it.Event = new(OptimismPortal2Initialized)
		if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
			it.fail = err
			return false
		}
		it.Event.Raw = log
		return true

	case err := <-it.sub.Err():
		it.done = true
		it.fail = err
		return it.Next()
	}
}

// Error returns any retrieval or parsing error occurred during filtering.
func (it *OptimismPortal2InitializedIterator) Error() error {
	return it.fail
}

// Close terminates the iteration process, releasing any pending underlying
// resources.
func (it *OptimismPortal2InitializedIterator) Close() error {
	it.sub.Unsubscribe()
	return nil
}

// OptimismPortal2Initialized represents a Initialized event raised by the OptimismPortal2 contract.
type OptimismPortal2Initialized struct {
	Version uint8
	Raw     types.Log // Blockchain specific contextual infos
}

// FilterInitialized is a free log retrieval operation binding the contract event 0x7f26b83ff96e1f2b6a682f133852f6798a09c465da95921460cefb3847402498.
//
// Solidity: event Initialized(uint8 version)
func (_OptimismPortal2 *OptimismPortal2Filterer) FilterInitialized(opts *bind.FilterOpts) (*OptimismPortal2InitializedIterator, error) {

	logs, sub, err := _OptimismPortal2.contract.FilterLogs(opts, "Initialized")
	if err != nil {
		return nil, err
	}
	return &OptimismPortal2InitializedIterator{contract: _OptimismPortal2.contract, event: "Initialized", logs: logs, sub: sub}, nil
}

// WatchInitialized is a free log subscription operation binding the contract event 0x7f26b83ff96e1f2b6a682f133852f6798a09c465da95921460cefb3847402498.
//
// Solidity: event Initialized(uint8 version)
func (_OptimismPortal2 *OptimismPortal2Filterer) WatchInitialized(opts *bind.WatchOpts, sink chan<- *OptimismPortal2Initialized) (event.Subscription, error) {

	logs, sub, err := _OptimismPortal2.contract.WatchLogs(opts, "Initialized")
	if err != nil {
		return nil, err
	}
	return event.NewSubscription(func(quit <-chan struct{}) error {
		defer sub.Unsubscribe()
		for {
			select {
			case log := <-logs:
				// New log arrived, parse the event and forward to the user
				event := new(OptimismPortal2Initialized)
				if err := _OptimismPortal2.contract.UnpackLog(event, "Initialized", log); err != nil {
					return err
				}
				event.Raw = log

				select {
				case sink <- event:
				case err := <-sub.Err():
					return err
				case <-quit:
					return nil
				}
			case err := <-sub.Err():
				return err
			case <-quit:
				return nil
			}
		}
	}), nil
}

// ParseInitialized is a log parse operation binding the contract event 0x7f26b83ff96e1f2b6a682f133852f6798a09c465da95921460cefb3847402498.
//
// Solidity: event Initialized(uint8 version)
func (_OptimismPortal2 *OptimismPortal2Filterer) ParseInitialized(log types.Log) (*OptimismPortal2Initialized, error) {
	event := new(OptimismPortal2Initialized)
	if err := _OptimismPortal2.contract.UnpackLog(event, "Initialized", log); err != nil {
		return nil, err
	}
	event.Raw = log
	return event, nil
}

// OptimismPortal2TransactionDepositedIterator is returned from FilterTransactionDeposited and is used to iterate over the raw logs and unpacked data for TransactionDeposited events raised by the OptimismPortal2 contract.
type OptimismPortal2TransactionDepositedIterator struct {
	Event *OptimismPortal2TransactionDeposited // Event containing the contract specifics and raw log

	contract *bind.BoundContract // Generic contract to use for unpacking event data
	event    string              // Event name to use for unpacking event data

	logs chan types.Log        // Log channel receiving the found contract events
	sub  ethereum.Subscription // Subscription for errors, completion and termination
	done bool                  // Whether the subscription completed delivering logs
	fail error                 // Occurred error to stop iteration
}

// Next advances the iterator to the subsequent event, returning whether there
// are any more events found. In case of a retrieval or parsing error, false is
// returned and Error() can be queried for the exact failure.
func (it *OptimismPortal2TransactionDepositedIterator) Next() bool {
	// If the iterator failed, stop iterating
	if it.fail != nil {
		return false
	}
	// If the iterator completed, deliver directly whatever's available
	if it.done {
		select {
		case log := <-it.logs:
			it.Event = new(OptimismPortal2TransactionDeposited)
			if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
				it.fail = err
				return false
			}
			it.Event.Raw = log
			return true

		default:
			return false
		}
	}
	// Iterator still in progress, wait for either a data or an error event
	select {
	case log := <-it.logs:
		it.Event = new(OptimismPortal2TransactionDeposited)
		if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
			it.fail = err
			return false
		}
		it.Event.Raw = log
		return true

	case err := <-it.sub.Err():
		it.done = true
		it.fail = err
		return it.Next()
	}
}

// Error returns any retrieval or parsing error occurred during filtering.
func (it *OptimismPortal2TransactionDepositedIterator) Error() error {
	return it.fail
}

// Close terminates the iteration process, releasing any pending underlying
// resources.
func (it *OptimismPortal2TransactionDepositedIterator) Close() error {
	it.sub.Unsubscribe()
	return nil
}

// OptimismPortal2TransactionDeposited represents a TransactionDeposited event raised by the OptimismPortal2 contract.
type OptimismPortal2TransactionDeposited struct {
	From       common.Address
	To         common.Address
	Version    *big.Int
	OpaqueData []byte
	Raw        types.Log // Blockchain specific contextual infos
}

// FilterTransactionDeposited is a free log retrieval operation binding the contract event 0xb3813568d9991fc951961fcb4c784893574240a28925604d09fc577c55bb7c32.
//
// Solidity: event TransactionDeposited(address indexed from, address indexed to, uint256 indexed version, bytes opaqueData)
func (_OptimismPortal2 *OptimismPortal2Filterer) FilterTransactionDeposited(opts *bind.FilterOpts, from []common.Address, to []common.Address, version []*big.Int) (*OptimismPortal2TransactionDepositedIterator, error) {

	var fromRule []interface{}
	for _, fromItem := range from {
		fromRule = append(fromRule, fromItem)
	}
	var toRule []interface{}
	for _, toItem := range to {
		toRule = append(toRule, toItem)
	}
	var versionRule []interface{}
	for _, versionItem := range version {
		versionRule = append(versionRule, versionItem)
	}

	logs, sub, err := _OptimismPortal2.contract.FilterLogs(opts, "TransactionDeposited", fromRule, toRule, versionRule)
	if err != nil {
		return nil, err
	}
	return &OptimismPortal2TransactionDepositedIterator{contract: _OptimismPortal2.contract, event: "TransactionDeposited", logs: logs, sub: sub}, nil
}

// WatchTransactionDeposited is a free log subscription operation binding the contract event 0xb3813568d9991fc951961fcb4c784893574240a28925604d09fc577c55bb7c32.
//
// Solidity: event TransactionDeposited(address indexed from, address indexed to, uint256 indexed version, bytes opaqueData)
func (_OptimismPortal2 *OptimismPortal2Filterer) WatchTransactionDeposited(opts *bind.WatchOpts, sink chan<- *OptimismPortal2TransactionDeposited, from []common.Address, to []common.Address, version []*big.Int) (event.Subscription, error) {

	var fromRule []interface{}
	for _, fromItem := range from {
		fromRule = append(fromRule, fromItem)
	}
	var toRule []interface{}
	for _, toItem := range to {
		toRule = append(toRule, toItem)
	}
	var versionRule []interface{}
	for _, versionItem := range version {
		versionRule = append(versionRule, versionItem)
	}

	logs, sub, err := _OptimismPortal2.contract.WatchLogs(opts, "TransactionDeposited", fromRule, toRule, versionRule)
	if err != nil {
		return nil, err
	}
	return event.NewSubscription(func(quit <-chan struct{}) error {
		defer sub.Unsubscribe()
		for {
			select {
			case log := <-logs:
				// New log arrived, parse the event and forward to the user
				event := new(OptimismPortal2TransactionDeposited)
				if err := _OptimismPortal2.contract.UnpackLog(event, "TransactionDeposited", log); err != nil {
					return err
				}
				event.Raw = log

				select {
				case sink <- event:
				case err := <-sub.Err():
					return err
				case <-quit:
					return nil
				}
			case err := <-sub.Err():
				return err
			case <-quit:
				return nil
			}
		}
	}), nil
}

// ParseTransactionDeposited is a log parse operation binding the contract event 0xb3813568d9991fc951961fcb4c784893574240a28925604d09fc577c55bb7c32.
//
// Solidity: event TransactionDeposited(address indexed from, address indexed to, uint256 indexed version, bytes opaqueData)
func (_OptimismPortal2 *OptimismPortal2Filterer) ParseTransactionDeposited(log types.Log) (*OptimismPortal2TransactionDeposited, error) {
	event := new(OptimismPortal2TransactionDeposited)
	if err := _OptimismPortal2.contract.UnpackLog(event, "TransactionDeposited", log); err != nil {
		return nil, err
	}
	event.Raw = log
	return event, nil
}

// OptimismPortal2WithdrawalFinalizedIterator is returned from FilterWithdrawalFinalized and is used to iterate over the raw logs and unpacked data for WithdrawalFinalized events raised by the OptimismPortal2 contract.
type OptimismPortal2WithdrawalFinalizedIterator struct {
	Event *OptimismPortal2WithdrawalFinalized // Event containing the contract specifics and raw log

	contract *bind.BoundContract // Generic contract to use for unpacking event data
	event    string              // Event name to use for unpacking event data

	logs chan types.Log        // Log channel receiving the found contract events
	sub  ethereum.Subscription // Subscription for errors, completion and termination
	done bool                  // Whether the subscription completed delivering logs
	fail error                 // Occurred error to stop iteration
}

// Next advances the iterator to the subsequent event, returning whether there
// are any more events found. In case of a retrieval or parsing error, false is
// returned and Error() can be queried for the exact failure.
func (it *OptimismPortal2WithdrawalFinalizedIterator) Next() bool {
	// If the iterator failed, stop iterating
	if it.fail != nil {
		return false
	}
	// If the iterator completed, deliver directly whatever's available
	if it.done {
		select {
		case log := <-it.logs:
			it.Event = new(OptimismPortal2WithdrawalFinalized)
			if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
				it.fail = err
				return false
			}
			it.Event.Raw = log
			return true

		default:
			return false
		}
	}
	// Iterator still in progress, wait for either a data or an error event
	select {
	case log := <-it.logs:
		it.Event = new(OptimismPortal2WithdrawalFinalized)
		if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
			it.fail = err
			return false
		}
		it.Event.Raw = log
		return true

	case err := <-it.sub.Err():
		it.done = true
		it.fail = err
		return it.Next()
	}
}

// Error returns any retrieval or parsing error occurred during filtering.
func (it *OptimismPortal2WithdrawalFinalizedIterator) Error() error {
	return it.fail
}

// Close terminates the iteration process, releasing any pending underlying
// resources.
func (it *OptimismPortal2WithdrawalFinalizedIterator) Close() error {
	it.sub.Unsubscribe()
	return nil
}

// OptimismPortal2WithdrawalFinalized represents a WithdrawalFinalized event raised by the OptimismPortal2 contract.
type OptimismPortal2WithdrawalFinalized struct {
	WithdrawalHash [32]byte
	Success        bool
	Raw            types.Log // Blockchain specific contextual infos
}

// FilterWithdrawalFinalized is a free log retrieval operation binding the contract event 0xdb5c7652857aa163daadd670e116628fb42e869d8ac4251ef8971d9e5727df1b.
//
// Solidity: event WithdrawalFinalized(bytes32 indexed withdrawalHash, bool success)
func (_OptimismPortal2 *OptimismPortal2Filterer) FilterWithdrawalFinalized(opts *bind.FilterOpts, withdrawalHash [][32]byte) (*OptimismPortal2WithdrawalFinalizedIterator, error) {

	var withdrawalHashRule []interface{}
	for _, withdrawalHashItem := range withdrawalHash {
		withdrawalHashRule = append(withdrawalHashRule, withdrawalHashItem)
	}

	logs, sub, err := _OptimismPortal2.contract.FilterLogs(opts, "WithdrawalFinalized", withdrawalHashRule)
	if err != nil {
		return nil, err
	}
	return &OptimismPortal2WithdrawalFinalizedIterator{contract: _OptimismPortal2.contract, event: "WithdrawalFinalized", logs: logs, sub: sub}, nil
}

// WatchWithdrawalFinalized is a free log subscription operation binding the contract event 0xdb5c7652857aa163daadd670e116628fb42e869d8ac4251ef8971d9e5727df1b.
//
// Solidity: event WithdrawalFinalized(bytes32 indexed withdrawalHash, bool success)
func (_OptimismPortal2 *OptimismPortal2Filterer) WatchWithdrawalFinalized(opts *bind.WatchOpts, sink chan<- *OptimismPortal2WithdrawalFinalized, withdrawalHash [][32]byte) (event.Subscription, error) {

	var withdrawalHashRule []interface{}
	for _, withdrawalHashItem := range withdrawalHash {
		withdrawalHashRule = append(withdrawalHashRule, withdrawalHashItem)
	}

	logs, sub, err := _OptimismPortal2.contract.WatchLogs(opts, "WithdrawalFinalized", withdrawalHashRule)
	if err != nil {
		return nil, err
	}
	return event.NewSubscription(func(quit <-chan struct{}) error {
		defer sub.Unsubscribe()
		for {
			select {
			case log := <-logs:
				// New log arrived, parse the event and forward to the user
				event := new(OptimismPortal2WithdrawalFinalized)
				if err := _OptimismPortal2.contract.UnpackLog(event, "WithdrawalFinalized", log); err != nil {
					return err
				}
				event.Raw = log

				select {
				case sink <- event:
				case err := <-sub.Err():
					return err
				case <-quit:
					return nil
				}
			case err := <-sub.Err():
				return err
			case <-quit:
				return nil
			}
		}
	}), nil
}

// ParseWithdrawalFinalized is a log parse operation binding the contract event 0xdb5c7652857aa163daadd670e116628fb42e869d8ac4251ef8971d9e5727df1b.
//
// Solidity: event WithdrawalFinalized(bytes32 indexed withdrawalHash, bool success)
func (_OptimismPortal2 *OptimismPortal2Filterer) ParseWithdrawalFinalized(log types.Log) (*OptimismPortal2WithdrawalFinalized, error) {
	event := new(OptimismPortal2WithdrawalFinalized)
	if err := _OptimismPortal2.contract.UnpackLog(event, "WithdrawalFinalized", log); err != nil {
		return nil, err
	}
	event.Raw = log
	return event, nil
}

// OptimismPortal2WithdrawalProvenIterator is returned from FilterWithdrawalProven and is used to iterate over the raw logs and unpacked data for WithdrawalProven events raised by the OptimismPortal2 contract.
type OptimismPortal2WithdrawalProvenIterator struct {
	Event *OptimismPortal2WithdrawalProven // Event containing the contract specifics and raw log

	contract *bind.BoundContract // Generic contract to use for unpacking event data
	event    string              // Event name to use for unpacking event data

	logs chan types.Log        // Log channel receiving the found contract events
	sub  ethereum.Subscription // Subscription for errors, completion and termination
	done bool                  // Whether the subscription completed delivering logs
	fail error                 // Occurred error to stop iteration
}

// Next advances the iterator to the subsequent event, returning whether there
// are any more events found. In case of a retrieval or parsing error, false is
// returned and Error() can be queried for the exact failure.
func (it *OptimismPortal2WithdrawalProvenIterator) Next() bool {
	// If the iterator failed, stop iterating
	if it.fail != nil {
		return false
	}
	// If the iterator completed, deliver directly whatever's available
	if it.done {
		select {
		case log := <-it.logs:
			it.Event = new(OptimismPortal2WithdrawalProven)
			if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
				it.fail = err
				return false
			}
			it.Event.Raw = log
			return true

		default:
			return false
		}
	}
	// Iterator still in progress, wait for either a data or an error event
	select {
	case log := <-it.logs:
		it.Event = new(OptimismPortal2WithdrawalProven)
		if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
			it.fail = err
			return false
		}
		it.Event.Raw = log
		return true

	case err := <-it.sub.Err():
		it.done = true
		it.fail = err
		return it.Next()
	}
}

// Error returns any retrieval or parsing error occurred during filtering.
func (it *OptimismPortal2WithdrawalProvenIterator) Error() error {
	return it.fail
}

// Close terminates the iteration process, releasing any pending underlying
// resources.
func (it *OptimismPortal2WithdrawalProvenIterator) Close() error {
	it.sub.Unsubscribe()
	return nil
}

// OptimismPortal2WithdrawalProven represents a WithdrawalProven event raised by the OptimismPortal2 contract.
type OptimismPortal2WithdrawalProven struct {
	WithdrawalHash [32]byte
	From           common.Address
	To             common.Address
	Raw            types.Log // Blockchain specific contextual infos
}

// FilterWithdrawalProven is a free log retrieval operation binding the contract event 0x67a6208cfcc0801d50f6cbe764733f4fddf66ac0b04442061a8a8c0cb6b63f62.
//
// Solidity: event WithdrawalProven(bytes32 indexed withdrawalHash, address indexed from, address indexed to)
func (_OptimismPortal2 *OptimismPortal2Filterer) FilterWithdrawalProven(opts *bind.FilterOpts, withdrawalHash [][32]byte, from []common.Address, to []common.Address) (*OptimismPortal2WithdrawalProvenIterator, error) {

	var withdrawalHashRule []interface{}
	for _, withdrawalHashItem := range withdrawalHash {
		withdrawalHashRule = append(withdrawalHashRule, withdrawalHashItem)
	}
	var fromRule []interface{}
	for _, fromItem := range from {
		fromRule = append(fromRule, fromItem)
	}
	var toRule []interface{}
	for _, toItem := range to {
		toRule = append(toRule, toItem)
	}

	logs, sub, err := _OptimismPortal2.contract.FilterLogs(opts, "WithdrawalProven", withdrawalHashRule, fromRule, toRule)
	if err != nil {
		return nil, err
	}
	return &OptimismPortal2WithdrawalProvenIterator{contract: _OptimismPortal2.contract, event: "WithdrawalProven", logs: logs, sub: sub}, nil
}

// WatchWithdrawalProven is a free log subscription operation binding the contract event 0x67a6208cfcc0801d50f6cbe764733f4fddf66ac0b04442061a8a8c0cb6b63f62.
//
// Solidity: event WithdrawalProven(bytes32 indexed withdrawalHash, address indexed from, address indexed to)
func (_OptimismPortal2 *OptimismPortal2Filterer) WatchWithdrawalProven(opts *bind.WatchOpts, sink chan<- *OptimismPortal2WithdrawalProven, withdrawalHash [][32]byte, from []common.Address, to []common.Address) (event.Subscription, error) {

	var withdrawalHashRule []interface{}
	for _, withdrawalHashItem := range withdrawalHash {
		withdrawalHashRule = append(withdrawalHashRule, withdrawalHashItem)
	}
	var fromRule []interface{}
	for _, fromItem := range from {
		fromRule = append(fromRule, fromItem)
	}
	var toRule []interface{}
	for _, toItem := range to {
		toRule = append(toRule, toItem)
	}

	logs, sub, err := _OptimismPortal2.contract.WatchLogs(opts, "WithdrawalProven", withdrawalHashRule, fromRule, toRule)
	if err != nil {
		return nil, err
	}
	return event.NewSubscription(func(quit <-chan struct{}) error {
		defer sub.Unsubscribe()
		for {
			select {
			case log := <-logs:
				// New log arrived, parse the event and forward to the user
				event := new(OptimismPortal2WithdrawalProven)
				if err := _OptimismPortal2.contract.UnpackLog(event, "WithdrawalProven", log); err != nil {
					return err
				}
				event.Raw = log

				select {
				case sink <- event:
				case err := <-sub.Err():
					return err
				case <-quit:
					return nil
				}
			case err := <-sub.Err():
				return err
			case <-quit:
				return nil
			}
		}
	}), nil
}

// ParseWithdrawalProven is a log parse operation binding the contract event 0x67a6208cfcc0801d50f6cbe764733f4fddf66ac0b04442061a8a8c0cb6b63f62.
//
// Solidity: event WithdrawalProven(bytes32 indexed withdrawalHash, address indexed from, address indexed to)
func (_OptimismPortal2 *OptimismPortal2Filterer) ParseWithdrawalProven(log types.Log) (*OptimismPortal2WithdrawalProven, error) {
	event := new(OptimismPortal2WithdrawalProven)
	if err := _OptimismPortal2.contract.UnpackLog(event, "WithdrawalProven", log); err != nil {
		return nil, err
	}
	event.Raw = log
	return event, nil
}
