// Code generated - DO NOT EDIT.
// This file is a generated binding and any manual changes will be lost.

package bindings

import (
	"errors"
	"math/big"
	"strings"

	ethereum "github.com/ethereum/go-ethereum"
	"github.com/ethereum/go-ethereum/accounts/abi"
	"github.com/ethereum/go-ethereum/accounts/abi/bind"
	"github.com/ethereum/go-ethereum/common"
	"github.com/ethereum/go-ethereum/core/types"
	"github.com/ethereum/go-ethereum/event"
)

// Reference imports to suppress errors if they are not otherwise used.
var (
	_ = errors.New
	_ = big.NewInt
	_ = strings.NewReader
	_ = ethereum.NotFound
	_ = bind.Bind
	_ = common.Big1
	_ = types.BloomLookup
	_ = event.NewSubscription
)

// OptimismMintableERC721FactoryMetaData contains all meta data concerning the OptimismMintableERC721Factory contract.
var OptimismMintableERC721FactoryMetaData = &bind.MetaData{
	ABI: "[{\"inputs\":[{\"internalType\":\"address\",\"name\":\"_bridge\",\"type\":\"address\"},{\"internalType\":\"uint256\",\"name\":\"_remoteChainId\",\"type\":\"uint256\"}],\"stateMutability\":\"nonpayable\",\"type\":\"constructor\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":true,\"internalType\":\"address\",\"name\":\"localToken\",\"type\":\"address\"},{\"indexed\":true,\"internalType\":\"address\",\"name\":\"remoteToken\",\"type\":\"address\"},{\"indexed\":false,\"internalType\":\"address\",\"name\":\"deployer\",\"type\":\"address\"}],\"name\":\"OptimismMintableERC721Created\",\"type\":\"event\"},{\"inputs\":[],\"name\":\"BRIDGE\",\"outputs\":[{\"internalType\":\"address\",\"name\":\"\",\"type\":\"address\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"REMOTE_CHAIN_ID\",\"outputs\":[{\"internalType\":\"uint256\",\"name\":\"\",\"type\":\"uint256\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"_remoteToken\",\"type\":\"address\"},{\"internalType\":\"string\",\"name\":\"_name\",\"type\":\"string\"},{\"internalType\":\"string\",\"name\":\"_symbol\",\"type\":\"string\"}],\"name\":\"createOptimismMintableERC721\",\"outputs\":[{\"internalType\":\"address\",\"name\":\"\",\"type\":\"address\"}],\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"inputs\":[{\"internalType\":\"address\",\"name\":\"\",\"type\":\"address\"}],\"name\":\"isOptimismMintableERC721\",\"outputs\":[{\"internalType\":\"bool\",\"name\":\"\",\"type\":\"bool\"}],\"stateMutability\":\"view\",\"type\":\"function\"},{\"inputs\":[],\"name\":\"version\",\"outputs\":[{\"internalType\":\"string\",\"name\":\"\",\"type\":\"string\"}],\"stateMutability\":\"view\",\"type\":\"function\"}]",
	Bin: "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",
}

// OptimismMintableERC721FactoryABI is the input ABI used to generate the binding from.
// Deprecated: Use OptimismMintableERC721FactoryMetaData.ABI instead.
var OptimismMintableERC721FactoryABI = OptimismMintableERC721FactoryMetaData.ABI

// OptimismMintableERC721FactoryBin is the compiled bytecode used for deploying new contracts.
// Deprecated: Use OptimismMintableERC721FactoryMetaData.Bin instead.
var OptimismMintableERC721FactoryBin = OptimismMintableERC721FactoryMetaData.Bin

// DeployOptimismMintableERC721Factory deploys a new Ethereum contract, binding an instance of OptimismMintableERC721Factory to it.
func DeployOptimismMintableERC721Factory(auth *bind.TransactOpts, backend bind.ContractBackend, _bridge common.Address, _remoteChainId *big.Int) (common.Address, *types.Transaction, *OptimismMintableERC721Factory, error) {
	parsed, err := OptimismMintableERC721FactoryMetaData.GetAbi()
	if err != nil {
		return common.Address{}, nil, nil, err
	}
	if parsed == nil {
		return common.Address{}, nil, nil, errors.New("GetABI returned nil")
	}

	address, tx, contract, err := bind.DeployContract(auth, *parsed, common.FromHex(OptimismMintableERC721FactoryBin), backend, _bridge, _remoteChainId)
	if err != nil {
		return common.Address{}, nil, nil, err
	}
	return address, tx, &OptimismMintableERC721Factory{OptimismMintableERC721FactoryCaller: OptimismMintableERC721FactoryCaller{contract: contract}, OptimismMintableERC721FactoryTransactor: OptimismMintableERC721FactoryTransactor{contract: contract}, OptimismMintableERC721FactoryFilterer: OptimismMintableERC721FactoryFilterer{contract: contract}}, nil
}

// OptimismMintableERC721Factory is an auto generated Go binding around an Ethereum contract.
type OptimismMintableERC721Factory struct {
	OptimismMintableERC721FactoryCaller     // Read-only binding to the contract
	OptimismMintableERC721FactoryTransactor // Write-only binding to the contract
	OptimismMintableERC721FactoryFilterer   // Log filterer for contract events
}

// OptimismMintableERC721FactoryCaller is an auto generated read-only Go binding around an Ethereum contract.
type OptimismMintableERC721FactoryCaller struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// OptimismMintableERC721FactoryTransactor is an auto generated write-only Go binding around an Ethereum contract.
type OptimismMintableERC721FactoryTransactor struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// OptimismMintableERC721FactoryFilterer is an auto generated log filtering Go binding around an Ethereum contract events.
type OptimismMintableERC721FactoryFilterer struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// OptimismMintableERC721FactorySession is an auto generated Go binding around an Ethereum contract,
// with pre-set call and transact options.
type OptimismMintableERC721FactorySession struct {
	Contract     *OptimismMintableERC721Factory // Generic contract binding to set the session for
	CallOpts     bind.CallOpts                  // Call options to use throughout this session
	TransactOpts bind.TransactOpts              // Transaction auth options to use throughout this session
}

// OptimismMintableERC721FactoryCallerSession is an auto generated read-only Go binding around an Ethereum contract,
// with pre-set call options.
type OptimismMintableERC721FactoryCallerSession struct {
	Contract *OptimismMintableERC721FactoryCaller // Generic contract caller binding to set the session for
	CallOpts bind.CallOpts                        // Call options to use throughout this session
}

// OptimismMintableERC721FactoryTransactorSession is an auto generated write-only Go binding around an Ethereum contract,
// with pre-set transact options.
type OptimismMintableERC721FactoryTransactorSession struct {
	Contract     *OptimismMintableERC721FactoryTransactor // Generic contract transactor binding to set the session for
	TransactOpts bind.TransactOpts                        // Transaction auth options to use throughout this session
}

// OptimismMintableERC721FactoryRaw is an auto generated low-level Go binding around an Ethereum contract.
type OptimismMintableERC721FactoryRaw struct {
	Contract *OptimismMintableERC721Factory // Generic contract binding to access the raw methods on
}

// OptimismMintableERC721FactoryCallerRaw is an auto generated low-level read-only Go binding around an Ethereum contract.
type OptimismMintableERC721FactoryCallerRaw struct {
	Contract *OptimismMintableERC721FactoryCaller // Generic read-only contract binding to access the raw methods on
}

// OptimismMintableERC721FactoryTransactorRaw is an auto generated low-level write-only Go binding around an Ethereum contract.
type OptimismMintableERC721FactoryTransactorRaw struct {
	Contract *OptimismMintableERC721FactoryTransactor // Generic write-only contract binding to access the raw methods on
}

// NewOptimismMintableERC721Factory creates a new instance of OptimismMintableERC721Factory, bound to a specific deployed contract.
func NewOptimismMintableERC721Factory(address common.Address, backend bind.ContractBackend) (*OptimismMintableERC721Factory, error) {
	contract, err := bindOptimismMintableERC721Factory(address, backend, backend, backend)
	if err != nil {
		return nil, err
	}
	return &OptimismMintableERC721Factory{OptimismMintableERC721FactoryCaller: OptimismMintableERC721FactoryCaller{contract: contract}, OptimismMintableERC721FactoryTransactor: OptimismMintableERC721FactoryTransactor{contract: contract}, OptimismMintableERC721FactoryFilterer: OptimismMintableERC721FactoryFilterer{contract: contract}}, nil
}

// NewOptimismMintableERC721FactoryCaller creates a new read-only instance of OptimismMintableERC721Factory, bound to a specific deployed contract.
func NewOptimismMintableERC721FactoryCaller(address common.Address, caller bind.ContractCaller) (*OptimismMintableERC721FactoryCaller, error) {
	contract, err := bindOptimismMintableERC721Factory(address, caller, nil, nil)
	if err != nil {
		return nil, err
	}
	return &OptimismMintableERC721FactoryCaller{contract: contract}, nil
}

// NewOptimismMintableERC721FactoryTransactor creates a new write-only instance of OptimismMintableERC721Factory, bound to a specific deployed contract.
func NewOptimismMintableERC721FactoryTransactor(address common.Address, transactor bind.ContractTransactor) (*OptimismMintableERC721FactoryTransactor, error) {
	contract, err := bindOptimismMintableERC721Factory(address, nil, transactor, nil)
	if err != nil {
		return nil, err
	}
	return &OptimismMintableERC721FactoryTransactor{contract: contract}, nil
}

// NewOptimismMintableERC721FactoryFilterer creates a new log filterer instance of OptimismMintableERC721Factory, bound to a specific deployed contract.
func NewOptimismMintableERC721FactoryFilterer(address common.Address, filterer bind.ContractFilterer) (*OptimismMintableERC721FactoryFilterer, error) {
	contract, err := bindOptimismMintableERC721Factory(address, nil, nil, filterer)
	if err != nil {
		return nil, err
	}
	return &OptimismMintableERC721FactoryFilterer{contract: contract}, nil
}

// bindOptimismMintableERC721Factory binds a generic wrapper to an already deployed contract.
func bindOptimismMintableERC721Factory(address common.Address, caller bind.ContractCaller, transactor bind.ContractTransactor, filterer bind.ContractFilterer) (*bind.BoundContract, error) {
	parsed, err := abi.JSON(strings.NewReader(OptimismMintableERC721FactoryABI))
	if err != nil {
		return nil, err
	}
	return bind.NewBoundContract(address, parsed, caller, transactor, filterer), nil
}

// Call invokes the (constant) contract method with params as input values and
// sets the output to result. The result type might be a single field for simple
// returns, a slice of interfaces for anonymous returns and a struct for named
// returns.
func (_OptimismMintableERC721Factory *OptimismMintableERC721FactoryRaw) Call(opts *bind.CallOpts, result *[]interface{}, method string, params ...interface{}) error {
	return _OptimismMintableERC721Factory.Contract.OptimismMintableERC721FactoryCaller.contract.Call(opts, result, method, params...)
}

// Transfer initiates a plain transaction to move funds to the contract, calling
// its default method if one is available.
func (_OptimismMintableERC721Factory *OptimismMintableERC721FactoryRaw) Transfer(opts *bind.TransactOpts) (*types.Transaction, error) {
	return _OptimismMintableERC721Factory.Contract.OptimismMintableERC721FactoryTransactor.contract.Transfer(opts)
}

// Transact invokes the (paid) contract method with params as input values.
func (_OptimismMintableERC721Factory *OptimismMintableERC721FactoryRaw) Transact(opts *bind.TransactOpts, method string, params ...interface{}) (*types.Transaction, error) {
	return _OptimismMintableERC721Factory.Contract.OptimismMintableERC721FactoryTransactor.contract.Transact(opts, method, params...)
}

// Call invokes the (constant) contract method with params as input values and
// sets the output to result. The result type might be a single field for simple
// returns, a slice of interfaces for anonymous returns and a struct for named
// returns.
func (_OptimismMintableERC721Factory *OptimismMintableERC721FactoryCallerRaw) Call(opts *bind.CallOpts, result *[]interface{}, method string, params ...interface{}) error {
	return _OptimismMintableERC721Factory.Contract.contract.Call(opts, result, method, params...)
}

// Transfer initiates a plain transaction to move funds to the contract, calling
// its default method if one is available.
func (_OptimismMintableERC721Factory *OptimismMintableERC721FactoryTransactorRaw) Transfer(opts *bind.TransactOpts) (*types.Transaction, error) {
	return _OptimismMintableERC721Factory.Contract.contract.Transfer(opts)
}

// Transact invokes the (paid) contract method with params as input values.
func (_OptimismMintableERC721Factory *OptimismMintableERC721FactoryTransactorRaw) Transact(opts *bind.TransactOpts, method string, params ...interface{}) (*types.Transaction, error) {
	return _OptimismMintableERC721Factory.Contract.contract.Transact(opts, method, params...)
}

// BRIDGE is a free data retrieval call binding the contract method 0xee9a31a2.
//
// Solidity: function BRIDGE() view returns(address)
func (_OptimismMintableERC721Factory *OptimismMintableERC721FactoryCaller) BRIDGE(opts *bind.CallOpts) (common.Address, error) {
	var out []interface{}
	err := _OptimismMintableERC721Factory.contract.Call(opts, &out, "BRIDGE")

	if err != nil {
		return *new(common.Address), err
	}

	out0 := *abi.ConvertType(out[0], new(common.Address)).(*common.Address)

	return out0, err

}

// BRIDGE is a free data retrieval call binding the contract method 0xee9a31a2.
//
// Solidity: function BRIDGE() view returns(address)
func (_OptimismMintableERC721Factory *OptimismMintableERC721FactorySession) BRIDGE() (common.Address, error) {
	return _OptimismMintableERC721Factory.Contract.BRIDGE(&_OptimismMintableERC721Factory.CallOpts)
}

// BRIDGE is a free data retrieval call binding the contract method 0xee9a31a2.
//
// Solidity: function BRIDGE() view returns(address)
func (_OptimismMintableERC721Factory *OptimismMintableERC721FactoryCallerSession) BRIDGE() (common.Address, error) {
	return _OptimismMintableERC721Factory.Contract.BRIDGE(&_OptimismMintableERC721Factory.CallOpts)
}

// REMOTECHAINID is a free data retrieval call binding the contract method 0x7d1d0c5b.
//
// Solidity: function REMOTE_CHAIN_ID() view returns(uint256)
func (_OptimismMintableERC721Factory *OptimismMintableERC721FactoryCaller) REMOTECHAINID(opts *bind.CallOpts) (*big.Int, error) {
	var out []interface{}
	err := _OptimismMintableERC721Factory.contract.Call(opts, &out, "REMOTE_CHAIN_ID")

	if err != nil {
		return *new(*big.Int), err
	}

	out0 := *abi.ConvertType(out[0], new(*big.Int)).(**big.Int)

	return out0, err

}

// REMOTECHAINID is a free data retrieval call binding the contract method 0x7d1d0c5b.
//
// Solidity: function REMOTE_CHAIN_ID() view returns(uint256)
func (_OptimismMintableERC721Factory *OptimismMintableERC721FactorySession) REMOTECHAINID() (*big.Int, error) {
	return _OptimismMintableERC721Factory.Contract.REMOTECHAINID(&_OptimismMintableERC721Factory.CallOpts)
}

// REMOTECHAINID is a free data retrieval call binding the contract method 0x7d1d0c5b.
//
// Solidity: function REMOTE_CHAIN_ID() view returns(uint256)
func (_OptimismMintableERC721Factory *OptimismMintableERC721FactoryCallerSession) REMOTECHAINID() (*big.Int, error) {
	return _OptimismMintableERC721Factory.Contract.REMOTECHAINID(&_OptimismMintableERC721Factory.CallOpts)
}

// IsOptimismMintableERC721 is a free data retrieval call binding the contract method 0x5572acae.
//
// Solidity: function isOptimismMintableERC721(address ) view returns(bool)
func (_OptimismMintableERC721Factory *OptimismMintableERC721FactoryCaller) IsOptimismMintableERC721(opts *bind.CallOpts, arg0 common.Address) (bool, error) {
	var out []interface{}
	err := _OptimismMintableERC721Factory.contract.Call(opts, &out, "isOptimismMintableERC721", arg0)

	if err != nil {
		return *new(bool), err
	}

	out0 := *abi.ConvertType(out[0], new(bool)).(*bool)

	return out0, err

}

// IsOptimismMintableERC721 is a free data retrieval call binding the contract method 0x5572acae.
//
// Solidity: function isOptimismMintableERC721(address ) view returns(bool)
func (_OptimismMintableERC721Factory *OptimismMintableERC721FactorySession) IsOptimismMintableERC721(arg0 common.Address) (bool, error) {
	return _OptimismMintableERC721Factory.Contract.IsOptimismMintableERC721(&_OptimismMintableERC721Factory.CallOpts, arg0)
}

// IsOptimismMintableERC721 is a free data retrieval call binding the contract method 0x5572acae.
//
// Solidity: function isOptimismMintableERC721(address ) view returns(bool)
func (_OptimismMintableERC721Factory *OptimismMintableERC721FactoryCallerSession) IsOptimismMintableERC721(arg0 common.Address) (bool, error) {
	return _OptimismMintableERC721Factory.Contract.IsOptimismMintableERC721(&_OptimismMintableERC721Factory.CallOpts, arg0)
}

// Version is a free data retrieval call binding the contract method 0x54fd4d50.
//
// Solidity: function version() view returns(string)
func (_OptimismMintableERC721Factory *OptimismMintableERC721FactoryCaller) Version(opts *bind.CallOpts) (string, error) {
	var out []interface{}
	err := _OptimismMintableERC721Factory.contract.Call(opts, &out, "version")

	if err != nil {
		return *new(string), err
	}

	out0 := *abi.ConvertType(out[0], new(string)).(*string)

	return out0, err

}

// Version is a free data retrieval call binding the contract method 0x54fd4d50.
//
// Solidity: function version() view returns(string)
func (_OptimismMintableERC721Factory *OptimismMintableERC721FactorySession) Version() (string, error) {
	return _OptimismMintableERC721Factory.Contract.Version(&_OptimismMintableERC721Factory.CallOpts)
}

// Version is a free data retrieval call binding the contract method 0x54fd4d50.
//
// Solidity: function version() view returns(string)
func (_OptimismMintableERC721Factory *OptimismMintableERC721FactoryCallerSession) Version() (string, error) {
	return _OptimismMintableERC721Factory.Contract.Version(&_OptimismMintableERC721Factory.CallOpts)
}

// CreateOptimismMintableERC721 is a paid mutator transaction binding the contract method 0xd97df652.
//
// Solidity: function createOptimismMintableERC721(address _remoteToken, string _name, string _symbol) returns(address)
func (_OptimismMintableERC721Factory *OptimismMintableERC721FactoryTransactor) CreateOptimismMintableERC721(opts *bind.TransactOpts, _remoteToken common.Address, _name string, _symbol string) (*types.Transaction, error) {
	return _OptimismMintableERC721Factory.contract.Transact(opts, "createOptimismMintableERC721", _remoteToken, _name, _symbol)
}

// CreateOptimismMintableERC721 is a paid mutator transaction binding the contract method 0xd97df652.
//
// Solidity: function createOptimismMintableERC721(address _remoteToken, string _name, string _symbol) returns(address)
func (_OptimismMintableERC721Factory *OptimismMintableERC721FactorySession) CreateOptimismMintableERC721(_remoteToken common.Address, _name string, _symbol string) (*types.Transaction, error) {
	return _OptimismMintableERC721Factory.Contract.CreateOptimismMintableERC721(&_OptimismMintableERC721Factory.TransactOpts, _remoteToken, _name, _symbol)
}

// CreateOptimismMintableERC721 is a paid mutator transaction binding the contract method 0xd97df652.
//
// Solidity: function createOptimismMintableERC721(address _remoteToken, string _name, string _symbol) returns(address)
func (_OptimismMintableERC721Factory *OptimismMintableERC721FactoryTransactorSession) CreateOptimismMintableERC721(_remoteToken common.Address, _name string, _symbol string) (*types.Transaction, error) {
	return _OptimismMintableERC721Factory.Contract.CreateOptimismMintableERC721(&_OptimismMintableERC721Factory.TransactOpts, _remoteToken, _name, _symbol)
}

// OptimismMintableERC721FactoryOptimismMintableERC721CreatedIterator is returned from FilterOptimismMintableERC721Created and is used to iterate over the raw logs and unpacked data for OptimismMintableERC721Created events raised by the OptimismMintableERC721Factory contract.
type OptimismMintableERC721FactoryOptimismMintableERC721CreatedIterator struct {
	Event *OptimismMintableERC721FactoryOptimismMintableERC721Created // Event containing the contract specifics and raw log

	contract *bind.BoundContract // Generic contract to use for unpacking event data
	event    string              // Event name to use for unpacking event data

	logs chan types.Log        // Log channel receiving the found contract events
	sub  ethereum.Subscription // Subscription for errors, completion and termination
	done bool                  // Whether the subscription completed delivering logs
	fail error                 // Occurred error to stop iteration
}

// Next advances the iterator to the subsequent event, returning whether there
// are any more events found. In case of a retrieval or parsing error, false is
// returned and Error() can be queried for the exact failure.
func (it *OptimismMintableERC721FactoryOptimismMintableERC721CreatedIterator) Next() bool {
	// If the iterator failed, stop iterating
	if it.fail != nil {
		return false
	}
	// If the iterator completed, deliver directly whatever's available
	if it.done {
		select {
		case log := <-it.logs:
			it.Event = new(OptimismMintableERC721FactoryOptimismMintableERC721Created)
			if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
				it.fail = err
				return false
			}
			it.Event.Raw = log
			return true

		default:
			return false
		}
	}
	// Iterator still in progress, wait for either a data or an error event
	select {
	case log := <-it.logs:
		it.Event = new(OptimismMintableERC721FactoryOptimismMintableERC721Created)
		if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
			it.fail = err
			return false
		}
		it.Event.Raw = log
		return true

	case err := <-it.sub.Err():
		it.done = true
		it.fail = err
		return it.Next()
	}
}

// Error returns any retrieval or parsing error occurred during filtering.
func (it *OptimismMintableERC721FactoryOptimismMintableERC721CreatedIterator) Error() error {
	return it.fail
}

// Close terminates the iteration process, releasing any pending underlying
// resources.
func (it *OptimismMintableERC721FactoryOptimismMintableERC721CreatedIterator) Close() error {
	it.sub.Unsubscribe()
	return nil
}

// OptimismMintableERC721FactoryOptimismMintableERC721Created represents a OptimismMintableERC721Created event raised by the OptimismMintableERC721Factory contract.
type OptimismMintableERC721FactoryOptimismMintableERC721Created struct {
	LocalToken  common.Address
	RemoteToken common.Address
	Deployer    common.Address
	Raw         types.Log // Blockchain specific contextual infos
}

// FilterOptimismMintableERC721Created is a free log retrieval operation binding the contract event 0xe72783bb8e0ca31286b85278da59684dd814df9762a52f0837f89edd1483b299.
//
// Solidity: event OptimismMintableERC721Created(address indexed localToken, address indexed remoteToken, address deployer)
func (_OptimismMintableERC721Factory *OptimismMintableERC721FactoryFilterer) FilterOptimismMintableERC721Created(opts *bind.FilterOpts, localToken []common.Address, remoteToken []common.Address) (*OptimismMintableERC721FactoryOptimismMintableERC721CreatedIterator, error) {

	var localTokenRule []interface{}
	for _, localTokenItem := range localToken {
		localTokenRule = append(localTokenRule, localTokenItem)
	}
	var remoteTokenRule []interface{}
	for _, remoteTokenItem := range remoteToken {
		remoteTokenRule = append(remoteTokenRule, remoteTokenItem)
	}

	logs, sub, err := _OptimismMintableERC721Factory.contract.FilterLogs(opts, "OptimismMintableERC721Created", localTokenRule, remoteTokenRule)
	if err != nil {
		return nil, err
	}
	return &OptimismMintableERC721FactoryOptimismMintableERC721CreatedIterator{contract: _OptimismMintableERC721Factory.contract, event: "OptimismMintableERC721Created", logs: logs, sub: sub}, nil
}

// WatchOptimismMintableERC721Created is a free log subscription operation binding the contract event 0xe72783bb8e0ca31286b85278da59684dd814df9762a52f0837f89edd1483b299.
//
// Solidity: event OptimismMintableERC721Created(address indexed localToken, address indexed remoteToken, address deployer)
func (_OptimismMintableERC721Factory *OptimismMintableERC721FactoryFilterer) WatchOptimismMintableERC721Created(opts *bind.WatchOpts, sink chan<- *OptimismMintableERC721FactoryOptimismMintableERC721Created, localToken []common.Address, remoteToken []common.Address) (event.Subscription, error) {

	var localTokenRule []interface{}
	for _, localTokenItem := range localToken {
		localTokenRule = append(localTokenRule, localTokenItem)
	}
	var remoteTokenRule []interface{}
	for _, remoteTokenItem := range remoteToken {
		remoteTokenRule = append(remoteTokenRule, remoteTokenItem)
	}

	logs, sub, err := _OptimismMintableERC721Factory.contract.WatchLogs(opts, "OptimismMintableERC721Created", localTokenRule, remoteTokenRule)
	if err != nil {
		return nil, err
	}
	return event.NewSubscription(func(quit <-chan struct{}) error {
		defer sub.Unsubscribe()
		for {
			select {
			case log := <-logs:
				// New log arrived, parse the event and forward to the user
				event := new(OptimismMintableERC721FactoryOptimismMintableERC721Created)
				if err := _OptimismMintableERC721Factory.contract.UnpackLog(event, "OptimismMintableERC721Created", log); err != nil {
					return err
				}
				event.Raw = log

				select {
				case sink <- event:
				case err := <-sub.Err():
					return err
				case <-quit:
					return nil
				}
			case err := <-sub.Err():
				return err
			case <-quit:
				return nil
			}
		}
	}), nil
}

// ParseOptimismMintableERC721Created is a log parse operation binding the contract event 0xe72783bb8e0ca31286b85278da59684dd814df9762a52f0837f89edd1483b299.
//
// Solidity: event OptimismMintableERC721Created(address indexed localToken, address indexed remoteToken, address deployer)
func (_OptimismMintableERC721Factory *OptimismMintableERC721FactoryFilterer) ParseOptimismMintableERC721Created(log types.Log) (*OptimismMintableERC721FactoryOptimismMintableERC721Created, error) {
	event := new(OptimismMintableERC721FactoryOptimismMintableERC721Created)
	if err := _OptimismMintableERC721Factory.contract.UnpackLog(event, "OptimismMintableERC721Created", log); err != nil {
		return nil, err
	}
	event.Raw = log
	return event, nil
}
