package wrapper

import (
	"github.com/ethereum/go-ethereum/common"
	"math/big"
	"testing"
)

func TestWhash(t *testing.T) {
	user := common.HexToAddress("0x9910048204119cCA216a2325A3e2fA05eD4977ef")
	coin := "ETH"
	value := big.NewInt(5e18)
	//ethers.keccak256(ethers.toUtf8Bytes("test transaction"));
	hash := common.HexToHash("0xb2015d93f463a4d67145ab45f7498d426fc39879059311b863b3586240974305")
	whash := withdrawalHash(user, coin, value, hash)
	expected := common.HexToHash("0x4939ac2eefe1c20d05fa0a319d8dd8fa891a333800a68c4644e7bdc203c18b3d")
	if whash != expected {
		t.Errorf("expected %s, got %s", expected.Hex(), whash.Hex())
	} else {
		t.Logf("success")
	}
}
