package exchain

import (
	"github.com/ethereum/go-ethereum/common"
	nebulav1 "github.com/exchain/go-exchain/exchain/protocol/gen/go/nebula/v1"
)

type Signer func(data []byte) ([]byte, error)

type Engine interface {
	Start() error
	NewPayload(params PayloadParams) (ExecutionResult, error)
	ProcessPayload(block *nebulav1.Block) error
}

type PayloadParams struct {
	ParentRoot   *common.Hash
	Timestamp    uint64
	Proposer     common.Address
	Transactions nebulav1.TransactionList
	Signer       Signer
}

type ExecutionResult struct {
	ParentRoot common.Hash
	Payload    *nebulav1.Block
}

type mockEngine struct{}

func (m mockEngine) Start() error {
	return nil
}

func (m mockEngine) NewPayload(params PayloadParams) (ExecutionResult, error) {
	return ExecutionResult{}, nil
}

func (m mockEngine) ProcessPayload(block *nebulav1.Block) error {
	return nil
}

func NewEngine(database Database) Engine {
	return &mockEngine{}
}
