package engine

import (
	"time"

	"github.com/exchain/go-exchain/op-service/eth"
)

type BuildStartedEvent struct {
	Info eth.PayloadInfo

	BuildStarted time.Time

	Parent eth.L2BlockRef

	// if payload should be promoted to (local) safe (must also be pending safe, see DerivedFrom)
	Concluding bool
	// payload is promoted to pending-safe if non-zero
	DerivedFrom eth.L1BlockRef
	Envelope    *eth.ExecutionPayloadEnvelope
}

func (ev BuildStartedEvent) String() string {
	return "build-started"
}

func (eq *EngDeriver) onBuildStarted(ev BuildStartedEvent) {
	// If a (pending) safe block, immediately seal the block
	if ev.DerivedFrom != (eth.L1BlockRef{}) {
		eq.emitter.Emit(BuildSealEvent{
			Info:         ev.Info,
			BuildStarted: ev.BuildStarted,
			Concluding:   ev.Concluding,
			DerivedFrom:  ev.DerivedFrom,
			Envelope:     ev.Envelope,
		})
	}
}
