package main

import (
	"log"

	"github.com/exchain/process/api/handlers"
	"github.com/exchain/process/api/router"
	"github.com/exchain/process/engine"
)

func main() {
	eg := engine.GetEngine()
	// 创建订单处理器
	orderHandler := handlers.NewOrderHandler(eg)
	// 设置路由
	r := router.SetupRouter(orderHandler)
	// 启动服务器
	if err := r.Run(":8080"); err != nil {
		log.Fatalf("Failed to start server: %v", err)
	}
}
