package router

import (
	"github.com/exchain/process/api/handlers"

	"github.com/gin-gonic/gin"
)

// SetupRouter 配置API路由
func SetupRouter(orderHandler *handlers.OrderHandler) *gin.Engine {
	r := gin.Default()

	// 订单相关路由
	orderGroup := r.Group("/api/v1/orders")
	{
		orderGroup.POST("/limit", orderHandler.PlaceLimitOrder)   // 限价单
		orderGroup.POST("/market", orderHandler.PlaceMarketOrder) // 市价单
		orderGroup.POST("/cancel", orderHandler.CancelOrder)      // 取消订单
	}

	// 订单簿相关路由
	r.GET("/api/v1/orderbook", orderHandler.GetOrderBookDepth) // 获取订单簿深度

	return r
}
