package database

import (
	"github.com/exchain/process/leveldb"
	"github.com/exchain/process/orderbook"
)

type OrderObject struct {
	db    *leveldb.Database
	Order *orderbook.Order
}

func NewOrderObject(db *leveldb.Database, order *orderbook.Order) *OrderObject {
	return &OrderObject{
		db:    db,
		Order: order,
	}
}

func (o *OrderObject) Save() error {
	data, err := o.Order.Dump()
	if err != nil {
		return err
	}
	return o.db.Put([]byte(o.Order.Id), data)
}

func (o *OrderObject) Load() error {
	b, err := o.db.Get([]byte(o.Order.Id))
	if err != nil {
		return err
	}
	o.Order.Load(b)
	return nil
}
