package engine

import (
	"errors"

	"github.com/exchain/process/types"

	"github.com/ethereum/go-ethereum/common"
	"github.com/holiman/uint256"
)

func (e *Engine) PorcessSignProxy(user common.Address, proxy common.Address, nonce uint64) (err error) {
	userObject, err := e.db.GetOrNewAccountObject(user)
	if err != nil {
		return
	}
	if userObject == nil {
		return errors.New("invalid user")
	}
	userObject.SetProxy(proxy)
	err = e.db.SaveAccountObject(userObject)
	if err != nil {
		return
	}

	tx := &types.SignProxyTx{
		Tx: types.Tx{
			Time:   nonce,
			User:   user,
			Action: types.OrderActionSignProxy,
			Nonce:  nonce,
		},
		ProxyAddress: proxy,
	}
	e.AddToQueue(tx)
	return
}

func (e *Engine) ProcessDepositBalance(user common.Address, coin types.Coin, amount *uint256.Int) (err error) {
	userObject, err := e.db.GetOrNewAccountObject(user)
	if err != nil {
		return
	}
	if userObject == nil {
		return errors.New("invalid user")
	}
	userObject.AddBalance(coin, amount, false)
	err = e.db.SaveAccountObject(userObject)
	if err != nil {
		return
	}
	return
}
