package orderbook

import (
	"encoding/json"
	"testing"

	"github.com/ethereum/go-ethereum/common"
	"github.com/holiman/uint256"
)

func TestNewOrder(t *testing.T) {
	t.Log(NewOrder("order-1", common.HexToAddress("0x0000000000000000000000000000000000000000"), Sell, uint256.NewInt(100), uint256.NewInt(100), 1234567890))
}

func TestOrderJSON(t *testing.T) {
	data := []*Order{
		NewOrder("one", common.HexToAddress("0x0000000000000000000000000000000000000000"), Buy, uint256.NewInt(11), uint256.NewInt(110), 1234567890),
		NewOrder("two", common.HexToAddress("0x0000000000000000000000000000000000000000"), Buy, uint256.NewInt(22), uint256.NewInt(220), 1234567890),
		NewOrder("three", common.HexToAddress("0x0000000000000000000000000000000000000000"), Sell, uint256.NewInt(33), uint256.NewInt(330), 1234567890),
		NewOrder("four", common.HexToAddress("0x0000000000000000000000000000000000000000"), Sell, uint256.NewInt(44), uint256.NewInt(440), 1234567890),
	}

	result, _ := json.Marshal(data)
	t.Log(string(result))

	data = []*Order{}

	_ = json.Unmarshal(result, &data)
	t.Log(data)

	err := json.Unmarshal([]byte(`[{"side":"fake"}]`), &data)
	if err == nil {
		t.Fatal("can unmarshal unsupported value")
	}
}
