package utils_test

import (
	"bytes"
	"encoding/gob"
	"testing"
	"time"

	"github.com/ethereum/go-ethereum/common"
	"github.com/holiman/uint256"
)

func TestGob(t *testing.T) {

	type Order struct {
		Creator   common.Address
		Id        string
		Timestamp time.Time
		Quantity  *uint256.Int
		Price     *uint256.Int
		Filled    *uint256.Int
	}

	var buf bytes.Buffer

	o := &Order{
		Creator:   common.HexToAddress("0x0000000000000000000000000000000000000001"),
		Id:        "order-1",
		Timestamp: time.Now(),
		Quantity:  uint256.NewInt(10),
		Price:     uint256.NewInt(1),
		Filled:    uint256.NewInt(0),
	}

	enc := gob.NewEncoder(&buf)
	err := enc.Encode(o)
	if err != nil {
		t.Fatal(err)
	}

	dec := gob.NewDecoder(&buf)
	b := &Order{
	}
	err = dec.Decode(&b)
	if err != nil {
		t.Fatal(err)
	}
	t.Log("111", b.Quantity)
}
