package utils

import (
	"time"

	"github.com/bwmarrin/snowflake"
)

var node *snowflake.Node

func init() {
	node, _ = snowflake.NewNode(1)
}

func GenOrderID() string {
	return node.Generate().String()
}

func NonceToTime(nonce uint64) time.Time {
	return time.UnixMilli(int64(nonce))
}
