package orderbook

import (
	"encoding/json"
	"reflect"
)

// Side 订单方向
type Side int

// Sell (卖出/卖单) 或 Buy (买入/买单)
const (
	Sell Side = iota
	Buy
)

// String 实现fmt.Stringer接口
func (s Side) String() string {
	if s == Buy {
		return "buy"
	}

	return "sell"
}

// MarshalJSON 实现json.Marshaler接口
func (s Side) MarshalJSON() ([]byte, error) {
	return []byte(`"` + s.String() + `"`), nil
}

// UnmarshalJSON 实现json.Unmarshaler接口
func (s *Side) UnmarshalJSON(data []byte) error {
	switch string(data) {
	case `"buy"`:
		*s = Buy
	case `"sell"`:
		*s = Sell
	default:
		return &json.UnsupportedValueError{
			Value: reflect.New(reflect.TypeOf(data)),
			Str:   string(data),
		}
	}

	return nil
}
