# blockscout explorer for cmp20

## how to use
```shell
# start
make start
# stop
make stop
# clean data
make clean && make start
```


## contract verify with hardhat

add `network` and `etherscan` config in **hardhat.config.js** 
```js
    etherscan: {
		apiKey: {
			'achain': 'empty',
		},
		customChains: [
			{
				network: "achain",
				chainId: 100,
				urls: {
					apiURL: "https://scan.cmp20.bitheart.org/api",
					browserURL: "https://scan.cmp20.bitheart.org"
				}
			}
		]
	},
	networks: {
		achain: {
			url: "https://rpc.cmp20.bitheart.org",
			accounts: [privateKey],
		},
	},
```
and then run command 
```shell
npx hardhat verify --network achain *contractAddress* [*construct params*]
```
