require("@nomicfoundation/hardhat-toolbox");
require("@nomicfoundation/hardhat-ethers");
require("dotenv").config()


// This is a sample Hardhat task. To learn how to create your own go to
// https://hardhat.org/guides/create-task.html
task("accounts", "Prints the list of accounts", async (taskArgs, hre) => {
  const accounts = await hre.ethers.getSigners()

  for (const account of accounts) {
    console.log(account.address)
  }
})

// Define mnemonic for accounts.
let mnemonic = process.env.MNEMONIC
if (!mnemonic) {
  // NOTE: this fallback is for development only!
  // When using other networks, set the secret in .env.
  // DO NOT commit or share your mnemonic with others!
  mnemonic = "test test test test test test test test test test test test"
}

// contract owner: 0x9f8fb0488dE145E7467FDeD872098e1115d6ea4C
// contract admin: 0x9f8fb0488dE145E7467FDeD872098e1115d6ea4C
// const fs = require('fs');
// const mnemonic = fs.readFileSync(".secret").toString().trim();
const privateKey = process.env.DEPLOY_PRIVATE_KEY
const accounts = { mnemonic }


/** @type import('hardhat/config').HardhatUserConfig */
module.exports = {
	solidity: {
		evmVersion: "istanbul",
		compilers: [
			{
				version: "0.8.26",
				settings: {
					evmVersion: "cancun",
					optimizer: {
						enabled: true,
						runs: 200,
					},
				},
			},
			{
				version: "0.8.24",
				settings: {
					optimizer: {
						enabled: true,
						runs: 200,
					},
				},
			},
			{
				version: "0.8.20",
				settings: {
					optimizer: {
						enabled: true,
						runs: 200,
					},
				},
			},
			{
				version: "0.8.10",
				settings: {
					optimizer: {
						enabled: true,
						runs: 200,
					},
				},
			},
		],
	},
	sourcify: {
		enabled: false
	},
	etherscan: {
		apiKey: {
			'achain': 'empty',
			'hole': 'empty',
			'movadev': 'empty',
			'mova': 'empty',
			'bsc':'AVZIFYCHUFHPG9FDKNMHEWJ1VAW1H5U66T'
		},
		customChains: [
			{
				network: "achain",
				chainId: 100,
				urls: {
					apiURL: "https://scan.cmp20.bitheart.org/api",
					browserURL: "https://scan.cmp20.bitheart.org"
				}
			},
			{
				network: "hole",
				chainId: 6174,
				urls: {
					apiURL: "https://holescan.bitheart.org/api",
					browserURL: "https://holescan.bitheart.org"
				}
			},
			{
				network: "movadev",
				chainId: 8891,
				urls: {
					apiURL: "https://scan.mova.bitheart.org/api",
					browserURL: "https://scan.mova.bitheart.org"
				}
			},
			{
				network: "mova",
				chainId: 10323,
				urls: {
					apiURL: "https://scan.mars.movachain.com/api",
					browserURL: "https://scan.mars.movachain.com"
				}
			}
		]
	},
	networks: {
		hardhat: {
			accounts: [{ privateKey, balance: "10000000000000000000000" }], // Example balance
			gas: 10000000,
			gasPrice: 10000000000
		},
		hole: {
			url: "https://rpc.hole.bitheart.org",
			accounts: [privateKey]
		},
		movadev: {
			url: "https://rpc.mova.bitheart.org",
			accounts: [privateKey]
		},
		mova: {
			url: "https://mars.rpc.movachain.com",
			accounts: [privateKey]
		}
	},
};
