const { ContractFactory } = require("ethers");
const hre = require("hardhat");
const {ethers} = require("hardhat");

async function deploy() {
    [owner] = await ethers.getSigners();
    // Deploy the contract
    const factory =  await hre.ethers.getContractFactory(
        "TestAbi"
    );
    const contract = await factory.deploy(owner.address);
    await contract.waitForDeployment();
    const depAddr = await contract.getAddress();
    console.log("Contract deployed for mova at:", depAddr);

    const params = {
        toChainID: 2,
        receiver: "0x000000000000000000000000000000000000dead",
        token: "0x000000000000000000000000000000000000beef",
        amount: hre.ethers.parseEther("10"),
        outId: 1,
        fromChainID: 1,
        sender: "0x000000000000000000000000000000000000cafe",
        sendToken: "0x000000000000000000000000000000000000babe",
        sendAmount: hre.ethers.parseEther("10"),
        signature: "0x000000000000000000000000000000000000babe000000000000000000000000",
    };
    const tx = await contract.getSubmitData(params);
    console.log("Computed hash:", tx);
}
async function initForMovaChain(bridge) {
    await addValidators(bridge, initialValidators);
}

// Define the script
async function main() {
    await deploy();
}

// Run the script
main().catch((error) => {
    console.error("Error:", error);
});