const { ContractFactory } = require("ethers");
const hre = require("hardhat");


async function forceRevert() {
    // 部署合约
    const factory = await hre.ethers.getContractFactory("RevertContract");
    const contract = await factory.deploy();
    await contract.waitForDeployment();
    const contractAddress = await contract.getAddress();
    console.log("Contract deployed at:", contractAddress);
    return


    const signer = new hre.ethers.Wallet(process.env.DEPLOY_PRIVATE_KEY, hre.ethers.provider);
    const transferAmount = hre.ethers.parseEther("0.0005"); // 小于 1 ETH

    var nonce = await hre.ethers.provider.getTransactionCount(signer.address)
    const chainid = await hre.ethers.provider.getNetwork().then(network => network.chainId);


    // Encode the function call
    const abi = ["function sendViaTransfer(address payable _to, uint256 _amount)"];
    const iface = new hre.ethers.Interface(abi);
    const data = iface.encodeFunctionData("sendViaTransfer", ['0xAD4143Df8Fe9E31B1C4318e8dE555872085f481d', transferAmount]);

    // 签名交易
    const signedTx = await signer.signTransaction({
        type: 0,
        chainId: chainid,
        nonce: nonce,
        to: contractAddress,
        data: data,
        value: transferAmount,
        gasLimit: 1000000, // 设置 gas 限制
        gasPrice: hre.ethers.parseUnits("1", "gwei"), // 设置 gas 价格
    });

    // 发送交易
    const txResponse = await hre.ethers.provider.broadcastTransaction(signedTx);
    console.log("Transaction sent:", txResponse.hash);
}

// Define the script
async function main() {
    await forceRevert()
}

// Run the script
main().catch((error) => {
    console.error("Error:", error);
});