const { ContractFactory } = require("ethers");
const hre = require("hardhat");

async function getTokenInfo(contract) {
    const name = await contract.name();
    console.log("Token Name:", name);
    const symbol = await contract.symbol();
    const totalSupply = await contract.totalSupply();

    console.log("Token Symbol:", symbol);
    console.log("Total Supply:", totalSupply.toString());
}

// Define the script
async function main() {

    // Deploy the contract
    const factory =  await hre.ethers.getContractFactory(
        "TestToken"
    );
    {
        const contract = await factory.deploy("TestTokenAlice", "TTA");
        await contract.waitForDeployment();
        const depAddr = await contract.getAddress();
        console.log("TTA deployed at:", depAddr);
        await getTokenInfo(contract);

    }
    {
        const contract = await factory.deploy("TestTokenBob", "TTB");
        await contract.waitForDeployment();
        const depAddr = await contract.getAddress();
        console.log("TTB deployed at:", depAddr);
        await getTokenInfo(contract);

    }
    {
        const contract = await factory.deploy("TestTokenCharlie", "TTC");
        await contract.waitForDeployment();
        const depAddr = await contract.getAddress();
        console.log("TTC deployed at:", depAddr);
        await getTokenInfo(contract);

    }
    {
        const contract = await factory.deploy("TestTokenDoody", "TTD");
        await contract.waitForDeployment();
        const depAddr = await contract.getAddress();
        console.log("TTD deployed at:", depAddr);
        await getTokenInfo(contract);

    }
}

// Run the script
main().catch((error) => {
    console.error("Error:", error);
});