// SPDX-License-Identifier: MIT
pragma solidity ^0.8.20;

contract InternalTransfer {
    function sendViaTransfer(address payable _to, uint256 _amount) public payable {
        _to.transfer(_amount);
    }

    function sendViaSend(address payable _to, uint256 _amount) public payable returns (bool) {
        bool sent = _to.send(_amount);
        require(sent, "Send failed");
        return sent;
    }

    function sendViaCall(address payable _to, uint256 _amount) public payable returns (bool) {
        (bool success, ) = _to.call{value: _amount}("");
        require(success, "Call failed");
        return success;
    }
    receive() external payable {}
}