const { ContractFactory } = require("ethers");
const hre = require("hardhat");

async function getTokenInfo(contract) {
    const name = await contract.name();
    console.log("Token Name:", name);
    const symbol = await contract.symbol();
    const totalSupply = await contract.totalSupply();

    console.log("Token Symbol:", symbol);
    console.log("Total Supply:", totalSupply.toString());
}

// Define the script
async function main() {

    // Deploy the contract
    const factory =  await hre.ethers.getContractFactory(
        "PublicToken"
    );
    // const contract = await factory.deploy({ value: hre.ethers.parseEther("0.0008") });
    const contract = await factory.deploy();
    await contract.waitForDeployment();
    const depAddr = await contract.getAddress();
    console.log("Contract deployed at:", depAddr);
    await getTokenInfo(contract);
    // const minttx = await contract.mint('0x88395111AB1586a4030dAC62a183542762929bbC', 10000);
    // console.log("mint tx:", minttx.hash);


}

// Run the script
main().catch((error) => {
    console.error("Error:", error);
});