const { ContractFactory } = require("ethers");
const hre = require("hardhat");

// Define the script
async function main() {

    // Deploy the contract
    const factory =  await hre.ethers.getContractFactory(
        "WMDD"
    );
    const contract = await factory.deploy();
    await contract.waitForDeployment();
    const depAddr = await contract.getAddress();
    console.log("Contract deployed at:", depAddr);
}

// Run the script
main().catch((error) => {
    console.error("Error:", error);
});